/*      @(#)if_ae6.c UniPlus VVV.2.1.4       */

/*
 * (C) 1986 Apple Computer Co. 
 *
 */
#undef HOWFAR
#define	NAE6	6

#if	NAE6 > 0
#include "sys/types.h"
#include "sys/param.h"
#include "sys/uconfig.h"
#include "sys/sysmacros.h"
#include "sys/reg.h"
#include "sys/mmu.h"
#include "sys/page.h"
#include "sys/systm.h"
#include "sys/mbuf.h"
#include "sys/socket.h"
#include "sys/ioctl.h"
#include "sys/errno.h"

#include "net/if.h"
#include "net/route.h"
#include "net/netisr.h"

#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/in_var.h"
#include "netinet/ip.h"
#include "netinet/ip_var.h"
#include "netinet/if_ether.h"
#include "vaxuba/ubavar.h"
#include "sys/if_ae6.h"

#ifdef HOWFAR
#include <sys/debug.h>
#include <sys/time.h>
#else

#define	dprintf	if(ae6_debug)printf
#endif

#ifndef ae6count
#define AE6COUNT 1
int ae6count = AE6COUNT;
int ae6addr[NAE6] = {9, 10, 11, 12, 13, 14};
#endif

int	ae6_debug = 0;

/*
 * Ae6 routine declarations.
 */
int	ae6_probe(), ae6_init(), ae6_attach(), ae6_output(), ae6_ioctl(),
    	ae6_intr(), ae6_rint(), ae6_tint(), ae6_timeout();
struct 	mbuf *ae6_get();
u8 	get_boundary_page(), get_current_page();

/*
 * Ae6 global structure declarations.
 */
struct	uba_device *ae6info[NAE6];
struct	uba_driver ae6driver = {
	ae6_probe, ae6_attach, (u_short *) 0, ae6info
};
static 	
struct 	ae6 ae6[NAE6];
u8 	ae6_mar[8] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

/*
 * Ae6 external structure references.
 */
extern 
struct 	ifnet loif;

/*
 * Prove for device.
 */
static ae6_probe(ui)
     struct uba_device *ui;
{
	struct ae6 *ae6p = &ae6[ui->ui_unit];

	if (ui->ui_unit < ae6count) {
		ae6_map(ui);
		if (iocheck((caddr_t) &ae6p->ae6_cmd->ae6_csr) == 0) {
			ae6_unmap(ui);
			return (0);
		}
		else
			return (1);
	}
	else
		return (0);
}

/*
 * Set up the control, ram and rom pointers for the ethernet board.
 */

static ae6_map(ui)
	struct uba_device *ui;
{
	struct ae6 *ae6p = &ae6[ui->ui_unit];

	ae6p->ae6_base = (char *)(AE6_BASE(ae6addr[ui->ui_unit]) + RAM);
	ae6p->ae6_cmd = (struct ae6_regs *)(AE6_BASE(ae6addr[ui->ui_unit]) + CTRL);
	ae6p->ae6_rom = (char *)(AE6_BASE(ae6addr[ui->ui_unit]) + ROM);
}

/*
 * Zero the control, ram and rom pointers for the ethernet board.
 */
static ae6_unmap(ui)
	struct uba_device *ui;
{
	struct ae6 *ae6p = &ae6[ui->ui_unit];

	ae6p->ae6_base = 0;
	ae6p->ae6_cmd = 0;
	ae6p->ae6_rom = 0;
}

/*
 * Interface exists: make it available by inializing the network visible
 * interface structure.  The system will initalize the interface when it is
 * ready to accept packets.
 */
static ae6_attach(ui)
	struct uba_device *ui;
{
	register struct ifnet *ifp = &ae6[ui->ui_unit].ae6_if;

	ifp->if_unit = ui->ui_unit;
	ifp->if_name = "ae";
	ifp->if_mtu = ETHERMTU;

	ifp->if_init = ae6_init;
	ifp->if_ioctl = ae6_ioctl;
	ifp->if_output = ae6_output;
	ifp->if_flags = IFF_BROADCAST;
	if_attach(ifp);
}

/*
 * Initalize the hardware.
 */
static ae6_init(unit)
     int	unit;
{
	register int i;
	register struct ae6 *ae6p = &ae6[unit];
	register struct ae6_regs *rp = ae6p->ae6_cmd;
	struct ifnet *ifp = &ae6p->ae6_if;
	register struct sockaddr_in *sin;
	int s;

	/* not yet, if address still unknown */
	if (ifp->if_addrlist == (struct ifaddr *)0)
		return;

#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_init:  ", time.tv_sec));
#else
	dprintf("ae6_init: ");
#endif
	s = splimp();
	ae6p->ae6_oactive = 0;
	/*
	 * Initialize the NIC as specified in board documentation. 
	 */
	rp->ae6_csr = CR_STP;
	rp->ae6_rbcr0 = 0;
	rp->ae6_rbcr1 = 0;
	/*
	 * Loop until the interrupt status register indicates that the board
	 * has been reset. 
	 */
        for (i = 0; i < 100; i++)
		if (rp->ae6_isr & ISR_RST)
			break;
	if ((rp->ae6_isr & ISR_RST) == 0) {
		splx(s);
		ifp->if_flags &=  ~IFF_RUNNING;
		printf("ae%d:  init failed\n", unit);
		return;
	}
	rp->ae6_dcr = DCR_FT_2 | DCR_BMS | DCR_WTS;
	rp->ae6_rcr =  RCR_AM | RCR_AB;
	rp->ae6_tcr = TCR_LOO_EXT;
	rp->ae6_pstart = RECV_START;
	/*
	 * Point Pstop to the first byte of the page outside the receive
	 * ring. 
	 */
	rp->ae6_pstop = RECV_STOP + 1;

	/*
	 * Set the boundary page to be the one "behind" RECV_START 
	 */
	rp->ae6_bnry = RECV_STOP;
	rp->ae6_isr = ISR_ALL;

	/*
	 * Get the six bytes of ethernet address from ROM, into the enaddr
	 * structure in arpcom.
	 */
	if(slot_ether_addr(ae6p->ae6_rom, &ae6p->ae6_enaddr) == -1) {
		splx(s);
		printf("ae%d:  ethernet address not found\n", unit);
		return;
	}

	/*
	 * Set the csr to point to page 1 of registers 
	 */
	rp->ae6_csr = CR_PS1 | CR_STP;
	rp->ae6_curr = RECV_START;

	/*
	 * Set up the page address registers from the arpcom structure.
	 */
	rp->ae6_par0 = ae6p->ae6_enaddr.ether_addr_octet[0];
	rp->ae6_par1 = ae6p->ae6_enaddr.ether_addr_octet[1];
	rp->ae6_par2 = ae6p->ae6_enaddr.ether_addr_octet[2];
	rp->ae6_par3 = ae6p->ae6_enaddr.ether_addr_octet[3];
	rp->ae6_par4 = ae6p->ae6_enaddr.ether_addr_octet[4];
	rp->ae6_par5 = ae6p->ae6_enaddr.ether_addr_octet[5];
#ifdef HOWFAR
        TRACE(ae6_debug, (" enaddr 02 60 8c 0x%x 0x%x 0x%x\n",
			  ae6p->ae6_enaddr.ether_addr_octet[3],
			  ae6p->ae6_enaddr.ether_addr_octet[4],
			  ae6p->ae6_enaddr.ether_addr_octet[5]));
#else
	dprintf(" 02 60 8c %x %x %x enaddr\n", 
		ae6p->ae6_enaddr.ether_addr_octet[3],
		ae6p->ae6_enaddr.ether_addr_octet[4],
		ae6p->ae6_enaddr.ether_addr_octet[5]);
#endif
	/*
	 * Set up the Multicast address as accept all. 
	 */
	rp->ae6_mar0 = ae6_mar[0];
	rp->ae6_mar1 = ae6_mar[1];
	rp->ae6_mar2 = ae6_mar[2];
	rp->ae6_mar3 = ae6_mar[3];
	rp->ae6_mar4 = ae6_mar[4];
 	rp->ae6_mar5 = ae6_mar[5];
	rp->ae6_mar6 = ae6_mar[6];
	rp->ae6_mar7 = ae6_mar[7];

	rp->ae6_csr = CR_STP;

	/*
	 *	Set up VIA interrupt handler for this slot
	 */
	viamkslotintr(unit + SLOT_LO, ae6_intr, 1);

	/*
	 * Enable interrupts
	 */
	rp->ae6_imr = 0x1f;
	rp->ae6_csr = CR_STA;
	rp->ae6_tcr = TCR_LOO_NON;

	ifp->if_flags |=  IFF_RUNNING;
	if (ifp->if_snd.ifq_head)
		ae6_start(unit);
	splx(s);
}

ae6_ovrecover(unit)
    int unit;
{
	register struct ae6 *ae6p = &ae6[unit];
	register struct ae6_regs *rp = ae6p->ae6_cmd;
	register int i;
	struct ifnet *ifp = &ae6p->ae6_if;
	int s = splimp();

	ae6p->ae6_oactive = 0;
	/*
	 * Reset the NIC as specified in board documentation in the case
	 * of an overflow warning interrupt. 
	 */
	rp->ae6_csr = CR_STP;
	/*
	 * Try to remove packets from the receive buffer ring.
	 */
	ae6_rintr(ae6p);

	rp->ae6_rbcr0 = 0;
	rp->ae6_rbcr1 = 0;
	/*
	 * Loop until the interrupt status register indicates that the board
	 * has been reset. 
	 */
        for (i = 0; i < 100; i++)
		if (rp->ae6_isr & ISR_RST)
			break;
	if ((rp->ae6_isr & ISR_RST) == 0) {
	        splx(s);
		ifp->if_flags &=  ~IFF_RUNNING;
		printf("ae%d:  overflow NIC reset failed\n", unit);
		return;
	}
	rp->ae6_tcr = TCR_LOO_EXT;
	rp->ae6_csr = CR_STA;
	rp->ae6_tcr = TCR_LOO_NON;
	splx(s);
}

/*
 * Start a packet transmission.
 */
static ae6_start(unit)
     int	unit;
{
	int len;
	register struct ae6 *ae6p = &ae6[unit];
	register struct ae6_regs *rp = ae6p->ae6_cmd;
	struct mbuf *m;

	if (ae6p->ae6_oactive)
		goto restart;

	IF_DEQUEUE(&ae6p->ae6_if.if_snd, m);
	if (m == 0) {
		ae6p->ae6_oactive = 0;
		return;
	}
	len = ae6_put(m, ae6p->ae6_base);
	if (len < ETHERMIN + sizeof(struct ether_header)) 
		len = ETHERMIN + sizeof(struct ether_header);
	/*
	 * Set the packet length and the transmit start address to the
	 * requested values. 
	 */
restart:
	rp->ae6_tbcr1 = (len >> 8) & 0x7;
	rp->ae6_tbcr0 = (len & 0xff);
	rp->ae6_tpsr = 0;
	/*
	 * ... on your mark, get set, go ... 
	 */
	rp->ae6_csr = CR_TXP | CR_STA;
	ae6p->ae6_oactive = 1;
	/*
	 * Schedule a timeout to guard against trasmitter freeze-up, and
	 * missed interrupts.  This timeout is cancelled when we get the
	 * transmit interrupt for the outgoing packet.  
	 */
	ae6p->ae6_flags |= AE6_TOPENDING;
	timeout(ae6_timeout, unit, 50 << 2);
}

static ae6_timeout(unit)
     int unit;
{
	register struct ae6 *ae6p = &ae6[unit];

	ae6p->ae6_flags &= ~AE6_TOPENDING;
	printf("ae%d transmitter frozen -- resetting\n", unit);
	ae6_init(unit);
}

static ae6_output(ifp, m0, dst)
	struct ifnet   *ifp;
	struct mbuf    *m0;
	struct sockaddr *dst;
{
	int type, s, error;
	struct ether_addr edst;
	struct in_addr	idst;
	register struct ae6 *ae6p = &ae6[ifp->if_unit];
	register struct mbuf *m = m0;
	struct mbuf    *mcopy = (struct mbuf *) 0;
	register struct ether_header *e;

	if ((ifp->if_flags & (IFF_UP|IFF_RUNNING)) != (IFF_UP|IFF_RUNNING)) {
		error = ENETDOWN;
		goto bad;
	}
	switch (dst->sa_family) {
#ifdef INET
	case AF_INET:
		idst = ((struct sockaddr_in *) dst)->sin_addr;
		if (!arpresolve(&ae6p->ae6_ac, m, &idst, &edst))
			return (0);	/* if not yet resolved */
		type = ETHERPUP_IPTYPE;
		if (in_lnaof(idst) == INADDR_ANY)
			mcopy = m_copy(m, 0, (int) M_COPYALL);
		goto gottype;
#endif
	case AF_UNSPEC:
		e = (struct ether_header *)dst->sa_data;
		edst = e->ether_dhost;
		type = e->ether_type;
		goto gottype;

	default:
		printf("ae%d: can't handle af%d\n", ifp->if_unit,
		       dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottype:
	/*
	 * Add local net header.  If no space in first mbuf, allocate
	 * another. 
	 */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof(struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof(struct ether_header);
	} else {
		m->m_off -= sizeof(struct ether_header);
		m->m_len += sizeof(struct ether_header);
	}
	e = mtod(m, struct ether_header *);
	e->ether_type = htons((u_short) type);
	e->ether_dhost = edst;
	e->ether_shost = ae6p->ae6_enaddr;
#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_output:  type 0x%x\n", time.tv_sec,
	                  e->ether_type));
#else
	dprintf("ae6_output: %x %x %x %x %x %x src, %x %x %x %x %x %x dst, %x type\n",
		e->ether_shost.ether_addr_octet[0],
		e->ether_shost.ether_addr_octet[1],
		e->ether_shost.ether_addr_octet[2],
		e->ether_shost.ether_addr_octet[3],
		e->ether_shost.ether_addr_octet[4],
		e->ether_shost.ether_addr_octet[5],
		e->ether_dhost.ether_addr_octet[0],
		e->ether_dhost.ether_addr_octet[1],
		e->ether_dhost.ether_addr_octet[2],
		e->ether_dhost.ether_addr_octet[3],
		e->ether_dhost.ether_addr_octet[4],
		e->ether_dhost.ether_addr_octet[5],
		e->ether_type);
#endif
	/*
	 * Queue message on interface, and start output if interface not yet
	 * active. 
	 */
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	if (ae6p->ae6_oactive == 0)
		ae6_start(ifp->if_unit);
	splx(s);
	return (mcopy ? looutput(&loif, mcopy, dst) : 0);

bad:
	m_freem(m0);
	if (mcopy)
		m_freem(mcopy);
	return (error);
}

/*
 * ae6 interrupt handlers 
 */

static ae6_xintr(unit)
     int	unit;
{
	register struct ae6 *ae6p = &ae6[unit];
	struct ae6_regs *rp = ae6p->ae6_cmd;
	int s;

#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_xintr tsr 0x%x", time.tv_sec,
	                  rp->ae6_tsr));
#else
	dprintf("ae6_xintr: tsr %x\n", rp->ae6_tsr);
#endif
	if (ae6p->ae6_oactive == 0)
		return;

	ae6p->ae6_if.if_opackets++;
	if(ae6p->ae6_flags & AE6_TOPENDING) {
		untimeout(ae6_timeout, unit);
		ae6p->ae6_flags &= ~AE6_TOPENDING;
	}
	ae6p->ae6_oactive = 0;
	s = splimp();
	if (ae6p->ae6_if.if_snd.ifq_head)
		ae6_start(unit);
	splx(s);
}


static ae6_rintr(unit)
     int	unit;
{
	register struct ae6 *ae6p = &ae6[unit];
	struct ae6_regs *rp = ae6p->ae6_cmd;
	u8 gc, gb;			/* Current and boundary pages */

#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_rintr isr 0x%x", time.tv_sec,
	                  rp->ae6_rsr));
#else
	dprintf("ae6_rintr: rsr %x ", rp->ae6_isr);
#endif

	/*
	 * Check for a received packet 
	 */
next:
	gb = get_boundary_page(ae6p);
	gc = get_current_page(ae6p);

	/* If there is one, then get it. */
	if (gb != gc) {
		ae6_rpkt(ae6p);
		update_boundary_page(ae6p);
		goto next;
	}
}

/*ARGSUSED*/
static ae6_intr(args)
     struct args *args;
{
	int unit = args->a_dev - SLOT_LO;
	register struct ae6 *ae6p = &ae6[unit];
	register struct ae6_regs *rp = ae6p->ae6_cmd;
	struct ifnet *ifp = &ae6p->ae6_if;
	register int isr, sr = 0, s;

	if (unit >= NAE6) {
		printf("ae6_intr:  interrupt from slot %d\n", unit);
		panic("ae6_intr");
		/*NOTREACHED*/
	}

	/* 
	 * Read and reset interrupt status register 
	 */
	isr = rp->ae6_isr;
	rp->ae6_isr = ISR_ALL;

	if(isr == 0) {
		printf("ae%d spurious interrupt\n", unit);
		return;
	}
#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_intr:  isr 0x%x", time.tv_sec, isr));
#else
	dprintf("ae6_intr: %x isr\n", isr);
#endif
	if ((isr & ISR_PRX) || (isr & ISR_OVW)) {
	        if(isr & ISR_OVW) {
		        ae6_ovrecover(unit);
		        printf("ae6_intr: Receive overflow warning\n"); 
		} 
		if (isr & ISR_RXE) {
			ifp->if_ierrors++;
			sr = rp->ae6_rsr;
			if (sr & RSR_CRC) {
				if (sr & RSR_FAE)
					ae6p->ae6_stats.rfae_err++;
				else
					ae6p->ae6_stats.rcrc_err++;
			}
			if (sr & RSR_FO)
				ae6p->ae6_stats.rfo_err++;
			if (sr & RSR_MPA) {
				ae6_rintr(unit);
				ae6p->ae6_stats.rmiss_err++;
				printf("ae6_intr: Receive overflow, total lost %d\n", 
				       rp->ae6_cntr2); 
			}
		} else
			ae6_rintr(unit);
	}
	if ((isr & ISR_PTX) || 
		((ae6p->ae6_oactive) && (rp->ae6_tsr&TSR_PTX))) {
		if (isr & ISR_TXE) {
			ifp->if_oerrors++;
			sr = rp->ae6_rsr;
			if (sr & TSR_COL)
				ae6p->ae6_stats.scol_err++;
			if (sr & TSR_ABT)
				ae6p->ae6_stats.sabt_err++;
			if (sr & TSR_CRS)
				ae6p->ae6_stats.scrs_err++;
			if (sr & TSR_FU)
				ae6p->ae6_stats.sfu_err++;
			if (sr & TSR_CDH)
				ae6p->ae6_stats.scdh_err++;
			if (sr & TSR_OWC)
				ae6p->ae6_stats.sowc_err++;
			ae6p->ae6_oactive = 0;
  
			s = splimp();
			if (ae6p->ae6_if.if_snd.ifq_head)
				ae6_start(unit);
			splx(s);
		} else
			ae6_xintr(unit);
	}
} 

static ae6_rpkt(ae6p)
     register struct ae6 *ae6p;
{
	struct rcv_pkt_hdr *rcvp;	/* Packet header pointer	 */
	u8 llen;			/* Low byte of packet length	 */
	u8 hlen;			/* High byte of packet length	 */
	register short len;		/* Packet length		 */
	int page;			/* Packet page boundary		 */
	int off;			/* Offset			 */
	int resid;			/* residual byte count		 */
	register struct mbuf *m;	/* packet buffer		 */
	struct mbuf *m0;
	struct ifqueue *inq;		/* the interface queue		 */

	ae6p->ae6_if.if_ipackets++;
	/*
	 * Set the page to point to the page boundary of the received packet.
	 * Then create a pointer into memory based on the page, the page size
	 * and the location in memory of the ethernet ram. 
	 */
	page = (int) (get_boundary_page(ae6p) & 0xff);
	rcvp = (struct rcv_pkt_hdr *) ((unsigned) (page * AE6_PAGESIZE) +
				       (unsigned) ae6p->ae6_base);

#define	ae6dataaddr(rcvp, off, type)	((type)((caddr_t)((rcvp)+1)+(off)))

	if ((rcvp->rph_type >= ETHERPUP_TRAIL) &&
	    (rcvp->rph_type < ETHERPUP_TRAIL + ETHERPUP_NTRAILER)) {
		off = (rcvp->rph_type - ETHERPUP_TRAIL) * 512;
		if (off >= ETHERMTU)
			return;
		rcvp->rph_type = ntohs(*ae6dataaddr(rcvp, off, u_short *));
		resid = ntohs(*(ae6dataaddr(rcvp, off + 2, u_short *)));
		if (off + resid > len)
			return;
		len = off + resid;
	} else
		off = 0;
	/*
	 * The input packet length is swapped, so swap it into a valid value
	 * to count down. 
	 */
	len = (u16) ((rcvp->rph_hbc << 8) | rcvp->rph_lbc);

	if (len == 0)
		return;
	m = ae6_get(rcvp, len, off, ae6p->ae6_base);
	if (m == 0) {
		return;
	}
	if (off) {
		m->m_off += 2 * sizeof(u_short);
		m->m_len -= 2 * sizeof(u_short);
	}
#ifdef HOWFAR
        TRACE(ae6_debug, ("time 0x%x ae6_rpkt: type 0x%x\n", time.tv_sec,
	                  rcvp->rph_type));
        TRACE(ae6_debug, ("utime 0x%x ae6_rpkt: from 0x%x %x\n", time.tv_usec,
	                  (rcvp->rph_src.ether_addr_octet[0] << 16 |
	                   rcvp->rph_src.ether_addr_octet[1] << 8 |
		           rcvp->rph_src.ether_addr_octet[2]),
			  (rcvp->rph_src.ether_addr_octet[3] << 16 |
			   rcvp->rph_src.ether_addr_octet[4] << 8 |
			   rcvp->rph_src.ether_addr_octet[5])));
        TRACE(ae6_debug, ("utime 0x%x ae6_rpkt:  to 0x%x %x\n", time.tv_usec,
	                  (rcvp->rph_dest.ether_addr_octet[0] << 16 |
	                   rcvp->rph_dest.ether_addr_octet[1] << 8 |
	      		   rcvp->rph_dest.ether_addr_octet[2]),
 		          (rcvp->rph_dest.ether_addr_octet[3] << 16 |
		           rcvp->rph_dest.ether_addr_octet[4] << 8 |
		           rcvp->rph_dest.ether_addr_octet[5])));
#else
	dprintf(" src %x %x %x %x %x %x, dest %x %x %x %x %x %x, type %x\n", 
		rcvp->rph_src.ether_addr_octet[0],
		rcvp->rph_src.ether_addr_octet[1],
		rcvp->rph_src.ether_addr_octet[2],
		rcvp->rph_src.ether_addr_octet[3],
		rcvp->rph_src.ether_addr_octet[4],
		rcvp->rph_src.ether_addr_octet[5],
		rcvp->rph_dest.ether_addr_octet[0],
		rcvp->rph_dest.ether_addr_octet[1],
		rcvp->rph_dest.ether_addr_octet[2],
		rcvp->rph_dest.ether_addr_octet[3],
		rcvp->rph_dest.ether_addr_octet[4],
		rcvp->rph_dest.ether_addr_octet[5],
		rcvp->rph_type);
#endif
	switch (rcvp->rph_type) {

#ifdef INET
	case ETHERPUP_IPTYPE:
	    /*
	     * Prepend the interface pointer to first mbuf.
	     */
	    if (m->m_off <= MMAXOFF &&
		m->m_off >= MMINOFF + sizeof(struct ifnet *)) {
		    m->m_off -= sizeof(struct ifnet *);
		    m->m_len += sizeof(struct ifnet *);
		} else {
		    MGET(m0, M_DONTWAIT, MT_HEADER);
		    if(m0 == (struct mbuf *)0) {
			m_freem(m);
			return(ENOBUFS);
		    }
		    m0->m_off = MMINOFF;
		    m0->m_len = sizeof(struct ifnet *);
		    m0->m_next = m;
		    m = m0;
		}
	    *(mtod(m, struct ifnet **)) = &ae6p->ae6_if;
	    schednetisr(NETISR_IP);
	    inq = &ipintrq;
	    if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
		return;
	    }
	    IF_ENQUEUE(inq, m);
	    return;

	case ETHERPUP_ARPTYPE:
	    arpinput(&ae6p->ae6_ac, m);
	    return;

	case ETHERPUP_REVARPTYPE:
	    revarpinput(&ae6p->ae6_ac, m);
	    return;
#endif
	default:
	    m_freem(m);
	    return;
	}
}

/*
 * Ae6 page manipulation routines. 
 */

static u8 get_current_page(ae6p)
     struct ae6 *ae6p;
{
	u8 page;
	register struct ae6_regs *rp = ae6p->ae6_cmd;

	rp->ae6_csr = CR_PS1;
	page = rp->ae6_curr;
	rp->ae6_csr = CR_PS0;
	return (page);
}

static u8 get_boundary_page(ae6p)
     struct ae6 *ae6p;
{
	u8 page;
	register struct ae6_regs *rp = ae6p->ae6_cmd;

	page = rp->ae6_bnry + 1;
	if (page > RECV_STOP)
		page = RECV_START;
	return (page);
}

static update_boundary_page(ae6p)
     struct ae6 *ae6p;
{
	register struct ae6_regs *rp = ae6p->ae6_cmd;
	struct rcv_pkt_hdr *rcvp;
	u8 new_bnry, page;

	page = (get_boundary_page(ae6p) & 0xff);
	rcvp = (struct rcv_pkt_hdr *) ((unsigned) (page * AE6_PAGESIZE) +
				       (unsigned) ae6p->ae6_base);

	/*
	 * Get the new boundary out of the packet header, and subtract one
	 * because the boundary must always be one behind the current packet
	 * pointer. 
	 */
	new_bnry = rcvp->rph_next - 1;

	/*
	 * If the subtraction causes the page to be out of the receive area,
	 * then wrap it around. 
	 */
	if (new_bnry < RECV_START) {
		new_bnry = RECV_STOP;
	}
	rp->ae6_bnry = new_bnry;
}

/*
 * Ae6 ram read/write routines.	 Ram is read and written from/to mbufs. 
 */

static ae6_put(m, base)
	struct mbuf *m;
	char *base;
{
	register struct mbuf *mp;
	register int off;
	register u_char *bp;
	u16 temp;
	u16 *tp;

	for (bp = (u_char *) base, mp = m, off = 0; mp; mp = mp->m_next) {
		register unsigned len = mp->m_len;
		u_char *mcp;

		off += mp->m_len;
		if (len == 0)
			continue;
		mcp = mtod(mp, u_char *);
		/*
		 * If the ram pointer (bp) is left on a byte address,
		 * then adjust the pointer back one byte, create a
		 * 16 bit quantity from the odd byte in card ram, and
		 * the first byte in the next mbuf, store it, and
		 * leave bp pointing to a 16 bit word address, and
		 * mcp pointing to the next byte (which is byte
		 * aligned.  This only works for 68020s!)
		 */
		if(((unsigned)bp & 0x1) != 0) {
			bp--;
			tp = (u16 *)bp;
			temp = *tp;
			*tp++ = ((temp & 0xff00) | (*mcp++ & 0xff)) & 0xffff;
			len--;
			bp = (u_char *)tp;
		}
		wordcopy((u16 *) mcp, (u16 *) bp, (int) len);
		bp += len;
	}
	if (off & 01) {
		off++;
	}
	m_freem(m);
	return (off);
}

static struct mbuf *ae6_get(buf, totlen, off0, base)
	u_char *buf;
	int totlen, off0;
	u_char *base;
{
	register struct mbuf *m;
	struct mbuf *top = 0, **mp = &top;
	register int off = off0, len;
	register u_char *cp;
	int templen;
	u16 *bufp;

	cp = buf + sizeof(struct rcv_pkt_hdr);
	totlen -= sizeof(struct ether_header);
	while (totlen > 0) {

		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0)
			goto bad;
		if (off) {
			len = totlen - off;
			cp = buf + sizeof(struct rcv_pkt_hdr) + off;
		} else
			len = totlen;
		if ((len < MCLBYTES) || (mclget(m) == 0)) {
			m->m_len = MIN(MLEN, len);
			m->m_off = MMINOFF;
		}
		bufp = mtod(m, u16 *);
		if (((unsigned)cp + m->m_len) >= ((unsigned) base +
			     (unsigned) ((RECV_STOP + 1) * AE6_PAGESIZE))) {
			templen = ((unsigned) base + (unsigned) ((RECV_STOP + 1)
					   * AE6_PAGESIZE)) - (unsigned) cp;
			wordcopy((u16 *) cp, bufp, templen);
			cp = (u_char *) ((unsigned) base +
				    (unsigned) (RECV_START * AE6_PAGESIZE));
			bufp = (u16 *)((unsigned)bufp + templen);
			wordcopy((u16 *) cp, bufp, 
					(unsigned) m->m_len - templen);
			cp += (m->m_len - templen);
		} else {
			wordcopy((u16 *) cp, bufp, (unsigned) m->m_len);
			cp += m->m_len;
		}
		*mp = m;
		mp = &m->m_next;
		if (off0) {
			off += m->m_len;
			if (off == totlen) {
				cp = buf + sizeof(struct rcv_pkt_hdr);
				off = 0;
				totlen = off0;
			}
		}
		else
			totlen -= m->m_len;
	}
	return (top);
bad:
	if (top)
		m_freem(top);
	return (0);
}

/*
 * Process an ioctl request. 
 */
static ae6_ioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	int		cmd;
	caddr_t		data;
{
        register struct ifaddr *ifa = (struct ifaddr *)data;
	struct ae6 *ae6p = &ae6[ifp->if_unit];
	int s = splimp(), error = 0;

	switch (cmd) {

	case SIOCSIFADDR:
	        ifp->if_flags |= IFF_UP;
		switch (ifa->ifa_addr.sa_family) {
		case AF_INET:
		    /* 
		     * Initalize the interface.  This includes setting the
		     * ethernet address for the interface.
		     */
		    ae6_init(ifp->if_unit);
		    ((struct arpcom *)ifp)->ac_ipaddr = IA_SIN(ifa)->sin_addr;
		    arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
		    break;

		default:
		    error = EINVAL;
		    break;
		}
		break;
	case SIOCSIFFLAGS:
		if ((ifp->if_flags & IFF_UP) == 0 &&
		    ifp->if_flags & IFF_RUNNING) {
			ifp->if_flags &= ~IFF_RUNNING;
		} else if (ifp->if_flags & IFF_UP &&
		    (ifp->if_flags & IFF_RUNNING) == 0)
			ae6_init(ifp->if_unit);
		break;
	default:
		error = EINVAL;
		break;
	}
	splx(s);
	return (error);
}

static wordcopy(from, to, len)
	register u16 *from, *to;
	register int len;
{
	while (len > 0) {
		if (len > 1) {
			*to++ = *from++;
			len -= 2;
		} else {
			*to++ = *from++ & 0xff00;
			len--;
		}
	}
}
#endif	/* NAE6 */
