(setq chaos:server-alist '(("STATUS" (CHAOS:SEND-STATUS) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSNCP  ") ("BAND-TRANSFER" (PROCESS-RUN-FUNCTION "BAND-TRANSFER Server" (QUOTE BAND-TRANSFER-SERVER)) NIL #FS:LOGICAL-PATHNAME "SYS: SYS2; BAND  ") ("FINGER" (CHAOS:GIVE-FINGER) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("NAME" (PROCESS-RUN-FUNCTION "NAME Server" (QUOTE CHAOS:GIVE-NAME)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("TIME" (CHAOS:TIME-SERVER) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("UPTIME" (CHAOS:UPTIME-SERVER) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("MAIL" (PROCESS-RUN-FUNCTION "MAIL Server" (QUOTE CHAOS:DUMMY-MAIL-SERVER)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("REMOTE-DISK" (PROCESS-RUN-FUNCTION "REMOTE-DISK Server" (QUOTE CHAOS:REMOTE-DISK-SERVER)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("BABEL" (PROCESS-RUN-FUNCTION "Babel Server" (QUOTE CHAOS:BABEL-SERVER)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("DUMP-ROUTING-TABLE" (CHAOS:DUMP-ROUTING-TABLE) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("EVAL" (PROCESS-RUN-FUNCTION "EVAL Server" (QUOTE CHAOS:EVAL-SERVER-FUNCTION)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("TELNET" (PROCESS-RUN-FUNCTION "TELNET Server" (QUOTE CHAOS:TELNET-SERVER-FUNCTION)) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("NOTIFY" (CHAOS:NOTIFY-SERVER) NIL #FS:LOGICAL-PATHNAME "SYS: NETWORK; CHAOS; CHSAUX  ") ("SEND" (PROCESS-RUN-FUNCTION "CONVERSE" (FUNCTION ZWEI:RECEIVE-MSG)) NIL #FS:LOGICAL-PATHNAME "SYS: IO1; CONVER  ")))


(defun find-disk-conn (window)
  (CHAOS:LISTEN "BAND-TRANSFER" WINDOW))




(DEFUNP BAND-TRANSFER-SERVER (&AUX CONN PKT STR TEM RQB BUF WRITE-P (QUANTUM 17.) PART-NAME
				   PART-BASE PART-SIZE PART-COMMENT SUB-START SUB-N NB TOP
				   (WINDOW 36.))
  (ERRSET
    (UNWIND-PROTECT
      (PROG ()
	(SETQ CONN (find-disk-conn window))
	(IF (CHAOS:SYMBOLICS-CONNECTION-P CONN)
	    (RETURN (CHAOS:SYMBOLICS-REJECT CONN))
	  (SETQ STR (CHAOS:PKT-STRING (CHAOS:READ-PKTS CONN)))	;Look at the RFC
	  (LET ((*READ-BASE* 10.))	;RFC is BAND-TRANSFER READ/WRITE band subset size comment
				;subset is NIL or list of rel start and n-blocks
	    (SETQ TEM (READ-FROM-STRING (STRING-APPEND "(" STR ")"))))
	  (MULTIPLE-VALUE (PART-BASE PART-SIZE NIL PART-NAME)
	    (SYS:FIND-DISK-PARTITION (THIRD TEM)))
	  (OR PART-BASE
	      (RETURN (CHAOS:REJECT CONN (FORMAT NIL "No /"~A/" partition here." PART-NAME))))
	  (AND (FOURTH TEM) (SETQ SUB-START (FIRST (FOURTH TEM)) SUB-N (SECOND (FOURTH TEM))))
	  (COND ((STRING-EQUAL (SECOND TEM) "READ")
		 (SETQ WRITE-P NIL)
		 (SETQ PART-COMMENT (PARTITION-COMMENT PART-NAME 0)))
		((STRING-EQUAL (SECOND TEM) "WRITE")
		 (SETQ WRITE-P T)
		 (OR ( (FIFTH TEM) PART-SIZE)
		     (RETURN (CHAOS:REJECT CONN (FORMAT NIL "Partition too small, ~D>~D"
							(FIFTH TEM) PART-SIZE))))
		 (SETQ PART-SIZE (FIFTH TEM))
		 (SETQ PART-COMMENT (STRING (SIXTH TEM))))	;Comment to store later
		(T (RETURN (CHAOS:REJECT CONN "Illegal operation, must be READ or WRITE"))))
	  (AND SUB-START (OR (MINUSP SUB-START) (MINUSP SUB-N) (> u(+ SUB-START SUB-N) PART-SIZE))
	       (RETURN (CHAOS:REJECT CONN "Subset outside of partition")))
	  (CHAOS:ACCEPT CONN)
	  (AND (EQ BAND-TRANSFER-SERVER-ON ':NOTIFY)
	       (PROCESS-RUN-FUNCTION "Notify" 'TV:NOTIFY NIL
				     "BAND-TRANSFER-SERVER: ~:[READ~;WRITE~] of ~A partition by ~A"
				     WRITE-P PART-NAME
				     (CHAOS:HOST-DATA (CHAOS:FOREIGN-ADDRESS CONN))))
	  (FUNCALL TV:WHO-LINE-FILE-STATE-SHEET ':ADD-SERVER CONN "BAND-TRANSFER")
	  (COND ((NOT WRITE-P)			;Send packet containing size, comment
		 (SETQ PART-SIZE (MEASURED-SIZE-OF-PARTITION PART-NAME))
		 (SETQ PKT (CHAOS:GET-PKT))
		 (CHAOS:SET-PKT-STRING PKT (FORMAT NIL "~D ~S" PART-SIZE PART-COMMENT))
		 (CHAOS:SEND-PKT CONN PKT)))
	  (AND SUB-START (SETQ PART-BASE (+ PART-BASE SUB-START)
			       PART-SIZE SUB-N))
	  (COND (WRITE-P (UPDATE-PARTITION-COMMENT PART-NAME "Incomplete Copy" 0)))
	  (SETQ RQB (SYS:GET-DISK-RQB QUANTUM)
		BUF (SYS:RQB-BUFFER RQB))
	  (SETQ DISK-ERROR-RETRY-COUNT 20.)	;Try to bypass hardware overrun problem
	  (WIRE-DISK-RQB RQB)
	  (SETQ TOP (+ PART-BASE PART-SIZE))
	  (DO ((BLOCK PART-BASE (+ BLOCK QUANTUM)))
	      (( BLOCK TOP))
	    (AND (< (SETQ NB (- TOP BLOCK)) QUANTUM)
		 (WIRE-DISK-RQB RQB (SETQ QUANTUM NB)))
	    (COND ((NOT WRITE-P)		;This can modify pages without setting
		   (DISK-READ-WIRED RQB 0 BLOCK)	; the modified bits, but as long as
						; we dont depend on data after its unwired,
						; it wont hurt.
		   (ARRAY-TO-NET BUF CONN (* QUANTUM PAGE-SIZE 2)))
		  (T (ARRAY-FROM-NET BUF CONN (* QUANTUM PAGE-SIZE 2))
		     (DISK-WRITE-WIRED RQB 0 BLOCK))))
	  (CHAOS:FINISH-CONN CONN)
	  (CHAOS:CLOSE-CONN CONN "Done")
	  (AND WRITE-P (UPDATE-PARTITION-COMMENT PART-NAME PART-COMMENT 0))))
      (AND RQB (SYS:RETURN-DISK-RQB RQB))
      (AND CONN (PROGN (FUNCALL TV:WHO-LINE-FILE-STATE-SHEET ':DELETE-SERVER CONN)
		       (CHAOS:REMOVE-CONN CONN))))
    NIL))
