;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Patch file for System version 98.12
;;; Reason: Rubout handler interface improvements:
;;;  :ACTIVATION, :COMMAND, :PREEMPTABLE, :DO-NOT-ECHO, :PASS-THROUGH.
;;; WITH-INPUT-EDITING.
;;; Editor top level and Ztop mode have input histories; bugs fixed.
;;; COMPILE-INTERVAL and Add Patch printout bug.  C-Sh-E on atoms.
;;; READLINE, READ and PROMPT-AND-READ now use :ACTIVATION.
;;; RECORD-SOURCE-FILE-NAME flushes duplicate entries.
;;; UPDATE-INTERVAL-COMPILE-TICK bug.
;;; CHAOS:CONN-FINISHED-P, CHAOS:CLOSE-CONN, CHAOS:FINISH-CONN.
;;; Some streams now support :ANY-TYI.  Colons in logical pathnames bug.
;;; Written 12/21/83 23:59:59 by rms,
;;; while running on Lisp Machine Eighteen from band 7
;;; with Experimental System 98.8, CADR 3.2, Experimental ZMail 53.5, MIT-Specific 22.0, microcode 305, ZM MIT.

(globalize "WITH-INPUT-EDITING")

; From file FQUERY.LISP SRC:<L.IO1> OZ:
#8R FORMAT#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FORMAT")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO1; FQUERY  "

(DEFUN FQUERY-READLINE-WITH-HELP (STREAM)
  (DO ((STRING (MAKE-ARRAY 20. ':TYPE 'ART-STRING ':LEADER-LIST '(0)))
       (CH))
      (NIL)
    (SETQ CH (FUNCALL STREAM ':TYI))
    (COND ((OR (NULL CH) (= CH #\CR))
	   (RETURN STRING))
	  ((AND (= CH #\HELP) FQUERY-HELP-FUNCTION)
	   (FRESH-LINE STREAM)
	   (FUNCALL FQUERY-HELP-FUNCTION STREAM FQUERY-CHOICES #'READLINE-FQUERY-FUNCTION)
	   (FUNCALL STREAM ':SEND-IF-HANDLES ':REFRESH-RUBOUT-HANDLER))
	  ((LDB-TEST %%KBD-CONTROL-META CH))
	  (T (ARRAY-PUSH-EXTEND STRING CH)))))

))

; From file RH.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; RH  "


(DEFUN RH-INSERT-CHAR (CH N RUBBED-OUT-SOME?)
  "Insert N copies of the character CH."
  (USING-RESOURCE (STRING RH-INSERT-STRING)
    (SETQ N (MIN N (ARRAY-LENGTH STRING)))
    (DOTIMES (I N) (ASET CH STRING I))
    ;; Flush bucky bits unless we are going to return right away.
    (OR (ZEROP (LDB %%KBD-CONTROL-META CH))
	(AND RUBBED-OUT-SOME?
	     (SETQ CH (LDB %%KBD-CHAR CH))))
    (RH-INSERT-STRING STRING 0 N RUBBED-OUT-SOME? T
;		      (OR (NOT (ZEROP (LDB %%KBD-CONTROL-META CH)))
;			  (MEMQ CH (CDR (ASSQ ':DO-NOT-ECHO RUBOUT-HANDLER-OPTIONS))))
		      )))

))

; From file COLD.LISP SRC:<L.WINDOW> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; COLD  "

(DEFVAR COLD-LOAD-STREAM-ACTIVATION-CHARACTER)

;;; Give a single character, or do rubout processing, throws to RUBOUT-HANDLER on editing.
(DECLARE-INSTANCE-IMMEDIATE-INSTANCE-VARIABLES (COLD-LOAD-STREAM)
(DEFUN COLD-LOAD-STREAM-RUBOUT-HANDLER ()
  (WHEN (= (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1) 7777777)
    (SETF (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1) 0)
    (*THROW 'RUBOUT-HANDLER T))
  (IF COLD-LOAD-STREAM-ACTIVATION-CHARACTER
      (RETURN-FROM COLD-LOAD-STREAM-RUBOUT-HANDLER
	(PROG1 COLD-LOAD-STREAM-ACTIVATION-CHARACTER
	       (SETQ COLD-LOAD-STREAM-ACTIVATION-CHARACTER NIL))))
  (DO ((CH)
       (RUBBED-OUT-SOME)
       (LEN)
       (RUBOUT-HANDLER NIL)
       (PASS-THROUGH (CDR (ASSQ ':PASS-THROUGH RUBOUT-HANDLER-OPTIONS)))
       (DO-NOT-ECHO (CDR (ASSQ ':DO-NOT-ECHO RUBOUT-HANDLER-OPTIONS)))
       (COMMAND-HANDLER
	 (ASSQ ':COMMAND RUBOUT-HANDLER-OPTIONS))
       (ACTIVATION-HANDLER
	 (ASSQ ':ACTIVATION RUBOUT-HANDLER-OPTIONS)))
      (NIL)
    (SETQ CH (FUNCALL-SELF ':TYI))
    (COND ((AND COMMAND-HANDLER
		(APPLY (CADR COMMAND-HANDLER) CH (CDDR COMMAND-HANDLER)))
	     (SETF (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1) 0)
	     (*THROW 'TV:RETURN-FROM-RUBOUT-HANDLER
		     (VALUES
		       `(:COMMAND ,CH 1)
		       ':COMMAND)))
	  ;; Don't touch this character, just return it to caller.
	  ((OR (MEMQ CH PASS-THROUGH)
	       (ASSQ-CAREFUL CH PASS-THROUGH))
	   ;; Cause rubout handler rescan next time the user does :TYI.
	   (IF RUBBED-OUT-SOME
	       (SETF (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1) 7777777))
	   (RETURN CH))
	  ((AND (NOT (OR (MEMQ CH DO-NOT-ECHO)
			 (AND ACTIVATION-HANDLER
			      (APPLY (CADR ACTIVATION-HANDLER) CH (CDDR ACTIVATION-HANDLER)))))
		(OR (LDB-TEST %%KBD-CONTROL-META CH)
		    (MEMQ CH '(#\RUBOUT #\CLEAR-INPUT #\CLEAR-SCREEN #\VT))))
	   (COND
	     ((= CH #\CLEAR)			;CLEAR flushes all buffered input
	      (STORE-ARRAY-LEADER 0 RUBOUT-HANDLER-BUFFER 0)
	      (SETQ RUBBED-OUT-SOME T)		;Will need to throw out
	      (FUNCALL-SELF ':TYO CH)		;Echo and advance to new line
	      (FUNCALL-SELF ':TYO #\CR))
	     ((OR (= CH #\FORM) (= CH #\VT))	;Retype buffered input
	      (FUNCALL-SELF ':TYO CH)		;Echo it
	      (IF (= CH #\FORM) (FUNCALL-SELF ':CLEAR-SCREEN) (FUNCALL-SELF ':TYO #\CR))
	      (LET ((PROMPT (CADR (OR (ASSQ ':REPROMPT RUBOUT-HANDLER-OPTIONS)
				      (ASSQ ':PROMPT RUBOUT-HANDLER-OPTIONS)))))
		(AND PROMPT
		     (IF (STRINGP PROMPT)
			 (PRINC PROMPT SELF)
		       (FUNCALL PROMPT SELF CH))))
	      (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER))
	     ((= CH #\RUBOUT)
	      (COND ((NOT (ZEROP (SETQ LEN (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 0))))
		     (SETQ CURSOR-X (MAX 0 (- CURSOR-X CHAR-WIDTH)))
		     (FUNCALL-SELF ':CLEAR-EOL)
		     (STORE-ARRAY-LEADER (SETQ LEN (1- LEN)) RUBOUT-HANDLER-BUFFER 0)
		     (SETQ RUBBED-OUT-SOME T)
		     (COND ((ZEROP LEN)
			    (STORE-ARRAY-LEADER 0 RUBOUT-HANDLER-BUFFER 1)
			    (*THROW 'RUBOUT-HANDLER T))))))
	     ((LDB-TEST %%KBD-CONTROL-META CH)
	      (KBD-CONVERT-BEEP)))
	   (COND ((AND (ZEROP (FILL-POINTER RUBOUT-HANDLER-BUFFER))
		       (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-OPTIONS))
		  (SETF (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1) 0)
		  (*THROW 'RUBOUT-HANDLER T))))
	  (T						;It's a self-inserting character
	   (COND ((MEMQ CH DO-NOT-ECHO)
		  (SETQ COLD-LOAD-STREAM-ACTIVATION-CHARACTER CH))
		 ((AND ACTIVATION-HANDLER
		       (APPLY (CADR ACTIVATION-HANDLER) CH (CDDR ACTIVATION-HANDLER)))
		  (SETQ CH `(:ACTIVATION ,CH 1))
		  (SETQ COLD-LOAD-STREAM-ACTIVATION-CHARACTER CH))
		 (T
		  (FUNCALL-SELF ':TYO CH)
		  (ARRAY-PUSH-EXTEND RUBOUT-HANDLER-BUFFER CH)))
	   (COND (RUBBED-OUT-SOME
		  (STORE-ARRAY-LEADER 0 RUBOUT-HANDLER-BUFFER 1)
		  (*THROW 'RUBOUT-HANDLER T))
		 (T
		  (STORE-ARRAY-LEADER (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 0)
				      RUBOUT-HANDLER-BUFFER 1)
		  (SETQ COLD-LOAD-STREAM-ACTIVATION-CHARACTER NIL)
		  (RETURN CH))))))))

(DEFMETHOD-IMMEDIATE (COLD-LOAD-STREAM :RUBOUT-HANDLER)
		     (RUBOUT-HANDLER-OPTIONS FUNCTION &REST ARGS)
  (STORE-ARRAY-LEADER 0 RUBOUT-HANDLER-BUFFER 0)
  (STORE-ARRAY-LEADER 0 RUBOUT-HANDLER-BUFFER 1)
  (MULTIPLE-VALUE-BIND (PROMPT-STARTING-X PROMPT-STARTING-Y)
      (FUNCALL COLD-LOAD-STREAM ':READ-CURSORPOS)
    (LET ((PROMPT (CADR (ASSQ ':PROMPT RUBOUT-HANDLER-OPTIONS))))
      (AND PROMPT				;Prompt if desired
	   (IF (STRINGP PROMPT)
	       (PRINC PROMPT SELF)
	     (FUNCALL PROMPT SELF NIL))))
    (*CATCH 'TV:RETURN-FROM-RUBOUT-HANDLER
      (DO ((RUBOUT-HANDLER T)			;Establish rubout handler
	   (INHIBIT-SCHEDULING-FLAG T)		;Make sure all chars come here
	   (COLD-LOAD-STREAM-ACTIVATION-CHARACTER NIL))
	  (NIL)
	(*CATCH 'RUBOUT-HANDLER			;Throw here when rubbing out
	  (CONDITION-CASE (ERROR)
	      (RETURN (APPLY FUNCTION ARGS))	;Call read type function
	    (READ-ERROR
	     (TERPRI SELF)
	     (PRINC ">>ERROR: " SELF)
	     (SEND ERROR ':REPORT SELF)
	     (TERPRI SELF)
	     (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER)	;On error, retype buffered
	     (DO () (NIL) (FUNCALL-SELF ':TYI)))))		;and force user to edit it
	;;Maybe return when user rubs all the way back
	(AND (ZEROP (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 0))
	     (LET ((FULL-RUBOUT-OPTION (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-OPTIONS)))
	       (WHEN FULL-RUBOUT-OPTION
		 ;; Get rid of the prompt, if any.
		 (FUNCALL COLD-LOAD-STREAM ':SET-CURSORPOS PROMPT-STARTING-X PROMPT-STARTING-Y)
		 (FUNCALL COLD-LOAD-STREAM ':CLEAR-EOL)
		 (RETURN NIL (CADR FULL-RUBOUT-OPTION)))))))))

))

; From file COLD.LISP SRC:<L.WINDOW> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; COLD  "

(DEFCONST CADR-TYPE-CODE 1
  "The value which SI:PROCESSOR-TYPE-CODE has when you run on a CADR.")
(DEFCONST LAMBDA-TYPE-CODE 2
  "The value which SI:PROCESSOR-TYPE-CODE has when you run on a LAMBDA.")

))

; From file COLD.LISP SRC:<L.WINDOW> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; COLD  "

(DEFMETHOD-IMMEDIATE (COLD-LOAD-STREAM :TYI) (&OPTIONAL IGNORE
							&AUX IDX (INHIBIT-SCHEDULING-FLAG T))
  (COND	((NOT RUBOUT-HANDLER)
	 (IF UNRCHF
	     (PROG1 UNRCHF (SETQ UNRCHF NIL))
	   (DO () (())
	     (COLD-LOAD-STREAM-WAIT-FOR-CHAR)
	     (LET ((CHAR (KBD-CONVERT-TO-SOFTWARE-CHAR (KBD-GET-HARDWARE-CHAR))))
	       (SELECTQ CHAR
		 (NIL)				;Unreal character
		 (#\BREAK (BREAK "BREAK"))
		 (OTHERWISE (RETURN CHAR)))))))
	((> (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 0)
	    (SETQ IDX (ARRAY-LEADER RUBOUT-HANDLER-BUFFER 1)))
	 (STORE-ARRAY-LEADER (1+ IDX) RUBOUT-HANDLER-BUFFER 1)
	 (AREF RUBOUT-HANDLER-BUFFER IDX))
	(T
	 (COLD-LOAD-STREAM-RUBOUT-HANDLER))))

))

; From file EH.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EH  "

(DEFUN SG-APPLY (SG FUNCTION ARGUMENTS &OPTIONAL NO-ERROR-RESTART GOODBYE
		 &AUX (PREV-FH (SG-FOOTHOLD-DATA SG)))
  "Apply FUNCTION to ARGUMENTS in stack group SG.
This is a high-level function, in that SG's state is preserved."
  (SG-SAVE-STATE SG)
  (SETF (SG-FOOTHOLD-DATA SG) (SG-AP SG))
  (SG-OPEN-CALL-BLOCK SG 0
		      (IF NO-ERROR-RESTART 'FH-APPLIER-NO-RESTART 'FH-APPLIER))
  (SG-REGPDL-PUSH FUNCTION SG)
  (SG-REGPDL-PUSH ARGUMENTS SG)
  (SG-REGPDL-PUSH + SG)
  (SG-REGPDL-PUSH * SG)
  (SG-REGPDL-PUSH // SG)
  (SG-REGPDL-PUSH ++ SG)
  (SG-REGPDL-PUSH ** SG)
  (SG-REGPDL-PUSH //// SG)
  (SG-REGPDL-PUSH +++ SG)
  (SG-REGPDL-PUSH *** SG) 
  (SG-REGPDL-PUSH ////// SG)
  (SG-REGPDL-PUSH SG SG)
  (SG-REGPDL-PUSH CURRENT-FRAME SG)
  (SG-REGPDL-PUSH EH-ERROR SG)
  (SG-REGPDL-PUSH CURRENT-STACK-GROUP SG)
  (SG-REGPDL-PUSH ERROR-HANDLER-RUNNING SG)
  (SG-REGPDL-PUSH PREV-FH SG)
  (IF GOODBYE
      (SG-RUN-GOODBYE SG)
    (RUN-SG SG)))

))

; From file EH.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EH  "

(DEFUN SG-APPLY-NO-TRAP (SG FUNCTION ARGUMENTS &OPTIONAL NO-ERROR-RESTART GOODBYE)
  "Apply FUNCTION to ARGUMENTS in stack group SG, suppressing trap-on-call.
This is a high-level function, in that SG's state is preserved."
  (LET ((OTOC (SG-FLAGS-TRAP-ON-CALL SG)))
    (SETF (SG-FLAGS-TRAP-ON-CALL SG) 0)
    (UNWIND-PROTECT
	(SG-APPLY SG FUNCTION ARGUMENTS NO-ERROR-RESTART GOODBYE)
      (SETF (SG-FLAGS-TRAP-ON-CALL SG) OTOC))))

))

; From file EHC.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EHC  "

(DEFUN SG-ABORT (SG)
  (SG-APPLY-NO-TRAP SG 'SIGNAL-CONDITION (LIST EH:ABORT-OBJECT) T
		    (NOT ERROR-HANDLER-RUNNING)))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(SET-COMTAB *STREAM-COMTAB* '(						 #\C-M-Y COM-YANK-INPUT-HISTORY
))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFFLAVOR EDITOR-STREAM-MIXIN
       (TV:IO-BUFFER
	(*INSIDE-EDITOR-STREAM* T)
	*STREAM-SHEET*
	*STREAM-START-BP*
	(*STREAM-COMMAND-POINT* NIL)
	(*STREAM-INPUT-HISTORY* NIL)
	*STREAM-BP*
	*STREAM-BLINKER*)
       ()
  (:DEFAULT-INIT-PLIST :IBEAM-BLINKER-P T
    :EDITOR-CLOSURE-VARIABLES EDITOR-STREAM-CLOSURE-VARIABLES
    :COMTAB *STREAM-COMTAB*
    :MODE-LINE-LIST '("EDITOR-STREAM " "(" *MODE-NAME-LIST* ")"
		      (*EDITOR-STREAM-ACTIVATION-NEEDED* " {Not activating}"
							 :ELSE "")))
  (:REQUIRED-FLAVORS TOP-LEVEL-DISPLAYER-MIXIN DISPLAYER)
  (:INITABLE-INSTANCE-VARIABLES *STREAM-SHEET*)
  (:GETTABLE-INSTANCE-VARIABLES *STREAM-SHEET* *STREAM-INPUT-HISTORY*)
  (:SETTABLE-INSTANCE-VARIABLES *STREAM-COMMAND-POINT*)
  (:SPECIAL-INSTANCE-VARIABLES *INSIDE-EDITOR-STREAM*)
  (:INIT-KEYWORDS :IBEAM-BLINKER-P))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (EDITOR-STREAM-MIXIN :AFTER :INIT) (INIT-PLIST)
  (SETQ *STREAM-INPUT-HISTORY* (MAKE-HISTORY (STRING-APPEND "input history of "
							    (SEND *STREAM-SHEET* ':NAME))))
  (SETQ TV:IO-BUFFER (SEND *STREAM-SHEET* ':IO-BUFFER))
  (SETQ *STREAM-BLINKER* (WINDOW-POINT-BLINKER *STREAM-SHEET*))
  (AND (GET INIT-PLIST ':IBEAM-BLINKER-P)
       (LET ((BLINKER (TV:MAKE-BLINKER *STREAM-SHEET* 'STREAM-IBEAM-BLINKER
				       ':EDITOR-STREAM SELF ':VISIBILITY NIL )))
	 (SETF (WINDOW-SPECIAL-BLINKER-LIST *STREAM-SHEET*)
	       (DELQ (ASSQ 'STREAM-BLINK-IBEAM (WINDOW-SPECIAL-BLINKER-LIST *STREAM-SHEET*))
		     (WINDOW-SPECIAL-BLINKER-LIST *STREAM-SHEET*)))
	 (PUSH `(STREAM-BLINK-IBEAM . ,BLINKER)
	       (WINDOW-SPECIAL-BLINKER-LIST *STREAM-SHEET*))))
  (SYS:%USING-BINDING-INSTANCES (CLOSURE-BINDINGS EDITOR-CLOSURE))
  (SETQ *EDITOR-STREAM* SELF
	*WINDOW* *STREAM-SHEET*
	*EDITOR-STREAM-START-BP* *STREAM-START-BP*)
  (PUSH 'STREAM-PRE-COMMAND-HOOK *COMMAND-HOOK*)
  (PUSH 'STREAM-COMMAND-HOOK *POST-COMMAND-HOOK*))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (EDITOR-STREAM-MIXIN :BEFORE :CLEAR-INPUT) ()
  (UNLESS (BP-= *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
    (LET ((*WINDOW* *STREAM-SHEET*)
	  (*INTERVAL* (WINDOW-INTERVAL *STREAM-SHEET*)))
      (KILL-INTERVAL *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)) T))
    (FORMAT SELF
	    "~&Killing the rest of the buffer to clear input.  It is on the kill ring.")))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (EDITOR-STREAM-MIXIN :ANY-TYI) (&OPTIONAL IGNORE)
  (COND (RUBOUT-HANDLER
	 ;; If input is being edited...
	 (IF (AND (NULL *SRE-INPUT-POINT*)
		  (NOT (BP-= *STREAM-BP*
			     (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))))
	     ;; If we have more to fetch from the buffer, just fetch it.
	     (PROG1 (LDB %%CH-CHAR (BP-CHAR *STREAM-BP*))      ;Give buffered character if any
		    (MUST-REDISPLAY *STREAM-SHEET* DIS-BPS)	;We are moving point, so...
		    (LET ((*INTERVAL* INTERVAL))
		      (IBP *STREAM-BP*)))
	   ;; We have to get more input, probably invoking the editor.
	   (LET ((*EDITOR-STREAM-ALREADY-KNOWS* T))
	     (FUNCALL-SELF ':STREAM-RUBOUT-HANDLER))))
	;; If input is not being edited...
	(T
	 ;; Then we read it directly, as if were not an editor stream.
	 ;; Make sure screen is right before we read it.
	 ;; But if came from within the rubout handler, that is already done.
	 (OR *EDITOR-STREAM-ALREADY-KNOWS*
	     (STREAM-REDISPLAY))
	 (COND ((TV:KBD-IO-BUFFER-GET TV:IO-BUFFER T))
	       (T
		(FUNCALL-SELF ':NOTICE ':INPUT-WAIT)
		(TV:KBD-IO-BUFFER-GET TV:IO-BUFFER))))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *STREAM-PREEMPTABLE* NIL)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *STREAM-COMMAND-HANDLER* NIL)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *STREAM-ACTIVATION-HANDLER* NIL)
;; These two are the ones that get the cdr of the option value.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *STREAM-PASS-THROUGH* NIL)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *STREAM-DO-NOT-ECHO* NIL)


))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *SRE-INPUT-END-BP* NIL)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *SRE-INPUT-POINT* NIL)

;; If we encounter a :ACTIVATION or :DO-NOT-ECHO, we put here the value
;; to return for that character and force a rescan (all in the pre-command hook).
;; When the input is all rescanned, the :STREAM-RUBOUT-HANDLER operation
;; sees this is non-NIL; then it returns this value to its caller (:ANY-TYI)
;; and clears it out.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFVAR *SRE-ACTIVATION-CHARACTER* NIL)

;This is the "rubout handler" itself.  We call the supplied function
;after binding RUBOUT-HANDLER to T.  That function, which might be READ,
;does its input as usual, but the :ANY-TYI operation acts differently
;because RUBOUT-HANDLER is T.  Specifically, it may invoke :STREAM-RUBOUT-HANDLER.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (EDITOR-STREAM-MIXIN :RUBOUT-HANDLER) (RUBOUT-HANDLER-ARGS FUNCTION
						  &REST ARGS &AUX TEM
						  (*WINDOW* *STREAM-SHEET*)
						  *STREAM-DEFER-OUTPUT-NOT-AT-END*
						  COMMAND-POINT)
  (IF *STREAM-COMMAND-POINT*
      (PROGN
	(MOVE-BP *STREAM-START-BP* *STREAM-BP*)
	(SETQ COMMAND-POINT *STREAM-COMMAND-POINT*)
	(FLUSH-BP COMMAND-POINT)
	(SETQ *STREAM-COMMAND-POINT* NIL))
    (MOVE-BP *STREAM-START-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*))))
  (LET ((PROMPT-OPTION (ASSQ ':PROMPT RUBOUT-HANDLER-ARGS)))
    (WHEN PROMPT-OPTION
      (IF (ARRAYP (CADR PROMPT-OPTION))
	  (PRINC (CADR PROMPT-OPTION) SELF)
	(FUNCALL (CADR PROMPT-OPTION) SELF NIL))
      (MOVE-BP *STREAM-START-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))))
  (STREAM-MAYBE-REDISPLAY)
  (*CATCH 'TV:RETURN-FROM-RUBOUT-HANDLER
    (DO ((RUBOUT-HANDLER T)			;Establish rubout handler
	 (*SRE-ACTIVATION-CHARACTER* NIL)
	 (*STREAM-PASS-THROUGH* (CDR (ASSQ ':PASS-THROUGH RUBOUT-HANDLER-ARGS)))
	 (*STREAM-COMMAND-HANDLER*
	   (ASSQ ':COMMAND RUBOUT-HANDLER-ARGS))
	 (*STREAM-ACTIVATION-HANDLER*
	   (ASSQ ':ACTIVATION RUBOUT-HANDLER-ARGS))
	 (*STREAM-DO-NOT-ECHO*
	   (CDR (ASSQ ':DO-NOT-ECHO RUBOUT-HANDLER-ARGS)))
	 (*STREAM-PREEMPTABLE* (ASSQ ':PREEMPTABLE RUBOUT-HANDLER-ARGS)))
	(())
      (WITH-BP (START-OF-MSG-BP *STREAM-START-BP* ':NORMAL)
	(WITH-BP (END-OF-MSG-BP *STREAM-START-BP* ':NORMAL)
	  (*CATCH 'RUBOUT-HANDLER
	    (CONDITION-CASE (ERROR)
		(LET ((*SRE-STREAM-BP* *STREAM-BP*)
		      (*SRE-STREAM-START-BP* *STREAM-START-BP*)
		      (*SRE-WINDOW* *STREAM-SHEET*)
		      *SRE-INPUT-END-BP*
		      (*SRE-INPUT-POINT* COMMAND-POINT))
		  (CONDITION-BIND ((ERROR 'STREAM-READ-ERROR-HANDLER))
		    (RETURN (MULTIPLE-VALUE-PROG1
			      (APPLY FUNCTION ARGS)
			      (LET ((*INTERVAL* (WINDOW-INTERVAL *STREAM-SHEET*)))
				(DELETE-INTERVAL *STREAM-BP*
						 (INTERVAL-LAST-BP *INTERVAL*)))))))
	      (SYS:READ-ERROR
	       (LET ((*STREAM-DEFER-OUTPUT-NOT-AT-END* T))
		 (TERPRI SELF)
		 (PRINC ">>ERROR: " SELF)
		 (SEND ERROR ':REPORT SELF)
		 (TERPRI SELF))
	       (MOVE-BP *STREAM-START-BP* *STREAM-BP*)
	       (MOVE-BP END-OF-MSG-BP *STREAM-START-BP*)
	       (MOVE-BP *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
	       (MUST-REDISPLAY *STREAM-SHEET* DIS-BPS)
	       (STREAM-REDISPLAY)
	       (DO () (NIL) (FUNCALL-SELF ':TYI)))))
	  ;; Here if editor throws to RUBOUT-HANDLER
	  ;; to cause the input we have to be read over again.
	  ;; First, delete any error message we got from a previous parsing.
	  (COND ((NOT (BP-= START-OF-MSG-BP END-OF-MSG-BP))
		 (DELETE-INTERVAL START-OF-MSG-BP END-OF-MSG-BP T)
		 (MUST-REDISPLAY *STREAM-SHEET* DIS-TEXT)
		 (STREAM-REDISPLAY T)))
	  ;; Now start over again reading from the front of the input.
	  (MOVE-BP *STREAM-BP* *STREAM-START-BP*)
	  (SETQ COMMAND-POINT NIL)
	  (MUST-REDISPLAY *STREAM-SHEET* DIS-BPS)))
      ;; When a rubout or other editing operation is done, throws back to that
      ;; catch to reread the input.  But if the :FULL-RUBOUT option was specified
      ;; and everything was rubbed out, we return NIL and the specified value.
      (AND (BP-= *STREAM-START-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
	   (SETQ TEM (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-ARGS))
	   (RETURN NIL (CADR TEM))))))

;;; Catch all errors from inside read and make a copy of the text so far so the error message
;;; looks reasonable

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (EDITOR-STREAM-MIXIN :REFRESH-RUBOUT-HANDLER) (&REST IGNORE)
  (UNLESS (BP-< *STREAM-START-BP* *SRE-INPUT-POINT*)
    (MOVE-BP *SRE-INPUT-POINT* *STREAM-START-BP*))
  (LET ((CONTENTS
	  (STRING-INTERVAL *STREAM-START-BP* *SRE-INPUT-END-BP*))
	(POINT-OFFSET (BP-DIFFERENCE *SRE-INPUT-POINT* *STREAM-START-BP*))
	(*INTERVAL* (WINDOW-INTERVAL *STREAM-SHEET*)))
    (MOVE-BP *STREAM-START-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
    (INSERT *STREAM-START-BP* CONTENTS)
    (MOVE-BP *STREAM-BP*
	     (FORWARD-CHAR *STREAM-START-BP* POINT-OFFSET T))
    (SETQ *SRE-INPUT-POINT* (COPY-BP *STREAM-BP*))
    (MUST-REDISPLAY *STREAM-SHEET* DIS-TEXT)
    (STREAM-REDISPLAY T)))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFUN BP-DIFFERENCE (BP2 BP1)
  (LET ((BP (COPY-BP BP1))
	(*INTERVAL* (BP-TOP-LEVEL-NODE BP1)))
    (DO ((I 0 (1+ I)))
	((BP-= BP BP2) I)
      (IBP BP))))

;Do one :ANY-TYI for a read being done with rubout handling.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (EDITOR-STREAM-MIXIN :STREAM-RUBOUT-HANDLER)
	   (&AUX (RUBOUT-HANDLER NIL) CHAR)
  ;; If there is a saved-up activation character, return it from :ANY-TYI now.
  ;; This happens at the end of a rescan of the input.
  (IF *SRE-ACTIVATION-CHARACTER*
      (PROG1 *SRE-ACTIVATION-CHARACTER*
	     (SETQ *SRE-ACTIVATION-CHARACTER* NIL))
    ;; We could just call the editor, but we must pass certain characters
    ;; that the program doing the read is handling, and we also want to
    ;; save some time for alphabetic characters.
    (IF *SRE-INPUT-POINT*
	(MUST-REDISPLAY *STREAM-SHEET* DIS-BPS)
      (SETQ CHAR (FUNCALL-SELF ':ANY-TYI)))
    ;; Just type out and insert self-inserting printing characters
    ;; but not if they are the caller's pass-throughs or activations or commands,
    ;; or if they have been redefined in the editor itself.
    (IF (AND (NUMBERP CHAR)
	     (NOT (OR (MEMQ CHAR *STREAM-PASS-THROUGH*)
		      (SI:ASSQ-CAREFUL CHAR *STREAM-PASS-THROUGH*)))
	     (NOT (AND *STREAM-COMMAND-HANDLER*
		       (APPLY (CADR *STREAM-COMMAND-HANDLER*)
			      CHAR (CDDR *STREAM-COMMAND-HANDLER*))))
	     (NOT (AND *STREAM-ACTIVATION-HANDLER*
		       (APPLY (CADR *STREAM-ACTIVATION-HANDLER*)
			      CHAR (CDDR *STREAM-ACTIVATION-HANDLER*))))
	     (NOT (MEMQ CHAR *STREAM-DO-NOT-ECHO*))
	     (OR (< CHAR 40)
		 (AND ( CHAR #/A) ( CHAR #/Z))
		 (AND ( CHAR #/a) ( CHAR #/z)))
	     (EQ 'COM-ORDINARILY-SELF-INSERT (COMMAND-LOOKUP CHAR *STREAM-COMTAB*)))
	(LET ((*WINDOW* *STREAM-SHEET*))
	  (INSERT-MOVING *STREAM-BP* CHAR)
	  (STREAM-IMMEDIATE-OUTPUT
	    (TV:SHEET-TYO *STREAM-SHEET* CHAR))
	  CHAR)
      ;; Otherwise, run the editor till COM-ACTIVATE throws to us,
      ;; then throw to RUBOUT-HANDLER to restart the read using the buffer contents.

      ;; Move editor point to where we are reading.
      (MOVE-BP *STREAM-BP*
	       (OR *SRE-INPUT-POINT* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*))))
      (SETQ *SRE-INPUT-POINT* NIL)
      ;; Update buffer display and window data so editor gets consistent data.
      (STREAM-REDISPLAY T)
      ;; Unread this character so editor will execute it.
      (WHEN CHAR (TV:IO-BUFFER-UNGET (SEND *STREAM-SHEET* ':IO-BUFFER) CHAR))
      ;; Edit.
      (SET-IN-CLOSURE EDITOR-CLOSURE '*EDITOR-STREAM-ACTIVATION-NEEDED* NIL)
      ;; PASS-ON characters throw here
      ;; to return from the :ANY-TYI method.
      (*CATCH 'RETURN-FROM-ANY-TYI
	(LET ((*STREAM-IBEAM-SHOULD-BLINK* NIL)
	      (*INSIDE-EDITOR-STREAM* NIL))
	  (BIND (LOCF (TV:SHEET-MORE-VPOS *STREAM-SHEET*)) NIL)
	  (UNLESS (BP-= *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
	    (SEND SELF ':ENTER-EDITOR)
	    (SETQ *STREAM-IBEAM-SHOULD-BLINK* T)
	    (LET ((IBEAM-BLINKER
		    (CDR (ASSQ 'STREAM-BLINK-IBEAM
			       (WINDOW-SPECIAL-BLINKER-LIST *STREAM-SHEET*)))))
	      (WHEN IBEAM-BLINKER
		(STREAM-BLINK-IBEAM IBEAM-BLINKER *STREAM-SHEET* *STREAM-BP* NIL))))
	  (UNWIND-PROTECT
	      (FUNCALL *STREAM-SHEET* ':EDIT EDITOR-CLOSURE)
	    (FUNCALL *STREAM-SHEET* ':EXIT-EDITOR)
	    ;; Put blinker into ordinary stream mode instead of editor mode.
	    (MULTIPLE-VALUE-BIND (X Y) (TV:BLINKER-READ-CURSORPOS *STREAM-BLINKER*)
	      (TV:SHEET-SET-CURSORPOS *STREAM-SHEET* X Y))
	    (FUNCALL *STREAM-BLINKER* ':SET-FOLLOW-P T)	;Make the blinker follow again
	    (TV:BLINKER-SET-VISIBILITY *STREAM-BLINKER*
				       (IF (EQ *STREAM-SHEET* TV:SELECTED-WINDOW)
					   ':BLINK ':ON)))
	  ;; Tell the :RUBOUT-HANDLER method to restart the read.
	  (*THROW 'RUBOUT-HANDLER T))))))

;;; Call editor redisplay from the editing stream.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFUN STREAM-PRE-COMMAND-HOOK-1 (CHAR)
  (COND ((OR (MEMQ CHAR *STREAM-PASS-THROUGH*)
	     (SI:ASSQ-CAREFUL CHAR *STREAM-PASS-THROUGH*))
	 (SETQ *SRE-INPUT-END-BP* (COPY-BP (INTERVAL-LAST-BP *INTERVAL*)))
	 (SETQ *SRE-INPUT-POINT* (COPY-BP *SRE-STREAM-BP*))
	 (MOVE-BP *SRE-STREAM-BP* (INTERVAL-LAST-BP *INTERVAL*))
	 (*THROW 'RETURN-FROM-ANY-TYI CHAR))
	((AND *STREAM-COMMAND-HANDLER*
	      (APPLY (CADR *STREAM-COMMAND-HANDLER*) CHAR (CDDR *STREAM-COMMAND-HANDLER*)))
	 (SEND *SRE-WINDOW* ':SET-*STREAM-COMMAND-POINT*
	       (COPY-BP *SRE-STREAM-BP* ':NORMAL))
	 (MOVE-BP *SRE-STREAM-BP* *SRE-STREAM-START-BP*)
	 (*THROW 'TV:RETURN-FROM-RUBOUT-HANDLER
		 (VALUES
		   `(:COMMAND ,CHAR ,(OR *NUMERIC-ARG* 1))
		   ':COMMAND)))
	((OR (MEMQ CHAR *STREAM-DO-NOT-ECHO*)
	     (AND *STREAM-ACTIVATION-HANDLER*
		  (APPLY (CADR *STREAM-ACTIVATION-HANDLER*)
			 CHAR (CDDR *STREAM-ACTIVATION-HANDLER*))))
	 (SETQ *SRE-ACTIVATION-CHARACTER*
	       (IF (MEMQ CHAR *STREAM-DO-NOT-ECHO*) CHAR
		 `(:ACTIVATION ,CHAR ,(OR *NUMERIC-ARG* 1))))
	 (*THROW 'RUBOUT-HANDLER T)))
  ;; Tell label to change at redisplay after this command finishes,
  ;; so that if this command activates, there will be no change.
  (FUNCALL *WINDOW* ':ENTER-EDITOR)
  ;; Tell the ibeam blinker to start blinking at next redisplay, also.
  (SETQ *STREAM-IBEAM-SHOULD-BLINK* T))

;I'm not really sure what value is right; this will prevent blowouts comparing priorities.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFUN INITIALIZE-STREAM-COMTAB ()
  (COND ((NOT (VARIABLE-BOUNDP *STREAM-COMTAB*))
	 (SETQ *STREAM-COMTAB* (SET-COMTAB NIL '(#\END COM-ACTIVATE
						 #\C-CR COM-ACTIVATE
						 #\CLEAR COM-STREAM-CLEAR
						 #\FF COM-RECENTER-TO-TOP
						 #\C-M-Y COM-YANK-INPUT-HISTORY
						 #\C-H-A COM-QUICK-ARGLIST-INTO-BUFFER)
					   '(("Require Activation Mode"
					      . COM-REQUIRE-ACTIVATION-MODE-1))))
	 (SET-COMTAB-INDIRECTION *STREAM-COMTAB* *STANDARD-COMTAB*))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFCOM COM-YANK-INPUT-HISTORY "Insert the previous input string." ()
  (HISTORY-YANK (SEND *WINDOW* ':*STREAM-INPUT-HISTORY*)))

;;; Special ibeam blinker

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFVAR *ZTOP-PACKAGE* :UNBOUND
  "Current PACKAGE at entry to :RUBOUT-HANDLER on a Ztop stream.
Used to pass changes in current package from editor to execution sg and vice versa.")

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMAJOR COM-ZTOP-MODE ZTOP-MODE "ZTOP"
	  "Sets things up for zmacs buffer editor top level." () 
  (COMMAND-HOOK (MAKE-ZTOP-COMMAND-HOOK *INTERVAL* *WINDOW*) *POST-COMMAND-HOOK*)
  (COMMAND-HOOK (MAKE-ZTOP-PRE-COMMAND-HOOK *INTERVAL* *WINDOW*) *COMMAND-HOOK*)
  (SETQ *SPACE-INDENT-FLAG* T)
  (SETQ *PARAGRAPH-DELIMITER-LIST* NIL)
  (SETQ *COMMENT-START* 'LISP-FIND-COMMENT-START-AND-END)
  (SET-COMTAB *MODE-COMTAB* '(#\END COM-FINISH-ZTOP-EVALUATION
			      #\C-CR COM-FINISH-ZTOP-EVALUATION
			      #\ABORT COM-ZTOP-ABORT
			      #\META-ABORT COM-ZTOP-ABORT-ALL
			      #\C-M-Y COM-ZTOP-YANK-INPUT-HISTORY
			      #\TAB COM-INDENT-FOR-LISP
			      #\RUBOUT COM-TAB-HACKING-RUBOUT
			      #\C-RUBOUT COM-RUBOUT)
	      '(("Require Activation Mode" . COM-REQUIRE-ACTIVATION-MODE)))
  (SETQ *MODE-LINE-LIST*
	(APPEND *MODE-LINE-LIST*
		'((*ZTOP-ACTIVATION-NEEDED* "  Type End to resume reading input")
		  (*ZTOP-READING-INPUT* "  Reading input")
		  (*ZTOP-EDITING* "  Editing"))))
  (PROGN (AND (TYPEP *INTERVAL* 'FILE-BUFFER)
	      (SETQ *LAST-ZTOP-BUFFER* *INTERVAL*))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFUN MAKE-ZTOP-BUFFER (&OPTIONAL (NAME "ZTOP") &AUX BUFFER)
  (SETQ BUFFER (CREATE-ONE-BUFFER-TO-GO NAME))
  (SETF (BUFFER-SAVED-MAJOR-MODE BUFFER) 'ZTOP-MODE)
  (BIND (LOCF (WINDOW-INTERVAL *WINDOW*)) BUFFER)
  (MAKE-ZTOP-COMMAND-HOOK BUFFER *WINDOW*)  
  (MAKE-ZTOP-PRE-COMMAND-HOOK BUFFER *WINDOW*)  
  BUFFER)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFVAR *ZTOP-PRE-COMMAND-HOOK-ALIST* NIL)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFUN MAKE-ZTOP-COMMAND-HOOK (BUFFER WINDOW &AUX ZTOP-STREAM HOOK-CLOSURE HOOK)
  (SETQ *CURRENT-COMMAND-TYPE* 'ZTOP-MODE)
  (COND ((SETQ HOOK (ASSQ BUFFER *ZTOP-COMMAND-HOOK-ALIST*))
	 (SETQ HOOK (CDR HOOK) HOOK-CLOSURE (FSYMEVAL HOOK)
	       ZTOP-STREAM (SYMEVAL-IN-CLOSURE HOOK-CLOSURE '*ZTOP-STREAM*))
	 (FUNCALL ZTOP-STREAM ':SET-STREAM-WINDOW WINDOW))
	(T
	 (SETQ ZTOP-STREAM (LET ((INIT-PLIST (LIST ':*STREAM-SHEET* WINDOW
						   ':*ZMACS-SG* CURRENT-STACK-GROUP
						   ':BUFFER BUFFER)))
			     (INSTANTIATE-FLAVOR 'ZTOP-STREAM-FROM-WINDOW (LOCF INIT-PLIST)
						 T NIL TV:SHEET-AREA)))
	 (SEND BUFFER ':PUTPROP ZTOP-STREAM 'ZTOP-STREAM)
	 (SETQ HOOK-CLOSURE (LET-CLOSED ((*ZTOP-INTERVAL* BUFFER)
					 (*ZTOP-STREAM* ZTOP-STREAM))
					#'(LAMBDA (IGNORE)
					    (AND (EQ *INTERVAL* *ZTOP-INTERVAL*)
						 (FUNCALL *ZTOP-STREAM* ':COMMAND-HOOK
							  *CURRENT-COMMAND-TYPE*))))
	       HOOK (GENSYM))
	 (FSET HOOK HOOK-CLOSURE)
	 (PUTPROP HOOK 1000 'COMMAND-HOOK-PRIORITY)
	 (PUSH (CONS BUFFER HOOK) *ZTOP-COMMAND-HOOK-ALIST*)
	 (SETQ *ZTOP-EDITING* NIL *ZTOP-READING-INPUT* T
	       *ZTOP-ACTIVATION-NEEDED* NIL)))
  HOOK)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFUN MAKE-ZTOP-PRE-COMMAND-HOOK (BUFFER WINDOW &AUX ZTOP-STREAM HOOK-CLOSURE HOOK)
  WINDOW
  (SETQ *CURRENT-COMMAND-TYPE* 'ZTOP-MODE)
  (UNLESS (SETQ HOOK (CDR (ASSQ BUFFER *ZTOP-PRE-COMMAND-HOOK-ALIST*)))
    (SETQ ZTOP-STREAM (GET BUFFER 'ZTOP-STREAM))
    (SETQ HOOK-CLOSURE (LET-CLOSED ((*ZTOP-INTERVAL* BUFFER)
				    (*ZTOP-STREAM* ZTOP-STREAM))
			 #'(LAMBDA (CHAR)
			     (AND (EQ *INTERVAL* *ZTOP-INTERVAL*)
				  (FUNCALL *ZTOP-STREAM* ':PRE-COMMAND-HOOK CHAR))))
	  HOOK (GENSYM))
    (FSET HOOK HOOK-CLOSURE)
    (PUTPROP HOOK 1000 'COMMAND-HOOK-PRIORITY)
    (PUSH (CONS BUFFER HOOK) *ZTOP-PRE-COMMAND-HOOK-ALIST*))
  HOOK)

;;; Special commands used while in ZTOP mode.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFCOM COM-ZTOP-ABORT "Abort program that is running in the Ztop buffer." ()
  (FUNCALL (FUNCALL *INTERVAL* ':GET 'ZTOP-STREAM)
	   ':ZTOP-ABORT)
  DIS-TEXT)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFCOM COM-ZTOP-ABORT-ALL "Abort the running program all the way to top level." ()
  (FUNCALL (FUNCALL *INTERVAL* ':GET 'ZTOP-STREAM)
	   ':ZTOP-ABORT-ALL)
  DIS-TEXT)

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFCOM COM-ZTOP-YANK-INPUT-HISTORY "Yank the previous input." ()
  (HISTORY-YANK (SEND (GET *INTERVAL* 'ZTOP-STREAM) ':*STREAM-INPUT-HISTORY*)))

;;; Define the flavors for the actual streams used by ZTOP.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFFLAVOR ZTOP-STREAM-MIXIN
	(*ZMACS-SG*
	 *ZTOP-SG*
	 *STREAM-START-BP*
	 (*STREAM-ACTIVATION-NEEDED* NIL)
	 (*RUBOUT-HANDLER-ARGS* NIL)
	 (*RUBOUT-HANDLER-STATE* ':NORMAL))
	()
  (:REQUIRED-FLAVORS EDITOR-STREAM-FROM-WINDOW)
  (:INIT-KEYWORDS :BUFFER)
  (:INITABLE-INSTANCE-VARIABLES *ZMACS-SG*)
  (:GETTABLE-INSTANCE-VARIABLES *STREAM-START-BP*))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (ZTOP-STREAM-MIXIN :AFTER :INIT) (INIT-PLIST)
  (SETQ *ZTOP-SG* (MAKE-STACK-GROUP "ZTOP" ':REGULAR-PDL-SIZE 40000
					   ':SPECIAL-PDL-SIZE 4000))
  (SETQ *STREAM-INPUT-HISTORY*
	(MAKE-HISTORY (STRING-APPEND "input history of "
				     (BUFFER-NAME (GET INIT-PLIST ':BUFFER)))))
  (INITIALIZE-ZTOP-SG SELF))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFMETHOD (ZTOP-STREAM-MIXIN :BEFORE :RUBOUT-HANDLER) (ARGS &REST IGNORE)
  (SETQ *STREAM-ACTIVATION-NEEDED* NIL
	*ZTOP-PACKAGE* PACKAGE
	*RUBOUT-HANDLER-ARGS* ARGS
	*RUBOUT-HANDLER-STATE*
	(IF (BP-= *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
	    ':NORMAL ':EDITING)
	*ZTOP-READING-INPUT* (EQ *RUBOUT-HANDLER-STATE* ':NORMAL)
	*ZTOP-EDITING* (NOT *ZTOP-READING-INPUT*)
	*ZTOP-ACTIVATION-NEEDED* NIL))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (ZTOP-STREAM-MIXIN :STREAM-RUBOUT-HANDLER) ()
  ;; If everything has been typed out correctly, update the window datastructure
  (AND (< (WINDOW-REDISPLAY-DEGREE *STREAM-SHEET*) DIS-TEXT)
       (FAKE-OUT-TOP-LINE *STREAM-SHEET* (WINDOW-INTERVAL *STREAM-SHEET*)))
  ;; Avoid confusing the :RUBOUT-HANDLER method after a PASS-THROUGH character.
  (SETQ *SRE-INPUT-END-BP* NIL *SRE-INPUT-POINT* NIL)
  (IF *SRE-ACTIVATION-CHARACTER*
      (PROG1 *SRE-ACTIVATION-CHARACTER*
	     (SETQ *SRE-ACTIVATION-CHARACTER* NIL))
    (SETQ *ZTOP-SG* SYS:%CURRENT-STACK-GROUP)
    (WITH-BP (OLD-STREAM-BP *STREAM-BP* ':NORMAL)
      (LET ((RESUME-INFORMATION (FUNCALL *ZMACS-SG*)))
	(COND ((EQ RESUME-INFORMATION ':RESCAN)
	       (*THROW 'RUBOUT-HANDLER T))
	      ((EQ RESUME-INFORMATION ':KEEP-READING)
	       (MOVE-BP *STREAM-BP* OLD-STREAM-BP)
	       (FUNCALL-SELF ':ANY-TYI))
	      ((EQ (CAR RESUME-INFORMATION) ':PASS-THROUGH)
	       (SETQ *SRE-INPUT-END-BP* (CADR RESUME-INFORMATION)
		     *SRE-INPUT-POINT* (CADDR RESUME-INFORMATION))
	       (CADDDR RESUME-INFORMATION))
	      ((EQ (CAR RESUME-INFORMATION) ':COMMAND)
	       (SETQ *STREAM-COMMAND-POINT*
		     (COPY-BP *STREAM-BP* ':NORMAL))
	       (MOVE-BP *STREAM-BP* *STREAM-START-BP*)
	       (*THROW 'TV:RETURN-FROM-RUBOUT-HANDLER
		       (VALUES (CADR RESUME-INFORMATION) ':COMMAND)))
	      ((EQ (CAR RESUME-INFORMATION) ':ACTIVATION)
	       (SETQ *SRE-ACTIVATION-CHARACTER*
		     (CADR RESUME-INFORMATION))
	       (*THROW 'RUBOUT-HANDLER T)))))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (ZTOP-STREAM-MIXIN :PRE-COMMAND-HOOK)
	   (CHAR &AUX
	    (PASS-THROUGH (CDR (ASSQ ':PASS-THROUGH *RUBOUT-HANDLER-ARGS*)))
	    (DO-NOT-ECHO (CDR (ASSQ ':DO-NOT-ECHO *RUBOUT-HANDLER-ARGS*)))
	    (COMMAND-HANDLER (ASSQ ':COMMAND *RUBOUT-HANDLER-ARGS*))
	    (ACTIVATION-HANDLER (ASSQ ':ACTIVATION *RUBOUT-HANDLER-ARGS*)))
  (COND ((OR (MEMQ CHAR PASS-THROUGH)
	     (SI:ASSQ-CAREFUL CHAR PASS-THROUGH))
	 (RESUME-ZTOP-SG
	   (PROG1
	     `(:PASS-THROUGH
		,(COPY-BP (INTERVAL-LAST-BP *INTERVAL*))
		,(COPY-BP (POINT))
		,CHAR)
	     (MOVE-BP (POINT) (INTERVAL-LAST-BP *INTERVAL*))))
	 (SETQ *CURRENT-COMMAND-TYPE* 'PASS-THROUGH)
	 (*THROW 'COMMAND-EXECUTE T))
	((AND COMMAND-HANDLER
	      (APPLY (CADR COMMAND-HANDLER) CHAR (CDDR COMMAND-HANDLER)))
	 (RESUME-ZTOP-SG
	   `(:COMMAND
	      (:COMMAND ,CHAR ,(OR *NUMERIC-ARG* 1))))
	 (SETQ *CURRENT-COMMAND-TYPE* 'PASS-THROUGH)
	 (*THROW 'COMMAND-EXECUTE T))
	((OR (MEMQ CHAR DO-NOT-ECHO)
	     (AND ACTIVATION-HANDLER
		  (APPLY (CADR ACTIVATION-HANDLER)
			 CHAR (CDDR ACTIVATION-HANDLER))))
	 (SETQ *RUBOUT-HANDLER-STATE* ':NORMAL)
	 (SETQ *ZTOP-ACTIVATION-NEEDED* NIL
	       *ZTOP-EDITING* NIL
	       *ZTOP-READING-INPUT* T)
	 (REDISPLAY-MODE-LINE)
	 (RESUME-ZTOP-SG
	   `(:ACTIVATION
	      ,(IF (MEMQ CHAR DO-NOT-ECHO) CHAR
		 `(:ACTIVATION ,CHAR ,(OR *NUMERIC-ARG* 1)))))
	 (SETQ *CURRENT-COMMAND-TYPE* 'ACTIVATE-ZTOP)
	 (*THROW 'COMMAND-EXECUTE T))))

;;; This gets called by the editor after each command

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (ZTOP-STREAM-MIXIN :COMMAND-HOOK) (TYPE &AUX (OLD-STATE *RUBOUT-HANDLER-STATE*))
  (UNLESS (EQ TYPE 'PASS-THROUGH)
    (AND (ASSQ ':FULL-RUBOUT *RUBOUT-HANDLER-ARGS*) (BP-= *STREAM-START-BP* *STREAM-BP*)
	 (SETQ OLD-STATE ':EDITING TYPE ':FULL-RUBOUT))
    (SETQ *RUBOUT-HANDLER-STATE*
	  (IF (AND (BP-= *STREAM-BP* (INTERVAL-LAST-BP (WINDOW-INTERVAL *STREAM-SHEET*)))
		   (OR (NOT *STREAM-ACTIVATION-NEEDED*)
		       (EQ TYPE 'ACTIVATE-ZTOP))
		   (MEMQ TYPE '(SELF-INSERT INSERT-CR ACTIVATE-ZTOP ZTOP-MODE :FULL-RUBOUT)))
	      ':NORMAL
	    ':EDITING))
    (IF (EQ *RUBOUT-HANDLER-STATE* ':EDITING)
	(SETQ *STREAM-ACTIVATION-NEEDED* *ZTOP-REQUIRE-ACTIVATION*)
      (AND (NEQ OLD-STATE ':NORMAL)		;If we were editing
	   (MOVE-BP *STREAM-BP* *STREAM-START-BP*))
      (SETQ *ZMACS-SG* SYS:%CURRENT-STACK-GROUP)
      (RESUME-ZTOP-SG (IF (EQ OLD-STATE ':EDITING) ':RESCAN ':KEEP-READING))
      (AND (NEQ OLD-STATE ':NORMAL)
	   (MUST-REDISPLAY *STREAM-SHEET* DIS-BPS))))
  (SETQ *ZTOP-ACTIVATION-NEEDED* *STREAM-ACTIVATION-NEEDED*)
  (SETQ *ZTOP-EDITING*
	(AND (NOT *ZTOP-ACTIVATION-NEEDED*)
	     (EQ *RUBOUT-HANDLER-STATE* ':EDITING)))
  (SETQ *ZTOP-READING-INPUT* (AND (NOT *ZTOP-ACTIVATION-NEEDED*) (NOT *ZTOP-EDITING*))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "


(DEFUN RESUME-ZTOP-SG (ARG)
  (DECLARE (:SELF-FLAVOR ZTOP-STREAM-MIXIN))
  (FUNCALL CURRENT-PROCESS ':ADD-COROUTINE-STACK-GROUP *ZTOP-SG*)
  ;; If the editor has changed our package, tell the execution SG.
  (MULTIPLE-VALUE-BIND (VALUE LOC)
      (SYMEVAL-IN-STACK-GROUP '*ZTOP-PACKAGE* *ZTOP-SG*)
    (UNLESS (EQ VALUE PACKAGE)
      (SETF (CONTENTS LOC) PACKAGE)
      (MULTIPLE-VALUE-BIND (NIL LOC)
	  (SYMEVAL-IN-STACK-GROUP 'PACKAGE *ZTOP-SG*)
	(SETF (CONTENTS LOC) PACKAGE))))
  (LET ((NORMAL-EXIT-P NIL))
    (UNWIND-PROTECT
	(PROG1
	  (FUNCALL *ZTOP-SG* ARG)
	  (SETQ NORMAL-EXIT-P T)
	  ;; If the execution SG has changed its package, propagate to editor.
	  (SETQ PACKAGE (SYMEVAL-IN-STACK-GROUP '*ZTOP-PACKAGE* *ZTOP-SG*))
	  (SETF (BUFFER-PACKAGE *INTERVAL*) PACKAGE))
      (OR NORMAL-EXIT-P
	  (INITIALIZE-ZTOP-SG SELF)))))

;Decide whether and where to blink the ibeam blinker.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (ZTOP-STREAM-MIXIN :COMPUTE-BLINKER-POSITION) (BP)
  (AND (EQ (BP-TOP-LEVEL-NODE BP) (BP-TOP-LEVEL-NODE *STREAM-START-BP*))
      (NOT *ZTOP-READING-INPUT*)
       (FIND-BP-IN-WINDOW-COORDS *STREAM-START-BP* *STREAM-SHEET*)))

;Executed in the editor sg to abort the execution sg.

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (ZTOP-STREAM-MIXIN :ZTOP-ABORT-ALL) ()
  (EH:SG-APPLY-NO-TRAP *ZTOP-SG* 'TV:KBD-INTERCEPT-ABORT-ALL '(#\M-ABORT) T T))

))

; From file COMC.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; COMC  "

(DEFUN COMPILE-PRINT-INTERVAL (BP1 BP2 IN-ORDER-P COMPILE-P REGION-NAME MODE-NAME ECHO-NAME
			       &OPTIONAL USE-TYPEOUT DEFVAR-HACK
			       COMPILER-PROCESSING-MODE
			       ALREADY-RESECTIONIZED-FLAG
			       &AUX FORMAT-FUNCTION SUCCESS)
  "Compile or evaluate the interval specified by BP1, BP2, IN-ORDER-P.
COMPILE-P is T to compile, NIL to eval, or else a function to evaluate and print a form.
REGION-NAME is a string to print as the name of this whole object,
 or NIL to mention each object's name.
USE-TYPEOUT can be T, NIL, :TYPEOUT or :PROMPT.
  T prints form values and names of objects in typeout window.
 Otherwise, form values appear in the echo area, and 
  :TYPEOUT prints names of objects in typeout window.
  :PROMPT prints names of objects in prompt line.
  NIL prints names of objects in the echo area.
DEFVAR-HACK says always re-set variables if DEFVARs are evaluated.
 Normally this is only done if there is no region.
COMPILE-PROCESSING-MODE is either COMPILER:MACRO-COMPILE or COMPILER:MICRO-COMPILE.
ALREADY-RESECTIONIZED-FLAG should be T to inhibit resectionization.
MODE-NAME is a string containing a capitalized present participle, such as /"Compiling/".
ECHO-NAME is a string containing a lowecase past participle and period (/"compiled./")."
  (OR COMPILER-PROCESSING-MODE
      (SETQ COMPILER-PROCESSING-MODE 'COMPILER:MACRO-COMPILE))
  (GET-INTERVAL BP1 BP2 IN-ORDER-P)
  (UNLESS ALREADY-RESECTIONIZED-FLAG
    (CHECK-INTERVAL-SECTIONS BP1 BP2 T))
  (UNDO-SAVE-CURRENT-RANGE)
  (SETQ FORMAT-FUNCTION (SELECTQ USE-TYPEOUT
			  ((T :TYPEOUT) #'(LAMBDA (STRING &REST ARGS)
					    (LEXPR-FUNCALL #'FORMAT T
							   STRING ARGS)))
			  (:PROMPT #'PROMPT-LINE-MORE)
			  (OTHERWISE #'(LAMBDA (STRING &REST ARGS)
					(LEXPR-FUNCALL #'FORMAT QUERY-IO
						       STRING ARGS)))))
  (IF REGION-NAME
      (FUNCALL FORMAT-FUNCTION "~&~A ~A" MODE-NAME REGION-NAME)
    (FUNCALL FORMAT-FUNCTION "~&~A ~S" MODE-NAME (SECTION-NODE-NAME (BP-NODE BP1))))
  (UNWIND-PROTECT
    (PROGN
      (COMPILE-INTERVAL COMPILE-P
			(SELECTQ USE-TYPEOUT
			  ((T) T)
			  (T QUERY-IO))
			DEFVAR-HACK BP1 BP2 T
			COMPILER-PROCESSING-MODE)
      (SETQ SUCCESS T))
    (OR SUCCESS
	(FUNCALL FORMAT-FUNCTION " -- aborted.")))
  (FUNCALL FORMAT-FUNCTION " -- ~A" ECHO-NAME)
  (UPDATE-INTERVAL-COMPILE-TICK BP1 BP2 T))

))

; From file PATED.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; PATED  "

(DEFUN ADD-PATCH-INTERVAL (BP1 BP2 IN-ORDER-P DEFUN-NAME BUFFER &AUX NEW-PATCH-BUFFER-P)
  (GET-INTERVAL BP1 BP2 IN-ORDER-P)
  (VALIDATE-PATCH-BUFFER)
  (SETQ NEW-PATCH-BUFFER-P (NULL *PATCH-BUFFER*))
  (AND NEW-PATCH-BUFFER-P (CREATE-NEW-PATCH (READ-PATCH-SYSTEM-NAME)))
  (IF (STRINGP DEFUN-NAME)
      (FORMAT QUERY-IO
	      "~&Adding ~A to patch file ~A~:[~;~%(New patch file.)~]"
	      DEFUN-NAME (PATCH-VERSION-DESCRIPTION) NEW-PATCH-BUFFER-P)
    (FORMAT QUERY-IO
	    "~&Adding ~S to patch file ~A~:[~;~%(New patch file.)~]"
	    DEFUN-NAME (PATCH-VERSION-DESCRIPTION) NEW-PATCH-BUFFER-P))
  (LET ((BP (INTERVAL-LAST-BP *PATCH-BUFFER*)))
    ;; Put into the patch buffer, making sure the right package and base will be used.
    (MULTIPLE-VALUE-BIND (VARS VALS)
	(SEND BUFFER ':ATTRIBUTE-BINDINGS)
      (PROGV VARS VALS
	     (INSERT BP (FORMAT NIL "~%; From file ~A~%#~DR ~A#:
/(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE /"~:*~A/")))
/  (COMPILER#:PATCH-SOURCE-FILE ~S

"
				(BUFFER-NAME BUFFER) IBASE PACKAGE
				(WHEN (BUFFER-GENERIC-PATHNAME BUFFER)
				  (SEND (BUFFER-GENERIC-PATHNAME BUFFER)
					':STRING-FOR-PRINTING))))))
    (INSERT-INTERVAL BP BP1 BP2 T)
    (INSERT BP "
))
"))
  ;; Mark all sections that the region contains part of
  ;; as having been patched.
  (INTERVAL-LINES (BP1 BP2) (START-LINE END-LINE)
    (DO ((LINE START-LINE (LINE-NEXT LINE))
	 (LAST-SECTION))
	((EQ LINE END-LINE))
      (LET ((SECTION (LINE-NODE LINE)))
	(UNLESS (EQ LAST-SECTION SECTION)
	  (PUTPROP SECTION *TICK* 'PATCH-TICK))
	(SETQ LAST-SECTION SECTION)))))

))

; From file RH.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; RH  "

(DEFUN-RH RH-YANK-FROM-HISTORY (THING &OPTIONAL
				   (KILL-PREVIOUS (TYPEP *LAST-COMMAND-TYPE* 'ZWEI:HISTORY)))
  (WHEN KILL-PREVIOUS
    (RH-DELETE-STRING (MIN (RH-TYPEIN-POINTER) *RUBOUT-HANDLER-MARK*)
		      (MAX (RH-TYPEIN-POINTER) *RUBOUT-HANDLER-MARK*)
		      NIL))
  (LET ((POS (RH-TYPEIN-POINTER)))
    (WHEN THING
      (LET ((STRING (IF (ARRAYP THING) THING (ZWEI:STRING-INTERVAL THING))))
	(RH-INSERT-STRING (STRING-REMOVE-FONTS STRING) 0 NIL T NIL)))
    (SETQ *RUBOUT-HANDLER-MARK* POS)))

))

; From file QCFILE.LISP SRC:<L.SYS> OZ:
#8R COMPILER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "COMPILER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QCFILE  "

(DEFUN COMPILE-DRIVER (FORM PROCESS-FN OVERRIDE-FN &OPTIONAL COMPILE-TIME-TOO)
  (PROG TOP (FN (OFORM FORM))
    ;; The following loop is essentially MACROEXPAND,
    ;; but for each expansion, we create an appropriate warn-on-errors message
    ;; containing the name of the macro about to be (perhaps) expanded this time.
    (DO ((NFORM))
	(())
      (IF (AND OVERRIDE-FN
	       (FUNCALL OVERRIDE-FN FORM))
	  (RETURN-FROM TOP NIL))
      (IF (ATOM FORM) (RETURN NIL))
      (SETQ NFORM
	    (WARN-ON-ERRORS ('MACRO-EXPANSION-ERROR "Error expanding macro ~S at top level"
			     (CAR FORM))
	      (MACROEXPAND-1 FORM)))
      (IF (EQ FORM NFORM) (RETURN)
	(SETQ FORM NFORM)))
    ;; If this was a top-level macro, supply a good guess
    ;; for the function-parent for any DEFUNs inside the expansion.
    (LET ((LOCAL-DECLARATIONS LOCAL-DECLARATIONS))
      (COND ((ATOM FORM))
	    ((AND (NEQ FORM OFORM) (SYMBOLP (CADR OFORM)))
	     (PUSH `(FUNCTION-PARENT ,(CADR OFORM)) LOCAL-DECLARATIONS))
	    ((MEMQ (CAR OFORM) '(DEFSTRUCT :DEFSTRUCT))
	     (PUSH `(FUNCTION-PARENT ,(IF (SYMBOLP (CADR OFORM)) (CADR OFORM) (CAADR OFORM)))
		   LOCAL-DECLARATIONS)))
      (AND (CONSP FORM)
	   (NEQ (CAR FORM) 'EVAL-WHEN)
	   COMPILE-TIME-TOO
	   (FUNCALL PROCESS-FN FORM 'DECLARE))
      (COND ((ATOM FORM)
	     (FUNCALL PROCESS-FN FORM 'RANDOM))
	    ((EQ (CAR FORM) 'EVAL-WHEN)
	     (OR (AND (OR (NOT (ATOM (CADR FORM))) (NULL (CADR FORM)))	;LISTP eventually
		      (LOOP FOR TIME IN (CADR FORM)
			    ALWAYS (MEMQ TIME '(EVAL LOAD COMPILE))))
		 (FERROR NIL "~S invalid EVAL-WHEN times;
must be a list of EVAL, LOAD, and//or COMPILE."
			     (CADR FORM)))
	     (LET* ((COMPILE (MEMQ 'COMPILE (CADR FORM)))
		    (LOAD (MEMQ 'LOAD (CADR FORM)))
		    (EVAL (MEMQ 'EVAL (CADR FORM)))
		    (EVAL-NOW (OR COMPILE (AND COMPILE-TIME-TOO EVAL))))
	       (DOLIST (FORM1 (CDDR FORM))
		 (IF LOAD
		     (IF EVAL-NOW
			 (COMPILE-DRIVER FORM1 PROCESS-FN OVERRIDE-FN T)
		       (COMPILE-DRIVER FORM1 PROCESS-FN OVERRIDE-FN))
		   (IF EVAL-NOW
		       (FUNCALL PROCESS-FN FORM1 'DECLARE))))))
	    ((EQ (SETQ FN (CAR FORM)) 'DEFF)
	     (COMPILATION-DEFINE (CADR FORM))
	     (FUNCALL PROCESS-FN FORM 'RANDOM))
	    ((EQ FN 'DEF)
	     (COMPILATION-DEFINE (CADR FORM))
	     (MAPC (FUNCTION (LAMBDA (FORM)
		       (COMPILE-DRIVER FORM PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)))
		   (CDDR FORM)))
	    ((EQ FN 'WITH-SELF-ACCESSIBLE)
	     (MAPC (FUNCTION (LAMBDA (FORM)
		       (COMPILE-DRIVER FORM PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)))
		   (CDDR FORM)))
	    ((EQ FN 'PROGN)
	     (MAPC (FUNCTION (LAMBDA (FORM)
		       (COMPILE-DRIVER FORM PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)))
		   (CDR FORM)))
	    ((MEMQ FN '(MACRO DEFSUBST))
	     (FUNCALL PROCESS-FN FORM 'MACRO))
	    ((MEMQ FN '(SPECIAL UNSPECIAL MAKE-PACKAGE IN-PACKAGE SHADOW SHADOWING-IMPORT
				EXPORT UNEXPORT USE-PACKAGE UNUSE-PACKAGE IMPORT DEFF-MACRO))
	     (FUNCALL PROCESS-FN FORM 'SPECIAL))
	    ((EQ FN 'DECLARE)
	     (COMPILE-DECLARE (CDR FORM) PROCESS-FN))
	    ((EQ FN 'COMMENT) NIL)
	    ((EQ FN 'PATCH-SOURCE-FILE)
	     (COMPILE-DRIVER `(EVAL-WHEN (LOAD EVAL)
				(SETQ SI:PATCH-SOURCE-FILE-NAMESTRING ,(CADR FORM)))
			     PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)
	     (MAPC (FUNCTION (LAMBDA (FORM)
			       (COMPILE-DRIVER FORM PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)))
		   (CDDR FORM))
	     (COMPILE-DRIVER `(EVAL-WHEN (LOAD EVAL)
				(SETQ SI:PATCH-SOURCE-FILE-NAMESTRING NIL))
			     PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO))
	    ((EQ FN 'COMPILER-LET)
	     (EVAL `(LET ,(CADR FORM) (COMPILE-DRIVER '(PROGN 'COMPILE . ,(CDDR FORM))
						      ',PROCESS-FN ',OVERRIDE-FN
						      ,COMPILE-TIME-TOO))))
	    ((EQ FN 'DEFUN)
	     (LET (TEM)
	       (WARN-ON-ERRORS ('MALFORMED-DEFUN "Malformed defun")
		 (SETQ TEM (DEFUN-COMPATIBILITY (CDR FORM))))
	       (COND ((EQ (CDR TEM) (CDR FORM))
		      (IF (NULL (CDDR TEM))
			  (WARN 'MALFORMED-DEFUN ':IMPOSSIBLE
				"Malformed defun ~S" FORM)
			(FUNCALL PROCESS-FN FORM 'DEFUN)))
		     (T (COMPILE-DRIVER TEM PROCESS-FN OVERRIDE-FN COMPILE-TIME-TOO)))))
	    (T (FUNCALL PROCESS-FN FORM 'RANDOM))))))

))

; From file COLD.LISP SRC:<L.WINDOW> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; COLD  "


(DEFMETHOD-IMMEDIATE (COLD-LOAD-STREAM :ANY-TYI) (&OPTIONAL IGNORE)
  (FUNCALL COLD-LOAD-STREAM ':TYI))

(DEFMETHOD-IMMEDIATE (COLD-LOAD-STREAM :ANY-TYI-NO-HANG) ()
  (FUNCALL COLD-LOAD-STREAM ':TYI-NO-HANG))

))

; From file COLD.LISP SRC:<L.WINDOW> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; COLD  "

(SETF (AREF (INSTANCE-FLAVOR COLD-LOAD-STREAM) 3)
      (%MAKE-POINTER DTP-SELECT-METHOD
		     `((:ANY-TYI . COLD-LOAD-STREAM-ANY-TYI-METHOD)
		       (:ANY-TYI-NO-HANG . COLD-LOAD-STREAM-ANY-TYI-METHOD-NO-HANG)
		       . ,(%MAKE-POINTER DTP-LIST
					 (AREF (INSTANCE-FLAVOR COLD-LOAD-STREAM) 3)))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN READLINE (&REST READ-ARGS)
  "Read a line from STREAM and return it as a string.
The string does not include a Return character, and is empty for a blank line.
If EOF-OPTION is non-NIL, it is returned on end of file at beginning of line;
 otherwise, end of file with no text first is an error.
End of file after reading some text is never an error.

If the stream supports the :RUBOUT-HANDLER operation, we use it.
OPTIONS is a list of rubout handler options, passed to :RUBOUT-HANDLER if it is used.

The second value is T if we exit due to end of file."
  (DECLARE (ARGLIST &OPTIONAL STREAM EOF-OPTION OPTIONS)
	   (VALUES STRING-OR-EOF-OPTION EOF-FLAG))
  (LET ((OPTIONS NIL))
    ;; This kludge is to let us take a third, optional argument.
    (COND ((> (LENGTH READ-ARGS) 2)
	   (SETQ OPTIONS (THIRD READ-ARGS))
	   (SETQ READ-ARGS (LIST (FIRST READ-ARGS) (SECOND READ-ARGS)))))
    (MULTIPLE-VALUE-BIND (STREAM EOF-OPTION)
	(DECODE-READ-ARGS READ-ARGS)
      (READ-DELIMITED-STRING '(#\RETURN #\END) STREAM
			     (NEQ EOF-OPTION 'NO-EOF-OPTION) OPTIONS))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN READ-LINE (&OPTIONAL (STREAM STANDARD-INPUT) IGNORE OPTIONS)
  "Read a line from STREAM and return it as a string.
The string does not include a Return character, and is empty for a blank line.
The second value is T if the line was terminated by EOF.
If the stream supports the :RUBOUT-HANDLER operation, we use it.
OPTIONS is a list of rubout handler options, passed to :RUBOUT-HANDLER if it is used."
  (DECLARE (VALUES LINE EOF-FLAG))
  (READ-DELIMITED-STRING '(#\RETURN #\END)
			 (COND ((NULL STREAM) STANDARD-INPUT)
			       ((EQ STREAM T) TERMINAL-IO)
			       (T STREAM))
			 NIL OPTIONS))

))

; From file QRAND.LISP SRC:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QRAND  "

(DEFUN RECORD-SOURCE-FILE-NAME (FUNCTION-SPEC
				&OPTIONAL (TYPE 'DEFUN)
					  (NO-QUERY (EQ INHIBIT-FDEFINE-WARNINGS T))
				&AUX (DEFAULT-CONS-AREA BACKGROUND-CONS-AREA))
  "Record a definition of FUNCTION-SPEC, of type TYPE, in the current source file.
The source file's generic-pathname is found in FDEFINE-FILE-PATHNAME.
FUNCTION-SPEC is actually only a function spec if TYPE is 'DEFUN,
which is the default.  If TYPE is 'DEFVAR, the first arg is a variable name, etc.
NO-QUERY inhibits warnings about redefinition in a different file.

The value is T if you should go ahead and perform the definition,
NIL if the user was asked and said no."
  ;; When defining a function in a patch, record it as coming
  ;; from its real source file.  So the editor knows where to find it.
  (IF (AND FS:THIS-IS-A-PATCH-FILE PATCH-SOURCE-FILE-NAMESTRING)
      (LET* ((FDEFINE-FILE-DEFINITIONS NIL)
	     (FDEFINE-FILE-PATHNAME
	       (SEND (FS:PARSE-PATHNAME PATCH-SOURCE-FILE-NAMESTRING) ':GENERIC-PATHNAME))
	     (PATCH-SOURCE-FILE-NAMESTRING NIL)
	     (PKG-SPEC (SEND FDEFINE-FILE-PATHNAME ':GET ':PACKAGE))
	     (PACKAGE (OR (PKG-FIND-PACKAGE PKG-SPEC ':FIND) PACKAGE)))
	;; Record the source file as having defined this function.
	;; THIS-IS-A-PATCH-FILE is still set, to prevent querying,
	;; but PATCH-SOURCE-FILE-NAMESTRING is not, so we don't recurse forever.
	(RECORD-SOURCE-FILE-NAME FUNCTION-SPEC TYPE NO-QUERY)
	;; Add the function to the source's list of definitions.
	(RECORD-FILE-DEFINITIONS FDEFINE-FILE-PATHNAME FDEFINE-FILE-DEFINITIONS
				 NIL FDEFINE-FILE-PATHNAME)))
  (LET ((PATHNAME FDEFINE-FILE-PATHNAME)
	(DEF (CONS-IN-AREA FUNCTION-SPEC TYPE BACKGROUND-CONS-AREA))
	(PROPERTY (FUNCTION-SPEC-GET FUNCTION-SPEC ':SOURCE-FILE-NAME)))
    (OR (NULL FDEFINE-FILE-PATHNAME)
	(MEMBER DEF FDEFINE-FILE-DEFINITIONS)
	(SETQ FDEFINE-FILE-DEFINITIONS
	      (CONS-IN-AREA DEF FDEFINE-FILE-DEFINITIONS BACKGROUND-CONS-AREA)))
    (COND ((AND (NULL PROPERTY)			;Check most common case first
		(EQ TYPE 'DEFUN))
	   ;; We don't record the keyboard as a "source file"
	   ;; so things like the editor don't get confused.
	   (IF FDEFINE-FILE-PATHNAME
	       (FUNCTION-SPEC-PUTPROP FUNCTION-SPEC PATHNAME ':SOURCE-FILE-NAME))
	   T)
	  ((IF (ATOM PROPERTY)
	       (AND (EQ TYPE 'DEFUN) (EQ PATHNAME PROPERTY))
	     (EQ PATHNAME (CADR (ASSQ TYPE PROPERTY))))
	   T)					;This pathname already known
	  (T
	   (AND PROPERTY (ATOM PROPERTY)
		(SETQ PROPERTY `((DEFUN ,PROPERTY))))
	   (LET ((THIS-TYPE (ASSQ TYPE PROPERTY))
		 (OLD-FILE))
	     (COND ((COND ((NULL THIS-TYPE)
			   (IF FDEFINE-FILE-PATHNAME
			       (SETQ THIS-TYPE `(,TYPE)
				     PROPERTY (NCONC PROPERTY
						     (NCONS THIS-TYPE))))
			   T)
			  (NO-QUERY T)
			  (FS:THIS-IS-A-PATCH-FILE T)
			  ((AND (NOT FDEFINE-FILE-PATHNAME)
				(MEMBER FUNCTION-SPEC NON-FILE-REDEFINED-FUNCTIONS))
			   ;; If user has ever confirmed redefining this fn from the kbd,
			   ;; it is ok to do so again.
			   T)
			  ;; Before format is loaded, don't bomb out trying to query.
			  ((NOT (FBOUNDP 'FQUERY)) T)
			  ;; If all the old definitions are from patch files, don't query.
			  ((NULL (SETQ OLD-FILE
				       (LOOP FOR FILE IN (CDR THIS-TYPE)
					     UNLESS (OR (STRINGP FILE)	;During QLD
							(FUNCALL FILE ':GET
								 ':PATCH-FILE))
					     RETURN FILE)))
			   T)
			  ((QUERY-ABOUT-REDEFINITION FUNCTION-SPEC PATHNAME TYPE
						     OLD-FILE)
			   ;; Though we don't record the keyboard as a "source file",
			   ;; once the user confirms redefining a certain function
			   ;; from the keyboard, we don't ever ask about it again.
			   (UNLESS FDEFINE-FILE-PATHNAME
			     (PUSH FUNCTION-SPEC NON-FILE-REDEFINED-FUNCTIONS))
			   T))
		    ;; We don't record the keyboard as a "source file"
		    ;; so things like the editor don't get confused.
		    (WHEN FDEFINE-FILE-PATHNAME
		      (SETF (CDR THIS-TYPE)
			    (CONS PATHNAME (DELQ PATHNAME (CDR THIS-TYPE))))
		      (FUNCTION-SPEC-PUTPROP FUNCTION-SPEC PROPERTY ':SOURCE-FILE-NAME))
		    T)
		   (T NIL)))))))

))

; From file COMC.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; COMC  "

(DEFUN UPDATE-INTERVAL-COMPILE-TICK (BP1 &OPTIONAL BP2 IN-ORDER-P)
  "Update the tick-of-last-compilation for all sections in an interval.
Pass either an interval or a pair of BPs."
  (TICK)
  (GET-INTERVAL BP1 BP2 IN-ORDER-P)
  (DO ((NODE (BP-NODE BP1) (NODE-NEXT NODE))
       (FIRST T NIL))
      ((OR (NULL NODE)
	   (NOT (OR FIRST (BP-< (INTERVAL-FIRST-BP NODE) BP2)))))
    (WHEN (OR (NOT FIRST)
	      ;; If compiled or evaluated only part of the text in a node,
	      ;; don't set its compile tick.
	      ;; Now that there is only one form per section,
	      ;; we can be confident that if the compiled code
	      ;; started at the beginning of the form,
	      ;; it must have reached the end,
	      ;; unless either the compilation bombed out from unmatched parens
	      ;; or the section contains unmatched parens.
	      (EQ (BP-LINE BP1) (SECTION-NODE-DEFUN-LINE NODE))
	      (EQ (BP-LINE BP1) (BP-LINE (INTERVAL-FIRST-BP NODE)))
	      (AND (SECTION-NODE-DEFUN-LINE NODE)
		   (BP-< BP1 (CREATE-BP (SECTION-NODE-DEFUN-LINE NODE) 0))))
      (SEND NODE ':UPDATE-COMPILE-TICK))))

))

; From file COMC.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; COMC  "

(DEFUN COMPILE-INTERVAL (COMPILE-P PRINT-RESULTS-STREAM DEFVAR-HACK
			 BP1 &OPTIONAL BP2 IN-ORDER-P
			 (COMPILE-PROCESSING-MODE 'COMPILER:MACRO-COMPILE)
			 &AUX GENERIC-PATHNAME STREAM
			      WHOLE-FILE   ;T if processing the entire file.
			      SI:FDEFINE-FILE-DEFINITIONS)
  "Compile or evaluate the interval specified by BP1, BP2, IN-ORDER-P.
Does not print any sort of message saying what is being compiled,
does not know about sectionization.
COMPILE-P is T to compile, NIL to eval, or else a function to evaluate and print a form.
PRINT-RESULTS-STREAM is a stream for printing the results of evaluation, or NIL not to print.
DEFVAR-HACK says always re-set variables if DEFVARs are evaluated.
 Normally this is only done if there is no region.
COMPILE-PROCESSING-MODE is either COMPILER:MACRO-COMPILE or COMPILER:MICRO-COMPILE.
ALREADY-RESECTIONIZED-FLAG should be T to inhibit resectionization."
  (DECLARE (SPECIAL COMPILE-P PRINT-RESULTS-STREAM DEFVAR-HACK COMPILE-PROCESSING-MODE))
  (SETQ GENERIC-PATHNAME (SEND *INTERVAL* ':GENERIC-PATHNAME))
  ;; Does not reparse the mode line; we should let the user decide whether to do that.!
  ;; Should not override the user's Set Package if he has done one.
  (GET-INTERVAL BP1 BP2 IN-ORDER-P)
  ;; Decide whether the entire file is being processed or just a part.
  ;; If the whole file, we want to notice if any function present in the file previously
  ;; is now missing.  If just a part, anything we don't notice now we must assume
  ;; is elsewhere in the file.
  (SETQ WHOLE-FILE
	(AND (BP-= BP1 (INTERVAL-FIRST-BP *INTERVAL*))
	     (BP-= BP2 (INTERVAL-LAST-BP *INTERVAL*))))
  (SETQ STREAM (INTERVAL-STREAM BP1 BP2 T))
  ;; Arrange for first read-error's location to be saved in q-reg ".".
  (REMPROP (MAKE-REGISTER-NAME #/.) 'POINT)
  (LET (SI:INTERPRETER-ENVIRONMENT (SI:INTERPRETER-FUNCTION-ENVIRONMENT T))
    (MULTIPLE-VALUE-BIND (VARS VALS) (SEND *INTERVAL* ':ATTRIBUTE-BINDINGS)
      (PROGV VARS VALS
	(WHEN FS:THIS-IS-A-PATCH-FILE
	  ;; If compiling out of the editor buffer of a patch file,
	  ;; make sure the file itself is marked
	  ;; so that Meta-. will behave right.
	  (PUTPROP GENERIC-PATHNAME T ':PATCH-FILE))
	;; Bind off this flag -- our stream is not generating font changes
	;; so READ should not try to remove any.
	(LET ((SI:READ-DISCARD-FONT-CHANGES NIL))
	  (FLET ((DO-IT ()
			(COMPILER:COMPILE-STREAM
			  STREAM
			  GENERIC-PATHNAME
			  NIL			;FASD-FLAG
			  'COMPILE-INTERVAL-PROCESS-FN
			  T			;QC-FILE-LOAD-FLAG
			  NIL			;QC-FILE-IN-CORE-FLAG
			  PACKAGE
			  NIL			;FILE-LOCAL-DECLARATIONS
			  NIL			;Unused
			  WHOLE-FILE)))
	    (IF COMPILE-P
		(COMPILER:LOCKING-RESOURCES-NO-QFASL (DO-IT))
	      (DO-IT)))))))
  (OR (NULL GENERIC-PATHNAME)
      (SI:RECORD-FILE-DEFINITIONS GENERIC-PATHNAME SI:FDEFINE-FILE-DEFINITIONS WHOLE-FILE)))

))

; From file STREAM.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; STREAM  "

(DEFVAR RUBOUT-HANDLER-ACTIVATION-CHARACTER NIL
  "The character or blip that is activating this invocation of :RUBOUT-HANDLER.")

))

; From file STREAM.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; STREAM  "

(DEFMETHOD (STREAM-MIXIN :RUBOUT-HANDLER) (RUBOUT-HANDLER-OPTIONS FUNCTION &REST ARGS)
  (COND ((> (RHB-FILL-POINTER) (RHB-SCAN-POINTER))
	 (COPY-ARRAY-PORTION RUBOUT-HANDLER-BUFFER (RHB-SCAN-POINTER) (RHB-FILL-POINTER)
			     RUBOUT-HANDLER-BUFFER 0 (ARRAY-LENGTH RUBOUT-HANDLER-BUFFER))
	 (IF (NUMBERP (RHB-TYPEIN-POINTER))
	     (DECF (RHB-TYPEIN-POINTER) (RHB-SCAN-POINTER)))
	 (SETF (RHB-FILL-POINTER) (- (RHB-FILL-POINTER) (RHB-SCAN-POINTER))))
	(T (SETF (RHB-FILL-POINTER) 0)))
  (SETF (RHB-SCAN-POINTER) 0)
  (SETF (RHB-INITIAL-ENTRY) T)
  (*CATCH 'RETURN-FROM-RUBOUT-HANDLER
    (MULTIPLE-VALUE-BIND (PROMPT-STARTING-X PROMPT-STARTING-Y)
	(FUNCALL-SELF ':READ-CURSORPOS)
      (LET ((PROMPT-OPTION (ASSQ ':PROMPT RUBOUT-HANDLER-OPTIONS)))
	(AND PROMPT-OPTION			;Prompt if desired
	     (RUBOUT-HANDLER-PROMPT (CADR PROMPT-OPTION) SELF NIL)))
      (MULTIPLE-VALUE-BIND (RUBOUT-HANDLER-STARTING-X RUBOUT-HANDLER-STARTING-Y)
	  (FUNCALL-SELF ':READ-CURSORPOS)
	;; Output any "typeahead"
	(AND (PLUSP (RHB-FILL-POINTER))
	     (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER))
	(DO ((RUBOUT-HANDLER T)			;Establish rubout handler
	     (RUBOUT-HANDLER-INSIDE T)
	     (RUBOUT-HANDLER-RE-ECHO-FLAG NIL NIL)
	     (RUBOUT-HANDLER-ACTIVATION-CHARACTER NIL))
	    (NIL)
	  (*CATCH 'RUBOUT-HANDLER			;Throw here when rubbing out
	    (CONDITION-CASE (ERROR)
		(RETURN
		 (MULTIPLE-VALUE-PROG1
		   (APPLY FUNCTION ARGS)		;Call READ or whatever.
		   (SETF (RHB-FILL-POINTER) (RHB-SCAN-POINTER))
		   (AND (RHB-TYPEIN-POINTER)
			(> (RHB-TYPEIN-POINTER) (RHB-FILL-POINTER))
			(SETF (RHB-TYPEIN-POINTER) (RHB-FILL-POINTER)))))
	      (SYS:READ-ERROR
	       (TERPRI SELF)
	       (PRINC ">>ERROR: " SELF)
	       (SEND ERROR ':REPORT SELF)
	       (TERPRI SELF)
	       (SETQ RUBOUT-HANDLER-RE-ECHO-FLAG T)
	       (DO () (NIL) (FUNCALL-SELF ':TYI)))))	;If error, force user to rub out
	  ;;Maybe return when user rubs all the way back
	  (AND (ZEROP (RHB-FILL-POINTER))
	       (LET ((FULL-RUBOUT-OPTION (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-OPTIONS)))
		 (WHEN FULL-RUBOUT-OPTION
		   ;; Get rid of the prompt, if any.
		   (SHEET-CLEAR-BETWEEN-CURSORPOSES
		     SELF PROMPT-STARTING-X PROMPT-STARTING-Y
		     (- CURSOR-X LEFT-MARGIN-SIZE) (- CURSOR-Y TOP-MARGIN-SIZE))
		   (SHEET-SET-CURSORPOS SELF PROMPT-STARTING-X PROMPT-STARTING-Y)
		   (RETURN NIL (CADR FULL-RUBOUT-OPTION))))))))))

))

; From file STREAM.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; STREAM  "

(DEFMETHOD (EDITOR-STREAM-MIXIN :AFTER :RUBOUT-HANDLER) (OPTIONS &REST IGNORE)
  (UNLESS (OR (CADR (ASSQ ':NO-INPUT-SAVE OPTIONS))
	      (CADR (ASSQ ':DONT-SAVE OPTIONS)))
    (PUSH-ON-HISTORY (STRING-INTERVAL *STREAM-START-BP* (WINDOW-POINT *STREAM-SHEET*))
		     *STREAM-INPUT-HISTORY*)))

))

; From file STREAM.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; STREAM  "

(DEFUN DEFAULT-RUBOUT-HANDLER ()
  (DECLARE (:SELF-FLAVOR STREAM-MIXIN))
  (SETF (RHB-TYPEIN-POINTER) NIL)   ;Mark that old rubout handler is in use.
  (WHEN (RHB-INITIAL-ENTRY)
    (LET ((INITIAL-INPUT (CADR (ASSQ ':INITIAL-INPUT RUBOUT-HANDLER-OPTIONS))))
      (WHEN INITIAL-INPUT
	(STRING-NCONC RUBOUT-HANDLER-BUFFER INITIAL-INPUT))))
  (SETF (RHB-INITIAL-ENTRY) NIL)
  (WHEN (= (RHB-SCAN-POINTER) MOST-POSITIVE-FIXNUM)
    (SETF (RH-SCAN-POINTER) 0)
    (*THROW 'RUBOUT-HANDLER T))
  (OR (PROG1 RUBOUT-HANDLER-ACTIVATION-CHARACTER
	     (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER NIL))
      (DO ((RUBOUT-HANDLER NIL)
	   (RUBBED-OUT-SOME NIL)
	   (PASS-THROUGH (CDR (ASSQ ':PASS-THROUGH RUBOUT-HANDLER-OPTIONS)))
	   (DO-NOT-ECHO (CDR (ASSQ ':DO-NOT-ECHO RUBOUT-HANDLER-OPTIONS)))
	   (COMMAND-HANDLER
	     (ASSQ ':COMMAND RUBOUT-HANDLER-OPTIONS))
	   (PREEMPTABLE (ASSQ ':PREEMPTABLE RUBOUT-HANDLER-OPTIONS))
	   (ACTIVATION-HANDLER
	     (ASSQ ':ACTIVATION RUBOUT-HANDLER-OPTIONS))
	   CH LEN)
	  (NIL)
	(SETQ CH (FUNCALL-SELF ':ANY-TYI))
	(COND ((AND (CONSP CH) (EQ (CAR CH) 'REDISPLAY-RUBOUT-HANDLER))
	       (SEND SELF ':SET-CURSORPOS PROMPT-STARTING-X PROMPT-STARTING-Y)
	       (SEND SELF ':CLEAR-EOL)
	       (AND (SETQ LEN (OR (ASSQ ':REPROMPT RUBOUT-HANDLER-OPTIONS)
				  (ASSQ ':PROMPT RUBOUT-HANDLER-OPTIONS)))
		    (RUBOUT-HANDLER-PROMPT (CADR LEN) SELF CH))
	       (MULTIPLE-VALUE (RUBOUT-HANDLER-STARTING-X RUBOUT-HANDLER-STARTING-Y)
		 (FUNCALL-SELF ':READ-CURSORPOS))
	       (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER))
	      ((LISTP CH)
	       (WHEN PREEMPTABLE
		 (SETF (RHB-SCAN-POINTER) 0)
		 (*THROW 'RETURN-FROM-RUBOUT-HANDLER
			 (VALUES CH (CADR PREEMPTABLE)))))
	      ((AND COMMAND-HANDLER
		    (APPLY (CADR COMMAND-HANDLER) CH (CDDR COMMAND-HANDLER)))
	       (SETF (RHB-SCAN-POINTER) 0)
	       (*THROW 'RETURN-FROM-RUBOUT-HANDLER
		       (VALUES
			 `(:COMMAND ,CH 1)
			 ':COMMAND)))
	      ;; Don't touch this character, just return it to caller.
	      ((OR (MEMQ CH PASS-THROUGH)
		   (SI:ASSQ-CAREFUL CH PASS-THROUGH))
	       ;; Cause rubout handler rescan next time the user does :TYI.
	       (IF RUBBED-OUT-SOME (SETF (RH-SCAN-POINTER) MOST-POSITIVE-FIXNUM))
	       (RETURN CH))
	      ;; Is it an editing character?
	      ((AND (NOT (OR (MEMQ CH DO-NOT-ECHO)
			     (AND ACTIVATION-HANDLER
				  (APPLY (CADR ACTIVATION-HANDLER) CH (CDDR ACTIVATION-HANDLER)))))
		    (OR (LDB-TEST %%KBD-CONTROL-META CH)
			(MEMQ CH '(#\RUBOUT #\CLEAR-INPUT #\CLEAR-SCREEN #\VT))))
	       (COND ((MEMQ CH '(#\CLEAR-SCREEN #\VT))	;Retype buffered input
		      (FUNCALL-SELF ':TYO CH)		;Echo it
		      (IF (= CH #\CLEAR-SCREEN) (FUNCALL-SELF ':CLEAR-SCREEN)
			  (FUNCALL-SELF ':TYO #\CR))
		      (MULTIPLE-VALUE (PROMPT-STARTING-X PROMPT-STARTING-Y)
			(FUNCALL-SELF ':READ-CURSORPOS))
		      (AND (SETQ LEN (OR (ASSQ ':REPROMPT RUBOUT-HANDLER-OPTIONS)
					 (ASSQ ':PROMPT RUBOUT-HANDLER-OPTIONS)))
			   (RUBOUT-HANDLER-PROMPT (CADR LEN) SELF CH))
		      (MULTIPLE-VALUE (RUBOUT-HANDLER-STARTING-X RUBOUT-HANDLER-STARTING-Y)
			(FUNCALL-SELF ':READ-CURSORPOS))
		      (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER))
		     ((MEMQ CH '(#\RUBOUT #\M-RUBOUT #\CLEAR-INPUT)) ;Delete some characters
		      (COND ((NOT (ZEROP (SETQ LEN (RHB-FILL-POINTER))))
			     (SETF (RHB-FILL-POINTER)
			       (SETQ LEN (SELECTQ CH
					   (#\RUBOUT (1- LEN))
					   (#\M-RUBOUT (STRING-BACKWARD-WORD
							RUBOUT-HANDLER-BUFFER LEN))
					   (#\CLEAR-INPUT 0))))
			     (SETQ RUBBED-OUT-SOME T)
			     (MULTIPLE-VALUE-BIND (X Y)
				 (FUNCALL-SELF ':COMPUTE-MOTION RUBOUT-HANDLER-BUFFER 0 LEN
				   RUBOUT-HANDLER-STARTING-X RUBOUT-HANDLER-STARTING-Y)
			       (IF RUBOUT-HANDLER-RE-ECHO-FLAG
				   (SETQ X RUBOUT-HANDLER-STARTING-X Y RUBOUT-HANDLER-STARTING-Y))
			       (MULTIPLE-VALUE-BIND (CX CY) (FUNCALL-SELF ':READ-CURSORPOS)
				 (FUNCALL-SELF ':CLEAR-BETWEEN-CURSORPOSES X Y CX CY))
			       (FUNCALL-SELF ':SET-CURSORPOS X Y)
			       (AND RUBOUT-HANDLER-RE-ECHO-FLAG
				    (FUNCALL-SELF ':STRING-OUT RUBOUT-HANDLER-BUFFER))))))
		     (T (BEEP)))				;Undefined editing character
	       (COND ((AND (ZEROP (RHB-FILL-POINTER))
			   (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-OPTIONS))
		      (SETF (RHB-SCAN-POINTER) 0)
		      (*THROW 'RUBOUT-HANDLER T))))
	      (T						;It's a self-inserting character
	       ;; If this is first character typed in, re-get starting cursorpos since while
	       ;; waiting for input a notification may have been typed out.
	       (AND (ZEROP (RHB-FILL-POINTER))
		    (MULTIPLE-VALUE (RUBOUT-HANDLER-STARTING-X RUBOUT-HANDLER-STARTING-Y)
		      (FUNCALL-SELF ':READ-CURSORPOS)))
	       (COND ((MEMQ CH DO-NOT-ECHO)
		      (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER CH))
		     ((AND ACTIVATION-HANDLER
			   (APPLY (CADR ACTIVATION-HANDLER) CH (CDDR ACTIVATION-HANDLER)))
		      (SETQ CH `(:ACTIVATION ,CH 1))
		      (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER CH))
		     (T
		      (FUNCALL-SELF ':TYO CH)
		      (ARRAY-PUSH-EXTEND RUBOUT-HANDLER-BUFFER CH)))
	       (COND (RUBBED-OUT-SOME
		      (SETF (RHB-SCAN-POINTER) 0)
		      (*THROW 'RUBOUT-HANDLER T))
		     (T
		      (SETF (RHB-SCAN-POINTER) (RHB-FILL-POINTER))
		      (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER NIL)
		      (RETURN CH))))))))

))

; From file LTOP.LISP SRC:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; LTOP  "

(DEFUN BREAK (&OPTIONAL &QUOTE FORMAT-STRING &EVAL &REST ARGS &AUX TEM
	      SAVED-BUFFER SAVED-BUFFER-POSITION)
  "Read-eval-print loop for use as subroutine.  Args are passed to FORMAT.
Many variables are rebound, as specified in SI:*BREAK-BINDINGS*."
  (SETQ FORMAT-STRING
	(IF (OR (SYMBOLP FORMAT-STRING) (AND (CONSP FORMAT-STRING)
					     (EQ (CAR FORMAT-STRING) 'QUOTE)
					     (SYMBOLP (CADR FORMAT-STRING))
					     (NULL (CDDR FORMAT-STRING))
					     (SETQ FORMAT-STRING (CADR FORMAT-STRING))))
	    (STRING FORMAT-STRING)
	  (EVAL1 FORMAT-STRING)))
  (UNLESS (OR (EQUAL FORMAT-STRING "")
	      (MEMQ (AREF FORMAT-STRING (1- (LENGTH FORMAT-STRING))) '(#/. #/? #/!)))
    (SETQ FORMAT-STRING (STRING-APPEND FORMAT-STRING #/.)))
  (PROGW *BREAK-BINDINGS*
    ;; Deal with keyboard multiplexing in a way similar to the error-handler.
    ;; If we break in the scheduler, set CURRENT-PROCESS to NIL.
    ;; If this is not the scheduler process, make sure it has a run reason
    ;; in case we broke in the middle of code manipulating process data.
    ;; If INHIBIT-SCHEDULING-FLAG is set, turn it off and print a warning.
    (COND ((EQ %CURRENT-STACK-GROUP SCHEDULER-STACK-GROUP)
	   (SETQ CURRENT-PROCESS NIL)))
    (AND (NOT (NULL CURRENT-PROCESS))
	 (NULL (FUNCALL CURRENT-PROCESS ':RUN-REASONS))
	 (FUNCALL CURRENT-PROCESS ':RUN-REASON 'BREAK))
    (COND (INHIBIT-SCHEDULING-FLAG
	   (FORMAT T "~%---> Turning off INHIBIT-SCHEDULING-FLAG, you may lose. <---~%")
	   (SETQ INHIBIT-SCHEDULING-FLAG NIL)))
    (AND (MEMQ ':SAVE-RUBOUT-HANDLER-BUFFER (FUNCALL OLD-STANDARD-INPUT
						     ':WHICH-OPERATIONS))
	 (SETF (VALUES SAVED-BUFFER SAVED-BUFFER-POSITION)
	       (FUNCALL OLD-STANDARD-INPUT ':SAVE-RUBOUT-HANDLER-BUFFER)))
    (FORMAT T "~&;Breakpoint ~?  ~:@C to continue, ~:@C to quit.~%"
	    FORMAT-STRING ARGS #\RESUME #\ABORT)
    (LET ((VALUE
	    (DO ()
		(NIL)		;Do forever (until explicit return)
	      (TERPRI)
	     LOOK-FOR-SPECIAL-KEYS
	      (SETQ TEM (FUNCALL STANDARD-INPUT ':TYI))
	      ;; Intercept characters even if otherwise disabled in program
	      ;; broken out of.  Also treat c-Z like ABORT for convenience
	      ;; and for compatibility with the error handler.
	      (AND (= TEM #\C-Z) (SETQ TEM #\ABORT))
	      (COND ((AND (BOUNDP 'TV:KBD-STANDARD-INTERCEPTED-CHARACTERS)
			  (ASSQ TEM TV:KBD-STANDARD-INTERCEPTED-CHARACTERS))
		     (FUNCALL (CADR (ASSQ TEM TV:KBD-STANDARD-INTERCEPTED-CHARACTERS)) TEM))
		    ((= TEM #\RESUME)
		     (FUNCALL STANDARD-OUTPUT ':STRING-OUT "[Resume]
")
		     (RETURN NIL))
		    (T (FUNCALL STANDARD-INPUT ':UNTYI TEM)))
	      (LET ((EH:CONDITION-RESUME-HANDLERS (CONS T EH:CONDITION-RESUME-HANDLERS)))
		(MULTIPLE-VALUE (NIL TEM)
		  (CATCH-ERROR-RESTART ((SYS:ABORT ERROR)
					"Return to BREAK ~?"
					FORMAT-STRING ARGS)
		    (MULTIPLE-VALUE (- TEM)
		      (FUNCALL STANDARD-INPUT ':RUBOUT-HANDLER '((:FULL-RUBOUT
								   :FULL-RUBOUT)
								 (:ACTIVATION = #\END))
			       #'READ-FOR-TOP-LEVEL))
		    (COND ((EQ TEM ':FULL-RUBOUT)
			   (GO LOOK-FOR-SPECIAL-KEYS))
			  ((EQ - 'P)		;Altmode-P proceeds from BREAK
			   (RETURN NIL))
			  ((AND (CONSP -) (EQ (CAR -) 'RETURN))
			   (RETURN (EVAL-ABORT-TRIVIAL-ERRORS (CADR -)))))	;(RETURN form) proceeds
		    (LET ((VALUES
			    (MULTIPLE-VALUE-LIST (EVAL-ABORT-TRIVIAL-ERRORS -))))
		      (SETQ ////// ////
			    //// //
			    // VALUES)
		      (SETQ *** **
			    ** *
			    * (CAR //)))
		    (DOLIST (VALUE //)
		      (TERPRI)
		      (FUNCALL (OR PRIN1 #'PRIN1) VALUE)))))
	      (AND TEM (FORMAT T "~&;Back to Breakpoint ~?  ~:@C to continue, ~:@C to quit.~%"
			       FORMAT-STRING ARGS #\RESUME #\ABORT))
	      (SETQ +++ ++ ++ + + -))))
      ;; Before returning, restore and redisplay rubout handler's buffer so user
      ;; gets what he sees, if we broke out of reading through the rubout handler.
      ;; If we weren't inside there, the rubout handler buffer is now empty because
      ;; we read from it, so leave it alone.  (Used to :CLEAR-INPUT).
      (COND (SAVED-BUFFER
	     (FUNCALL OLD-STANDARD-INPUT ':RESTORE-RUBOUT-HANDLER-BUFFER
		      SAVED-BUFFER SAVED-BUFFER-POSITION)))
      VALUE)))

))

; From file READ.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; READ  "

(DEFUN XR-XRTYI (STREAM &OPTIONAL IGNORE-WHITESPACE NO-CHARS-SPECIAL NO-MULTIPLE-ESCAPES)
  "Read a character from STREAM, processing escapes (// and /) and multiple-escapes (/|).
IGNORE-WHITESPACE non-NIL means skip over whitespace characters.
NO-CHARS-SPECIAL means do not process escapes specially.
NO-MULTIPLE-ESCAPES means do not process multiple-escape characters specially.

The first value is the translated character.
The second is the index for looking in READ's FSM.
The third is the original, nontranslated character.

Has a kludge for IBASE > 10. where letters that should be digits
return the readtable code for EXTENDED-DIGIT rather than their own codes."
  (DECLARE (VALUES TRANSLATED-CHAR FSM-INDEX ACTUAL-CHAR))
  (PROG TOP (CH BITS CODE CH-CHAR)
	(SETQ XR-XRTYI-PREV-CHAR XR-XRTYI-LAST-CHAR)
     L
	(DO-FOREVER
	  (SETQ CH (FUNCALL STREAM (IF RUBOUT-HANDLER ':ANY-TYI ':TYI)))
	  (COND ((NULL CH)
		 (RETURN-FROM TOP CH (RDTBL-EOF-CODE READTABLE) CH))
		((CONSP CH)
		 (AND (EQ (CAR CH) ':ACTIVATION)
		      ;; Ignore activations except in top-level context.
		      (NOT IGNORE-WHITESPACE)
		      (NOT NO-CHARS-SPECIAL)
		      (NOT NO-MULTIPLE-ESCAPES)
		      (LET ((CH1 (CAR (RDTBL-WHITESPACE READTABLE))))
			(RETURN-FROM TOP
			  CH1 (RDTBL-CODE READTABLE CH1) CH))))
		((AND READ-DISCARD-FONT-CHANGES
		      (EQ CH #/))
		 (IF (EQ #/ (SEND STREAM ':TYI))
		     (RETURN)))
		((NOT (> CH RDTBL-ARRAY-SIZE))
		 (RETURN))))
	(SETQ CH-CHAR (LDB %%CH-CHAR CH))
	(SETQ BITS (RDTBL-BITS READTABLE CH-CHAR))
	(SETQ CODE (RDTBL-CODE READTABLE CH-CHAR))
	(COND ((AND (NOT NO-CHARS-SPECIAL)
		    (NOT NO-MULTIPLE-ESCAPES)
		    (= CODE
		       (RDTBL-MULTIPLE-ESCAPE-CODE READTABLE)))
	       ;; Vertical bar.
	       (SETQ READ-INSIDE-MULTIPLE-ESCAPE
		     (IF READ-INSIDE-MULTIPLE-ESCAPE NIL
		       CH-CHAR))
	       (GO L))
	      ((AND (NOT NO-CHARS-SPECIAL)
		    (= CODE
		       (RDTBL-ESCAPE-CODE READTABLE)))
	       ;; Slash
	       (SETQ XR-XRTYI-PREV-CHAR CH)
	       (DO-FOREVER
		 (SETQ CH (FUNCALL STREAM ':TYI))
		 (COND ((AND READ-DISCARD-FONT-CHANGES
			     (EQ CH #/))
			(IF (EQ #/ (SEND STREAM ':TYI))
			    (RETURN)))
		       (T (RETURN))))
	       (SETQ XR-XRTYI-LAST-CHAR CH)
	       (RETURN (OR CH
			   (PROGN
			     (CERROR ':NO-ACTION NIL 'SYS:READ-END-OF-FILE
				     "EOF on ~S after a ~S." STREAM
				     (STRING XR-XRTYI-PREV-CHAR))
			     #\SP))
		       (RDTBL-SLASH-CODE READTABLE)
		       CH))
	      ((AND (NOT NO-CHARS-SPECIAL)
		    (= CODE
		       (RDTBL-CHARACTER-CODE-ESCAPE-CODE READTABLE)))
	       ;; circlecross
	       (SETQ XR-XRTYI-LAST-CHAR (XR-READ-CIRCLECROSS STREAM))
	       (RETURN XR-XRTYI-LAST-CHAR
		       (RDTBL-SLASH-CODE READTABLE)
		       XR-XRTYI-LAST-CHAR))
	      (READ-INSIDE-MULTIPLE-ESCAPE
	       ;; Ordinary character but within vertical bars.
	       (SETQ XR-XRTYI-LAST-CHAR CH)
	       (RETURN (OR CH
			   (PROGN
			     (CERROR ':NO-ACTION NIL 'SYS:READ-END-OF-FILE
				     "EOF on ~S inside a ~C-quoted token." STREAM
				     READ-INSIDE-MULTIPLE-ESCAPE)
			     #\SP))
		       (RDTBL-SLASH-CODE READTABLE)
		       CH))
	      (T
	       ;; Ordinary character.
	       (COND ((AND IGNORE-WHITESPACE
			   (BIT-TEST 1 BITS))
		      ;; Here if whitespace char to be ignored.
		      (SETQ XR-XRTYI-PREV-CHAR CH)
		      (GO L)))
	       ;; Here for ordinary, significant input char.
	       (SETQ XR-XRTYI-LAST-CHAR CH)
	       (RETURN (RDTBL-TRANS READTABLE CH-CHAR)
		       ;; If not doing slashes, caller must not really want the RDTBL-CODE,
		       ;; so return a value which, if passed to XR-XRUNTYI,
		       ;; will prevent barfing.
		       (IF NO-CHARS-SPECIAL 0
			 (IF (AND (NUMBERP IBASE)
				  (> IBASE 10.)
				  ( #/A (CHAR-UPCASE CH) (+ IBASE #/A -11.)))
			     (CDR (GETF (RDTBL-PLIST READTABLE) 'EXTENDED-DIGIT))
			   (RDTBL-CODE READTABLE CH-CHAR)))
		       CH)))))

(DEFUN XR-XRUNTYI (STREAM CH NUM)
  "XR-XRUNTYI is to XR-XRTYI as the :UNTYI operation is to :TYI.
CH and NUM should be the third and second values returned by XR-XRTYI."
  (AND (= NUM (RDTBL-SLASH-CODE READTABLE))
       (FERROR 'SYS:READ-ERROR-1
	       "The character /"~C/" was slashified and cannot be UNTYIed." CH))
  (COND ((AND CH (NOT (CONSP CH))
	      (OR READ-PRESERVE-DELIMITERS (ZEROP (LOGAND 1 (RDTBL-BITS READTABLE CH)))))
	 (SETQ XR-XRTYI-LAST-CHAR XR-XRTYI-PREV-CHAR)
	 (FUNCALL STREAM ':UNTYI CH))))

(DEFVAR READ-STREAM :UNBOUND
  "Within READ, the stream being read from.  For creating error objects.")

(DEFUN INTERNAL-READ (&OPTIONAL (STREAM STANDARD-INPUT)
		      (EOF-ERRORP T) EOF-VALUE RECURSIVE-P
		      PRESERVE-WHITESPACE DISCARD-CLOSEPARENS CHECK-INDENTATION
		      &AUX W-O)
  "Read an s-expression from STREAM and return it.
End of file within an s-expression is an error.
End of file with no s-expression seen is controlled by EOF-ERRORP.
T means it is an error then too.  NIL means that end of file
with no s-expression returns EOF-VALUE.

RECURSIVE-P non-NIL is used for recursive calls, e.g. from read macro definitions.
Recursive calls must be distinguished to make READ-PRESERVING-WHITESPACE
and #n= /"labels/" work properly.

PRESERVE-WHITESPACE if non-NIL says do not discard the terminating delimiter even
if it is whitespace.  This argument is ignored if RECURSIVE-P is non-NIL,
and the outer, nonrecursive call gets to control the matter.

DISCARD-CLOSEPARENS if non-NIL says if we see a close paren
just keep reading past it, with no error.

CHECK-INDENTATION controls whether indentation is checked within this
s-expression.  If RECURSIVE-P is non-NIL, this argument is ignored
and the outer, nonrecursive call gets to control the matter."
  (IF (EQ STREAM T) (SETQ STREAM *TERMINAL-IO*))
  (LET-IF (NOT RECURSIVE-P)
	  ((XR-LABEL-BINDINGS NIL)
	   (READ-PRESERVE-DELIMITERS PRESERVE-WHITESPACE)
	   (READ-CHECK-INDENTATION CHECK-INDENTATION)
	   (XR-XRTYI-LAST-CHAR #\RETURN)
	   (XR-XRTYI-PREV-CHAR NIL)
	   (READ-STREAM STREAM)
	   (MISSING-CLOSEPAREN-REPORTED NIL))
    (SETQ W-O (FUNCALL STREAM ':WHICH-OPERATIONS))
    (COND ((MEMQ ':READ W-O)
	   (FUNCALL STREAM ':READ NIL))
	  ((AND (NOT RECURSIVE-P) (NOT RUBOUT-HANDLER) (MEMQ ':RUBOUT-HANDLER W-O))
	   ;;We must get inside the rubout handler's top-level CATCH
	   (FUNCALL STREAM ':RUBOUT-HANDLER '((:ACTIVATION = #\END))
		    #'INTERNAL-READ STREAM EOF-ERRORP EOF-VALUE T))
	  ((PROG (THING TYPE XR-SHARP-ARGUMENT)
	       A (MULTIPLE-VALUE (THING TYPE) (XR-READ-THING STREAM))
		 (COND ((EQ TYPE 'READER-MACRO)
			(LET ((XR-LIST-SO-FAR ':TOPLEVEL)
			      (XR-SPLICE-P NIL)
			      VALUES)
			  (SETQ VALUES (INVOKE-READER-MACRO THING STREAM))
			  (IF (OR XR-SPLICE-P
				  ( (LENGTH VALUES) 1))
			      (GO A))
			  (RETURN (CAR VALUES))))
		       ((EQ TYPE 'SPECIAL-TOKEN)
			(COND ((EQ THING 'EOF)
			       (IF EOF-ERRORP
				   (CERROR ':NO-ACTION NIL 'SYS:READ-END-OF-FILE
					   "End of file encountered by READ on stream ~S."
					   STREAM)
				 (RETURN EOF-VALUE)))
			      ((AND DISCARD-CLOSEPARENS
				    (EQ THING 'CLOSE))
			       (GO A))
			      (T
			       (CERROR ':NO-ACTION NIL 'SYS:READ-ERROR-1
				       "The special token ~S was read in at top level."
				       THING))))
		       (T (RETURN THING))))))))

))

; From file RH.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; RH  "

(DEFUN-RH ALTERNATE-RUBOUT-HANDLER ()
  (LET ((CH) (CH-CHAR) (CH-CONTROL-META) (COMMAND)
	(FILL-POINTER (RH-FILL-POINTER))
	(TYPEIN-POINTER (RH-TYPEIN-POINTER))
	(INITIAL-ENTRY (RHB-INITIAL-ENTRY))
	(RUBBED-OUT-SOME? NIL)
	(INITIAL-INPUT (CADR (ASSQ ':INITIAL-INPUT RUBOUT-HANDLER-OPTIONS)))
	(INITIAL-INPUT-POINTER
	  (CADR (ASSQ ':INITIAL-INPUT-POINTER-INDEX RUBOUT-HANDLER-OPTIONS)))
	(NUMERIC-ARG NIL)
	(NUMERIC-ARG-NEGATIVE NIL))

    (SETF (RHB-INITIAL-ENTRY) NIL)

    ;; Kludge #1.  If this is the first time this rubout handler has been invoked
    ;; in this stream, then we must create the input history.
    (OR (RH-INPUT-RING)
	(WHEN (FBOUNDP 'ZWEI:MAKE-HISTORY)
	  (SETF (RH-INPUT-RING) (RH-MAKE-INPUT-RING))))

    (WHEN INITIAL-ENTRY
      ;; save the previous input on the input history,
      ;; unless the previous read said not to save it.
      (COND ((AND (NOT (RH-DONT-SAVE-FLAG)) (RH-INPUT-RING)
		  TYPEIN-POINTER
		  (NOT (ZEROP TYPEIN-POINTER)))
	     ;; only add the contents if it is different than the last entry, and
	     ;; the entry is at least 2 characters long.
	     (SETF (FILL-POINTER RUBOUT-HANDLER-BUFFER) TYPEIN-POINTER)
	     (WHEN (AND (> TYPEIN-POINTER 1)
			(MISMATCH RUBOUT-HANDLER-BUFFER
				  (ZWEI:HISTORY-LATEST-ELEMENT (RH-INPUT-RING))))
	       (ZWEI:PUSH-ON-HISTORY (SUBSEQ RUBOUT-HANDLER-BUFFER 0 TYPEIN-POINTER)
				     (RH-INPUT-RING)))
	     (SETF (FILL-POINTER RUBOUT-HANDLER-BUFFER) FILL-POINTER)))

      ;; Then initialize the typein pointer.
      (SETF (RH-TYPEIN-POINTER) FILL-POINTER)
      (SETQ TYPEIN-POINTER FILL-POINTER)

      ;; Gobble the initial input if any.
      (WHEN INITIAL-INPUT
	(RH-INSERT-STRING INITIAL-INPUT 0 NIL NIL NIL)
	(SETQ RUBBED-OUT-SOME? T)
	(RH-SET-POSITION (OR INITIAL-INPUT-POINTER (RH-TYPEIN-POINTER))))
    
      ;; Record whether this unit of input should be saved on the history.
      (SETF (RH-DONT-SAVE-FLAG)
	    (OR (CADR (ASSQ ':DONT-SAVE RUBOUT-HANDLER-OPTIONS))
		(CADR (ASSQ ':NO-INPUT-SAVE RUBOUT-HANDLER-OPTIONS))))
      )

    ;; Kludge #5.  We can't echo or rub out a bucky char or a bli,
    ;; so if the last char inserted was a either of those
    ;; and it did not terminate the input, flush it.
    (AND (NOT (ZEROP TYPEIN-POINTER))
	 (OR (CONSP (AREF RUBOUT-HANDLER-BUFFER (1- TYPEIN-POINTER)))
	     (LDB-TEST %%KBD-CONTROL-META
		       (AREF RUBOUT-HANDLER-BUFFER (1- TYPEIN-POINTER))))
	 (SETF (RH-TYPEIN-POINTER) (DECF (RH-FILL-POINTER))))

    ;; Kludge #4.  After resuming a Break, the stream's cursorpos is wrong.
    ;; In fact, the cursor is at the end of the string in that case.
    ;; So, if it is supposed to be elsewhere, move it.
    ;; This condition also avoids wasting time when we are reading typein
    ;; at the end of the string.
    (OR (= FILL-POINTER TYPEIN-POINTER)
	(RH-CURSOR-MOTION TYPEIN-POINTER))

    ;; In case we had to return to the caller with a PASS-THROUGH char
    ;; while RUBBED-OUT-SOME? was T, make things consistent again
    ;; by causing a rescan now.
    (WHEN (AND (NOT INITIAL-ENTRY)
	       (= (RH-SCAN-POINTER) MOST-POSITIVE-FIXNUM))
      (SETF (RH-SCAN-POINTER) 0)
      (*THROW 'RUBOUT-HANDLER T))

    (*CATCH 'RETURN-CHARACTER
      (WHEN RUBOUT-HANDLER-ACTIVATION-CHARACTER
	(*THROW 'RETURN-CHARACTER
		(PROG1 RUBOUT-HANDLER-ACTIVATION-CHARACTER
		       (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER NIL))))
      ;; Read characters.  If an ordinary character is typed and nothing has been rubbed out,
      ;; return immediately.  Otherwise, let all editing operations complete
      ;; before returning. 
      (DO (*LAST-COMMAND-TYPE*
	   *CURRENT-COMMAND-TYPE*
	   *RUBOUT-HANDLER-MARK*
	   (PASS-THROUGH (CDR (ASSQ ':PASS-THROUGH RUBOUT-HANDLER-OPTIONS)))
	   (DO-NOT-ECHO (CDR (ASSQ ':DO-NOT-ECHO RUBOUT-HANDLER-OPTIONS)))
	   (COMMAND-HANDLER
	     (ASSQ ':COMMAND RUBOUT-HANDLER-OPTIONS))
	   (PREEMPTABLE (ASSQ ':PREEMPTABLE RUBOUT-HANDLER-OPTIONS))
	   (ACTIVATION-HANDLER
	     (ASSQ ':ACTIVATION RUBOUT-HANDLER-OPTIONS)))
	  (NIL)
	;; Read a character from the stream after bypassing ourself.
	(SETQ CH (LET ((RUBOUT-HANDLER NIL)) (FUNCALL-SELF ':ANY-TYI)))
	(IF (LISTP CH)
	    (COND ((EQ (CAR CH) 'REDISPLAY-RUBOUT-HANDLER)
		   (SEND SELF ':SET-CURSORPOS
			 PROMPT-STARTING-X PROMPT-STARTING-Y)
		   (SEND SELF ':CLEAR-EOL)
		   (RH-REPRINT-INPUT NIL T))
		  (PREEMPTABLE
		   (SETF (RH-SCAN-POINTER) 0)
		   (*THROW 'RETURN-FROM-RUBOUT-HANDLER
			   (VALUES CH (CADR PREEMPTABLE))))
		  ((AND (EQ (CAR CH) ':MOUSE-BUTTON)
			(EQ (CADR CH) #\MOUSE-3-1))
		   (MOUSE-CALL-SYSTEM-MENU)))
	  (SETQ CH-CHAR (LDB %%KBD-CHAR CH))
	  (SETQ CH-CONTROL-META (LDB %%KBD-CONTROL-META CH))
	  (SETQ COMMAND (ASSQ CH RH-COMMAND-ALIST))
	  (COND
	    ((AND COMMAND-HANDLER
		  (APPLY (CADR COMMAND-HANDLER) CH (CDDR COMMAND-HANDLER)))
	     (SETF (RH-SCAN-POINTER) 0)
	     (*THROW 'RETURN-FROM-RUBOUT-HANDLER
		     (VALUES
		       `(:COMMAND ,CH ,(* (OR NUMERIC-ARG 1)
					  (IF NUMERIC-ARG-NEGATIVE -1 1)))
		       ':COMMAND)))
	    ((OR (MEMQ CH DO-NOT-ECHO)
		 (AND ACTIVATION-HANDLER
		      (APPLY (CADR ACTIVATION-HANDLER) CH (CDDR ACTIVATION-HANDLER))))
	     (RH-SET-POSITION (RH-FILL-POINTER))
	     (LET ((VALUE
		     (IF (MEMQ CH DO-NOT-ECHO) CH
		       `(:ACTIVATION ,CH ,(* (OR NUMERIC-ARG 1)
					     (IF NUMERIC-ARG-NEGATIVE -1 1))))))
	       (COND (RUBBED-OUT-SOME?
		      ;; Why isn't this done in the :RUBOUT-HANDLER method loop?
		      (SETQ RUBOUT-HANDLER-ACTIVATION-CHARACTER VALUE)
		      (SETF (RH-SCAN-POINTER) 0)
		      (*THROW 'RUBOUT-HANDLER T))
		     (T (*THROW 'RETURN-CHARACTER VALUE)))))
	    ;; Don't touch this character, just return it to caller.
	    ((OR (MEMQ CH PASS-THROUGH)
		 (SI:ASSQ-CAREFUL CH PASS-THROUGH))
	     ;; Cause rubout handler rescan next time the user does :TYI.
	     (IF RUBBED-OUT-SOME? (SETF (RH-SCAN-POINTER) MOST-POSITIVE-FIXNUM))
	     (RETURN CH))

	    ;; An editing command of some sort.  The RUBBED-OUT-SOME bit can only be
	    ;; cleared by entering this function again.  The function is passed the
	    ;; numeric argument, and returns T if we are going to need to throw out (like
	    ;; DIS-ALL in the editor).
	    (COMMAND
	     (SETQ *LAST-COMMAND-TYPE* *CURRENT-COMMAND-TYPE*
		   *CURRENT-COMMAND-TYPE* NIL)
	     (SETQ RUBBED-OUT-SOME?
		   (OR (FUNCALL (CDR COMMAND) (* (OR NUMERIC-ARG 1)
						 (IF NUMERIC-ARG-NEGATIVE -1 1)))
		       RUBBED-OUT-SOME?))
	     (SETQ NUMERIC-ARG NIL NUMERIC-ARG-NEGATIVE NIL)
	     ;; If the buffer is empty and the :FULL-RUBOUT option is active, then throw now.
	     ;; This will throw if the user types Rubout or ClearScreen immediately after
	     ;; entering the read function.  It is important that we check for this here
	     ;; and not in RH-DELETE-STRING since some commands, such as Yank-Pop, may
	     ;; temporarily empty the buffer.  It wouldn't be the right thing to throw
	     ;; if the buffer only contained whitespace since it is the responsibility
	     ;; of the caller to discard whitespace when looking for special characters.
	     (COND ((AND (ZEROP (RH-FILL-POINTER))
			 (ASSQ ':FULL-RUBOUT RUBOUT-HANDLER-OPTIONS))
		    ;; This SETF should be done in the :RUBOUT-HANDLER method loop.
		    (SETF (RH-SCAN-POINTER) 0)
		    (*THROW 'RUBOUT-HANDLER T))))
	    
	    ;;Handle Control-number and Control-U specially.
	    ((AND (NOT (ZEROP CH-CONTROL-META))
		  ( #/0 CH-CHAR #/9))
	     (SETQ NUMERIC-ARG (+ (* (OR NUMERIC-ARG 0) 10.) (- CH-CHAR #/0))))
	    ((= CH #\CONTROL-U)
	     (SETQ NUMERIC-ARG (* (OR NUMERIC-ARG 1) 4)))
	    ((AND (NOT (ZEROP CH-CONTROL-META)) (= CH-CHAR #/-))
	     (IF NUMERIC-ARG
		 (FUNCALL-SELF ':BEEP)
	       (SETQ NUMERIC-ARG-NEGATIVE (NOT NUMERIC-ARG-NEGATIVE))))
	    
	    ;; Some other random control character -- beep and ignore
	    ((NOT (ZEROP CH-CONTROL-META))
	     (FUNCALL-SELF ':BEEP)
	     (SETQ NUMERIC-ARG NIL NUMERIC-ARG-NEGATIVE NIL))
	    
	    ;; Self-inserting character.  Set RUBBED-OUT-SOME since if we return,
	    ;; we were typing in the middle of the line.  Typing at the end of the
	    ;; line throws to RETURN-CHARACTER.
	    (T (UNLESS NUMERIC-ARG-NEGATIVE
		 (RH-INSERT-CHAR CH (OR NUMERIC-ARG 1) RUBBED-OUT-SOME?)
		 (SETQ RUBBED-OUT-SOME? T))
	       (SETQ *LAST-COMMAND-TYPE* *CURRENT-COMMAND-TYPE*
		     *CURRENT-COMMAND-TYPE* NIL
		     *RUBOUT-HANDLER-MARK* NIL)
	       (SETQ NUMERIC-ARG NIL NUMERIC-ARG-NEGATIVE NIL))))))))

))

; From file READ.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; READ  "

(DEFUN READ-DELIMITED-LIST (STOP-CHAR &OPTIONAL (STREAM STANDARD-INPUT) RECURSIVE-P)
  "Read objects from STREAM until STOP-CHAR is seen; return a list of the objects read.
STOP-CHAR should not be a whitespace character in the current READTABLE;
for best results, its syntax should be the standard syntax of closeparen.
RECURSIVE-P should be supplied non-NIL when this is called from a reader macro."
  (LET-IF (NOT RECURSIVE-P)
	  ((XR-LABEL-BINDINGS NIL)
	   (XR-XRTYI-LAST-CHAR #\RETURN)
	   (XR-XRTYI-PREV-CHAR NIL)
	   (READ-CHECK-INDENTATION NIL)
	   (READ-PRESERVE-DELIMITERS NIL))
    (IF (AND (NOT RECURSIVE-P) (NOT RUBOUT-HANDLER)
	     (SEND STREAM ':OPERATION-HANDLED-P ':RUBOUT-HANDLER))
	;;We must get inside the rubout handler's top-level CATCH
	(FUNCALL STREAM ':RUBOUT-HANDLER '((:ACTIVATION = #\END))
		 #'READ-DELIMITED-LIST STOP-CHAR STREAM)
      (PROG (LIST THING TYPE END-OF-LIST BP CORRESPONDENCE-ENTRY
	     (INSIDE-COLUMN-0-LIST INSIDE-COLUMN-0-LIST)
	     (THIS-IS-COLUMN-0-LIST (AND READ-CHECK-INDENTATION
					 (EQ XR-XRTYI-PREV-CHAR #\RETURN))))
	    (AND THIS-IS-COLUMN-0-LIST
		 (NOT *READ-SUPPRESS*)
		 (IF (NOT INSIDE-COLUMN-0-LIST)
		     (SETQ INSIDE-COLUMN-0-LIST T)
		   ;; ( in column 0 when not allowed.
		   ;; Report it (but only report each occurrence once).
		   (OR MISSING-CLOSEPAREN-REPORTED
		       (PROGN (SETQ MISSING-CLOSEPAREN-REPORTED T)
			      (SIGNAL-PROCEED-CASE (() 'SYS:MISSING-CLOSEPAREN
						       "Open paren found in column zero; missing closeparens assumed.")
				(:NO-ACTION))))
		   ;; Unread it and pretend it was a ).
		   (XR-XRUNTYI STREAM XR-XRTYI-LAST-CHAR -1)
		   (RETURN 'CLOSE 'SPECIAL-TOKEN)))
	    (SETQ MISSING-CLOSEPAREN-REPORTED NIL)
	    (SETQ END-OF-LIST (LOCF LIST))
	    (COND (XR-CORRESPONDENCE-FLAG
		   (FUNCALL STREAM ':UNTYI XR-XRTYI-LAST-CHAR)
		   (SETQ CORRESPONDENCE-ENTRY
			 `(NIL ,(FUNCALL STREAM ':READ-BP) NIL . ,XR-CORRESPONDENCE))
		   (SETQ XR-CORRESPONDENCE CORRESPONDENCE-ENTRY)
		   (FUNCALL STREAM ':TYI)))
	 A  (AND XR-CORRESPONDENCE-FLAG
		 (PUSH (FUNCALL STREAM ':READ-BP)
		       (CADDR CORRESPONDENCE-ENTRY)))
	    ;; Peek ahead to look for the terminator we expect.
	    (MULTIPLE-VALUE-BIND (CHAR NUM ACTUAL-CHAR)
		(XR-XRTYI STREAM T T)
	      (WHEN (= CHAR STOP-CHAR)
		(RETURN LIST))
	      (XR-XRUNTYI STREAM ACTUAL-CHAR NUM))
	    ;; Read the next token, or a macro character.
	    (MULTIPLE-VALUE (THING TYPE) (XR-READ-THING STREAM))
	    ;; If this is the first element of a list starting in column 0,
	    ;; and it is EVAL-WHEN or something like that,
	    ;; say it is ok for our sublists to start in column 0.
	    (AND THIS-IS-COLUMN-0-LIST
		 (EQ END-OF-LIST (LOCF LIST))
		 (SYMBOLP THING)
		 ;; It is usually dangerous for READ to look at properties of symbols,
		 ;; but this will only happen for the symbol after a paren in column 0
		 ;; and never in lists read in interactively.
		 (GET THING 'MAY-SURROUND-DEFUN)
		 (SETQ INSIDE-COLUMN-0-LIST NIL))
	    (COND ((EQ TYPE 'READER-MACRO)
		   (COND (XR-CORRESPONDENCE-FLAG
			  (FUNCALL STREAM ':UNTYI XR-XRTYI-LAST-CHAR)
			  (SETQ BP (FUNCALL STREAM ':READ-BP))
			  (FUNCALL STREAM ':TYI)))
		   (LET ((XR-LIST-SO-FAR LIST)
			 (XR-SPLICE-P NIL)
			 VALUES)
		     (SETQ VALUES (INVOKE-READER-MACRO THING STREAM))
		     (COND (XR-SPLICE-P
			    (SETQ LIST XR-LIST-SO-FAR)
			    (AND XR-CORRESPONDENCE-FLAG
				 (SETF (CADDR CORRESPONDENCE-ENTRY)
				       (FIRSTN (LENGTH LIST)
					       (CADDR CORRESPONDENCE-ENTRY))))
			    (SETQ END-OF-LIST
				  (COND ((ATOM LIST) (LOCF LIST))
					(T (LAST LIST)))))
			   (VALUES
			    (RPLACD END-OF-LIST
				    (SETQ VALUES (COPYLIST VALUES READ-AREA)))
			    (SETQ END-OF-LIST (LAST VALUES))
			    (AND XR-CORRESPONDENCE-FLAG
				 (SETQ XR-CORRESPONDENCE
				       `(,(CAR VALUES) ,BP NIL . ,XR-CORRESPONDENCE)))
			    )))
		   (GO A))
		  ((EQ TYPE 'SPECIAL-TOKEN)
		   (COND ((EQ THING 'EOF)
			  (OR (AND READ-CHECK-INDENTATION MISSING-CLOSEPAREN-REPORTED)
			      (SIGNAL-PROCEED-CASE
				(() 'SYS:READ-LIST-END-OF-FILE
				    "End of file on ~S in the middle of the list ~:S."
				    STREAM LIST)
				(:NO-ACTION
				 (IF READ-CHECK-INDENTATION
				     (SETQ MISSING-CLOSEPAREN-REPORTED T)))))
			  (RETURN LIST 'LIST))
			 (T (CERROR ':NO-ACTION NIL 'SYS:READ-ERROR-1
				    "Incorrect terminator, ~C not ~C."
				    XR-XRTYI-LAST-CHAR
				    STOP-CHAR))))
		  (T
		   (RPLACD END-OF-LIST (SETQ END-OF-LIST (NCONS-IN-AREA THING READ-AREA)))
		   (GO A)))))))

))

; From file CHSNCP.LISP SRC:<L.IO> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSNCP  "


(DEFF CONN-FINISHED-P 'FINISHED-P)
(MAKE-OBSOLETE FINISHED-P "use CHAOS:CONN-FINISHED-P")

))

; From file CHSNCP.LISP SRC:<L.IO> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSNCP  "


(DEFF FINISH-CONN 'FINISH)
(MAKE-OBSOLETE FINISH "use CHAOS:FINISH-CONN")

))

; From file CHSAUX.LISP SRC:<L.IO> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSAUX  "


(DEFF CLOSE-CONN 'CLOSE)
(DEFF CHAOS-CLOSE 'CLOSE)
(MAKE-OBSOLETE CLOSE "use CHAOS:CLOSE-CONN")
(MAKE-OBSOLETE CHAOS-CLOSE "use CHAOS:CLOSE-CONN")

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN READ-FROM-STRING-STREAM (OPERATION &OPTIONAL ARG1 &REST REST)
  (COND ((OR (EQ OPERATION ':TYI) (EQ OPERATION ':ANY-TYI))
	 (COND ((= *IOCH *IOEND)
		NIL)
	       (T (PROG2 NIL (AR-1 *IOLST *IOCH)
			     (SETQ *IOCH (1+ *IOCH))))))
	((EQ OPERATION ':UNTYI)
	 (WHEN ARG1
	   (SETQ *IOCH (1- *IOCH))))
	((EQ OPERATION ':GET-STRING-INDEX)
	 *IOCH)
	((EQ OPERATION ':WHICH-OPERATIONS)
	 '(:TYI :UNTYI :GET-STRING-INDEX))
	(T (STREAM-DEFAULT-HANDLER 'READ-FROM-STRING-STREAM OPERATION ARG1 REST))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN READLIST-STREAM (OPERATION &OPTIONAL ARG1 &REST REST)
  (COND ((OR (EQ OPERATION ':ANY-TYI)
	     (MEMQ OPERATION '(:TYI :TYI-NO-HANG :ANY-TYI-NO-HANG)))
	 (COND ((EQ *IOCH T)
		(FERROR NIL "EOF in middle of READLIST"))
	       ((NOT (NULL *IOCH))
		(PROG2 NIL *IOCH (SETQ *IOCH NIL)))
	       ((NULL *IOLST)
		(SETQ *IOCH T)
		40)
	       (T (PROG1 (CHARACTER (CAR *IOLST))
			 (SETQ *IOLST (CDR *IOLST))))))
	((EQ OPERATION ':UNTYI)
	 (SETQ *IOCH ARG1))
	((EQ OPERATION ':WHICH-OPERATIONS)
	 '(:TYI :UNTYI))
	(T (STREAM-DEFAULT-HANDLER 'READLIST-STREAM OPERATION ARG1 REST))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN NULL-STREAM (OP &REST ARGS &AUX TEM)
  "An i//o stream which ignores output and gives instant end-of-file on input."
  (SELECTQ-WITH-WHICH-OPERATIONS OP
    ;; These operations signal EOF.
    ((:TYI :TYI-NO-HANG :TYIPEEK :GET-INPUT-BUFFER :READ-INPUT-BUFFER
	   :ANY-TYI :ANY-TYI-NO-HANG)
     (AND (FIRST ARGS) (FERROR 'READ-END-OF-FILE "End of file on SI:NULL-STREAM.")))
    ;; Signals EOF differently.
    (:STRING-IN
     (AND (FIRST ARGS) (FERROR 'READ-END-OF-FILE "End of file on SI:NULL-STREAM."))
     (VALUES (THIRD ARGS) T))
    ;; Signals EOF still differently.
    (:LINE-IN
      (SETQ TEM (MAKE-ARRAY 0 ':TYPE 'ART-STRING
			      ':LEADER-LENGTH (AND (NUMBERP (FIRST ARGS)) (FIRST ARGS))))
      (AND (NUMBERP (FIRST ARGS))
	   (PLUSP (FIRST ARGS))
	   (STORE-ARRAY-LEADER 0 TEM 0))
      (VALUES TEM T))
    ;; These operations should all return their argument.
    ((:TYO :STRING-OUT :LINE-OUT :UNTYI)
     (FIRST ARGS))
    ((:INCREMENT-CURSORPOS :FINISH :FORCE-OUTPUT :CLEAR-OUTPUT :CLEAR-INPUT :LISTEN)
     NIL)
    ;; These operations should always return T.
    ((:CHARACTERS :BEEP) T)
    ;; Supports nothing in both directions.
    (:DIRECTION ':BIDIRECTIONAL)
    ;; Handle obscure operations.
    (OTHERWISE (STREAM-DEFAULT-HANDLER 'NULL-STREAM OP (FIRST ARGS) (REST1 ARGS)))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN STREAM-DEFAULT-HANDLER (FCTN OP ARG1 ARGS &AUX TEM)
  "Subroutine which provides default definition of certain stream operations.
If a stream does not recognize an operation, it may call this function
to have the operation handled.  The stream should return whatever
this function returns to it.  OP should be the operation, FCTN should
be the stream which received the operation, and ARG1 and ARGS should be
the arguments that came with the operation."
  (SELECTQ OP
    ((:TYIPEEK :LISTEN)
     (COND ((SETQ TEM (FUNCALL FCTN ':TYI NIL))
	    (FUNCALL FCTN ':UNTYI TEM)
	    TEM)))
    ((:ANY-TYI :TYI-NO-HANG)
     (FUNCALL FCTN ':TYI ARG1))
    (:ANY-TYI-NO-HANG
     (FUNCALL FCTN ':ANY-TYI ARG1))
    ((:CLEAR-OUTPUT :CLEAR-INPUT :FORCE-OUTPUT :FINISH :CLOSE :EOF)
     NIL)
    (:FRESH-LINE
     (FUNCALL FCTN ':TYO #\CR)
     T)
    ((:STRING-OUT :LINE-OUT)
     (SETQ TEM (STRING ARG1))
     (DO ((LEN (COND ((SECOND ARGS))
		     (T (STRING-LENGTH TEM))))
	  (I (COND ((FIRST ARGS)) (T 0))
	     (1+ I)))
	 ((>= I LEN) NIL)
       (FUNCALL FCTN ':TYO (AR-1 TEM I)))
     (AND (EQ OP ':LINE-OUT)
	  (FUNCALL FCTN ':TYO #\CR)))
    (:LINE-IN
     (LET ((BUF (MAKE-ARRAY 100 ':TYPE ART-STRING
			    ':LEADER-LENGTH (IF (NUMBERP ARG1) ARG1 1))))
       (STORE-ARRAY-LEADER 0 BUF 0)		;Fill pointer
       (VALUES BUF
	       (DO ((TEM (FUNCALL FCTN ':TYI NIL) (FUNCALL FCTN ':TYI NIL)))
		   ((OR (NULL TEM) (= TEM #\CR) (= TEM #\END))
		    (ADJUST-ARRAY-SIZE BUF (ARRAY-ACTIVE-LENGTH BUF))
		    (NULL TEM))
		 (ARRAY-PUSH-EXTEND BUF TEM)))))
    (:STRING-IN
     ;; ARG1 = EOF, (CAR ARGS) = STRING
     (LOOP WITH START = (OR (CADR ARGS) 0)
	   AND END = (OR (CADDR ARGS) (ARRAY-LENGTH (CAR ARGS)))
	   WHILE (< START END)
	   AS CH = (FUNCALL FCTN ':TYI)
	   WHILE CH
	   DO (ASET CH (CAR ARGS) (PROG1 START (INCF START)))
	   FINALLY (AND (ARRAY-HAS-LEADER-P (CAR ARGS))
			(STORE-ARRAY-LEADER START (CAR ARGS) 0))
		   (AND (NULL CH) ARG1 (FERROR 'END-OF-FILE-1 "End of file on ~S." FCTN))
		   (RETURN (VALUES START (NULL CH)))))
    (:STRING-LINE-IN
     ;; ARG1 = EOF, (CAR ARGS) = STRING
     (LOOP WITH START = (OR (CADR ARGS) 0)
	   AND END = (OR (CADDR ARGS) (ARRAY-LENGTH (CAR ARGS)))
	   WHILE (< START END)
	   AS CH = (FUNCALL FCTN ':TYI)
	   WHILE (AND CH (NEQ CH #\RETURN))
	   DO (ASET CH (CAR ARGS) (PROG1 START (INCF START)))
	   FINALLY (AND (ARRAY-HAS-LEADER-P (CAR ARGS))
			(STORE-ARRAY-LEADER START (CAR ARGS) 0))
		   (AND (NULL CH) ARG1 (FERROR 'END-OF-FILE-1 "End of file on ~S." FCTN))
		   (RETURN (VALUES START (NULL CH) (NEQ CH #\RETURN)))))
    (:TYI-NO-HANG (FUNCALL FCTN ':TYI ARG1))
    (:OPERATION-HANDLED-P (MEMQ ARG1 (FUNCALL FCTN ':WHICH-OPERATIONS)))
    (:CHARACTERS T)
    (:DIRECTION
     (LET ((OPS (FUNCALL FCTN ':WHICH-OPERATIONS)))
       (IF (MEMQ ':TYI OPS)
	   (IF (MEMQ ':TYO OPS) ':BIDIRECTIONAL ':INPUT)
	 (IF (MEMQ ':TYO OPS) ':OUTPUT NIL))))
    (:SEND-IF-HANDLES
     (IF (MEMQ ARG1 (FUNCALL FCTN ':WHICH-OPERATIONS))
	 (LEXPR-FUNCALL FCTN ARG1 ARGS)))
    (OTHERWISE
     (FERROR ':UNCLAIMED-MESSAGE "The stream operation ~S is not supported by ~S"
	     OP FCTN))))

))

; From file DEFMIC.LISP SRC:<L.SYS> OZ:
#8R COMPILER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "COMPILER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; DEFMIC  "

(DEFMIC GET 320 (SYMBOL PROPERTY &OPTIONAL DEFAULT) NIL T)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFUN PROMPT-AND-READ (OPTION FORMAT-STRING &REST FORMAT-ARGS)
  "Read an object from QUERY-IO according to OPTION, prompting using FORMAT-STRING and -ARGS.
OPTION says how to read the object and what its syntax is.  It can be:
 :READ -- use READ to read the object.
 :EVAL-READ -- read an s-expression and evaluate it.  Return the value.
 :EVAL-READ-OR-END -- Like :EVAL-READ, but user can also type just End,
   in which case we return NIL as first value and :END as second.
 (:EVAL-READ :DEFAULT <DEFAULT>) -- Like :EVAL-READ, but user can
   also type just Space to use the default.  Second value is :DEFAULT then.
 (:EVAL-READ-OR-END :DEFAULT <DEFAULT>) -- Analogous.
 :NUMBER -- read a number, terminated by Return or End.
 (:NUMBER :INPUT-RADIX <RADIX> :OR-NIL <BOOLEAN>) -- read using <RADIX> for IBASE,
   and if <BOOLEAN> is non-NIL it allows you to type just Return and returns NIL.
 :CHARACTER -- read one character and return it as a fixnum.
 :DATE -- read a date and return in universal time format.
 (:DATE :PAST-P <PAST-P> :NEVER-P <NEVER-P>) -- read a date.
   The value is in universal time format.
   If <NEVER-P> is non-NIL, /"never/" is accepted, meaning return NIL.
   If <PAST-P> is non-NIL, the date is required to be before the present.
 :STRING -- read a string, terminated by Return.
 :STRING-TRIM -- read a string, terminated by Return.
   Discard leading and trailing whitespace.
 :STRING-OR-NIL -- read a string, terminated by Return.
   Discard leading and trailing whitespace.  If string is empty, return NIL.
 :PATHNAME -- read a pathname and default it.
 (:PATHNAME :DEFAULTS <DEFAULTS-LIST> :VERSION <VERSION-DEFAULT>) --
   read a pathname and default it using the defaults list specified.
   <VERSION-DEFAULT> is passed as the fourth arg to FS:MERGE-PATHNAME-DEFAULTS.
 :PATHNAME-OR-NIL -- like :PATHNAME but if user types just End then NIL is returned.
 (:DELIMITED-STRING :DELIMITER <DELIM> :BUFFER-SIZE <SIZE>) --
   read a string terminated by <DELIM>, which should be a character or a list of them.
   <SIZE> specifies the size of string to allocate initially.
 :DELIMITED-STRING-OR-NIL -- like :DELIMITED-STRING but if user types
   an empty string then NIL is returned.
 (:FQUERY . FQUERY-OPTIONS) -- calls FQUERY with the options."
  (OR (LEXPR-SEND QUERY-IO ':SEND-IF-HANDLES ':PROMPT-AND-READ
		  OPTION FORMAT-STRING FORMAT-ARGS)
      (LET* ((OPTION-TYPE (IF (CONSP OPTION) (CAR OPTION) OPTION))
	     (FUNCTION (GET OPTION-TYPE 'PROMPT-AND-READ-FUNCTION))
	     (PROMPT-AND-READ-FORMAT-STRING FORMAT-STRING)
	     (PROMPT-AND-READ-FORMAT-ARGS FORMAT-ARGS))
	(COND ((GET OPTION-TYPE 'PROMPT-AND-READ-NO-RUBOUT-FUNCTION)
	       (FUNCALL (GET OPTION-TYPE 'PROMPT-AND-READ-NO-RUBOUT-FUNCTION)
			OPTION QUERY-IO))
	      ((NULL FUNCTION)
	       (FERROR NIL "~S is not a known PROMPT-AND-READ option keyword." OPTION-TYPE))
	      ((SEND QUERY-IO ':OPERATION-HANDLED-P ':RUBOUT-HANDLER)
	       (SEND QUERY-IO ':RUBOUT-HANDLER
		     (GET OPTION-TYPE 'PROMPT-AND-READ-RUBOUT-OPTIONS
			  '((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
			    (:ACTIVATION MEMQ (#\END #\RETURN))))
		     FUNCTION OPTION QUERY-IO))
	      (T
	       (FUNCALL FUNCTION OPTION QUERY-IO))))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFPROP :READ ((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
		(:ACTIVATION = #\END))
	 PROMPT-AND-READ-RUBOUT-OPTIONS)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFPROP :EXPRESSION ((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
		      (:ACTIVATION = #\END))
	 PROMPT-AND-READ-RUBOUT-OPTIONS)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFPROP :EXPRESSION-OR-END EXPRESSION-OR-END-PROMPT-AND-READ PROMPT-AND-READ-FUNCTION)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFPROP :EXPRESSION-OR-END ((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
			     (:ACTIVATION = #\END))
	 PROMPT-AND-READ-RUBOUT-OPTIONS)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN (:CHARACTER PROMPT-AND-READ-NO-RUBOUT-FUNCTION) (IGNORE STREAM)
  (PROMPT-AND-READ-PROMPT-FUNCTION STREAM NIL)
  (LET ((CHAR (SEND STREAM ':TYI))
	(STANDARD-OUTPUT STREAM))
    (FORMAT:OCHAR CHAR ':EDITOR)
    CHAR))

(DEFUN (:NUMBER PROMPT-AND-READ-FUNCTION) (OPTION STREAM)
  (LET ((IBASE (OR (AND (CONSP OPTION) (GET OPTION ':INPUT-RADIX)) IBASE))
	(STRING (READLINE-TRIM STREAM)))
    (IF (AND (CONSP OPTION) (GET OPTION ':OR-NIL)
	     (EQUAL STRING ""))
	NIL
      (CONDITION-CASE ()
	  (LET* ((NUMBER (READ-FROM-STRING STRING)))
	    (IF (NUMBERP NUMBER) NUMBER
	      (FERROR 'READ-ERROR-1 "That is not a number.")))
	(END-OF-FILE (FERROR 'READ-ERROR-1 "That is not a number."))))))

(DEFUN (:STRING-OR-NIL PROMPT-AND-READ-FUNCTION) (IGNORE STREAM)
  (READLINE-OR-NIL STREAM))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFUN (:PATHNAME-OR-END PROMPT-AND-READ-FUNCTION) (OPTION STREAM)
  (LET ((DEFAULTS (IF (CONSP OPTION) (GET OPTION ':DEFAULTS) FS:*DEFAULT-PATHNAME-DEFAULTS*)))
    (MULTIPLE-VALUE-BIND (STRING NIL TERMINATOR)
	(READLINE STREAM)
      (IF (AND (EQUAL STRING "") (EQ TERMINATOR #\END))
	  #\END
	(FS:MERGE-PATHNAME-DEFAULTS STRING DEFAULTS
				    FS:*NAME-SPECIFIED-DEFAULT-TYPE*
				    (OR (AND (CONSP OPTION) (GET OPTION ':DEFAULT-VERSION))
					':NEWEST))))))

(remprop ':pathname-or-end 'prompt-and-read-no-rubout-function)

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "


(DEFUN (:PATHNAME-OR-NIL PROMPT-AND-READ-FUNCTION) (OPTION STREAM)
  (LET ((DEFAULTS (IF (CONSP OPTION) (GET OPTION ':DEFAULTS) FS:*DEFAULT-PATHNAME-DEFAULTS*)))
    (MULTIPLE-VALUE-BIND (STRING NIL TERMINATOR)
	(READLINE STREAM)
      (UNLESS (AND (EQUAL STRING "") (EQ TERMINATOR #\END))
	(FS:MERGE-PATHNAME-DEFAULTS STRING DEFAULTS
				    FS:*NAME-SPECIFIED-DEFAULT-TYPE*
				    (OR (AND (CONSP OPTION) (GET OPTION ':DEFAULT-VERSION))
					':NEWEST))))))

(remprop ':pathname-or-nil 'prompt-and-read-no-rubout-function)

(DEFUN (:FQUERY PROMPT-AND-READ-NO-RUBOUT-FUNCTION) (OPTION QUERY-IO)
  (LEXPR-FUNCALL 'FQUERY (IF (LISTP OPTION) (CDR OPTION))
		 PROMPT-AND-READ-FORMAT-STRING PROMPT-AND-READ-FORMAT-ARGS))

(DEFUN (:DELIMITED-STRING PROMPT-AND-READ-NO-RUBOUT-FUNCTION) (OPTION STREAM)
  (READ-DELIMITED-STRING (OR (AND (CONSP OPTION) (GET OPTION ':DELIMITER)) #\END)
			 STREAM NIL '((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION))
			 (OR (AND (CONSP OPTION) (GET OPTION ':BUFFER-SIZE)) 100)))

(DEFUN (:DELIMITED-STRING-OR-NIL PROMPT-AND-READ-NO-RUBOUT-FUNCTION) (OPTION STREAM)
  (LET ((STRING
	  (READ-DELIMITED-STRING (OR (AND (CONSP OPTION) (GET OPTION ':DELIMITER)) #\END)
				 STREAM NIL '((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION))
				 (OR (AND (CONSP OPTION) (GET OPTION ':BUFFER-SIZE)) 100))))
    (IF (EQUAL STRING "") NIL STRING)))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN READ-DELIMITED-STRING (&OPTIONAL (DELIMITER #/END) (STREAM STANDARD-INPUT)
			      EOF RH-OPTIONS (BUFFER-SIZE 100.))
  "Reads input from STREAM until DELIMITER is found; returns a string.
Uses the rubout handler if STREAM supports that.
DELIMITER is either a character or a list of characters.
 (Characters may be fixnums or character objects).
Values are:
 The string of characters read, not including the delimiter
 T if input ended due to end of file
 The delimiter character read (as a fixnum), or NIL if ended at EOF.
EOF if non-NIL means get error on end of file before any input is got.
RH-OPTIONS are passed to the :RUBOUT-HANDLER operation.
BUFFER-SIZE is the size to make the buffer string, initially."
  (DECLARE (VALUES STRING EOF-FLAG DELIMITER))
  (IF (AND (NOT RUBOUT-HANDLER)
	   (SEND STREAM ':OPERATION-HANDLED-P ':RUBOUT-HANDLER))
      (SEND STREAM ':RUBOUT-HANDLER
	    (CONS (LIST ':ACTIVATION 'MEMQ
			(IF (CONSP DELIMITER) DELIMITER (LIST DELIMITER)))
		  RH-OPTIONS)
	    'READ-DELIMITED-STRING DELIMITER STREAM EOF NIL BUFFER-SIZE)
    (DO ((BUFFER (MAKE-ARRAY BUFFER-SIZE ':TYPE ART-STRING ':FILL-POINTER 0)))
	(())
      (LET ((CH (SEND STREAM ':ANY-TYI (AND EOF (ZEROP (LENGTH BUFFER))))))
	(COND ((NULL CH)
	       (RETURN BUFFER T))
	      ((CONSP CH)
	       (WHEN (EQ (CAR CH) ':ACTIVATION)
		 (SEND STREAM ':TYO (CADR CH))
		 (RETURN BUFFER NIL (CADR CH))))
	      ((AND (NOT RUBOUT-HANDLER)
		    (IF (CONSP DELIMITER) (MEMQ CH DELIMITER) (EQ CH DELIMITER)))
	       (RETURN BUFFER NIL CH))
	      (T
	       (ARRAY-PUSH-EXTEND BUFFER CH)))))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN EXPRESSION-OR-END-PROMPT-AND-READ (IGNORE STREAM)
  (LET ((CH (SEND STREAM ':ANY-TYI)))
    (IF (OR (AND (CONSP CH) (EQ (CAR CH) ':ACTIVATION))
	    (AND (NOT RUBOUT-HANDLER) (EQ CH #\END)))
	(PROGN
	  (IF (CONSP CH)
	      (SEND STREAM ':TYO (CADR CH)))
	  (VALUES NIL ':END))
      (WHEN (ATOM CH) (SEND STREAM ':UNTYI CH))
      (VALUES (READ STREAM)))))

))

; From file LMMAC.LISP SRC:<L.SYS2> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; LMMAC  "

(defmacro with-input-editing ((stream rubout-options . brand-s-compatibility-args) &body body)
  "Execute BODY inside of STREAM's :RUBOUT-HANDLER method.
If BODY does input from STREAM, it will be done with rubout processing
if STREAM implements any.
RUBOUT-OPTIONS should be the options for the :RUBOUT-HANDLER message, such as 
 (:NO-INPUT-SAVE T)   -- don't save this batch of input in the history.
 (:FULL-RUBOUT T)     -- return from this construct if rubout buffer becomes empty.
 (:INITIAL-INPUT string) -- start out with that string in the buffer.
 (:INITIAL-INPUT-POINTER n) -- start out with editing pointer n chars from start.
 (:ACTIVATION fn x-args) -- fn is used to test characters for being activators.
	fn's args are the character read followed by the x-args from the option.
        If fn returns non-NIL, the character is an activation.
	It makes a blip (:ACTIVATION char numeric-arg)
	which BODY can read with :ANY-TYI.
 (:DO-NOT-ECHO chars...) -- poor man's activation characters.
	This is like the :ACTIVATION option except that: characters are listed explicitly;
	and the character itself is returned when it is read,
	rather than an :ACTIVATION blip.
 (:COMMAND fn x-args) -- tests like :ACTIVATION, but command chars do a different thing.
	If fn returns non-NIL, the character is a command character.
	The :RUBOUT-HANDLER operation (and therefore the WITH-INPUT-EDITING)
	returns instantly these two values: (:COMMAND char numeric-arg) :COMMAND.
	The input that was buffered remains in the buffer.
 (:PREEMPTABLE token) -- makes all blips act like command chars.
	If the rubout handler encounters a blip while reading input,
	it instantly returns two values: the blip itself, and the specified token.
	Any buffered input remains buffered for the next request for input editing.
 (:PASS-THROUGH (char doc)...) -- user-implemented /"editing/" commands.
	If any char in the alist is read by the rubout handler,
	it is returned to the caller (that is, to an :ANY-TYI in BODY).
	BODY should process these characters in appropriate ways and keep reading.
 (:PROMPT fn-or-string)
	Says how to prompt initially for the input.
	If a string, it is printed; otherwise it is called with two args,
	the stream and a character which is an editing command that says
	why the prompt is being printed.
 (:REPROMPT fn-or-string)
	Same as :PROMPT except used only if the input is reprinted
	for some reason after editing has begun.  The :REPROMPT option
	is not used on initial entry.  If both :PROMPT and :REPROMPT
        are specified, :PROMPT is used on initial entry and :REPROMPT thereafter."
  (let ((keyword (cadr brand-s-compatibility-args)))
    (unless stream (setq stream 'standard-input))
    `(flet ((do-it () . ,body))
       (if (send ,stream ':operation-handled-p ':rubout-handler)
	   ,(if keyword
		`(with-stack-list* (options
				     ',(selectq keyword
					 (:end-activation '(:activation = #/end))
					 ((:line :line-activation)
					  '(:activation memq (#/end #/return))))
				     ,rubout-options)
		   (send ,stream ':rubout-handler options #'do-it))
	      `(send ,stream ':rubout-handler ,rubout-options #'do-it))
	 (do-it)))))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN EVAL-READ-OR-END-PROMPT-AND-READ (OPTION STREAM)
  (DO (VALUE FORM FLAG)
      (())
    (ERROR-RESTART (ERROR "Try again to type this input.")
      (MULTIPLE-VALUE (FORM FLAG)
	(WITH-INPUT-EDITING (STREAM
			      '((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
				(:ACTIVATION = #\END)))
	  (LET ((CH (SEND STREAM ':ANY-TYI)))
	    (COND ((AND (CONSP OPTION) (GET-LOCATION-OR-NIL OPTION ':DEFAULT)
			(EQ CH #\SP))
		   (VALUES (GET OPTION ':DEFAULT) ':DEFAULT))
		  ((AND (CONSP CH)
			(EQ (CAR CH) ':ACTIVATION))
		   (SEND STREAM ':TYO (CADR CH))
		   (VALUES NIL ':END))
		  ((EQ CH #\END) (VALUES NIL ':END))
		  (T (UNLESS (CONSP CH) (SEND STREAM ':UNTYI CH))
		     (VALUES (READ STREAM)))))))
      (IF FLAG (RETURN FORM FLAG)
	(SETQ VALUE (EVAL-ABORT-TRIVIAL-ERRORS FORM))))
    ;; If FORM was not trivial, ask for confirmation of the value it returned.
    (WHEN (OR (TRIVIAL-FORM-P FORM)
	      (LET ((PRINLEVEL EVAL-READ-PRINLEVEL)
		    (PRINLENGTH EVAL-READ-PRINLENGTH))
		(FQUERY '(:LIST-CHOICES NIL) "The object is ~S, ok? " VALUE)))
      (RETURN VALUE))
    (TERPRI STREAM)))

))

; From file QIO.LISP SRC:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QIO  "

(DEFUN EVAL-READ-PROMPT-AND-READ (OPTION STREAM)
  (DO (VALUE FORM FLAG)
      (())
    (ERROR-RESTART (ERROR "Try again to type this input.")
      (MULTIPLE-VALUE (FORM FLAG)
	(WITH-INPUT-EDITING (STREAM
			      '((:PROMPT PROMPT-AND-READ-PROMPT-FUNCTION)
				(:ACTIVATION = #\END)))
	  (LET ((CH (SEND STREAM ':TYI)))
	    (COND ((AND (CONSP OPTION) (GET-LOCATION-OR-NIL OPTION ':DEFAULT)
			(EQ CH #\SP))
		   (VALUES (GET OPTION ':DEFAULT) ':DEFAULT))
		  (T (SEND STREAM ':UNTYI CH)
		     (VALUES (READ STREAM)))))))
      (IF FLAG (RETURN FORM FLAG)
	(SETQ VALUE (EVAL-ABORT-TRIVIAL-ERRORS FORM))))
    ;; If FORM was not trivial, ask for confirmation of the value it returned.
    (WHEN (OR (TRIVIAL-FORM-P FORM)
	      (LET ((PRINLEVEL EVAL-READ-PRINLEVEL)
		    (PRINLENGTH EVAL-READ-PRINLENGTH))
		(FQUERY '(:LIST-CHOICES NIL) "The object is ~S, ok? " VALUE)))
      (RETURN VALUE))
    (TERPRI STREAM)))

))

; From file PATHST.LISP SRC:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; PATHST  "

(DEFMETHOD (LOGICAL-PATHNAME :CHARACTER-NEEDS-QUOTING-P) (CH)
  (OR ( #/a CH #/z)
      (MEMQ CH '(#/: #/; #/ #/ #\SP #/. #\TAB))))

))
