;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 5/10/84 01:23:10 by RpK,
;;; Reason: ZWEI: Electric Font Lock mode is considered appropriate only if there's more than
;;;  one font in the attribute list.
;;; TV: Changing a window's label changes the string, not the font.
;;; Hardcopy: (In the SI: package)
;;;  (SET-PRINTER-DEFAULT-OPTION printer-type option value) allows the user to set a
;;;  default option for a printer type, which the hardcopy functions look at.
;;;  A common use at MIT may be (SI:SET-PRINTER-DEFAULT-OPTION :DOVER :SPOOL T)
;;;  Currently defaultable options are :FONT, :FONT-LIST, :HEADING-FONT, :PAGE-HEADINGS,
;;;  :VSP, :COPIES, and :SPOOL.
;;; while running on Lisp Machine Five from band 6
;;; with Don't-dump-a-band! Inconsistent (unreleased patches loaded) System 98.48, CADR 3.6, ZMail 53.17, MIT-Specific 22.0, microcode 309, ZM MIT.



; From file MODES.LISP PS:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; MODES  "

(DEFUN ELECTRIC-FONT-LOCK-IF-APPROPRIATE ()
  "Turn on Electric Font Lock Mode if there's more than one font in the attribute list."
  (IF (LET ((FONTS (SEND *INTERVAL* :GET-ATTRIBUTE :FONTS)))
	(AND FONTS
	     (LISTP FONTS)
	     (> (LENGTH FONTS) 1)))
      (TURN-ON-MODE 'ELECTRIC-FONT-LOCK-MODE)
    (TURN-OFF-MODE 'ELECTRIC-FONT-LOCK-MODE)))

))

; From file SCRED.LISP PS:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; SCRED  "

(DEFUN SCREEN-EDITOR-EDIT-ATTRIBUTES (WINDOW)
  (LOCALLY 
    (DECLARE (SPECIAL BORDER-MARGIN-WIDTH-VALUE CURRENT-FONT-VALUE MORE-P-VALUE 
		      REVERSE-VIDEO-P BORDERS-SPEC LABEL-OR-NAME VSP IN-ACTION
		      CHAR-ALU-FCN ERASE-ALU-FCN PRIORITY-VALUE SAVE-BITS-VALUE
		      OUT-ACTION OTHER-OUT-ACTION))
    (LET ((BORDERS-P (SEND WINDOW ':OPERATION-HANDLED-P ':SET-BORDERS))
	  (LABEL-P (SEND WINDOW ':OPERATION-HANDLED-P ':SET-LABEL))
	  (NAME-P (SEND WINDOW ':OPERATION-HANDLED-P ':SET-NAME)))
      (LET* ((CURRENT-FONT-VALUE (FUNCALL WINDOW ':CURRENT-FONT))
	     (OLD-CURRENT-FONT-VALUE CURRENT-FONT-VALUE)
	     (MORE-P-VALUE (FUNCALL WINDOW ':MORE-P))
	     (OLD-MORE-P-VALUE MORE-P-VALUE)
	     (REVERSE-VIDEO-P (FUNCALL WINDOW ':REVERSE-VIDEO-P))
	     (OLD-REVERSE-VIDEO-P REVERSE-VIDEO-P)
	     (VSP (FUNCALL WINDOW ':VSP))
	     (OLD-VSP VSP)
	     (IN-ACTION (FUNCALL WINDOW ':DEEXPOSED-TYPEIN-ACTION))
	     (OLD-IN-ACTION IN-ACTION)
	     (OUT-ACTION (FUNCALL WINDOW ':DEEXPOSED-TYPEOUT-ACTION))
	     (OLD-OUT-ACTION OUT-ACTION)
	     (OTHER-OUT-ACTION)
	     (OLD-OTHER-OUT-ACTION)
	     (CHAR-ALU-FCN (FUNCALL WINDOW ':CHAR-ALUF))
	     (OLD-CHAR-ALU-FCN CHAR-ALU-FCN)
	     (ERASE-ALU-FCN (FUNCALL WINDOW ':ERASE-ALUF))
	     (OLD-ERASE-ALU-FCN ERASE-ALU-FCN)
	     (PRIORITY-VALUE (FUNCALL WINDOW ':PRIORITY))
	     (OLD-PRIORITY-VALUE PRIORITY-VALUE)
	     (SAVE-BITS-VALUE (FUNCALL WINDOW ':SAVE-BITS))
	     (OLD-SAVE-BITS-VALUE SAVE-BITS-VALUE)
	     (LABEL-OR-NAME (COND (NAME-P (FUNCALL WINDOW ':NAME))
				  (LABEL-P (FUNCALL WINDOW ':LABEL))))
	     (OLD-LABEL-OR-NAME LABEL-OR-NAME)
	     (BORDERS-SPEC (IF BORDERS-P (FUNCALL WINDOW ':BORDERS)))
	     (OLD-BORDERS-SPEC BORDERS-SPEC)
	     (BORDER-MARGIN-WIDTH-VALUE (IF BORDERS-P (FUNCALL WINDOW ':BORDER-MARGIN-WIDTH)))
	     (OLD-BORDER-MARGIN-WIDTH-VALUE BORDER-MARGIN-WIDTH-VALUE))
	(IF (CONSP BORDERS-SPEC)		;********************
	    (SETQ BORDERS-SPEC (- (FOURTH (FIRST BORDERS-SPEC))
				  (SECOND (FIRST BORDERS-SPEC)))))
	(IF (CONSP LABEL-OR-NAME)
	    (SETQ LABEL-OR-NAME (SIXTH LABEL-OR-NAME)))
	(COND ((NOT (MEMQ OUT-ACTION '(:NORMAL :NOTIFY :PERMIT :ERROR)))
	       (SETQ OTHER-OUT-ACTION OUT-ACTION
		     OLD-OTHER-OUT-ACTION OTHER-OUT-ACTION
		     OUT-ACTION ':OTHER
		     OLD-OUT-ACTION OUT-ACTION)))
	(MULTIPLE-VALUE-BIND (NIL ABORT-P)
	    (*CATCH 'ABORT-EDIT
	      (CHOOSE-VARIABLE-VALUES
	       (MAKE-ATTRIBUTES-LIST WINDOW BORDERS-P LABEL-P NAME-P)
	       ':LABEL (FORMAT NIL "Edit window attributes of ~A." WINDOW)
	       ':MARGIN-CHOICES '("Done" ("Abort" (*THROW 'ABORT-EDIT NIL)))
	       ':FUNCTION 'ATTRIBUTE-EDITOR-HOOK))
	  (COND (ABORT-P
		 (BEEP))
		(T
		 (IF (NEQ CURRENT-FONT-VALUE OLD-CURRENT-FONT-VALUE)
		     (FUNCALL WINDOW ':SET-CURRENT-FONT CURRENT-FONT-VALUE))
		 (IF (NEQ MORE-P-VALUE OLD-MORE-P-VALUE)
		     (FUNCALL WINDOW ':SET-MORE-P MORE-P-VALUE))
		 (IF (NEQ REVERSE-VIDEO-P OLD-REVERSE-VIDEO-P)
		     (FUNCALL WINDOW ':SET-REVERSE-VIDEO-P REVERSE-VIDEO-P))
		 (IF (NEQ VSP OLD-VSP)
		     (FUNCALL WINDOW ':SET-VSP VSP))
		 (IF (NEQ IN-ACTION OLD-IN-ACTION)
		     (FUNCALL WINDOW ':SET-DEEXPOSED-TYPEIN-ACTION IN-ACTION))
		 (COND ((NEQ OUT-ACTION OLD-OUT-ACTION)
			(FUNCALL WINDOW ':SET-DEEXPOSED-TYPEOUT-ACTION
				 (IF (EQ OUT-ACTION ':OTHER)
				     OTHER-OUT-ACTION
				     OUT-ACTION)))
		       ((AND (EQ OUT-ACTION ':OTHER)
			     (NEQ OTHER-OUT-ACTION OLD-OTHER-OUT-ACTION))
			(FUNCALL WINDOW ':SET-DEEXPOSED-TYPEOUT-ACTION OTHER-OUT-ACTION)))
		 (IF (NEQ CHAR-ALU-FCN OLD-CHAR-ALU-FCN)
		     (FUNCALL WINDOW ':SET-CHAR-ALUF CHAR-ALU-FCN))
		 (IF (NEQ ERASE-ALU-FCN OLD-ERASE-ALU-FCN)
		     (FUNCALL WINDOW ':SET-ERASE-ALUF ERASE-ALU-FCN))
		 (IF (NEQ PRIORITY-VALUE OLD-PRIORITY-VALUE)
		     (FUNCALL WINDOW ':SET-PRIORITY PRIORITY-VALUE))
		 (IF (NEQ SAVE-BITS-VALUE OLD-SAVE-BITS-VALUE)
		     (FUNCALL WINDOW ':SET-SAVE-BITS SAVE-BITS-VALUE))
		 (IF (NEQ LABEL-OR-NAME OLD-LABEL-OR-NAME)
		     (COND (NAME-P (SEND WINDOW :SET-NAME LABEL-OR-NAME))
			   (LABEL-P (SETF (SIXTH OLD-LABEL-OR-NAME) LABEL-OR-NAME)
				    (SEND WINDOW :SET-LABEL OLD-LABEL-OR-NAME))))
		 (COND (BORDERS-P
			(IF (NEQ BORDERS-SPEC OLD-BORDERS-SPEC)
			    (FUNCALL WINDOW ':SET-BORDERS BORDERS-SPEC))
			(IF (NEQ BORDER-MARGIN-WIDTH-VALUE OLD-BORDER-MARGIN-WIDTH-VALUE)
			    (FUNCALL WINDOW ':SET-BORDER-MARGIN-WIDTH
				     BORDER-MARGIN-WIDTH-VALUE))
			)))))))))

))

; From file QMISC.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QMISC  "


(DEFMACRO SET-PRINTER-DEFAULT-OPTION (PRINTER-TYPE OPTION VALUE)
  "For all printers of PRINTER-TYPE, default OPTION to VALUE"
  `(SETF (GET ,PRINTER-TYPE ,OPTION) ,VALUE))

(DEFVAR *PRINTER-OPTIONS* '(:FONT :FONT-LIST :HEADING-FONT :PAGE-HEADINGS :VSP
			    :COPIES :SPOOL)
  "A list of keyword options that can be defaulted on a per-printer-type basis.
This is looked at by SI:GET-PRINTER-DEFAULT-OPERATIONS.")

;;; Any HARDCOPY-function that actually does printing should call this to let the
;;; have more control over the printing.
(DEFUN GET-PRINTER-DEFAULT-OPTIONS (PRINTER SUPPLIED-OPTIONS &AUX V)
  "Returns a list of default options with the SUPPLIED-OPTIONS.
A default for a printer type is set with SET-PRINTER-DEAFULT-OPTION.
Defined options to default are in the list SI:*PRINTER-OPTIONS*; your printer
type may want to PUSHNEW a symbol on this."
  (IF (CONSP PRINTER) (SETQ PRINTER (CAR PRINTER)))
  (DOLIST (O *PRINTER-OPTIONS*)
    (UNLESS ;; supplied-p
      (DO ((SUPPLIED SUPPLIED-OPTIONS (CDDR SUPPLIED)))
	  ((NULL SUPPLIED) ())
	(IF (EQ O (CAR SUPPLIED)) (RETURN T)))
      (AND (SETQ V (GET PRINTER O))
	   (SETQ SUPPLIED-OPTIONS (CONS O (CONS V SUPPLIED-OPTIONS))))))
  SUPPLIED-OPTIONS)

(DEFUN HARDCOPY-FILE (FILE-NAME &REST OPTIONS
		      &KEY &OPTIONAL FORMAT (PRINTER *DEFAULT-PRINTER*)
		      &ALLOW-OTHER-KEYS
		      &AUX (PATHNAME (FS:MERGE-PATHNAME-DEFAULTS FILE-NAME)))
  "Print the file FILE-NAME on a printer.
:FORMAT specifies the file format; options are :TEXT, :PRESS, :XGP or :SUDS-PLOT.
:PRINTER specifies the printer to use; default is SI:*DEFAULT-PRINTER*.
:FONT specifies the font to use; or, :FONT-LIST a list of fonts to use.
:HEADING-FONT specifies the font for page headings.
:PAGE-HEADINGS NIL inhibits generation of page headings.
:VSP is the space to leave between lines, in micas [only for printers that use press]
:COPIES specifies the number of copies to be printed.
:SPOOL T says spool the file, if the selected printer has optional spooling."
  (DECLARE (ARGLIST FILE-NAME
		    &KEY &OPTIONAL FORMAT
		    (FONT "LPT8") FONT-LIST HEADING-FONT
		    (PAGE-HEADINGS T) VSP (COPIES 1) SPOOL))
  (OR FORMAT
      (SETQ FORMAT
	    (SELECTOR (SEND PATHNAME ':TYPE) EQUALP
	      (("PRESS" "PRE") ':PRESS)
	      ("XGP" ':XGP)
	      ("PLT" ':SUDS-PLOT)
	      (T ':TEXT))))
  (APPLY (DECODE-PRINTER-ARGUMENT PRINTER 'PRINT-FILE)
	 PRINTER FILE-NAME ':FORMAT FORMAT (GET-PRINTER-DEFAULT-OPTIONS PRINTER OPTIONS)))

(DEFUN HARDCOPY-STREAM (STREAM &REST OPTIONS
			&KEY &OPTIONAL (PRINTER *DEFAULT-PRINTER*)
			&ALLOW-OTHER-KEYS)
  "Print the text read from STREAM on a printer.
:PRINTER specifies the printer to use; default is SI:*DEFAULT-PRINTER*.
:FILE-NAME is an arbitrary string to use as the /"filename/" on the listing.
:FONT specifies the font to use; or, :FONT-LIST a list of fonts to use.
:HEADING-FONT specifies the font for page headings.
:PAGE-HEADINGS NIL inhibits generation of page headings.
:VSP is the space to leave between lines, in micas [only for printers that use press]
:COPIES specifies the number of copies to be printed.
:SPOOL T says spool the file, if the selected printer has optional spooling."
  (DECLARE (ARGLIST STREAM
		    &KEY &OPTIONAL FILE-NAME
		    (FONT "LPT8") FONT-LIST HEADING-FONT
		    (PAGE-HEADINGS T) VSP (COPIES 1) SPOOL))
  (APPLY (DECODE-PRINTER-ARGUMENT PRINTER 'PRINT-STREAM)
	 PRINTER STREAM (GET-PRINTER-DEFAULT-OPTIONS PRINTER OPTIONS)))

(DEFUN HARDCOPY-BIT-ARRAY (ARRAY LEFT TOP RIGHT BOTTOM &REST OPTIONS
			   &KEY &OPTIONAL
			   (PRINTER (OR *DEFAULT-BIT-ARRAY-PRINTER* *DEFAULT-PRINTER*))
			   &ALLOW-OTHER-KEYS)
  "Print all or part of the bits in ARRAY on the printer PRINTER.
PRINTER defaults to SI:*DEFAULT-BIT-ARRAY-PRINTER*,
 or to SI:*DEFAULT-PRINTER* if the former is NIL.
LEFT, TOP, RIGHT, BOTTOM specify the part of the array to print,
 measuring from the top left corner."
  (APPLY (DECODE-PRINTER-ARGUMENT PRINTER 'PRINT-BIT-ARRAY)
	 PRINTER ARRAY LEFT TOP RIGHT BOTTOM
	 (GET-PRINTER-DEFAULT-OPTIONS PRINTER OPTIONS)))

))
