;;; -*- Mode: Lisp; Package: SYSTEM-INTERNALS; Base: 10.; Readtable:T -*-

;;; This file contains information on the physical location of the various
;;; lisp machines.
;;; 
;;; For MIT: OZ:SRC:<L.SITE>LMLOCS.LISP.
;;; 
;;; Format is
;;; (name machine-name finger-location (building floor) associated-machine
;;;   site-keyword-overriding-alist)
;;; 
;;; Each machine is the only source of knowledge of where it is; all
;;; programs which print machine locations ask each machine for its
;;; location.
;;; 
;;; To change a machine's location knowledge:
;;; 
;;; (1) Edit this file to correctly list the affected machine's location.
;;; 
;;; (2) Compile this file on a LispM, with (MAKE-SYSTEM 'SITE 'COMPILE)
;;; 
;;; (3) Load it by doing (MAKE-SYSTEM 'SITE).
;;; 
;;; To make this knowledge permanent, do (DISK-SAVE <n>) immediately after
;;; loading the qfasl file.  This will add the new location knowledge to
;;; the band that you loaded the file into.  See the LispM Manual, section
;;; 32.10, for more information on saving and restoring bands.

(DEFCONST MACHINE-LOCATION-ALIST
 '(
   
   ("MIT-LISPM-2"  "Lisp Machine Two"       "7th x8975 Fairway twixt 797 and 749"
    (MIT-NE43 7) "OZ")				
   
   ("MIT-LISPM-3"  "Lisp Machine Three"     "901 Vision x3482, 902 Vision x6769"
    (MIT-NE43 9) "OZ") 
   
   ("MIT-LISPM-4"  "Lisp Machine Four"      "7th Fellini's Chroma x8975"
    (MIT-NE43 7) "OZ") 
   
   ("MIT-LISPM-5"  "Lisp Machine Five"      "904 Micro-Automation x3416"
    (MIT-NE43 9) "OZ") 
   
   ("MIT-LISPM-6"  "Lisp Machine Six"       "915/916 Robot Lab"
    (MIT-NE43 7) "OZ") 
   
   ("MIT-LISPM-7"  "Lisp Machine Seven"     "936 Lisp Machine Hangar x6703"
    (MIT-NE43 9) "OZ") 
   
   ("MIT-LISPM-8"  "Lisp Machine Eight"     "7th Outside 740 (no phone)"
    (MIT-NE43 7) "OZ") 
   
   ("MIT-LISPM-9"  "Lisp Machine Nine"      "3rd outside 371 (no phone)"
    (MIT-NE43 3) "MC") 
   
   ("MIT-ARTHUR" "Arthur Dent"              "38-350 Derelict Spaceport x4650"
    (MIT-38 3) "EE") 
   
   ("MIT-LISPM-12" "Lisp Machine Twelve"    "3rd Floor Medical Ward x????"
    (MIT-NE43 3) "MC") 
   
   ("MIT-MARVIN" "Marvin"	            "38-350 Derelict Spaceport x4650"
    (MIT-38 3) "EE") 
   
   ("MIT-FORD" "Ford Prefect"               "38-350 Derelict Spaceport x4650"
    (MIT-38 3) "EE") 
   
   ("MIT-LISPM-15" "Lisp Machine Fifteen"   "702 Namelossage (Don't blame us!) x8974"
    (MIT-NE43 7) "OZ")
   
   ("MIT-LISPM-16" "Lisp Machine Sixteen"   "367 Patil x3539"
    (MIT-NE43 3) "MC") 
   
   ("MIT-ZARNIWOOP" "Zarniwoop"             "38-301 EE-CS Machine Room x5624"
    (MIT-38 3) "EE") 
   
   ("MIT-LISPM-20" "Lisp Machine Twenty"    "4th Floor Hallway (no phone)"
    (MIT-NE43 4) "MC")

   ("MIT-LISPM-23" "Lisp Machine Twenty-three" "7th floor Vision (no phone)"
    (MIT-NE43 7) "OZ")
   
   ("MIT-LISPM-24" "Lisp Machine Twenty-four" "903 Mobile Robot Group x3416"
    (MIT-NE43 9) "OZ")
   
   ("MIT-LISPM-25" "Lisp Machine Twenty-five" "904 Near the Puma x3416"
    (MIT-NE43 9) "OZ")

   ("MIT-POLAR"    "Lisp Machine Polar"       "Peech Imspediment Zoo x4672"
    (MIT-36 5) "SPEECH")

   ("MIT-LISPM-29" "Lisp Machine Twenty-nine" "252 Dataflow Sanctuary x8856"
    (MIT-NE43 2) "XX")

   ("MIT-LISPM-30" "Lisp Machine Thirty" "903 Mobile Robot Group x3416"
    (MIT-NE43 9) "OZ")

   ("MIT-LISPM-31" "Lisp Machine Thirty-one" "836 Brooks x5223"
    (MIT-NE43 8) "OZ")

   ("MIT-LISPM-32" "Lisp Machine Thirty-two" "913 Hand Lab x8596"
    (MIT-NE43 9) "OZ")

   ("MIT-APIARY-3" "Lisp Machine Apiary-3"  "811 x5875"
    (MIT-NE43 8) "OZ")

   ("MIT-APIARY-4" "Lisp Machine Apiary-4"  "811 X5875"
    (MIT-NE43 8) "OZ")

   ("MIT-APIARY-5" "Lisp Machine Apiary-5"  "812 Apiary x7891"
    (MIT-NE43 8) "OZ")

   ("MIT-APIARY-6" "Lisp Machine Apiary-6"  "812 Apiary x7891"
    (MIT-NE43 8) "OZ")

   ("MIT-APIARY-7" "Lisp Machine Apiary-7"  "809"
    (MIT-NE43 8) "OZ")

   ("MIT-APIARY-8" "Lisp Machine Apiary-8"  "814"
    (MIT-NE43 8) "OZ")

   ("MIT-ROBOT-1" "Lisp Machine Robot-1"  "Near 759 (1024k)"
    (MIT-NE43 3) "OZ")

   ("MIT-ROBOT-2" "Lisp Machine Robot-2"  "Near the puma"
    (MIT-NE43 3) "OZ")

   ("MIT-ROBOT-3" "Lisp Machine Robot-3"  "790, Sundar Narasimhan x3-2483"
    (MIT-NE43 3) "OZ")

   ("MIT-ROBOT-4" "Lisp Machine Robot-4"  "792, No intelligent life"
    (MIT-NE43 3) "OZ")

   ("MIT-SARAH" "Sarah Bernhardt"  "356a Mrs. Thompson's Social Club x3194"
    (MIT-NE43 3) "OZ")

   ("MIT-PI" "PI Project"           "800b Theory of Computation x6072"
    (MIT-NE43 8) "OZ")

;No longer in host table.
;   ("MIT-EURIDICE" "MFE Euridice" "2nd floor machine room"
;    (MIT-NE43 2) "XX")

;   ("MIT-ORFEO" "MFE Orfeo" "2nd floor machine room"
;    (MIT-NE43 2) "XX")
   
   ("MIT-LIVE-OAK" "MEF Live Oak" "238 Soley, Fuqua, Lim x8860"
    (MIT-NE43 2) "XX")

   ("MIT-CHERRY" "MEF Cherry" "238 Soley, Fuqua, Lim x8860"
    (MIT-NE43 2) "XX")

   ("MIT-JANIS" "Lisp Machine Janis Joplin" "7th floor playroom"
    (MIT-NE43 7) "OZ")

   ("MIT-JIMI" "Lisp Machine Jimi Hendrix" "7th floor by phone closet"
    (MIT-NE43 7) "OZ")

   ("MIT-ELVIS" "Lisp Machine Elvis Presley" "725 Knight x7807"
    (MIT-NE43 7) "OZ")

   ("MIT-BUDDY" "Lisp Machine Buddy Holly" "708 Tardis"
    (MIT-NE43 7) "OZ")

   ("MIT-LENNON" "Lisp Machine John Lennon" "740 or thereabouts x3332"
    (MIT-NE43 7) "OZ")

   ("MIT-MORRISON" "Lisp Machine Jim Morrison" "708 Tardis"
    (MIT-NE43 7) "OZ")

   ("MIT-MOON" "Lisp Machine Keith Moon" "7th floor whiteboard"
    (MIT-NE43 7) "OZ")

   ("MIT-PANDA" "Lisp Machine Panda" "JTW's Office x7307"
    (MIT-36 5) "SPEECH")

   ("MIT-YOGI" "Lisp Machine Yogi" "Peech Imspediment Zoo x4672"
    (MIT-36 5) "SPEECH")

   ("MIT-BOO-BOO" "Lisp Machine Boo Boo" "Peech Imspediment Zoo x4672"
    (MIT-36 5) "SPEECH")

   ("MIT-AVATAR" "PA Lisp Machine Avatar" "800B//839 Sorcerer's Apprentice"
    (MIT-NE43 8) "OZ")

   ("MIT-MERLIN" "PA Lisp Machine Merlin" "800B Sorcerer's Apprentice"
    (MIT-NE43 8) "OZ")

   ("MIT-MICKEY-MOUSE" "Lisp Machine Mickey Mouse" "4th floor hallway"
    (MIT-NE43 4) "XX")

   ("MIT-MINNIE-MOUSE" "Lisp Machine Minnie Mouse" "4th floor hallway"
    (MIT-NE43 4) "XX")

   ("MIT-TWEETY-PIE" "Lisp Machine Tweety Pie" "36-640 DSPG Terminal Room x7313"
    (MIT-36 6) "MIT-DSPG")

   ("MIT-GRIZZLY" "Lisp Machine Grizzly" "Peech National Spark x4672"
    (MIT-36 5) "MIT-SPEECH")

   ("MIT-JOE-LOUIS" "Lisp Machine Joe Louis" "4th Floor Hallway (soon)"
    (MIT-NE43 4) "OZ")
      
   ("MIT-ROCKY-GRAZIANO" "Lisp Machine Rocky Graziano" "4th Floor Hallway"
    (MIT-NE43 4) "MC")

   ("G-COOPER" "G-COOPER"         "MIT LCS 4"
	       (MIT-LCS 4) "G-COOPER")
  )

  "This variable has a list of local lisp machine hosts and their associated finger info.
All lisp machines that are on the chaosnet and are to be considered part of this site
should be on this list.
  The format is:
  (name machine-name finger-location (building floor) associated-machine
   site-keyword-overriding-alist)")

