;;; -*-Mode:Lisp;Package:User;Fonts:CPTFONTB;Base:10-*-

(DEFSYSTEM TAPE
  (:NAME "Tape")
  (:PATHNAME-DEFAULT "LAM2: NL.TAPE;")
  (:NOT-IN-DISK-LABEL)
  (:PACKAGE TAPE)
  (:MODULE PACKAGE ("PACKAGE"))
  (:MODULE DEFS ("NL.TAPE.NEW; MTDEFS"))
  (:MODULE STREAM ("NL.TAPE.NEW; MTSTR"))
  (:MODULE MAIN ("FDUMP-DEF" "FDUMP" "COPY" "MTAUX" "PDP10")) 
  (:COMPILE-LOAD DEFS (:READFILE PACKAGE))
  (:COMPILE-LOAD STREAM (:FASLOAD DEFS))
  (:COMPILE-LOAD MAIN (:FASLOAD DEFS STREAM)))

;;; Note that the MTRQB file is used by both the Wesperco and Tapemaster drivers
(DEFSYSTEM WESPERCO
  (:NAME "Wesperco")
  (:PATHNAME-DEFAULT "LAM2: NL.TAPE.NEW;")
  (:NOT-IN-DISK-LABEL)
  (:PACKAGE TAPE)
  (:MODULE RQB ("MTRQB"))
  (:MODULE MAIN ("WEUNIT"))
  (:COMPILE-LOAD RQB)
  (:COMPILE-LOAD MAIN (:FASLOAD RQB)))

(DEFSYSTEM TAPEMASTER
  (:NAME "Tapemaster")
  (:PATHNAME-DEFAULT "LAM2: NL.TAPE;")
  (:NOT-IN-DISK-LABEL)
  (:PACKAGE TAPE)
  (:MODULE DEFS ("TMDEFS"))
  (:MODULE RQB ("NL.TAPE.NEW; MTRQB"))
  (:MODULE MAIN ("TM" "NL.TAPE.NEW; TMUNIT"))
  (:COMPILE-LOAD DEFS)
  (:COMPILE-LOAD RQB)
  (:COMPILE-LOAD MAIN (:FASLOAD DEFS RQB)))

(DEFSYSTEM VMS-TAPE
  (:NAME "VMS-Tape")
  (:NICKNAMES "VMST")
  (:PATHNAME-DEFAULT "SYS: TAPE;")
  (:PACKAGE FILE-SYSTEM)
  (:COMPILE-LOAD ("VMS")))
