;;; -*- Mode: Lisp; Package: TV; Base: 8 -*-
;;;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;This file is loaded after the kernel of the window system and
;before any windows are instantiated.  It contains the combined
;methods and such.

;WINDOW because those methods will get shared then, and
;because it may even be instantiated itself.  Plus all the
;types of windows used in code loaded up til now.
(COMPILE-FLAVOR-METHODS WHO-LINE-SCREEN WHO-LINE-SHEET WHO-LINE-FILE-SHEET WHO-LINE-WINDOW
			WINDOW LISP-LISTENER LISP-INTERACTOR BACKGROUND-LISP-INTERACTOR
			POP-UP-TEXT-WINDOW POP-UP-NOTIFICATION-WINDOW
			TRUNCATING-POP-UP-TEXT-WINDOW
			TRUNCATING-POP-UP-TEXT-WINDOW-WITH-RESET)

(ADD-INITIALIZATION "Sheet" '(INITIALIZE) '(:ONCE))
(ADD-INITIALIZATION "Mouse" '(MOUSE-INITIALIZE) '(:WARM :FIRST))

;Later modules generally have their own COMPILE-FLAVOR-METHODS at the
;end of their own file.  This file exists for bootstrapping reasons.

;Mustn't create any windows (including doing any DEFWINDOW-RESOURCEs) until
;here, because flavors aren't compiled yet and TV:DEFAULT-SCREEN isn't set up yet.

(DEFWINDOW-RESOURCE POP-UP-FINGER-WINDOW ()
  :MAKE-WINDOW (TRUNCATING-POP-UP-TEXT-WINDOW-WITH-RESET)
  :REUSABLE-WHEN :DEACTIVATED)

;Resource of general-purpose momentary menus
(DEFWINDOW-RESOURCE MOMENTARY-MENU ()
	:MAKE-WINDOW (MOMENTARY-MENU)
	:INITIAL-COPIES 0
	:REUSABLE-WHEN :DEEXPOSED)

(DEFWINDOW-RESOURCE MOMENTARY-MULTIPLE-MENU ()
	:MAKE-WINDOW (MOMENTARY-MULTIPLE-MENU)
	:INITIAL-COPIES 0
	:REUSABLE-WHEN :DEEXPOSED)

(DEFRESOURCE BACKGROUND-LISP-INTERACTORS ()
  :CONSTRUCTOR (MAKE-WINDOW 'BACKGROUND-LISP-INTERACTOR
			    ':PROCESS CURRENT-PROCESS	;will be set later
			    ':SUPERIOR DEFAULT-SCREEN	;always on this screen
			    ':HEIGHT (TRUNCATE (SHEET-HEIGHT DEFAULT-SCREEN) 3)))

; It is now time to initialize the window system, which will create and expose
; the initial-lisp-listener and turn on blinkers.
(ADD-INITIALIZATION "WINDOW" '(WINDOW-INITIALIZE) '(:SYSTEM))
