;;; -*- Mode:LISP; Package:ZWEI; Base:8 -*- 

;; LMFILE mail files.
(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :MAIL-FILE-FORMAT-COMPUTER) (STREAM &AUX FLAVOR APPEND-P)
  (IF (NULL STREAM)
      (SETQ FLAVOR 'RMAIL-FILE-BUFFER)
      (LET ((FIRST-LINE (SEND STREAM :LINE-IN)))
	(SEND STREAM :SET-POINTER 0)
	(IF (STRING-EQUAL FIRST-LINE "Babyl Options:")
	    ;; Looks like a babyl file
	    (SETQ FLAVOR 'BABYL-MAIL-FILE-BUFFER)
	    ;; Default is rmail file
	    (SETQ FLAVOR 'RMAIL-FILE-BUFFER)
	    (AND (STRING-EQUAL FIRST-LINE "*APPEND*")
		 (SETQ APPEND-P T)))))
  (VALUES FLAVOR APPEND-P))

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :POSSIBLE-MAIL-FILE-NAMES) ()
  (LOOP FOR FN2 IN *ZMAIL-FILE-FN2S*
	COLLECT (SEND SELF :NEW-PATHNAME :NAME USER-ID :TYPE FN2 :VERSION :NEWEST)))

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :POSSIBLE-MAIL-FILE-BUFFER-FLAVORS) ()
  '(RMAIL-FILE-BUFFER BABYL-MAIL-FILE-BUFFER))

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :NEW-MAIL-PATHNAME) ()
  (SEND SELF :NEW-PATHNAME :NAME (OR FS:NAME USER-ID)
			       :TYPE "MAIL"))

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "_Z" (SEND SELF :TYPE)))

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :INBOX-BUFFER-FLAVOR) ()
  'ITS-INBOX-BUFFER)
