;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 53.15
;;; Reason: random mouse button lossage
;;; universe expansion degerate cases
;;; try to stamp out the dreaded base-tick unbound bug...
;;; Written 10-Apr-84 17:52:58 by Mly,
;;; while running on Lisp Machine One from band 7
;;; with System 98.40, CADR 3.6, ZMail 53.14, MIT-Specific 22.0, microcode 309.



; From file PROFIL.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; PROFIL  "

(DEFSELECT (ZMAIL-PROFILE-COMMAND-LIST ZMAIL-COMMAND-LIST-DEFAULT)
  (:VARIABLE-CHOICE (WINDOW ITEM CHOICE LINE-NO BUTTON)
    (TV:WITH-SELECTION-SUBSTITUTE
      ((SEND *PROFILE-WINDOW* ':GET-PANE 'CHOOSE-WINDOW)
       *ZMAIL-WINDOW*)
      (TV:CHOOSE-VARIABLE-VALUES-CHOICE WINDOW ITEM CHOICE LINE-NO BUTTON)
      (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
      (LET ((*EXPLICIT-OPTION-UPDATE* T))
	(DOLIST (COM (GET (CAR ITEM) 'DOCUMENTATION-ASSOCIATED-COMMANDS))
	  (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION COM))))
    DIS-NONE)
  (:MOUSE-BUTTON (CH WINDOW IGNORE IGNORE &AUX WINDOW-NAME *ZMAIL-COMMAND-BUTTON* NEAR-MODE)
    (COND ((EQ WINDOW *PROFILE-EDITOR-WINDOW*)	;click on zmacs window
	   (SEND *STANDARD-INPUT* ':UNTYI *LAST-COMMAND-CHAR*)
	   (SEND SELF ':PROCESS-SPECIAL-COMMAND 'SELECT-WINDOW *WINDOW*))
	  ((SEND WINDOW ':OPERATION-HANDLED-P ':SET-ACCENT)
	   (SEND WINDOW ':SET-ACCENT T)		;may have gotten turned off
	   (SET-COMMAND-BUTTON CH)
	   (SETQ WINDOW-NAME (SEND *PROFILE-WINDOW* ':PANE-NAME WINDOW)
		 NEAR-MODE `(:WINDOW ,WINDOW))
	   (UNWIND-PROTECT
	       (SELECTQ WINDOW-NAME
		 (FILTERS-BUTTON
		  (PROFILE-FILTERS-BUTTON NEAR-MODE))
		 (UNIVERSES-BUTTON
		  (PROFILE-UNIVERSES-BUTTON NEAR-MODE))
		 (MAIL-FILES-BUTTON
		  (PROFILE-MAIL-FILES-BUTTON NEAR-MODE))
		 (KEYWORDS-BUTTON
		  (PROFILE-KEYWORDS-BUTTON NEAR-MODE))
		 (HARDCOPY-BUTTON
		  (CHOOSE-HARDCOPY-OPTIONS NEAR-MODE ':BOTH))
		 (FILE-OPTIONS-BUTTON
		  (LET* ((ALIST (OR (GET-ZMAIL-BUFFER-ALISTS T) (BARF "No buffers to choose")))
			 (ZMAIL-BUFFER (TV:MENU-CHOOSE ALIST NIL NEAR-MODE)))
		    (COND (ZMAIL-BUFFER
			   (ZMAIL-BUFFER-COERCE ZMAIL-BUFFER)
			   (CHOOSE-MAIL-FILE-OPTIONS ZMAIL-BUFFER)))))
		 (DONE-BUTTON
		  (*THROW 'EXIT-PROFILE-EDITOR T))
		 ((RESET-BUTTON DEFAULTS-BUTTON)
		  (RESET-USER-OPTIONS *ZMAIL-USER-OPTION-ALIST*)
		  (IF (EQ WINDOW-NAME 'RESET-BUTTON)
		      (PROGN (LOAD (ZMAIL-INIT-FILE-PATHNAME)
				   (BUFFER-PACKAGE *INTERVAL*)
				   T)
			     (WITH-OPEN-FILE (SRC-FILE (BUFFER-PATHNAME *INTERVAL*) ':PROBE)
			       (DECIDE-IF-SOURCE-MATCHES-QFASL SRC-FILE)))
		    (SETF (PROFILE-BUFFER-PROFILE-COMPILE-TICK *INTERVAL*) NIL))
		  (SEND *PROFILE-WINDOW* ':SEND-PANE 'CHOOSE-WINDOW ':REFRESH)
		  (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
		  (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
		  (AND (BUFFER-NEEDS-SAVING-P *INTERVAL*)
		       (IF (AND (EQ WINDOW-NAME 'RESET-BUTTON)
				(TYPEOUT-BEEP-YES-OR-NO-P "Revert file buffer too? "))
			   (REVERT-BUFFER *INTERVAL*)
			 (INSERT-CHANGED-VARIABLES ':ASK))))
		 (SAVE-BUTTON
		  (PROFILE-SAVE-BUTTON NEAR-MODE))
		 ;; "Edit" button -- edit the text of the init file.
		 (EDIT-BUTTON
		  ;; Make sure text buffer reflects changes made in the CVV window.
		  (INSERT-CHANGED-VARIABLES NIL)
		  (TV:WITH-SELECTION-SUBSTITUTE (*PROFILE-EDITOR-WINDOW* *ZMAIL-WINDOW*)
		    (*CATCH 'EXIT-TOP-LEVEL
		      (*CATCH 'ABORT-STANDALONE-EDIT
			(LET ((*EDITING-PROFILE* NIL))
			  (SEND *PROFILE-EDITOR-WINDOW* ':EDIT))))
		    (RESECTIONIZE-BUFFER *INTERVAL*)
		    ;; Now read in whatever the user changed in the text
		    (RESET-USER-OPTIONS *ZMAIL-USER-OPTION-ALIST*)
		    (SI:READFILE-INTERNAL (INTERVAL-STREAM *INTERVAL*)
					  (BUFFER-PACKAGE *INTERVAL*) T)
		    ;; Update things based on new values.
		    (SEND *PROFILE-WINDOW* ':SEND-PANE 'CHOOSE-WINDOW ':REFRESH)
		    (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
		    ;; Remember that CVV window and text buffer now match each other.
		    (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
		    (SETF (PROFILE-BUFFER-EDITOR-VARIABLE-TICK *INTERVAL*)
			  *TICK*)))
		 (OTHERWISE
		  (BARF "~S is not a recognized window" WINDOW)))
	     (SEND WINDOW ':SET-ACCENT NIL)))
	  (T NIL))				;clicked at some random place.
     DIS-NONE)
  (SELECT-WINDOW (IGNORE)
    ;; Clicking on the editor window sends this blip.
    ;; Pretend it was a click on the "Edit" button.
    (ZMAIL-PROFILE-COMMAND-LIST ':MOUSE-BUTTON ':LEFT
				(SEND *PROFILE-WINDOW* ':GET-PANE 'EDIT-BUTTON)
				NIL NIL))
  )

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFUN GET-FILTER-FUNCTION-1 (MAP-FUNCTION MAP-ARG NAME NEAR-MODE
			      &AUX FILTER-FUNCTION FILTER-ARG NOT-P)
  (DECLARE (RETURN-LIST MAP-FUNCTION MAP-ARG FILTER-FUNCTION FILTER-ARG))
  (SEND *FILTER-SELECTION-FRAME* ':COMPUTE-GEOMETRY NAME
	(APPEND '(("Any" :VALUE ANY
		   :FONT FONTS:HL12BI
		   :DOCUMENTATION "Messages with any keyword on them."))
		*KEYWORD-ALIST*
		NIL)				;Use a copy of the keyword-alist.
	(APPEND *USER-FILTER-ALIST*
		'(("New filter" :VALUE :NEW-FILTER
		   :FONT FONTS:HL12BI
		   :DOCUMENTATION "Define and use a new filter."))))
  (SEND *FILTER-SELECTION-FRAME* ':TURN-OFF-ACCENTS)
  (UNWIND-PROTECT
    (PROGN
      (TV:EXPOSE-WINDOW-NEAR *FILTER-SELECTION-FRAME* NEAR-MODE)
      (DO ((CHAR)) (NIL)
	(SETQ CHAR (SEND *FILTER-SELECTION-FRAME* ':ANY-TYI))
	(IF (ATOM CHAR)
	    (TV:BEEP)
	  (SELECTQ (FIRST CHAR)
	    (:MOUSE-BUTTON
	     (COND ((SEND (THIRD CHAR) ':OPERATION-HANDLED-P ':SET-ACCENT)
		    (LET* ((WINDOW (THIRD CHAR))
			   (WINDOW-NAME (SEND *FILTER-SELECTION-FRAME* ':PANE-NAME WINDOW)))
		      (UNWIND-PROTECT
			  (SELECTQ WINDOW-NAME
			    (ABORT-BUTTON (ABORT-CURRENT-COMMAND))
			    (NOT-BUTTON)
			    (UNIVERSE-BUTTON
			     (MULTIPLE-VALUE-BIND (NEW-MAP-FUNCTION NEW-MAP-ARG NEW-NAME)
				 (GET-UNIVERSE-FUNCTION `(:WINDOW ,*FILTER-SELECTION-FRAME*))
			       (AND NEW-MAP-FUNCTION
				    (SETQ MAP-FUNCTION NEW-MAP-FUNCTION
					  MAP-ARG NEW-MAP-ARG
					  NAME NEW-NAME)))
			     (SEND *FILTER-SELECTION-FRAME* ':SET-PANES-NAME
				   'UNIVERSE-BUTTON NAME))
			    (OTHERWISE (FERROR NIL "~S is not a known window" (THIRD CHAR))))
			(SEND WINDOW ':SET-ACCENT (AND (EQ WINDOW-NAME 'NOT-BUTTON)
						       (SETQ NOT-P (NOT NOT-P)))))))
		   (T NIL)))			;random window
	      (:MENU
	       (SETQ FILTER-ARG (SEND (FOURTH CHAR) ':EXECUTE-NO-SIDE-EFFECTS
				      (SECOND CHAR)))
	       (SELECTQ (SEND *FILTER-SELECTION-FRAME* ':PANE-NAME (FOURTH CHAR))
		 (KEYWORD-MENU
		  (SETQ FILTER-FUNCTION (IF (EQ FILTER-ARG 'ANY)
					    (IF NOT-P
						'MSG-DOES-NOT-HAVE-KEYWORDS-P
						'MSG-HAS-KEYWORDS-P)
					    (IF NOT-P
						'MSG-DOES-NOT-HAVE-KEYWORD-P
						'MSG-HAS-KEYWORD-P))))
		 (SYSTEM-FILTER-MENU
		  (SETQ FILTER-FUNCTION (COND ((EQ FILTER-ARG ':ALL)
					       (IF NOT-P 'MSG-FALSE-FILTER 'MSG-TRUE-FILTER))
					      ((EQ FILTER-ARG ':SEARCH)
					       (SEND *FILTER-SELECTION-FRAME* ':DEACTIVATE)
					       (MULTIPLE-VALUE-BIND (FUN KEY)
						   (ZMAIL-READ-FIND-SEARCH-STRING
						     "Messages containing string")
						 (SETQ FILTER-ARG KEY)
						 (SELECTQ FUN
						   (SEARCH
						    (IF NOT-P
							'MSG-DOES-NOT-HAVE-SEARCH-STRING
							'MSG-HAS-SEARCH-STRING))
						   (FSM-SEARCH
						    (IF NOT-P
							'MSG-DOES-NOT-HAVE-FSM-SEARCH-STRING
							'MSG-HAS-FSM-SEARCH-STRING))
						   (FSM-EXPR-SEARCH
						    (IF NOT-P
						     'MSG-DOES-NOT-HAVE-FSM-EXPR-SEARCH-STRING
							'MSG-HAS-FSM-EXPR-SEARCH-STRING)))))
					      ((EQ FILTER-ARG ':FROM-TO)
					       (SEND *FILTER-SELECTION-FRAME* ':DEACTIVATE)
					       (LET (X)
						 (MULTIPLE-VALUE (X FILTER-ARG)
						   (CHOOSE-OR-READLINE-ADDRESS "From//To"
									       NOT-P))
						 X))
					      ((EQ FILTER-ARG ':SUBJECT)
					       (SEND *FILTER-SELECTION-FRAME* ':DEACTIVATE)
					       (LET ((X (CHOOSE-MSG-OR-READLINE "Subject")))
						 (OR (STRINGP X)
						     (SETQ X (GET-MSG-SUBJECT-CLEVERLY X)))
						 (SETQ FILTER-ARG X))
					       (IF NOT-P 'MSG-DOES-NOT-HAVE-SUBJECT-STRING
							 'MSG-HAS-SUBJECT-STRING))
					      (T
					       (IF NOT-P 'MSG-DOES-NOT-HAVE-ATTRIBUTE-P
							 'MSG-HAS-ATTRIBUTE-P)))))
		 (USER-FILTER-MENU
		  (COND ((EQ FILTER-ARG ':NEW-FILTER)
			 (SETQ NOT-P NIL)
			 (SEND *FILTER-SELECTION-FRAME* ':DEACTIVATE)
			 (SETQ FILTER-ARG (DEFINE-NEW-FILTER))
			 (OR FILTER-ARG (ABORT-CURRENT-COMMAND))))
		  (SETQ FILTER-FUNCTION (IF NOT-P 'MSG-DOES-NOT-FIT-FILTER-P
					    'MSG-FITS-FILTER-P)))
		 (OTHERWISE (FERROR NIL "~S is not a known window" (THIRD CHAR))))
	       (AND FILTER-FUNCTION (RETURN NIL)))))))
    (SEND *FILTER-SELECTION-FRAME* ':DEACTIVATE))
  (VALUES MAP-FUNCTION MAP-ARG FILTER-FUNCTION FILTER-ARG))

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFSELECT (ZMAIL-FILTER-COMMAND-LIST ZMAIL-COMMAND-LIST-DEFAULT)
  (:MENU (ITEM IGNORE WINDOW &AUX WINDOW-NAME ITEM-NAME)
   (SETQ WINDOW-NAME (SEND SELF ':PANE-NAME WINDOW)
	 ITEM-NAME (IF (ATOM ITEM) ITEM (CAR ITEM))
	 ITEM (SEND WINDOW ':EXECUTE-NO-SIDE-EFFECTS ITEM))
   (SELECTQ WINDOW-NAME
     (KEYWORD-COMMAND-MENU
      (INSERT-FORM-INTO-WINDOW (IF (EQ ITEM 'ANY)
				   'KEYWORDS
				 `(MEMQ ',ITEM KEYWORDS))))
     (USER-FILTER-MENU
      (INSERT-FORM-INTO-WINDOW `(MSG-FITS-FILTER-P MSG ',ITEM)))
     (OTHERWISE
      (INSERT-FILTER ITEM-NAME ITEM)))
   DIS-NONE)
  (SELECT-WINDOW (WINDOW)			;Moused a window, edit there
    (TV:WITH-SELECTION-SUBSTITUTE (WINDOW SELF)
;      (MAKE-WINDOW-CURRENT WINDOW)
      (*CATCH 'ABORT-STANDALONE-EDIT
	(SEND *WINDOW* ':EDIT)))
    DIS-NONE)
  (:MOUSE-BUTTON (CH WINDOW IGNORE IGNORE &AUX WINDOW-NAME)
    (COND ((EQ WINDOW *WINDOW*)
	   (SEND *STANDARD-INPUT* ':UNTYI *LAST-COMMAND-CHAR*)
	   (SEND SELF ':PROCESS-SPECIAL-COMMAND 'SELECT-WINDOW *WINDOW*))
	  ((SEND WINDOW ':OPERATION-HANDLED-P ':SET-ACCENT)
	   (SETQ WINDOW-NAME (SEND SELF ':PANE-NAME WINDOW))
	   (UNWIND-PROTECT
	       (SELECTQ WINDOW-NAME
		 (ABORT-BUTTON
		  (*THROW 'EXIT-FILTER-DEFINITION NIL))
		 (DONE-BUTTON
		  (*THROW 'EXIT-FILTER-DEFINITION (GET-AND-COMPILE-FILTER)))
		 (SAMPLE-BUTTON
		  (LET ((MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER)
			(MAP-ARG *ZMAIL-BUFFER*))
		    (AND (= CH #/MOUSE-3-1)
			 (MULTIPLE-VALUE (MAP-FUNCTION MAP-ARG)
			   (GET-UNIVERSE-FUNCTION `(:WINDOW ,SELF))))
		    (OR MAP-FUNCTION (ABORT-CURRENT-COMMAND))
		    (SURVEY-FROM-FILTER MAP-FUNCTION MAP-ARG
					'MSG-FITS-FILTER-P (GET-AND-COMPILE-FILTER)))
		  (CHECK-FOR-TYPEOUT-WINDOW-TYPEOUT))
		 (NAME-BUTTON
		  (READ-NEW-NAME WINDOW CH *USER-FILTER-ALIST* 'GET-FILTER-DEFINITION))
		 (CLOSE-BUTTON
		  (EDITOR-WINDOW-CLOSE-BUTTON))
		 (OTHERWISE
		  (INSERT-FORM-INTO-WINDOW `(,(SELECTQ WINDOW-NAME
						(NOT-BUTTON 'NOT)
						(AND-BUTTON 'AND)
						(OR-BUTTON 'OR)))
					   -1)))
	     (SEND WINDOW ':SET-ACCENT NIL)))
	  (T NIL))				;random window
    DIS-NONE)
  (SUMMARY-MOUSE (ITEM IGNORE IGNORE &AUX (MSG (CADR ITEM)))	;Mouse in summary window
   (EXTRACT-FILTERS-FROM-MSG MSG)
   DIS-NONE)
  ((:TYPEOUT-EXECUTE SUMMARY-EXECUTE) (&REST IGNORE)
    (BARF)))

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFSELECT (ZMAIL-UNIVERSE-COMMAND-LIST ZMAIL-COMMAND-LIST-DEFAULT)
  (SELECT-WINDOW (WINDOW)			;Moused a window, edit there
    (TV:WITH-SELECTION-SUBSTITUTE (WINDOW SELF)
      (LET ((*COMTAB* *STANDALONE-COMTAB*)
	    (*MODE-LINE-LIST* '("ZMail " "Editing Filter")))
	(*CATCH 'ABORT-STANDALONE-EDIT
	  (SEND *WINDOW* ':EDIT))))
    DIS-NONE)
  (:MENU (ITEM IGNORE WINDOW &AUX WINDOW-NAME)
   (SETQ WINDOW-NAME (SEND SELF ':PANE-NAME WINDOW))
   (SETQ ITEM (SEND WINDOW ':EXECUTE-NO-SIDE-EFFECTS ITEM))
   (IF (EQ WINDOW-NAME 'UNIVERSE-MENU)
       (SETQ ITEM `(,ITEM))
       (AND (TYPEP ITEM 'ZMAIL-BUFFER)
	    (SETQ ITEM (ZMAIL-BUFFER-NAME ITEM))))
   (INSERT-FORM-INTO-WINDOW ITEM)
   DIS-NONE)
  (:MOUSE-BUTTON (CH WINDOW IGNORE IGNORE &AUX WINDOW-NAME)
    (COND ((SEND WINDOW ':OPERATION-HANDLED-P ':SET-ACCENT)
	   (SETQ WINDOW-NAME (SEND SELF ':PANE-NAME WINDOW))
	   (UNWIND-PROTECT
	       (SELECTQ WINDOW-NAME
		 (ABORT-BUTTON
		  (*THROW 'EXIT-UNIVERSE-DEFINITION NIL))
		 (DONE-BUTTON
		  (*THROW 'EXIT-UNIVERSE-DEFINITION (EVAL (READ-FROM-EDITOR-WINDOW))))
		 (NAME-BUTTON
		  (READ-NEW-NAME WINDOW CH *UNIVERSE-LIST* 'GET-UNIVERSE-DEFINITION))
		 (CLOSE-BUTTON
		  (EDITOR-WINDOW-CLOSE-BUTTON))
		 (OTHERWISE
		  (INSERT-FORM-INTO-WINDOW `(,(SELECTQ WINDOW-NAME
						(NOT-BUTTON ')
						(UNION-BUTTON ')
						(INTERSECTION-BUTTON ')))
					   -1)))
	     (SEND WINDOW ':SET-ACCENT NIL)))
	  (T NIL))				;random window
   DIS-NONE)
  )

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFUN COMMAND-WITH-UNIVERSE-OR-FILTER (&AUX BUTTON-FRAME UNIVERSE-BUTTON FILTER-BUTTON)
  (SETQ BUTTON-FRAME (SEND *ZMAIL-WINDOW* ':GET-PANE 'BUTTONS-FRAME)
	UNIVERSE-BUTTON (SEND BUTTON-FRAME ':GET-PANE 'UNIVERSE-BUTTON)
	FILTER-BUTTON (SEND BUTTON-FRAME ':GET-PANE 'FILTER-BUTTON))
  (UNWIND-PROTECT
    (DO ((FILTER-FUNCTION 'MSG-TRUE-FILTER)
	 (FILTER-ARG NIL)
	 ;; Assume by default that there is no universe, no filter.
	 (MAP-FUNCTION 'MAP-OVER-SINGLE-MSG)
	 (MAP-ARG *MSG*)
	 (CHAR))
	(NIL)
      ;; Read the next blip.
      (SETQ CHAR (WITHOUT-IO-BUFFER-OUTPUT-FUNCTION
		   (SEND *STANDARD-INPUT* ':ANY-TYI)))
      (SETQ *LAST-COMMAND-CHAR* CHAR)
      (COND ((AND (CONSP CHAR)
		  (EQ (FIRST CHAR) ':MENU))
	     ;; If the blip is a command, execute it
	     ;; using universe and filter already specified.
	     (LET* ((COMMAND (SEND (FOURTH CHAR) ':EXECUTE-NO-SIDE-EFFECTS (SECOND CHAR)))
		    (ALL-COMMAND (GET COMMAND 'ASSOCIATED-ALL-COMMAND))
		    (MAP-COMMAND (GET COMMAND 'ASSOCIATED-MAP-COMMAND)))
	       ;; Record which button was typed to invoke command we will now do.
	       (SET-COMMAND-BUTTON (THIRD CHAR))
	       (DO () ((NEQ COMMAND 'COM-ZMAIL-OTHER-COMMANDS))
		 (SETQ COMMAND (CHOOSE-OTHER-COMMAND)))
	       ;; How to execute the command depends on whether the command
	       ;; provides a MAP-FUNCTION or an ALL-FUNCTION, and what universe/filter.
	       ;; The MAP-FUNCTION does mapping itself; the ALL-FUNCTION can only
	       ;; operate on an entire buffer.
	       (RETURN (COND ((EQ MAP-FUNCTION 'MAP-OVER-SINGLE-MSG)
			      (FUNCALL COMMAND))
			     ((AND ALL-COMMAND
				   (EQ MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER)
				   (EQ MAP-ARG *ZMAIL-BUFFER*)
				   (EQ FILTER-FUNCTION 'MSG-TRUE-FILTER))
			      (FUNCALL ALL-COMMAND))
			     ((AND ALL-COMMAND
				   (EQ MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER)
				   (TYPEP MAP-ARG 'ZMAIL-BUFFER)
				   (EQ FILTER-FUNCTION 'MSG-TRUE-FILTER))
			      (LET ((*ZMAIL-BUFFER* MAP-ARG)
				    (*MSG* ':NO-SELECT))
				(FUNCALL ALL-COMMAND)))
			     ((AND (NULL MAP-COMMAND)
				   ALL-COMMAND)
			      (LET ((*ZMAIL-BUFFER*
				      (MAKE-ZMAIL-BUFFER-FROM-FILTER
					MAP-FUNCTION MAP-ARG
					FILTER-FUNCTION FILTER-ARG))
				    (*MSG* ':NO-SELECT))				
				(FUNCALL ALL-COMMAND))
			      (ZMAIL-SELECT-MSG *MSG* NIL NIL))
			     (MAP-COMMAND
			      (FUNCALL MAP-COMMAND MAP-FUNCTION MAP-ARG
				       FILTER-FUNCTION FILTER-ARG))
			     (T
			      (BARF "That command does not take a filter argument"))))))
	    ;; If the blip is a :MOUSE-BUTTON blip, it contains data from the
	    ;; universe or filter button.  Look at them to specify the
	    ((AND (CONSP CHAR)
		  (EQ (FIRST CHAR) ':MOUSE-BUTTON))
	     (SET-COMMAND-BUTTON (SECOND CHAR))
	     (LET ((WINDOW (THIRD CHAR)))
	       (COND ((SEND WINDOW ':OPERATION-HANDLED-P ':SET-ACCENT)
		      (UNWIND-PROTECT
			  (*CATCH 'ZWEI-COMMAND-LOOP
			    (COND ((EQ WINDOW UNIVERSE-BUTTON)
				   (MULTIPLE-VALUE (MAP-FUNCTION MAP-ARG)
				     (GET-UNIVERSE-OR-FILTER-FOR-COMMAND
				       'GET-UNIVERSE-FUNCTION-FOR-COMMAND WINDOW BUTTON-FRAME
				       '*LAST-COMMAND-UNIVERSE-FUNCTION*
				       '*LAST-COMMAND-UNIVERSE-ARG*
				       '*LAST-COMMAND-UNIVERSE-NAME*
				       'MAP-OVER-SINGLE-ZMAIL-BUFFER *ZMAIL-BUFFER*
				       (AND *ZMAIL-BUFFER*
					    (ZMAIL-BUFFER-NAME *ZMAIL-BUFFER*)))))
				  ((EQ WINDOW FILTER-BUTTON)
				   (MULTIPLE-VALUE (FILTER-FUNCTION FILTER-ARG)
				     (GET-UNIVERSE-OR-FILTER-FOR-COMMAND
				       'GET-FILTER-FUNCTION-FOR-COMMAND WINDOW BUTTON-FRAME
				       '*LAST-COMMAND-FILTER-FUNCTION*
				       '*LAST-COMMAND-FILTER-ARG*
				       '*LAST-COMMAND-FILTER-NAME*
				       NIL NIL NIL))
				   (COND ((EQ MAP-FUNCTION 'MAP-OVER-SINGLE-MSG)
					  (SETQ MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER
						MAP-ARG *ZMAIL-BUFFER*)
					  (SEND BUTTON-FRAME ':CHANGE-BUTTONS UNIVERSE-BUTTON
						(ZMAIL-BUFFER-NAME *ZMAIL-BUFFER*)))))
				  (T (FERROR NIL "~S is not a known window" WINDOW))))
			(SEND WINDOW ':SET-ACCENT NIL)))
		     (T NIL))))			;random window
	    (T
	     (SEND *STANDARD-INPUT* ':UNTYI CHAR)
	     (RETURN NIL))))
    (SEND BUTTON-FRAME ':CHANGE-BUTTONS UNIVERSE-BUTTON "Just current message"
	  FILTER-BUTTON "All")))

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFUN EXPAND-UNIVERSE (UNIVERSE)
  (COND ((NULL UNIVERSE) NIL)
	((SYMBOLP UNIVERSE)
	 (SELECTQ UNIVERSE
	   (PRIMARY *PRIMARY-ZMAIL-BUFFER*)
	   (CURRENT *ZMAIL-BUFFER*)
	   (ALL (EXPAND-UNIVERSE-INTERSECTION NIL))
	   (OTHERWISE (EXPAND-UNIVERSE (GET UNIVERSE 'UNIVERSE)))))
	((STRINGP UNIVERSE)
	 (GET-ZMAIL-BUFFER-FROM-NAME UNIVERSE T))
	((EQ (CAR UNIVERSE) ')
	 (EXPAND-UNIVERSE-NOT (EXPAND-UNIVERSE (CADR UNIVERSE))))
	((EQ (CAR UNIVERSE) ')
	 (EXPAND-UNIVERSE-UNION (MAPCAR 'EXPAND-UNIVERSE (CDR UNIVERSE))))
	((EQ (CAR UNIVERSE) ')
	 (EXPAND-UNIVERSE-INTERSECTION (MAPCAR 'EXPAND-UNIVERSE (CDR UNIVERSE))))
	((NULL (CDR UNIVERSE))
	 (EXPAND-UNIVERSE (GET (CAR UNIVERSE) 'UNIVERSE)))
	(T
	 (FERROR NIL "~S is not a valid universe" UNIVERSE))))

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFUN CHECK-EXPANSION (EXPANSION)
  (COND ((STRINGP EXPANSION))
	((PATHNAMEP EXPANSION))
	((NULL EXPANSION))
	((MEMQ EXPANSION '(PRIMARY CURRENT)))
	((AND (SYMBOLP EXPANSION) (GET EXPANSION 'UNIVERSE)))
	((ATOM EXPANSION)
	 (FERROR NIL "~S is not a valid universe component" EXPANSION))
	((NULL (CDR EXPANSION))
	 (OR (SYMBOLP (CAR EXPANSION))
	     (FERROR NIL "~S is not a valid universe component" EXPANSION)))
	((EQ (CAR EXPANSION) ')
	 (OR (= (LENGTH EXPANSION) 2)
	     (FERROR NIL "~S wrong number of argument to " EXPANSION)))
	((NOT (MEMQ (CAR EXPANSION) '( )))
	 (FERROR NIL "~S is not a known set operator" (CAR EXPANSION)))
	(T
	 (DOLIST (EXP (CDR EXPANSION))
	   (CHECK-EXPANSION EXP)))))

))

; From file WINDOW.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; WINDOW  "

(DEFMETHOD (ZMAIL-WINDOW :BEFORE :EDIT) (&REST IGNORE)
  (MAKE-WINDOW-CURRENT SELF)
  (SETQ BASE-TICK (TICK))
  (SELECT-WINDOW SELF))

))

; From file MFILES.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFUN MAKE-NEW-TEMP-ZMAIL-BUFFER (NAME &OPTIONAL (FULL-NAME NAME) &AUX ZMAIL-BUFFER)
  (SETQ ZMAIL-BUFFER (ALLOCATE-RESOURCE 'TEMP-ZMAIL-BUFFER))
  (SETF (ZMAIL-BUFFER-NAME ZMAIL-BUFFER) NAME)
  (SEND ZMAIL-BUFFER ':SET-FULL-NAME FULL-NAME)
  (SETF (ZMAIL-BUFFER-SAVED-CURRENT-MSG ZMAIL-BUFFER) NIL)
  (SETF (NODE-TICK ZMAIL-BUFFER) (TICK))
  (SEND ZMAIL-BUFFER ':ACTIVATE)
  ZMAIL-BUFFER)

))
