;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 53.17
;;; Reason: Bugswith invalid headers in draft messages.
;;; Bug in replying to multiple messages.
;;; Point-pdl robustness.
;;; Written 4/21/84 17:14:35 by RMS,
;;; while running on Lisp Machine Seven from band 7
;;; with Don't-dump-a-band! System 98.44, CADR 3.6, Inconsistent (unreleased patches loaded) ZMail 53.16, MIT-Specific 22.0, microcode 309.



; From file MAIL.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MAIL  "


(DEFUN VALIDATE-DRAFT-MSG-SUMMARY-STRING (DRAFT-MSG &AUX TEM HEADERS RECIPIENTS SUBJECT
					  SUMMARY-STRING
					  (*INTERVAL* DRAFT-MSG))
  "Return a string summarizing DRAFT-MSG.
Used in giving the user a menu for the Continue command."
  (IF ( (NODE-TICK DRAFT-MSG) (DRAFT-MSG-SUMMARY-STRING-TICK DRAFT-MSG))
      (DRAFT-MSG-SUMMARY-STRING DRAFT-MSG)
    (CONDITION-CASE ()
	(PROGN
	  (SETQ TEM (PARSE-HEADERS-INTERVAL (DRAFT-MSG-HEADER-INTERVAL DRAFT-MSG))
		HEADERS (LOCF TEM))
	  (AND (SETQ RECIPIENTS (GET HEADERS ':TO))
	       (SETQ SUMMARY-STRING (STRING-APPEND "To: " (SUMMARIZE-RECIPIENTS RECIPIENTS 20.))))
	  (AND (OR (NULL RECIPIENTS)
		   (< (STRING-LENGTH SUMMARY-STRING) 20.))
	       (SETQ RECIPIENTS (GET HEADERS ':CC))
	       (SETQ SUMMARY-STRING (STRING-APPEND (IF SUMMARY-STRING
						       (STRING-APPEND SUMMARY-STRING "; CC: ")
						     "CC: ")
						   (SUMMARIZE-RECIPIENTS RECIPIENTS 20.))))
	  (AND (> (STRING-LENGTH SUMMARY-STRING) 30.)
	       (SETQ SUMMARY-STRING (SUBSTRING SUMMARY-STRING 0 30.)))
	  (AND (COND ((SETQ SUBJECT (GET HEADERS ':SUBJECT))
		      (AND (CONSP SUBJECT)
			   (SETQ SUBJECT (CAR SUBJECT)))
		      (SETQ SUBJECT (STRING-APPEND "Re: " SUBJECT))
		      T)
		     ((NOT (EQUAL (SETQ SUBJECT (FIRST-TEXT-LINE (DRAFT-MSG-REPLY-INTERVAL
								   DRAFT-MSG)))
				  ""))))
	       (SETQ SUMMARY-STRING (IF SUMMARY-STRING
					(STRING-APPEND SUMMARY-STRING "; " SUBJECT)
				      SUBJECT)))
	  (COND (SUMMARY-STRING
		 (AND (DRAFT-MSG-MSGS-BEING-REPLIED-TO DRAFT-MSG)
		      (SETQ SUMMARY-STRING (STRING-APPEND "Reply: " SUMMARY-STRING)))
		 (OR (DRAFT-MSG-SENT-P DRAFT-MSG)
		     (SETQ SUMMARY-STRING (STRING-APPEND (IF (DRAFT-MSG-MSGS-BEING-REPLIED-TO DRAFT-MSG)
							     "Unsent "
							   "Unsent: ")
							 SUMMARY-STRING))))
		(T
		 (SETQ SUMMARY-STRING "Empty")))
	  (SETF (DRAFT-MSG-SUMMARY-STRING DRAFT-MSG) SUMMARY-STRING)
	  (SETF (DRAFT-MSG-SUMMARY-STRING-TICK DRAFT-MSG) (TICK))
	  SUMMARY-STRING)
	(ERROR "??"))))

;;; Send some more

))

; From file MAIL.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MAIL  "


(DEFUN ZMAIL-MAIL (CONFIGURATION STARTING-WINDOW
		   &AUX (OLD-CONFIGURATION *WINDOW-CONFIGURATION*)
		   (*INTERVAL* *DRAFT-MSG*)
		   (*INSIDE-MAIL* T)
		   *END-SENDS-MESSAGE-P*)
  "Enter composition of *DRAFT-MSG*, exiting on End or Abort.
INITIALIZE-FOR-MAIL should have been called already to specify
the draft to be edited and set up some things based on it.
CONFIGURATION is a keyword specifying the window configuration to use;
we switch to it and switch back on exit.
STARTING-WINDOW is the window in that configuratio to select to start with."
  (TV:WITH-SELECTION-SUBSTITUTE (NIL *ZMAIL-WINDOW*)
    (LET ((W
	    (FUNCALL *MSG-WINDOW* ':FUNCALL-INSIDE-YOURSELF
		     'SET-MAIL-WINDOW-CONFIGURATION CONFIGURATION STARTING-WINDOW NIL)))
      (UNWIND-PROTECT
	  (UNWIND-PROTECT
	      (PROGN
		(LOCK-BACKGROUND-PROCESS)
		(IF (TV:SHEET-EXPOSED-P *MSG-WINDOW*)
		    (PREPARE-WINDOW-FOR-REDISPLAY *MSG-WINDOW*))
		(*CATCH 'SEND-IT
		  (LET ((*COMTAB* *REPLY-COMTAB*)
			(*PARAGRAPH-DELIMITER-LIST*
			  (CONS #/- *PARAGRAPH-DELIMITER-LIST*))
			(*MODE-LINE-LIST*
			  `("ZMail " "Mail " "(" *MODE-NAME-LIST*
			    ") " *ZMAIL-INTERVAL-NAME*
			    (*MACRO-LEVEL* "  Macro-level: " *MACRO-LEVEL*)
			    ,(FORMAT NIL "     ~:@C " #\END)
			    (*END-SENDS-MESSAGE-P* "mails" :ELSE "adds more text")
			    ,(FORMAT NIL ", ~:@C aborts" #\ABORT))))
		    (BIND (LOCF (TV:BLINKER-DESELECTED-VISIBILITY
				  (WINDOW-POINT-BLINKER *DRAFT-HEADER-WINDOW*)))
			  ':ON)
		    (BIND (LOCF (TV:BLINKER-DESELECTED-VISIBILITY
				  (WINDOW-POINT-BLINKER *DRAFT-TEXT-WINDOW*)))
			  ':ON)
		    (BIND (LOCF (TV:BLINKER-DESELECTED-VISIBILITY
				  (WINDOW-POINT-BLINKER *MSG-WINDOW*)))
			  ':ON)
		    (SEND *ZMAIL-WINDOW* ':SET-SELECTION-SUBSTITUTE W)
		    (FUNCALL W ':EDIT))))
	    (RESEPARATE-HEADER-AND-TEXT)
	    (SAVE-DRAFT-MSG-WINDOW-STATE *DRAFT-MSG*)
	    (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION 'COM-ZMAIL-CONTINUE))
	;; These are the vital ones; do them even if the previous ones blow out.
	(IF (NEQ OLD-CONFIGURATION *WINDOW-CONFIGURATION*)
	    (FUNCALL *ZMAIL-WINDOW* ':SET-WINDOW-CONFIGURATION OLD-CONFIGURATION))
	(MUST-REDISPLAY *MSG-WINDOW* DIS-TEXT)  ;Was DIS-ALL.  Think this should do it.
	(ZMAIL-SELECT-MSG *MSG* T NIL)
	(PROCESS-UNLOCK *ZMAIL-BACKGROUND-PROCESS-LOCK*))))
  DIS-NONE)

))

; From file MAIL.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MAIL  "

(DEFUN INITIALIZE-FOR-MAIL (&OPTIONAL (DRAFT-MSG (MAKE-DRAFT-MSG)) (INSERT-DEFAULTS T))
  "Set various variables for composing mail.
Sets *DRAFT-HEADER-INTERVAL* and *DRAFT-TEXT-INTERVAL*
to the inferiors of DRAFT-MSG.  Each caller MUST bind those variables.
Also puts those intervals into the corresponding windows."
  (SETQ *DRAFT-HEADER-INTERVAL* (DRAFT-MSG-HEADER-INTERVAL DRAFT-MSG))
  (SEND *DRAFT-HEADER-WINDOW* ':SET-INTERVAL *DRAFT-HEADER-INTERVAL*)
  (MUST-REDISPLAY *DRAFT-HEADER-WINDOW* DIS-ALL)
  (SETQ *DRAFT-TEXT-INTERVAL* (DRAFT-MSG-REPLY-INTERVAL DRAFT-MSG))
  (SEND *DRAFT-TEXT-WINDOW* ':SET-INTERVAL *DRAFT-TEXT-INTERVAL*)
  (MUST-REDISPLAY *DRAFT-TEXT-WINDOW* DIS-ALL)
  (SEND *MSG-WINDOW* ':SET-INTERVAL DRAFT-MSG)

  (AND INSERT-DEFAULTS
       (OR *DEFAULT-CC-LIST* *DEFAULT-FCC-LIST* *REQUIRE-SUBJECTS*)
       (LET* ((LIST `(:CC ,*DEFAULT-CC-LIST*
		      :FCC ,*DEFAULT-FCC-LIST*))
	      (PLIST (LOCF LIST))
	      (STREAM (INTERVAL-STREAM-INTO-BP (INTERVAL-LAST-BP *DRAFT-HEADER-INTERVAL*))))
	 (AND (EQ INSERT-DEFAULTS ':SUBJECT-TOO)
	      *REQUIRE-SUBJECTS*
	      (OR (NEQ *REQUIRE-SUBJECTS* ':BUG)
		  *SENDING-BUG-REPORT*)
	      (SETQ LIST (LIST* ':SUBJECT "" LIST)))
	 (OUTPUT-HEADER STREAM PLIST '(:SUBJECT :CC :FCC))))
  (SETF (DRAFT-MSG-MSGS-BEING-REPLIED-TO DRAFT-MSG)
	(DEL-IF #'(LAMBDA (MSG) (EQ (MSG-PARSED-P MSG) ':KILLED))
		(DRAFT-MSG-MSGS-BEING-REPLIED-TO DRAFT-MSG)))
  (SETF (DRAFT-MSG-MSGS-BEING-FORWARDED DRAFT-MSG)
	(DEL-IF #'(LAMBDA (MSG) (EQ (MSG-PARSED-P MSG) ':KILLED))
		(DRAFT-MSG-MSGS-BEING-FORWARDED DRAFT-MSG)))
  (LET ((MSGS (DRAFT-MSG-MSGS-BEING-REPLIED-TO DRAFT-MSG)))
    (COND ((NULL MSGS)
	   (SETQ *MSGS-BEING-REPLIED-TO-INTERVAL* NIL))
	  ((NULL (CDR MSGS))
	   (SETQ *MSGS-BEING-REPLIED-TO-INTERVAL* (MSG-INTERVAL (CAR MSGS))))
	  (T
	   (SETQ *MSGS-BEING-REPLIED-TO-INTERVAL* (CREATE-INTERVAL))
	   (DO ((BP (INTERVAL-LAST-BP *MSGS-BEING-REPLIED-TO-INTERVAL*))
		(MSGS MSGS (CDR MSGS))
		(*BATCH-UNDO-SAVE* T)
		(FIRST-P T NIL))
	       ((NULL MSGS))
	    (OR FIRST-P (INSERT BP #\CR))
	    (INSERT-INTERVAL BP (MSG-INTERVAL (CAR MSGS)))))))
  (LOOP FOR ZOT IN (DRAFT-MSG-WINDOW-POINTS DRAFT-MSG)
	AS WINDOW = (POP ZOT)
	DO (MOVE-BP (WINDOW-POINT WINDOW) (POP ZOT))
	   (RECENTER-WINDOW WINDOW ':START (POP ZOT)))
  (SETQ *DRAFT-LIST* (CONS DRAFT-MSG (DELQ DRAFT-MSG *DRAFT-LIST*)))
  (SETQ *DRAFT-MSG* DRAFT-MSG))


))

; From file COMNDS.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "


(DEFUN MSG-POINT-PDL-PUSH (MSG ZMAIL-BUFFER &AUX START-BP)
  (COND ((NEQ MSG ':NO-SELECT)
	 (LET ((INT (WINDOW-INTERVAL *MSG-WINDOW*)))
	   (AND (BP-= (INTERVAL-FIRST-BP INT) (MSG-START-BP MSG))
		(BP-= (INTERVAL-LAST-BP INT) (MSG-END-BP MSG))
		(SETQ START-BP (COPY-BP (WINDOW-START-BP *MSG-WINDOW*) ':NORMAL))))
	 (PUSH (LIST MSG ZMAIL-BUFFER START-BP) *MSG-POINT-PDL*)
	 (AND (> (LENGTH *MSG-POINT-PDL*) *POINT-PDL-MAX*)
	      (LET ((ENTRY (DELETE-LAST-ELEMENT *MSG-POINT-PDL*)))
		(AND ENTRY (THIRD ENTRY)
		     (FLUSH-BP (THIRD ENTRY))))))))

))

; From file COMNDS.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "


(DEFINE-ZMAIL-TOP-LEVEL-COMMAND COM-ZMAIL-REPLY-ALL
				"Reply to all these messages at once."
				()
  (LET (*DRAFT-MSG* *DRAFT-TEXT-INTERVAL* *DRAFT-HEADER-INTERVAL*)
    (MULTIPLE-VALUE-BIND (MODE STARTING-WINDOW)
	(APPLY #'NORMAL-REPLY (LISTARRAY (ZMAIL-BUFFER-ARRAY *ZMAIL-BUFFER*)))
      (WHEN MODE
	(MOVE-BP (WINDOW-POINT *DRAFT-HEADER-WINDOW*)
		 (INTERVAL-FIRST-BP (WINDOW-INTERVAL *DRAFT-HEADER-WINDOW*)))
	;; Avoid an extra blank line at end of headers.
	(WHEN (= (BP-CHAR-BEFORE (INTERVAL-LAST-BP *DRAFT-HEADER-INTERVAL*)) #\RETURN)
	  (DELETE-INTERVAL (FORWARD-CHAR (INTERVAL-LAST-BP *DRAFT-HEADER-INTERVAL*) -1)
			   (INTERVAL-LAST-BP *DRAFT-HEADER-INTERVAL*) T))
	(WHEN *DEFAULT-REPLY-TEMPLATE*
	  (FUNCALL *DEFAULT-REPLY-TEMPLATE* *DRAFT-MSG*
		   (DRAFT-MSG-MSGS-BEING-REPLIED-TO *DRAFT-MSG*)))
	(ZMAIL-MAIL MODE STARTING-WINDOW)))))

;;; This might be useful enough to be someplace

))
