;; sys2/lmmac.lisp

;;; Make a variable special and, optionally, initialize it.
;;; This is recorded as a definition by TAGS and ZWEI.
(DEFMACRO DEFVAR (VARIABLE . ARGS)
  "Define a special variable named VARIABLE, and initialize to INITIAL-VALUE if unbound.
Normally, reevaluating the DEFVAR does not change the variable's value.
But in patch files, and if you do C-Shift-E with no region on a DEFVAR,
the variable is reinitialized.  DOCUMENTATION is available if the user
asks for the documentation of the symbol VARIABLE.
If you want your variable to be initially unbound, yet have documentation, 
use :UNBOUND as the initial value."
  (DECLARE (ARGLIST VARIABLE &OPTIONAL INITIAL-VALUE DOCUMENTATION))
  `(PROGN (EVAL-WHEN (COMPILE)
	    (PROCLAIM '(SPECIAL ,VARIABLE)))
	  (EVAL-WHEN (LOAD EVAL)
	    (DEFVAR-1 ,VARIABLE . ,ARGS))))

;; sys/qrand.lisp

;;; These are used by DEFVAR and DEFCONST in LMMAC
(DEFUN DEFVAR-1 (&QUOTE SYMBOL &OPTIONAL (VALUE :UNBOUND) DOCUMENTATION)
  (IF (EQ (CAR-SAFE SYMBOL) 'QUOTE) (SETQ SYMBOL (CADR SYMBOL)))
  (WHEN (RECORD-SOURCE-FILE-NAME SYMBOL 'DEFVAR)
    (SETF (GET SYMBOL 'SPECIAL) (OR FDEFINE-FILE-PATHNAME T))
    (AND (NEQ VALUE :UNBOUND)
	 (OR FS:THIS-IS-A-PATCH-FILE (NOT (BOUNDP SYMBOL)))
	 (SET SYMBOL (EVAL1 VALUE)))
    (SETF (DOCUMENTATION SYMBOL 'VARIABLE) DOCUMENTATION))
  SYMBOL)

