;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 1/03/84 17:57:42 by RMS,
;;; Reason: Zwei Clear-Screen multi-window bug.  Various M-X Copy File bugs.
;;; Really fix buffer history bug.  Section name for ((LAMBDA ...)..), etc.
;;; Common Lisp ERROR and CERROR bugs.  SHOW-MV-SPECS.
;;; C-M-Break interaction with rubout handler fixed
;;;  when debugging using cold load stream.
;;; while running on Lisp Machine Eighteen from band 5
;;; with System 98.22, CADR 3.4, ZMail 53.5, MIT-Specific 22.0, microcode 306, ZM MIT.



; From file COMA.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; COMA  "

(DEFCOM COM-COMPLETE-REDISPLAY "Redisplay all windows.
By default, the text is not scrolled on the screen.
However, a numeric argument specifies the screen line
to scroll point to (negative counting from the bottom)." (KM)
  (DOLIST (W (FRAME-EXPOSED-WINDOWS))
    (PREPARE-WINDOW-FOR-REDISPLAY W))
  (SEND (SEND *WINDOW* ':ALIAS-FOR-SELECTED-WINDOWS) ':REFRESH)
  (WHEN *NUMERIC-ARG-P*
    (COM-RECENTER-WINDOW))
  DIS-NONE)

))

; From file FILES.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; FILES  "


(DEFCOM COM-COPY-BINARY-FILE "Copy one file to another, as a binary file.
With a numeric argument, don't copy creation date." ()
  (COPY-FILE-1 NIL *NUMERIC-ARG-P*)
  DIS-NONE)

(DEFCOM COM-COPY-TEXT-FILE "Copy one file to another, as a text file.
With a numeric argument, don't copy creation date." ()
  (COPY-FILE-1 T *NUMERIC-ARG-P*)
  DIS-NONE)

(DEFCOM COM-COPY-FILE "Copy one file to another.
If Arg=2, force copying in binary mode.
If Arg=3, force copying in characters mode.
If Arg=4, Don't copy creation date or author.
If Arg=5, Don't copy creation date or author, force binary.
If Arg=6, Don't copy creation date or author, force characters." ()
  (COPY-FILE-1 (SELECTQ *NUMERIC-ARG*
		 ((2 5) 'T)
		 ((3 6) 'NIL)
		 (OTHERWISE ':DEFAULT))
	       (< *NUMERIC-ARG* 4))
  DIS-NONE)

(DEFUN COPY-FILE-1 (COPY-MODE COPY-CREATION-DATE?)
  (LET* ((FILE-TYPE-STRING
	   (SELECTQ COPY-MODE
	     ((T) "Copy text file")
	     ((NIL) "Copy binary file")
	     (OTHERWISE "Copy file")))
	 (PATHNAME
	   (READ-DEFAULTED-PATHNAME (FORMAT NIL "~A:" FILE-TYPE-STRING)
				    (PATHNAME-DEFAULTS)))
	 (TO-SPEC (READ-UNDEFAULTED-PATHNAME-STRING
		    (FORMAT NIL "Copy file ~A to:" PATHNAME)
		    PATHNAME)))
    (IF (SEND PATHNAME ':WILD-P)
	(LET ((DIR (CDR (FS:DIRECTORY-LIST PATHNAME)))
	      (TO-PATHNAME (FS:MERGE-PATHNAMES TO-SPEC PATHNAME)))
	  (FORMAT T "~&Files to be copied:~%")
	  (MAPC *DIRECTORY-SINGLE-FILE-LISTER* DIR)
	  (WHEN (LET ((QUERY-IO STANDARD-OUTPUT))
		  (Y-OR-N-P "Copy them all? "))
	    (DOLIST (ELT DIR)
	      (CONDITION-CASE (ERROR)
		  (COPY-FILE (CAR ELT)
			     (SEND PATHNAME ':TRANSLATE-WILD-PATHNAME TO-PATHNAME (CAR ELT))
			     ':COPY-CREATION-DATE COPY-CREATION-DATE?
			     ':COPY-AUTHOR COPY-CREATION-DATE?
			     ':CHARACTERS COPY-MODE
			     ':REPORT-STREAM STANDARD-OUTPUT)
		((FS:FILE-ERROR SYS:REMOTE-NETWORK-ERROR)
		 (FORMAT T "~&Copy failure: ~A" ERROR))))
	    (FORMAT T "~&Done.~%")))
      (CONDITION-CASE (VALUE)
	  (COPY-FILE PATHNAME TO-SPEC
		     ':COPY-CREATION-DATE COPY-CREATION-DATE?
		     ':COPY-AUTHOR COPY-CREATION-DATE?
		     ':CHARACTERS COPY-MODE
		     ':REPORT-STREAM QUERY-IO)
	((FS:FILE-ERROR SYS:REMOTE-NETWORK-ERROR)
	 (BARF VALUE))))))

))

; From file HISTORY.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; HISTORY  "

(DEFUN CLEAR-ALL-HISTORIES ()
  (MAPC 'CLEAR-HISTORY *HISTORIES-TO-CLEAR*))

))

zwei:(let ((window (funcall (window-editor-closure (tv:find-window-of-flavor 'zmacs-frame))
			    'eval '*window*)))
       (zwei:push-remove-on-history (send window ':interval)
				    (send window ':buffer-history)))


; From file OPEN.LISP SRC:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; OPEN  "

(DEFUN PRIMITIVE-COPY-FILE (INPUT-PLIST-OR-PATHNAME MAPPED-PATHNAME OUTPUT-SPEC
			    &KEY (ERROR T) (COPY-CREATION-DATE T) (COPY-AUTHOR T)
			    REPORT-STREAM (CREATE-DIRECTORIES ':QUERY)
			    (CHARACTERS ':DEFAULT) (BYTE-SIZE ':DEFAULT)
			    &AUX INTYPE INPUT-PLIST INPUT-PATHNAME INPUT-TRUENAME)
  (IF (NLISTP INPUT-PLIST-OR-PATHNAME)
      (SETQ INPUT-PATHNAME INPUT-PLIST-OR-PATHNAME
	    INPUT-PLIST NIL)
      (SETQ INPUT-PATHNAME (CAR INPUT-PLIST-OR-PATHNAME)
	    INPUT-PLIST INPUT-PLIST-OR-PATHNAME))
  ;; Decide whether to copy as binary file.
  ;; Either do as told, guess from file byte size or type, or ask the user.
  (LET ((CHARACTERS?
	  (SELECTQ CHARACTERS
	    ((T) CHARACTERS)
	    (:ASK (FQUERY NIL "~&Is ~A a text file? " INPUT-PATHNAME))
	    (OTHERWISE
	     ;; At this point we really need to refer to the file's property list,
	     ;; so get it if we were not given it as the first arg.
	     (IF (NULL INPUT-PLIST)
		 (SETQ INPUT-PLIST (FILE-PROPERTIES INPUT-PATHNAME)
		       INPUT-PATHNAME (CAR INPUT-PLIST)))
	     (LET ((BYTE-SIZE (GET INPUT-PLIST ':BYTE-SIZE)))
	       (COND ((NULL CHARACTERS) NIL)
		     ((MEMQ BYTE-SIZE '(7 8)) T)
		     ((EQ BYTE-SIZE 16.) NIL)
		     ((MEMBER (SETQ INTYPE (SEND INPUT-PATHNAME ':CANONICAL-TYPE))
			      *COPY-FILE-KNOWN-TEXT-TYPES*)
		      T)
		     ((MEMBER INTYPE *COPY-FILE-KNOWN-BINARY-TYPES*) NIL)
		     ((EQ CHARACTERS ':DEFAULT) ':DEFAULT)
		     (T (FQUERY '(:BEEP T) "~&Is ~A a text file? " INPUT-PATHNAME))))))))
    (IF (EQ BYTE-SIZE ':DEFAULT)
	(SETQ BYTE-SIZE (OR (GET INPUT-PLIST ':BYTE-SIZE) ':DEFAULT)))
    (IF (EQ BYTE-SIZE 36.)
	(SETQ BYTE-SIZE 12.))
    (CONDITION-CASE-IF (NOT ERROR) (ERROR)
	(WITH-OPEN-FILE (INSTREAM INPUT-PATHNAME
				  ':DIRECTION ':INPUT
				  ':CHARACTERS CHARACTERS?
				  ':BYTE-SIZE BYTE-SIZE)
	  (SETQ INPUT-TRUENAME (SEND INSTREAM ':TRUENAME))
	  (LET ((DEFAULTED-NEW-NAME
		  (LET ((*ALWAYS-MERGE-TYPE-AND-VERSION* T))
		    (MERGE-PATHNAME-DEFAULTS
		      (SEND MAPPED-PATHNAME ':TRANSLATE-WILD-PATHNAME
			    OUTPUT-SPEC INPUT-TRUENAME)
		      INPUT-TRUENAME))))
	    (CONDITION-BIND ((DIRECTORY-NOT-FOUND
			       #'(LAMBDA (ERROR)
				   (WHEN (IF (EQ CREATE-DIRECTORIES ':QUERY)
					     (PROGN
					       (SEND QUERY-IO ':FRESH-LINE)
					       (SEND ERROR ':REPORT QUERY-IO)
					       (Y-OR-N-P "Create the directory? "))
					   CREATE-DIRECTORIES)
				     (CREATE-DIRECTORY (SEND ERROR ':PATHNAME) ':RECURSIVE T)
				     ':RETRY-FILE-OPERATION))))
	      (WITH-OPEN-FILE (OUTSTREAM DEFAULTED-NEW-NAME
					 ':DIRECTION ':OUTPUT
					 ':CHARACTERS CHARACTERS?
					 ':BYTE-SIZE (IF CHARACTERS? ':DEFAULT BYTE-SIZE))
		(IF COPY-AUTHOR
		    (IF COPY-CREATION-DATE
			(SEND OUTSTREAM ':CHANGE-PROPERTIES NIL
			      ':CREATION-DATE (SEND INSTREAM ':CREATION-DATE)
			      ':AUTHOR (OR (SEND INSTREAM ':GET ':AUTHOR)
					   (GET INPUT-PLIST ':AUTHOR)))
		      (SEND OUTSTREAM ':CHANGE-PROPERTIES NIL
			    ':AUTHOR (OR (SEND INSTREAM ':GET ':AUTHOR)
					 (GET INPUT-PLIST ':AUTHOR))))
		  (IF COPY-CREATION-DATE
		      (SEND OUTSTREAM ':CHANGE-PROPERTIES NIL
			    ':CREATION-DATE (SEND INSTREAM ':CREATION-DATE))))
		(STREAM-COPY-UNTIL-EOF INSTREAM OUTSTREAM)
		(CLOSE OUTSTREAM)
		(WHEN REPORT-STREAM
		  (FORMAT REPORT-STREAM "~&Copied ~A to ~A "
			  INPUT-TRUENAME (SEND OUTSTREAM ':TRUENAME))
		  (IF CHARACTERS?
		      (FORMAT REPORT-STREAM "in character mode.~%")
		    (FORMAT REPORT-STREAM "in byte size ~D.~%"
			    BYTE-SIZE)))
		(LIST MAPPED-PATHNAME INPUT-PATHNAME DEFAULTED-NEW-NAME
		      INPUT-TRUENAME (SEND OUTSTREAM ':TRUENAME)
		      (STREAM-ELEMENT-TYPE INSTREAM))))))
      ((FILE-ERROR SYS:REMOTE-NETWORK-ERROR)
       (LIST MAPPED-PATHNAME INPUT-PATHNAME
	     (LET ((*ALWAYS-MERGE-TYPE-AND-VERSION* T))
	       (MERGE-PATHNAME-DEFAULTS
		 (SEND MAPPED-PATHNAME ':TRANSLATE-WILD-PATHNAME
		       OUTPUT-SPEC (OR INPUT-TRUENAME INPUT-PATHNAME))
		 (OR INPUT-TRUENAME INPUT-PATHNAME)))
	     INPUT-PATHNAME ERROR)))))

))

; From file EHF.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EHF  "

(DEFUN FERROR (SIGNAL-NAME &OPTIONAL FORMAT-STRING &REST ARGS)
  "Report an uncorrectable error, using FORMAT-STRING and ARGS to print the message.
SIGNAL-NAME is a signal name or condition flavor name to be signalled,
or else a condition name to include in the signal, or NIL for none in particular."
  (SIGNAL-CONDITION
    (IF (STRINGP SIGNAL-NAME)
	;; Symbolics calling sequence has no condition; 1st arg is really the format string.
	(LEXPR-FUNCALL 'MAKE-CONDITION 'FERROR ':FORMAT-STRING SIGNAL-NAME
		       ':FORMAT-ARGS (CONS FORMAT-STRING ARGS))
      (LEXPR-FUNCALL 'MAKE-CONDITION SIGNAL-NAME FORMAT-STRING ARGS))
    NIL T))

))

; From file SECTIO.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; SECTIO  "

(DEFUN (:LISP GET-SECTION-NAME) (LINE BP &AUX STR SYM ERROR-P
				 IDX END-IDX (EOF "") NON-FONT-LINE)
  (IF (NOT (AND (PLUSP (LENGTH LINE)) (= (LDB %%CH-CHAR (AREF LINE 0)) #/()))
      (VALUES NIL NIL T)
    (SETQ ERROR-P T)
    (WHEN (AND (%STRING-EQUAL LINE 0 "(DEF" 0 4)
	       (NOT (%STRING-EQUAL LINE 0 "(DEFPROP " 0 9))
	       (SETQ IDX (STRING-SEARCH-SET *WHITESPACE-CHARS* LINE))
	       (SETQ IDX (STRING-SEARCH-NOT-SET *WHITESPACE-CHARS* LINE IDX)))
      (SETQ ERROR-P NIL)
      (SETQ NON-FONT-LINE (STRING-REMOVE-FONTS LINE))
      (CONDITION-CASE ()
	  (SETF (VALUES SYM END-IDX)
		(READ-FROM-STRING NON-FONT-LINE EOF IDX))
	(:NO-ERROR
	 (IF (EQ SYM EOF)
	     (SETQ ERROR-P T)
	   (SETQ STR (SUBSTRING NON-FONT-LINE IDX (MIN (LENGTH LINE) END-IDX)))))
	(SYS:READ-ERROR
	 (SETQ STR (GET-DEFUN-NAME (MOVE-BP BP LINE 0)))))
      (UNLESS ERROR-P
	(MULTIPLE-VALUE (SYM NIL ERROR-P)
	  (SYMBOL-FROM-STRING STR NON-FONT-LINE NIL SYM))))
    (WHEN ERROR-P
      (SETQ SYM (CONCATENATE 'STRING
			     (LET ((BUFFER (NODE-TOP-LEVEL-NODE (LINE-NODE LINE))))
			       (IF (BUFFER-PATHNAME BUFFER)
				   (LET ((NAME
					   (PATHNAME-NAME (BUFFER-PATHNAME BUFFER))))
				     (IF (CONSP NAME)
					 (APPLY 'STRING-APPEND
						(MAPCAR #'(LAMBDA (NAME-ELT)
							    (IF (CONSP NAME-ELT)
								(CAR NAME-ELT) NAME-ELT))
							NAME))
				       (STRING NAME)))
				 (BUFFER-NAME BUFFER)))
			     "-"
			     (LET ((START-INDEX (STRING-SEARCH-NOT-CHAR #/( LINE)))
			       (SUBSTRING LINE START-INDEX
					  (STRING-SEARCH-SET *WHITESPACE-CHARS*
							     LINE START-INDEX)))
			     "-"
			     (PRIN1-TO-STRING (INCF *SECTION-COUNT*)))
	    STR SYM))
    (VALUES SYM STR NIL)))

))

; From file EHF.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EHF  "

(DEFMETHOD (COMMON-LISP-CERROR :CASE :PROCEED-ASKING-USER :CONTINUE)
	   (CONTINUATION IGNORE)
  (FUNCALL CONTINUATION ':CONTINUE))

))

; From file EHC.LISP SRC:<L.WINDOW> OZ:
#8R EH#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "EH")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; EHC  "

(DEFUN SHOW-MV-SPECS (RP IDX)
  (LET ((STORING-OPTION (NTH (LDB %%ADI-RET-STORING-OPTION (AR-1 RP IDX))
			     ADI-STORING-OPTIONS)))
    (COND ((EQ STORING-OPTION 'ADI-ST-BLOCK)
	   (FORMAT T "~% Expecting ~D values"
		   (LDB %%ADI-RET-NUM-VALS-TOTAL (AR-1 RP IDX)))
	   (LET ((NUM-ALREADY
		   (- (LDB %%ADI-RET-NUM-VALS-TOTAL (AR-1 RP IDX))
		      (LDB %%ADI-RET-NUM-VALS-EXPECTING (AR-1 RP IDX)))))
	     (OR (ZEROP NUM-ALREADY)
		 (FORMAT T "; ~D already returned." NUM-ALREADY))))
	  ((EQ STORING-OPTION 'ADI-ST-MAKE-LIST)
	   (FORMAT T "~% Values to be collected for MULTIPLE-VALUE-LIST"))
	  ((EQ STORING-OPTION 'ADI-ST-LIST)
	   (FORMAT T "~% Values being collected for MULTIPLE-VALUE-LIST")
	   (FORMAT T "; ~D values already returned."
		   (LENGTH (AREF RP (1- IDX)))))
	  ((EQ STORING-OPTION 'ADI-ST-INDIRECT)
	   (IF (AREF RP (1- IDX))
	       (FORMAT T "~% Multiple values being passed to frame at ~O"
		       (+ 4 (%POINTER-DIFFERENCE (AREF RP (1- IDX))
						 (ALOC RP 0))))
	     (FORMAT T "~% Multiple values passed to frame, but frame pointer is NIL.
 This means that we were going to pass multiple values
 to a frame that did not want them."))))))

))

; From file BASSTR.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; BASSTR  "

(DEFUN KBD-INTERCEPT-ERROR-BREAK (CHAR &REST IGNORE)
  "Perform the action normally associated with the Meta-Break character.
This function is intended to be called from IO-BUFFER output functions."
  (SETQ INHIBIT-SCHEDULING-FLAG NIL)		;It was T in the IO-BUFFER-OUTPUT-FUNCTION
;  (LET ((EH:CONDITION-PROCEED-TYPES '(:NO-ACTION)))
  (MULTIPLE-VALUE-BIND (BUFFER POSITION)
      (SEND STANDARD-INPUT ':SEND-IF-HANDLES ':SAVE-RUBOUT-HANDLER-BUFFER)
;   (LET ((EH:ERROR-DEPTH (1+ EH:ERROR-DEPTH)))
;     (EH:INVOKE-DEBUGGER '(BREAK)))
    (UNWIND-PROTECT
	(SIGNAL-CONDITION (MAKE-CONDITION 'BREAK) '(:NO-ACTION) T)
      (unless (eq debug-io cold-load-stream)
	(IF BUFFER (SEND STANDARD-INPUT ':RESTORE-RUBOUT-HANDLER-BUFFER BUFFER POSITION)))))
  (VALUES CHAR T))

))
