;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 5/19/84 22:19:53 by RpK,
;;; Reason: QFILE: Add :SUBMIT open to OPEN.  Use in the output direction to submit a file for
;;;  a batch job.  Support the PROPERTIES command, add :PROPERTIES operation for streams.
;;;  Teach the directory property parser about a few new random properties.
;;; CHAOS: Routing table stuff was offset 8 relative from the rest of the world.
;;;  SHOW-ROUTING-PATH tell you what host the packet is going to at the very end.
;;; while running on Lisp Machine Six from band 2
;;; with System 98.48, CADR 3.6, ZMail 53.17, MIT-Specific 22.0, microcode 309, ZM MIT.



; From file QFILE.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QFILE  "


(DEFUN OPEN-CHAOS (HOST PATHNAME &REST OPTIONS
		   &KEY (DIRECTION ':INPUT)
		   	(CHARACTERS T)
			(ERROR T)
			(ACCESS-ERROR (NOT ERROR))
			(ELEMENT-TYPE 'STRING-CHAR ELEMENT-TYPE-P)
			(IF-EXISTS (IF (MEMQ (PATHNAME-VERSION PATHNAME)
					     ;; :UNSPECIFIC here is to prevent lossage
					     ;; writing ITS files with no version numbers.
					     '(:NEWEST :UNSPECIFIC))
				       ':NEW-VERSION ':ERROR))
			(IF-DOES-NOT-EXIST
			  (COND ((MEMQ DIRECTION '(:PROBE :PROBE-LINK :PROBE-DIRECTORY))
				 NIL)
				((AND (EQ DIRECTION ':OUTPUT)
				      (NOT (MEMQ IF-EXISTS '(:OVERWRITE :TRUNCATE :APPEND))))
				 ':CREATE)
				;; Note: if DIRECTION is NIL, this defaults to :ERROR
				;; for compatibility with the past.
				;; A Common-Lisp program would use :PROBE
				;; and get NIL as the default for this.
				(T ':ERROR)))
			TEMPORARY DELETED RAW SUPER-IMAGE (BYTE-SIZE ':DEFAULT)
			PRESERVE-DATES INHIBIT-LINKS SUBMIT ESTIMATED-LENGTH
			&AUX HOST-UNIT DATA-CONN PKT SUCCESS STRING NOT-ABORTED
			PHONY-CHARACTERS SIGN-EXTEND-BYTES IF-EXISTS-P
			(DEFAULT-CONS-AREA BACKGROUND-CONS-AREA))
  (SI:CCASE DIRECTION
    ((:INPUT :OUTPUT :PROBE-DIRECTORY :PROBE-LINK))
    (:IO (FERROR NIL "Bidirectional file streams are not supported."))
    ((NIL :PROBE) (SETQ DIRECTION NIL)))
  (CHECK-TYPE IF-EXISTS (MEMBER :ERROR :NEW-VERSION :RENAME :RENAME-AND-DELETE
				:OVERWRITE :APPEND :TRUNCATE :SUPERSEDE NIL))
  (CHECK-TYPE IF-DOES-NOT-EXIST (MEMBER :ERROR :CREATE NIL))
  ;; IF-EXISTS-P is T if we need to give the IF-EXISTS to the server.
  (SETQ IF-EXISTS-P
	(NOT (MEMQ IF-EXISTS
		   (SELECTQ (PATHNAME-VERSION PATHNAME)
		     (:NEWEST '(:NEW-VERSION))
		     (:UNSPECIFIC '(:NEW-VERSION :SUPERSEDE))))))
  (WHEN ELEMENT-TYPE-P
    (SETF (VALUES CHARACTERS BYTE-SIZE PHONY-CHARACTERS SIGN-EXTEND-BYTES)
	  (DECODE-ELEMENT-TYPE ELEMENT-TYPE BYTE-SIZE)))
  (FILE-OPERATION-RETRY
    (CONDITION-CASE-IF ACCESS-ERROR (ERROR-OBJECT)
        (PROGN
	  (IF (MEMQ DIRECTION '(NIL :PROBE-DIRECTORY :PROBE-LINK))
	      ;;PROBE mode implies no need for data connection
	      (SETQ HOST-UNIT (SEND HOST ':GET-HOST-UNIT))
	    (MULTIPLE-VALUE (DATA-CONN HOST-UNIT)
	      (SEND HOST ':GET-DATA-CONNECTION DIRECTION))))
      (REMOTE-NETWORK-ERROR ERROR-OBJECT)
      (:NO-ERROR
       (UNWIND-PROTECT
	 (PROGN
	   (MULTIPLE-VALUE (PKT SUCCESS STRING)
	     (IF (TYPEP SELF '(OR LMFILE-PARSING-MIXIN LM-PARSING-MIXIN))
		 (SEND HOST-UNIT ':COMMAND NIL
		       (SELECTQ DIRECTION
			 (:INPUT (DATA-INPUT-HANDLE DATA-CONN))
			 (:OUTPUT (DATA-OUTPUT-HANDLE DATA-CONN)))
		       NIL "OPEN-FOR-LISPM " #/RETURN
		       (FILE-PRINT-PATHNAME SELF) #/RETURN
		       (LET ((*PRINT-BASE* 10.) (*NOPOINT T) (*PACKAGE* SI:PKG-USER-PACKAGE)
			     (*READTABLE* SI:COMMON-LISP-READTABLE))
			 (AND (EQ DIRECTION ':OUTPUT) (NULL IF-EXISTS)
			      (SETQ OPTIONS (LIST* ':IF-EXISTS ':ERROR OPTIONS)))
			 (AND (NOT IF-EXISTS-P)
			      (GET-LOCATION-OR-NIL (LOCF OPTIONS) ':IF-EXISTS)
			      (PROGN
				(SETQ OPTIONS (COPYLIST OPTIONS))
				(REMPROP (LOCF OPTIONS) ':IF-EXISTS)))
			 (AND (NULL IF-DOES-NOT-EXIST)
			      (SETQ OPTIONS (LIST* ':IF-DOES-NOT-EXIST ':ERROR OPTIONS)))
			 (PRIN1-TO-STRING OPTIONS)))
	       (SEND HOST-UNIT ':COMMAND NIL
		     (SELECTQ DIRECTION
		       (:INPUT (DATA-INPUT-HANDLE DATA-CONN))
		       (:OUTPUT (DATA-OUTPUT-HANDLE DATA-CONN)))
		     NIL
		     "OPEN " (SELECTQ DIRECTION
			       ((NIL) "PROBE")
			       (:PROBE-DIRECTORY "PROBE-DIRECTORY")
			       (:PROBE-LINK "PROBE INHIBIT-LINKS")
			       (:INPUT "READ")
			       (:OUTPUT "WRITE"))
		     " " (SELECTQ CHARACTERS
			   ((NIL) "BINARY")
			   (:DEFAULT "DEFAULT")
			   (T "CHARACTER"))
		     (IF (AND (EQ DIRECTION ':OUTPUT)
			      IF-EXISTS-P)
			 (STRING-APPEND " IF-EXISTS "
					(IF (EQ IF-EXISTS NIL)
					    ':ERROR
					  IF-EXISTS))
		       "")
		     (IF (OR IF-EXISTS-P
			     (NEQ IF-DOES-NOT-EXIST
				  (SELECTQ DIRECTION
				    ((:INPUT NIL :PROBE-DIRECTORY :PROBE-LINK) ':ERROR)
				    (:OUTPUT ':CREATE))))
			 (STRING-APPEND " IF-DOES-NOT-EXIST "
					(IF (EQ IF-DOES-NOT-EXIST NIL)
					    ':ERROR
					  IF-DOES-NOT-EXIST))
		       "")
		     (IF INHIBIT-LINKS " INHIBIT-LINKS" "")
		     (FORMAT NIL "~:[ BYTE-SIZE ~D~;~*~]~:[~; TEMPORARY~]~:[~; DELETED~]~
				~:[~; RAW~]~:[~; SUPER~]~:[~; PRESERVE-DATES~]~
				~:[~; SUBMIT~]~@[ ESTIMATED-LENGTH ~D~]~%~A~%"
			     (EQ BYTE-SIZE ':DEFAULT) BYTE-SIZE
			     TEMPORARY DELETED RAW SUPER-IMAGE PRESERVE-DATES SUBMIT
			     ESTIMATED-LENGTH
			     (FILE-PRINT-PATHNAME SELF)))))
	   (COND ((NOT SUCCESS)
		  (SETQ NOT-ABORTED T)
		  (SETQ STRING (STRING-APPEND STRING))
		  (AND PKT (CHAOS:RETURN-PKT PKT))
		  (OR (NULL DATA-CONN)
		      (SETF (DATA-STREAM DATA-CONN DIRECTION) NIL))
		  (CONDITION-CASE-IF (NOT IF-DOES-NOT-EXIST)
				     ()
		      (CONDITION-CASE-IF (NOT IF-EXISTS)
					 ()
			  (FILE-PROCESS-ERROR-NEW STRING PATHNAME NIL (NOT ERROR) ':OPEN)
			(FILE-ALREADY-EXISTS NIL))
		    (FILE-NOT-FOUND NIL)))
		 (T
		  (LET ((PROPERTIES (READ-FILE-PROPERTY-LIST-STRING STRING "OPEN" PATHNAME)))
		    (CHAOS:RETURN-PKT PKT)
		    (AND (EQ CHARACTERS ':DEFAULT)
			 (SETQ CHARACTERS (GET (LOCF PROPERTIES) ':CHARACTERS)))
		    (UNLESS (OR (EQ BYTE-SIZE ':DEFAULT)
				(GET (LOCF PROPERTIES) ':BYTE-SIZE))
		      (SETF (GET (LOCF PROPERTIES) ':BYTE-SIZE) BYTE-SIZE))
		    (PROG1
		      (MAKE-INSTANCE (SELECTQ DIRECTION
				       (:INPUT
					(IF CHARACTERS
					    'FILE-INPUT-CHARACTER-STREAM
					  (COND (SIGN-EXTEND-BYTES
						 'FILE-INPUT-SIGNED-BINARY-STREAM)
						(PHONY-CHARACTERS
						 'FILE-INPUT-PHONY-CHARACTER-STREAM)
						(T
						 'FILE-INPUT-BINARY-STREAM))))
				       (:OUTPUT
					(IF CHARACTERS
					   'FILE-OUTPUT-CHARACTER-STREAM
					  (IF PHONY-CHARACTERS
					      'FILE-OUTPUT-PHONY-CHARACTER-STREAM
					    'FILE-OUTPUT-BINARY-STREAM)))
				       (T 'FILE-PROBE-STREAM))
				     ':HOST-UNIT HOST-UNIT
				     ':DATA-CONNECTION DATA-CONN
				     ':PROPERTY-LIST PROPERTIES
				     ':PATHNAME PATHNAME)
		      (SETQ NOT-ABORTED T))))))
	 (UNLESS (OR NOT-ABORTED
		     (NULL DATA-CONN)
		     (NULL (SEND HOST-UNIT ':CONTROL-CONNECTION)))
	   ;; Here if aborted out of it and server may have file open.
	   (CONDITION-CASE ()
	       (PROGN
		(AND (EQ DIRECTION ':OUTPUT)
		     (SEND HOST-UNIT ':COMMAND NIL
			   (DATA-OUTPUT-HANDLE DATA-CONN) NIL "DELETE"))
		(MULTIPLE-VALUE-BIND (NIL CLOSE-SUCCESS)
		    (SEND HOST-UNIT ':COMMAND
			  NIL
			  (SELECTQ DIRECTION
			    (:INPUT (DATA-INPUT-HANDLE DATA-CONN))
			    (:OUTPUT (DATA-OUTPUT-HANDLE DATA-CONN)))
			  NIL "CLOSE")
		  (WHEN CLOSE-SUCCESS
		    (SELECTQ DIRECTION
		      (:INPUT (READ-UNTIL-SYNCHRONOUS-MARK (DATA-CONNECTION DATA-CONN)))
		      (:OUTPUT (CHAOS:SEND-PKT (DATA-CONNECTION DATA-CONN)
					       (CHAOS:GET-PKT) %FILE-SYNCHRONOUS-MARK-OPCODE)))))
		(SEND HOST-UNIT ':FREE-DATA-CONNECTION DATA-CONN DIRECTION))
	     (SYS:HOST-STOPPED-RESPONDING NIL))))))))

))

; From file QFILE.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QFILE  "

(DEFUN MAKE-FILE-PROPERTY-LIST-STREAM-CHAOS (HOST COMMAND STRING-ARG TOKEN-ARGS PATHNAME
					     NOERROR-P
					     &AUX DATA-CONN HOST-UNIT PKT SUCCESS NOT-ABORTED
					     STRING
					     (DEFAULT-CONS-AREA BACKGROUND-CONS-AREA))
  (MULTIPLE-VALUE (DATA-CONN HOST-UNIT)
    (SEND HOST ':GET-DATA-CONNECTION ':INPUT))
  (UNWIND-PROTECT
      (PROGN
	(MULTIPLE-VALUE (PKT SUCCESS STRING)
	  (SEND HOST-UNIT ':COMMAND
		NIL (DATA-INPUT-HANDLE DATA-CONN) NIL
		COMMAND
		TOKEN-ARGS
		#/CR STRING-ARG #/CR))
	(COND ((NOT SUCCESS)
	       (SETQ NOT-ABORTED T)
	       (SETQ STRING (STRING-APPEND STRING))
	       (CHAOS:RETURN-PKT PKT)
	       (SETF (DATA-STREAM DATA-CONN ':INPUT) NIL)
	       (FILE-PROCESS-ERROR-NEW STRING PATHNAME NIL NOERROR-P ':DIRECTORY-STREAM))
	      (T
	       (FILE-CHECK-COMMAND COMMAND STRING)
	       (CHAOS:RETURN-PKT PKT)
	       (PROG1
		 (MAKE-INSTANCE 'FILE-DIRECTORY-STREAM
				':HOST-UNIT HOST-UNIT
				':DATA-CONNECTION DATA-CONN
				':PATHNAME PATHNAME)
		 (SETQ NOT-ABORTED T)))))
      ;; Both success and failure set NOT-ABORTED once they get past critical section.
      (UNLESS (OR NOT-ABORTED
		  (NULL DATA-CONN)
		  (NULL (SEND HOST-UNIT ':CONTROL-CONNECTION)))
	;; Here if aborted out of it and server may have directory stream open.
	(CONDITION-CASE ()
	    (MULTIPLE-VALUE-BIND (NIL CLOSE-SUCCESS)
		(SEND HOST-UNIT ':COMMAND
		      NIL
		      (DATA-INPUT-HANDLE DATA-CONN)
		      NIL "CLOSE")
	      (WHEN CLOSE-SUCCESS
		(READ-UNTIL-SYNCHRONOUS-MARK (DATA-CONNECTION DATA-CONN)))
	     (SEND HOST-UNIT ':FREE-DATA-CONNECTION DATA-CONN ':INPUT))
	  (SYS:HOST-STOPPED-RESPONDING NIL)))))

))

; From file QFILE.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QFILE  "


(DEFUN DIRECTORY-CHAOS (HOST PATHNAME OPTIONS
			&AUX (NOERROR-P NIL) (DELETED-P NIL) (FAST-P NIL) (DIRS-ONLY-P NIL)
			     (NO-EXTRA-INFO NIL) (SORTED-P NIL))
  (FILE-OPERATION-RETRY
    (DO ((L OPTIONS (CDR L)))
	((NULL L))
      (SELECTQ (CAR L)
	(:NOERROR (SETQ NOERROR-P T))
	(:FAST (SETQ FAST-P T))
	(:NO-EXTRA-INFO (SETQ NO-EXTRA-INFO T))
	(:SORTED (SETQ SORTED-P T))
	;; This is for the :ALL-DIRECTORIES message
	(:DIRECTORIES-ONLY (SETQ DIRS-ONLY-P T))
	;; This is for TOPS-20
	(:DELETED (SETQ DELETED-P T))
	(OTHERWISE (FERROR NIL "~S is not a known DIRECTORY option" (CAR L)))))
    (MAKE-FILE-PROPERTY-LIST-STREAM-CHAOS HOST "DIRECTORY" (FILE-PRINT-PATHNAME PATHNAME)
     (FORMAT NIL "~:[~; DELETED~]~:[~; FAST~]~:[~; DIRECTORIES-ONLY~]~
		  ~:[~; NO-EXTRA-INFO~]~:[~; SORTED~]"
	     DELETED-P FAST-P DIRS-ONLY-P NO-EXTRA-INFO SORTED-P)
     PATHNAME NOERROR-P)))

))

; From file QFILE.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QFILE  "

(DEFUN PROPERTIES-CHAOS (TYPE THING ERROR-P
			 &AUX (PATHNAME
				(SELECTQ TYPE
				  (:FILE THING)
				  (:STREAM (SEND THING :TRUENAME))))
			 SETTABLE-PROPERTIES GOT-ERROR PLIST)
  "TYPE is either :FILE or :STREAM."
  (DECLARE (VALUES PLIST SETTABLE-PROPERTIES))
  (WITH-OPEN-STREAM-CASE
    (S (MAKE-FILE-PROPERTY-LIST-STREAM-CHAOS
	 (SEND PATHNAME :HOST)
	 "PROPERTIES"
	 (IF (EQ TYPE :FILE) (FILE-PRINT-PATHNAME THING) "")
	 (IF (EQ TYPE :STREAM) (SEND THING :FILE-HANDLE) "")
	 PATHNAME
	 ()))
    (ERROR (IF (NOT ERROR-P) (SETQ GOT-ERROR S) (SIGNAL-CONDITION S)))
    (:NO-ERROR
     (SETQ SETTABLE-PROPERTIES (PARSE-SETTABLE-PROPERTIES (SEND S :LINE-IN) 0))
     (SETQ PLIST (SEND PATHNAME :READ-DIRECTORY-STREAM-ENTRY S))))
  (OR GOT-ERROR (VALUES PLIST SETTABLE-PROPERTIES)))



))

; From file QFILE.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; QFILE  "


(DEFMETHOD (FILE-STREAM-MIXIN :PROPERTIES) (&OPTIONAL (ERROR-P T))
  (IF (EQ STATUS :CLOSED) (PROPERTIES-CHAOS :FILE (SEND SELF :TRUENAME) ERROR-P)
    (PROPERTIES-CHAOS :STREAM SELF ERROR-P)))
  
;;; Flavors that really have an open connection
;;; STATUS is one of
;;;  :OPEN - a file is currently open on this channel
;;;  :CLOSED - no file is open, but the channel exists
;;;  :EOF - a file is open, but is at its end (no more data available).
;;;  :SYNC-MARKED - a mark that was requested has been received
;;;  :ASYNC-MARKED - an asynchronous (error) mark has been received

))

; From file CHSNCP.LISP PS:<L.IO> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSNCP  "

(DEFCONSTANT FIRST-DATA-WORD-IN-PKT 8. 
  "Offset to first data word in packet (or, number of bytes in header).
Note that the contents of the packet, as an array, includes its header.")

))

; From file CHSAUX.LISP PS:<L.IO> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSAUX  "


;;; Routing table format: for N subnets, N*4 bytes of data, holding N*2 words
;;; For subnet n, pkt[2n] has the method; if this is less than 400 (octal), it's
;;; an interface number; otherwise, it's a host which will forward packets to that
;;; subnet.  pkt[2n+1] has the host's idea of the cost.

(DEFUN FORMAT-ROUTING-TABLE-PKT (PKT &OPTIONAL (STREAM *STANDARD-OUTPUT*)
				 &AUX METHOD COST (I first-data-word-in-pkt))
  (FORMAT STREAM "~%Subnet   Method                Cost~%")
  (DOTIMES (SUBNET (- (TRUNCATE (PKT-NWORDS PKT) 2) first-data-word-in-pkt))
     (SETQ METHOD (AREF PKT I))
     (INCF I)
     (SETQ COST (AREF PKT I))
     (INCF I)
     (AND (NOT (ZEROP METHOD)) (> MAXIMUM-ROUTING-COST COST)
	  (FORMAT STREAM "~3O      ~A~28T~6D~%"
		  SUBNET
		  (IF (< METHOD #o400) (FORMAT NIL "Interface ~D" METHOD)
		    (HOST-DATA METHOD))
		  COST))))

(DEFUN SHOW-ROUTING-TABLE (HOST &OPTIONAL (STREAM *STANDARD-OUTPUT*))
  (CONDITION-CASE (PKT) (SIMPLE HOST "DUMP-ROUTING-TABLE")
    (SYS:NETWORK-ERROR
     (SEND STREAM :FRESH-LINE)
     (SEND STREAM :STRING-OUT "Network error: ")
     (SEND PKT :REPORT STREAM))
    (:NO-ERROR
     (UNWIND-PROTECT (FORMAT-ROUTING-TABLE-PKT PKT STREAM)
       (RETURN-PKT PKT)))))

(DEFUN SHOW-ROUTING-PATH (&KEY (FROM SI:LOCAL-HOST) TO (STREAM *STANDARD-OUTPUT*)
			  (TO-HOST TO)
			  &AUX METHOD-AS-HOST)
  "Show how packets would most likely from a host to TO.
The required TO argument can be a ChaosNet host/address or a subnet number."
  (OR (AND (NUMBERP TO) (< TO #2r11111111))
      (SETQ TO (LDB #o1010 (CHAOS:ADDRESS-PARSE TO))))
  (CONDITION-CASE (PKT) (SIMPLE FROM "DUMP-ROUTING-TABLE")
    (SYS:NETWORK-ERROR
     (FORMAT STREAM "~&Network error: ")
     (SEND PKT :REPORT STREAM))
    (:NO-ERROR
     (UNWIND-PROTECT
	 (LET ((METHOD (AREF PKT (+ first-data-word-in-pkt (* 2 TO))))
	       (COST (AREF PKT (+ first-data-word-in-pkt 1 (* 2 TO)))))
	   (COND ((OR (ZEROP METHOD)
		      ( TO (TRUNCATE (PKT-NBYTES PKT) 4)))
		  (FORMAT STREAM "~&No routing table entry for subnet ~O in ~A."
			  TO (HOST-DATA FROM)))
		 ((< METHOD #o400)
		  (FORMAT STREAM
			  "~&Direct path from ~A to host ~A on subnet ~O at interface ~D."
			  (HOST-DATA FROM) TO-HOST TO METHOD))
		 (T
		  (FORMAT STREAM "~&~A will bounce the packet off ~A at cost ~D."
			  (HOST-DATA FROM) (HOST-DATA METHOD) COST)
		  (SETQ METHOD-AS-HOST METHOD))))
       (RETURN-PKT PKT))
     (IF METHOD-AS-HOST (SHOW-ROUTING-PATH :FROM METHOD-AS-HOST :TO TO
					   :STREAM STREAM :TO-HOST TO-HOST)))))
  
(DEFUN DUMP-ROUTING-TABLE (&AUX (PKT (GET-PKT))
				(N-SUBNETS (MIN (ARRAY-LENGTH ROUTING-TABLE)
						(TRUNCATE MAX-DATA-WORDS-PER-PKT 2))))
  (DO ((SUBNET 0 (1+ SUBNET))
       (PKT-IDX first-data-word-in-pkt))
      ((= SUBNET N-SUBNETS))
    (SETF (AREF PKT PKT-IDX) (AREF ROUTING-TABLE SUBNET))
    (INCF PKT-IDX)				; deposit cost in next word
    (SETF (AREF PKT PKT-IDX) (AREF ROUTING-TABLE-COST SUBNET))
    (INCF PKT-IDX))
  (SETF (AREF PKT (+ first-data-word-in-pkt (* MY-SUBNET 2))) 1) ; Interface 1
  (SETF (AREF PKT (+ first-data-word-in-pkt 1 (* MY-SUBNET 2))) 15.)
  ;; set the number of bytes before actually sending....
  (SETF (PKT-NBYTES PKT) (* 4 N-SUBNETS))
  (ANSWER (LISTEN "DUMP-ROUTING-TABLE") PKT))

))

; From file OPEN.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; OPEN  "

(DEFVAR *KNOWN-DIRECTORY-PROPERTIES*
  '(((PARSE-DIRECTORY-BOOLEAN-PROPERTY PRIN1 :BOOLEAN)
     . (:DELETED :DONT-DELETE :DONT-DUMP :DONT-REAP :DELETE-PROTECT :SUPERSEDE-PROTECT
	:NOT-BACKED-UP :OFFLINE :TEMPORARY :CHARACTERS :DUMPED :DIRECTORY
	;; Supported by LM
	:QFASLP :PDP10 :MAY-BE-REAPED))
    ((SUBSTRING PRINC :STRING) . (:ACCOUNT :AUTHOR :LINK-TO :PHYSICAL-VOLUME :PROTECTION
				  :VOLUME-NAME :PACK-NUMBER :READER :DISK-SPACE-DESCRIPTION
				  :INCREMENTAL-DUMP-TAPE :COMPLETE-DUMP-TAPE))
    ((ZWEI:PARSE-NUMBER PRINT-DECIMAL-PROPERTY :NUMBER)
     . (:BLOCK-SIZE :BYTE-SIZE :GENERATION-RETENTION-COUNT :LENGTH-IN-BLOCKS
	:LENGTH-IN-BYTES :DEFAULT-GENERATION-RETENTION-COUNT))
    ((PARSE-DIRECTORY-DATE-PROPERTY PRINT-DIRECTORY-DATE-PROPERTY :DATE)
     . (:CREATION-DATE :MODIFICATION-DATE))
    ((PARSE-DIRECTORY-DATE-PROPERTY TV:PRINT-UNIVERSAL-TIME-OR-NEVER :DATE-OR-NEVER)
     . ( :REFERENCE-DATE :INCREMENTAL-DUMP-DATE :COMPLETE-DUMP-DATE :DATE-LAST-EXPUNGED
	 :EXPIRATION-DATE))
    ((PARSE-SETTABLE-PROPERTIES PRINT-SETTABLE-PROPERTIES)
     . (:SETTABLE-PROPERTIES :LINK-TRANSPARENCIES :DEFAULT-LINK-TRANSPARENCIES))
    ((PARSE-DIRECTORY-FREE-SPACE PRINT-DIRECTORY-FREE-SPACE) . (:PHYSICAL-VOLUME-FREE-BLOCKS))
    ((TIME:PARSE-INTERVAL-OR-NEVER TIME:PRINT-INTERVAL-OR-NEVER :TIME-INTERVAL-OR-NEVER)
	 . (:AUTO-EXPUNGE-INTERVAL))
    ))

))

; From file OPEN.LISP PS:<L.IO> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; OPEN  "

(TRANSFORM-DIRECTORY-PROPERTIES)

))
