;;; -*- Mode:LISP; Package:USER; Patch-file:T; Base:8; Lowercase:T -*-
;;; Written 6/20/84 19:13:17 by MLY,
;;; Reason: Not compiling variable initializations for value!
;;; (SETF (CHAR-BITS ...) ...)  and high-bit lossage.
;;; Disassembly of FLOOR/CEILING/TRUNCATE/ROUND instructions.
;;; New type NON-COMPLEX-NUMBER
;;;   (TYPEP x '(NON-COMPLEX-NUMBER a b)  (AND (NUMBERP x) (NOT (COMPLEXP x)) ( a x b))
;;; Better (and more correct!) optimization of COERCE
;;; SUBTYPEP lossage on some array types.
;;; Lap bug treating EQUAL frobs for quote vector as EQL
;;; Whitespace preserved on recursive calls READing package prefixes.
;;; while running on Lisp Machine One from band 2
;;; with Don't-dump-a-band! Inconsistent (unreleased patches loaded) System 98.64, CADR 3.7, ZMail 53.17, MIT-Specific 22.1, microcode 309, ZM MIT.

(eval-when (load compile eval)
  (globalize (intern "FIND-POSITION-IN-LIST-EQL" "SI") "SYS"))

; From file QCP1.LISP PS:<L.SYS> OZ:
#8R COMPILER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "COMPILER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QCP1  "

(DEFUN VAR-COMPUTE-INIT (HOME PARALLEL)
  (LET* ((NAME (VAR-NAME HOME))
	 (KIND (VAR-KIND HOME))
	 (TYPE (VAR-TYPE HOME))
	 (INIT-SPECS (VAR-INIT HOME))
	 (INIT-FORM (CAR INIT-SPECS))
	 (SPECIFIED-FLAG-NAME (CADR INIT-SPECS))
	 INIT-TYPE
	 INIT-DATA
	 (P1VALUE 1))
    (COND ((NULL INIT-FORM))
	  ((EQ (CAR-SAFE INIT-FORM) 'QUOTE))
	  ((AND (CONSTANTP INIT-FORM)
		(OR (NOT (SYMBOLP INIT-FORM)) (BOUNDP INIT-FORM))
		(EQ INIT-FORM (EVAL INIT-FORM)))
	   (SETQ INIT-FORM `',INIT-FORM))
	  ((EQUAL INIT-FORM '(UNDEFINED-VALUE))
	   ;;This is simplest thing that works.
	   ;; More hair is not needed for the ways these are usually generated by SETF.
	   (SETQ TLFUNINIT T))
	  (T
	   ;; Init is not NIL, constant or self => must P1 it, and maybe set TLFUNINIT.
	   (LET ((TLEVEL NIL))
	     (SETQ INIT-FORM (P1 INIT-FORM)))
	   (COND ((NOT (ADRREFP INIT-FORM))
		  (SETQ TLFUNINIT T)))))
    ;; Now that we have processed the init form, determine the ADL initialization field.
    ;; First, must we, or would we rather, use code to initialize the variable?
    ;; Note: specified-flags MUST be initted at entry time regardless of anything else.
    (WHEN (AND (NOT (MEMQ 'FEF-ARG-SPECIFIED-FLAG (VAR-MISC HOME)))
	       (OR (EQ KIND 'FEF-ARG-INTERNAL-AUX) TLFUNINIT
		   ;; Don't spoil the fast arg option with nontrivial inits for aux's. 
		   (AND (EQ KIND 'FEF-ARG-AUX)
			FAST-ARGS-POSSIBLE
			(NOT (MEMBER INIT-FORM '(NIL 'NIL))))
		   (IF PARALLEL (NEQ TYPE 'FEF-LOCAL))))
      (SETQ INIT-TYPE 'FEF-INI-COMP-C)
      ;; Note: if we are initting by code, there is no advantage
      ;; in binding at function entry, and doing so would
      ;; make lap stupidly turn off the fast arg option!
      (AND (EQ KIND 'FEF-ARG-AUX)
	   (SETF (VAR-KIND HOME) (SETQ KIND 'FEF-ARG-INTERNAL-AUX)))
      (SETQ TLFUNINIT T))
    ;; If we aren't forced already not to use an init, figure out
    ;; what type of init to use if there's no init-form: either "none" or "nil".
    (UNLESS INIT-TYPE
      (SETQ INIT-TYPE
	    (IF (OR (EQ KIND 'FEF-ARG-OPT)
		    (AND (EQ KIND 'FEF-ARG-AUX)
			 (MEMQ TYPE '(FEF-SPECIAL FEF-REMOTE))))
		'FEF-INI-NIL
		'FEF-INI-NONE)))
    ;; Then, if there is an init form, gobble it.
    (WHEN (AND INIT-FORM (NEQ INIT-TYPE 'FEF-INI-COMP-C))
      (COND ((NOT (MEMQ KIND
			'(FEF-ARG-OPT FEF-ARG-AUX FEF-ARG-INTERNAL-AUX)))
	     (WARN 'BAD-ARGUMENT-LIST :IMPOSSIBLE
		   "The mandatory argument ~S was given a default value."
		   NAME))
	    ;; There's a hack for binding a special var to itself.
	    ((AND (EQ NAME INIT-FORM)
		  (NEQ TYPE 'FEF-LOCAL))
	     (SETQ INIT-TYPE 'FEF-INI-SELF))
	    ((ATOM INIT-FORM)
	     (SETQ INIT-TYPE 'FEF-INI-C-PNTR)
	     (SETQ INIT-DATA (LIST 'LOCATIVE-TO-S-V-CELL INIT-FORM)))
	    ((MEMQ (CAR INIT-FORM) '(LOCAL-REF))
	     (SETQ INIT-TYPE 'FEF-INI-EFF-ADR)	;Initted to value of local var
	     (SETQ INIT-DATA (LIST 'FIXE INIT-FORM)))
	    ((MEMQ (CAR INIT-FORM) '(QUOTE FUNCTION BREAKOFF-FUNCTION SELF-REF))
	     (SETQ INIT-TYPE 'FEF-INI-PNTR)
	     (SETQ INIT-DATA INIT-FORM))
	    (T (BARF INIT-FORM "Init-form calculation confused" 'BARF))))
    (COND ((AND (EQ KIND 'FEF-ARG-OPT)
		(OR TLFUNINIT SPECIFIED-FLAG-NAME))
	   ;; Once an opt arg gets an alternate starting address,
	   ;; all following args must be similar or else FEF-INI-COMP-C.
	   (SETQ TLFUNINIT T)
	   (SETQ INIT-TYPE 'FEF-INI-OPT-SA)
	   (SETQ INIT-DATA (GENSYM)))
	  ;; If something not an optional arg was given a specified-flag,
	  ;; discard that flag now.  There has already been an error message.
	  (T (SETQ SPECIFIED-FLAG-NAME NIL)))
    (SETF (VAR-INIT HOME)
	  (LIST* INIT-TYPE INIT-DATA
		 (AND SPECIFIED-FLAG-NAME
		      (DOLIST (V ALLVARS)
			(AND (EQ (VAR-NAME V) SPECIFIED-FLAG-NAME)
			     (MEMQ 'FEF-ARG-SPECIFIED-FLAG (VAR-MISC V))
			     (RETURN V))))))
    (IF (NULL INIT-FORM)
	NAME
        (LIST NAME INIT-FORM))))

))

; From file CHARACTER.LISP PS:<L.SYS2> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; CHARACTER  "

(defsubst char-bits (char)
  "Returns the special bits of the character CHAR."
  (%logldb %%kbd-control-meta char))

))

; From file DISASS.LISP PS:<L.SYS2> OZ:
#8R COMPILER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "COMPILER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; DISASS  "

(DEFUN DISASSEMBLE-INSTRUCTION (FEF PC &AUX WD OP SUBOP DEST REG DISP ILEN SECOND-WORD)
  "Print on STANDARD-OUTPUT the disassembly of the instruction at PC in FEF.
Returns the length of that instruction."
  (SETQ ILEN (DISASSEMBLE-INSTRUCTION-LENGTH FEF PC))
  (BLOCK NIL
    (SETQ WD (DISASSEMBLE-FETCH FEF PC))
    (FORMAT T "~3O" pc)
    (TYO #/SPACE)
    (SETQ OP (LDB #o1104 WD)
	  SUBOP (LDB #o1503 WD)
	  DEST (LDB #o1602 WD)
	  DISP (LDB #o0011 WD)
	  REG (LDB #o0603 WD))
    (COND ((= ILEN 2)
	   (INCF PC)
	   (SETQ SECOND-WORD (DISASSEMBLE-FETCH FEF PC))
	   ;; If a two-word insn has a source address, it must be an extended address,
	   ;; so set up REG and DISP to be right for that.
	   (UNLESS (= OP #o14)
	     (SETQ REG (LDB #o0603 SECOND-WORD)
		   DISP (DPB (LDB #o1104 SECOND-WORD)
			     #o0604 (LDB #o0006 SECOND-WORD))))))
    (WHEN (< OP #o11) (SETQ OP (LDB #o1105 WD)))
    (COND ((ZEROP WD)
	   (PRINC "0"))
	  ((< OP 11)				;DEST/ADDR 
	   (PRINC (NTH OP '("CALL" "CALL0" "MOVE" "CAR" "CDR" "CADR" "CDDR" "CDAR" "CAAR")))
	   (TYO #/SPACE)
	   (PRINC (NTH DEST '("D-IGNORE" "D-PDL" "D-RETURN" "D-LAST")))
	   (DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD))
	  ((= OP #o11)				;ND1
	   (PRINC (NTH SUBOP '("ND1-UNUSED" "+" "-" "*" "//" "LOGAND" "LOGXOR" "LOGIOR")))
	   (DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD))
	  ((= OP #o12)				;ND2
	   (PRINC (NTH SUBOP '("=" ">" "<" "EQ" "SETE-CDR" "SETE-CDDR" "SETE-1+" "SETE-1-")))
	   (DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD))
	  ((= OP #o13)				;ND3
	   (PRINC (NTH SUBOP '("BIND-OBSOLETE?" "BIND-NIL" "BIND-POP"
			       "SET-NIL" "SET-ZERO" "PUSH-E" "MOVEM" "POP")))
	   (DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD))
	  ((= OP #o14)				;BRANCH
	   (PRINC (NTH SUBOP '("BR" "BR-NIL" "BR-NOT-NIL" "BR-NIL-POP"
			       "BR-NOT-NIL-POP" "BR-ATOM" "BR-NOT-ATOM" "BR-ILL-7")))
	   (TYO #/SPACE)
	   (AND (> DISP #o400) (SETQ DISP (LOGIOR #o-400 DISP)))	;Sign-extend
	   (IF (NEQ DISP -1)
	       ;; One word
	       (FORMAT T "~O" (+ PC DISP 1))
	     ;; Long branch
	     (SETQ DISP SECOND-WORD)
	     (AND ( DISP #o100000) (SETQ DISP (LOGIOR #o-100000 DISP)))
	     (FORMAT T "LONG ~O" (+ PC DISP 1))
	     (RETURN)))
	  ((= OP #o15)				;MISC
	   (PRINC "(MISC) ")			;Moon likes to see this
	   (IF (BIT-TEST 1 SUBOP)
	       (SETQ DISP (+ DISP #o1000)))
	   (COND ((< DISP #o200)
		  (FORMAT T "~A (~D) "
			  (NTH (LDB #o0403 DISP)
			       '(AR-1 ARRAY-LEADER %INSTANCE-REF UNUSED-AREFI-3
				 AS-1 STORE-ARRAY-LEADER %INSTANCE-SET UNUSED-AREFI-7))
			  (+ (LDB #o0004 DISP)
			     (IF (= (LDB #o0402 DISP) 2) 1 0))))
		 ((< DISP #o220)
		  (FORMAT T "UNBIND ~D binding~:P " (- DISP #o177))	;200 does 1 unbind.
		  (AND (ZEROP DEST) (RETURN)))
		 ((< DISP #o240)
		  (FORMAT T "POP-PDL ~D time~:P " (- DISP #o220))	;220 does 0 pops.
		  (AND (ZEROP DEST) (RETURN)))
		 ((= DISP #o460)		;(GET 'INTERNAL-FLOOR-1 'QLVAL)
		  (PRINC (NTH DEST '(FLOOR CEILING TRUNCATE ROUND)))
		  (PRINC " one value to stack")
		  (SETQ DEST NIL))
		 ((= DISP #o510)		;(GET 'INTERNAL-FLOOR-2 'QLVAL)
		  (PRINC (NTH DEST '(FLOOR CEILING TRUNCATE ROUND)))
		  (PRINC " two values to stack")
		  (SETQ DEST NIL))
		 (T
                  (LET ((OP (MICRO-CODE-SYMBOL-NAME-AREA (- DISP #o200))))
                    (COND ((NULL OP) (FORMAT T "#~O " DISP))
                          (T (FORMAT T "~A " OP))))))
	   (WHEN DEST (PRINC (NTH DEST '(D-IGNORE D-PDL D-RETURN D-LAST)))))
	  ((= OP #o16)				;ND4
	   (SELECTQ SUBOP
	     (0 (FORMAT T "STACK-CLOSURE-DISCONNECT  local slot ~D" DISP))
	     (1 (LET ((LOCALNUM
			(LDB #o0012 (NTH DISP
					 (%P-CONTENTS-OFFSET
					   FEF (- (%P-LDB %%FEFH-PC-IN-WORDS FEF) 2))))))
		  (FORMAT T "STACK-CLOSURE-UNSHARE LOCAL|~D" LOCALNUM)
		  (LET ((TEM (DISASSEMBLE-LOCAL-NAME FEF LOCALNUM)))
		    (AND TEM (FORMAT T " ~30,8T;~A" TEM)))))
	     (2 (FORMAT T "MAKE-STACK-CLOSURE  local slot ~D" DISP))
	     (3 (FORMAT T "PUSH-NUMBER ~S" DISP))
	     (4 (FORMAT T "STACK-CLOSURE-DISCONNECT-FIRST  local slot ~D" DISP))
	     (5 (FORMAT T "PUSH-CDR-IF-CAR-EQUAL ")
		(DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD PC))
	     (6 (FORMAT T "PUSH-CDR-STORE-CAR-IF-CONS ")
		(DISASSEMBLE-ADDRESS FEF REG DISP SECOND-WORD PC))
	     (T (FORMAT T "UNDEF-ND4-~D ~D" SUBOP DISP))))
	  ((= OP #o20)
	   (FORMAT T "~A (~D) "
		   (NTH REG
			'(AR-1 ARRAY-LEADER %INSTANCE-REF COMMON-LISP-AR-1
			  SET-AR-1 SET-ARRAY-LEADER SET-%INSTANCE-REF UNUSED-AREFI))
		   (+ (LDB #o0006 DISP)
		      (IF (MEMQ REG '(2 6)) 1 0)))
	   (PRINC (NTH DEST '(D-IGNORE D-PDL D-RETURN D-LAST))))
	  (T					;UNDEF
	   (FORMAT T "UNDEF-~O" op))))
  ILEN)

))


; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop number (rational integer bignum ratio complex real non-complex-number
		 float short-float single-float)
	 subtypes)

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop non-complex-number (rational integer ratio bignum float short-float single-float)
	 subtypes)

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop real (rational integer ratio bignum float short-float single-float)
	 subtypes)

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop atom (array simple-array vector string bit-vector
	       simple-vector simple-bit-vector simple-string
	       standard-char
	       symbol null
	       number rational integer bignum ratio complex real non-complex-number
	       float short-float single-float
	       hash-table readtable package pathname stream random-state
	       structure
	       closure entity instance stack-group select locative
	       compiled-function microcode-function)
	 subtypes)

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop common (array simple-array vector string bit-vector
		 simple-vector simple-bit-vector simple-string
		 standard-char
		 list symbol cons null
		 number rational integer bignum ratio complex real non-complex-number
		 float short-float single-float
		 hash-table readtable package pathname stream random-state
		 structure)
	 subtypes)

))



; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop non-complex-number "a non-complex number" type-name)

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property cli:member type-predicate) (object &rest members)
  (not (null (member-eql object members))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property cli:member type-optimizer) (expression &rest members)
  `(member-eql ,(cadr expression) ',(copy-list members)))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun coerce (object result-type)
  "Coerce OBJECT to an object of type RESULT-TYPE.  Only certain coercions are allowed.
Any sequence can be coerced to any sequence type if the elements are legal.
Strings, symbols and integers can be coerced to type CHARACTER.
Any number can be coerced to type COMPLEX.
Any real number can be coerced to any floating point number type."
  (if (typep object result-type)
      object
    (prog ((canon (type-canonicalize result-type)))
      (case (if (atom canon) canon (car canon))
	(list
	 (cond ((typep object 'vector)
		(return (listarray object)))))
	(short-float
	 (if (realp object)
	     (return (small-float (realpart object)))))
	(single-float
	 (if (realp object)
	     (return (float (realpart object)))))
	(float
	 (if (realp object)
	     (return (if (small-floatp object) object (float (realpart object))))))
	(complex (return (complex object)))
	((character cli:character)
	 (cond ((stringp object)
		(if (= (length object) 1)
		    (return (aref object 0))))
	       ((symbolp object)
		(if (= (length (symbol-name object)) 1)
		    (return (aref (symbol-name object) 0))))
	       ((integerp object)
		(return (int-char object)))))
	((array simple-array vector simple-vector
	  string simple-string bit-vector simple-bit-vector)
	 (when (typep object 'sequence)
	   (return (coerce-to-vector object (if (atom canon) t
					      (array-type-from-element-type (cadr canon))))))))
      ;; If it did not already RETURN, this coercion is not allowed.
      (ferror nil "~S cannot be coerced to a ~S." object result-type))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun coerce-to-vector (object array-type &aux vector length)
  (etypecase object
    (vector
     (if (eq (array-type object) array-type)	;VERY simple optimization
	 vector
       (setq length (length object))
       (setq vector (make-array length :type array-type))
       (dotimes (i length)
	 (setf (cli:aref vector i) (cli:aref object i)))))
    (list
     (setq length (length object))
     (setq vector (make-array length :type array-type))
     (do ((i 0 (1+ i))
	  (l object (cdr l)))
	 ((null l))
       (setf (cli:aref vector i) (car object))))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun coerce-to-list (vector)
  (if (cli:listp vector) vector
    (check-type vector vector "a sequence")
    (let* ((length (length vector))
	   (list (make-list length))
	   (l list))
      (dotimes (x length)
	(setf (car l) (cli:aref vector x))
	(setq l (cdr l)))
      list)))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun coerce-optimizer (form)
  (let (frob type canon)
    (if (not (list-match-p form `(coerce ,frob ',type)))
	form
      (setq canon (type-canonicalize type))
      (case (if (atom canon) canon (car canon))
	(list
	 (once-only (frob)
	   `(if (consp ,frob) ,frob (coerce-to-list ,frob))))
	(short-float `(small-float ,frob))	;not strictly correct, since works on complex
	(single-float `(float ,frob))		;ditto
	(float
	 (once-only (frob)			;ditto
	   `(if (small-floatp ,frob) ,frob (float ,frob))))
	((t) frob)
	((character cli:character) `(coerce-to-character ,frob))
	(complex
	 (if (not (cadr-safe canon))
	     (once-only (frob)
	       `(if (complexp ,frob) ,frob
		  (complex frob)))
	     (once-only (frob)
	       `(if (complexp ,frob)
		    (%complex-cons (coerce (%complex-real-part ,frob) ',(cadr canon))
				   (coerce (%complex-imag-part ,frob) ',(cadr canon)))
		  (complex-cons (coerce ,frob ',(cadr canon)))))))
	((array simple-array vector simple-vector)
	 `(coerce-to-vector
	    ,frob
	    ',(array-type-from-element-type
		(if (atom canon) t (cadr canon)))))
	((bit-vector simple-bit-vector)
	 `(coerce-to-vector
	    ,frob
	    'art-1b))
	((string simple-string)
	 `(coerce-to-vector
	    ,frob
	    'art-string))))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defsubst non-complex-number-p (object)
  (and (numberp object) (not (complexp object))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property non-complex-number type-predicate) (object &optional (low '*) (high '*))
  (and (numberp object)
       (not (complexp object))
       (cond ((memq low '(nil *)) t)
	     ((numberp low) ( low object))
	     ((consp low) (< (car low) object))
	     (t (ferror nil "Invalid lower limit in NON-COMPLEX-NUMBER type specifier.")))
       (cond ((memq high '(nil *)) t)
	     ((numberp high) ( high object))
	     ((consp high) (> (car high) object))
	     (t (ferror nil "Invalid upper limit in NON-COMPLEX-NUMBER type specifier.")))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property non-complex-number type-optimizer) (expression &optional (low '*) (high '*))
  (optimize-numeric-type-test 'non-complex-number-p expression low high))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property vector type-expander) (&optional (element-type t) (size '*))
  `(array ,element-type (,size)))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property vector type-predicate) (object &optional (element-type t) (size '*))
  (and (vectorp object)
       (or (eq element-type '*)
	   (eq element-type (array-element-type object)))
       (or (memq size '(nil *))
	   (= size (array-length object)))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property array type-predicate) (object &optional (element-type t) (dimensions '*))
  (and (arrayp object)
       (or (memq element-type '(t *))
	   (eq element-type (array-element-type object)))
       (or (eq dimensions '*)
	   (if (numberp dimensions)
	       (= dimensions (array-rank object))
	     (and (= (length dimensions) (array-rank object))
		  (dotimes (i (array-rank object) t)
		    (unless
		      (or (eq (nth i dimensions) '*)
			  (= (nth i dimensions) (array-dimension object i))
			  (return nil)))))))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun array-subtypep (type1 type2 &aux known tem)
  (unless (or (null (cdr type2))		;.		(array)
	      (eq (cadr type2) '*)		;.		(array * ...)
	      (and (cdr type1)
		   (neq (cadr type1) '*)	;(array x ...)
		   (progn
		     (multiple-value (tem known)
		       (subtypep (cadr type1)
				 (cadr type2)))
		     (if known tem t))))
    (return-from array-subtypep (values nil t)))
  (if (or (null (cddr type2))			;.		(array x)
	  (eq (caddr type2) '*)			;.		(array x *)
	  (and (cddr type1)
	       (neq (caddr type1) '*)		;(array x y ...)
	       (= (if (numberp (caddr type1)) (caddr type1)
		    (length (caddr type1)))
		  (if (numberp (caddr type2)) (caddr type2)
		    (length (caddr type2))))
	       (do ((1tail (if (consp (caddr type1))
			       (caddr type1)
			     (make-list (caddr type1) ':initial-value '*))
			   (cdr 1tail))
		    (2tail (if (consp (caddr type2))
			       (caddr type2)
			     (make-list (caddr type2) ':initial-value '*))
			   (cdr 2tail)))
		   ((null 1tail) t)
		 (unless (or (eq (car 2tail) '*)
			     (eql (car 1tail) (car 2tail)))
		   (return nil)))))
      (if known (values t t) (values nil nil))
    nil))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defvar subtypep-pairwise-disjoint-sets
  '((integer fixnum bignum)
    (rational ratio integer)
    (number rational float complex)
    (number non-complex-number complex)
    (list cons null)
    (sequence list sequence)
    (t cons symbol array number character entity locative instance closure
       stack-group select compiled-function microcode-function)
    (t list number hash-table readtable package pathname stream random-state)))

))


; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defprop member member-type-name-function type-name-function)
(defprop cli:member member-type-name-function type-name-function)
(defun member-type-name-function (type &aux (len (length (cdr type))))
  (selectq len
    (0 nil)
    (1 (string-append (format nil "EQL ~S" (cadr type))))
    (2 (string-append (format nil "EQL either ~S or ~S" (cadr type) (caddr type))))
    (t (string-append
	 (format:output nil
	   (princ "EQL one of ")
	   (do ((tail (cdr type) (cdr tail)))
	       ((null tail))
	     (unless (cdr tail)
	       (princ "or "))
	     (prin1 (car tail))
	     (when (cdr tail)
	       (if (cddr tail)
		   (princ ", ")
		 (tyo #/space)))))))))

))

; From file TYPES.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun type-canonicalize (typespec &aux tem)
  "Returns a typespec equivalent in meaning to TYPESPEC, but possibly simpler."
  (cond ((null typespec) ())
	((eq typespec t) t)
	((symbolp typespec)
	 (cond ((setq tem (get typespec 'type-alias-for))
		(type-canonicalize tem))
	       ((setq tem (get typespec 'type-expander))
		(type-canonicalize (funcall tem)))
	       (t typespec)))
	((and (consp typespec) (symbolp (car typespec)))
	 (setq typespec (cons (get (car typespec) 'type-alias-for (car typespec))
			      (cdr typespec)))
	 (case (car typespec)
	   (or (let ((z (mapcan #'(lambda (x)
				    (setq x (type-canonicalize x))
				    (cond ((eq (car-safe x) 'or)
					   (cdr x))
					  ((eq x t)
					   (return-from type-canonicalize t))
					  ((eq x nil)
					   ())
					  (t (list x))))
				(cdr typespec))))
		 (if (cdr z) (cons 'or z) (car z))))
	   (and (let ((z (mapcan #'(lambda (x)
				     (setq x (type-canonicalize x))
				     (cond ((eq (car-safe x) 'and)
					    (cdr x))
					   ((eq x nil)
					    (return-from type-canonicalize nil))
					   ((eq x t)
					    ())
					   (t (list x))))
				 (cdr typespec))))
		  (if (cdr z) (cons 'and z) (car z))))
	   (not (let ((z (type-canonicalize (cadr typespec))))
		  (if (eq (car-safe z) 'not)
		      (cadr z)
		      `(not . ,z))))
	   (t
	    ;; (foo * * *) => foo
	    (if (dolist (elt (cdr typespec) t)
		    (unless (eq elt '*)
		      (return nil)))
		(type-canonicalize (car typespec))
	      (if (setq tem (get (car typespec) 'type-expander))
		  (apply tem (cdr typespec))
		typespec)))))
	(t (type-canonicalize
	     (cerror t nil 'wrong-type-argument "~*~S invalid typespec."
		     'typespec typespec)))))

))

;;; this should be the last thing in this patch concerning types
(si:fixup-type-properties)


; From file QFCTNS.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QFCTNS  "

(DEFUN FIND-POSITION-IN-LIST-EQL (ITEM IN-LIST)
  "Return the numeric position of the first element of IN-LIST that is EQL to ITEM.
The first element is position 0.  Returns NIL if no match is found."
  (DO ((L IN-LIST (CDR L))
       (C 0 (1+ C)))
      ((NULL L))
    (AND (EQL ITEM (CAR L)) (RETURN C))))

))

; From file QCLAP.LISP PS:<MLY.T> OZ:
#8R COMPILER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "COMPILER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QCLAP  "

(DEFUN QADD (X) 
  (OR (NULL X)
      (QFIND-CONSTANTS-PAGE X)
      (PROGN
	(INCF QUOTE-COUNT)
	(AND (NOT (CONTAINS-LOAD-TIME-EVAL X))
	     (ASSOC-EQL X QUOTE-LIST)))
      (PUSH (CONS X QUOTE-COUNT) QUOTE-LIST))
    X)


(DEFUN LAP-QUOTE-ADR (ITEM &AUX TM)
  (COND ((SETQ TM (QFIND-CONSTANTS-PAGE ITEM))
	 (+ TM (GET 'CONST-PAGE 'QLVAL)))
	((PROGN
	   (INCF QUOTE-COUNT)
	   (DO ((IDX 0 (1+ IDX))
		(QUOTE-LIST QUOTE-LIST (CDR QUOTE-LIST)))
	       ((NULL QUOTE-LIST) (SETQ TM NIL))
	     (AND (OR (NOT (CONTAINS-LOAD-TIME-EVAL ITEM))
		      (= QUOTE-COUNT (CDAR QUOTE-LIST)))
		  (EQL ITEM (CAAR QUOTE-LIST))
		  (RETURN (SETQ TM IDX)))))
	 (+ TM (QLEVAL 'QUOTE-BASE T)))
	(T (BARF ITEM "not on quote-list" 'BARF)
	   0)))

))

(deff si:pkg-read-lock-p #'ignore)

; From file READ.LISP PS:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; READ  "

(DEFUN (PACKAGE-PREFIX STANDARD-READ-FUNCTION) (STREAM STRING LAST-CH)
  LAST-CH					;ignored
  (PROG (THING PK
	 ;; Help un-screw the user if *PACKAGE* gets set to NIL.
	 (*PACKAGE* (OR *PACKAGE* PKG-USER-PACKAGE))
	 INTERNAL-OK ENTIRE-LIST-PREFIXED)
	;; Gobble the second colon, if any, and set flag if found.
	;; Note that we do not, currently, DO anything with the flag!
	(MULTIPLE-VALUE-BIND (CH NUM REAL-CH)
	    (XR-XRTYI STREAM NIL T)
	  (IF (= CH #/:)
	      (SETQ INTERNAL-OK T)
	    (IF (= CH #/()
		(SETQ ENTIRE-LIST-PREFIXED T))
	    (XR-XRUNTYI STREAM REAL-CH NUM)))
	;; Try to find the package.
	(DO ((STRING1 (OR STRING "")))
	    ;;don't try to find packages if we're not interning -- eg #+slime (dis:foo)
	    ((OR *READ-SUPPRESS*
		 (SETQ PK (FIND-PACKAGE STRING1 PACKAGE))))
	  ;; Package not found.
	  (SIGNAL-PROCEED-CASE ((PKG) 'SYS:READ-PACKAGE-NOT-FOUND
				      "Package ~S does not exist."
				      STRING1)
	    (:NO-ACTION
	     (RETURN))
	    (:NEW-NAME
	     (LET ((*PACKAGE* PKG-USER-PACKAGE))
	       (SETQ STRING1 (STRING (READ-FROM-STRING PKG)))))
	    (:CREATE-PACKAGE
	     (OR (FIND-PACKAGE STRING1 PACKAGE)
		 (MAKE-PACKAGE STRING1)))))
	(UNLESS PK
	  (SETQ PK PKG-USER-PACKAGE))
	(WHEN STRING (RETURN-READ-STRING STRING))
	(LET ((*PACKAGE* PK)
	      (READ-INTERN-FUNCTION
		(IF (OR (AND (PKG-AUTO-EXPORT-P PK)
			     (PACKAGE-USED-BY-LIST PK))
			(PKG-READ-LOCK-P PK))
		    'READ-INTERN-SOFT
		    'INTERN)
		;; This change may occur only in Common Lisp.
		#| (IF (OR ENTIRE-LIST-PREFIXED (EQ PK *PACKAGE*))
		       ;; Here for, e.g., SI: while in SI already.
		       ;; There are things in LOOP which MUST say "SI:" even though
		       ;; loop is loaded into SI on the Lisp machine.
		       ;; Also here for ZWEI:(BP-LINE (POINT));
		       ;; such constructs are not valid Common Lisp
		       ;; so let's keep their meaning the same.
		       READ-INTERN-FUNCTION
		     (IF READ-COLON-ALLOW-INTERNALS
			 'READ-PACKAGE-PREFIX-INTERN
		       'READ-PACKAGE-PREFIX-EXTERNAL-INTERN)) |#))
	  (SETQ THING (INTERNAL-READ STREAM T NIL T))
	  ;; Don't use symbol substitution if a package is explicitly specified!
	  (WHEN (SYMBOLP THING) (SETQ THING (INTERN THING *PACKAGE*))))
	(RETURN THING (TYPE-OF THING) T)))	;T means we already did RETURN-READ-STRING

))
; From file READ.LISP PS:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; READ  "

(DEFUN (SHARP-PACKAGE-PREFIX STANDARD-READ-FUNCTION) (STREAM STRING LAST-CH)
  LAST-CH ;ignored
  (PROG (THING TYPE PK
	 ;; Help un-screw the user if *PACKAGE* gets set to NIL.
	 (*PACKAGE* (OR *PACKAGE* PKG-USER-PACKAGE))
	 (PKG-NAME (SUBSTRING STRING 0 (1- (LENGTH STRING)))))
	;; Try to find the package.
	(UNLESS
	  ;;don't tvy to find packages if we're not interning -- eg #+slime (dis:foo)
	  (OR *READ-SUPPRESS*
	      (SETQ PK (FIND-PACKAGE PKG-NAME NIL)))
	  ;; Package not found.
	  (CERROR ':NO-ACTION NIL 'SYS:READ-ERROR-1
		  "Package ~S does not exist." PKG-NAME))
	(UNLESS PK
	  (SETQ PK PKG-USER-PACKAGE))
	(RETURN-READ-STRING STRING)
	(LET ((*PACKAGE* PK)
	      (READ-INTERN-FUNCTION
		(COND ((EQUAL PKG-NAME "")
		       'READ-UNINTERNED-SYMBOL)
		      ((OR (AND (PKG-AUTO-EXPORT-P PK)
				(PACKAGE-USED-BY-LIST PK))
			   (PKG-READ-LOCK-P PK))
		       'READ-INTERN-SOFT)
		      (T 'INTERN))))
	  (MULTIPLE-VALUE (THING TYPE)
	    (INTERNAL-READ STREAM T NIL T)))
	(RETURN-ARRAY PKG-NAME)
	(RETURN THING TYPE T)))			;T means we already did RETURN-READ-STRING.

))

; From file TYPES.LISP OZ:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

;;;; pretty names for types (used in check-type, etypecase, etc)
(defvar type-pretty-name-hash-table :unbound
  "A hash table containing cached pretty names for types")

(defun type-pretty-name (type)
  "Return a string containing a noun phrase describing objects of type TYPE."
  (unless (variable-boundp type-pretty-name-hash-table)
    (let ((default-cons-area background-cons-area))
      (setq type-pretty-name-hash-table (make-hash-table :test 'equal :size 500.))))
  (or (gethash type type-pretty-name-hash-table)
      (let ((default-cons-area background-cons-area)
	    pretty-name)
	;; Prevent lossage if TYPE was consed in a temporary area.
	(setq type (copytree type)
	      pretty-name
	      	   (cond ((symbolp type)
			  (or (get type 'type-name)
			      (string-append-a-or-an
				(string-subst-char #/space #/-
						   (string-downcase (format nil "~a" type))
						   nil))))
			 ((and (consp type)
			  (funcall (get (car type) 'type-name-function #'ignore) type)))
			 (t (string-append (format nil "an object of type ~S" type)))))
	(setf (gethash type type-pretty-name-hash-table) pretty-name
	      (gethash (type-canonicalize type) type-pretty-name-hash-table) pretty-name))))

(defun (:property or type-name-function) (type)
  (setq type (block or
	       (mapcan #'(lambda (x)
			   (cond ((eq (car-safe x) 'or)
				  (cdr x))
				 ((eq x t)
				  (return-from or t))
				 ((eq x nil)
				  ())
				 (t (list x))))
		       (cdr type))))
  (if (cdr type)
      (string-append
	(format:output nil
	  (do ((tail type (cdr tail)))
	      ((null tail))
	    (unless (cdr tail)
	      (princ "or "))
	    (princ (type-pretty-name (car tail)))
	    (when (cdr tail)
	      (if (cddr tail)
		  (princ ", ")
		(tyo #/space))))))
    (type-pretty-name (car type))))


(defun (:property and type-name-function) (type)
  (setq type (block and
	       (mapcan #'(lambda (x)
			   (cond ((eq (car-safe x) 'and)
				  (cdr x))
				 ((eq x nil)
				  (return-from and nil))
				 ((eq x t)
				  ())
				 (t (list x))))
		       (cdr type))))
  (if (cdr type)
      (string-append
	(format:output nil
	  (princ (type-pretty-name (car type)))
	  " which is also "
	  (do ((tail (cdr type) (cdr tail)))
	      ((null tail))
	    (unless (or (cdr tail) (not (cddr type)))
	      (princ "and "))
	    (princ (type-pretty-name (car tail)))
	    (when (cdr tail)
	      (if (cddr tail)
		  (princ ", ")
		(tyo #/space))))))
    (type-pretty-name (car type))))


))

; From file CLPACK.LISP OZ:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; CLPACK  "

(defun shadowing-import (symbols &optional (pkg *package*))
  "Makes SYMBOLS be present in package PKG.
They then belong to PKG directly, rather than by inheritance.
If any symbol with the same name is already available,
it gets replaced; this is rather drastic."
  (setq pkg (pkg-find-package pkg))
  (dolist (sym (if (and symbols (symbolp symbols)) (list symbols) symbols))
    (unintern (symbol-name sym) pkg)
    (intern-local sym pkg)
    (unless (memq sym (pkg-shadowing-symbols pkg))
      (setf (pkg-shadowing-symbols pkg)
	    (cons-in-area sym (pkg-shadowing-symbols pkg) working-storage-area))))
  t)

))

; From file TYPES.LISP OZ:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; TYPES  "

(defun (:property non-complex-number type-name-function) (type)
  (float-type-name-function "non-complex number" type))

))

#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; PATCH  "

(DEFUN GET-NEW-SYSTEM-VERSION (&OPTIONAL (MAXIMUM-LENGTH 16.) &KEY INCREMENTAL)
  (FORMAT T "~&This is now:")
  (DESCRIBE-SYSTEM-VERSIONS)
  (FRESH-LINE)
  (SETQ SYSTEM-ADDITIONAL-INFO
	(READLINE-TRIM *QUERY-IO* ""
		       `((:PROMPT "Additional comment for herald: ")
			 (:INITIAL-INPUT ,system-additional-info)
			 (:INITIAL-INPUT-POINTER ,(LENGTH SYSTEM-ADDITIONAL-INFO)))))
  (LET ((VERS (SYSTEM-VERSION-INFO T)))
    (IF INCREMENTAL
	(SETQ VERS (STRING-APPEND "Inc " VERS)))
    ;; If short version doesn't fit, allow user to edit it (e.g. abbreviate system names)
    (DO (SHORT)
	(( (LENGTH VERS) MAXIMUM-LENGTH))
      (SETQ SHORT (SUBSTRING VERS 0 MAXIMUM-LENGTH))
      (SETQ VERS
	    (READLINE-TRIM *QUERY-IO* ""
			   `((:PROMPT ,(FORMAT NIL "~S will not fit in disk label.~@
						    Please abbreviate to ~D characters~:P: "
					       VERS MAXIMUM-LENGTH))
			     (:INITIAL-INPUT ,VERS)
			     (:INITIAL-INPUT-POINTER ,MAXIMUM-LENGTH)))))
    VERS))

))

; From file DISK.LISP PS:<L.IO> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; DISK  "

(DEFUN MAXIMUM-PARTITION-COMMENT-LENGTH (PART UNIT &AUX RQB DESC-LOC)
  "Returns the maximum length in characters of the descriptive partition comments on UNIT"
  (UNWIND-PROTECT
      (PROGN (SETQ RQB (GET-DISK-LABEL-RQB))
	     (SETQ DESC-LOC (NTH-VALUE 2 (FIND-DISK-PARTITION PART RQB UNIT)))
	     (COND ((NULL DESC-LOC) NIL)
		   (( (GET-DISK-FIXNUM RQB #o201) 7)
		    (* 4 (- (GET-DISK-FIXNUM RQB #o201) 3)))
		   (T 0)))
    (RETURN-DISK-RQB RQB)))

))

; From file QMISC.LISP PS:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QMISC  "

(DEFUN DISK-SAVE (PARTITION &OPTIONAL NO-QUERY INCREMENTAL)
  "Save the current Lisp world in partition PARTITION.
PARTITION can be either a string naming a partition, or a number which signifies
 a partition whose name starts with LOD.
NO-QUERY says do not ask for confirmation (or any keyboard input at all).
INCREMENTAL means to write out only those parts of the world which have changed
 since the it was loaded from disk. (The effect of loading a world from a band
 saved incrementally is that the incremental saves /"patch/" the original full save."
  (PROG* ((L (DISK-RESTORE-DECODE PARTITION))
	  (PART-NAME (STRING-APPEND (LDB #o0010 (CADR L)) (LDB #o1010 (CADR L))
				    (LDB #o0010 (CAR L)) (LDB #o1010 (CAR L))))
	  PART-BASE PART-SIZE SYSTEM-VERSION MAX-ADDR
	  (INC-PAGES-SAVED 0))
    (OR (MULTIPLE-VALUE (PART-BASE PART-SIZE)
	  (IF NO-QUERY
	      (FIND-DISK-PARTITION-FOR-READ PART-NAME)
	    (FIND-DISK-PARTITION-FOR-WRITE PART-NAME)))
	(RETURN NIL))

    (UNLESS NO-QUERY
      (DOLIST (PATCH-SYSTEM PATCH-SYSTEMS-LIST)
	(WHEN (EQ (PATCH-STATUS PATCH-SYSTEM) :INCONSISTENT)
	  (BEEP)
	  (FORMAT *QUERY-IO* "~&You have loaded patches out of sequence,
 or loaded unreleased patches, in ~A.
As a result, the environment is probably inconsistent with the
current patches and will remain so despite attempts to update it.
Unless you understand these problems well and know how to
be sure whether they are occurring, or how to clean them up,
you should not save this environment."
		  (PATCH-NAME PATCH-SYSTEM))
	  (SEND *QUERY-IO* :CLEAR-INPUT)
	  (UNLESS (YES-OR-NO-P "Dump anyway? ")
	    (RETURN-FROM DISK-SAVE NIL)))))

    ;; This will catch most lossages before the user has waited.
    (UNLESS INCREMENTAL
      (CHECK-PARTITION-SIZE PART-SIZE))

    ;; Prompt now for this rather than waiting through all the initializations.
    (LET ((MAX (OR (MAXIMUM-PARTITION-COMMENT-LENGTH PART-NAME 0) 16.)))
      (SETQ SYSTEM-VERSION
	    (IF NO-QUERY
		(LET ((VERS (SYSTEM-VERSION-INFO T)))
		  (SUBSTRING VERS 0 (MIN (LENGTH VERS) MAX)))
	      (GET-NEW-SYSTEM-VERSION MAX :INCREMENTAL INCREMENTAL))))

    ;; Cause cold boot initializations to happen when rebooted
    ;; and do the BEFORE-COLD initializations now
    (INITIALIZATIONS 'BEFORE-COLD-INITIALIZATION-LIST T)
    (RESET-INITIALIZATIONS 'COLD-INITIALIZATION-LIST)
    (SETQ WHO-LINE-JUST-COLD-BOOTED-P T)
    (LOGOUT)

    ;; Help stop user from getting worried.
    (WHEN INCREMENTAL
      (FORMAT T "~&NOTE: Comparing current memory contents with the original band
will take a few minutes.")
      (PROCESS-SLEEP 120.))

    ;; This can't be a before-cold initialization, because some other
    ;; initializations sometimes type out
    TV:(SHEET-FORCE-ACCESS (INITIAL-LISP-LISTENER)
	 (SEND INITIAL-LISP-LISTENER :REFRESH)
	 (SEND INITIAL-LISP-LISTENER :HOME-CURSOR))

    (CHAOS:RESET)  ;Otherwise, UCODE could lose hacking packets as world dumped.

    ;; Compare all pages with band we booted from,
    ;; record unchanged pages in a bitmap in the band being saved in.
    (WHEN INCREMENTAL
      (SETQ INC-PAGES-SAVED (DISK-SAVE-INCREMENTAL PART-BASE)))

    ;; Check again before updating the partition comment.
    (CHECK-PARTITION-SIZE (+ INC-PAGES-SAVED PART-SIZE))
    (UPDATE-PARTITION-COMMENT PART-NAME SYSTEM-VERSION 0)

    ;; Now shut down the world and check the partition size for real, just
    ;; to make sure that we didn't exceed the size very recently.
    (DOLIST (S TV:ALL-THE-SCREENS) (TV:SHEET-GET-LOCK S))
    (TV:WITH-MOUSE-USURPED
      (WITHOUT-INTERRUPTS
	(SETQ TV:MOUSE-SHEET NIL)
	(DOLIST (S TV:ALL-THE-SCREENS)
	  (SEND S :DEEXPOSE)
	  (TV:SHEET-RELEASE-LOCK S))
	;; The process we are now executing in will look like it was warm-booted when
	;; this saved band is restored.  Suppress the warm-boot message, but disable
	;; and flush the process so it doesn't start running with its state destroyed.
	;; We'd like to :RESET it, but can't because we are still running in it.
	;; If the process is the initial process, it will get a new state and get enabled
	;; during the boot process.
	(PROCESS-DISABLE CURRENT-PROCESS)
	(SET-PROCESS-WAIT CURRENT-PROCESS 'FLUSHED-PROCESS NIL)
	(SETQ CURRENT-PROCESS NIL)
	;; Once more with feeling, and bomb out badly if losing.
	(SETQ MAX-ADDR (FIND-MAX-ADDR))
	(CHECK-PARTITION-SIZE (+ INC-PAGES-SAVED PART-SIZE) T)
	;; Store the size in words rather than pages.  But don't get a bignum!
	(SETF (AREF #'SYSTEM-COMMUNICATION-AREA %SYS-COM-HIGHEST-VIRTUAL-ADDRESS)
	      (LSH MAX-ADDR 8))
	(DO ((I #o600 (1+ I)))			;Clear the disk error log
	    ((= I #o640))
	  (%P-DPB 0 %%Q-LOW-HALF I)
	  (%P-DPB 0 %%Q-HIGH-HALF I))
	(%DISK-SAVE (IF INCREMENTAL
			(- (SYSTEM-COMMUNICATION-AREA %SYS-COM-MEMORY-SIZE))
		      (SYSTEM-COMMUNICATION-AREA %SYS-COM-MEMORY-SIZE))
		    (CAR L) (CADR L))))))

))
