;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 8/14/84 14:26:07 by RpK,
;;; Reason: Handle character objects when copying trees.
;;; CHAOS: PRINT-HOST-TIMES is faster, new function (EXPAND-MAILING-LISTS names host)
;;; while running on Lisp Machine Thirty-one from band 5
;;; with System 98.67, CADR 3.8, ZMail 53.18, MIT-Specific 22.2, microcode 309, gc@36.


; From file QFCTNS.LISP OZ:<L.SYS> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS; QFCTNS  "

(DEFUN COPY-OBJECT-TREE (OBJECT &OPTIONAL TEMPORARY-AREAS-ONLY DEPTH)
  "Copy lists, arrays and everything but symbols, to all levels.
If TEMPORARY-AREAS-ONLY is non-NIL, objects in non-temporary areas are left alone."
  (IF (OR (MEMQ (%DATA-TYPE OBJECT) '(#.DTP-FIX #.DTP-U-ENTRY
				      #.DTP-SMALL-FLONUM #.DTP-LOCATIVE #.DTP-CHARACTER
				      #.DTP-SYMBOL))
	  (AND TEMPORARY-AREAS-ONLY
	       (NOT (AREA-TEMPORARY-P (%AREA-NUMBER OBJECT)))))
      OBJECT
    (LET* ((NEW (COPY-OBJECT OBJECT))
	   (LEADER (%FIND-STRUCTURE-LEADER NEW)))
      (DO ((I 0 (1+ I))) ((= I (%STRUCTURE-BOXED-SIZE NEW)))
	(COND ((MEMQ (%P-LDB-OFFSET %%Q-DATA-TYPE LEADER I)
		     '(#.DTP-NULL #.DTP-HEADER #.DTP-ARRAY-HEADER #.DTP-INSTANCE-HEADER
		       #.DTP-FIX #.DTP-SELF-REF-POINTER
		       #.DTP-U-ENTRY #.DTP-SMALL-FLONUM #.DTP-LOCATIVE
		       #.DTP-SYMBOL #.DTP-ONE-Q-FORWARD #.DTP-CHARACTER
		       #.DTP-EXTERNAL-VALUE-CELL-POINTER
		       #.DTP-HEADER-FORWARD #.DTP-BODY-FORWARD
		       )))
	      (T
	       (SETF (%P-CONTENTS-OFFSET LEADER I)
		     (IF (EQ DEPTH 0)
			 NIL
		       (COPY-OBJECT-TREE (%P-CONTENTS-OFFSET LEADER I) TEMPORARY-AREAS-ONLY
					 (IF DEPTH (1- DEPTH))))))))
      NEW)))

))

; From file CHSAUX.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSAUX  "

(DEFUN PRINT-HOST-TIMES (&OPTIONAL (HOSTS TIME-SERVER-HOSTS) (STREAM *STANDARD-OUTPUT*)
			 &AUX BEGIN-TIME)
  (SETQ BEGIN-TIME (TIME:TIME))
  (LET ((TOTAL-TIME 0)
	(RESPONSES 0))
    (POLL-HOSTS STREAM HOSTS "TIME" #'(LAMBDA () (FORMAT T "~&Host~26TTime"))
		#'(LAMBDA (ADDRESS PKT)
		    (LET ((TIME (DECODE-CANONICAL-TIME-PACKET PKT)))
		      (FORMAT STREAM "~&~:[~;! ~]~A~22,2T~\TIME\~%"
			      (> (ABS (- (TIME:GET-UNIVERSAL-TIME) TIME)) 180.)
			      (SI:GET-HOST-FROM-ADDRESS ADDRESS :CHAOS)
			      TIME)
		      (INCF TOTAL-TIME TIME)
		      (INCF RESPONSES))))
    (FORMAT STREAM "~2%Average time: ~\TIME\; total time elapsed: ~D seconds.~%"
	    (ROUND TOTAL-TIME RESPONSES) (TRUNCATE (- (TIME:TIME) BEGIN-TIME) 60.))))

))

; From file CHSAUX.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSAUX  "

(DEFUN EXPAND-MAILING-LISTS (NAMES HOST &AUX RESULT STREAM BAD-ADDRESSES CHAR)
  "Return a list of the recipients of the addresses NAMES at HOST.
Returns either a list of addresses, and a list of bad addresses, or an error instance.
The NAMES should not contain atsigns."
  (DECLARE (VALUES ADDRESSES BAD-ADDRESSES))
  (UNWIND-PROTECT
      (PROGN
	(SETQ STREAM (OPEN-STREAM HOST "EXPAND-MAILING-LIST" :ERROR NIL))
	(IF (ERRORP STREAM) STREAM
	  (DOLIST (NAME NAMES (VALUES RESULT BAD-ADDRESSES))
	    (SEND STREAM :LINE-OUT NAME)
	    (SEND STREAM :FORCE-OUTPUT)
	    (COND ((CHAR= (SETQ CHAR (SEND STREAM :TYIPEEK)) #/-)
		   (SEND STREAM :LINE-IN)
		   (PUSH NAME BAD-ADDRESSES))
		  ((CHAR= CHAR #/+)
		   (SEND STREAM :LINE-IN)
		   (DO ((LINE (SEND STREAM :LINE-IN T) (SEND STREAM :LINE-IN T)))
		       ((ZEROP (STRING-LENGTH LINE)))
		     (PUSHNEW LINE RESULT :TEST #'STRING-EQUAL)))
		  (T
		   (FERROR () "Unknown character ~C in response" CHAR))))))
    (AND STREAM (NOT (ERRORP STREAM)) (SEND STREAM :CLOSE :ABORT))))

))

; From file CHSAUX.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSAUX  "

(DEFUN (:INTERNET HOST-ADDRESS-PARSER) (IGNORE LINE START END)
  (SUBSTRING LINE START END))
))
