;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 51.7
;;; Reason: new function ZWEI:LOAD-ZMAIL-INIT-FILE allows preloading of ZMAIL profile
;;; Written 10/14/83 02:53:04 by Mly,
;;; while running on Lisp Machine Eighteen from band 8
;;; with System 97.18, CADR 1.0, ZMail 51.6, MIT-Specific 21.0, microcode 257, ZM MIT.



; From file TOP.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; TOP  "

(DEFVAR *ZMAIL-INIT-LOADED* NIL
  "Allows preloading of Zmail profile")

))

; From file TOP.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; TOP  "

(DEFUN SET-ZMAIL-USER (&OPTIONAL SILENT &AUX (OLD-FRACT *SUMMARY-WINDOW-FRACTION*))
  (LET ((LOCK (LOCF *ZMAIL-PROFILE-LOADING-LOCK-CELL*)))
    (UNWIND-PROTECT
      (PROGN (PROCESS-LOCK LOCK)
	     (COND ((NOT (EQUAL *ZMAIL-USER* USER-ID))
		    (UNLESS *INITIALIZED-FOR-USER*
		      (LET ((*INTERVAL*
			      (OR *INTERVAL*	;Must not be NIL; would cause errors.
				  (WINDOW-INTERVAL *MSG-WINDOW*))))
			(TURN-ON-MODE *MAJOR-MODE*))
		      (SETQ *INITIALIZED-FOR-USER* T))
		    (LOAD-ZMAIL-INIT-FILE SILENT)
		    (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
		    (SET-MAIN-WINDOW-CONFIGURATION *DEFAULT-INITIAL-WINDOW-CONFIGURATION*
						   ( *SUMMARY-WINDOW-FRACTION* OLD-FRACT))
		    (SETQ *ZMAIL-USER* USER-ID))))
      (PROCESS-UNLOCK LOCK))))

))

; From file TOP.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; TOP  "

(DEFUN LOAD-ZMAIL-INIT-FILE (&OPTIONAL SILENT)
  (UNLESS (EQUAL *ZMAIL-INIT-LOADED* USER-ID)
    (LET ((LOCK (LOCF *ZMAIL-PROFILE-LOADING-LOCK-CELL*)))
      (UNWIND-PROTECT
	  (PROGN (PROCESS-LOCK LOCK)
		 (WITH-OPEN-FILE (STREAM (ZMAIL-INIT-FILE-PATHNAME)
					 ':ERROR NIL ':CHARACTERS ':DEFAULT)
		   (COND ((NOT (ERRORP STREAM))
			  (UNLESS SILENT (FORMAT QUERY-IO "~&Loading Zmail init file ~A"
						 (FUNCALL STREAM ':TRUENAME)))
			  (FUNCALL (IF (FUNCALL STREAM ':CHARACTERS)
				       #'SI:READFILE-INTERNAL #'SI:FASLOAD-INTERNAL)
				   STREAM "ZWEI" T))))
		 (SETQ *ZMAIL-INIT-LOADED* USER-ID))
	(PROCESS-UNLOCK LOCK)))))

))
