;;; -*- Mode: LISP; Package: TV; Base: 8 -*-

(defun set-tv-lines (n-lines)
  "Set the number of TV lines."
  ;; Try not to burn up the monitor
  (CHECK-ARG n-lines (AND (> n-lines 320.) (< n-lines 1000.))
	     "a number between 320. and 1000.")
  (DELAYING-SCREEN-MANAGEMENT
   (WITH-MOUSE-USURPED
    (LOCK-SHEET (MAIN-SCREEN)
		(LOCK-SHEET (WHO-LINE-SCREEN)
			    (WITHOUT-INTERRUPTS
			     (LET ((MS MOUSE-SHEET) (SW SELECTED-WINDOW))
				  (AND (SHEET-ME-OR-MY-KID-P MS MAIN-SCREEN)
				       (SETQ MOUSE-SHEET NIL))
				  (FUNCALL WHO-LINE-SCREEN ':DEEXPOSE)
				  (FUNCALL MAIN-SCREEN ':DEEXPOSE)

				  ;; Move the who-line, and change the dimensions of main screen
				  (SETQ MAIN-SCREEN-HEIGHT N-LINES)
				  (FUNCALL WHO-LINE-SCREEN ':CHANGE-OF-SIZE-OR-MARGINS
					   ':TOP (- MAIN-SCREEN-HEIGHT (SHEET-HEIGHT WHO-LINE-SCREEN)))
				  (FUNCALL MAIN-SCREEN ':CHANGE-OF-SIZE-OR-MARGINS
					   ':HEIGHT (- MAIN-SCREEN-HEIGHT (SHEET-HEIGHT WHO-LINE-SCREEN)))
				  (SETQ %DISK-RUN-LIGHT
					(+ (- (* MAIN-SCREEN-HEIGHT (SHEET-LOCATIONS-PER-LINE MAIN-SCREEN)) 15)
					   (LSH 77 18.)))
				  (SETQ WHO-LINE-RUN-LIGHT-LOC (+ 2 (LOGAND %DISK-RUN-LIGHT 777777)))
				  (FUNCALL WHO-LINE-SCREEN ':EXPOSE)
				  (FUNCALL MAIN-SCREEN ':EXPOSE)
				  (AND SW (FUNCALL SW ':SELECT))
				  (MOUSE-SET-SHEET MS)
				  N-LINES)))))))


