;;; Initializer for when machine has just been powered up.    -*-LISP-*-

(INCLUDE |LMDOC;.COMPL PRELUD|)
;(DECLARE (EVAL (READ))
; (LOAD '(MACROS > DSK LISPM))
;       (LOAD '(DEFMAC FASL DSK LISPM2))
;       (LOAD '(LMMAC > DSK LISPM2)))
(IF-FOR-MACLISP (DECLARE  (EVAL (READ))))
(IF-FOR-MACLISP (DEFUN **STRING** MACRO (X) `',(CADR X)) ;Bubbles in my brain
)

(INCLUDE ((LMCONS)CADMAC >))

(DECLARE (SPECIAL SPY-CLK
		  SPY-MODE CC-MODE-REG
		  CC-PDL-BUFFER-INDEX-CHANGED-FLAG
		  CC-MICRO-STACK-SAVED-FLAG
		  CC-SAVED-DISPATCH-CONSTANT
		  CC-PASSIVE-SAVE-VALID
		  CC-FULL-SAVE-VALID))

(DEFUN CC-ZERO-ENTIRE-MACHINE ()
  (SETQ CC-FULL-SAVE-VALID NIL
	CC-PASSIVE-SAVE-VALID NIL
	CC-SAVED-DISPATCH-CONSTANT NIL
	CC-MICRO-STACK-SAVED-FLAG NIL
	CC-PDL-BUFFER-INDEX-CHANGED-FLAG NIL)
  (DBG-RESET) ;TEMPORARY KLUDGE?  JUST IN CASE MACHINE IS HUNG
  (LET ((CC-MODE-REG 40))	;Bind this because CC-RUN-TEST-LOOP looks at it!
    (CC-RESET-MACH)		;Disable all error halts, disable prom, slow speed
    (CC-EXECUTE CONS-IR-ALUF CONS-ALU-SETZ	;Zero the pdl buffer
		CONS-IR-OB CONS-OB-ALU
		CONS-IR-FUNC-DEST CONS-FUNC-DEST-PDL-BUFFER-PUSH)
    (SPY-WRITE SPY-CLK 11)		;Set run and debug
    (SLEEP 1)			;Let it run for 1 second, plenty long enough
    (SPY-WRITE SPY-CLK 10)		;Clear run, but leave debug set
    (DO ADR 0 (1+ ADR) (= ADR 40)	;Set up level-1 map to address level-2 map
	(DECLARE (FIXNUM ADR))
	(CC-WRITE-LEVEL-1-MAP ADR ADR))
    (CC-WRITE-FUNC-DEST CONS-FUNC-DEST-VMA 1_25.) ;Initialize MD and VMA
    (CC-EXECUTE CONS-IR-M-SRC CONS-M-SRC-MD	;Set up DIB and IR to clear level-2 map
		CONS-IR-ALUF CONS-ALU-M+1
		CONS-IR-OB CONS-OB-ALU
		CONS-IR-FUNC-DEST CONS-FUNC-DEST-MD-WRITE-MAP)
    (SPY-WRITE SPY-CLK 11)		;Set run and debug
    (SLEEP 1)			;Let it run for 1 second, plenty long enough
    (SPY-WRITE SPY-CLK 10)		;Clear run, but leave debug set
    (CC-WRITE-A-MEM 1 10000)	;1@A gets increment for MD
    (CC-WRITE-FUNC-DEST CONS-FUNC-DEST-VMA 1_26.)	;Initialize MD and VMA
    (CC-EXECUTE CONS-IR-A-SRC 1	;Set up DIB and IR to clear level-1 map
		CONS-IR-M-SRC CONS-M-SRC-MD
		CONS-IR-ALUF CONS-ALU-ADD
		CONS-IR-OB CONS-OB-ALU
		CONS-IR-FUNC-DEST CONS-FUNC-DEST-MD-WRITE-MAP)
    (SPY-WRITE SPY-CLK 11)		;Set run and debug
    (SLEEP 1)			;Let it run for 1 second, plenty long enough
    (SPY-WRITE SPY-CLK 10)		;Clear run, but leave debug set
    (CC-FILL-A-MEM 0 1 T)		;Clear all of A memory except 0 (with fast loop)
    (CC-ZERO-D-MEM)		;Clear dispatch memory
    (CC-ZERO-C-MEM)		;Clear control memory
    (DO N 32. (1- N) (= N 0)	;Zero out the micro stack (leaves pointer random)
	(DECLARE (FIXNUM N))	;Note, the micro stack is bashed by writing D or C mem.
	(CC-EXECUTE (WRITE)
		    CONS-IR-ALUF CONS-ALU-SETZ
		    CONS-IR-OB CONS-OB-ALU
		    CONS-IR-FUNC-DEST CONS-FUNC-DEST-MICRO-STACK-PUSH))
    (DO ADR 0 (1+ ADR) (= ADR 40)	;Clear M mem, 0@A
	(DECLARE (FIXNUM ADR))
	(CC-EXECUTE (WRITE)
		    CONS-IR-ALUF CONS-ALU-SETZ
		    CONS-IR-OB CONS-OB-ALU
		    CONS-IR-M-MEM-DEST ADR)))
  (CC-RESET-MACH))		;Restore mode register and return

;MD has address in D memory.  1@A has zero.  Dispatch address is IR<22-12>.
;OA, Dispatch, increment, jump
(DEFUN CC-ZERO-D-MEM ()
  (CC-EXECUTE (W-C-MEM 0)
	CONS-IR-OP CONS-OP-BYTE
	CONS-IR-M-SRC CONS-M-SRC-MD
	CONS-IR-A-SRC 1
	CONS-IR-BYTE-FUNC CONS-BYTE-FUNC-DPB
	CONS-IR-MROT 12.
	CONS-IR-BYTL-1 10.
	CONS-IR-FUNC-DEST CONS-FUNC-DEST-OA-LOW)
  (CC-EXECUTE (W-C-MEM 1)
	CONS-IR-STAT-BIT 1
	CONS-IR-A-SRC 1  ;VALUE TO WRITE
	CONS-IR-OP CONS-OP-DISPATCH
	CONS-IR-DISP-ADDR 0
	CONS-IR-MF 2)
  (CC-EXECUTE (W-C-MEM 2)
	CONS-IR-M-SRC CONS-M-SRC-MD
	CONS-IR-OB CONS-OB-ALU
	CONS-IR-ALUF CONS-ALU-M+1
	CONS-IR-FUNC-DEST CONS-FUNC-DEST-MD)
  (CC-EXECUTE (W-C-MEM 3)
	CONS-IR-OP CONS-OP-JUMP
	CONS-IR-JUMP-ADDR 0
	CONS-IR-JUMP-COND CONS-JUMP-COND-UNC
	CONS-IR-N 1)
  (CC-WRITE-STAT-COUNTER -2048.) ;STOP AFTER WRITING 2048. LOCATIONS
  (CC-WRITE-A-MEM 1 0)
  (CC-WRITE-MD 0) ;STARTING AT 0
  (CC-RUN-TEST-LOOP 0))

;MD has address in C memory.  1@A, 1@M have zero.  Jump address is IR<25-12>.
;OA, W-C-MEM, increment, jump
(DEFUN CC-ZERO-C-MEM ()
  (CC-EXECUTE (W-C-MEM 0)
	CONS-IR-OP CONS-OP-BYTE
	CONS-IR-M-SRC CONS-M-SRC-MD
	CONS-IR-A-SRC 1
	CONS-IR-BYTE-FUNC CONS-BYTE-FUNC-DPB
	CONS-IR-MROT 12.
	CONS-IR-BYTL-1 13.
	CONS-IR-FUNC-DEST CONS-FUNC-DEST-OA-LOW)
  (CC-EXECUTE (W-C-MEM 1)
	CONS-IR-OP CONS-OP-JUMP
	CONS-IR-A-SRC 1 ;VALUE TO WRITE (HIGH)
	CONS-IR-M-SRC 1 ;VALUE TO WRITE (LOW)
	CONS-IR-JUMP-ADDR 0
	CONS-IR-JUMP-COND CONS-JUMP-COND-UNC
	CONS-IR-R 1
	CONS-IR-P 1
	CONS-IR-N 1)
  (CC-EXECUTE (W-C-MEM 2)
	CONS-IR-STAT-BIT 1
	CONS-IR-M-SRC CONS-M-SRC-MD
	CONS-IR-OB CONS-OB-ALU
	CONS-IR-ALUF CONS-ALU-M+1
	CONS-IR-FUNC-DEST CONS-FUNC-DEST-MD)
  (CC-EXECUTE (W-C-MEM 3)
	CONS-IR-OP CONS-OP-JUMP
	CONS-IR-JUMP-ADDR 0
	CONS-IR-JUMP-COND CONS-JUMP-COND-UNC
	CONS-IR-N 1)
  (CC-WRITE-STAT-COUNTER -16380.) ;STOP AFTER WRITING 16K-4 LOCATIONS
  (CC-WRITE-M-MEM 1 0)
  (CC-WRITE-MD 4) ;STARTING AT 4
  (CC-RUN-TEST-LOOP 0)
  (CC-WRITE-C-MEM 0 0)  ;NOW ZERO OUT THE TEST LOOP
  (CC-WRITE-C-MEM 1 0)
  (CC-WRITE-C-MEM 2 0)
  (CC-WRITE-C-MEM 3 0))
