;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Patch file for System version 78.37
;;; Reason: Expand PROCESS-RUN-FUNCTION
;;; Written 12/25/81 16:35:20 by HIC,
;;; while running on Basset from band 2
;;; with System 78.36, ZMail 38.5, Symbolics 8.7, Tape 6.5, LMFS 21.21, Canon 9.6, microcode 841.



; From file PROCES.LISP >LISPM2 POINTER:
#8R SYSTEM-INTERNALS:(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))

(DEFUN PROCESS-RUN-FUNCTION (NAME-OR-KWDS FUNCTION &REST ARGS)
  "Run a function in its own process.  The process is reused if the machine is warm booted
or if the process is reset."
  (PROCESS-RUN-FUNCTION-1 NAME-OR-KWDS FUNCTION ARGS NIL))

(DEFF PROCESS-RUN-TEMPORARY-FUNCTION 'PROCESS-RUN-FUNCTION)

(DEFUN PROCESS-RUN-RESTARTABLE-FUNCTION (NAME FUNCTION &REST ARGS)
  "Run a function in its own process.  The process is reset and restarted when the machine
is warm booted, and restarted when the process is reset."
  (PROCESS-RUN-FUNCTION-1 NAME FUNCTION ARGS '(:RESTART-AFTER-BOOT T :RESTART-AFTER-RESET T)))

(DEFUN PROCESS-RUN-FUNCTION-1 (NAME-OR-KEYS FUNCTION ARGS LOCAL-KEYS)
  (LET ((NAME (IF (STRINGP NAME-OR-KEYS) NAME-OR-KEYS NIL))
	(PRIORITY 0)
	(QUANTUM 60.)
	RESTART-AFTER-RESET RESTART-AFTER-BOOT PROCESS WARM-BOOT-ACTION)
    (KEYWORD-EXTRACT (IF (STRINGP NAME-OR-KEYS) LOCAL-KEYS (APPEND LOCAL-KEYS NAME-OR-KEYS))
		     KEYWORDS
		     (NAME PRIORITY QUANTUM RESTART-AFTER-RESET RESTART-AFTER-BOOT
			   WARM-BOOT-ACTION)
      NIL NIL)
    (SETQ PROCESS (WITHOUT-INTERRUPTS (OR (POP PROCESS-RUN-FUNCTION-SPARE-PROCESSES)
					  (MAKE-PROCESS NAME
							':SPECIAL-PDL-SIZE 4000
							':REGULAR-PDL-SIZE 15000))))
    (SETF (PROCESS-NAME PROCESS) (OR NAME (SETQ NAME "Anonymous")))
    (SETF (PROCESS-WARM-BOOT-ACTION PROCESS) (IF (EQ WARM-BOOT-ACTION ':FLUSH)
						 NIL
					       (OR WARM-BOOT-ACTION
						   (AND RESTART-AFTER-BOOT
							#'PROCESS-WARM-BOOT-DELAYED-RESTART)
						   #'PROCESS-RUN-FUNCTION-WARM-BOOT-RESET)))
    (SETF (SG-NAME (PROCESS-INITIAL-STACK-GROUP PROCESS)) NAME)
    (FUNCALL PROCESS ':SET-QUANTUM QUANTUM)
    (FUNCALL PROCESS ':SET-PRIORITY PRIORITY)
    (LEXPR-FUNCALL #'PROCESS-PRESET PROCESS
		   #'PROCESS-RUN-FUNCTION-INTERNAL RESTART-AFTER-RESET FUNCTION ARGS)
    (PROCESS-ENABLE PROCESS)
    PROCESS))

)
