;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Patch file for System version 78.44
;;; Reason: Time printers not to impugn daylightness to explicitly supplied timezones.
;;; Written 1/06/82 20:34:58 by BSG,
;;; while running on Basset from band 2
;;; with System 78.43, ZMail 38.5, Symbolics 8.7, Tape 6.5, LMFS 21.26, Canon 9.11, microcode 841.



; From file TIME.LISP >LMIO1 POINTER:
#8R TIME:(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TIME")))

;; Takes Univeral Time (seconds since 1/1/1900) as a 32-bit number
;; Algorithm from KLH's TIMRTS.
(DEFUN DECODE-UNIVERSAL-TIME (UNIVERSAL-TIME &OPTIONAL TIMEZONE
					    &AUX SECS MINUTES HOURS DAY MONTH
					     YEAR DAY-OF-THE-WEEK DST-P)
  (DECLARE (RETURN-LIST SECS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK DAYLIGHT-SAVINGS-P))
  (IF TIMEZONE					;explicit timezone means no-dst
      (MULTIPLE-VALUE (SECS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK)
	 (DECODE-UNIVERSAL-TIME-WITHOUT-DST UNIVERSAL-TIME TIMEZONE))
    ;;Otherwise, decode the time and THEN daylight-adjust it.
    (MULTIPLE-VALUE (SECS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK)
      (DECODE-UNIVERSAL-TIME-WITHOUT-DST UNIVERSAL-TIME *TIMEZONE*))
    (AND (SETQ DST-P (DAYLIGHT-SAVINGS-TIME-P HOURS DAY MONTH YEAR))
	 ;; See if it's daylight savings time, time-zone number gets smaller if so.
	 (MULTIPLE-VALUE (SECS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK)
	   (DECODE-UNIVERSAL-TIME-WITHOUT-DST UNIVERSAL-TIME (1- *TIMEZONE*)))))
  (PROG () (RETURN SECS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK DST-P)))

)

; From file TIME.LISP >LMIO1 POINTER:
#8R TIME:(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TIME")))

(DEFUN PRINT-UNIVERSAL-DATE (UT &OPTIONAL (STREAM STANDARD-OUTPUT) TIMEZONE)
  (MULTIPLE-VALUE-BIND (SECONDS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK)
      (DECODE-UNIVERSAL-TIME UT TIMEZONE)
    (PRINT-DATE SECONDS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK STREAM)))

)

; From file TIME.LISP >LMIO1 POINTER:
#8R TIME:(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TIME")))

(DEFUN PRINT-UNIVERSAL-TIME (UT &OPTIONAL (STREAM STANDARD-OUTPUT) TIMEZONE)
  ;;Let DECODE-UNIVERSAL-TIME default the timezone if wanted, as that fcn
  ;;must know to suppress DST iff TIMEZONE is supplied.
  (MULTIPLE-VALUE-BIND (SECONDS MINUTES HOURS DAY MONTH YEAR)
      (DECODE-UNIVERSAL-TIME UT TIMEZONE)
    (PRINT-TIME SECONDS MINUTES HOURS DAY MONTH YEAR STREAM)))

)
