#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/mman.h>

#include <ucontext.h>

char *p;

void segv_handler (int sigval, siginfo_t *si, void *uc)
{
	printf("segv_handler()\n");
}

void plan2(void)
{
	printf("plan2\n"); fflush(stdout);
	while(1);
}

void buserr_handler (int sigval, struct __siginfo *si, void *uc_p)
{
	register struct ucontext64 *uc = (struct ucontext64*)uc_p;
	int ret;

	printf("buserr_handler(sigval=%d, si=%p, uc=%p)\n", sigval, si, uc);

	ret = mprotect((caddr_t)p, (size_t)8192, PROT_READ | PROT_WRITE);
	if (ret)
		perror("mprotect");

//	printf("Unexpected SEGV at PC %p on VMA %p\n",
//	       (void*)uc->uc_mcontext64->ss.srr0, (void*)uc->uc_mcontext64->es.dar);
//
//	uc->uc_mcontext64->ss.srr0 = (uint64_t)plan2;
}

main()
{
    struct sigaction action;
    volatile char *page, v;
    int ret;

    action.sa_sigaction = segv_handler;
//    action.sa_flags = SA_SIGINFO;
    action.sa_flags = 0;

    sigemptyset(&action.sa_mask);
    if (sigaction(SIGSEGV, &action, NULL))
	    perror("sigaction");

    action.sa_sigaction = buserr_handler;
//    action.sa_flags = SA_SIGINFO;
    action.sa_flags = 0;

    sigemptyset(&action.sa_mask);
    if (sigaction(SIGBUS, &action, NULL))
	    perror("sigaction");

    page = malloc(1024*1024);
    ret = mprotect((caddr_t)page, (size_t)8192, PROT_READ);
    if (ret)
	    perror("mprotect");

    p = page;

    printf("read\n"); fflush(stdout);
    v = page[0];
    printf("read done\n"); fflush(stdout);

    printf("write\n"); fflush(stdout);
    page[0] = v;
    printf("write done\n"); fflush(stdout);

/*
f0             204.80000019073486	(raw 0x406999999a000000)
f1             214748365	(raw 0x41a999999a000000)
f2             1048576	(raw 0x4130000000000000)
*/
    {
	    double n1, n2, n3;

asm volatile ("mtfsf 0xff,f31");
asm volatile ("mtfsfi 6,0xf");

	    *(long *)&n2 = 0x41a999999a000000L;
	    *(long *)&n3 = 0x4130000000000000L;
	    n1 = n2 / n3;
	    asm volatile ("fdiv f0,f1,f2");
	    asm volatile ("mtfsb1 28");
	    asm volatile ("mtfsb0 30");
	    asm volatile ("mtfsb0 31");
//	    printf("n1 %lx, n2 %lx, n3 %lx\n",
//		   *(long *)&n1, *(long *)&n2, *(long *)&n3);
//	    printf("n1 %g\n", n1);

	    n3 = 0;
	    n1 = n2 / n3;
	    asm volatile ("fdiv f0,f1,f2");
	    asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);

	    n2 = 0;
	    n1 = n2 / n3;
	    asm volatile ("fdiv f0,f1,f2");
	    asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);
    }

//    asm volatile ("fdiv	f0,f1,f2");
//    asm volatile ("mtfsb1	28");

    exit(0);
}
