#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/mman.h>

#include <ucontext.h>

/* set up FPU to trap floating point exceptions */
extern void u_fpu_setup(void);

#include <architecture/ppc/fp_regs.h>
#include <mach/mach.h>
#include <pthread.h>

static void *fpu_fpe_enable(void *arg);
#define FE0_MASK (1<<11)
#define FE1_MASK (1<<8)
/* FE0 FE1 exceptions enabled if either FE0 or FE1 set
 * 0 0 -- floating-point exceptions disabled
 * 0 1 -- floating-point imprecise nonrecoverable
 * 1 0 -- floating-point imprecise recoverable
 * 1 1 -- floating-point precise mode
 */

void u_set_fp_scr(void)
{
	ppc_fp_scr_t r = get_fp_scr();

	/* turn off exception bits to prevent immediate re-fault */
	r.fx = r.fex = r.vx = r.ox = r.ux = r.zx = r.xx = r.vx_snan = r.vx_isi =
		r.vx_idi = r.vx_zdz = r.vx_imz = r.vx_xvc = r.vx_cvi = r.vx_soft = 0;

	/* these only have to be set once, but may as well set anyway */
	r.ve = 1; /* invalid */
	r.oe = 1; /* overflow */
	r.ue = 0; /* underflow */
	r.ze = 1; /* zero divide */
	r.xe = 0; /* inexact */

	set_fp_scr(r);
}

void code2(void)
{
	printf("code2\n"); fflush(stdout);
}

void fpe_handler(int sigval, struct __siginfo *si, void *uc_p)
{
	int ret, i;

	printf("fpe_handler(sigval=%d, si=%p, uc=%p)\n", sigval, si, uc_p);
//	printf("was %p\n", ((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0);
//	((struct ucontext*)uc_p)->uc_mcontext->ss.srr0 = (uint64_t)code2;
//	for (i = 0; i < 32; i++)
//		((struct ucontext*)uc_p)->uc_mcontext->fs.fpregs[i] = 1.0;
//	u_set_fp_scr();

//	((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0 = (uint64_t)code2;
//	((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0 = 
//		((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0 + 4;

	{
	  struct ppc_thread_state state;
	  mach_msg_type_number_t state_size = THREAD_STATE_MAX;
	  thread_t t = mach_thread_self();

	  if (thread_get_state(t, PPC_THREAD_STATE64,
			       (natural_t *)&state, &state_size) == KERN_SUCCESS) {
//		  state.srr0 = (uint64_t)code2;
printf("set srr0\n");
		  thread_set_state(t, PPC_THREAD_STATE64, (natural_t *)&state, state_size);
	  }
	}

//	printf("is  %p\n", ((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0);

//	while (1) sleep(1);

	printf("exit\n"); fflush(stdout);
	return 0;
}


/* a thread cannot get or set its own MSR bits */
static void *
fpu_fpe_enable(void *arg)
{
	thread_t t = *(thread_t *)arg;
	struct ppc_thread_state state;
	unsigned int state_size = PPC_THREAD_STATE_COUNT;

	printf("fpu_fpe_enable(arg=%p)\n", arg); fflush(stdout);

	if (thread_get_state(t, PPC_THREAD_STATE64,
			     (natural_t *)&state, &state_size) == KERN_SUCCESS) {
		state.srr1 |= FE1_MASK;
		thread_set_state(t, PPC_THREAD_STATE64, (natural_t *)&state, state_size);
	}

	printf("fpu_fpe_enable() done\n"); fflush(stdout);

//	while (1) sleep(1);

	return 0;
}

void
u_fpu_setup(void)
{
	static volatile int looping = 0;
	thread_t self = mach_thread_self();
	pthread_t enabler;

	u_set_fp_scr();

	/* MSR bit reset after every fault, set it again */
	printf("calling pthread_create\n");
	pthread_create(&enabler, 0, fpu_fpe_enable, &self);
	usleep(1);

	printf("back from pthread_create\n");
}

main()
{
	struct sigaction action;
	double n1, n2, n3;

/*
  f0             204.80000019073486	(raw 0x406999999a000000)
  f1             214748365	(raw 0x41a999999a000000)
  f2             1048576	(raw 0x4130000000000000)
*/

#if 1
	action.sa_sigaction = fpe_handler;
//	action.sa_flags = SA_SIGINFO;
	action.sa_flags = 0;

	sigemptyset(&action.sa_mask);
	if (sigaction(SIGFPE, &action, NULL))
		perror("sigaction");
#endif

	u_fpu_setup();

//	asm volatile ("mtfsf 0xff,f31");
//	asm volatile ("mtfsfi 6,0xf");

	printf("doing math 1\n");

	*(long *)&n2 = 0x41a999999a000000L;
	*(long *)&n3 = 0x4130000000000000L;
	n1 = n2 / n3;
	asm volatile ("fdiv f0,f1,f2");
	asm volatile ("mtfsb1 28");
	asm volatile ("mtfsb0 30");
	asm volatile ("mtfsb0 31");
//	    printf("n1 %lx, n2 %lx, n3 %lx\n",
//		   *(long *)&n1, *(long *)&n2, *(long *)&n3);
//	    printf("n1 %g\n", n1);

	printf("doing math 2\n");

	n3 = 0;
	n1 = n2 / n3;
	asm volatile ("fdiv f0,f1,f2");
	asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);

	printf("doing math 3\n");

	n2 = 0;
	n1 = n2 / n3;
	asm volatile ("fdiv f0,f1,f2");
	asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);

//    asm volatile ("fdiv	f0,f1,f2");
//    asm volatile ("mtfsb1	28");

	printf("done with math\n");

	exit(0);
