/* */

#include <ctype.h>
#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>

#include <signal.h>

#include <pthread.h>

#include <sys/mman.h>
#define _FPU_RESERVED 0xffffff00
#ifndef SA_NODEFER
#define SA_NODEFER 0
#endif

#include <ucontext.h>
#include <architecture/ppc/fp_regs.h>

#include <mach/mach_types.h>
#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>
#include <mach/exception_types.h>

#define HANDLER_COUNT 64

typedef struct exception_ports_s {
    mach_msg_type_number_t maskCount;
    exception_mask_t       masks[HANDLER_COUNT];
    exception_handler_t    handlers[HANDLER_COUNT];
    exception_behavior_t   behaviors[HANDLER_COUNT];
    thread_state_flavor_t  flavors[HANDLER_COUNT];
} exception_ports_t;

exception_ports_t old_exception_ports;


int ecount;

void code2(void)
{
	printf("code2\n"); fflush(stdout);
}

#if 0
void
restore_mach_thread_state(mach_port_t thread, ExceptionInformation *lss)
{
  int i, j;
#ifdef PPC64
  struct mcontext64 *mc = UC_MCONTEXT(lss);
#else
  struct mcontext * mc = UC_MCONTEXT(lss);
#endif

  /* Set the thread's FP state from the lss */
  thread_set_state(thread,
		   PPC_FLOAT_STATE,
		   (thread_state_t)&(mc->fs),
		   PPC_FLOAT_STATE_COUNT);

  /* The thread'll be as good as new ... */
#ifdef PPC64
  thread_set_state(thread,
                   PPC_THREAD_STATE64,
                   (thread_state_t)&(mc->ss),
                   PPC_THREAD_STATE64_COUNT);
#else
  thread_set_state(thread, 
		   MACHINE_THREAD_STATE,
		   (thread_state_t)&(mc->ss),
		   MACHINE_THREAD_STATE_COUNT);
#endif
}  

/* This code runs in the exception handling thread, in response
   to an attempt to execute the UU0 at "pseudo_sigreturn" (e.g.,
   in response to a call to pseudo_sigreturn() from the specified
   user thread.
   Find that context (the user thread's R3 points to it), then
   use that context to set the user thread's state.  When this
   function's caller returns, the Mach kernel will resume the
   user thread.
*/

kern_return_t
do_pseudo_sigreturn(mach_port_t thread, TCR *tcr)
{
  ExceptionInformation *xp;

  lock_acquire(mach_exception_lock_set, 0);
  xp = tcr->pending_exception_context;
  tcr->pending_exception_context = NULL;
  tcr->valence = TCR_STATE_LISP;
  restore_mach_thread_state(thread, xp);
  raise_pending_interrupt(tcr);
  lock_release(mach_exception_lock_set, 0);
  return KERN_SUCCESS;

}  

void
restore_mach_thread_state(mach_port_t thread, ExceptionInformation *lss)
{
    int i, j;
    struct mcontext64 *mc = UC_MCONTEXT(lss);

    /* Set the thread's FP state from the lss */
    thread_set_state(thread,
                     PPC_FLOAT_STATE,
                     (thread_state_t)&(mc->fs),
                     PPC_FLOAT_STATE_COUNT);

    /* The thread'll be as good as new ... */
    thread_set_state(thread,
                     PPC_THREAD_STATE64,
                     (thread_state_t)&(mc->ss),
                     PPC_THREAD_STATE64_COUNT);
}  
#endif

/*
  This function runs in the exception handling thread.  It's
  called (by this precise name) from the library function "exc_server()"
  when the thread's exception ports are set up.  (exc_server() is called
  via mach_msg_server(), which is a function that waits for and dispatches
  on exception messages from the Mach kernel.)

  This checks to see if the exception was caused by a pseudo_sigreturn()
  UUO; if so, it arranges for the thread to have its state restored
  from the specified context.

  Otherwise, it tries to map the exception to a signal number and
  arranges that the thread run a "pseudo signal handler" to handle
  the exception.

  Some exceptions could and should be handled here directly.
*/

#define true 1
#define false 0

kern_return_t
catch_exception_raise(mach_port_t exception_port,
		      mach_port_t thread,
		      mach_port_t task, 
		      exception_type_t exception,
		      exception_data_t code_vector,
		      mach_msg_type_number_t code_count)
{
    int signum = 0, code = *code_vector;
    kern_return_t kret;  
    unsigned int portIndex;

    mach_port_t port;
    exception_behavior_t behavior;
    thread_state_flavor_t flavor;

    thread_state_data_t thread_state;
    mach_msg_type_number_t thread_state_count;

    printf("hey! catch_exception_raise(exception_port=%p)!\n", exception_port);

    if (++ecount > 2) exit(0);

    for (portIndex = 0; portIndex < old_exception_ports.maskCount; portIndex++) {
printf("[%d] %x %x\n", portIndex, old_exception_ports.masks[portIndex], (1 << exception));
        if (old_exception_ports.masks[portIndex] & (1 << exception)) {
            // This handler wants the exception
            break;
        }
    }

    if (portIndex >= old_exception_ports.maskCount) {
        fprintf(stderr, "No handler for exception = %d. Not fowarding\n",
		exception);
        return KERN_FAILURE;
    }

    port = old_exception_ports.handlers[portIndex];
    behavior = old_exception_ports.behaviors[portIndex];
    flavor = old_exception_ports.flavors[portIndex];

printf("flavor %x, should be %x\n", flavor, PPC_THREAD_STATE64);

    thread_state_count = THREAD_STATE_MAX;
    kret = thread_get_state (thread, flavor, thread_state, &thread_state_count);
    if (kret != KERN_SUCCESS)
        printf("thread_get_state failed %d\n", kret);

    switch (exception) {
    case EXC_BAD_ACCESS:
        printf("EXC_BAD_ACCESS\n");
        signum = SIGSEGV;
        break;

    case EXC_BAD_INSTRUCTION:
        signum = SIGILL;
        break;

    case EXC_SOFTWARE:
        if (code == EXC_PPC_TRAP) {
            signum = SIGTRAP;
        }
        break;

    case EXC_ARITHMETIC:
        printf("EXC_ARITHMETIC\n");
//return KERN_SUCCESS;

        signum = SIGFPE;
#if 1
        {
            struct ppc_thread_state64 state;
            mach_msg_type_number_t state_size = THREAD_STATE_MAX;

            kret = thread_get_state(thread, PPC_THREAD_STATE64,
                                    (natural_t *)&state, &state_size);
            if (kret == KERN_SUCCESS) {
printf("old srr0 %p, srr1 %p\n", state.srr0, state.srr1);
                state.srr0 = (uint64_t)code2;
//                state.srr0 += 4;
            state.srr1 |= 0x400UL; // enable SE bit
printf("set srr0\n");
		kret = thread_set_state(thread, PPC_THREAD_STATE64,
                                        (natural_t *)&state, state_size);
                if (kret != KERN_SUCCESS)
                    printf("thread_set_state failed %d\n", kret);
printf("set srr0 ok\n");
            } else
                printf("get ppc state failed %d\n", kret);
        }
#else
 {
            struct ppc_thread_state64 *ps = (struct ppc_thread_state64 *)&thread_state;
            ps->srr0 = (uint64_t)code2;
            printf("set srr0 #2\n");
            kret = thread_set_state(thread, flavor, thread_state, thread_state_count);
            if (kret)
                printf("set state failed %d\n", kret);

printf("behavior %x, want %x\n", behavior,EXCEPTION_DEFAULT);
 }
#endif
        break;

    default:
        break;
    }

#if 0
    if (behavior != EXCEPTION_DEFAULT) {
        kret = thread_set_state (thread, flavor, thread_state, thread_state_count);
	if (kret)
            printf("thread_set_state failed %d\n", kret);
    }
#endif

//return 1;
printf("exiting\n");
//thread_resume(thread);
//thread_resume(mach_thread_self());
    return KERN_SUCCESS;
}


/*
  The initial function for an exception-handling thread.
*/

void *
exception_handler_proc(void *arg)
{
    extern boolean_t exc_server();
    mach_port_t p = (mach_port_t) arg;

    mach_msg_server(exc_server, 256, p, 0);

    /* Should never return. */
    abort();
}


mach_port_t
mach_exception_port_set()
{
    static mach_port_t __exception_port_set = MACH_PORT_NULL;
    kern_return_t kret;  
    pthread_t thread;

    printf("mach_exception_port_set()\n");

    if (__exception_port_set == MACH_PORT_NULL) {

        kret = mach_port_allocate(mach_task_self(),
                                  MACH_PORT_RIGHT_PORT_SET,
                                  &__exception_port_set);
        if (kret)
	    printf("port allocate %d\n", kret);

        printf("__exception_port_set %p\n", __exception_port_set);

        pthread_create(&thread, 0,
                       exception_handler_proc,
                       (void *)__exception_port_set);
        usleep(1);
    }

    return __exception_port_set;
}

kern_return_t
setup_mach_exception_handling(void)
{
    mach_port_t thread_exception_port = MACH_PORT_NULL;
    mach_port_t task_self = mach_task_self();
    kern_return_t kret, krc;

    /* */
    krc = mach_port_allocate(task_self,
                             MACH_PORT_RIGHT_RECEIVE,
                             &thread_exception_port);
    if (krc != KERN_SUCCESS)
        printf("port allocate %d\n",kret);

    printf("thread_exception_port %p\n", thread_exception_port);

    /* */
    kret = mach_port_insert_right(task_self,
                                  thread_exception_port,
                                  thread_exception_port,
                                  MACH_MSG_TYPE_MAKE_SEND);

    if (krc != KERN_SUCCESS)
        printf("adding send right to exception_port %d\n",kret);

    /* */
    krc = task_set_exception_ports(task_self,
                                   EXC_MASK_ALL & ~(EXC_MASK_MACH_SYSCALL | 
						    EXC_MASK_SYSCALL |
						    EXC_MASK_RPC_ALERT),
                                   thread_exception_port,
                                   EXCEPTION_DEFAULT, THREAD_STATE_NONE);
    if (krc != KERN_SUCCESS)
        printf("set exception port %d\n", krc);

    {
        mach_port_t exception_port_set = mach_exception_port_set();

        printf("exception_port_set %p\n", exception_port_set);

        kret = mach_port_move_member(task_self,
                                     thread_exception_port,
                                     exception_port_set);
        if (kret != KERN_SUCCESS)
            printf("port move %d\n", kret);
    }

    return kret;
}


void
init_mach_exceptions(void)
{
    exception_ports_t *ports;
    kern_return_t krc;  
    mach_port_t task_self = mach_task_self();
    int i;

    ports = &old_exception_ports;
    memset(ports, 0, sizeof(*ports));

    ports->maskCount = sizeof(ports->masks)/sizeof(ports->masks[0]);

    krc = task_get_exception_ports(task_self, EXC_MASK_ALL, ports->masks,  
                                   &ports->maskCount,
                                   ports->handlers, ports->behaviors, ports->flavors);

    printf("ports->maskCount %d\n", ports->maskCount);

    for (i = 0; i < ports->maskCount; i++) {
        printf("[%d] masks %x, flavors %x\n",
               i, ports->masks[i], ports->flavors[i]);
    }

    if (krc != KERN_SUCCESS)
        printf("Unable to get old task exception ports %d\n", krc);

    setup_mach_exception_handling();
}

#define FE0_MASK (1<<11)
#define FE1_MASK (1<<8)
/* FE0 FE1 exceptions enabled if either FE0 or FE1 set
 * 0 0 -- floating-point exceptions disabled
 * 0 1 -- floating-point imprecise nonrecoverable
 * 1 0 -- floating-point imprecise recoverable
 * 1 1 -- floating-point precise mode
 */

void u_set_fp_scr(void)
{
	ppc_fp_scr_t r = get_fp_scr();

	/* turn off exception bits to prevent immediate re-fault */
	r.fx = r.fex = r.vx = r.ox = r.ux = r.zx = r.xx = r.vx_snan = r.vx_isi =
		r.vx_idi = r.vx_zdz = r.vx_imz = r.vx_xvc = r.vx_cvi = r.vx_soft = 0;

	/* these only have to be set once, but may as well set anyway */
	r.ve = 1; /* invalid */
	r.oe = 1; /* overflow */
	r.ue = 0; /* underflow */
	r.ze = 1; /* zero divide */
	r.xe = 0; /* inexact */

	set_fp_scr(r);
}

void fpe_handler(int sigval, struct __siginfo *si, void *uc_p)
{
	int ret, i;

	printf("fpe_handler(sigval=%d, si=%p, uc=%p)\n", sigval, si, uc_p);
	printf("was %p\n", ((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0);
	((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0 = (uint64_t)code2;
	printf("is  %p\n", ((struct ucontext64*)uc_p)->uc_mcontext64->ss.srr0);
//	for (i = 0; i < 32; i++)
//		((struct ucontext64*)uc_p)->uc_mcontext64->fs.fpregs[i] = 1.0;
//	u_set_fp_scr();
}

/* a thread cannot get or set its own MSR bits */
static void *
fpu_fpe_enable(void *arg)
{
	thread_t t = *(thread_t *)arg;
	struct ppc_thread_state64 state;
	unsigned int state_size = THREAD_STATE_MAX/*PPC_THREAD_STATE_COUNT*/;

	printf("fpu_fpe_enable(arg=%p)\n", arg); fflush(stdout);

	if (thread_get_state(t, PPC_THREAD_STATE64,
			     (natural_t *)&state, &state_size) == KERN_SUCCESS) {
printf("setting FE1_MASK!\n");
		state.srr1 |= FE1_MASK;
		thread_set_state(t, PPC_THREAD_STATE64, (natural_t *)&state, state_size);
	}
        else
printf("setting FE1_MASK FAILED!\n");

	printf("fpu_fpe_enable() done\n"); fflush(stdout);

//	while (1) sleep(1);

	return 0;
}

void
u_fpu_setup(void)
{
	static volatile int looping = 0;
	thread_t self = mach_thread_self();
	pthread_t enabler;

	u_set_fp_scr();

	/* MSR bit reset after every fault, set it again */
	printf("calling pthread_create\n");
	pthread_create(&enabler, 0, fpu_fpe_enable, &self);
	usleep(1);

	printf("back from pthread_create\n");
}

void
init_signal(void)
{
	struct sigaction action;
	action.sa_sigaction = fpe_handler;
	action.sa_flags = SA_SIGINFO;
//	action.sa_flags = 0;

	sigemptyset(&action.sa_mask);
	if (sigaction(SIGFPE, &action, NULL))
		perror("sigaction");
}

void
math_fault(void)
{
    double n1, n2, n3;

    printf("doing math 1\n"); fflush(stdout);

    *(long *)&n2 = 0x41a999999a000000L;
    *(long *)&n3 = 0x4130000000000000L;
    n1 = n2 / n3;
    asm volatile ("fdiv f0,f1,f2");
    asm volatile ("mtfsb1 28");
    asm volatile ("mtfsb0 30");
    asm volatile ("mtfsb0 31");
//	    printf("n1 %lx, n2 %lx, n3 %lx\n",
//		   *(long *)&n1, *(long *)&n2, *(long *)&n3);
//	    printf("n1 %g\n", n1);

    printf("done math 1\n"); fflush(stdout);

    printf("doing math 2\n");

    n3 = 0;
    n1 = n2 / n3;
    asm volatile ("fdiv f0,f1,f2");
    asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);

    printf("doing math 3\n");

    n2 = 0;
    n1 = n2 / n3;
    asm volatile ("fdiv f0,f1,f2");
    asm volatile ("mtfsb1	28");
//	    printf("n1 %g\n", n1);

//    asm volatile ("fdiv	f0,f1,f2");
//    asm volatile ("mtfsb1	28");

    printf("done with math\n");
}

void
mem_fault(void)
{
    char *p = (char *)-27;
    printf("do fault\n"); fflush(stdout);
    *p = 0;
    printf("after fault\n"); fflush(stdout);
}

main()
{
    u_fpu_setup();
    init_mach_exceptions();

    init_signal();

//    mem_fault();
    math_fault();
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
 */

