/*
 * ldisass.c
 * l-machine macrocode disassembler
 *
 * Copyright (C) 2004 Brad Parker <brad@heeltoe.com>
 * $Id: ldisass.c,v 1.3 2004/06/09 15:14:00 brad Exp $
 */

/* instruction formats */ 
enum inst_format {
	unsigned_immediate_operand,
	signed_immediate_operand,
	ten_bit_immediate_operand,
	address_operand,
	no_operand,
	quick_external_call,
	constant_operand,
	indirect_operand,
	lexical_operand,
	microcode_operand,
	unsigned_pc_relative,
	signed_pc_relative,
	constant_pc_relative
};

/* instruction attributes */
enum attributes {
     smashes_stack = 1,
     needs_stack = 2,
     branch = 4,
     branch_if = 8,
     branch_if_not = 16,
     stop_ifu = 32,
     tos_unchanged = 64,
     operand_character = 1<<8,
     operand_byte_pointer = 1<<9,
     operand_data_type = 1<<10,
     operand_long_branch_low_byte = 1<<11,
     operand_argument_number = 1<<12,
     operand_instance_variable = 1<<13,
     operand_lexical_variable = 1<<14,
     operand_push_list_counts = 1<<15
};


/*
 * table of macrocode opcodes w/format & attributes
 */
#define defopcode(name,value,format,attributes) { #name, 0##value, format, attributes }

struct opcode_s {
	char *name;
	int value;
	int format;
	int attributes;
} opcodes[] = {
defopcode(push-indirect,100,indirect_operand,0),
defopcode(push-constant,101,constant_operand,0),
defopcode(push-local,102,address_operand,0),
defopcode(push-immed,103,signed_immediate_operand,0),
defopcode(push-address-local,104,address_operand,0),
defopcode(push-from-beyond-multiple,105,unsigned_immediate_operand,0),
defopcode(movem-local,106,address_operand,needs_stack),
defopcode(movem-indirect,107,indirect_operand,needs_stack),
defopcode(pop-local,110,address_operand,needs_stack),
defopcode(pop-indirect,111,indirect_operand,needs_stack),
defopcode(push-character,112,unsigned_immediate_operand,operand_character),
defopcode(push-n-nils,120,unsigned_immediate_operand,0),
defopcode(push-nil,1120,no_operand,0),
defopcode(push-2-nils,1230,no_operand,0),
defopcode(push-t,1231,no_operand,0),
defopcode(pop-n,121,unsigned_immediate_operand,0),
defopcode(pop-n-save-1,122,unsigned_immediate_operand,needs_stack),
defopcode(pop-n-save-m,123,unsigned_immediate_operand,needs_stack),
defopcode(pop-n-save-multiple,124,unsigned_immediate_operand,needs_stack),
defopcode(pop-multiple-save-n,125,unsigned_immediate_operand,0),
defopcode(fixup-tos,1160,no_operand,0),
defopcode(pop-multiple-save-multiple,1161,no_operand,needs_stack),
defopcode(push-car-local,255,address_operand,0),
defopcode(push-cdr-local,256,address_operand,0),
defopcode(push-instance-variable,130,unsigned_immediate_operand,operand_instance_variable),
defopcode(movem-instance-variable,131,unsigned_immediate_operand,needs_stack|operand_instance_variable),
defopcode(pop-instance_variable,132,unsigned_immediate_operand,needs_stack|operand_instance_variable),
defopcode(push-address-instance-variable,133,unsigned_immediate_operand,operand_instance_variable),
defopcode(push-instance-variable-ordered,134,unsigned_immediate_operand,operand_instance_variable),
defopcode(movem-instance-variable-ordered,135,unsigned_immediate_operand,needs_stack|operand_instance_variable),
defopcode(pop-instance-variable-ordered,136,unsigned_immediate_operand,needs_stack|operand_instance_variable),
defopcode(push-address-instance-variable-ordered,137,unsigned_immediate_operand,operand_instance_variable),
defopcode(%instance-ref,230,unsigned_immediate_operand,0),
defopcode(%instance-loc,231,unsigned_immediate_operand,0),
defopcode(%instance-set,232,unsigned_immediate_operand,0),
defopcode(bind-specvar,140,indirect_operand,0),
defopcode(bind-locative,1140,no_operand,0),
defopcode(unbind-n,141,unsigned_immediate_operand,0),
defopcode(%save-binding-stack-level,1141,no_operand,0),
defopcode(%restore-binding-stack-level,1142,no_operand,0),
defopcode(optional-arg-supplied-p,142,unsigned_immediate_operand,operand_argument_number),
defopcode(append-multiple-groups,1143,no_operand,needs_stack),
defopcode(take-arg,143,unsigned_immediate_operand,0),
defopcode(require-args,144,unsigned_immediate_operand,needs_stack|smashes_stack),
defopcode(take-values,145,unsigned_immediate_operand,0),
defopcode(take-keyword-argument,146,address_operand,needs_stack),
defopcode(take-n-args,150,unsigned_immediate_operand,0),
defopcode(take-n-args-rest,151,unsigned_immediate_operand,0),
defopcode(take-rest-arg,152,unsigned_immediate_operand,0),
defopcode(take-n-optional-args,153,unsigned_immediate_operand,0),
defopcode(take-n-optional-args-rest,154,unsigned_immediate_operand,0),
defopcode(take-m-required-n-optional_args,155,unsigned_immediate_operand,needs_stack|smashes_stack),
defopcode(take-m-required-n-optional_args_rest,156,unsigned_immediate_operand,needs_stack|smashes_stack),
defopcode(branch,160,signed_pc_relative,branch),
defopcode(branch-true,161,signed_pc_relative,branch_if_not),
defopcode(branch-false,162,signed_pc_relative,branch_if),
defopcode(branch-true-else-pop,163,signed_pc_relative,branch_if_not),
defopcode(branch-false-else-pop,164,signed_pc_relative,branch_if),
defopcode(branch-true-and-pop,165,signed_pc_relative,branch_if_not),
defopcode(branch-false-and-pop,166,signed_pc_relative,branch_if),
defopcode(branch-eq,176,signed_pc_relative,needs_stack|branch_if_not),
defopcode(branch-not-eq,177,signed_pc_relative,needs_stack|branch_if),
defopcode(branch-atom,200,signed_pc_relative,branch_if_not),
defopcode(branch-not-atom,201,signed_pc_relative,branch_if),
defopcode(branch-endp,202,signed_pc_relative,branch_if),
defopcode(branch-not-endp,203,signed_pc_relative,branch_if_not),
defopcode(long-branch,167,constant_pc_relative,stop_ifu),
defopcode(long-branch-immed,157,unsigned_immediate_operand,stop_ifu|operand_long_branch_low_byte),
defopcode(error-if-true,1162,no_operand,needs_stack),
defopcode(error-if-false,1163,no_operand,needs_stack),
defopcode(catch-open-ignore,170,unsigned_pc_relative,needs_stack),
defopcode(catch-open-stack,171,unsigned_pc_relative,needs_stack),
defopcode(catch-open-return,172,unsigned_pc_relative,needs_stack),
defopcode(catch-open-multiple,173,unsigned_pc_relative,needs_stack),
defopcode(unwind-protect-open,174,unsigned_pc_relative,0),
defopcode(catch-close,175,unsigned_immediate_operand,0),
defopcode(catch-close_multiple,1170,no_operand,0),
defopcode(call-0-ignore,300,indirect_operand,stop_ifu),
defopcode(call-0-stack,301,indirect_operand,stop_ifu),
defopcode(call-0-return,302,indirect_operand,stop_ifu),
defopcode(call-0-multiple,303,indirect_operand,stop_ifu),
defopcode(call-1-ignore,304,indirect_operand,stop_ifu),
defopcode(call-1-stack,305,indirect_operand,stop_ifu),
defopcode(call-1-return,306,indirect_operand,stop_ifu),
defopcode(call-1-multiple,307,indirect_operand,stop_ifu),
defopcode(call-2-ignore,310,indirect_operand,stop_ifu),
defopcode(call-2-stack,311,indirect_operand,stop_ifu),
defopcode(call-2-return,312,indirect_operand,stop_ifu),
defopcode(call-2-multiple,313,indirect_operand,stop_ifu),
defopcode(call-3-ignore,314,indirect_operand,stop_ifu),
defopcode(call-3-stack,315,indirect_operand,stop_ifu),
defopcode(call-3-return,316,indirect_operand,stop_ifu),
defopcode(call-3-multiple,317,indirect_operand,stop_ifu),
defopcode(call-4-ignore,320,indirect_operand,stop_ifu),
defopcode(call-4-stack,321,indirect_operand,stop_ifu),
defopcode(call-4-return,322,indirect_operand,stop_ifu),
defopcode(call-4-multiple,323,indirect_operand,stop_ifu),
defopcode(call-n-ignore,324,indirect_operand,needs_stack|stop_ifu),
defopcode(call-n-stack,325,indirect_operand,needs_stack|stop_ifu),
defopcode(call-n-return,326,indirect_operand,needs_stack|stop_ifu),
defopcode(call-n-multiple,327,indirect_operand,needs_stack|stop_ifu),
defopcode(funcall-0-ignore,1300,no_operand,0),
defopcode(funcall-0-stack,1301,no_operand,0),
defopcode(funcall-0-return,1302,no_operand,0),
defopcode(funcall-0-multiple,1303,no_operand,0),
defopcode(funcall-1-ignore,1304,no_operand,0),
defopcode(funcall-1-stack,1305,no_operand,0),
defopcode(funcall-1-return,1306,no_operand,0),
defopcode(funcall-1-multiple,1307,no_operand,0),
defopcode(funcall-2-ignore,1310,no_operand,0),
defopcode(funcall-2-stack,1311,no_operand,0),
defopcode(funcall-2-return,1312,no_operand,0),
defopcode(funcall-2-multiple,1313,no_operand,0),
defopcode(funcall-3-ignore,1314,no_operand,0),
defopcode(funcall-3-stack,1315,no_operand,0),
defopcode(funcall-3-return,1316,no_operand,0),
defopcode(funcall-3-multiple,1317,no_operand,0),
defopcode(funcall-4-ignore,1320,no_operand,0),
defopcode(funcall-4-stack,1321,no_operand,0),
defopcode(funcall-4-return,1322,no_operand,0),
defopcode(funcall-4-multiple,1323,no_operand,0),
defopcode(funcall-n-ignore,1324,no_operand,needs_stack),
defopcode(funcall-n-stack,1325,no_operand,needs_stack),
defopcode(funcall-n-return,1326,no_operand,needs_stack),
defopcode(funcall-n-multiple,1327,no_operand,needs_stack),
defopcode(funcall-ni-ignore,330,unsigned_immediate_operand,stop_ifu),
defopcode(funcall-ni-stack,331,unsigned_immediate_operand,stop_ifu),
defopcode(funcall-ni-return,332,unsigned_immediate_operand,stop_ifu),
defopcode(funcall-ni-multiple,333,unsigned_immediate_operand,stop_ifu),
defopcode(lexpr-funcall-ignore,334,unsigned_immediate_operand,stop_ifu),
defopcode(lexpr-funcall-stack,335,unsigned_immediate_operand,stop_ifu),
defopcode(lexpr-funcall-return,336,unsigned_immediate_operand,stop_ifu),
defopcode(lexpr-funcall-multiple,337,unsigned_immediate_operand,stop_ifu),
defopcode(lexpr-funcall-n-ignore,1330,no_operand,needs_stack),
defopcode(lexpr-funcall-n-stack,1331,no_operand,needs_stack),
defopcode(lexpr-funcall-n-return,1332,no_operand,needs_stack),
defopcode(lexpr-funcall-n-multiple,1333,no_operand,needs_stack),
defopcode(call-quick-external,370,quick_external_call,stop_ifu),
defopcode(return-n,371,unsigned_immediate_operand,stop_ifu),
defopcode(return-stack,1370,no_operand,needs_stack),
defopcode(return-multiple,1371,no_operand,0),
defopcode(return-nil,1374,no_operand,0),
defopcode(call-quick-internal,372,unsigned_pc_relative,stop_ifu),
defopcode(call-quick-internal_long,373,constant_operand,stop_ifu),
defopcode(popj,1372,no_operand,0),
defopcode(popj-n,374,unsigned_immediate_operand,stop_ifu),
defopcode(popj-multiple,1373,no_operand,needs_stack),
defopcode(%dispatch-elt,375,unsigned_immediate_operand,needs_stack),
defopcode(eq,1200,no_operand,needs_stack),
defopcode(eql,1201,no_operand,needs_stack),
defopcode(not,1202,no_operand,0),
defopcode(zerop,1203,no_operand,needs_stack),
defopcode(plusp,1204,no_operand,needs_stack),
defopcode(minusp,1205,no_operand,needs_stack),
defopcode(lessp,1206,no_operand,needs_stack),
defopcode(greaterp,1207,no_operand,needs_stack),
defopcode(equal-number,1210,no_operand,needs_stack),
defopcode(atom,1211,no_operand,0),
defopcode(fixp,1212,no_operand,0),
defopcode(single-float-p,1213,no_operand,0),
defopcode(numberp,1214,no_operand,0),
defopcode(symbolp,1215,no_operand,0),
defopcode(arrayp,1216,no_operand,0),
defopcode(cl-listp,1217,no_operand,0),
defopcode(endp,1220,no_operand,0),
defopcode(double-float-p,1221,no_operand,0),
defopcode(floatp,1222,no_operand,0),
defopcode(char-equal,1223,no_operand,needs_stack),
defopcode(char=,1224,no_operand,needs_stack),
defopcode(add-stack,1240,no_operand,needs_stack),
defopcode(add-local,240,address_operand,needs_stack),
defopcode(add-immed,241,signed_immediate_operand,0),
defopcode(sub-stack,1241,no_operand,needs_stack),
defopcode(sub-local,242,address_operand,needs_stack),
defopcode(sub-immed,243,signed_immediate_operand,0),
defopcode(unary-minus,1242,no_operand,0),
defopcode(logand-stack,1243,no_operand,needs_stack),
defopcode(logior-stack,1244,no_operand,needs_stack),
defopcode(logxor-stack,1245,no_operand,needs_stack),
defopcode(multiply-stack,1246,no_operand,needs_stack),
defopcode(multiply-immed,244,unsigned_immediate_operand,0),
defopcode(quotient-stack,1263,no_operand,needs_stack),
defopcode(remainder-stack,1264,no_operand,needs_stack),
defopcode(rational-quotient-stack,1265,no_operand,needs_stack),
defopcode(mod-stack,1266,no_operand,needs_stack),
defopcode(increment-local,250,address_operand,tos_unchanged),
defopcode(decrement-local,251,address_operand,tos_unchanged),
defopcode(set-cdr-local,252,address_operand,tos_unchanged),
defopcode(floor-stack,1451,no_operand,needs_stack),
defopcode(truncate-stack,1452,no_operand,needs_stack),
defopcode(ceiling-stack,1453,no_operand,needs_stack),
defopcode(round-stack,1454,no_operand,needs_stack),
defopcode(ldb-immed,260,ten_bit_immediate_operand,operand_byte_pointer),
defopcode(dpb-immed,264,ten_bit_immediate_operand,needs_stack|operand_byte_pointer),
defopcode(lsh-stack,1260,no_operand,needs_stack),
defopcode(rot-stack,1261,no_operand,needs_stack),
defopcode(ash-stack,1262,no_operand,needs_stack),
defopcode(sign-extend-8,1442,no_operand,0),
defopcode(sign-extend-16,1443,no_operand,0),
defopcode(%numeric-dispatch-index,1347,no_operand,0),
defopcode(%32-bit-plus,1440,no_operand,needs_stack),
defopcode(%32-bit-difference,1441,no_operand,needs_stack),
defopcode(%add-bignum-step,1444,no_operand,needs_stack),
defopcode(%sub-bignum-step,1445,no_operand,needs_stack),
defopcode(%lshc-bignum-step,1446,no_operand,needs_stack),
defopcode(%multiply-bignum-step,1447,no_operand,needs_stack),
defopcode(%divide-bignum-step,1450,no_operand,needs_stack),
defopcode(%convert-single-to-double,1060,no_operand,needs_stack),
defopcode(%convert-double-to-single,1061,no_operand,0),
defopcode(%convert-double-to-fixnum,1062,no_operand,0),
defopcode(%convert-fixnum-to-double,1063,no_operand,needs_stack),
defopcode(%convert-single-to-fixnum,1064,no_operand,0),
defopcode(float,1065,no_operand,needs_stack),
defopcode(%double-floating-compare,1067,no_operand,0),
defopcode(%double-floating-add,1070,no_operand,0),
defopcode(%double-floating-sub,1071,no_operand,0),
defopcode(%double-floating-multiply,1072,no_operand,0),
defopcode(%double-floating-divide,1073,no_operand,0),
defopcode(%double-floating-abs,1074,no_operand,0),
defopcode(%double-floating-minus,1075,no_operand,0),
defopcode(%double-floating-scale,1076,no_operand,0),
defopcode(car,1100,no_operand,0),
defopcode(cdr,1101,no_operand,0),
defopcode(rplaca,1102,no_operand,smashes_stack),
defopcode(rplacd,1103,no_operand,smashes_stack),
defopcode(set,1104,no_operand,0),
defopcode(symeval,1105,no_operand,0),
defopcode(fsymeval,1106,no_operand,0),
defopcode(boundp,1107,no_operand,0),
defopcode(fboundp,1110,no_operand,0),
defopcode(location-boundp,1375,no_operand,0),
defopcode(get-pname,1111,no_operand,0),
defopcode(value-cell-location,1112,no_operand,0),
defopcode(function-cell-location,1113,no_operand,0),
defopcode(property-cell-location,1114,no_operand,0),
defopcode(package_cell_location,1115,no_operand,0),
defopcode(assq,1116,no_operand,needs_stack),
defopcode(memq,1117,no_operand,needs_stack),
defopcode(get,1121,no_operand,needs_stack),
defopcode(cons,1122,no_operand,0),
defopcode(ncons,1123,no_operand,0),
defopcode(getf-internal,1232,no_operand,0),
defopcode(member-fast,1236,no_operand,needs_stack),
defopcode(assoc-fast,1237,no_operand,needs_stack),
defopcode(last,1376,no_operand,0),
defopcode(length-internal,1377,no_operand,0),
defopcode(cl-length-internal,1346,no_operand,0),
defopcode(vector-length,1345,no_operand,0),
defopcode(float-operating-mode,1124,no_operand,0),
defopcode(set-float-operating-mode,1125,no_operand,smashes_stack),
defopcode(float-operation-status,1126,no_operand,0),
defopcode(set-float-operation-status,1127,no_operand,smashes_stack),
defopcode(ftn-ar-1,1144,no_operand,needs_stack),
defopcode(ftn-as-1,1145,no_operand,needs_stack|smashes_stack),
defopcode(ftn-ap-1,1146,no_operand,needs_stack),
defopcode(ftn-load-array-register,1147,no_operand,0),
defopcode(ftn-double-ar-1,1150,no_operand,needs_stack),
defopcode(ftn-double-as-1,1151,no_operand,needs_stack|smashes_stack),
defopcode(ar-1,1270,no_operand,needs_stack),
defopcode(ar-1-immed,270,unsigned_immediate_operand,0),
defopcode(ar-1-local,271,address_operand,0),
defopcode(as-1,1271,no_operand,needs_stack|smashes_stack),
defopcode(as-1-immed,272,unsigned_immediate_operand,smashes_stack),
defopcode(as-1-local,273,address_operand,smashes_stack),
defopcode(array-leader-immed,274,unsigned_immediate_operand,0),
defopcode(array-leader,1272,no_operand,needs_stack),
defopcode(store-array-leader,1273,no_operand,needs_stack|smashes_stack),
defopcode(store-array-leader-immed,275,unsigned_immediate_operand,smashes_stack),
defopcode(%1d-aref,1274,no_operand,needs_stack),
defopcode(%1d-aset,1275,no_operand,needs_stack|smashes_stack),
defopcode(%1d-aloc,1276,no_operand,needs_stack),
defopcode(ap-1,1277,no_operand,needs_stack),
defopcode(ap-leader,1250,no_operand,needs_stack),
defopcode(ar-2,1251,no_operand,0),
defopcode(as-2,1252,no_operand,smashes_stack),
defopcode(ap-2,1253,no_operand,0),
defopcode(array-register_event,1254,no_operand,tos_unchanged),
defopcode(setup-1d-array,1255,no_operand,smashes_stack),
defopcode(setup-force_1d_array,1256,no_operand,smashes_stack),
defopcode(setup-1d_array_sequential,1257,no_operand,0),
defopcode(setup-force_1d_array_sequential,1267,no_operand,0),
defopcode(fast-aref,276,address_operand,needs_stack),
defopcode(fast-aset,277,address_operand,needs_stack|smashes_stack),
defopcode(octet-aref_8,1152,no_operand,needs_stack),
defopcode(octet-aref_16,1153,no_operand,needs_stack),
defopcode(octet_aref,1154,no_operand,needs_stack),
defopcode(octet_aset_8,1155,no_operand,needs_stack|smashes_stack),
defopcode(octet_aset_16,1156,no_operand,needs_stack|smashes_stack),
defopcode(octet_aset,1157,no_operand,needs_stack|smashes_stack),
defopcode(%start,1133,no_operand,0),
defopcode(%halt,1000,no_operand,tos_unchanged),
defopcode(%multiply_double,1001,no_operand,needs_stack),
defopcode(%data_type,1002,no_operand,0),
defopcode(%pointer,1003,no_operand,needs_stack),
defopcode(%fixnum,1004,no_operand,needs_stack),
defopcode(%flonum,1005,no_operand,needs_stack),
defopcode(%make-pointer,1006,no_operand,0),
defopcode(%trap_on-instance,1131,no_operand,0),
defopcode(%make-pointer-immed,2,unsigned_immediate_operand,operand_data_type),
defopcode(%make-pointer-immed-offset,3,unsigned_immediate_operand,operand_data_type),
defopcode(%pointer_difference,1007,no_operand,needs_stack),
defopcode(%p-store_contents,1010,no_operand,0),
defopcode(%p-store_tag-and-pointer,1011,no_operand,needs_stack|smashes_stack),
defopcode(%p-contents_as_locative,1012,no_operand,needs_stack),
defopcode(%p-structure_offset,1013,no_operand,0),
defopcode(%p-ldb-immed,10,ten_bit_immediate_operand,needs_stack|operand_byte_pointer),
defopcode(%p-tag-ldb-immed,4,unsigned_immediate_operand,needs_stack|operand_byte_pointer),
defopcode(%p-dpb-immed,14,ten_bit_immediate_operand,needs_stack|operand_byte_pointer),
defopcode(%p-tag-dpb-immed,5,unsigned_immediate_operand,needs_stack|operand_byte_pointer),
defopcode(char-ldb-immed,20,ten_bit_immediate_operand,operand_byte_pointer),
defopcode(%microsecond-clock,1014,no_operand,0),
defopcode(%stack-group-switch,1015,no_operand,needs_stack),
defopcode(%p-store-cdr-and-contents,1016,no_operand,smashes_stack),
defopcode(follow-structure_forwarding,1017,no_operand,0),
defopcode(follow-cell-forwarding,1020,no_operand,0),
defopcode(%unsynchronized-device-read,1021,no_operand,0),
defopcode(%block-store-cdr-and-contents,1022,no_operand,needs_stack|smashes_stack),
defopcode(%block-store-tag-and-pointer,1023,no_operand,needs_stack|smashes_stack),
defopcode(%block-search-eq-internal,1132,no_operand,needs_stack),
defopcode(%p-contents-increment-pointer,24,address_operand,0),
defopcode(%p-store-contents-increment_pointer,25,address_operand,0),
defopcode(%p-contents-pointer-decrement,26,address_operand,0),
defopcode(%p-store-contents-pointer-decrement,27,address_operand,smashes_stack),
defopcode(%io-read-until-bit-test,30,address_operand,needs_stack),
defopcode(%io-read-while-bit-test,31,address_operand,needs_stack),
defopcode(%io-read,32,address_operand,0),
defopcode(%io-write,33,address_operand,smashes_stack),
defopcode(store-conditional,1025,no_operand,needs_stack),
defopcode(%bitblt-short-row,1350,no_operand,tos_unchanged),
defopcode(%bitblt-long-row,1351,no_operand,tos_unchanged),
defopcode(%bitblt-long-row-backwards,1352,no_operand,tos_unchanged),
defopcode(%bitblt-decode-arrays,1353,no_operand,0),
defopcode(push-microcode-escape-constant,6,unsigned_immediate_operand,0),
defopcode(funcall-microcode_escape_constant,7,unsigned_immediate_operand,0),
defopcode(restart-trapped-call,1360,no_operand,0),
defopcode(un-lexpr-funcall,1361,no_operand,0),
defopcode(stack-dump,1362,no_operand,0),
defopcode(stack-load,1363,no_operand,0),
defopcode(%assure-pdl-room,1367,no_operand,needs_stack|smashes_stack),
defopcode(%resume-main-stack-buffer,1364,no_operand,0),
defopcode(%funcall-in-auxiliary-stack-buffer,1365,no_operand,needs_stack),
defopcode(%audio-start,1354,no_operand,needs_stack),
defopcode(%fep-doorbell,1355,no_operand,tos_unchanged),
defopcode(%disk-start,1356,no_operand,tos_unchanged),
defopcode(%net-wakeup,1357,no_operand,tos_unchanged),
defopcode(%set-ethernet_address,1337,no_operand,smashes_stack),
defopcode(%tape-wakeup,1366,no_operand,tos_unchanged),
defopcode(%read-scc_register,1412,no_operand,0),
defopcode(%write-scc_register,1413,no_operand,0),
defopcode(%map-cache_write,1030,no_operand,smashes_stack),
defopcode(%phtc-read,1031,no_operand,0),
defopcode(%phtc-write,1032,no_operand,smashes_stack),
defopcode(%phtc_setup,1033,no_operand,needs_stack|smashes_stack),
defopcode(%reference_tag_read,1034,no_operand,0),
defopcode(%reference_tag_write,1035,no_operand,smashes_stack),
defopcode(%scan-reference_tags,1036,no_operand,needs_stack),
defopcode(%gc_tag_read,1037,no_operand,0),
defopcode(%gc_tag_write,1040,no_operand,smashes_stack),
defopcode(%scan-gc_tags,1041,no_operand,needs_stack),
defopcode(%gc_map_write,1042,no_operand,needs_stack|smashes_stack),
defopcode(%meter_on,1043,no_operand,tos_unchanged),
defopcode(%meter_off,1044,no_operand,tos_unchanged),
defopcode(%block_gc_copy,1045,no_operand,smashes_stack),
defopcode(%block_transport,1046,no_operand,needs_stack),
defopcode(%scan-for-oldspace,1047,no_operand,needs_stack),
defopcode(%clear_caches,1050,no_operand,tos_unchanged),
defopcode(%physical_address_cache,1051,no_operand,0),
defopcode(%set_preempt_pending,1052,no_operand,tos_unchanged),
defopcode(%check_preempt_pending,1053,no_operand,tos_unchanged),
defopcode(%scan-for-ephemeral_space,1027,no_operand,needs_stack),
defopcode(%ephemeralp,1024,no_operand,0),
defopcode(%clear_instruction-cache,1026,no_operand,tos_unchanged),
defopcode(%scan-for-ecc_error,1130,no_operand,needs_stack),
defopcode(%frame_consing_done,1066,no_operand,tos_unchanged),
defopcode(%allocate-list-block,1054,no_operand,needs_stack),
defopcode(%allocate-structure-block,1055,no_operand,needs_stack),
defopcode(%allocate-list_transport-block,1056,no_operand,needs_stack),
defopcode(%allocate-structure-transport-block,1057,no_operand,needs_stack),
defopcode(%fetch-freevar-n,400,unsigned_immediate_operand,operand_lexical_variable),
defopcode(%fetch-freevar-0,401,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-1,402,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-2,403,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-3,404,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-4,405,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-5,406,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-6,407,address_operand,operand_lexical_variable),
defopcode(%fetch-freevar-7,410,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-n,411,unsigned_immediate_operand,operand_lexical_variable),
defopcode(%pop-freevar-0,412,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-1,413,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-2,414,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-3,415,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-4,416,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-5,417,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-6,420,address_operand,operand_lexical_variable),
defopcode(%pop-freevar-7,421,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-n,422,unsigned_immediate_operand,operand_lexical_variable),
defopcode(%movem-freevar-0,423,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-1,424,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-2,425,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-3,426,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-4,427,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-5,430,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-6,431,address_operand,operand_lexical_variable),
defopcode(%movem-freevar-7,432,address_operand,operand_lexical_variable),
defopcode(array_length,1225,no_operand,0),
defopcode(array_active_length,1226,no_operand,0),
defopcode(stringp,1227,no_operand,0),
defopcode(%draw_line_loop,1400,no_operand,tos_unchanged),
defopcode(%draw_string_step,433,address_operand,0),
defopcode(%draw_triangle_segment,1405,no_operand,tos_unchanged),
defopcode(%bitblt_short,1406,no_operand,tos_unchanged),
defopcode(%bitblt_long,1407,no_operand,tos_unchanged),
defopcode(soft_matte_decode_arrays,1430,no_operand,0),
defopcode(soft_matte_internal,1431,no_operand,tos_unchanged),
defopcode(%block_checksum_copy,1233,no_operand,smashes_stack),
defopcode(%block_32_36_checksum_copy,1234,no_operand,smashes_stack),
defopcode(%block_36_32_checksum_copy,1235,no_operand,smashes_stack),
defopcode(%leave_unwind_protect,1411,no_operand,0),
defopcode(%set_cdr_code_1,253,address_operand,0),
defopcode(%set_cdr_code_2,254,address_operand,0),
defopcode(proceed,1600,no_operand,0),
defopcode(assure_prolog_frame_room,600,unsigned_immediate_operand,needs_stack),
defopcode(push-choice_pointer,1601,no_operand,0),	
defopcode(cut,1602,no_operand,needs_stack),	
defopcode(neck_cut,1603,no_operand,smashes_stack),
defopcode(fail,1604,no_operand,0),
defopcode(fail_if_false,1605,no_operand,0),
defopcode(fail_if-true,1606,no_operand,0),
defopcode(%restart-trapped-fail,1611,no_operand,0),
defopcode(%prolog_meter_on,1626,no_operand,tos_unchanged),
defopcode(%prolog_meter_off,1627,no_operand,tos_unchanged),
defopcode(push-goal,601,indirect_operand,0),
defopcode(execute-goal,607,indirect_operand,0),
defopcode(execute-stack,1607,no_operand,0),
defopcode(dereference-local,610,address_operand,0),
defopcode(dereference-stack,1610,no_operand,0),
defopcode(globalize-var,611,unsigned_immediate_operand,0),
defopcode(globalize-var-for-neck-cut,615,unsigned_immediate_operand,0),
defopcode(push-var,612,address_operand,0),
defopcode(push-void,1612,no_operand,0),
defopcode(push-list,613,unsigned_immediate_operand,operand_push_list_counts),
defopcode(push-list-star,614,unsigned_immediate_operand,operand_push_list_counts),
defopcode(unify-nil,1620,no_operand,smashes_stack),
defopcode(unify-constant,620,constant_operand,smashes_stack),
defopcode(unify-immediate,621,signed_immediate_operand,smashes_stack),
defopcode(unify-local,622,address_operand,smashes_stack),
defopcode(unify-list,623,unsigned_immediate_operand,0),
defopcode(unify-list-star,624,unsigned_immediate_operand,0),
defopcode(unify-list-star-1,1624,no_operand,0),
{ 0, 0, 0 }
};

int opcode_setup;
struct opcode_s *opcode_ptr[1024];

void
disassemble36_setup(void)
{
	int i, j;

	for (i = 0; opcodes[i].name; i++) {
		int v;

		v = opcodes[i].value;

		opcode_ptr[v] = &opcodes[i];

		if (opcodes[i].format == ten_bit_immediate_operand) {
			for (j = 1; j < 4; j++) {
				opcode_ptr[v+j] = &opcodes[i];
			}
		}
	}

	opcode_setup = 1;
}

static char *data_types[] = {
	"dtp-null", "dtp-nil", "dtp-symbol", "dtp-extended-number",
	"dtp-external-value-cell-pointer", "dtp-locative",
	"dtp-list", "dtp-compiled-function",
	"dtp-array", "dtp-closure", "dtp-entity", "dtp-lexical-closure",
	"dtp-select-method", "dtp-instance", "dtp-header-p", "dtp-header-i",
	"dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix",
	"dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix", "dtp-fix",
	"dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float",
	"dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float", "dtp-float",
	"dtp-float", "dtp-float",
	"dtp-even-pc", "dtp-gc-forward", "dtp-one-q-forward", "dtp-header-forward",
	"dtp-body-forward", "dtp-66", "dtp-66", "dtp-67",
	"dtp-odd-pc", "dtp-71", "dtp-72", "dtp-73",
	"dtp-74", "dtp-75", "dtp-76", "dtp-77"
};

static char *cdr_codes[] = {
	"cdr-next", "cdr-nil", "cdr-normal", "cdr-spare"
};

static void
printf_soctal(char *str, int o)
{
	if (str && str[0])
		printf("%s", str);

	if (o & 0x8000000) {
		printf("-%o", -o);
	} else {
		printf("%o", o);
	}
}

void
disassemble36(int inst)
{
	int uop, i;
	struct opcode_s *op;
	int si, operand;
	unsigned ui, ao, wo;

	if (!opcode_setup) {
		disassemble36_setup();
	}

	if ((inst & 0xff) == 0xff)
		uop = 01000 + ((inst >> 8) & 0x1ff);
//		uop = 01000 + ((inst >> 8) & 0x0ff);
	else
//		uop = (inst & 0xff) | ((inst & 0x10000) ? 0x100 : 0);
		uop = (inst & 0xff);

	operand = (inst >> 8) & 0xff;

#if 0
	op = 0;
	for (i = 0; opcodes[i].name; i++) {
		if (uop == opcodes[i].value) {
			op = &opcodes[i];
			break;
		}
	}
#else
	op = opcode_ptr[uop];
#endif

	if (op && op->name) {
		printf("op %4o %s ", uop, op->name);
	} else {
		printf("op %4o unknown\n", uop);
		return;
	}

	switch (op->format) {
	case unsigned_immediate_operand:
		ui = operand;
		if (op->attributes & operand_data_type) {
			if (ui >= 0 && ui <= 077)
				printf("%s", data_types[ui]);
			else
				printf("dtp-%d", ui);

		} else {
			printf("%o", ui);
		}
		break;
	case signed_immediate_operand:
		si = operand;
		if (operand & 0x80)
			si |= 0xffffff00;
		printf_soctal("", si);
		break;
	case ten_bit_immediate_operand:
		operand |= inst & 0x300;
		printf("%o", operand);
		break;
	case address_operand:
		ao = operand & 0x7f;
		/* FP or SP */
		if (operand & 0x80) { 
			printf("SP %d", (0xffffff80 | ao) + 1);
		} else {
			/* fast-aref or fast-aset */
			if (uop == 0276 || uop == 0277) {
				/* cca-arg-name */
			}
			printf("FP %d", ao);
		}
		break;

	case no_operand:
		break;

	case quick_external_call:
		break;

	case constant_operand:
	case indirect_operand:
		printf("0%o", operand);
		break;

	case lexical_operand:
	case microcode_operand:
		break;

	case unsigned_pc_relative:
		wo = operand;
		printf("PC 0%o", wo);
		break;

	case signed_pc_relative:
		if (operand & 0x80)
			wo = operand | 0xffffff00;
		else
			wo = operand - 1;
		printf_soctal("PC ", wo);
		break;

	case constant_pc_relative:
		break;
	}

	printf("\n");
}

