;;;-*- Mode:LISP; Package:SYSTEM-INTERNALS -*-
;;; Site declaration for MIT
;;; ** (c) Copyright 1981 Massachusetts Institute of Technology **

(DEFCONST ITS-LOGICAL-PATHNAME-TRANSLATIONS
  '(("CC" "LMCONS;")
    ("CHAOS" "SYSENG;")
    ("DEMO" "LMDEMO;")
    ("FILE" "LMFS;")
    ("FONTS" "LMFONT;")
    ("IO" "LMIO;")
    ("IO1" "LMIO1;")
    ("PATCH" "LMPAT;")
    ("PRESS-FONTS" "FONTS;")
    ("SYS" "LISPM;")
    ("SYS2" "LISPM2;")
    ("UBIN" "LISPM1;")
    ("UCADR" "LCADR;")
    ("WINDOW" "LMWIN;")
    ("ZMAIL" "ZMAIL;")
    ("ZWEI" "ZWEI;")
    ))

(DEFSITE :MIT
  ;; AI is where the sources are
  (:SYS-HOST "AI")
  ;; SYS: translations to use
  (:SYS-DIRECTORY-TRANSLATIONS ITS-LOGICAL-PATHNAME-TRANSLATIONS)
  ;; Has a local chaosnet
  (:CHAOS T)
  ;; But no (working) ethernet
  (:ETHER NIL)
  ;; File computers using the chaosnet file server protocol
  (:CHAOS-FILE-SERVER-HOSTS '("AI" "MC" "XX" "SPEECH" "EE"))
  ;; Hosts suspected of supporting time servers
  (:CHAOS-TIME-SERVER-HOSTS '("MC" "AI" "XX" "EE" "VX"))
  ;; EST
  (:TIMEZONE 5)
  ;; Destination for mail to BUG-FOOBAR
  (:HOST-FOR-BUG-REPORTS "MIT-AI")
  ;; "Local sites", used by ZMail summary display
  (:LOCAL-MAIL-HOSTS '("AI" "MC" "ML" "MIT-AI" "MIT-MC" "MIT-ML"))
  ;; Mail can be sent by COMSAT
  (:COMSAT T)
  ;; And that is the default
  (:DEFAULT-MAIL-MODE ':COMSAT)
  ;; There is a GMSGS server for collection system messages
  (:GMSGS T)
  ;; For finger and supdup
  (:ARPA-GATEWAYS '("AI" "MC"))
  ;; Has a Dover
  (:DOVER T)
  ;; And an XGP
  (:XGP T)
  ;; And the dover is the default
  (:DEFAULT-HARDCOPY-MODE ':DOVER)
  ;; But not for ESC Q
  (:HARDCOPY-SCREEN-MODE ':XGP)
  ;; Interpretation of arguments to ESC F
  (:ESC-F-ARG-ALIST '((NIL . :LOGIN) (1 . :LISP-MACHINES)
		      (2 "AI") (3 "MC") (4 "AI" "MC")
		      (0 . :READ)))
  )
