;-*-Mode:Midas-*-

(SETQ UC-ARRAY '(
;;; ARRAYS

;GENERAL ON ARRAY REFERENCING--
; CODE TO DEAL WITH NON-DISPLACED ARRAYS IS CODED OPEN, WHILE THAT TO
;DEAL WITH DISPLACED ARRAYS IS IN DSP-ARRAY-SETUP.  SINCE THE DISPLACED 
;CASE EVENTUALLY DROPS INTO THE NORMAL CASE, CERTAIN CONVENTIONS ARE NECESSARY.
; THE NORMAL SEQUENCE OF CODE IS
;      1: GET ARRAY-POINTER Q INTO M-A
;      2: CALL GAHD1 TO FETCH ARRAY-HEADER Q INTO M-B.  GAHD1 MAKES SURE IT
;	    IS THE RIGHT TYPE, ETC.  M-D GET NUMBER DIMENSIONS, M-E DATA ORIGIN,
;	    M-S DATA STORAGE LENGTH IN ELEMENTS (NOT QS).
;      3: GET ELEMENT NUMBER WANT TO REF IN M-Q.
;      4: DO (CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B DSP-ARRAY-SETUP)
;	    THIS WILL CHANGE M-E AND M-S, AND MAY CHANGE M-Q.
;	    DSP-ARRAY-SETUP IS TRANSPARENT TO M-A, M-B, AND M-D.
;	    DSP-ARRAY-SETUP KNOWS ABOUT INDIRECT ARRAYS, AND WILL FOLLOW
;		DISPLACED CHAINS, ETC.
;      5: BARF IF M-Q IS GREATER THAN OR EQUAL TO M-S (INDEX OUT OF BOUNDS).
;      6: DISPATCH ON ARRAY-TYPE TO APPROPRIATE REFERENCE ROUTINE.

;M-Q, M-S, M-D, M-E PURE (TYPE-LESS) NUMBERS

;NO SEQ BRKS ALLOWED ANYWHERE IN THIS CODE.  THIS (1) CAUSES STORES
;INTO BYTE ARRAYS TO NOT LOSE SIMULTANEOUS STORES INTO OTHER BYTES SAME WORD
;(2) PREVENTS LOSSAGE FROM ONE PROCESS *REARRAYING WHILE ANOTHER IS REFERENCING
;(3) ALLOWS TWO PROCESSES TO CALL ARRAY-PUSH WITH NO TIMING ERRORS

;THE FOLLOWING REGISTERS MUST BE PRESERVED THROUGH ARRAY REFERENCING,
;FOR THE SAKE OF BITBLT: M-C, M-I, M-K, M-ZR
;VARIOUS ROUTINES ALSO RELY ON M-E, M-Q, M-S, M-B BEING LEFT ALONE
;UPON RETURN FROM THE ARRAY-TYPE-REF-DISPATCH.

;Actual one-dimensional array access instructions.
;These are an exception to the above rules.  For speed, GAHD1 is not used.
;Instead, ARRAY-DECODE-1 checks quickly for the normal case
;rather than checking for each unusual case one at a time.

    (ERROR-TABLE RESTART XAR-1)
XAR-1 (MISC-INST-ENTRY AR-1)
XAR-1-NONCACHED
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XAR-1)
	(CALL-XCT-NEXT ARRAY-DECODE-1)
       ((M-Q) Q-POINTER PDL-POP)
;; Actually get an element of an array.
;; This code is used for arrays of all numbers of dimensions,
;; with the cumulative subscript in M-Q.
XAR-1-X
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A)
	(DISPATCH-CALL-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-REF-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       (NO-OP)
	(POPJ)

;Most SUBSCRIPT-OOB errors are restarted with a pushj to this.
XAREF-RECHECK-INDEX (ERROR-TABLE RESTART XAREF-RECHECK-INDEX)
	(POPJ-XCT-NEXT)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

    (ERROR-TABLE RESTART XAS-1)
XAS-1 (MISC-INST-ENTRY AS-1)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XAS-1)
	(CALL-XCT-NEXT ARRAY-DECODE-1)
       ((M-Q) Q-POINTER PDL-POP)
XAS-1-X
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A)
	(DISPATCH-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-STORE-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       ((M-T) Q-TYPED-POINTER PDL-POP)

    (ERROR-TABLE RESTART XAP-1)
XAP-1 (MISC-INST-ENTRY AP-1)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XAP-1)
	(CALL-XCT-NEXT ARRAY-DECODE-1)
       ((M-Q) Q-POINTER PDL-POP)
XAP-1-X
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A)
	(DISPATCH (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B SKIP-IF-NUMERIC-ARRAY)
	 (JUMP XAP-1-A)
	(CALL TRAP)
    (ERROR-TABLE NUMBER-ARRAY-NOT-ALLOWED M-A)
XAP-1-A
	(POPJ-AFTER-NEXT
	 (M-T) ADD M-E A-Q)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

;Misc insns opcodes 0-17 do AR-1, 20-37 do ARRAY-LEADER, 40-57 do %INSTANCE-REF.
;Misc insns opcodes 100-17 do AR-1, 120-37 do ARRAY-LEADER, 140-57 do %INSTANCE-REF.
AREFI	((M-C) M-INST-ADR)
	(DISPATCH-XCT-NEXT (BYTE-FIELD 2 4) M-C D-AREFI)
       ((M-A) Q-TYPED-POINTER PDL-POP)

(LOCALITY D-MEM)
(START-DISPATCH 2 0)
D-AREFI
	(AREFI-ARRAY)
	(AREFI-ARRAY-LEADER)
	(AREFI-INSTANCE)
	(TRAP)
(END-DISPATCH)
(LOCALITY I-MEM)

AREFI-ARRAY-LEADER
	(CALL GAHDR)
	(CALL-XCT-NEXT XFLAD1-RESTART-1)
       ((M-Q) (BYTE-FIELD 4 0) M-C)
	(JUMP-IF-BIT-SET-XCT-NEXT (BYTE-FIELD 1 6) M-C XSALDR-AREFI)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC AREFI-RETURN)))
	(JUMP XFALDR-AREFI)

;Handles both reading and setting.
AREFI-INSTANCE
	((M-1) LDB (BYTE-FIELD 4 0) M-C)
	((M-TEM) Q-DATA-TYPE M-A)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) TRAP)
		(ERROR-TABLE ARGTYP INSTANCE PP 0 XINSTANCE-LOC %INSTANCE-LOC)
	((VMA-START-READ) M-A)
	(CALL-XCT-NEXT XINSTANCE-LOC-1)
       ((M-1) ADD M-1 (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR-XCT-NEXT (BYTE-FIELD 1 6) M-C QCAR3)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC AREFI-RETURN)))
	((M-S) M-T)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QRAR4)
       ((M-A) M-T)

AREFI-ARRAY
	(CALL-XCT-NEXT ARRAY-DECODE-1-A)
       ((M-Q) LDB (BYTE-FIELD 4 0) M-C)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A)
	(JUMP-IF-BIT-SET (BYTE-FIELD 1 6) M-C AREFI-ASET)
	(DISPATCH-CALL-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-REF-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       (NO-OP)
AREFI-RETURN
	(DISPATCH M-INST-DEST QMDTBD)
       ((PDL-PUSH) DPB M-T Q-TYPED-POINTER (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))

AREFI-ASET
	(JUMP-XCT-NEXT AREFI-RETURN)
       (CALL XAS-1-X)

;Decode a one-dimensional array and a subscript,
; checking all errors except subscript data type.
;Expects subscript as typeless number in M-Q.
;Return the array in M-A, the address of its data in M-E,
;the subscript in M-Q, and the index length in M-S.
;The header is returned in M-B.
;Calling sequence is:
;	(CALL-XCT-NEXT ARRAY-DECODE-1)
;      ((M-Q) Q-POINTER PDL-POP)
;   (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S M-A)
ARRAY-DECODE-1
	((M-A) Q-TYPED-POINTER PDL-POP)
    (ERROR-TABLE RESTART ARRAY-DECODE-1-A)
ARRAY-DECODE-1-A
	((M-TEM) Q-DATA-TYPE M-A)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER))
		ARRAY-DECODE-WTA)
	((VMA-START-READ) Q-POINTER M-A)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER MD)
	((M-E) ADD VMA (A-CONSTANT 1))
ARRAY-DECODE-1-FORCE-1   ;Enter from ARRAY-DECODE-1-FORCE.
	((M-B) MD)
	((M-TEM) AND M-B (A-CONSTANT (PLUS (BYTE-VALUE %%ARRAY-LONG-LENGTH-FLAG 1)
					   (BYTE-VALUE %%ARRAY-DISPLACED-BIT 1)
					   (BYTE-VALUE %%ARRAY-NUMBER-DIMENSIONS 7777)
					   (BYTE-VALUE Q-DATA-TYPE 77777))))
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (PLUS (BYTE-VALUE %%ARRAY-NUMBER-DIMENSIONS 1)
						(BYTE-VALUE Q-DATA-TYPE DTP-ARRAY-HEADER)))
		ARRAY-DECODE-1-UNUSUAL)
	(POPJ-AFTER-NEXT
	 (M-S) (LISP-BYTE %%ARRAY-INDEX-LENGTH-IF-SHORT) M-B)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

;Handle wrong-type-arg errors on arrays passed to AR/S/P-n.
;Returns to caller with valid array pointer in M-A.
ARRAY-DECODE-WTA
	(POPJ-EQUAL M-TEM (A-CONSTANT (EVAL DTP-STACK-GROUP)))
	(CALL TRAP)
    (ERROR-TABLE ARGTYP ARRAY M-A 0 FALL-THROUGH AREF)
	((M-TEM) Q-DATA-TYPE M-A)
	(POPJ-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER)))
	(JUMP ARRAY-DECODE-WTA)

;Decode a one-dimensional array other than in the usual case.
;Either it is long, or displaced, or it has the wrong rank, or a bad data type.
ARRAY-DECODE-1-UNUSUAL
	;; First handle the ones that are just long.  That is most common case here.
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (PLUS (BYTE-VALUE %%ARRAY-NUMBER-DIMENSIONS 1)
						(BYTE-VALUE Q-DATA-TYPE DTP-ARRAY-HEADER)
						(BYTE-VALUE %%ARRAY-LONG-LENGTH-FLAG 1)))
		ARRAY-DECODE-1-WEIRD)
	;; Get the index length from its Q.
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	;; Also update address of start of data.
	((M-E) ADD M-E (A-CONSTANT 1))
	(POPJ-AFTER-NEXT
	 (M-S) Q-POINTER MD)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

;; Wrong rank, bad data type or displaced array.
ARRAY-DECODE-1-WEIRD
	((M-TEM) Q-DATA-TYPE MD)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-HEADER)) TRAP)
    (ERROR-TABLE DATA-TYPE-SCREWUP ARRAY)
	((M-S) (LISP-BYTE %%ARRAY-NUMBER-DIMENSIONS) MD)
	(CALL-NOT-EQUAL M-S (A-CONSTANT 1) TRAP)
    (ERROR-TABLE ARRAY-NUMBER-DIMENSIONS M-S 1 M-A ARRAY-DECODE-1-A)
	;; The only case left is a displaced array.
	;; This sets up M-S right, and doesn't depend on it.
	(CALL DSP-ARRAY-SETUP)
	(POPJ-XCT-NEXT)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

;; Instructions for caching decoding of arrays.

    (ERROR-TABLE RESTART XAR-1-CACHED-1)
XAR-1-CACHED-1 (MISC-INST-ENTRY AR-1-CACHED-1)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XAR-1-CACHED-1)
	((M-Q) Q-POINTER PDL-POP)
    (ERROR-TABLE RESTART XAR-1-CACHED-OOB-1)
	(JUMP-NOT-EQUAL PDL-TOP A-AR-1-ARRAY-POINTER-1 XAR-1-CACHE-INIT-1)
;; This array is the one most recently referenced.
;; Discard array pointer from pdl, at same time get saved array type in M-B.
	((M-B) SETA A-AR-1-ARRAY-HEADER-1 PDL-POP)
	(CALL-GREATER-OR-EQUAL M-Q A-AR-1-ARRAY-LENGTH-1 TRAP)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S XAR-1-CACHED-OOB-1 PP)
;; Reference the array, getting data addr in M-E.
	(DISPATCH-CALL-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-REF-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       ((M-E) A-AR-1-ARRAY-ADDRESS-1)
	(POPJ)

;; This array is not the last one referenced.
;; Decode it, and remember in case it is referenced again.
XAR-1-CACHE-INIT-1
	(CALL-XCT-NEXT ARRAY-DECODE-1-A)
       ((M-A) Q-TYPED-POINTER PDL-POP)
;; Must not record a displaced array, as for them the subscript
;; must be altered to do the access.
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B XAR-1-X)
	((A-AR-1-ARRAY-ADDRESS-1) M-E)
	((A-AR-1-ARRAY-POINTER-1) DPB M-A Q-TYPED-POINTER
	 (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	((A-AR-1-ARRAY-LENGTH-1) M-S)
	(JUMP-XCT-NEXT XAR-1-X)
       ((A-AR-1-ARRAY-HEADER-1) M-B)

    (ERROR-TABLE RESTART XAR-1-CACHED-2)
XAR-1-CACHED-2 (MISC-INST-ENTRY AR-1-CACHED-2)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XAR-1-CACHED-2)
	((M-Q) Q-POINTER PDL-POP)
    (ERROR-TABLE RESTART XAR-1-CACHED-OOB-2)
	(JUMP-NOT-EQUAL PDL-TOP A-AR-1-ARRAY-POINTER-2 XAR-1-CACHE-INIT-2)
;; This array is the one most recently referenced.
;; Discard array pointer from pdl, at same time get saved array type in M-B.
	((M-B) SETA A-AR-1-ARRAY-HEADER-2 PDL-POP)
	(CALL-GREATER-OR-EQUAL M-Q A-AR-1-ARRAY-LENGTH-2 TRAP)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S XAR-1-CACHED-OOB-2 PP)
;; Reference the array, getting data addr in M-E.
	(DISPATCH-CALL-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-REF-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       ((M-E) A-AR-1-ARRAY-ADDRESS-2)
	(POPJ)

;; This array is not the last one referenced.
;; Decode it, and remember in case it is referenced again.
XAR-1-CACHE-INIT-2
	(CALL-XCT-NEXT ARRAY-DECODE-1-A)
       ((M-A) Q-TYPED-POINTER PDL-POP)
;; Must not record a displaced array, as for them the subscript
;; must be altered to do the access.
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B XAR-1-X)
	((A-AR-1-ARRAY-ADDRESS-2) M-E)
	((A-AR-1-ARRAY-POINTER-2) DPB M-A Q-TYPED-POINTER
	 (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	((A-AR-1-ARRAY-LENGTH-2) M-S)
	(JUMP-XCT-NEXT XAR-1-X)
       ((A-AR-1-ARRAY-HEADER-2) M-B)

;Instructions that apply a single subscript to any array regardless of rank.

XAR-1-FORCE (MISC-INST-ENTRY AR-1-FORCE)
	(CALL ARRAY-DECODE-1-FORCE)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A 1)
	(JUMP XAR-1-X)

XAS-1-FORCE (MISC-INST-ENTRY AS-1-FORCE)
	(CALL ARRAY-DECODE-1-FORCE)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A 1)
	(JUMP XAS-1-X)

XAP-1-FORCE (MISC-INST-ENTRY AP-1-FORCE)
	(CALL ARRAY-DECODE-1-FORCE)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A 1)
	(JUMP XAP-1-X)

;Decode an array and subscript, treating it as one-dimensional regardless of rank.
    (ERROR-TABLE RESTART ARRAY-DECODE-1-FORCE)
ARRAY-DECODE-1-FORCE
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 ARRAY-DECODE-1-FORCE)
	((M-Q) Q-POINTER PDL-POP)
	((M-A) Q-TYPED-POINTER PDL-POP)
	((M-TEM) Q-DATA-TYPE M-A)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER))
		ARRAY-DECODE-WTA)
	((VMA-START-READ) Q-POINTER M-A)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER MD)
	((M-E) (LISP-BYTE %%ARRAY-NUMBER-DIMENSIONS) MD)
	((M-E) ADD VMA A-E)	
;Mung the data from the header to say "one dimensional" rather than the array's own rank.
	((MD) ANDCA MD (A-CONSTANT (BYTE-VALUE %%ARRAY-NUMBER-DIMENSIONS 7)))
	((MD) IOR MD (A-CONSTANT (BYTE-VALUE %%ARRAY-NUMBER-DIMENSIONS 1)))
	(JUMP ARRAY-DECODE-1-FORCE-1)

;Instructions that access two-dimensional arrays.

;Like AS-2 but always makes first subscript vary fastest
;regardless of what AREF does.
XAS-2-REVERSE (MISC-INST-ENTRY AS-2-REVERSE)
	(JUMP-XCT-NEXT ARRAY-DECODE-2-REVERSE)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAS-1-X)))

XAS-2 (MISC-INST-ENTRY AS-2)
	(JUMP-XCT-NEXT ARRAY-DECODE-2)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAS-1-X)))

XAP-2 (MISC-INST-ENTRY AP-2)
	(JUMP-XCT-NEXT ARRAY-DECODE-2)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAP-1-X)))

;Like AR-2 but always makes first subscript vary fastest
;regardless of what AREF does.
XAR-2-REVERSE (MISC-INST-ENTRY AR-2-REVERSE)
	(JUMP-XCT-NEXT ARRAY-DECODE-2-REVERSE)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAR-1-X)))

XAR-2 (MISC-INST-ENTRY AR-2)
XAR2   ;Perhaps used by microcompiled code
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAR-1-X)))

;Decode a two-dimensional array and two subscripts, popping them and checking all errors.
;Return the array in M-A, the address of its data in M-E,
;the ultimate index in M-Q, and the array length in M-S.
;The header is returned in M-B.
;Unlike the one-dimensional version of this routine,
;the caller does not need to pop the subscripts.
ARRAY-DECODE-2
	((M-A) A-ARRAY-INDEX-ORDER)
	(JUMP-EQUAL M-A A-V-NIL ARRAY-DECODE-2-REVERSE)
;Decode with last subscript varying fastest.
	((M-Q) Q-TYPED-POINTER PDL-POP)
	(CALL-XCT-NEXT GAHDRA)
       ((M-J) Q-TYPED-POINTER PDL-POP)
	(JUMP ARRAY-DECODE-2-COMMON)

;Restart here with new array in A after array-number-dimensions error.
ARRAY-DECODE-2-NEW-ARRAY-RESTART
    (ERROR-TABLE RESTART ARRAY-DECODE-2-NEW-ARRAY-RESTART)
	(CALL GAHDR)
	(JUMP ARRAY-DECODE-2-COMMON)

;Decode with first subscript varying fastest.
ARRAY-DECODE-2-REVERSE
	((M-J) Q-TYPED-POINTER PDL-POP)
	(CALL-XCT-NEXT GAHDRA)
       ((M-Q) Q-TYPED-POINTER PDL-POP)
ARRAY-DECODE-2-COMMON
	(CALL-NOT-EQUAL M-D (A-CONSTANT 2) TRAP)
    (ERROR-TABLE ARRAY-NUMBER-DIMENSIONS M-D 2 M-A ARRAY-DECODE-2-NEW-ARRAY-RESTART)
;Check the types of the subscripts.
    (ERROR-TABLE RESTART ARRAY-DECODE-2-ERROR-RESTART)
ARRAY-DECODE-2-ERROR-RESTART
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-Q TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-Q 1 ARRAY-DECODE-2-ERROR-RESTART AR-2)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-J TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-J 2 ARRAY-DECODE-2-ERROR-RESTART AR-2)
	((M-1) Q-POINTER M-J)
;Fetch the first dimension length.
	((VMA-START-READ) SUB M-E (A-CONSTANT 1))
;Enter here for 3-dimensional array, with combination of first two subscripts in M-1.
ARRAY-DECODE-2-A
	(CHECK-PAGE-READ)		;NO TRANSPORT SINCE JUST TOUCHED HDR
;Now multiply the first subscript by the array first dimension length.
	(CALL-XCT-NEXT MPY)
       ((Q-R M-D) READ-MEMORY-DATA)		;FIRST DIMENSION, SAVE IN M-D FOR BITBLT
;Add the other subscript.
	((M-Q) ADD Q-R A-Q)
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B DSP-ARRAY-SETUP)
       ((M-Q) Q-POINTER M-Q)
;Return checking the subscript bounds.
	(POPJ-XCT-NEXT)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

;Three-dimensional array access instructions

XAR-3 (MISC-INST-ENTRY AR-3)
	(JUMP-XCT-NEXT ARRAY-DECODE-3)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAR-1-X)))

XAS-3 (MISC-INST-ENTRY AS-3)
	(JUMP-XCT-NEXT ARRAY-DECODE-3)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAS-1-X)))

XAP-3 (MISC-INST-ENTRY AP-3)
	(JUMP-XCT-NEXT ARRAY-DECODE-3)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XAP-1-X)))

;Decode a three-dimensional array and three subscripts, popping them and checking all errors.
;Return the array in M-A, the address of its data in M-E,
;the ultimate index in M-Q, and the array length in M-S.
;The header is returned in M-B.
;Unlike the one-dimensional version of this routine,
;the caller does not need to pop the subscripts.
ARRAY-DECODE-3
	((M-A) A-ARRAY-INDEX-ORDER)
	(JUMP-EQUAL M-A A-V-NIL ARRAY-DECODE-3-REVERSE)
	((M-Q) Q-TYPED-POINTER PDL-POP)
	((M-J) Q-TYPED-POINTER PDL-POP)
	(CALL-XCT-NEXT GAHDRA)
       ((M-I) Q-TYPED-POINTER PDL-POP)
	(JUMP ARRAY-DECODE-3-COMMON)

;Restart here with new array in A after array-number-dimensions error.
ARRAY-DECODE-3-NEW-ARRAY-RESTART
    (ERROR-TABLE RESTART ARRAY-DECODE-3-NEW-ARRAY-RESTART)
	(CALL GAHDR)
	(JUMP ARRAY-DECODE-3-COMMON)

ARRAY-DECODE-3-REVERSE
	((M-I) Q-TYPED-POINTER PDL-POP)
	((M-J) Q-TYPED-POINTER PDL-POP)
	(CALL-XCT-NEXT GAHDRA)
       ((M-Q) Q-TYPED-POINTER PDL-POP)
ARRAY-DECODE-3-COMMON
    (ERROR-TABLE CALLS-SUB AX-3)
	(CALL-NOT-EQUAL M-D (A-CONSTANT 3) TRAP)
    (ERROR-TABLE ARRAY-NUMBER-DIMENSIONS M-D 3 M-A ARRAY-DECODE-3-NEW-ARRAY-RESTART)
    (ERROR-TABLE RESTART ARRAY-DECODE-3-ERROR-RESTART)
ARRAY-DECODE-3-ERROR-RESTART
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-Q TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-Q 1 ARRAY-DECODE-3-ERROR-RESTART AR-3)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-J TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-J 2 ARRAY-DECODE-3-ERROR-RESTART AR-3)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-I TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-I 3 ARRAY-DECODE-3-ERROR-RESTART AR-3)
	((VMA-START-READ) SUB M-E (A-CONSTANT 1))
	(CHECK-PAGE-READ)		;NO TRANSPORT SINCE JUST TOUCHED HEADER
	((M-1) Q-POINTER M-I)
	(CALL-XCT-NEXT MPY)
       ((Q-R) READ-MEMORY-DATA)
	((M-1) ADD Q-R A-J)
	((VMA-START-READ) SUB VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	(JUMP-XCT-NEXT ARRAY-DECODE-2-A)
       ((M-1) Q-POINTER M-1)

;Decode an array and any number of subscripts, on the stack.  Does not pop them!
;Expects number of subscripts in M-R.
;Return the array in M-A, the address of its data in M-E,
;the ultimate index in M-Q, and the array length in M-S.
;The header is returned in M-B.
ARRAY-DECODE-N
;Find the array on the stack and get its dimension, data start, and length.
	((PDL-INDEX) SUB PDL-POINTER A-R)
	(JUMP-EQUAL M-R (A-CONSTANT 1) ARRAY-DECODE-N=1)   ;Special case rank 1, for speed
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
    (ERROR-TABLE RESTART ARRAY-DECODE-N-NEW-ARRAY-RESTART)
	(CALL GAHDR)
	(CALL-NOT-EQUAL M-D A-R TRAP)
    (ERROR-TABLE ARRAY-NUMBER-DIMENSIONS M-D M-R M-A ARRAY-DECODE-N-NEW-ARRAY-RESTART)
;Enter here with GAHDR called, from QARYR.
ARRAY-DECODE-N-2
;Now multiply subscripts by dimensions, summing.
;First initialize.
	(JUMP-EQUAL-XCT-NEXT M-D A-ZERO ARRAY-DECODE-N=0) ;Index always 0 for 0-rank array.
       ((M-Q Q-R) A-ZERO)
;M-D is NIL if first subscript should vary fastest.
	((M-D) A-ARRAY-INDEX-ORDER)
	((VMA) M-E)		;Address of last multiplier (next-to-last dimension), plus 1.
	((PDL-INDEX) PDL-POINTER) ;Address of last subscript.
	(JUMP-EQUAL-XCT-NEXT M-D A-V-NIL ARRAY-DECODE-N-MULTIPLY)
       ((M-D) A-MINUS-ONE)
	((PDL-INDEX) SUB PDL-POINTER A-R) ;Address of first subscript, minus one.
	((PDL-INDEX) ADD PDL-INDEX (A-CONSTANT 1))
	((M-D) (A-CONSTANT 1))
;PDL-INDEX points to the next subscript to use in the computation.
;M-D has the amount to increment PDL-INDEX by (1 or -1).
ARRAY-DECODE-N-MULTIPLY
	((M-J) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
    (ERROR-TABLE RESTART ARRAY-DECODE-N-ERROR-RESTART)
ARRAY-DECODE-N-ERROR-RESTART
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE M-J TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM M-J NIL ARRAY-DECODE-N-ERROR-RESTART)
	((M-1) ADD Q-R A-J)
	((PDL-INDEX) ADD PDL-INDEX A-D)
	(JUMP-EQUAL-XCT-NEXT M-R (A-CONSTANT 1) ARRAY-DECODE-N-LAST-SUBSCRIPT)
	((M-1) Q-POINTER M-1)
	((VMA-START-READ) SUB VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)		;NO TRANSPORT SINCE JUST TOUCHED HDR
;Now multiply the next subscript by the array next dimension length.
	(CALL-XCT-NEXT MPY)
       ((Q-R) READ-MEMORY-DATA)
	(JUMP-XCT-NEXT ARRAY-DECODE-N-MULTIPLY)
       ((M-R) SUB M-R (A-CONSTANT 1))

ARRAY-DECODE-N=0
	((M-1) A-ZERO)
;Here after adding in the last subscript (sum in M-1).
;The ultimate index is now complete with no final multiplication.
ARRAY-DECODE-N-LAST-SUBSCRIPT
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B DSP-ARRAY-SETUP)
       ((M-Q) M-1)
;Return checking the subscript bounds.
	(POPJ-XCT-NEXT)
       (CALL-GREATER-OR-EQUAL M-Q A-S TRAP)

;Handle single-subscript case of ARRAY-DECODE-N.
;Go to ARRAY-DECODE-1 with array and subscript in M-A and M-Q,
;but also leave them on the stack.
ARRAY-DECODE-N=1
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
    (ERROR-TABLE RESTART ARRAY-DECODE-N=1-ERROR-RESTART)
ARRAY-DECODE-N=1-ERROR-RESTART
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE PDL-TOP TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 ARRAY-DECODE-N=1-ERROR-RESTART)
	(JUMP-XCT-NEXT ARRAY-DECODE-1-A)
       ((M-Q) Q-POINTER PDL-TOP)

;AREF is called with the CALL instruction; args are an array and subscripts.
;So M-R is the number of args, or one more than the number of subscripts.
;When we return, the frame is thrown away.
;ASET and ALOC are similar; ASET's first arg is the value to store.
XAREF (MISC-INST-ENTRY AREF)
	(CALL-XCT-NEXT ARRAY-DECODE-N)
       ((M-R) SUB M-R (A-CONSTANT 1))
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A T)
	(JUMP XAR-1-X)

XASET (MISC-INST-ENTRY ASET)
	(CALL-XCT-NEXT ARRAY-DECODE-N)
       ((M-R) SUB M-R (A-CONSTANT 2))	;There are TWO args that aren't subscripts, in ASET.
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A T)
	((PDL-INDEX) ADD M-AP (A-CONSTANT 1))
	(DISPATCH-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B
	 ARRAY-TYPE-STORE-DISPATCH)
    (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)

XALOC (MISC-INST-ENTRY ALOC)
	(CALL-XCT-NEXT ARRAY-DECODE-N)
       ((M-R) SUB M-R (A-CONSTANT 1))
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A T)
	(JUMP XAP-1-X)

QARYR	((M-Q) READ-I-ARG)			;In case we go to CALL-HASH-TABLE.
    (ERROR-TABLE RESTART QARYR)
	(CALL GAHD1)	;REFERENCE ARRAY
;A named structure with its funcall as hash table bit set
;should not simply be indexed into.  Instead, do something like
;what is done for funcalling an instance:
; hash the first arg to find the function to call.
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ARRAY-LEADER-BIT) M-B QARYR2)
	((VMA-START-READ) SUB M-A (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARRAY-LEADER-FUNCALL-AS-HASH-TABLE) MD CALL-HASH-TABLE)
QARYR2
	(CALL-NOT-EQUAL M-D A-R TRAP)
    (ERROR-TABLE ARRAY-NUMBER-DIMENSIONS M-D M-R M-A QARYR)
	(CALL ARRAY-DECODE-N-2)
    (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S (NIL XAREF-RECHECK-INDEX) M-A T)
	((A-QLARYL) DPB M-Q Q-POINTER 	;LAST ELEMENT # REF ED
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(CALL-XCT-NEXT XAR-1-X)
       ((A-QLARYH) Q-TYPED-POINTER M-A)	;PNTR TO HEADER OF LAST ARRAY REF ED

;Drops in.  Return from a call with frame to an array or %AREF, %ASET or %ALOC.
;Pops the frame and returns to the calling frame.
QARYR5	((M-TEM) A-IPMARK)		;GET POINTER TO (OLD) OPEN BLOCK
	((PDL-BUFFER-INDEX) ADD M-TEM (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-C) C-PDL-BUFFER-INDEX)	;IN CASE CALL QRAD1 AND CLOBBER PDL INDEX
	((A-TEM1) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) M-C)
	((M-1) SUB M-TEM A-TEM1)
	((A-IPMARK) (BYTE-FIELD 10. 0) M-1)
	((PDL-BUFFER-POINTER) SUB M-TEM (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH)))
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-CLS-ADI-PRESENT)
			 M-C		;MULTI-VALUE CALL, STORE LAST VALUE
			 QRAD1)		;IN RIGHT PLACE, ETC
	;; Store into destination in M-C.  Could be D-MICRO.  Duplicates QIMOVE-EXIT
	(DISPATCH (LISP-BYTE %%LP-CLS-DESTINATION) M-C QMDTBD)
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
;QBNEAF AND QBALM FLUSHED

;General subroutine for decoding an array's header information.
;Call GAHDRA, GAHDR or GAHD1 with array pointer in appropriate place.
;Returns: array header in M-B, rank in M-D, first data word pointer in M-E,
;array-length in M-S, array pointer in M-A.

GAHD4	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-STACK-GROUP)) GAHD1)	;SG OK
	(CALL TRAP)			;BAD D.T. IN ARRAY-POINTER
   (ERROR-TABLE ARGTYP ARRAY M-A NIL GAHDR)

GAHDRA	((M-A) C-PDL-BUFFER-POINTER-POP)
   (ERROR-TABLE RESTART GAHDR)
GAHDR	((M-TEM) Q-DATA-TYPE M-A)	;FOR USE WHEN A IS NOT ALREADY KNOW TO BE
					; ARRAY-POINTER
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) GAHD4)
GAHD1	((VMA-START-READ) M-A)		;GET ARRAY HEADER
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)	;GC, FOLLOW INVZ
	((M-A) VMA)			;MAY HAVE FORWARDED, GET REAL ADDRESS
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)	;VERIFY ARRAY HEADER DATA TYPE
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-HEADER)) ILLOP)
	((M-B) Q-POINTER READ-MEMORY-DATA)	;SAVE ARRAY HEADER Q
	((M-E) Q-POINTER M-A)		;INITIAL TYPELESS PNTR TO FIRST DATA ELEMENT
	((M-D) (LISP-BYTE %%ARRAY-NUMBER-DIMENSIONS) M-B)
	((M-E) ADD M-E A-D)		;ADDR OF FIRST DATA ELEMENT OF ARRAY (TYPELESS)
	(CALL-EQUAL M-D A-ZERO GAHD-RANK-0)
	(POPJ-AFTER-NEXT
	 (M-S) (LISP-BYTE %%ARRAY-INDEX-LENGTH-IF-SHORT) M-B)	;INDEX LENGTH
       (CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-LONG-LENGTH-FLAG) M-B GAHD3)

;A rank-0 array has the same number of multipliers as a rank-1 array (none).
GAHD-RANK-0
	(POPJ-AFTER-NEXT NO-OP)
       ((M-E) ADD M-E (A-CONSTANT 1))

GAHD3	((VMA-START-READ) ADD M-A (A-CONSTANT 1))	;LONG ARRAY, GET INDEX LENGTH Q
	(CHECK-PAGE-READ)		;NO TRANSP SINCE JUST TOUCHED HEADER
	(POPJ-AFTER-NEXT (M-E) ADD M-E (A-CONSTANT 1))	;SPACE OVER INDEX Q
       ((M-S) Q-POINTER READ-MEMORY-DATA)


XAIXL (MISC-INST-ENTRY ARRAY-LENGTH)
	(CALL GAHDRA)
  (ERROR-TABLE CALLS-SUB ARRAY-LENGTH)
  (ERROR-TABLE ARG-POPPED 0 M-A)
XAIXL1	(POPJ-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B)
       ((M-T) DPB M-S Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((VMA-START-READ) ADD M-E (A-CONSTANT 1))	;DISPLACED, GET INDEX LENGTH
	(CHECK-PAGE-READ)	;NO TRANSPORT SINCE JUST TOUCHED HDR
XAIXL2	(POPJ-AFTER-NEXT NO-OP)
       ((M-T) DPB READ-MEMORY-DATA Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

XAAIXL (MISC-INST-ENTRY ARRAY-ACTIVE-LENGTH)
	(CALL GAHDRA)
  (ERROR-TABLE CALLS-SUB ARRAY-ACTIVE-LENGTH)
  (ERROR-TABLE ARG-POPPED 0 M-A)
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ARRAY-LEADER-BIT) M-B XAIXL1)
	((VMA-START-READ) SUB M-A (A-CONSTANT 2))	;Get fill pointer from leader
	(CHECK-PAGE-READ)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)		;Fixnum there?
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) XAIXL2) ;Yes, it's the fill ptr
	(JUMP XAIXL1)					;No, don't use garbage as fill ptr

DSP-ARRAY-SETUP   ;CALL WITH ARRAY POINTER IN M-A, HEADER IN M-B, 
		  ; FIRST DATA ELEM IN M-E, DESIRED ELEMENT NUMBER IN M-Q.
		  ;RETURNS WITH DATA ORIGIN IN M-E, M-S CHANGED TO REFLECT ARRAY
		  ; BEING REF'ED AND POSSIBLY ADJUSTED M-Q.
	((VMA-START-READ) ADD A-ZERO M-E ALU-CARRY-IN-ONE)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)	;TRANSPORT IN CASE POINTS TO OLDSPACE
	((M-S) Q-POINTER READ-MEMORY-DATA)	;GET NEW DATA LENGTH LIMIT
	((VMA-START-READ) M-E)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)	;TRANSPORT IN CASE POINTS TO OLDSPACE
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(POPJ-NOT-EQUAL-XCT-NEXT M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER)))
       ((M-E) Q-POINTER READ-MEMORY-DATA)
;Drops in if Indirect-array
;Operation of QDACMP:
; The word just read from memory is the array-pointer to indirect to
; M-Q has entry number desired
;QDACMP pushes the info relative to the indirect array (M-A, M-B, M-D).
; M-E eventually gets the data base of the pointed-to array.
; M-S gets MIN(M-S from indirect array + index offset, index length of pointed-to array).
; In the process, M-Q will be adjusted if an index offset is encountered.
; After the final data base is determined, M-A, M-B, and M-D are restored.

QDACMP	((C-PDL-BUFFER-POINTER-PUSH) M-A)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((C-PDL-BUFFER-POINTER-PUSH) M-D)
	((C-PDL-BUFFER-POINTER-PUSH)	;SAVE ARRAY-TYPE OF ORIGINALLY REF'ED ARRAY
		(LISP-BYTE %%ARRAY-TYPE-FIELD) M-B  ;THIS MUST BE IN 0@PP BELOW
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
;Come here each time we trace through to another indirect array.
;M-B has the header of the last indirect array found, which we will now trace.
;In particular, the low bit of M-B is set if the length-field is 3 (index offset)
;and not if it is 2 (no index offset).
QDACM2	((M-A) READ-MEMORY-DATA)	;POINTED-TO ARRAY
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 0) M-B QDACM5)  ;JUMP UNLESS INDEX OFFSET
	((VMA-START-READ) ADD VMA (A-CONSTANT 2))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
			Q-DATA-TYPE READ-MEMORY-DATA TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE DATA-TYPE-SCREWUP ARRAY)
	((M-D) Q-POINTER READ-MEMORY-DATA)		;FETCH INDEX OFFSET
	((M-S) ADD M-S A-D)				;ADJUST INDEX LIMIT
	((M-Q) ADD M-Q A-D)				;ADJUST CURRENT INDEX
QDACM5	(CALL-XCT-NEXT GAHD1)		;SETS UP M-E, M-S
       ((C-PDL-BUFFER-POINTER-PUSH) Q-POINTER M-S	;SAVE POINTER'S INDEX LENGTH
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
  (ERROR-TABLE CALLS-SUB ARRAY-INDIRECT)
	(JUMP-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B QDACMI)
       ((M-D) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;NOW TAKE MINIMUM OF THE TWO LENGTHS
	((VMA-START-READ) ADD M-E (A-CONSTANT 1))	;DOUBLE DISPLACE, GET CORRECT LENGTH
	(CHECK-PAGE-READ)
	((M-S) Q-POINTER READ-MEMORY-DATA)
QDACMI	((M-TEM) (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B  ;CHECK IF SAME ARRAY-TYPE AS ORIG REF
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(JUMP-NOT-EQUAL C-PDL-BUFFER-POINTER A-TEM QDACM8)  ;NO, ORIG MUST CONTROL
	(JUMP-GREATER-OR-EQUAL M-D A-S QDACM7)
QDACM8	((M-S) M-D)
QDACM7	(JUMP-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B QDACM6) ;FURTHER INDIR
QDACM1	((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)	;FLUSH ARRAY TYPE
	((M-D) C-PDL-BUFFER-POINTER-POP) ;GOT ALL INFO, RESTORE M-A, M-B, M-D
	(POPJ-AFTER-NEXT 
	 (M-B) C-PDL-BUFFER-POINTER-POP)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QDACM6	((VMA-START-READ) M-E)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) QDACM2) ;DOUBLE INDIRECT
	(JUMP-XCT-NEXT QDACM1)				;JUST DISPLACED
       ((M-E) Q-POINTER READ-MEMORY-DATA)

QBFXIT	((M-J) SUB (M-CONSTANT 40) A-TEM2)	;REFLECT BECAUSE OF SHIFTER LOSSAGE
QBFXIT1	((OA-REG-LOW) DPB M-J A-TEM3 OAL-MROT)	;MODIFY NEXT INSTRUCTION
		;DPB NECESSARY BECAUSE M-J = 40 IF A-TEM2 WAS 0
	(POPJ-AFTER-NEXT 
	 BYTE-INST (M-T) READ-MEMORY-DATA)
       ((M-T) IOR (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)) M-T)

QB1RY	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 5) 5) M-Q)	;BIT ARRAY
	((VMA-START-READ) ADD A-TEM1 M-E)
	(CHECK-PAGE-READ)
	((A-TEM2) (BYTE-FIELD 5 0) M-Q)
	(JUMP-XCT-NEXT QBFXIT)			;NO LSH SINCE EA ELEMENT ONE BIT
       ((A-TEM3) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 1 0)))) )

QB2RY	((M-J) (BYTE-FIELD 4 0) M-Q)		;2 BIT ARRAY
	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 4) 4) M-Q)
	((VMA-START-READ) ADD A-TEM1 M-E)
	(CHECK-PAGE-READ)
	((A-TEM2) DPB M-J A-ZERO (BYTE-FIELD 4 1))	;LSH M-J 1
	(JUMP-XCT-NEXT QBFXIT)
       ((A-TEM3) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 2 0)))) )

QB4RY	((M-J) (BYTE-FIELD 3 0) M-Q)		;4 BIT ARRAY
	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 3) 3) M-Q)
	((VMA-START-READ) ADD A-TEM1 M-E)
	(CHECK-PAGE-READ)
	((A-TEM2) DPB M-J A-ZERO (BYTE-FIELD 3 2))	;LSH M-J 2
	(JUMP-XCT-NEXT QBFXIT)
       ((A-TEM3) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 4 0)))) )

;; 8-bit bytes (including strings)
QBARY	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 2) 2) M-Q)
	((VMA-START-READ) ADD A-TEM1 M-E)
	(DISPATCH-XCT-NEXT (BYTE-FIELD 2 0) M-Q D-QBARY)
       (CHECK-PAGE-READ)

(LOCALITY D-MEM)
(START-DISPATCH 2 0)
D-QBARY	(QBARY-0)
	(QBARY-1)
	(QBARY-2)
	(QBARY-3)
(END-DISPATCH)
(LOCALITY I-MEM)

QBARY-0
	(POPJ-XCT-NEXT)
       ((M-T) DPB MD (BYTE-FIELD 10 0) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QBARY-1	(POPJ-AFTER-NEXT (M-T) (BYTE-FIELD 10 10) MD)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QBARY-2	(POPJ-AFTER-NEXT (M-T) (BYTE-FIELD 10 20) MD)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QBARY-3	(POPJ-AFTER-NEXT (M-T) (BYTE-FIELD 10 30) MD)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QB16RY	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 1) 1) M-Q)
	((VMA-START-READ) ADD A-TEM1 M-E)
	(JUMP-IF-BIT-SET-XCT-NEXT (BYTE-FIELD 1 0) M-Q QB16RY-ODD)
       (CHECK-PAGE-READ)
	(POPJ-XCT-NEXT)
       ((M-T) DPB MD (BYTE-FIELD 20 0) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QB16RY-ODD
	(POPJ-AFTER-NEXT (M-T) (BYTE-FIELD 20 20) MD)
       ((M-T) DPB M-T (BYTE-FIELD 20 0) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QB32RY	((VMA-START-READ) ADD A-Q M-E)		;32 BIT ARRAY (REALLY POINTER SIZE AND FORCE
	(CHECK-PAGE-READ)			;FIXNUM DATA-TYPE) USEFUL FOR TV-BUFFER
	(POPJ-AFTER-NEXT NO-OP)
       ((M-T) DPB READ-MEMORY-DATA Q-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QB16SRY	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 1) 1) M-Q)	;HALFWORD FIXNUM ARRAY
	((VMA-START-READ) ADD A-TEM1 M-E)
	(CHECK-PAGE-READ)
	(JUMP-IF-BIT-CLEAR-XCT-NEXT (BYTE-FIELD 1 0) M-Q A-ZERO QB16SRY-1)
       ((M-T) (BYTE-FIELD 16. 0) READ-MEMORY-DATA
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-T) (BYTE-FIELD 16. 16.) READ-MEMORY-DATA
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
QB16SRY-1
	(POPJ-AFTER-NEXT POPJ-IF-BIT-CLEAR (BYTE-FIELD 1 15.) M-T)
       ((M-T) DPB (M-CONSTANT -1) (BYTE-FIELD 8 16.) A-T)	;NEGATIVE--EXTEND SIGN

QQARY	((VMA-START-READ) ADD A-Q M-E)		;Q ARRAY
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

QFARY	((M-TEM) ADD M-Q A-Q)			;FLOAT
	((VMA-START-READ) ADD M-E A-TEM)
	(CHECK-PAGE-READ)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((C-PDL-BUFFER-POINTER-PUSH) M-E)
	((C-PDL-BUFFER-POINTER-PUSH) M-I)
	((M-I) READ-MEMORY-DATA)
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	((C-PDL-BUFFER-POINTER-PUSH) M-K)
	((C-PDL-BUFFER-POINTER-PUSH) M-S)
	(CALL-XCT-NEXT FLOPACK)
       ((M-1) READ-MEMORY-DATA)
QFARY1	((M-S) C-PDL-BUFFER-POINTER-POP)
	((M-K) C-PDL-BUFFER-POINTER-POP)
	((M-I) C-PDL-BUFFER-POINTER-POP)
	(POPJ-AFTER-NEXT (M-E) C-PDL-BUFFER-POINTER-POP)
       ((M-B) C-PDL-BUFFER-POINTER-POP)

QFFARY	((VMA-START-READ) ADD M-Q A-E)		;FPS-FLOAT
	(CHECK-PAGE-READ)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((C-PDL-BUFFER-POINTER-PUSH) M-E)
	((C-PDL-BUFFER-POINTER-PUSH) M-I)
	((C-PDL-BUFFER-POINTER-PUSH) M-K)
	((C-PDL-BUFFER-POINTER-PUSH) M-S)
	((M-TEM) (BYTE-FIELD 16. 16.) READ-MEMORY-DATA)		;Swap halves
	((M-TEM) DPB READ-MEMORY-DATA (BYTE-FIELD 16. 16.) A-TEM)
	((M-1) DPB M-TEM (BYTE-FIELD 23. 7) (A-CONSTANT 1_30.))	;Positive fraction
	((M-I) (BYTE-FIELD 8 23.) M-TEM)	;Excess-200 exponent
	(CALL-EQUAL-XCT-NEXT M-I A-ZERO FLZERO)	;0.0 is a special case
       ((M-I) ADD M-I (A-CONSTANT 1600))	;Excess-2000 exponent
	(CALL-IF-BIT-SET (BYTE-FIELD 1 31.) M-TEM FNEG1) ;If negative, negate
	(JUMP-XCT-NEXT QFARY1)       
       (CALL FLOPACK)

;ART-COMPLEX.  Two words per element.
QCARY	(CALL-XCT-NEXT MAKE-COMPLEX-SAVE)
       ((M-TEM) ADD M-Q A-Q)
;Read the imaginary part first, and push it.
	((VMA-START-READ) M+A+1 M-E A-TEM)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	((PDL-PUSH) Q-TYPED-POINTER MD)
;Read the real part and push it.
	((VMA-START-READ) SUB VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	(JUMP-EQUAL PDL-TOP (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))
		QCARY-REAL)
	((PDL-PUSH) MD)
	(CALL MAKE-COMPLEX)
	(JUMP MAKE-COMPLEX-RESTORE)

;Here if the imaginary part was 0.  Just return the real part.
;Note we only checked for fixed point 0 because that is what was
;put in the imag part if a real number is stored in the array.
QCARY-REAL
	(PDL-POP)
	(JUMP-XCT-NEXT MAKE-COMPLEX-RESTORE)
       ((M-T) MD)

;Array reference routines that use MAKE-COMPLEX
;must call this before pushing the args for MAKE-COMPLEX.
MAKE-COMPLEX-SAVE
	((PDL-PUSH) M-K)
	((PDL-PUSH) M-E)
	(POPJ-AFTER-NEXT
	 (PDL-PUSH) M-B)
       ((PDL-PUSH) M-S)

;And call this after MAKE-COMPLEX returns.
MAKE-COMPLEX-RESTORE
	((M-S) PDL-POP)
	((M-B) PDL-POP)
	(POPJ-AFTER-NEXT
	 (M-E) PDL-POP)
       ((M-K) PDL-POP)

;Make a complex from the imag part and real part on the stack (in that order)
;and return it in M-T.
MAKE-COMPLEX
;Now make a rational (!) with the imag part as denominator and real part as numerator.
	(CALL MAKE-RATIONAL)
;Change the rational into a complex by altering the header type.
	((MD-START-WRITE)
	 (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-HEADER)
			   (BYTE-VALUE HEADER-TYPE-FIELD %HEADER-TYPE-COMPLEX)
			   0)))
	(CHECK-PAGE-WRITE)
	(POPJ)

;ART-COMPLEX-FLOAT.  Four words per element -- two flonums.
;Read the two flonums one by one as for ART-FLOAT,
;then make a complex from them.
QCFARY	(CALL MAKE-COMPLEX-SAVE)
	((PDL-PUSH) DPB M-Q Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(CALL-XCT-NEXT QFARY)
       ((M-Q) M+A+1 M-Q A-Q)
	((M-2) M-1)
	((M-Q) SUB M-Q (A-CONSTANT 1))
	(CALL-XCT-NEXT QFARY)
       ((PDL-PUSH) M-T)
	(JUMP-EQUAL M-2 A-ZERO QCFARY-REAL)
	(CALL-XCT-NEXT MAKE-COMPLEX)
       ((PDL-PUSH) M-T)
	(JUMP-XCT-NEXT MAKE-COMPLEX-RESTORE)
       ((M-Q) LDB Q-POINTER PDL-POP)

QCFARY-REAL
	(PDL-POP)
	(JUMP-XCT-NEXT MAKE-COMPLEX-RESTORE)
       ((M-Q) LDB Q-POINTER PDL-POP)

;ART-COMPLEX-FPS-FLOAT.  Two words per element -- two flonums in FPS format.
;Read the two flonums one by one as for ART-FPS-FLOAT,
;then make a complex from them.
QCFFARY	(CALL MAKE-COMPLEX-SAVE)
	((PDL-PUSH) DPB M-Q Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(CALL-XCT-NEXT QFFARY)
       ((M-Q) M+A+1 M-Q A-Q)
	((M-2) M-1)
	((M-Q) SUB M-Q (A-CONSTANT 1))
	(CALL-XCT-NEXT QFFARY)
       ((PDL-PUSH) M-T)
	(JUMP-EQUAL M-2 A-ZERO QCFARY-REAL)
	(CALL-XCT-NEXT MAKE-COMPLEX)
       ((PDL-PUSH) M-T)
	(JUMP-XCT-NEXT MAKE-COMPLEX-RESTORE)
       ((M-Q) LDB Q-POINTER PDL-POP)

   (MISC-INST-ENTRY GET-LOCATIVE-POINTER-INTO-ARRAY)
XGLOPR  ((M-R) SETA (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE))
		    C-PDL-BUFFER-POINTER-POP)	;FLUSH ARGUMENT
	(CALL-XCT-NEXT GAHD1)
       ((M-A) A-QLARYH)		;CONCEIVABLY SHOULD CHECK TO MAKE SURE Q ORIENTED
  (ERROR-TABLE CALLS-SUB GET-LOCATIVE-POINTER-INTO-ARRAY)
	(JUMP-XCT-NEXT XGLOP1)	;ARRAY
       ((M-Q) DPB M-ZERO Q-ALL-BUT-POINTER A-QLARYL)

   (MISC-INST-ENTRY GET-LIST-POINTER-INTO-ARRAY)
XGLPA	((M-R) SETA (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST))
		     C-PDL-BUFFER-POINTER-POP)	;IGNORE ARGUMENT
					;GET LIST POINTER TO LAST ARRAY ELEMENT REF ED
	(CALL-XCT-NEXT GAHD1)
       ((M-A) A-QLARYH)
   (ERROR-TABLE CALLS-SUB GET-LIST-POINTER-INTO-ARRAY)
	((M-Q) DPB M-ZERO Q-ALL-BUT-POINTER A-QLARYL)		;ENTRY NUMBER
XGLPA1	((M-TEM) (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL (LSH ART-Q-LIST ARRAY-TYPE-SHIFT))) TRAP)
   (ERROR-TABLE ARGTYP ART-Q-LIST-ARRAY M-A T NIL)
XGLOP1	(CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B 
		DSP-ARRAY-SETUP)  		;DISPLACED
	(CALL-GREATER-OR-EQUAL M-Q A-S TRAP)	;INDEX OUT OF BOUNDS
   (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S)
	(POPJ-AFTER-NEXT 
	 (A-TEM3) IOR A-R M-Q)
      ((M-T) ADD A-TEM3 M-E)

     (MISC-INST-ENTRY G-L-P)		;(G-L-P <ARRAY-POINTER-TO-ART-Q-LIST-ARRAY>)
XGLPAR	(CALL GAHDRA)			; RETURNS LIST POINTER TO ARRAY CONTENTS
    (ERROR-TABLE CALLS-SUB G-L-P)	;IF FILL-POINTER 0, RETURN NIL
    (ERROR-TABLE ARG-POPPED 0 M-A)
	(JUMP-IF-BIT-CLEAR M-B (LISP-BYTE %%ARRAY-LEADER-BIT) XGLPA2) ;JUMP ON NO LEADER
	((VMA-START-READ) SUB M-A (A-CONSTANT 2))	;NO TRANSPORT SINCE JUST TOUCHED HDR
	(CHECK-PAGE-READ)
	((M-TEM) Q-TYPED-POINTER READ-MEMORY-DATA)
	(JUMP-EQUAL M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)) XFALSE)
XGLPA2	((M-R) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	(JUMP-XCT-NEXT XGLPA1)		;RETURN POINTER TO ELEMENT NUMBER 0
       ((M-Q) A-ZERO)

;Storing into arrays.

(ERROR-TABLE DEFAULT-ARG-LOCATIONS XSTORE M-T)

XXSTOR (MISC-INST-ENTRY XSTORE)
	((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)	;STORE IN LAST ARRAY ELEM REF ED
	(CALL-XCT-NEXT GAHD1)
       ((M-A) A-QLARYH)
   (ERROR-TABLE CALLS-SUB STORE)
   (ERROR-TABLE ARG-POPPED 0 PP)
	((M-Q) DPB M-ZERO Q-ALL-BUT-POINTER A-QLARYL)
	(CALL-IF-BIT-SET M-B (LISP-BYTE %%ARRAY-DISPLACED-BIT) DSP-ARRAY-SETUP)
   (ERROR-TABLE ARG-POPPED 0 PP)
	(CALL-GREATER-OR-EQUAL M-Q A-S TRAP)	;INDEX OUT OF BOUNDS
   (ERROR-TABLE SUBSCRIPT-OOB M-Q M-S)
   (ERROR-TABLE ARG-POPPED 0 PP)
	(DISPATCH-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) 
		M-B ARRAY-TYPE-STORE-DISPATCH)
   (ERROR-TABLE BAD-ARRAY-TYPE M-B)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

;Store routines for various types of arrays, reached via ARRAY-TYPE-STORE-DISPATCH.
;M-T has data to store, M-Q subscript, M-E etc. have GAHDR data.

;NOTE REFLECTING ABOUT 40 HACK NOT NECESSARY FOR DPB
QSBARY	((M-J) DPB M-Q (BYTE-FIELD 2 3)		;STORE IN BYTE ARRAY (8 BIT)
		(A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 10 0)))))
	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 2) 2) M-Q)	;WORD OFFSET
QSANUM	((VMA-START-READ) ADD A-TEM1 M-E)	;COMMON STORE ROUTINE FOR NUMERIC ARRAYS
	(CHECK-PAGE-READ)
	(DISPATCH Q-DATA-TYPE M-T TRAP-UNLESS-FIXNUM)
	    (ERROR-TABLE ARGTYP FIXNUM M-T 0)	;STORING IN NUMERIC ARRAY, MUST BE FIXNUM
	((A-TEM1) READ-MEMORY-DATA)
	((OA-REG-LOW) M-J)			;MODIFY FOLLOWING INST FOR WRITE
       ((WRITE-MEMORY-DATA-START-WRITE) DPB M-T A-TEM1)
	(CHECK-PAGE-WRITE)
CPOPJ	(POPJ)

QS1RY	((M-J) DPB M-Q (BYTE-FIELD 5 0)		;STORE IN BIT ARRAY
		(A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 1 0)))))
	(JUMP-XCT-NEXT QSANUM)
       ((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 5) 5) M-Q)		;WORD OFFSET

QS2RY	((M-J) DPB M-Q (BYTE-FIELD 4 1)		;STORE IN 2-BIT ARRAY
		(A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 2 0)))))
	(JUMP-XCT-NEXT QSANUM)
       ((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 4) 4) M-Q)		;WORD OFFSET

QS4RY	((M-J) DPB M-Q (BYTE-FIELD 3 2)		;STORE IN 4-BIT ARRAY
		(A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 4 0)))))
	(JUMP-XCT-NEXT QSANUM)
       ((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 3) 3) M-Q)		;WORD OFFSET

QS16RY	((M-J) DPB M-Q (BYTE-FIELD 1 4)		;STORE IN 16-BIT ARRAY
		(A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST (BYTE-FIELD 20 0)))))
	(JUMP-XCT-NEXT QSANUM)
       ((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 1) 1) M-Q)		;WORD OFFSET

QS32RY	((VMA) ADD A-Q M-E)			;32 BIT ARRAY (ANOMALOUS)
	((WRITE-MEMORY-DATA-START-WRITE) M-T)
	(CHECK-PAGE-WRITE)
	(POPJ)

QSQARY	((VMA) ADD A-Q M-E)			;Q ARRAY
	((WRITE-MEMORY-DATA-START-WRITE) M-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

QSLQRY	((VMA-START-READ) ADD A-Q M-E)		;Q-LIST ARRAY
	(CHECK-PAGE-READ)			;NO TRANSPORT SINCE STORING AND JUST
	((WRITE-MEMORY-DATA-START-WRITE)	;TOUCHED HEADER AND DON'T ALLOW ONE-Q-FORWARD
		SELECTIVE-DEPOSIT READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

QSFARY	((M-J) M-I)				;Save M-I
	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;Value being stored
	(CALL GET-FLONUM)
	((M-TEM) ADD M-Q A-Q)
	((WRITE-MEMORY-DATA) M-I)
	((VMA-START-WRITE) ADD M-E A-TEM)
	(CHECK-PAGE-WRITE)
	((M-I) M-J)				;Restore M-I
	((WRITE-MEMORY-DATA) M-1)
	((VMA-START-WRITE) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-WRITE)
	(POPJ)

;Store into ART-COMPLEX-FLOAT.
QSCFARY (CALL-XCT-NEXT QSCARY-DECODE)
;M-J has real part, MD has imag part.
       ((PDL-PUSH) M-T)		;Don't clobber M-T or M-Q.
	((PDL-PUSH) DPB M-Q Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((PDL-PUSH) M-J)	;QSFARY clobbers M-J.
	((M-T) MD)
	(CALL-XCT-NEXT QSFARY)
       ((M-Q) M+A+1 M-Q A-Q)	;Store the imaginary part, ART-FLOAT style.
	((M-T) PDL-POP)
	(CALL-XCT-NEXT QSFARY)	;Store the real part similarly.
       ((M-Q) SUB M-Q (A-CONSTANT 1))
	(POPJ-AFTER-NEXT
	 (M-Q) LDB Q-POINTER PDL-POP)		;Restore registers.
       ((M-T) PDL-POP)

;Store into ART-COMPLEX-FPS-FLOAT.
QSCFFARY (CALL-XCT-NEXT QSCARY-DECODE)
;M-J has real part, MD has imag part.
       ((PDL-PUSH) M-T)		;Don't clobber M-T or M-Q.
	((PDL-PUSH) DPB M-Q Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((PDL-PUSH) M-J)	;QSFARY clobbers M-J.
	((M-T) MD)
	(CALL-XCT-NEXT QSFFARY)
       ((M-Q) M+A+1 M-Q A-Q)	;Store the imaginary part, ART-FPS-FLOAT style.
	((M-T) PDL-POP)
	(CALL-XCT-NEXT QSFFARY)	;Store the real part similarly.
       ((M-Q) SUB M-Q (A-CONSTANT 1))
	(POPJ-AFTER-NEXT
	 (M-Q) LDB Q-POINTER PDL-POP)		;Restore registers.
       ((M-T) PDL-POP)

QSCARY	(CALL QSCARY-DECODE)
;MD has the imaginary part, M-J the real part.
	((M-TEM) ADD M-Q A-Q)
	((VMA-START-WRITE) M+A+1 M-E A-TEM)
	(CHECK-PAGE-WRITE)
	((WRITE-MEMORY-DATA) M-J)
	((VMA-START-WRITE) SUB VMA (A-CONSTANT 1))
	(CHECK-PAGE-WRITE)
	(POPJ)

;Decode the number in M-T: put realpart in M-J and imag part in MD.
;If the number is real, put it in M-J and put boxed zero in MD.
QSCARY-DECODE
;First, is the number we are storing actually complex?
	((M-TEM) Q-DATA-TYPE M-T)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-EXTENDED-NUMBER)) QSCARY-REAL)
	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER MD)
	((M-TEM) HEADER-TYPE-FIELD MD)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL %HEADER-TYPE-COMPLEX)) QSCARY-REAL)
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	((M-J) Q-TYPED-POINTER MD)
	(POPJ-AFTER-NEXT
	 (VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)

QSCARY-REAL
	(POPJ-AFTER-NEXT
	 (M-J) M-T)
       ((MD) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

;FPS-FLOAT has less precision than Lisp machine float, so round.
QSFFARY	((M-J) M-I)				;Save M-I
	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;Value being stored
	(CALL GET-FLONUM)
	;Transfer sign bit to M-TEM and get magnitude of fraction
	(CALL-LESS-THAN-XCT-NEXT M-1 A-ZERO FNEG1)
       ((M-TEM) SELECTIVE-DEPOSIT M-1 (BYTE-FIELD 1 31.) A-ZERO)
	;Round off fraction
	((M-4) (BYTE-FIELD 7 0) M-1)		;Discarded bits of fraction
	(CALL-EQUAL M-4 (A-CONSTANT 1_6) QSFFRY2)	;Stable rounding
	((M-1) ADD M-1 (A-CONSTANT 1_6))
	(CALL-IF-BIT-SET (BYTE-FIELD 1 31.) M-1 QSFFRY3)	;Renormalize
QSFFRY0	((M-I) SUB M-I (A-CONSTANT 1600))	;Get excess-200 exponent
	(JUMP-LESS-OR-EQUAL M-I A-ZERO QSFFRY1)	;Underflow or zero => zero
	;Insert relevant fraction bits
	((M-TEM) (BYTE-FIELD 23. 7) M-1 A-TEM)
	(JUMP-LESS-THAN-XCT-NEXT M-I (A-CONSTANT 400) QSFFRY1)
       ((M-TEM) DPB M-I (BYTE-FIELD 8 23.) A-TEM)
	((M-TEM) DPB (M-CONSTANT -1) (BYTE-FIELD 31. 0) A-TEM)	;Overflow => infinity
QSFFRY1	((M-1) (BYTE-FIELD 16. 16.) M-TEM)	;Swap halves
	((WRITE-MEMORY-DATA) DPB M-TEM (BYTE-FIELD 16. 16.) A-1)	
	((VMA-START-WRITE) ADD M-E A-Q)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT (M-I) M-J)
       (NO-OP)

QSFFRY2	(POPJ-AFTER-NEXT POPJ-IF-BIT-SET (BYTE-FIELD 1 7) M-1)
	(JUMP QSFFRY0)				;If lsb 0, suppress adding 1

QSFFRY3	(POPJ-AFTER-NEXT (M-1) (BYTE-FIELD 30. 1) M-1)	;Shift fraction right 1
       ((M-I) ADD M-I (A-CONSTANT 1))		;And increment exponent
				
XFARY-RESTART
   (ERROR-TABLE RESTART XFARY-RESTART)
	(CALL GAHDR)
	(JUMP XFARY-1)

   (ERROR-TABLE DEFAULT-ARG-LOCATIONS ARRAY-PUSH PP M-T)
   (MISC-INST-ENTRY ARRAY-PUSH)
XFARY	((M-T) C-PDL-BUFFER-POINTER-POP)
	(CALL-XCT-NEXT GAHDR)
       ((M-A) C-PDL-BUFFER-POINTER)
   (ERROR-TABLE CALLS-SUB ARRAY-PUSH)
XFARY-1
	(CALL-IF-BIT-CLEAR (LISP-BYTE %%ARRAY-LEADER-BIT) M-B TRAP)
   (ERROR-TABLE ARRAY-HAS-NO-LEADER M-A XFARY-RESTART)
	((VMA-START-READ) SUB M-A (A-CONSTANT 2))	;REF FILL POINTER
	(CHECK-PAGE-READ)			;NO TRANSPORT SINCE JUST TOUCHED HEADER
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
			Q-DATA-TYPE READ-MEMORY-DATA TRAP-UNLESS-FIXNUM)
   (ERROR-TABLE FILL-POINTER-NOT-FIXNUM M-A XFARY-RESTART)
	((M-Q) Q-POINTER READ-MEMORY-DATA)	;THIS ONE GETS RELOCATED IF INDIRECT ARY
	((A-FARY-TEM) Q-TYPED-POINTER READ-MEMORY-DATA)  ;NOT CLOBBERED BY ARY ROUTINES
						;THIS COPY USED FOR INCREMENTING AND 
						;STORING BACK
	(CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B 
			 DSP-ARRAY-SETUP)
	(JUMP-GREATER-OR-EQUAL M-Q A-S POP-THEN-XFALSE)	;INDEX OUT OF BOUNDS, RETURN NIL,
							; DON'T STORE
	((VMA) SUB M-A (A-CONSTANT 2))		;KNOW WILL WIN NOW, MUNG
	((WRITE-MEMORY-DATA-START-WRITE) ADD A-FARY-TEM M-ZERO ALU-CARRY-IN-ONE)
	(CHECK-PAGE-WRITE)
	(DISPATCH-CALL (LISP-BYTE %%ARRAY-TYPE-FIELD) M-B 
			ARRAY-TYPE-FILL-DISPATCH)
   (ERROR-TABLE BAD-ARRAY-TYPE M-B)
	; ((M-T) A-FARY-TEM) and discard top of stack.
	(POPJ-AFTER-NEXT 	;RETURN ELEMENT NUMBER STORED INTO.
	 (M-T) SETA A-FARY-TEM C-PDL-BUFFER-POINTER-POP)
       ((M-T) IOR (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)) M-T)

XFALAR	((A-TEM1) M-Q)			;HERE FROM ARRAY-TYPE-FILL-DISPATCH FOR Q-LIST-ARRAY
	((VMA) ADD A-TEM1 M-E)		;MUST HACK CDR CODES
	((WRITE-MEMORY-DATA-START-WRITE)  ;NO TRANSPORTER HACKERY NEEDED SINCE ADDRESSING
	     DPB M-T Q-TYPED-POINTER      ;A "FRESH" Q.
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	(CHECK-PAGE-WRITE)
	(GC-WRITE-TEST)
	(POPJ-EQUAL A-FARY-TEM M-ZERO)	;FIRST ENTRY, DO NOTHING
	((VMA-START-READ) SUB VMA (A-CONSTANT 1))	;NO TRANSPORT NEEDED (JUST FIDDLING
	(CHECK-PAGE-READ)		                ;CDR CODE)
	(POPJ-AFTER-NEXT
	 (WRITE-MEMORY-DATA-START-WRITE)
	     DPB READ-MEMORY-DATA Q-TYPED-POINTER
		    (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
       (CHECK-PAGE-WRITE)

   (MISC-INST-ENTRY STORE-ARRAY-LEADER)
XSALDR	(CALL XFLAD1)		;STORE IN ARRAY LEADER
  (ERROR-TABLE CALLS-SUB STORE-ARRAY-LEADER)
;NEEDS TRANSPORTER HACKERY HERE IF ONE-Q-FORWARD S IN ARRAY-LEADERS ARE TO BE SUPPORTED.
XSALDR-AREFI
	((M-T WRITE-MEMORY-DATA-START-WRITE) 
		Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-WRITE)		;SEQ BRK O.K. HERE
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

   (MISC-INST-ENTRY ARRAY-LEADER)
XFALDR	(CALL XFLAD1)			;FETCH ELEMENT IN ARRAY LEADER
  (ERROR-TABLE CALLS-SUB ARRAY-LEADER)
XFALDR-AREFI
	((VMA-START-READ) VMA)
	(CHECK-PAGE-READ)		;SEQ BRK O.K. HERE
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

XFLAD1-RESTART
    (ERROR-TABLE RESTART XFLAD1-RESTART)
	(CALL GAHDR)
	(JUMP XFLAD1-RESTART-1)
;Pop index and array off stack, and return in VMA the address
;of the slot in the leader specified by the index.
XFLAD1	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM) ;COMPUTE ADDRESS
   (ERROR-TABLE ARGTYP FIXNUM PP 1)
   (ERROR-TABLE ARG-POPPED 0 PP PP)
	((M-Q) Q-POINTER C-PDL-BUFFER-POINTER-POP)		;OR ARRAY LEADER ELEMENT
	(CALL-XCT-NEXT GAHDR)
       ((M-A) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
   (ERROR-TABLE ARG-POPPED 0 M-A M-Q)
XFLAD1-RESTART-1
	(CALL-IF-BIT-CLEAR (LISP-BYTE %%ARRAY-LEADER-BIT) M-B TRAP)	;NO LEADER
   (ERROR-TABLE ARRAY-HAS-NO-LEADER M-A XFLAD1-RESTART)
   (ERROR-TABLE RESTART XFLAD1-A)
   (ERROR-TABLE ARG-POPPED 0 M-Q)
	((VMA-START-READ) SUB M-A (A-CONSTANT 1))	;GET LENGTH OF ARRAY LEADER
	(CHECK-PAGE-READ)	;NO TRANSPORT SINCE JUST TOUCHED HEADER
	((A-TEM1) (LISP-BYTE %%ARRAY-LEADER-LENGTH) READ-MEMORY-DATA)
	(CALL-GREATER-OR-EQUAL M-Q A-TEM1 TRAP)		;SUBSCRIPT OUT OF BOUNDS
   (ERROR-TABLE SUBSCRIPT-OOB M-Q RMD XFLAD1-A)
   (ERROR-TABLE ARG-POPPED 0 M-A M-Q)
	(POPJ-AFTER-NEXT (A-TEM1) ADD M-Q (A-CONSTANT 2))
       ((VMA) SUB M-A A-TEM1)

XAHLP  (MISC-INST-ENTRY ARRAY-HAS-LEADER-P)
	(CALL GAHDRA)
  (ERROR-TABLE CALLS-SUB ARRAY-HAS-LEADER-P)
  ;; The following is ok because the arg is, unchanged, in M-A
  ;; at the time when GAHRDA might get an error,
  ;; and we don't need to worry about it after GAHDRA returns.
  (ERROR-TABLE ARG-POPPED 0 M-A)
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ARRAY-LEADER-BIT) M-B XFALSE)
	(JUMP XTRUE)

XAPLD (MISC-INST-ENTRY AP-LEADER)	;RETURN LOCATIVE POINTER TO LEADER ELEMENT
	(CALL XFLAD1)			;SET UP VMA
  (ERROR-TABLE CALLS-SUB AP-LEADER)
XAP1B	(POPJ-AFTER-NEXT 
	 (M-T) DPB VMA Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
       (NO-OP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS COPY-ARRAY-CONTENTS-AND-LEADER M-C M-T)

XCARCL (MISC-INST-ENTRY COPY-ARRAY-CONTENTS-AND-LEADER)
	((M-T) C-PDL-BUFFER-POINTER-POP)		;TO
	((M-C) C-PDL-BUFFER-POINTER-POP)		;FROM
	(CALL-XCT-NEXT GALPTR)
       ((M-A) M-C)
	((M-Q) M-S)					;LENGTH OF FROM LEADER
	((M-J) M-E)					;HIGH ADDRESS OF FROM LEADER
	(CALL-XCT-NEXT GALPTR)
       ((M-A) M-T)
	((M-I) A-ZERO)					;CURRENT ARRAY LEADER INDEX
XCALD1	(JUMP-GREATER-OR-EQUAL M-I A-S XCARC0)		;TO LEADER DONE, GO COPY DATA
	(JUMP-GREATER-OR-EQUAL-XCT-NEXT M-I A-Q XCALD2)
       ((WRITE-MEMORY-DATA) A-V-NIL)			;IF FROM LEADER EXHAUSTED, USE NIL
	((VMA-START-READ) M-J)				;GET FROM ARRAY LEADER ITEM
	(CHECK-PAGE-READ)
	((M-J) SUB M-J (A-CONSTANT 1))
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	;((WRITE-MEMORY-DATA) READ-MEMORY-DATA)
XCALD2	((VMA-START-WRITE) M-E)				;STORE IN TO ARRAY LEADER ITEM
	(CHECK-PAGE-WRITE)				;NO TRANSP HERE SINCE TOUCHED HEADER?
	(GC-WRITE-TEST)
	((M-E) SUB M-E (A-CONSTANT 1))
	(JUMP-XCT-NEXT XCALD1)
       ((M-I) ADD M-I (A-CONSTANT 1))

;(COPY-ARRAY-PORTION FROM-ARRAY FROM-START FROM-END TO-ARRAY TO-START TO-END)
;IF THE TO-LENGTH IS LONGER IT FILLS WITH 0 OR NIL
;;;??? This one is hard to remember the args for.
XCAP (MISC-INST-ENTRY COPY-ARRAY-PORTION)
	((M-R) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;TO-END
	(CALL-XCT-NEXT GAHDRA)
       ((M-Q) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;TO-START
  (ERROR-TABLE CALLS-SUB COPY-ARRAY-PORTION)
	((M-R) SUB M-R A-Q)				;DON'T GET SCREWED BY DSP-ARRAY-SETUP
	(CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B DSP-ARRAY-SETUP)
	((M-R) ADD M-R A-Q)
	((M-I) M-Q)					;TO-INDEX
	(CALL-GREATER-THAN M-R A-S TRAP)		;TO-LENGTH IN M-R MUST BE IN-BOUNDS
  (ERROR-TABLE SUBSCRIPT-OOB M-R M-S)
	((M-C) M-E)					;TO-ADDRESS
	((M-K) M-B)					;TO-ARRAY-HEADER
	((M-T) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;FROM-END
	(CALL-XCT-NEXT GAHDRA)
       ((M-Q) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;FROM-START
  (ERROR-TABLE CALLS-SUB COPY-ARRAY-PORTION)
	((M-T) SUB M-T A-Q)				;DON'T GET SCREWED BY DSP-ARRAY-SETUP
	(CALL-IF-BIT-SET (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B DSP-ARRAY-SETUP)
	((M-T) ADD M-T A-Q)
	(CALL-GREATER-THAN M-T A-S TRAP)		;FROM-LENGTH IN M-T MUST BE IN-BOUNDS
  (ERROR-TABLE SUBSCRIPT-OOB M-T M-S)
	(JUMP-XCT-NEXT XCARC1)
       ((M-S) M-T)

;NOTE:  AN OPTIMIZATION TO DO IT WORD BY WORD MIGHT BE HANDY...
XCARC (MISC-INST-ENTRY COPY-ARRAY-CONTENTS)
	((M-T) C-PDL-BUFFER-POINTER-POP)		;TO
	((M-C) C-PDL-BUFFER-POINTER-POP)		;FROM
XCARC0	(CALL-XCT-NEXT GADPTR)
       ((M-A) M-T)
  (ERROR-TABLE CALLS-SUB COPY-ARRAY-CONTENTS)
  (ERROR-TABLE ARG-POPPED 0 M-C M-T)
	((M-A) M-C)					;FROM-ARRAY
	((M-R) M-S)					;TO LENGTH
	((M-C) M-E)					;TO ADDRESS
	((M-I) M-Q)					;TO INITIAL INDEX
	(CALL-XCT-NEXT GADPTR)
       ((M-K) M-B)					;TO ARRAY HEADER
  (ERROR-TABLE CALLS-SUB COPY-ARRAY-CONTENTS)
  (ERROR-TABLE ARG-POPPED 0 M-A M-T)
XCARC1	(JUMP-GREATER-OR-EQUAL M-I A-R XTRUE)		;TO ARRAY DONE, RETURN
	(JUMP-GREATER-OR-EQUAL M-Q A-S XCARC3)		;JUMP IF FROM ARRAY EXHAUSTED
	(DISPATCH-CALL-XCT-NEXT				;M-T := FROM ITEM, CLOBBER M-J
		(LISP-BYTE %%ARRAY-TYPE-FIELD) M-B ARRAY-TYPE-REF-DISPATCH)
   (ERROR-TABLE BAD-ARRAY-TYPE M-B)
XCARC4 ((C-PDL-BUFFER-POINTER-PUSH) Q-POINTER M-Q
			(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-D) M-E)
	((M-Q) M-I)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC XCARC5)))
	(DISPATCH-XCT-NEXT (LISP-BYTE %%ARRAY-TYPE-FIELD) M-K ARRAY-TYPE-STORE-DISPATCH)
   (ERROR-TABLE BAD-ARRAY-TYPE M-K)
       ((M-E) M-C)
XCARC5	((M-I) ADD M-I (A-CONSTANT 1))
	((M-Q) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-Q) ADD M-Q (A-CONSTANT 1))
	(JUMP-XCT-NEXT XCARC1)
       ((M-E) M-D)

;COMPUTE FILLER VALUE IN M-T, REENTER AT XCARC4
;THIS USED TO PAD STRINGS WITH 200, BUT THAT WAS A CROCK
XCARC3	((M-T) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))	;Zero for numeric array
	(DISPATCH (LISP-BYTE %%ARRAY-TYPE-FIELD) M-K SKIP-IF-NUMERIC-ARRAY)
	 ((M-T) A-V-NIL)			;NIL for non-numeric
	(JUMP XCARC4)

;GET ADDRESS AND LENGTH OF ARRAY LEADER
GALPTR	(CALL GAHDR)
	((M-E) SUB M-A (A-CONSTANT 2))		;ADDRESS
	(POPJ-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%ARRAY-LEADER-BIT) M-B)
       ((M-S) A-ZERO)				;LENGTH
	((VMA-START-READ) SUB M-A (A-CONSTANT 1))	;NO TRANSPORT SINCE JUST TOUCHED HEADER
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT
	 (M-S) (LISP-BYTE %%ARRAY-LEADER-LENGTH) READ-MEMORY-DATA)
       (NO-OP)

;Get address, length, and initial index of an array.
;Like GAHDR, but processes displacing and indirection of arrays.
GADPTR	(CALL GAHDR)
	(POPJ-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%ARRAY-DISPLACED-BIT) M-B)
       ((M-Q) A-ZERO)
	(JUMP DSP-ARRAY-SETUP)


;UCODE-AR-1-SETUP prepares an array for microcode access.  The first argument gives the
;array, the second the starting element and the third argument the number of elements.
;This calls the system microcode, which may have side-effects.  The following are returned:
; M-A the array, M-E base address, VMA word address, M-Q first index, M-K last index,
; M-D first dimension, M-S product of dimensions, M-B array header, M-T first element of array
; Preserves: M-C, M-I, M-R, M-ZR (if the system microcode does!).
;
UCODE-AR-1-SETUP
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
   (ERROR-TABLE ARGTYP FIXNUM PP NIL NIL UCODE-AR-1-SETUP)	;bless number of elements
	((M-TEM) SUB C-PDL-BUFFER-POINTER-POP (A-CONSTANT 1))	;M-TEM: first-last offset
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
   (ERROR-TABLE ARGTYP FIXNUM PP NIL NIL UCODE-AR-1-SETUP)	;bless first element
        ((M-K) ADD C-PDL-BUFFER-POINTER A-TEM)			;add first to get last
	((C-PDL-BUFFER-POINTER)					;Store last index
		Q-POINTER M-K (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(CALL-XCT-NEXT XAR-1)
       ((M-K) SUB M-K A-TEM)					;Reconstruct first index
   (ERROR-TABLE CALLS-SUB UCODE-AR-1-SETUP)
	((C-PDL-BUFFER-POINTER-PUSH) M-A)			;repush array
	((C-PDL-BUFFER-POINTER-PUSH) M-K)			;push saved first
	(JUMP-XCT-NEXT XAR-1)					;"call" AR-1 for first index
       ((M-K) M-Q)						;save index to last word

))

