;-*-Mode:Midas-*-

(SETQ UC-CALL-RETURN '(
;;; Push a micro-to-macro call block (just the first 3 words, not the function)
;;; in the case where ADI has been pushed
P3ADI	(JUMP-XCT-NEXT P3ZER1)
       ((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (PLUS 
		(BYTE-VALUE Q-DATA-TYPE DTP-FIX)
		(BYTE-VALUE %%LP-CLS-ADI-PRESENT 1))))

;;; Push a micro-to-macro call block (just the first 3 words, not the function)
P3ZERO	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT 
		(BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
P3ZER1	((M-ZR) ADD PDL-BUFFER-POINTER	;1- because of push just done
		 (A-CONSTANT (EVAL (1- %LP-CALL-BLOCK-LENGTH))))
	((M-TEM) SUB M-ZR A-IPMARK)
	((A-TEM1) DPB M-TEM (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK)
		(A-CONSTANT (BYTE-VALUE %%LP-CLS-DESTINATION D-MICRO)))
	((M-TEM) SUB M-ZR A-AP)
	((A-TEM1) DPB M-TEM (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) A-TEM1)
	((C-PDL-BUFFER-POINTER)		;IOR with LPCLS Q already pushed
		IOR C-PDL-BUFFER-POINTER A-TEM1)
	((C-PDL-BUFFER-POINTER-PUSH)	;Push LPEXS Q
	    (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(POPJ-AFTER-NEXT		;Push LPENS Q
	  (C-PDL-BUFFER-POINTER-PUSH)
	    (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
       ((A-IPMARK) (BYTE-FIELD 10. 0) M-ZR)	;Caller must push LPFEF Q


;;; Calling a function of strange data-type.  Call the interpreter (APPLY-LAMBDA).

INTP1	;; Finish the frame for the interpreted function
	(CALL FINISH-ENTERED-FRAME)
	(CALL-IF-BIT-SET M-TRAP-ON-CALLS QMRCL-TRAP)
	;; Get the arg-list.  Could be passed by FEXPR/LEXPR call, could be
	;; NIL, or could be a stack-list of the spread arguments.
	(JUMP-EQUAL M-R A-ZERO INTP1A)		;NO ARGS
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)	;TO VIRTUAL ADDRESS
       ((M-K) ADD A-ZERO M-AP ALU-CARRY-IN-ONE)
	((M-T) DPB M-K Q-POINTER
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))	;ARG LIST PTR
INTP1B	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
	(JUMP-IF-BIT-SET (LISP-BYTE %%LP-CLS-ADI-PRESENT) C-PDL-BUFFER-INDEX INTP5) ;check ADI
INTP9	(CALL P3ZERO)					;Open micro-to-macro call block
	((ARG-CALL REF-SUPPORT-VECTOR) (I-ARG SVCAPL))	;Get function cell of APPLY-LAMBDA
	((C-PDL-BUFFER-POINTER-PUSH) READ-MEMORY-DATA)	;Push it
	((PDL-BUFFER-INDEX) M-AP)
	((C-PDL-BUFFER-POINTER-PUSH) DPB C-PDL-BUFFER-INDEX	;Arg 1 = fcn being called
		Q-ALL-BUT-CDR-CODE (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-T			;Arg 2 = arg list
		Q-ALL-BUT-CDR-CODE (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	((ARG-JUMP MMJCALR) (I-ARG 2))		;Call to D-RETURN

INTP1A	(JUMP-XCT-NEXT INTP1B)
       ((M-T) A-V-NIL)			;ARG LIST IS NIL

;Sending ADI call to interpreter.  Check for LEXPR/FEXPR call.
INTP5	((PDL-BUFFER-INDEX M-I) SUB M-S (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH)))
	((M-B) PDL-BUFFER-POINTER)	;SAVE STACK POSITION OF LAST ARG (SEE INTP20)
INTP6	(DISPATCH (LISP-BYTE %%ADI-TYPE) C-PDL-BUFFER-INDEX INTP-ADI-DISPATCH)

(LOCALITY D-MEM)
(START-DISPATCH 3 INHIBIT-XCT-NEXT-BIT)
INTP-ADI-DISPATCH
	(P-BIT ILLOP)	;ERR
	(INTP7)		;MULTIPLE-VALUE-RETURN
	(INTP7)		;RESTART-PC
	(INTP20)	;FEXPR CALL
	(INTP20)	;LEXPR CALL
  (REPEAT 3 (P-BIT ILLOP))
(END-DISPATCH)
(LOCALITY I-MEM)

INTP7	((PDL-BUFFER-INDEX M-I) SUB M-I (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX INTP9)
	(JUMP-XCT-NEXT INTP6)
       ((PDL-BUFFER-INDEX M-I) SUB M-I (A-CONSTANT 1))

;HERE IF LAST SLOT HAS REST ARG.
INTP20	((PDL-BUFFER-INDEX) M-B)	;SAVED PDL POSITION OF LAST ARG
	(JUMP-GREATER-THAN M-R (A-CONSTANT 1) INTP21)
	(JUMP-XCT-NEXT INTP7)		;FIRST (AND LAST) SLOT IS ALREADY LIST OF ARGS
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX) ;SO REPLACE LIST-OF-ARGS POINTER WITH IT.

;GET HERE IF FCTN WAS CALLED WITH BOTH SPREAD AND REST ARGS.  MUNGE CDR CODES
; OF LAST SPREAD ARG AND THE REST ARG TO FULL-NODE, THUS NCONC ING THEM TOGETHER.
INTP21	((C-PDL-BUFFER-INDEX) DPB C-PDL-BUFFER-INDEX Q-ALL-BUT-CDR-CODE 
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-ERROR)))		;REST ARG
	((PDL-BUFFER-INDEX) SUB M-B (A-CONSTANT 1))		;TO POINT TO LAST SPREAD ARG
	(JUMP-XCT-NEXT INTP7)
       ((C-PDL-BUFFER-INDEX) DPB C-PDL-BUFFER-INDEX Q-ALL-BUT-CDR-CODE 
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NORMAL)))

REF-SUPPORT-VECTOR	
	((VMA-START-READ) ADD READ-I-ARG A-V-SUPPORT-ENTRY-VECTOR)
	(CHECK-PAGE-READ)
	(POPJ-after-next dispatch transport md)
       (no-op)

;;; This code is also duplicated at QLENTR and QME1 to save time.
;;; Make the new frame current, maintain pdl buffer, store arg count into frame.
;;; Note that the frame being entered may already be in M-AP!
FINISH-ENTERED-FRAME
	((PDL-BUFFER-INDEX) SUB M-S A-AP)	;Increment to M-AP (truncated to 10 bits)
	((M-PDL-BUFFER-ACTIVE-QS) ADD PDL-BUFFER-INDEX A-PDL-BUFFER-ACTIVE-QS)
	(CALL-GREATER-THAN-XCT-NEXT M-PDL-BUFFER-ACTIVE-QS 
			   A-PDL-BUFFER-HIGH-WARNING PDL-BUFFER-DUMP)
       ((M-AP) M-S)
	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
       ((C-PDL-BUFFER-INDEX) DPB M-R (LISP-BYTE %%LP-ENS-NUM-ARGS-SUPPLIED)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

;CALLING NUMBER AS FUNCTION
NUMBER-CALLED-AS-FUNCTION
	(CALL FINISH-ENTERED-FRAME)
	(CALL-IF-BIT-SET M-TRAP-ON-CALLS QMRCL-TRAP)
	(CALL TRAP)
    (ERROR-TABLE NUMBER-CALLED-AS-FUNCTION M-A)
	(JUMP-xct-next CSM-6)
       ((M-T) M-A)

;CALLING SYMBOL AS FUNCTION
QMRCL1	((VMA-START-READ) ADD M-A		;GET FUNCTION CELL
		(A-CONSTANT 2))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-TEM) SUB MICRO-STACK-PNTR-AND-DATA-POP
		(A-CONSTANT 1))	;Low 14 bits get address of QMRCL dispatcher.
	((PDL-BUFFER-INDEX) M-S)	;May have been clobbered by TRANS-TRAP.
	((OA-REG-LOW) DPB M-TEM OAL-JUMP A-ZERO)
	(JUMP-XCT-NEXT 0)		;Unskip and redispatch
       ((C-PDL-BUFFER-INDEX M-A) READ-MEMORY-DATA)	;Store new frob to call

;DON'T CALL QBND4 TO AVOID REFERENCING A-SELF VIA SLOW VIRTUAL-MEMORY PATH
BIND-SELF	;Bind SELF to M-A
	((M-TEM) ADD (M-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) A-QLBNDP)
	((M-TEM) SUB M-TEM A-QLBNDH)
	(CALL-IF-BIT-CLEAR BOXED-SIGN-BIT M-TEM TRAP)
	    (ERROR-TABLE PDL-OVERFLOW SPECIAL)
	(JUMP-IF-BIT-SET-XCT-NEXT M-QBBFL BIND-SELF-1)
       ((M-TEM WRITE-MEMORY-DATA) DPB M-MINUS-ONE
	       (LISP-BYTE %%SPECPDL-CLOSURE-BINDING) A-SELF)
	((WRITE-MEMORY-DATA) DPB (M-CONSTANT -1) (LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) A-TEM) ;START NEW BINDING BLOCK
	((M-QBBFL) DPB (M-CONSTANT -1) A-FLAGS)
BIND-SELF-1
	((VMA-START-WRITE) A-QLBNDP M+A+1 M-ZERO)	;STORE PREVIOUS CONTENTS
	(CHECK-PAGE-WRITE)		;NO SEQ BRK HERE
	((A-QLBNDP) ADD VMA (A-CONSTANT 1))
	((A-SELF) Q-TYPED-POINTER M-A)
	((WRITE-MEMORY-DATA)		;LOCATIVE POINTER TO BOUND LOCATION
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  LOWEST-A-MEM-VIRTUAL-ADDRESS
				  (A-MEM-LOC A-SELF))))
	(POPJ-AFTER-NEXT (VMA-START-WRITE) A-QLBNDP)
       (CHECK-PAGE-WRITE)

;Bind SELF-MAPPING-TABLE to M-B
BIND-SELF-MAP
	((M-TEM) ADD (M-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) A-QLBNDP)
	((M-TEM) SUB M-TEM A-QLBNDH)
	(CALL-IF-BIT-CLEAR BOXED-SIGN-BIT M-TEM TRAP)
	    (ERROR-TABLE PDL-OVERFLOW SPECIAL)
	(JUMP-IF-BIT-SET-XCT-NEXT M-QBBFL BIND-SELF-MAP-1)
       ((M-TEM WRITE-MEMORY-DATA) DPB M-MINUS-ONE
	         (LISP-BYTE %%SPECPDL-CLOSURE-BINDING) A-SELF-MAPPING-TABLE)
	((WRITE-MEMORY-DATA) DPB (M-CONSTANT -1) (LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) A-TEM) ;START NEW BINDING BLOCK
	((M-QBBFL) DPB (M-CONSTANT -1) A-FLAGS)
BIND-SELF-MAP-1
	((VMA-START-WRITE) M+A+1 A-QLBNDP M-ZERO)	;STORE PREVIOUS CONTENTS
	(CHECK-PAGE-WRITE)		;NO SEQ BRK HERE
	((A-QLBNDP) ADD VMA (A-CONSTANT 1))
	((A-SELF-MAPPING-TABLE) Q-TYPED-POINTER M-B)
	((WRITE-MEMORY-DATA)		;LOCATIVE POINTER TO BOUND LOCATION
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  LOWEST-A-MEM-VIRTUAL-ADDRESS
				  (A-MEM-LOC A-SELF-MAPPING-TABLE))))
	(POPJ-AFTER-NEXT (VMA-START-WRITE) A-QLBNDP)
       (CHECK-PAGE-WRITE)

;Calling an instance as a function.  Bind SELF to it, bind its instance-variables
;to its value slots, then call its handler function.
CALL-INSTANCE
	(CALL FINISH-ENTERED-FRAME)     ;Keep active frames and specpdl blocks in phase.
	(CALL BIND-SELF)
	((VMA-START-READ) M-A)		;Get instance header
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE-HEADER)) TRAP)
		(ERROR-TABLE DATA-TYPE-SCREWUP DTP-INSTANCE-HEADER)
	((M-A) VMA)			;Possibly-forwarded instance is where inst vars are
	((M-C) Q-POINTER READ-MEMORY-DATA	;Get address of instance-descriptor
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	((VMA-START-READ) ADD M-C (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-BINDINGS)))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)
	(JUMP-EQUAL M-T A-V-NIL CALL-INSTANCE-3)	;() => no bindings
	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)
	 (CALL TRAP)			;Other cases not implemented yet
		(ERROR-TABLE DATA-TYPE-SCREWUP %INSTANCE-DESCRIPTOR-BINDINGS)
	((M-D) Q-POINTER M-A
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-EXTERNAL-VALUE-CELL-POINTER)))
;This loop depends on the fact that the bindings list is cdr-coded,
;and saves time and register-shuffling by not calling CAR and CDR.
;However, it does check to make sure that this assumption is true.
CALL-INSTANCE-1				;Bind them up
	((VMA-START-READ) M-T)		;Get locative to location to bind
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE MD)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) CALL-INSTANCE-4)
	((VMA-START-READ M-B) READ-MEMORY-DATA)	;Get current binding
	(CHECK-PAGE-READ)
       ((M-D) ADD M-D (A-CONSTANT 1))	;Points to next value slot
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)
	((M-TEM) Q-TYPED-POINTER READ-MEMORY-DATA)
	(JUMP-EQUAL M-D A-TEM CALL-INSTANCE-2)	;Already there, avoid re-binding
	(CALL QBND4-CLOSURE)			;Bind it up
	((WRITE-MEMORY-DATA-START-WRITE) Q-TYPED-POINTER M-D A-E)
	(CHECK-PAGE-WRITE-BIND)
CALL-INSTANCE-2
	(DISPATCH Q-CDR-CODE M-B D-CALL-INSTANCE)	;More bindings if this was CDR-NEXT
		(ERROR-TABLE DATA-TYPE-SCREWUP CDR-CODE-IN-INSTANCE-BINDINGS)
       ((M-T) ADD M-T (A-CONSTANT 1))
CALL-INSTANCE-3				;Next removes possible garbage pointer from M-T
	((VMA-START-READ M-T) ADD M-C (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-FUNCTION)))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-T) Q-DATA-TYPE READ-MEMORY-DATA)
	(JUMP-EQUAL M-T (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) CALL-INSTANCE-ARRAY)
	(JUMP-XCT-NEXT QCLS2)
       ((M-A) READ-MEMORY-DATA)

;Fixnum in flavor's bindings list.
;Its value is the number of instance slots to skip over and not bind.
;We assume that this is not the last element of the bindings list!
CALL-INSTANCE-4
	((M-TEM) Q-POINTER MD)
	((M-D) ADD M-D A-TEM)
	(JUMP-xct-next CALL-INSTANCE-1)
       ((M-T) ADD M-T (A-CONSTANT 1))

;Here to call an instance whose descriptor's function is an array
;rather than a dtp-select-method.
;We treat the array as a hash array and expect to find in it
;a locative pointing to a function cell.  We call what is in that cell.
;If we don't find the operation in the hash table, we call a method failure function
;from the support vector (SVCFMETH).

;These arrays are not supposed to be forwarded.
;We make a check to see if it is forwarded; if so, we treat it as a hash failure.
;The hash failure function will eliminate the forwarding and try again.

(ASSIGN %HASH-TABLE-MODULUS -6)

;Enter here if the hash table itself is called by the user as a function.
;M-Q is the I-ARG specified in the dispatch on D-QMRCL.
;If it is zero, we should do a "leave" which was inhibited in the dispatch.
CALL-HASH-TABLE
	((M-S) A-IPMARK)
	(JUMP-NOT-EQUAL M-Q A-ZERO CALL-HASH-TABLE-1)
	(CALL MLLV)
CALL-HASH-TABLE-1
	(CALL FINISH-ENTEED-FRAME)     ;Keep active frames and specpdl blocks in phase.
	((MD) M-A)

;Enter here from calling an instance as a function.
;The hash array is presently MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE MD)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) CALL-INSTANCE-4)
	((VMA-START-READ M-B) READ-MEMORY-DATA)	;Get current binding
	(CHECK-PAGE-READ)
       ((M-D) ADD M-D (A-CONSTANT 1))	;Points to next value slot
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)
	((M-TEM) Q-TYPED-POINTER READ-MEMORY-DATA)
	(JUMP-EQUAL M-D A-TEM CALL-INSTANCE-2)	;Already there, avoid re-binding
	(CALL QBND4-CLOSURE)			;Bind it up
	((WRITE-MEMORY-DATA-START-WRITE) Q-TYPED-POINTER M-D A-E)
	(CHECK-PAGE-WRITE-BIND)
CALL-INSTANCE-2
	(DISPATCH Q-CDR-CODE M-B D-CALL-INSTANCE)	;More bindings if this was CDR-NEXTSH-FAILURE)
;M-3 gets the length of the hash table in entries.
;That is a power of 2, we assume.
;M-1 gets a number one less, a mask of bits.
	((M-3) Q-POINTER MD)
	((M-1) SUB M-3 (A-CONSTANT 1))
;Look at the array header, and make M-T point at the first word of array contents.
;No need to transport the header; we already know the array isn't forwarded.
	((VMA-START-READ) M-B)
	(CHECK-PAGE-READ)
	((M-2) (LISP-BYTE %%ARRAY-LONG-LENGTH-FLAG) MD)
	((M-T) M+A+1 M-B A-2)
;Get the first arg (the operation, used as the hash key) into M-C.
	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT 1))
	((M-C) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
;Compute the hash code
;	((M-2) DPB M-C (LISP-BYTE 0325))
;This change will lose with system 89.
	((M-2) Q-POINTER M-C)
	((M-1) AND M-1 A-2)
;Triple it to get the starting index into the array.
	((M-2) ADD M-1 A-1)
	((M-2) ADD M-1 A-2)
	((VMA) ADD M-T A-2)
;VMA points to the next hash table entry's key.
;M-1 is the index in the hash table, in units of entries (1/3 of index in words).
CALL-INSTANCE-ARRAY-SEARCH
	((VMA-START-READ) VMA)
	(CHECK-PAGE-READ)
	((M-2) Q-TYPED-POINTER MD)
;Jump if find the desired key.
;No need to transport -- if key is in old space, we need to rehash the array,
;which will be done by the hash failure function.
	(JUMP-EQUAL M-2 A-C CALL-INSTANCE-KEY-FOUND)
;Jump if we are sure the key is not to be found.
	(JUMP-EQUAL M-2 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-NULL)) CALL-INSTANCE-HASH-FAILURE)
	((M-1) ADD M-1 (A-CONSTANT 1))
	(JUMP-LESS-THAN-XCT-NEXT M-1 A-3 CALL-INSTANCE-ARRAY-SEARCH)
       ((VMA) ADD VMA (A-CONSTANT 3))
;At end of hash table, wrap to beginning.
	((VMA) M-T)
	(JUMP-xct-next CALL-INSTANCE-ARRAY-SEARCH)
       ((M-1) A-ZERO)

CALL-INSTANCE-KEY-FOUND
	((VMA-START-READ M-B) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	;; The array word should be a locative to a cell containing a function.
	;; Get the function.
	((VMA-START-READ) MD)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	((M-T) q-typed-pointer MD)			;Put function to call in M-T.
	((VMA-START-READ) ADD M-B (A-CONSTANT 1))	;Assumes no ONE-Q-FORWARDs in the hash table.
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-B) Q-TYPED-POINTER MD)
	(JUMP-EQUAL M-B A-V-NIL CSM-6)		;If non-nil mapping table found,
	(CALL BIND-SELF-MAP)			;bind SELF-MAPPING-TABLE to it.
;Bind flag in stack frame saying we have provided the self map;
;but not if the function is a symbol.
	((M-TEM) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-SYMBOL)) CSM-6)
	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-B) C-PDL-BUFFER-INDEX)
	((C-PDL-BUFFER-INDEX)
	 DPB (LISP-BYTE %%LP-CLS-SELF-MAP-PROVIDED)
	 (M-CONSTANT -1) A-B)
	(JUMP CSM-6)				;Put function in M-T into stack frame and call.

CALL-INSTANCE-HASH-FAILURE
	((ARG-CALL REF-SUPPORT-VECTOR) (I-ARG SVCFMETH))
	(JUMP-XCT-NEXT QCLS2)
       ((M-A) q-typed-pointer MD)

;CALLING ENTITY AS FUNCTION.  BIND SELF THEN TURN INTO CLOSURE CALL.
;DON'T CALL QBND4 TO AVOID REFERENCING A-SELF VIA SLOW VIRTUAL-MEMORY PATH
CALL-ENTITY
	(CALL FINISH-ENTERED-FRAME)     ;Keep active frames and specpdl blocks in phase.
	(CALL BIND-SELF)
	((WRITE-MEMORY-DATA) DPB M-MINUS-ONE
	 (LISP-BYTE %%SPECPDL-CLOSURE-BINDING) A-METHOD-SUBROUTINE-POINTER)
	((A-QLBNDP) ADD M-ZERO A-QLBNDP ALU-CARRY-IN-ONE)
	((VMA-START-WRITE) A-QLBNDP)	;STORE PREVIOUS CONTENTS
	(CHECK-PAGE-WRITE)		;NO SEQ BRK HERE
	((A-QLBNDP) ADD M-ZERO A-QLBNDP ALU-CARRY-IN-ONE)
	((WRITE-MEMORY-DATA)		;LOCATIVE POINTER TO BOUND LOCATION
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  LOWEST-A-MEM-VIRTUAL-ADDRESS
				  (A-MEM-LOC A-METHOD-SUBROUTINE-POINTER))))
	((VMA-START-WRITE) A-QLBNDP)
	(CHECK-PAGE-WRITE)
	((WRITE-MEMORY-DATA) DPB M-MINUS-ONE
	 (LISP-BYTE %%SPECPDL-CLOSURE-BINDING) A-METHOD-SEARCH-POINTER)
	((A-QLBNDP) ADD M-ZERO A-QLBNDP ALU-CARRY-IN-ONE)
	((VMA-START-WRITE) A-QLBNDP)	;STORE PREVIOUS CONTENTS
	(CHECK-PAGE-WRITE)		;NO SEQ BRK HERE
	((A-QLBNDP) ADD M-ZERO A-QLBNDP ALU-CARRY-IN-ONE)
	((WRITE-MEMORY-DATA)		;LOCATIVE POINTER TO BOUND LOCATION
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  LOWEST-A-MEM-VIRTUAL-ADDRESS
				  (A-MEM-LOC A-METHOD-SEARCH-POINTER))))
	((VMA-START-WRITE) A-QLBNDP)
	(CHECK-PAGE-WRITE)		;DROP INTO QCLS
;CALLING CLOSURE AS FUNCTION
QCLS	(CALL-XCT-NEXT QCAR)		;SEQ BRK IS OK HERE, ISNT IT?
       ((M-T C-PDL-BUFFER-POINTER-PUSH) Q-POINTER M-A
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	((PDL-BUFFER-INDEX) M-S)
	((C-PDL-BUFFER-INDEX M-A) M-T)	;REPLACE CLOSURE WITH CLOSED FCTN
	(CALL FINISH-ENTERED-FRAME)     ;Keep active frames and specpdl blocks in phase.
	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)	;GET BACK CLOSURE AND CDR IT.
	(CALL QCLS1)
QCLS2	((PDL-BUFFER-INDEX) M-S)
	(DISPATCH (I-ARG 1) Q-DATA-TYPE M-A D-QMRCL)
       (NO-OP)			;LEAVE, IF ANY, ALREADY DONE

QCLS1	(POPJ-EQUAL M-T A-V-NIL)	;Return if no bindings to do
	(CALL-XCT-NEXT QCAR)
       ((M-D) M-T)
	((M-B) M-T)			;Locn to bind
	(CALL-XCT-NEXT QCDR)
       ((M-T) M-D)
	(CALL-XCT-NEXT QCAR)		;Get new binding
       ((M-D) M-T)
	((VMA-START-READ) M-B)		;Get current binding
	(CHECK-PAGE-READ)
	((M-T) DPB M-T Q-POINTER        ;SWITCH DATA TYPE.. (DOING IT THIS WAY AVOIDS PROBLEMS
				        ;WITH CAR ABOVE AS WELL AS GENERALLY REDUCING 
					;PROFUSION OF FUNNY DATA TYPES)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-EXTERNAL-VALUE-CELL-POINTER)))
	(DISPATCH TRANSPORT-NO-EVCP-READ-WRITE READ-MEMORY-DATA)
	((M-TEM) Q-TYPED-POINTER READ-MEMORY-DATA)
	(JUMP-EQUAL M-T A-TEM QCLS3)	;Already there, avoid re-binding.  This saves on
					;special-pdl overflows in recursive message passing.
	(CALL QBND4-CLOSURE)		;Bind it up
	((WRITE-MEMORY-DATA-START-WRITE) Q-TYPED-POINTER M-T A-E)
	(CHECK-PAGE-WRITE-BIND)
QCLS3	(CALL-XCT-NEXT QCDR)
       ((M-T) M-D)
	(JUMP QCLS1)


CALL-SELECT-METHOD
	(CALL-EQUAL M-R A-ZERO TRAP)	;NOT ENUF ARGS
  (ERROR-TABLE ZERO-ARGS-TO-SELECT-METHOD M-A)
	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT 1))  ;FETCH MESSAGE KEY
	((M-C) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
	((M-B) A-V-NIL)		;HOLDS CONSTANT ON M-SIDE, FOR EASY COMPARISON
	((M-T) DPB M-A Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	(JUMP-EQUAL M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)) CSM-R)  ;RESUME
	((A-METHOD-SUBROUTINE-POINTER) A-V-NIL) ;"SUBROUTINE" CONTINUATION POINT, 
						;  OR NIL IF AT TOP LEVEL.
CSM-3	(CALL-XCT-NEXT QCAR)
       ((C-PDL-BUFFER-POINTER-PUSH) M-T)
	((M-ZR) Q-DATA-TYPE M-T)		;M-T HAS ASSQ-LIST ELEMENT
	(JUMP-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LIST)) CSM-1)   ;NOT METHOD-KEY, METHOD PAIR
	(CALL-XCT-NEXT QCAR)
       ((M-J) M-T)
	(JUMP-EQUAL M-T A-C CSM-2)		;FOUND IT
	((M-ZR) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LIST)) CSM-7)  ;ASSQ KEY A LIST, DO MEMQ ON IT
CSM-5	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-ZR) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LIST)) CSM-3)
	(JUMP-NOT-EQUAL M-B A-METHOD-SUBROUTINE-POINTER CSM-8A)   ;IF IN SUBROUTINE, RETURN.
	(JUMP-NOT-EQUAL M-T A-V-NIL CSM-6)   ;NON-NIL TERMINATION IS SUPERCLASS POINTER.
  ; USE IT TO REPLACE DTP-SELECT-METHOD AND REINVOKE. THE TWO COMMON CASES ARE (1) THIS SYMBOL
  ; IS A SUPERCLASS POINTER AND IT'S FUNCTION CELL CONTAINS A DTP-SELECT-METHOD.  THE SEARCH
  ; WILL CONTINUE. (2)  THIS SYMBOL IS A LISP FUNCTION AND WILL GET CALLED IN THE USUAL WAY.
  ; THIS SERVES AS AN "OTHERWISE" CLAUSE.
	(CALL TRAP)			;SELECTED METHOD NOT FOUND
  (ERROR-TABLE SELECTED-METHOD-NOT-FOUND M-A M-C)

CSM-R	(JUMP-XCT-NEXT CSM-5)		    ;RESUME SEARCH AT SAVED POINT
       ((C-PDL-BUFFER-POINTER-PUSH) A-METHOD-SEARCH-POINTER)  ;PUT IT WHERE CSM-5 EXPECT IT.

CSM-7	((C-PDL-BUFFER-POINTER-PUSH) M-A)   ;ASSQ KEY A LIST, DO MEMQ ON IT
	(CALL XMEMQ1)		    ; TAKES ARGS IN M-C, M-T.  Clobbers M-A.
	(JUMP-EQUAL-XCT-NEXT M-T A-V-NIL CSM-5)
       ((M-A) C-PDL-BUFFER-POINTER-POP)    ;RESTORE M-A
CSM-2	((A-METHOD-SEARCH-POINTER) C-PDL-BUFFER-POINTER-POP) ;SAVE IN CASE METHOD SEARCH
							     ; IS RESUMED.
	(CALL-XCT-NEXT QCDR)		   ;FOUND DESIRED METHOD KEY.  GET ASSOC FCTN
       ((M-T) M-J)                         ; FROM ASSQ ELEMENT.
CSM-6	((PDL-BUFFER-INDEX) M-S)
	((C-PDL-BUFFER-INDEX M-A) SELECTIVE-DEPOSIT C-PDL-BUFFER-INDEX 	;CLOBBER INTO
		Q-ALL-BUT-TYPED-POINTER A-T)	; LP-FEF SLOT, REPLACING DTP-SELECT-METHOD
	(DISPATCH (I-ARG 1) Q-DATA-TYPE M-A D-QMRCL)
       (NO-OP)

;GET HERE IF SELECT-METHOD LIST-ELEMENT NOT A CONS.
CSM-1	(CALL-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SYMBOL)) TRAP)
 (ERROR-TABLE SELECT-METHOD-GARBAGE-IN-SELECT-METHOD-LIST M-T)
   ;DO A ONE LEVEL "SUBROUTINE" CALL.  SAVE CONTINUATION POINTER IN M-B.
	(JUMP-NOT-EQUAL M-B A-METHOD-SUBROUTINE-POINTER CSM-8) ;ALREADY IN A SUBROUTINE, RETURN
	((A-METHOD-SUBROUTINE-POINTER) C-PDL-BUFFER-POINTER-POP)    ;SAVE CONTINUATION POINT.
	((VMA-START-READ) ADD M-T (A-CONSTANT 2))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-ZR) Q-DATA-TYPE READ-MEMORY-DATA)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SYMBOL)) CSM-8A)  ;NO METHODS IN THIS CLASS,
								 ; IMMEDIATELY RETURN.
	(CALL-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SELECT-METHOD)) TRAP)
 (ERROR-TABLE SELECT-METHOD-BAD-SUBROUTINE-CALL M-A)
	(JUMP-XCT-NEXT CSM-3)
       ((M-T) LDB Q-POINTER READ-MEMORY-DATA
		 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))

;HERE IF IN A SUBROUTINE, BUT DIDNT FIND IT.  RETURN FROM SUBROUTINE AND CONTINUE.
CSM-8	((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)
CSM-8A	((C-PDL-BUFFER-POINTER-PUSH) A-METHOD-SUBROUTINE-POINTER)  ;PUT CONTINUATION
	(JUMP-XCT-NEXT CSM-5)				; WHERE IT IS EXPECTED.
       ((A-METHOD-SUBROUTINE-POINTER) A-V-NIL)		;AT TOP LEVEL AGAIN.

;;; Frame-leaving routines.  Save appropriate state in the call-block.

;"Micro" leave.  This is the same as the normal frame leave except that
;it checks for any micro-stack which needs to be saved; if so it is
;transferred to the special-pdl and %%LP-EXS-MICRO-STACK-SAVED is set.
;However, the top entry on the micro-stack is the return from MLLV and
;is not saved.
;We always go to QLLV-NOT-TAIL-REC because, in the cases where MLLV is used,
;flushing the frame being left may not work (eg, stack group switching).
MLLV	((M-TEM) MICRO-STACK-POINTER)
	(JUMP-EQUAL M-TEM (A-CONSTANT 1) QLLV-NOT-TAIL-REC)	;Jump if nothing to save
	((M-2) MICRO-STACK-DATA-POP)	;Get real return off micro-stack
	((M-1) ADD (M-CONSTANT 40) A-QLBNDP)	;TEST P.C.E. (THIS M-CONST JUST HAPPENED TO
	((M-1) SUB M-1 A-QLBNDH)		; BE AROUND AT THE WRONG TIME).
	(CALL-IF-BIT-CLEAR BOXED-SIGN-BIT M-1 TRAP)
  (ERROR-TABLE PDL-OVERFLOW SPECIAL)		;M-1 should be negative as 24-bit quantity
	((M-Q) DPB (M-CONSTANT -1)	;First Q in block has flag bit
		(LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
MLLV1	((WRITE-MEMORY-DATA) MICRO-STACK-DATA-POP A-Q)	;Note- this involves a LDB operation
	((A-QLBNDP) ADD A-QLBNDP M-ZERO ALU-CARRY-IN-ONE) 
	((VMA-START-WRITE) A-QLBNDP)
	(CHECK-PAGE-WRITE)
	((M-TEM) MICRO-STACK-POINTER)	;Loop if not done
	(JUMP-NOT-EQUAL-XCT-NEXT M-TEM A-ZERO MLLV1)
	;Remaining Q's in block do not have flag bit
       ((M-Q) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((C-PDL-BUFFER-INDEX) IOR C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-MASK %%LP-EXS-MICRO-STACK-SAVED)))
	(JUMP-XCT-NEXT QLLV-NOT-TAIL-REC)
       ((MICRO-STACK-DATA-PUSH) M-2)	;Push back return address, drop into QLLV

;Leave a frame when we're running just macrocode, and no micro-stack needs to be saved.
;This routine saves and clears M-QBBFL, and saves the LC (even if the current frame
;is not a FEF frame; in that case it won't be looked at).
QLLV	;;*** Next 2 lines are temporary
	((M-TEM) MICRO-STACK-POINTER)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT 1) ILLOP)
	;;*** End of temporary code
	((M-TEM) A-V-NIL)
	(JUMP-NOT-EQUAL A-TAIL-RECURSION M-TEM QLLV-TAIL-REC)
;Re-enter here if tail recursion is not happening now.
;Enter here from MLLV.
QLLV-NOT-TAIL-REC
	((PDL-BUFFER-INDEX) M-AP)		;Must save LC as half-word offset from FEF
	((A-TEM1) DPB C-PDL-BUFFER-INDEX (BYTE-FIELD Q-POINTER-WIDTH 2)
		 (A-CONSTANT 0))	;Shift 2 to align with location counter
	((M-TEM) SUB LOCATION-COUNTER A-TEM1 OUTPUT-SELECTOR-RIGHTSHIFT-1) ;Relative PC (hwds)
	;; Build exit-state word from PC, M-FLAGS, and previous contents
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((A-TEM1) SELECTIVE-DEPOSIT C-PDL-BUFFER-INDEX (BYTE-FIELD 21 17) A-TEM)
			;CODE KNOWS THAT %%LP-EXS-EXIT-PC IS 0017
	(POPJ-AFTER-NEXT			;Save M-QBBFL then clear it
	 (C-PDL-BUFFER-INDEX) DPB M-FLAGS (LISP-BYTE %%LP-EXS-PC-STATUS) A-TEM1)
       ((M-FLAGS) SELECTIVE-DEPOSIT M-FLAGS M-FLAGS-EXCEPT-PROCESSOR-FLAGS A-ZERO)

QLLV-TAIL-REC
	(JUMP-IF-BIT-SET M-QBBFL QLLV-NOT-TAIL-REC)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(JUMP-IF-BIT-SET (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG) C-PDL-BUFFER-INDEX
		QLLV-NOT-TAIL-REC)
	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-TEM) (LISP-BYTE %%LP-CLS-DESTINATION) C-PDL-BUFFER-INDEX)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT D-RETURN) QLLV-NOT-TAIL-REC)
QLLV-TAIL-REC-0
;It is a call with D-RETURN, and no specials are bound.
;Are there any catches in the frame that is to be thrown away?
	((A-TEM1) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
					  *CATCH-U-CODE-ENTRY-/#)))
	;; Extract just three specific bits from called frame call state.
	((M-K) AND C-PDL-BUFFER-INDEX
	 (A-CONSTANT (PLUS (BYTE-VALUE %%LP-CLS-TRAP-ON-EXIT 1)
			   (BYTE-VALUE %%LP-CLS-SELF-MAP-PROVIDED 1)
			   (BYTE-VALUE %%LP-CLS-ADI-PRESENT 1))))
;Look at frame being called and each open frame within that frame.
;PDL-INDEX points to the %LP-CALL-STATE word of an open frame, here.
QLLV-TAIL-REC-1
	((M-TEM) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) C-PDL-BUFFER-INDEX)
	;; PDL-INDEX gets the function pointer word of the same frame.
	((PDL-INDEX) SUB PDL-INDEX (A-CONSTANT (EVAL %LP-CALL-STATE)))
	;; If the function is *CATCH, we cannot discard the open frame.
	((MD) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
	(JUMP-EQUAL MD A-TEM1 QLLV-NOT-TAIL-REC)
	;; Get address of next frame out.
	((PDL-INDEX) SUB PDL-INDEX A-TEM)
	;; If we come to the currently active frame (M-AP), there are no catches in it.
	(JUMP-NOT-EQUAL-XCT-NEXT PDL-INDEX A-AP QLLV-TAIL-REC-1)
       ((PDL-INDEX) ADD PDL-INDEX (A-CONSTANT (EVAL %LP-CALL-STATE)))
;; This is a tail recursive call from a frame with no specials and no catches.
;; Copy the frame being entered down on top of the one that was being left.
;; First clear the bit saying that the self-map was provided to the calling function,
;; because that does not mean it was provided to the called function.
;; PDL-INDEX already points to the frame's call-state word.
;; Also or together the trap-on-exit bits of the two frames.
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%LP-CLS-ADI-PRESENT) M-K
	    QLLV-TAIL-REC-ADI)
       ((M-TEM) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
;; M-TEM now has the data on type of call, to put in the frame's entry state.
;; Now merge the two call states: M-K has relevant info from the called frame's call state.
	((MD) ANDCA C-PDL-BUFFER-INDEX
		 (A-CONSTANT (BYTE-VALUE %%LP-CLS-SELF-MAP-PROVIDED 1)))
	((C-PDL-BUFFER-INDEX) IOR MD A-K)
;; We only need to copy the frame contents; the call state has just been merged,
;; and the entry state of the frame being moved has not been set up yet.
	((A-TEM1) PDL-POINTER)
	((PDL-POINTER) SUB M-AP (A-CONSTANT 1))
	((PDL-INDEX) SUB M-S (A-CONSTANT 1))
;; Set flag in entry state telling QLENTR to ignore the ADI
;; and get the A-LCTYP value from the low bits of the entry state word.
;; Also store the value (now in M-TEM) there.
	((PDL-TOP) ADD M-TEM
	 (A-CONSTANT (BYTE-VALUE %%LP-ENS-TAIL-RECURSIVELY-CALLED 1)))
QLLV-TAIL-REC-COPY
	((PDL-INDEX) ADD PDL-INDEX (A-CONSTANT 1))
	(JUMP-NOT-EQUAL-XCT-NEXT PDL-INDEX A-TEM1 QLLV-TAIL-REC-COPY)
       ((PDL-PUSH) PDL-INDEX-INDIRECT)
	(POPJ-AFTER-NEXT
	 (A-IPMARK) M-AP)
;Update the address of the frame to be entered.
       ((M-S) M-AP)

;Set up M-TEM with the %%LP-ENS-ADI-TYPE field.
;Sets the pdl index back to the call state word of the calling frame,
;which is what we assume it was when we were called.
QLLV-TAIL-REC-ADI
	((M-K) DPB M-ZERO (LISP-BYTE %%LP-CLS-ADI-PRESENT) A-K)	;Don't set ADI-PRESENT in calling frame.
	((PDL-INDEX) ADD M-S (A-CONSTANT (EVAL (1- %LP-CALL-STATE))))
	(POPJ-AFTER-NEXT
	 (M-TEM) SELECTIVE-DEPOSIT (LISP-BYTE %%ADI-TYPE) C-PDL-BUFFER-INDEX A-TEM)
       ((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))

XPERMIT-TAIL-RECURSION (MISC-INST-ENTRY %PERMIT-TAIL-RECURSION)
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(POPJ-AFTER-NEXT
	 (M-A) C-PDL-BUFFER-INDEX)
       ((C-PDL-BUFFER-INDEX) DPB M-ZERO (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG) A-A)

;Get here when resuming a stack group whose active frame is a FEF.
;Restore M-INST-BUFFER and A-LOCALP.
;Dont restore M-FLAGS, etc, because that is handled by SG resume mechanism.
QLLENT	((M-A) DPB C-PDL-BUFFER-INDEX (BYTE-FIELD Q-POINTER-WIDTH 2)
		   (A-CONSTANT 0))  ;SET UP FROM M-AP.  SHIFT TO BYTE ALIGN
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((A-TEM1) DPB C-PDL-BUFFER-INDEX (BYTE-FIELD 17 1) A-ZERO) ;RELATIVE PC IN BYTES
			;CODE KNOWS THAT %%LP-EXS-EXIT-PC IS 0017
	((LOCATION-COUNTER) ADD M-A A-TEM1)	;RESTORE LC
	((LOCATION-COUNTER) SUB LOCATION-COUNTER (A-CONSTANT 2))  ;IT IS NECESSARY THAT
			;M-INSTRUCTION-BUFFER ACTUALLY HAVE THE LAST INSTRUCTION
			;EXECUTED (IE NOT SUFFICIENT MERELY THAT THE CORRECT INSTRUCTION
			;WILL BE FETCHED NEXT TIME AROUND THE MAIN LOOP).  THIS IS BECAUSE
			;THE CURRENT MACRO-INSTRUCTION, WHICH MAY BE BEING REENTERED
			;IN THE MIDDLE, CAN DISPATCH AGAIN ON M-INSTRUCTION-STREAM
			;(TO GET THE DESTINATION IN MISC, FOR EXAMPLE).  THE SIMPLEST
			;WAY TO ASSURE THIS IS TO BACK UP THE LOCATION COUNTER AND
			;RE-ADVANCE IT.
	(DISPATCH ADVANCE-INSTRUCTION-STREAM)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(POPJ-AFTER-NEXT			;START INSTRUCTION FETCH, GET LOCAL BLOCK
	 (M-TEM) (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN) C-PDL-BUFFER-INDEX)
       ((A-LOCALP) ADD M-AP A-TEM)

;DTP-U-ENTRY turned out not to be microcoded.  Snap it out, and try again.
QME2	((PDL-BUFFER-INDEX) M-S)
	((C-PDL-BUFFER-INDEX M-A) SELECTIVE-DEPOSIT C-PDL-BUFFER-INDEX 	;CLOBBER INTO
		Q-ALL-BUT-TYPED-POINTER A-T)	; LP-FEF SLOT, REPLACING DTP-U-ENTRY
	(DISPATCH (I-ARG 1) Q-DATA-TYPE M-A D-QMRCL)
       (NO-OP)

;Enter micro-code entry function, called by XXX-TO-MACRO call.
; M-S has new value for M-AP, 0(M-S) is function being
; called (also in M-A), 1(M-S) is 1st arg, 2(M-S) is 2nd, etc.
; Calling function has been left.  M-R has number of args.

QME1	((M-D) Q-POINTER M-A A-AMCENT)
	(CALL-GREATER-OR-EQUAL M-D A-AMCENT TRAP)	;OUT OF RANGE
  (ERROR-TABLE MICRO-CODE-ENTRY-OUT-OF-RANGE M-D)
	((VMA-START-READ) ADD M-D A-V-MICRO-CODE-ENTRY-AREA)  ;IF THIS A FIXNUM, ITS
	(CHECK-PAGE-READ)           ;INDEX TO MICRO-CODE-SYMBOL-AREA.  OTHERWISE, FCTN
	((M-ERROR-SUBSTATUS) A-ZERO)
	((M-T) READ-MEMORY-DATA)    ;IS NOT REALLY MICROCODED NOW, AND THIS IS OTHER DEF.
	((M-TEM) Q-DATA-TYPE M-T)   ;IF SO, PUT THIS IN LP-FEF SLOT AND TRY AGAIN.
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) QME2)	;Jump if not microcoded
	((VMA-START-READ) ADD M-D A-V-MICRO-CODE-ENTRY-ARGS-INFO-AREA)
	(CHECK-PAGE-READ)
	((PDL-BUFFER-INDEX) SUB M-S A-AP)	;Increment to M-AP (truncated to 10 bits)
	((M-PDL-BUFFER-ACTIVE-QS) ADD PDL-BUFFER-INDEX A-PDL-BUFFER-ACTIVE-QS)
	((M-TEM) (LISP-BYTE %%ARG-DESC-MIN-ARGS) READ-MEMORY-DATA)
	(CALL-GREATER-THAN M-TEM A-R SET-TOO-FEW-ARGS)
	((M-TEM) (LISP-BYTE %%ARG-DESC-MAX-ARGS) READ-MEMORY-DATA)
	(CALL-LESS-THAN M-TEM A-R SET-TOO-MANY-ARGS)
			;NOTE, THIS DOESN'T CHECK FOR LEXPR/FEXPR CALL.
			;WE DO PROVIDE FOR MICROCODED FUNCTIONS WITH VARIABLE NUMBER
			;OF ARGS, WHICH ARE LEGAL PROVIDED THEY ARE NOT MISC INSTRUCTIONS.
	(CALL-GREATER-THAN-XCT-NEXT M-PDL-BUFFER-ACTIVE-QS
			   A-PDL-BUFFER-HIGH-WARNING PDL-BUFFER-DUMP)
       ((M-AP) M-S)
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
       ((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((C-PDL-BUFFER-INDEX) DPB M-R (LISP-BYTE %%LP-ENS-NUM-ARGS-SUPPLIED)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((VMA-START-READ) ADD M-T A-V-MICRO-CODE-SYMBOL-AREA)  ;M-T HAS DATA READ FROM
	(CHECK-PAGE-READ)			;MICRO-CODE-ENTRY-AREA
QME1A	(CALL-IF-BIT-SET M-TRAP-ON-CALLS QME1-QMRCL-TRAP)
	(JUMP-NOT-EQUAL M-ERROR-SUBSTATUS A-ZERO QLEERR) ;SIGNAL WRONG NUMBER OF ARGS ERROR
	((OA-REG-LOW M-LAST-MICRO-ENTRY) DPB READ-MEMORY-DATA OAL-JUMP A-ZERO)
	;; Drop into MISC-TO-RETURN.  Calls the micro-entry function with a return
	;; address of QMDDR.  Upon return the frame will be flushed.
	;; This return address of QMDDR causes multiple-values to work right.

MISC-TO-RETURN
	(CALL 0)				;CALL MISC FUNCTION, DROP INTO QMDDR

;;; DESTINATION RETURN  value in M-T.  Q-ALL-BUT-TYPED-POINTER bits must be 0.
QMDDR	((M-TEM) Q-DATA-TYPE M-T)
  ;** BUG.  THIS TEST CAN BE BYPASSED IF IT GETS TO QMDDR0 OR QMEX1 IN VARIOUS CASES**
  ; THIS SHOULD BE FLUSHED FROM HERE AND REHACKED USING NEW SCHEME.
	(CALL-EQUAL M-TEM (A-CONSTANT (EVAL DTP-STACK-CLOSURE))
		    STACK-CLOSURE-RETURN-TRAP)
	(JUMP-NOT-EQUAL M-AP A-IPMARK QMDDR-THROW) ;CHECK FOR UNWIND-PROTECT
QMDDR0	(CALL-IF-BIT-SET M-QBBFL BBLKP)		;POP BINDING BLOCK (IF STORED ONE)
QMEX1	((PDL-BUFFER-INDEX) M-AP)		;Save returning function for metering
	((M-A) C-PDL-BUFFER-INDEX)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-C) C-PDL-BUFFER-INDEX)
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-CLS-TRAP-ON-EXIT) C-PDL-BUFFER-INDEX QMEX1-TRAP)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-ENS-ENVIRONMENT-POINTER-POINTS-HERE)
			 C-PDL-BUFFER-INDEX
			 QMEX1-COPY)
	;;*** next 2 instructions are temporary
	((M-TEM) MICRO-STACK-POINTER)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT 0) ILLOP)
	;;*** end of temporary code
	((PDL-BUFFER-POINTER) SUB M-AP (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH))) ;FLUSH PDL
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-CLS-ADI-PRESENT) M-C QRAD1)  ;FLUSH ADDTL INFO
	((A-TEM1) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) M-C)
	(JUMP-EQUAL M-ZERO A-TEM1 QMXSG)	;RETURNING OUT TOP OF STACK-GROUP
	((M-TEM) SUB M-AP A-TEM1)		;COMPUTE PREV A-IPMARK
	((A-IPMARK) (BYTE-FIELD 10. 0) M-TEM)	;RESTORE THAT
	((A-TEM1) (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) M-C)
	((PDL-BUFFER-INDEX) SUB M-AP A-TEM1)	;RESTORE M-AP
	((M-AP) PDL-BUFFER-INDEX)		;THIS OPERATION MASKS M-AP TO 10 BITS.
	((M-PDL-BUFFER-ACTIVE-QS) SUB M-PDL-BUFFER-ACTIVE-QS A-TEM1)
	;; Make sure frame being returned to is in the pdl buffer
	(CALL-LESS-THAN M-PDL-BUFFER-ACTIVE-QS
			(A-CONSTANT PDL-BUFFER-LOW-WARNING) PDL-BUFFER-REFILL)
	;; Now restore the state of the frame being returned to.  We will restore
	;; the FEF stuff even if it's not a FEF frame, at the cost of a slight
	;; amount of time.
	(CALL-IF-BIT-SET (LISP-BYTE %%METER-FUNCTION-ENTRY-EXIT-ENABLE)
		M-METER-ENABLES METER-FUNCTION-EXIT)
	((M-A) Q-POINTER C-PDL-BUFFER-INDEX)	;FUNCTION RETURNING TO
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((M-TEM) (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN) C-PDL-BUFFER-INDEX)
	((A-LOCALP) ADD M-AP A-TEM)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((M-FLAGS) (LISP-BYTE %%LP-EXS-PC-STATUS) C-PDL-BUFFER-INDEX A-FLAGS)
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-EXS-MICRO-STACK-SAVED) C-PDL-BUFFER-INDEX QMMPOP)
	((M-TEM) DPB M-A (BYTE-FIELD Q-POINTER-WIDTH 2) (A-CONSTANT 0))	;FEF address in bytes
	((A-TEM1) DPB C-PDL-BUFFER-INDEX (BYTE-FIELD 17 1) A-ZERO)
			;CODE KNOWS THAT %%LP-EXS-EXIT-PC IS 0017
	((LOCATION-COUNTER) ADD M-TEM A-TEM1)
QIMOVE-EXIT	;Store into destination in M-C.  Could be D-MICRO
	(DISPATCH (LISP-BYTE %%LP-CLS-DESTINATION) M-C QMDTBD)
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))

;If we trap from QME1A, we need to "preserve" MD
;by reloading it after we get back from the trap.
QME1-QMRCL-TRAP
	((VMA) Q-POINTER VMA)
	(CALL QMRCL-TRAP-1)
	((VMA-START-READ) VMA)
	(CHECK-PAGE-READ)
	(POPJ)

;Here from QMDDR if data type of M-T is DTP-STACK-CLOSURE.
;Copy the closure into the heap, in case the frame it is in
;is about to go away.
STACK-CLOSURE-RETURN-TRAP
	((MD) M-T)
	((VMA) A-V-NIL)		;NIL has a special meaning to STACK-CLOSURE-TRAP.
	(GC-WRITE-TEST)
	(POPJ-XCT-NEXT)
       ((M-T) MD)

;;; M-A has the function returning from
METER-FUNCTION-EXIT
	((A-METER-EVENT) (A-CONSTANT (EVAL %METER-FUNCTION-EXIT-EVENT)))
	((C-PDL-BUFFER-POINTER-PUSH) M-A)
	(JUMP-XCT-NEXT METER-MICRO-WRITE-HEADER)
       ((A-METER-LENGTH) (A-CONSTANT 1))	;Number of meters pushed

;This is here so I can put breakpoints before and after trapping.
QMEX1-TRAP
	((VMA) A-ZERO)		;Avoid illop due to pointer not in any region,
	((M-Q) A-ZERO)		;which seems frequently to be true of VMA at QMEX1.
	(CALL TRAP)
    (ERROR-TABLE EXIT-TRAP)
	(POPJ)

;Copy the frame being exited into a list, if it has the bit set
;saying that an environment pointer points at it.
;The pointers to the frame are all in copied closure values of
;LEXICAL-ENVIRONMENT, and all of them are in cells pointed to
;by EVCPs located in the locals of this frame!  So we can find those
;pointers and make them point instead at the newly made list copy.

;Must preserve M-A and M-C, as well as M-T (the returned value).
;Assumes PDL-BUFFER-INDEX points at the %LP-ENTRY-STATUS word of the frame.
QMEX1-COPY
	((C-PDL-BUFFER-POINTER-PUSH) M-T)
	((M-K) LDB (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN) C-PDL-BUFFER-INDEX)
;Get number of locals in frame, from the fef.
	((PDL-BUFFER-INDEX) M-AP)
	((VMA-START-READ) ADD C-PDL-BUFFER-INDEX (A-CONSTANT (EVAL %FEFHI-MISC)))
	(CHECK-PAGE-READ)
	((M-B) (LISP-BYTE %%FEFHI-MS-LOCAL-BLOCK-LENGTH) READ-MEMORY-DATA)
;M-B now has number of locals in the frame.
;Save it for much later (QMEX1-FIND-CLOSURES).
;Also get the total size of frame data to be copied.
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((M-B) ADD M-B A-K)	
;Cons a block that big, preserving the size in B.
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	(CALL-XCT-NEXT LCONS)
       ((M-S) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-BACKGROUND-CONS-AREA)
	((M-B) C-PDL-BUFFER-POINTER-POP)
	((PDL-BUFFER-INDEX) M-AP)
	((VMA) M-T)
	((C-PDL-BUFFER-POINTER-PUSH) M-T)
;Copy the args and locals into the newly consed list.
;M-B has # left to copy, PDL-BUFFER-INDEX has where to copy from,
;VMA has where to copy to.
QMEX1-COPY-LOOP
	((MD-START-WRITE) Q-TYPED-POINTER C-PDL-BUFFER-INDEX
			  (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	((PDL-BUFFER-INDEX) M+1 PDL-BUFFER-INDEX)
	(CHECK-PAGE-WRITE)
	((M-B) SUB M-B (A-CONSTANT 1))
	(JUMP-GREATER-THAN-XCT-NEXT M-B A-ZERO QMEX1-COPY-LOOP)
       ((VMA) M+1 VMA)
;Store CDR-NIL into the last word.
	((VMA) SUB VMA (A-CONSTANT 1))
	((MD-START-WRITE) Q-TYPED-POINTER MD
			  (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	(CHECK-PAGE-WRITE)
;Get back the pointer to this list and store it
;into the forwarded copies of all the stack closures in this frame.
;Find them by scanning thru the frame's locals.
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) M-AP)
;M-D and M-T get original stack frame and copy, both with DTP-LIST.
	((M-D) M-K Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	((M-T) LDB C-PDL-BUFFER-POINTER-POP Q-POINTER
	       (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	((M-B) C-PDL-BUFFER-POINTER-POP)	;pop number of locals.
	((M-K) A-LOCALP)	;Get pdl index of first local.
QMEX1-FIND-FORWARDS
;Look for a local that is a forwarded list.
	((PDL-BUFFER-INDEX) M-K)
	((M-TEM) Q-DATA-TYPE C-PDL-BUFFER-INDEX)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-EXTERNAL-VALUE-CELL-POINTER))
	     QMEX1-NOT-FORWARD)
;Yes, find where forwarded to,
;and if it points at our stack frame,
;make it point at the new copy instead.
	((VMA-START-READ) C-PDL-BUFFER-INDEX)
	(CHECK-PAGE-READ)
	((M-TEM) Q-TYPED-POINTER MD)
	(JUMP-NOT-EQUAL M-TEM A-D QMEX1-NOT-FORWARD)
	((MD-START-WRITE) DPB MD Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
QMEX1-NOT-FORWARD
	((M-B) SUB M-B (A-CONSTANT 1))
	(JUMP-GREATER-THAN-XCT-NEXT M-B A-ZERO QMEX1-FIND-FORWARDS)
       ((M-K) M+1 M-K)
	(POPJ-XCT-NEXT)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

;Restore the micro-stack from the binding stack
QMMPOP	((C-PDL-BUFFER-INDEX) ANDCA C-PDL-BUFFER-INDEX	;Clear flag since flushing saved stack
		(A-CONSTANT (BYTE-MASK %%LP-EXS-MICRO-STACK-SAVED)))
	((M-S) MICRO-STACK-DATA-POP)		;Pop off return
QMMPO2	((VMA-START-READ) A-QLBNDP)		;No transport, known to be a fixnum
	(CHECK-PAGE-READ)			;Bind stack not really consistent, no seq brk
	((A-QLBNDP) SUB VMA (A-CONSTANT 1))
	((MICRO-STACK-DATA-PUSH) READ-MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) ILLOP)
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) READ-MEMORY-DATA QMMPO2)	;Jump if not last
	((OA-REG-LOW) DPB M-S OAL-JUMP A-ZERO)
	(JUMP 0)

;GET HERE WHEN RETURNING OUT TOP OF STACK GROUP
QMXSG	((PDL-BUFFER-POINTER) M-AP)	;AVOID GROSS SCREW WHERE P-F ROUTINES GET CONFUSED
		;ABOUT WHATS IN THE PDL-BUFFER DUE TO FACT PDL-BUFFER-POINTER WAS DECREMENTED
		;TO BEFORE ACTIVE CALL BLOCK (IE 1777 IF SG STARTED OFF AT 0@P)
	((VMA) A-QCSTKG)	;ERROR CHECK TO SEE IF DELTA S SCREWWED OR SOMETHING
	((VMA-START-READ) SUB VMA
		 (A-CONSTANT (PLUS 2 (EVAL SG-INITIAL-FUNCTION-INDEX))))
	(CHECK-PAGE-READ)
	((A-SG-TEM) M-T)	;VALUE GETTING RETURNED
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((PDL-BUFFER-INDEX) ADD READ-MEMORY-DATA A-PDL-BUFFER-HEAD)
	(CALL-NOT-EQUAL PDL-BUFFER-INDEX A-AP ILLOP)
	(JUMP-XCT-NEXT SG-RETURN-2)	;RETURN THIS LAST VALUE AND GO TO EXHAUSTED STATE
       ((M-TEM) (A-CONSTANT (EVAL SG-STATE-EXHAUSTED)))


;STORE LAST VALUE IN ADI CALL, FLUSH ADI FROM PDL
;MAY CLOBBER ALL REGISTERS EXCEPT M-C and M-A
QRAD1	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QRAD1R)))  ;DONT CARE IF THIS 
							; LAST OR NOT.
	((PDL-BUFFER-POINTER) M-AP)	;IN CASE WE SWITCH STACK GROUPS INSIDE MVR
	((M-K) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((PDL-BUFFER-INDEX) SUB M-K A-PDL-BUFFER-HEAD)
	((M-K) ADD PDL-BUFFER-INDEX A-PDL-BUFFER-VIRTUAL-ADDRESS)
	(CALL-XCT-NEXT MVR)	;STORE THE LAST VALUE INTO MV IF ANY
       ((M-S) A-ZERO)
QRAD1R	((PDL-BUFFER-INDEX M-K) SUB M-AP
		(A-CONSTANT (PLUS 1 (EVAL %LP-CALL-BLOCK-LENGTH)))) ;FLUSH ADI FROM PDL
QRAD2	(POPJ-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX)
       ((PDL-BUFFER-POINTER) SUB M-K (A-CONSTANT 1))
	(JUMP-XCT-NEXT QRAD2)
       ((PDL-BUFFER-INDEX M-K) SUB M-K (A-CONSTANT 2))

XRETN (MISC-INST-ENTRY %RETURN-N)		;RETURN N VALUES, LAST ARG IS N.
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
  (ERROR-TABLE ARGTYP FIXNUM PP NIL)
  (ERROR-TABLE ARG-POPPED 0 PP)
	((M-C) Q-POINTER C-PDL-BUFFER-POINTER-POP) ;NUMBER OF VALUES TO RETURN
XRETN1	((M-C) SUB M-C (A-CONSTANT 1))
	(JUMP-LESS-OR-EQUAL M-C A-ZERO XRETN2) ;LAST
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMDDR-KLUDGE))) ;RETURN ON LAST VAL
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVRPI)
       ((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER A-C)	;NEXT ARGUMENT SLOT
	(JUMP XRETN1)

XRET3 (MISC-INST-ENTRY %RETURN-3)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMDDR-KLUDGE))) ;RETURN ON LAST VAL
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVRPI)
       ((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))
XRET2 (MISC-INST-ENTRY %RETURN-2)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMDDR-KLUDGE))) ;RETURN ON LAST VAL
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVRPI)
       ((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 1))
XRETN2	(JUMP-XCT-NEXT QMDDR-KLUDGE)			;RETURN LAST VALUE REGULAR WAY
       ((M-T) C-PDL-BUFFER-POINTER)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS RETURN-LIST M-A)

XRETURN-LIST (MISC-INST-ENTRY RETURN-LIST)	;This is always used with dest D-RETURN!
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
	(JUMP-EQUAL M-A A-V-NIL RETURN-NO-VALUES)
XRETURN-LIST1
	(CALL-XCT-NEXT QMD)			;Get cdr of list
       ((M-T) C-PDL-BUFFER-POINTER)
	(JUMP-EQUAL M-T A-V-NIL QTA)		;This is last value, return it to QMDDR
	(CALL-XCT-NEXT QTA)			;Not last value, but get the value
       ((M-C) M-T)				; and save tail of list
	;Next element in M-T, list tail in M-C.  Return the element.
	;Push the address to return to if have no more values wanted (return via QMDDR)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC CPOPJ)))
	((M-S) A-ZERO)
	(CALL XRNVR)
	(JUMP-XCT-NEXT XRETURN-LIST1)
       ((C-PDL-BUFFER-POINTER-PUSH) M-C)

;Come here with a NIL on the top of the stack.  Calls XRNVR with the M-S flag,
;and either return returns to QMDDR.  We go through MVR so that in case the
;caller used a multiple-value-list, we will clobber the ADI so that QMDDR won't
;return any values into that list.
RETURN-NO-VALUES
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;Value is NIL, and flush the stack.
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC CPOPJ)))
	((M-S) (A-CONSTANT 1))
	(CALL XRNVR)
	(POPJ)

XRNV (MISC-INST-ENTRY RETURN-NEXT-VALUE)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMDDR-KLUDGE))) ;GO TO QMDDR IF LAST
						;  VALUE.
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;FROB TO RETURN
   (ERROR-TABLE ARG-POPPED 0 M-T)
	(POPJ)					;NOT LAST VALUE, RETURN TO MAIN LOOP

;This will eventually be replaced with just QMDDR.  It is here temporarily
;due to the compiler compiling the returning misc instructions to wrong destination.
QMDDR-KLUDGE
	((M-TEM) MICRO-STACK-POINTER)
	(JUMP-EQUAL M-TEM A-ZERO QMDDR)
	(JUMP QMDDR-KLUDGE MICRO-STACK-PNTR-AND-DATA-POP)

;Return next value.  See comments below for info on special calling sequence.
;We search back through the call stack until we get to a frame with a destination
;other than D-RETURN.  We then check that frame to see if it has multiple-value ADI.
;For speed, we try to avoid taking page faults when referencing the pdl buffer.
;M-K will have the virtual address being referenced, MD its contents.
;M-S must have the flag for MVR (q.v.).
XRNVRPI	((M-T) C-PDL-BUFFER-INDEX)		;Return value from PDL[PI]
XRNVR	((M-K) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((PDL-BUFFER-INDEX) SUB M-K A-PDL-BUFFER-HEAD)
	((M-K) ADD PDL-BUFFER-INDEX A-PDL-BUFFER-VIRTUAL-ADDRESS)
XRNVR1	(CALL MKCONT)				;Get this frame's call state
	((M-TEM) (LISP-BYTE %%LP-CLS-DESTINATION) MD)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT D-RETURN) XRNVR2)
XRNVR3
	((M-TEM) (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) MD)	;Chain back to previous frame
	(JUMP-NOT-EQUAL-XCT-NEXT M-TEM A-ZERO XRNVR1)
       ((M-K) SUB M-K A-TEM)
	(CALL ILLOP)				;Stack exhausted

XRNVR2	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%LP-CLS-ADI-PRESENT) MD XRNVX)	;Not doing mult vals
	(JUMP MVR)				;Go return multiple values from this frame

;MD gets contents of untyped virtual address in M-K, when likely to be in pdl buffer
;and known not to be off the top end of the pdl buffer.
MKCONT	(JUMP-LESS-THAN M-K A-PDL-BUFFER-VIRTUAL-ADDRESS MKCONT1)
	((M-TEM) SUB M-K A-PDL-BUFFER-VIRTUAL-ADDRESS)
	(POPJ-AFTER-NEXT (PDL-BUFFER-INDEX) ADD M-TEM A-PDL-BUFFER-HEAD)
       ((MD) C-PDL-BUFFER-INDEX)

MKCONT1	(POPJ-AFTER-NEXT (VMA-START-READ) M-K)
       (CHECK-PAGE-READ)

;Contents of untyped virtual address in M-K gets MD, when likely to be in pdl buffer
;and known not to be off the top end of the pdl buffer.
MKWRIT	((M-TEM) Q-DATA-TYPE MD)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-STACK-CLOSURE)) MKWRIT2)
	(JUMP-LESS-THAN M-K A-PDL-BUFFER-VIRTUAL-ADDRESS MKWRIT1)
	((M-TEM) SUB M-K A-PDL-BUFFER-VIRTUAL-ADDRESS)
	(POPJ-AFTER-NEXT (PDL-BUFFER-INDEX) ADD M-TEM A-PDL-BUFFER-HEAD)
       ((C-PDL-BUFFER-INDEX) MD)

MKWRIT1	(POPJ-AFTER-NEXT (VMA-START-WRITE) M-K)
       (CHECK-PAGE-WRITE)

;Stack closure, copy it if necessary.
MKWRIT2	((VMA-START-WRITE) M-K)
	(CHECK-PAGE-WRITE)
	(GC-WRITE-TEST)
	(POPJ)

;Documentation on calling sequence for XRNVR/MVR:
;M-T has the value to be returned.
;M-K has virtual address of LPCLS Q for the frame from which value is to be returned.
;M-S has a flag which is 1 when we are returning no values; this only happens
; from (return-list nil).
;The calling sequence is hairy to implement the feature that if the callee returns
;a value and the caller does not want further values after that one, the function
;suddenly returns.
;There are two return addresses on the micro-stack.  If this was the last value
; expected, the first return is taken; if more values are expected the second
; return is taken.  In the return-next-value case the first return should be
; QMDDR, causing a sudden return.  In the QRAD1 case both returns should be the same,
; since we are returning anyway whether or not this is the last value.
; In any case, both returns are flushed from the stack.
;The sudden return works by storing the value in the block, as usual, and then
; going to QMDDR to get the stack unwound and all, BUT first clobbering the
; ADI type to be ADI-USED-UP-RETURN-INFO so that QMDDR won't store the value
; all over again.

;  ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC <THAT-WAS-LAST-VALUE-RETURN>)))
;  (CALL XRVNR)
;  ... STILL EXPECTING MORE VALUES

;Clobbers A-TEM1, M-I, M-J, M-S, M-R, M-K plus calls QRDR1 (which doesnt clobber any more)
;Plus calls CONS, which clobbers more.  Protects M-C and M-A but probably not anything else.

;At this point M-K has the virtual address of the LPCLS Q for the frame
;from which the value is to be returned, which is known to have ADI.
;Investigate that ADI to see if there is a multiple-value receiver.
MVR	;; Get address of highest word of ADI
	((M-K) SUB M-K (A-CONSTANT (EVAL (+ %LP-CALL-BLOCK-LENGTH %LP-CALL-STATE))))
MVR0	(CALL MKCONT)				;MD gets ADI Q
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP) Q-DATA-TYPE MD TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE DATA-TYPE-SCREWUP ADI)
	((M-J) (LISP-BYTE %%ADI-TYPE) MD)
	(JUMP-NOT-EQUAL M-J (A-CONSTANT (EVAL ADI-RETURN-INFO)) MVR1)
	(DISPATCH-XCT-NEXT (LISP-BYTE %%ADI-RET-STORING-OPTION) MD D-MVR)
       ((M-I) (LISP-BYTE %%ADI-RET-NUM-VALS-EXPECTING) MD)

MVR1	(CALL-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) MD ILLOP)	;Info out of phase
	(CALL-XCT-NEXT MKCONT)
       ((M-K) SUB M-K (A-CONSTANT 1))
	(JUMP-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) MD MVR0) ;More
       ((M-K) SUB M-K (A-CONSTANT 1))
	;; No ADI, this the last value
XRNVX	((M-GARBAGE) MICRO-STACK-DATA-POP)	;Flush second return
	(POPJ)					;That was last value, take first return
	
;Indirect link.  Only allowed to indirect to something in the same pdl,
;so that MKCONT and MKWRIT can work.
MVRIND	(CALL-XCT-NEXT MKCONT)			;Get pointer to ADI to use
       ((M-K) SUB M-K (A-CONSTANT 1))
	(JUMP-XCT-NEXT MVR0)
       ((M-K) Q-POINTER MD)

;Store in block
MVRB	(CALL-LESS-OR-EQUAL M-I A-ZERO ILLOP)	;Returning too many values
	((M-I) SUB M-I (A-CONSTANT 1))
	((M-TEM) MD)				;Store back decremented values count
	((MD M-TEM) DPB M-I (LISP-BYTE %%ADI-RET-NUM-VALS-EXPECTING) A-TEM)
	(JUMP-NOT-EQUAL M-I A-ZERO MVRB0)	;If last val expected, clobber ADI.
	((MD) DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-TYPE) A-TEM)
MVRB0	(CALL MKWRIT)
	(CALL-XCT-NEXT MKCONT)			;Get storing pointer
       ((M-K) SUB M-K (A-CONSTANT 1))
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	(CALL-XCT-NEXT MKWRIT)
       ((MD M-R) ADD MD (A-CONSTANT 1))
MVRB1	((VMA-START-READ) SUB M-R (A-CONSTANT 1))	;No transport, since writing and no
MVRB2	(CHECK-PAGE-READ)				;need to follow invisible pntrs here
	((WRITE-MEMORY-DATA-START-WRITE)	;Store the value
		SELECTIVE-DEPOSIT READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)
        (CHECK-PAGE-WRITE)
	(JUMP-EQUAL M-I A-ZERO XRNVX)		;This was the last value expected.
	(POPJ-AFTER-NEXT GC-WRITE-TEST)		;More expected, or doing return and that was
       ((M-GARBAGE) MICRO-STACK-DATA-POP)	;last, take second return and flush first

;Cons up list
;2nd (lower) ADI word points to list tail.  Initially it is a locative
;to the location which will eventually hold the list of returned values,
;which should be initialized to NIL.
;After the first time, it is a list-pointer to the last cons in the list.
;XNCONS mustn't clobber M-C, M-I, M-R; QRDR1 mustn't clobber M-C or M-R.
MVRC	(JUMP-EQUAL M-S (A-CONSTANT 1) MVRC1)	;Returning no values?
	((M-I) ADD M-K				;Save address of prev ADI Q
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE) -1)))
	(CALL-XCT-NEXT XNCONS)			;Cons up a 2-Q cons, cdr NIL, to M-T
       ((C-PDL-BUFFER-POINTER-PUSH M-R) M-T)	;Save value returning, will be car
	(CALL-XCT-NEXT MKCONT)			;Get pointer to list tail
       ((M-K) Q-POINTER M-I)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	((M-S) MD)				;Save pntr to list tail
	(CALL-XCT-NEXT MKWRIT)
       ((MD) M-T)				;Change pntr to new list tail
	(CALL QRDR1)				;RPLACD tail of list
	(POPJ-XCT-NEXT)				;More <infinite> values expected
       ((M-T) SETA A-R MICRO-STACK-PNTR-AND-DATA-POP)    ;Restore value being returned 
		;and flush first return. (PNTR-AND-DATA necc. to avoid a byte-op)

;Returning no values.  Don't affect list, and clobber ADI-TYPE so that when
;QRAD1 calls MVR, it won't affect the list either.
MVRC1	((M-TEM) MD)
	((MD) DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-TYPE) A-TEM)
	(CALL MKWRIT)
	(POPJ-XCT-NEXT)				;More <infinite> values expected.
       ((M-GARBAGE) MICRO-STACK-DATA-POP)

;;; THROW CODE (*THROW, *UNWIND-STACK)
;;; Register Conventions:
;;; A-CATCH-MARK is the function for which an open call is what we want (usually *CATCH)
;;; A-CATCH-TAG is the first argument to that function.  Except, T and 0 are special.
;;; A-CATCH-COUNT contains a count of active frames.  If this reaches zero, we resume
;;;  that frame instead of throwing farther.  If this is NIL, no count.
;;; A-CATCH-ACTION contains the "action", which is usually NIL, but can if non-NIL,
;;;  when the resumption point is reached, instead of resuming it is a function
;;;  (or a stack-group) which gets called with one argument, the value being thrown.
;;; M-T value being thrown

;;; Special *CATCH tags are:
;;;  NIL  CATCH-ALL
;;;  T    UNWIND-PROTECT.  The difference between UNWIND-PROTECT and CATCH-ALL
;;;	  is that UNWIND-PROTECT will always continue throwing.

;;; Special *THROW, *UNWIND-STACK tags are:
;;;  0    Return from function (like destination-return)
;;;  T    Throw all the way out the top of the stack-group.  In this case we
;;;	  bypass CATCH-ALLs.  This is used for unwinding "old" stack groups.
;;;	  This must be used in connection with a non-null A-CATCH-ACTION.
;;;  NIL  *CATCH returns NIL as the tag if no throw or return operation occurred.
;;; If the tag is neither T nor 0, we throw to the nearest catch with that tag,
;;; or UNWIND-PROTECT, or CATCH-ALL.

;;; *UNWIND-STACK is a generalized *THROW, used by the error handler and
;;; by UNWIND-PROTECT.  The first two arguments are the same as to *THROW.
;;; The third argument is a count; if this NIL things are the same as *THROW,
;;; otherwise if this many frames are passed we resume as if a catch had been found.
;;; The fourth argument, if non-NIL, means that instead of resuming when
;;; we find the point to throw to, we call that function with one argument,
;;; the second arg to *UNWIND-STACK.

XCATCH (MISC-INST-ENTRY *CATCH)		;ONLY GET HERE WHEN NO *THROW 
	(POPJ-AFTER-NEXT 		;*CATCH WHICH COMPLETES RETURNS NIL AS SECOND VALUE
	 (M-T) C-PDL-BUFFER-POINTER-POP) ;VALUE OF FROB
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)

METER-FUNCTION-UNWIND
	((A-METER-EVENT) (A-CONSTANT (EVAL %METER-FUNCTION-UNWIND-EVENT)))
	(JUMP-XCT-NEXT METER-MICRO-WRITE-HEADER)
       ((A-METER-LENGTH) M-ZERO)	;Number of meters pushed

;;; This like *UNWIND-STACK but takes its args in the order value, tag, count, action
;;; and simply moves value to the destination if tag is NIL (normal exit from unwind-protect)
XUWPCON (MISC-INST-ENTRY %UNWIND-PROTECT-CONTINUE)
	((A-CATCH-ACTION) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((A-CATCH-COUNT) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-1) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;Tag
	(POPJ-EQUAL-XCT-NEXT M-1 A-V-NIL)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;Value
	(JUMP-EQUAL M-1 (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX) 1))
	  XUWPCON-POP-OPEN-CALL)	
	((C-PDL-BUFFER-POINTER-PUSH) M-1)		;Clobbered by meter code
	(CALL-IF-BIT-SET (LISP-BYTE %%METER-FUNCTION-ENTRY-EXIT-ENABLE)
		M-METER-ENABLES METER-FUNCTION-UNWIND)
	(JUMP-XCT-NEXT XUWPCN1)				;Join *UNWIND-STACK
       ((A-CATCH-MARK) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
					 *CATCH-U-CODE-ENTRY-/#)))


;A tag of 1 in %UNWIND-PROTECT-CONTINUE means
; return to a POP-OPEN-CALL instruction
; that popped an unwind protect's frame.
;The "value being thrown" records the location counter
; after the POP-OPEN-CALL instruction, in querterwords.
;We ignore the destination of the%UNWIND-PROTECT-CONTINUE
;and never push the "value" on the stack.
XUWPCON-POP-OPEN-CALL
	((M-1) M-INST-DEST)
	(JUMP-EQUAL M-1 A-ZERO XUWPCON-POP-OPEN-CALL-1)
       ((M-GARBAGE) MICRO-STACK-DATA-POP)	;Don't store in our destination.
XUWPCON-POP-OPEN-CALL-1
	((PDL-INDEX) M-AP)
;Get the address of the current fef, shifted left 2.
	((M-1) DPB (BYTE-FIELD Q-POINTER-WIDTH 2) C-PDL-BUFFER-INDEX A-ZERO)
	((M-T) Q-POINTER M-T)
	((LOCATION-COUNTER) ADD M-1 A-T)
;I don't know whether it would work to popj any sooner,
;since it will do an instruction fetch.
	(POPJ)

XUWSTK (MISC-INST-ENTRY *UNWIND-STACK)
   (ERROR-TABLE RESTART *UNWIND-STACK)
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%METER-FUNCTION-ENTRY-EXIT-ENABLE)
		M-METER-ENABLES METER-FUNCTION-UNWIND)
	((A-CATCH-ACTION) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((A-CATCH-COUNT) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT XUWS0)
      ;((A-CATCH-MARK) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
      ;					 *CATCH-U-CODE-ENTRY-/#)))

(ERROR-TABLE DEFAULT-ARG-LOCATIONS *THROW A-CATCH-TAG M-T)

XTHROW (MISC-INST-ENTRY *THROW)
   (ERROR-TABLE RESTART *THROW)
		;Note the following instruction is also XCT-NEXT'ed from above
	((A-CATCH-MARK) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
					  *CATCH-U-CODE-ENTRY-/#)))
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%METER-FUNCTION-ENTRY-EXIT-ENABLE)
		M-METER-ENABLES METER-FUNCTION-UNWIND)
	((A-CATCH-ACTION) A-V-NIL)
	((A-CATCH-COUNT) A-V-NIL)
XUWS0	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)  ;Value thrown
XUWPCN1	((M-1) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)  ;Tag
	(JUMP-EQUAL-XCT-NEXT M-1 A-V-TRUE XTHRW7)	  ;Tag of T means all the way
       ((A-CATCH-TAG) M-1)				  ; so don't check first
	(JUMP-EQUAL M-1 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))
		XTHRW7)					  ;Tag of 0 also special
;DROPS THROUGH

;DROPS IN, or jumps back from XTHC5.
;Before actually going and munging anything, follow the open-call-block chain
;and find out whether the catch tag we're looking for actually exists.
;Register usage:
;  M-A	Virtual address of next call block (typeless) (either active or open)
;  M-B	Virtual address of next active call block (typeless)
;  M-C	Pdl buffer address of next call block (only low 10 bits valid)
;  M-D  Typeless virtual address of outermost active frame we are popping
;       that has the %%LP-CLS-TRAP-ON-EXIT bit set; or zero, if there is none.
;  M-1	arg into / result out of XTHCG
XTHC0	((M-D) A-ZERO)
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) M-AP)
	((M-B) Q-POINTER M-K)
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) A-IPMARK)
	((M-A) Q-POINTER M-K)
	((M-C) A-IPMARK)
	(JUMP-NOT-EQUAL M-A A-B XTHC2)			;JUMP IF FOUND OPEN CALL BLOCK
XTHC1	(CALL-XCT-NEXT XTHCG)				;GET CALL STATE Q
       ((M-1) ADD M-A (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-ZR) (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) M-1)
	(JUMP-EQUAL M-ZR A-ZERO XTHC-ERROR)	        ;REACHED END OF PDL DIDN'T FIND MARK.
	((M-B) SUB M-B A-ZR)
XTHC4	((M-ZR) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) M-1)
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-CLS-TRAP-ON-EXIT) M-1 XTHC-TRAP-LATER)
	((M-A) SUB M-A A-ZR)
	(JUMP-EQUAL-XCT-NEXT M-A A-B XTHC1)
       ((M-C) SUB M-C A-ZR)
XTHC2	(CALL-XCT-NEXT XTHCG)				;GET LPFEF Q
       ((M-1) M-A)
	(JUMP-NOT-EQUAL M-1 A-CATCH-MARK XTHC3)		;NO GOOD
	(CALL-XCT-NEXT XTHCG)
       ((M-1) ADD M-A (A-CONSTANT 1))			;GET FIRST ARG
	(JUMP-EQUAL M-1 A-CATCH-TAG XTHC5)		;FOUND THE ONE WE'RE LOOKING FOR,
							;IT'S NOW SAFE TO GO THROW FOR REAL.
	(JUMP-EQUAL M-1 A-V-NIL XTHC5)			;FOUND CATCH-ALL, THATS OK TOO.
XTHC3	(CALL-XCT-NEXT XTHCG)				;GET CALL STATE Q
       ((M-1) ADD M-A (A-CONSTANT (EVAL %LP-CALL-STATE)))
	(JUMP XTHC4)

XTHC5	(JUMP-EQUAL M-D A-ZERO XTHRW7)
	((M-A) A-CATCH-TAG)
	((M-B) A-CATCH-COUNT)
	((M-C) A-CATCH-ACTION)
	((M-E) A-CATCH-MARK)
	((M-D) DPB M-D Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	(CALL TRAP)
    (ERROR-TABLE THROW-EXIT-TRAP)
	;Restart after clearing the trap-on-exit bit
	;of all the frames we are exiting.
	((A-CATCH-TAG) M-A)
	((A-CATCH-COUNT) M-B)
	((A-CATCH-ACTION) M-C)
	((A-CATCH-MARK) M-E)
	(JUMP XTHC0)

;Keep track of the lowest stack frame that has the %%LP-CLS-TRAP-ON-EXIT bit set.
XTHC-TRAP-LATER
	(POPJ-XCT-NEXT)
	((M-D) M-A)

XTHC-ERROR
	((M-A) A-CATCH-TAG)
	((M-B) A-CATCH-COUNT)
	((M-C) A-CATCH-ACTION)
	(CALL TRAP)
   (ERROR-TABLE THROW-TAG-NOT-SEEN)	;The EH knows specially about this entry.
					;It knows the tag is in M-A, the value is in M-T,
					;the count is in M-B, and the action is in M-C.
	((A-CATCH-TAG) M-A)
	((A-CATCH-COUNT) M-B)
	((A-CATCH-ACTION) M-C)
	(JUMP XTHC0)

;GET A WORD WHOSE UNTYPED VIRTUAL ADDRESS IS IN M-1.  FOR SPEED, ATTEMPTS
;TO FIGURE OUT IF IT IS IN THE PDL BUFFER AND IF SO GET IT DIRECTLY
;WITHOUT BOTHERING WITH PAGE TRAPS.  BASHES M-1 TO Q-TYPED-POINTER OF THE FETCHED DATA.
XTHCG	(JUMP-LESS-THAN M-1 A-PDL-BUFFER-VIRTUAL-ADDRESS XTHCG1)
	((M-1) SUB M-1 A-A)
	(POPJ-AFTER-NEXT (PDL-BUFFER-INDEX) ADD M-1 A-C)
       ((M-1) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)

XTHCG1	((VMA-START-READ) M-1)
	(CHECK-PAGE-READ)			;WILL PROBABLY ALWAYS FAULT
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-1) Q-TYPED-POINTER READ-MEMORY-DATA)

;Here from QMDDR if there are open call blocks in this frame.  It could
;be an UNWIND-PROTECT, so we come here to check it out by doing a throw
;of the value being returned, to the tag 0.
QMDDR-THROW
	((A-CATCH-TAG) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))) ;0
	((A-CATCH-MARK) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
					  *CATCH-U-CODE-ENTRY-/#)))
	((A-CATCH-ACTION) A-V-NIL)
	((A-CATCH-COUNT) A-V-NIL)
		;drop into XTHRW7
;This is the main throw loop.  Come here for each frame.
XTHRW7	(JUMP-EQUAL-XCT-NEXT M-AP A-IPMARK XTHRW1) ;LAST FRAME ACTIVE, UNWIND IT
       ((M-R) A-V-NIL)				;GET NIL ON THE M SIDE FOR LATER
	((M-I PDL-BUFFER-INDEX) A-IPMARK)	;LAST FRAME OPEN, NOTE IT MUST ALREADY BE IN
						; PDL BUFFER, SINCE ENTIRE ACTIVE FRAME IS.
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
	(JUMP-NOT-EQUAL M-A A-CATCH-MARK XTHRW2)	;THATS NOT WHAT LOOKING FOR
	((PDL-BUFFER-INDEX) ADD A-IPMARK M-ZERO ALU-CARRY-IN-ONE)
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
	(JUMP-EQUAL M-A A-V-TRUE XTHRW4)	;FOUND UNWIND-PROTECT, RESUME IT
	((M-1) A-V-TRUE)
	(JUMP-EQUAL A-CATCH-TAG M-1 XTHRW2)	;IF UNWINDING ALL THE WAY, KEEP LOOKING
	(JUMP-EQUAL M-A A-V-NIL XTHRW4)		;FOUND CATCH-ALL, RESUME IT
	(JUMP-NOT-EQUAL M-A A-CATCH-TAG XTHRW2)	;DIDN'T FIND RIGHT TAG, KEEP LOOKING
;FOUND FRAME TO RESUME
XTHRW4	((PDL-BUFFER-INDEX) ADD M-I (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-B) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)	;PRESERVE FOR USE BELOW
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%LP-CLS-ADI-PRESENT) C-PDL-BUFFER-INDEX 
		XTHRW9)		;NO ADI, HAD BETTER BE DESTINATION RETURN
	((PDL-BUFFER-INDEX M-D) SUB M-I (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH)))
XTHRW3	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP) 
		     Q-DATA-TYPE C-PDL-BUFFER-INDEX TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE DATA-TYPE-SCREWUP ADI)
	((M-A) (LISP-BYTE %%ADI-TYPE) C-PDL-BUFFER-INDEX)
	(JUMP-NOT-EQUAL M-A (A-CONSTANT (EVAL ADI-RESTART-PC)) XTHRW8)
	((M-J) (LISP-BYTE %%ADI-RPC-MICRO-STACK-LEVEL) C-PDL-BUFFER-INDEX)
	((PDL-BUFFER-INDEX) SUB M-D (A-CONSTANT 1))
	((M-E) Q-POINTER C-PDL-BUFFER-INDEX)	    ;Restart PC
	((PDL-BUFFER-INDEX) M-AP)
	((M-TEM) Q-DATA-TYPE C-PDL-BUFFER-INDEX)
	;; To make *CATCH in a micro-compiled function work will require more hair
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FEF-POINTER)) ILLOP)
	;; Change frame's return PC to restart PC
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((M-TEM) C-PDL-BUFFER-INDEX)
	((C-PDL-BUFFER-INDEX) DPB M-E (LISP-BYTE %%LP-EXS-EXIT-PC) A-TEM)
	;; Pop micro-stack back to specified level
XTHRW5	((M-ZR) MICRO-STACK-POINTER)		;INVOLVES A LDB OP
	(JUMP-EQUAL M-ZR A-J XTHRW6)
	(CALL-LESS-THAN M-ZR A-J ILLOP)		;Already popped more than that?
	((M-ZR) MICRO-STACK-DATA-POP)
	(JUMP-XCT-NEXT XTHRW5)
       (CALL-IF-BIT-SET %%-PPBSPC M-ZR BBLKP)

XTHRW6A	(CALL QUNBND)		;POP BINDING AND DROP THRU. CLOBBERS M-C.
 ;ON ENTRY HERE, M-D HAS PDL-BUFFER INDEX OF ADI-RESTART-PC ADI, OR -1 IF NONE.
XTHRW6	(JUMP-LESS-THAN M-D A-ZERO XTHRW6B)	;IF ENCOUNTERED *CATCH W/O ADI-RESTART-PC ADI,
			;DONT TRY TO HACK BIND STACK.  THIS CAN HAPPEN VIA INTERPRETED 
			;*CATCH S.  SINCE FRAME DESTINATION MUST BE D-RETURN,
			;NO NEED TO HACK BIND STACK ANYWAY.
	((PDL-BUFFER-INDEX) SUB M-D (A-CONSTANT 3))  ;MOVE BACK TO THE DATA Q 
		;PREVIOUS ADI BLOCK WHICH HAD BETTER BE AN ADI-BIND-STACK-LEVEL BLOCK
	((M-B) Q-POINTER C-PDL-BUFFER-INDEX)	;GET BIND-STACK-LEVEL
	(JUMP-IF-BIT-CLEAR BOXED-SIGN-BIT M-B XTHRW6C)  ;SIGN EXTEND SINCE EMPTY STACK
	((M-B) SELECTIVE-DEPOSIT M-B Q-POINTER (A-CONSTANT -1)) ;IS LEVEL OF -1
XTHRW6C	((M-J) A-QLBNDP)		; COMPUTE CURRENT RELATIVE STACK LEVEL
	((M-J) SUB M-J A-QLBNDO)
	(CALL-LESS-THAN M-J A-B ILLOP)	;ALREADY OVERPOPPED?
	(JUMP-NOT-EQUAL M-J A-B XTHRW6A) ;EVIDENTLY A BIND WAS DONE WITHIN THIS BLOCK ..
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))  ;STORE BACK QBBFL
	((M-TEM) C-PDL-BUFFER-INDEX)		;WHICH MAY HAVE BEEN CLEARED
	((C-PDL-BUFFER-INDEX) DPB M-FLAGS (LISP-BYTE %%LP-EXS-PC-STATUS) A-TEM)
XTHRW6B	((PDL-BUFFER-INDEX) SUB M-I A-AP)	;THIS EFFECTIVELY CANCELS WHAT WILL BE
	((M-PDL-BUFFER-ACTIVE-QS) ADD		; DONE AT QMEX1
		PDL-BUFFER-INDEX A-PDL-BUFFER-ACTIVE-QS)
	((M-AP) (BYTE-FIELD 10. 0) M-I)		;SIMULATE ACTIVATING CATCH FRAME
	((M-TEM) A-CATCH-TAG)			;IF THROWING OUT TOP, DON'T STOP ON
	(JUMP-EQUAL M-TEM A-V-TRUE XTHRW6D)	; UNWIND-PROTECT, GO WHOLE WAY
	(JUMP-NOT-EQUAL A-CATCH-ACTION M-R XUWR2);ACTION NON-NIL => DONT REALLY RESUME
						; EXECUTION, CALL FUNCTION INSTEAD.
XTHRW6D	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMEX1)))
	((M-S) A-ZERO)
	(CALL XRNVR)				;FIRST VALUE IS VALUE THROWN (STILL IN M-T)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMEX1)))
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVR)			;SECOND VALUE IS TAG
       ((M-T) A-CATCH-TAG)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMEX1)))
	((M-S) A-ZERO)
	(CALL-XCT-NEXT XRNVR)			;THIRD VALUE IS COUNT
       ((M-T) A-CATCH-COUNT)
	(JUMP-XCT-NEXT QMEX1)			;FOURTH VALUE IS ACTION
       ((M-T) A-CATCH-ACTION)

XTHRW8	(CALL-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX ILLOP)
	((PDL-BUFFER-INDEX M-D) SUB M-D (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX XTHRW9)
	((PDL-BUFFER-INDEX M-D) SUB M-D (A-CONSTANT 1))
	(JUMP-XCT-NEXT XTHRW3)
       ((M-D) (BYTE-FIELD 10. 0) M-D)	;ASSURE M-D POSITIVE SO CHECK AT XTHRW6 WINS.

;RAN OUT OF ADI.  THE SAVED DESTINATION HAD BETTER BE D-RETURN OR ERROR.  THIS
;CAN HAPPEN MAINLY THRU INTERPRETED CALLS TO *CATCH.
XTHRW9	((PDL-BUFFER-INDEX) ADD M-I (A-CONSTANT (EVAL %LP-CALL-STATE)))
;	((M-C) (LISP-BYTE %%LP-CLS-DESTINATION) C-PDL-BUFFER-INDEX)
;	(CALL-NOT-EQUAL M-C (A-CONSTANT D-RETURN) ILLOP)
	((M-D) (M-CONSTANT -1))		;SET FLAG THAT RESTART-PC ADI NOT FOUND, SO
				;BIND PDL HACKERY NOT ATTEMPTED.
	((M-S) (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) C-PDL-BUFFER-INDEX)
	((M-I) SUB M-I A-S)
	(JUMP-XCT-NEXT XTHRW5)
       ((M-J) M-ZERO)				;Flush whole micro-stack

;Skip this open frame
XTHRW2	((PDL-BUFFER-INDEX) ADD M-I (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-ZR) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) C-PDL-BUFFER-INDEX)
	((M-ZR) SUB M-I A-ZR)
	(JUMP-XCT-NEXT XTHRW7)
       ((A-IPMARK) (BYTE-FIELD 10. 0) M-ZR)	;ASSURE NO GARBAGE IN A-IPMARK

;Unwind an active frame
XTHRW1	((M-TEM) MICRO-STACK-POINTER)		;INVOLVES A LDB OP
	(JUMP-EQUAL M-TEM A-ZERO XTHRW1A)	;FLUSH MICRO-STACK
	((M-TEM) MICRO-STACK-DATA-POP)
	(JUMP-XCT-NEXT XTHRW1)
       (CALL-IF-BIT-SET %%-PPBSPC M-TEM BBLKP)

XTHRW1A	((M-TEM) A-CATCH-TAG)			;CHECK FOR THROW TAG OF 0
	(JUMP-EQUAL M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))
		QMDDR0)				;YES, RETURN FROM THIS FRAME
	(JUMP-EQUAL M-R A-CATCH-COUNT XTHRW1B)	;JUMP IF NO COUNT
	((A-CATCH-COUNT Q-R) ADD A-CATCH-COUNT (M-CONSTANT -1))
	(JUMP-IF-BIT-SET (BYTE-FIELD 1 23.) Q-R XUWR1)  ;REACHED MAGIC COUNT, RESUME BY RETURNING
XTHRW1B	(CALL-IF-BIT-SET M-QBBFL BBLKP)  	;POP BINDING-BLOCK IF FRAME HAS ONE
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((A-TEM1) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) C-PDL-BUFFER-INDEX)
	((M-ZR) SUB M-AP A-TEM1)		;COMPUTE PREV A-IPMARK
	((A-IPMARK) (BYTE-FIELD 10. 0) M-ZR)	;RESTORE THAT
	((A-TEM1) (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) C-PDL-BUFFER-INDEX)
	((PDL-BUFFER-POINTER) SUB M-AP (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH))) ;FLUSH PDL
	(JUMP-EQUAL A-TEM1 M-ZERO XUWR2)	;OFF THE BOTTOM OF THE STACK, GO CALL THE
						; ACTION, HAVING THROWN ALL THE WAY
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-CLS-ADI-PRESENT)
		C-PDL-BUFFER-INDEX QRAD1R)	;FLUSH ADDTL INFO
	((PDL-BUFFER-INDEX) SUB M-AP A-TEM1)	;RESTORE M-AP
	((M-AP) PDL-BUFFER-INDEX)	;THIS MASKS M-AP TO 10 BITS
	((M-PDL-BUFFER-ACTIVE-QS) SUB M-PDL-BUFFER-ACTIVE-QS A-TEM1)
	(CALL-LESS-THAN M-PDL-BUFFER-ACTIVE-QS 
			(A-CONSTANT PDL-BUFFER-LOW-WARNING) PDL-BUFFER-REFILL)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-EXIT-STATE)))
	((M-FLAGS) (LISP-BYTE %%LP-EXS-PC-STATUS) C-PDL-BUFFER-INDEX A-FLAGS)
	(CALL-IF-BIT-SET (LISP-BYTE %%LP-EXS-MICRO-STACK-SAVED) C-PDL-BUFFER-INDEX QMMPOP)
						;RESTORE USTACK FROM BINDING STACK
	(JUMP XTHRW7)

;HERE WHEN THE COUNT RUNS OUT
XUWR1	(CALL-NOT-EQUAL A-CATCH-ACTION M-R XUWR2)	;CALL FUNCTION?
	(JUMP QMDDR0)	;CAUSE ACTIVE FRAME TO RETURN VALUE

;HERE WHEN ACTION NOT NIL, IT IS A FUNCTION TO BE CALLED.
XUWR2	(CALL P3ZERO)
	((C-PDL-BUFFER-POINTER-PUSH) A-CATCH-ACTION)
	((C-PDL-BUFFER-POINTER-PUSH) Q-TYPED-POINTER M-T
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	((ARG-JUMP MMCALL) (I-ARG 1))
;IF THROWING OUT WHOLE WAY, SHOULDN'T RETURN.  MICROSTACK MUST BE CLEAR
;IN THIS CASE OR MLLV WILL STORE IT IN THE WRONG FRAME, BECAUSE OF THE
;ANOMALOUS CASE OF M-AP = M-S.  IF NOT THROWING OUT WHOLE WAY, FUNCTION
;MAY RETURN AND ITS VALUE WILL BE RETURNED FROM THE *CATCH BY THE EXIT
;TO QMDDR0 AT XUWR1.

;;; STUFF FOR CALLS WITH NUMBER OF ARGUMENTS NOT KNOWN AT COMPILE TIME
;;; AND FOR MAKING CALLS WITH SPECIAL ADI OF DIVERS SORTS

XOCB  (MISC-INST-ENTRY %OPEN-CALL-BLOCK)  ;<FCTN><ADI-PAIRS><DEST>
	((M-C) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-A) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-EQUAL M-A A-ZERO CBM0)		;If no ADI, push regular call block
	((PDL-BUFFER-INDEX) PDL-BUFFER-POINTER)	;ADI, fix the flag bits
	((M-A) ADD M-A A-A)			;2 QS per ADI pair
XOCB1	((C-PDL-BUFFER-INDEX) IOR C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-MASK %%ADI-PREVIOUS-ADI-FLAG)))
	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-INDEX (A-CONSTANT 1))
	(JUMP-NOT-EQUAL-XCT-NEXT M-A (A-CONSTANT 2) XOCB1)
       ((M-A) SUB M-A (A-CONSTANT 1))
	(CALL-XCT-NEXT CBM0)		;Push call block but take dest from M-C
       ((C-PDL-BUFFER-INDEX)		;Clear flag bit in last wd of ADI
		ANDCA C-PDL-BUFFER-INDEX (A-CONSTANT (BYTE-MASK %%ADI-PREVIOUS-ADI-FLAG)))
	(POPJ-AFTER-NEXT		;Fix the ADI-present flag
	 (PDL-BUFFER-INDEX) ADD PDL-BUFFER-POINTER (A-CONSTANT (EVAL %LP-CALL-STATE)))
       ((C-PDL-BUFFER-INDEX) IOR C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-MASK %%LP-CLS-ADI-PRESENT)))
	
XAOCB (MISC-INST-ENTRY %ACTIVATE-OPEN-CALL-BLOCK)
	;;*** this code is temporary to get around compiler bug
	((M-TEM) MICRO-STACK-POINTER)
	(JUMP-EQUAL M-TEM A-ZERO XAOCB0)
	(JUMP XAOCB MICRO-STACK-PNTR-AND-DATA-POP)

XAOCB0	;;*** end of temporary code
	(JUMP-XCT-NEXT QMRCL)		;Fix CDR-code of last arg then activate call
       ((C-PDL-BUFFER-POINTER) DPB C-PDL-BUFFER-POINTER
		Q-ALL-BUT-CDR-CODE (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
		
;;; I would be rather surprised if this is ever called!!  Foo, I'm surprised!
XPUSH (MISC-INST-ENTRY %PUSH)
	(POPJ-AFTER-NEXT 
	  (M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
       (NO-OP)

XAPDLR (MISC-INST-ENTRY %ASSURE-PDL-ROOM)
	((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;NUMBER OF PUSHES PLANNING TO DO
	((PDL-BUFFER-INDEX) M-A-1 PDL-BUFFER-POINTER A-AP)	;CURRENT FRAME SIZE
	(POPJ-AFTER-NEXT (M-2) ADD PDL-BUFFER-INDEX A-1)	;PROPOSED NEW FRAME SIZE
       (CALL-GREATER-THAN M-2 (A-CONSTANT 370) XAPDLR1)	;NOTE FUDGE FACTOR OF 10 SINCE WE DON'T
						;CURRENTLY KNOW HOW MANY COMPILER-GENERATED
						;PUSHES MIGHT BE GOING TO HAPPEN
XAPDLR1	(CALL TRAP)
    (ERROR-TABLE STACK-FRAME-TOO-LARGE)
    (ERROR-TABLE ARG-POPPED 0 M-1)

;This makes a list of specified length, full of NILs, on the stack.  Because it
;pushes on the stack it must be done at "top level" in the function body, rather
;than as an argument to a function, unless a SHRINK-PDL-SAVE-TOP instruction is
;emitted at a suitable place.
XMSL (MISC-INST-ENTRY %MAKE-STACK-LIST)
	(CALL XAPDLR)				;M-1 GETS LIST LENGTH, CHECK FOR ROOM
	(JUMP-EQUAL M-1 A-ZERO XFALSE)		;0-LENGTH LIST IS NIL
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)	;MAKE RETURN VALUE
       ((M-K) ADD PDL-BUFFER-POINTER (A-CONSTANT 1))
XMSL1	((C-PDL-BUFFER-POINTER-PUSH) DPB (M-CONSTANT -1)	;CDR-NEXT
		Q-CDR-CODE A-V-NIL)
	(JUMP-GREATER-THAN-XCT-NEXT M-1 (A-CONSTANT 1) XMSL1)
       ((M-1) SUB M-1 (A-CONSTANT 1))
	(POPJ-AFTER-NEXT (C-PDL-BUFFER-POINTER) Q-TYPED-POINTER C-PDL-BUFFER-POINTER
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
       ((M-T) Q-POINTER M-K (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))

;Like %MAKE-STACK-LIST but expects the contents of
;the list to be on the stack already,
;followed by a word containing the length, which we discard.
;We fix the cdr codes and return a pointer.
XMESL (MISC-INST-ENTRY %MAKE-EXPLICIT-STACK-LIST)
	((M-A) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-EQUAL M-A A-ZERO XFALSE)
	((M-K) SUB PDL-BUFFER-POINTER A-A)
	;Compute pointer to beginning of list.
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K PDL-BUFFER-INDEX) ADD M-K (A-CONSTANT 1))
	;B gets CDR-NEXT.
	((M-B) DPB (M-CONSTANT -1) Q-CDR-CODE)
	(JUMP-EQUAL M-A (A-CONSTANT 1) XMESL2)
;Give all but last element of list CDR-NEXT.
XMESL1
	((C-PDL-BUFFER-INDEX) Q-TYPED-POINTER C-PDL-BUFFER-INDEX A-B)
	((M-A) SUB M-A (A-CONSTANT 1))
	((PDL-BUFFER-INDEX) ADD PDL-BUFFER-INDEX (A-CONSTANT 1))
	(JUMP-GREATER-THAN M-A (A-CONSTANT 1) XMESL1)
XMESL2
;Give last element CDR-NIL.
	(POPJ-AFTER-NEXT
	 (C-PDL-BUFFER-INDEX) Q-TYPED-POINTER C-PDL-BUFFER-INDEX
			      (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	((M-T) Q-POINTER M-K (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))

;Like %MAKE-EXPLICIT-STACK-LIST except makes the last arg be the CDR.
XMESL* (MISC-INST-ENTRY %MAKE-EXPLICIT-STACK-LIST*)
	(CALL XMESL)
	;; After first making an ordinary list, fix up the last to cdr codes.
	((C-PDL-BUFFER-INDEX) Q-TYPED-POINTER C-PDL-BUFFER-INDEX
			      (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-ERROR)))
	(POPJ-AFTER-NEXT
	 (PDL-INDEX) SUB PDL-INDEX (A-CONSTANT 1))
       ((C-PDL-BUFFER-INDEX) Q-TYPED-POINTER C-PDL-BUFFER-INDEX
			     (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NORMAL)))
	
;A lexical closure is a pointer with type DTP-CLOSURE or DTP-STACK-CLOSURE
;to a couple of lists on the stack which look like
;(function ,(LOCF LEXICAL-ENVIRONMENT) ((,(%STACK-FRAME-POINTER) . ,LEXICAL-ENVIRONMENT)))
;This uses six slots.  We expect the index of the first one within the local block.
;We set up the third slot (to point to the fourth, cdr-nil),
;the fourth slot (to point to the fifth, cdr-nil),
;and the fifth (our own stack frame, cdr-normal).
;Then we return a pointer to the first slot, with DTP-STACK-CLOSURE.
XMLC (MISC-INST-ENTRY %MAKE-LEXICAL-CLOSURE)
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((M-2) C-PDL-BUFFER-INDEX)
	((C-PDL-BUFFER-INDEX) DPB M-MINUS-ONE (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG) A-2)

	((M-B) (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN) C-PDL-BUFFER-INDEX)
	((M-B) ADD C-PDL-BUFFER-POINTER-POP A-B)
;Put in M-T the memory address of the first slot.
	((M-K) ADD M-AP A-B)
	((PDL-BUFFER-INDEX) ADD M-K (A-CONSTANT 2))
	(CALL CONVERT-PDL-BUFFER-ADDRESS)
	((M-T) DPB M-K Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-STACK-CLOSURE)))
;Set up the third slot.
	((M-K) M+A+1 M-T (A-CONSTANT 2))
	((C-PDL-BUFFER-INDEX) DPB M-K Q-POINTER 
			      (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LIST)
						(BYTE-VALUE Q-CDR-CODE CDR-NIL))))
;Set up the fourth slot.
	((PDL-BUFFER-INDEX) M+1 PDL-BUFFER-INDEX)
	((M-K) M+1 M-K)
	((C-PDL-BUFFER-INDEX) DPB M-K Q-POINTER 
			      (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LIST)
						(BYTE-VALUE Q-CDR-CODE CDR-NIL))))
;Set up the fifth slot.
	((PDL-BUFFER-INDEX) M+1 PDL-BUFFER-INDEX)
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) M-AP)
	((C-PDL-BUFFER-INDEX) DPB M-K Q-POINTER 
			      (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LIST)
						(BYTE-VALUE Q-CDR-CODE CDR-NORMAL))))
;Set up the sixth slot.
	((PDL-BUFFER-INDEX) M+1 PDL-BUFFER-INDEX)
	(POPJ-AFTER-NEXT
	 (M-K) A-LEXICAL-ENVIRONMENT)
	((C-PDL-BUFFER-INDEX) DPB M-K Q-TYPED-POINTER 
			      (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-ERROR)))

;(%SPREAD-N list number) pushes the first <number> elements of <list>
;onto the stack.  If the destination is D-LAST, we then activate the call block.
;If the list is not long enough, we keep CDRing and presumably pushing NILs.
XSPREAD-N (MISC-INST-ENTRY %SPREAD-N)
	((M-GARBAGE) MICRO-STACK-DATA-POP)	;DON'T STORE IN DESTINATION
	((M-K) Q-POINTER PDL-POP)	;NUMBER OF ELEMENTS TO SPREAD.
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;LIST TO BE SPREAD
	((M-C) M-INST-DEST)
	((M-D) M-T)		;SAVE ORIGINAL ARGS FOR ERROR MSG.
	((M-E) SUB M-K (A-CONSTANT 1))
	((PDL-BUFFER-INDEX) M-A-1 PDL-BUFFER-POINTER A-AP)	;CURRENT FRAME SIZE (MOD 2000)
	((M-B) SUB PDL-BUFFER-INDEX (A-CONSTANT 370))	;-# PUSHES ALLOWED (FUDGE FACTOR OF 10)
	((M-B) SUB M-ZERO A-B)
	(CALL-LESS-THAN M-B A-E TRAP)
    (ERROR-TABLE STACK-FRAME-TOO-LARGE)
;M-E counts down to zero how many things we want to push.
;(It is number of pushes to do minus 1).
;M-C is the destination, saved for XSPREAD-EMPTY.
;M-T is the rest of the list.
;M-D and M-K are copies of the original arguments.
XSPREAD-N-1
	(CALL-XCT-NEXT QCAR)
       ((M-A) A-T)
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-T
		Q-TYPED-POINTER (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	(CALL-XCT-NEXT QCDR)
       ((M-T) A-A)
	(JUMP-GREATER-THAN-XCT-NEXT M-E A-ZERO XSPREAD-N-1)
       ((M-E) SUB M-E (A-CONSTANT 1))
	(JUMP XSPREAD-EMPTY)

;(%SPREAD LIST)D-NEXT sends the elements of the list which is
;on the top of the stack to D-NEXT.  (%SPREAD LIST)D-LAST is similar
;but sends the last one to D-LAST (i.e. activates an open-call).
;(%SPREAD LIST)D-PDL is identical to (%SPREAD LIST)D-NEXT
(ERROR-TABLE DEFAULT-ARG-LOCATIONS %SPREAD M-D)

XSPREAD (MISC-INST-ENTRY %SPREAD)
	((M-GARBAGE) MICRO-STACK-DATA-POP)	;DON'T STORE IN DESTINATION
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;LIST TO BE SPREAD
	((M-C) M-INST-DEST)
	((M-D) M-T)					;SAVE ORIGINAL ARG FOR ERROR MSG.
MC-SPREAD-0						;ENTRY FOR MICROCOMPILED CODE
	((PDL-BUFFER-INDEX) M-A-1 PDL-BUFFER-POINTER A-AP)	;CURRENT FRAME SIZE (MOD 2000)
	((M-B) SUB PDL-BUFFER-INDEX (A-CONSTANT 370))	;-# PUSHES ALLOWED (FUDGE FACTOR OF 10)
XSPREAD-1
	(JUMP-EQUAL M-T A-V-NIL XSPREAD-EMPTY)
	(CALL-XCT-NEXT QCAR)
       ((M-A) A-T)
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-T
		Q-TYPED-POINTER (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	(CALL-XCT-NEXT QCDR)
       ((M-T) A-A)
	(JUMP-LESS-THAN-XCT-NEXT M-B A-ZERO XSPREAD-1)
       ((M-B) ADD M-B (A-CONSTANT 1))		;DECREASE NEGATIVE COUNT OF PUSHES ALLOWED
	(CALL TRAP)
    (ERROR-TABLE STACK-FRAME-TOO-LARGE)

XSPREAD-EMPTY
	(JUMP-EQUAL M-C (A-CONSTANT D-LAST-OLD) XAOCB)
	(JUMP-EQUAL M-C (A-CONSTANT D-LAST) XAOCB)
	(POPJ)

XCTO (MISC-INST-ENTRY %CATCH-OPEN)
	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-T) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
				  *CATCH-U-CODE-ENTRY-/#)))
	(CALL-XCT-NEXT SBPL-ADI)	;PUSH ADI-BIND-STACK-LEVEL BLOCK
       ((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;GET RESTART PC OFF STACK
	((C-PDL-BUFFER-POINTER-PUSH)
		DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) A-S)	;PUSH RESTART PC
	((M-R) MICRO-STACK-POINTER)
	(JUMP-XCT-NEXT XCTO1)
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-R (LISP-BYTE %%ADI-RPC-MICRO-STACK-LEVEL)
	     (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
			       (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
			       (BYTE-VALUE %%ADI-TYPE ADI-RESTART-PC))))
	
SBPL-ADI((M-1) A-QLBNDP)		;STORE ADI-BIND-STACK-LEVEL ADI BLOCK
	((M-1) SUB M-1 A-QLBNDO)
	(POPJ-AFTER-NEXT 
	 (C-PDL-BUFFER-POINTER-PUSH) DPB M-1 Q-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
       ((C-PDL-BUFFER-POINTER-PUSH) 
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				  (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
				  (BYTE-VALUE %%ADI-TYPE ADI-BIND-STACK-LEVEL))))

XCTOM (MISC-INST-ENTRY %CATCH-OPEN-MV)
	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-T) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-U-ENTRY)
				  *CATCH-U-CODE-ENTRY-/#)))
	((M-D) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;# VALS TO BE RECVD
	(CALL-XCT-NEXT LMVRB)				;LEAVE RM ON PDL TO RECEIVE VALS
       ((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;RESTART PC
	(CALL SBPL-ADI)		;PUSH ADI-BIND-STACK-LEVEL BLOCK
	((C-PDL-BUFFER-POINTER-PUSH) DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) A-S)
	((M-R) MICRO-STACK-POINTER)
        ((C-PDL-BUFFER-POINTER-PUSH) DPB M-R (LISP-BYTE %%ADI-RPC-MICRO-STACK-LEVEL)
	     (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
			       (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
			       (BYTE-VALUE %%ADI-TYPE ADI-RESTART-PC))))
	(JUMP-XCT-NEXT XCTOM1)
       ((M-K) DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) A-K) ;THIS ISN'T LAST ADI

XLEC (MISC-INST-ENTRY %LEXPR-CALL)
	(JUMP-XCT-NEXT XLEC1)
       ((M-S) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				(BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
				(BYTE-VALUE %%ADI-TYPE ADI-LEXPR-CALL))))

XFEC (MISC-INST-ENTRY %FEXPR-CALL)
	((M-S) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				 (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
				 (BYTE-VALUE %%ADI-TYPE ADI-FEXPR-CALL))))
XLEC1	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-T) C-PDL-BUFFER-POINTER-POP)	;FUNCTION TO CALL
	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(JUMP-XCT-NEXT XCTO1)
       ((C-PDL-BUFFER-POINTER-PUSH) M-S)	;STORE ADI

XLECM (MISC-INST-ENTRY %LEXPR-CALL-MV)
	(JUMP-XCT-NEXT XLECM1)
       ((M-S) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				(BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
				(BYTE-VALUE %%ADI-TYPE ADI-LEXPR-CALL))))

XFECM (MISC-INST-ENTRY %FEXPR-CALL-MV)
	((M-S) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				 (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
				 (BYTE-VALUE %%ADI-TYPE ADI-FEXPR-CALL))))
XLECM1	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-D) C-PDL-BUFFER-POINTER-POP)		;NUMBER OF VALUES DESIRED
	(CALL-XCT-NEXT LMVRB)			;MAKE ROOM ON PDL
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;FCN TO CALL
	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((C-PDL-BUFFER-POINTER-PUSH) M-S)	;STORE ADI
	(JUMP-XCT-NEXT XCTOM1)
       ((M-K) DPB (M-CONSTANT -1) (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) A-K) ;THIS ISN'T LAST ADI

XC0MVL (MISC-INST-ENTRY %CALL0-MULT-VALUE-LIST)
	((M-TEM) MICRO-STACK-POINTER)		;Insert continuation to QMRCL in pdl
	(JUMP-EQUAL M-TEM A-ZERO XC0MVL1)
	((M-GARBAGE) MICRO-STACK-DATA-POP)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMRCL)))
XC0MVL1	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMRCL)))
XCMVL (MISC-INST-ENTRY %CALL-MULT-VALUE-LIST)
	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-T) C-PDL-BUFFER-POINTER-POP)	;FCN TO CALL
	((C-PDL-BUFFER-POINTER-PUSH) 	;INIT CDR OF LIST, ON RET WILL BE LIST
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-SYMBOL)  ;CDR-NEXT because this
				  (BYTE-VALUE Q-CDR-CODE CDR-NEXT))))  ;can get left on stack
						;and eventually become an argument.
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) PDL-BUFFER-POINTER)		;GET LOCATIVE POINTER TO THAT NIL
	((C-PDL-BUFFER-POINTER-PUSH) M-K)	;AS 2ND ADI WORD
	(JUMP-XCT-NEXT XCTO1)
       ((C-PDL-BUFFER-POINTER-PUSH)		;ADI FOR RETURN VALUES INFO
	     (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
			       (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
			       (BYTE-VALUE %%ADI-TYPE ADI-RETURN-INFO)
			       (BYTE-VALUE %%ADI-RET-STORING-OPTION ADI-ST-MAKE-LIST))))

XC0MV (MISC-INST-ENTRY %CALL0-MULT-VALUE)
	((M-TEM) MICRO-STACK-POINTER)		;Insert continuation to QMRCL in pdl
	(JUMP-EQUAL M-TEM A-ZERO XC0MV1)
	((M-GARBAGE) MICRO-STACK-DATA-POP)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMRCL)))
XC0MV1	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QMRCL)))
XCMV (MISC-INST-ENTRY %CALL-MULT-VALUE)
	(CALL-XCT-NEXT FLUSH-DESTINATION-RETURN-PC)
       ((M-D) C-PDL-BUFFER-POINTER-POP)	;# VALUES DESIRED
XCMV1	(CALL-XCT-NEXT LMVRB)			;MAKE ROOM ON PDL
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;FCN TO CALL
XCTOM1	((C-PDL-BUFFER-POINTER-PUSH) M-K)	;RETURN VALUES BLOCK POINTER
	((M-K) DPB M-D		;ADI FOR RETURN VALUES INFO
	  (LISP-BYTE %%ADI-RET-NUM-VALS-EXPECTING)
	     (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
			       (BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1)
			       (BYTE-VALUE %%ADI-TYPE ADI-RETURN-INFO)
			       (BYTE-VALUE %%ADI-RET-STORING-OPTION ADI-ST-BLOCK))))
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-D
	  (LISP-BYTE %%ADI-RET-NUM-VALS-TOTAL) A-K)
XCTO1	(CALL CBM)				;STORE CALL BLOCK
	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-ZR (A-CONSTANT (EVAL %LP-CALL-STATE)))
       ((C-PDL-BUFFER-INDEX) IOR C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-MASK %%LP-CLS-ADI-PRESENT)))

;; Push slots for multiple values to go in.
;; MD should be a fixnum saying how many slots.
;; Returns locative to first slot in M-K.
;; Clobbers M-D, M-E.
LMVRB	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP) Q-DATA-TYPE M-D TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE DATA-TYPE-SCREWUP ADI)
	((M-D) Q-POINTER M-D)
	(CALL-GREATER-THAN M-D (A-CONSTANT 100) TRAP)
   (ERROR-TABLE MVR-BAD-NUMBER M-D)
ULMVRB	(CALL-EQUAL M-D A-ZERO TRAP)
   (ERROR-TABLE MVR-BAD-NUMBER M-D)
	((M-K) PDL-BUFFER-POINTER)		;LOC OF BLOCK AS PDL INDEX
	((M-E) M-D)
LMVRB1	((C-PDL-BUFFER-POINTER-PUSH)		;RESERVE SLOTS, FILL WITH NIL
		DPB (M-CONSTANT -1) Q-CDR-CODE A-V-NIL)	;WITH CDR-NEXT
	(JUMP-GREATER-THAN-XCT-NEXT M-E (A-CONSTANT 1) LMVRB1)
       ((M-E) SUB M-E (A-CONSTANT 1))
	(JUMP-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)	;RET BLK PNTR AS LOCATIVE
       ((M-K) ADD M-K (A-CONSTANT 1))		;FIX POINTER

;;; The above misc instructions use their destination as a sub-opcode
;;; rather than as a normal destination.  This subroutine flushes the
;;; destination return address, if it is present.
;;; Note that none of the above will work anyway when called from micro-compiled code.
FLUSH-DESTINATION-RETURN-PC
	((M-TEM) M-INST-DEST)
	(POPJ-AFTER-NEXT POPJ-EQUAL M-TEM (A-CONSTANT D-IGNORE))
       ((M-GARBAGE) MICRO-STACK-DATA-POP)

;;; APPLY and MICRO-TO-MACRO calls (used by micro-compiled code and by
;;; certain things in the base microcode.)

UAPLY  (MISC-INST-ENTRY APPLY)
	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 1))
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)		;Function
	((M-A) Q-DATA-TYPE C-PDL-BUFFER-INDEX)
	(CALL-XCT-NEXT XARGI0)		;RETURN ARG-INFO IN M-T
       ((M-J) M-S)			;Save a copy of function for later.
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)	;Arguments
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARG-DESC-QUOTED-REST) M-T UAPFX)
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARG-DESC-EVALED-REST) M-T UAPFX)
;Note: calls to instances and select-methods come here because
;%args-info never says "rest arg" for them.  Ditto for funcallable hash tables.
;This causes trouble for interpreted fexprs since they expect safe rest args.
;APPLY-LAMBDA should fix that up for them.
UAPLY1	(CALL P3ZERO)				;PUSH MICRO-TO-MACRO CALL BLOCK, NO ADI
	((C-PDL-BUFFER-POINTER-PUSH) M-J)	;FINISH CALL BLOCK BY PUSHING FCTN
	((M-R) A-ZERO)			;COUNT OF # ARGS PUSHED
	(DISPATCH Q-DATA-TYPE M-A SKIP-IF-LIST)
	 (JUMP UAPLY4)
UAPLY5	(CALL-XCT-NEXT QCAR)
       ((M-T) M-A)
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-TYPED-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	(CALL-XCT-NEXT QCDR)
       ((M-T) M-A)
	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)
	 (JUMP UAPLY6)
	((M-A) M-T)
	(JUMP-XCT-NEXT UAPLY5)
       ((M-R) ADD M-R (A-CONSTANT 1))

UAPLY6	((C-PDL-BUFFER-POINTER) DPB C-PDL-BUFFER-POINTER Q-ALL-BUT-CDR-CODE 
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	(JUMP-XCT-NEXT UAPLY4)
       ((M-R) ADD M-R (A-CONSTANT 1))

UAPFX	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))	;ADI
	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (PLUS (PLUS
		(BYTE-VALUE Q-DATA-TYPE DTP-FIX)
		(BYTE-VALUE %%ADI-PREVIOUS-ADI-FLAG 1))
		(BYTE-VALUE %%ADI-TYPE ADI-FEXPR-CALL))))
	(CALL P3ADI)			;PUSH MICRO-TO-MACRO CALL BLOCK WITH ADI
	((C-PDL-BUFFER-POINTER-PUSH) M-J)	;function
	((C-PDL-BUFFER-POINTER-PUSH) M-A)	;list of args
	((M-R) (A-CONSTANT 1))
;This is like MMJCALL except that the number of args is already in M-R.
UAPLY4	((M-TEM) MICRO-STACK-DATA)		;Check the return address
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (I-MEM-LOC QMDDR)) UAPLY4R) ;ordinary return
;;; Change destination to D-RETURN so that multiple values will be passed
;;; back correctly.  Dont worry about args.  They will be flushed by frame unwindage.
	((M-GARBAGE) MICRO-STACK-DATA-POP)	;Flush return to QMDDR
	((M-TEM) A-IPMARK)			;Find LP-CLS Q of open call block
	((PDL-BUFFER-INDEX) ADD M-TEM (A-CONSTANT (EVAL %LP-CALL-STATE)))
	(JUMP-XCT-NEXT MMCAL4)
       ((C-PDL-BUFFER-INDEX) SUB C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-VALUE %%LP-CLS-DESTINATION
					(DIFFERENCE D-MICRO D-RETURN))))

UAPLY4R (CALL MMCAL4)
	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-POINTER) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))  ;remove args.
       (NO-OP)

;;; Activate a pending micro-to-macro call block.
;;; ((ARG-JUMP MMJCALL) (I-ARG number-args-pushed)) if you want to return the result(s)
;;; of the call as your own result(s).
;;; Changes the destination in the call-block from D-MICRO to D-RETURN if necessary
MMJCALL	((M-TEM) MICRO-STACK-DATA)		;Check the return address
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (I-MEM-LOC QMDDR)) MMCALL) ;ordinary return
;;; Change destination to D-RETURN so that multiple values will be passed
;;; back correctly.
	((M-GARBAGE) MICRO-STACK-DATA-POP)	;Flush return to QMDDR
MMJCALR	((M-TEM) A-IPMARK)			;Find LP-CLS Q of open call block
	((PDL-BUFFER-INDEX) ADD M-TEM (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((C-PDL-BUFFER-INDEX) SUB C-PDL-BUFFER-INDEX
		(A-CONSTANT (BYTE-VALUE %%LP-CLS-DESTINATION
					(DIFFERENCE D-MICRO D-RETURN))))
	;; Drop into MMCALL, dispatch-constant (I-ARG) still valid.
;;; Activate a pending micro-to-macro call block.
;;; ((ARG-CALL MMCALL) (I-ARG number-args-pushed)) if you want to get back the
;;; result of the function.  You can receive multiple values if you opened
;;; the call by pushing ADI and calling P3ADI rather than P3ZERO.
MMCALL	((M-R) READ-I-ARG)
;;; Here if M-R is already set up.
MMCAL4	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER A-R)	;Address of new frame
	((M-S) PDL-BUFFER-INDEX)		;Must be in both M-S and PDL-BUFFER-INDEX
	(CALL-NOT-EQUAL M-S A-IPMARK ILLOP)	;Frame not where it should be.  M-R lied?
       ((M-A) C-PDL-BUFFER-INDEX)		;M-A := FUNCTION TO CALL
	(DISPATCH Q-DATA-TYPE M-A D-QMRCL)	;Does MLLV if necc
       (CALL MLLV)


;;; "LINEAR" ENTER
;   M-A HAS PNTR TO FEF TO CALL
;   M-S HAS EVENTUAL NEW ARG POINTER (M-AP)
;   M-R HAS NUMBER OF ARGUMENTS
;WE DON'T SUPPORT USER COPYING AND FORWARDING OF FEFS,
;SO IT'S NOT NECESSARY TO CALL THE TRANSPORTER EVERYWHERE.
;CAN SEQUENCE BREAK ONCE WE GET PAST THE ARGUMENTS AND START DOING VARIABLE
;INITIALIZATIONS, WHICH CAN CAUSE ERRORS.  THIS WILL INVALIDATE A-LCTYP BUT
;PRESERVE THE LETTERED M-REGISTERS.
;*** WE STILL HAVE A PROBLEM WITH M-ERROR-SUBSTATUS NOT BEING PRESERVED

QLENTR	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%METER-FUNCTION-ENTRY-EXIT-ENABLE)
		M-METER-ENABLES METER-FUNCTION-ENTRY)
	((PDL-BUFFER-INDEX) SUB M-S A-AP)	;ASSURE ROOM IN PDL-BUFFER
	((M-PDL-BUFFER-ACTIVE-QS) ADD PDL-BUFFER-INDEX A-PDL-BUFFER-ACTIVE-QS)
	(CALL-GREATER-THAN-XCT-NEXT M-PDL-BUFFER-ACTIVE-QS 
			   A-PDL-BUFFER-HIGH-WARNING PDL-BUFFER-DUMP)
       ((M-AP) M-S)	;NEW ARG POINTER (DO THIS RIGHT AWAY TO MINIMIZE PROBLEMS IF ERR OUT)
	((VMA-START-READ) M-A)
	(CHECK-PAGE-READ)
	((M-ERROR-SUBSTATUS) M-ZERO)	;CLEAR OUT ERRORS
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
;Initialize call type (normal vs lexpr vs fexpr);
;usually this is 0, but may not be if tail recursive call.
	((A-LCTYP) (LISP-BYTE %%LP-ENS-LCTYP) C-PDL-BUFFER-INDEX)
	((M-D) Q-POINTER READ-MEMORY-DATA)	;GET FEF HEADER WORD
	((M-B) (LISP-BYTE %%HEADER-TYPE-FIELD) M-D)
	(CALL-NOT-EQUAL M-B (A-CONSTANT (EVAL %HEADER-TYPE-FEF)) ILLOP)	;NOT FEF
	((M-J) (LISP-BYTE %%FEFH-PC) M-D)	;MAY GET CHANGED DUE TO OPTIONAL ARGS.
					; ALSO NOTE RELATIVE TO FEF STILL
	(JUMP-IF-BIT-CLEAR-XCT-NEXT
	 (LISP-BYTE %%FEFH-GET-SELF-MAPPING-TABLE) M-D
	 QLENTR-NOT-METHOD)
       ((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL %LP-CALL-STATE)))
	(CALL-IF-BIT-CLEAR
	 (LISP-BYTE %%LP-CLS-SELF-MAP-PROVIDED) C-PDL-BUFFER-INDEX
	 QLENTR-GET-SELF-MAPPING-TABLE)
QLENTR-NOT-METHOD
	(JUMP-IF-BIT-SET (LISP-BYTE %%LP-CLS-ADI-PRESENT) 
			 C-PDL-BUFFER-INDEX QLEAI1)  ;FEXPR OR LEXPR ?
QLEAI2	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEFH-FAST-ARG) M-D QRENT)  ;NO FAST-OPTION
;NEED ERRONEOUS QUOTED ARG CHECK
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-FAST-ARG-OPT)))
	(CHECK-PAGE-READ)		;GET FAST-OPTION WORD
	((M-C) (LISP-BYTE %%FEFHI-FSO-MIN-ARGS) READ-MEMORY-DATA)
	((M-E) (LISP-BYTE %%FEFHI-FSO-MAX-ARGS) READ-MEMORY-DATA)
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARG-DESC-QUOTED-REST) READ-MEMORY-DATA QLFOA1)
	(JUMP-IF-BIT-SET (LISP-BYTE %%ARG-DESC-EVALED-REST) READ-MEMORY-DATA QLFOA1)
	(CALL-GREATER-THAN M-C A-R SET-TOO-FEW-ARGS)
	((Q-R) ADD M-E (A-CONSTANT (EVAL %LP-INITIAL-LOCAL-BLOCK-OFFSET)))
	((A-LOCALP) ADD Q-R A-S)
	((A-TEM1) DPB Q-R (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-C) DPB M-R (LISP-BYTE %%LP-ENS-NUM-ARGS-SUPPLIED) A-TEM1)
QLEAI5	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((C-PDL-BUFFER-INDEX) M-C)		;STORE ENTRY STATE Q
	(CALL-LESS-THAN M-E A-R SET-TOO-MANY-ARGS)
QFL2	(JUMP-LESS-OR-EQUAL M-E A-R QFL1)
	((C-PDL-BUFFER-POINTER-PUSH) A-V-NIL)	;DEFAULT UNSUPPLIED ARGS TO NIL
	(JUMP-XCT-NEXT QFL2)
       ((M-E) SUB M-E (A-CONSTANT 1))

METER-FUNCTION-ENTRY
	((A-METER-EVENT) (A-CONSTANT (EVAL %METER-FUNCTION-ENTRY-EVENT)))
	((C-PDL-BUFFER-POINTER-PUSH) M-A)
	(JUMP-XCT-NEXT METER-MICRO-WRITE-HEADER)
       ((A-METER-LENGTH) (A-CONSTANT 1))	;Number of meters pushed

SET-TOO-FEW-ARGS
	(POPJ-AFTER-NEXT (M-QBTFA) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)
       (NO-OP)

SET-TOO-MANY-ARGS
	(POPJ-AFTER-NEXT (M-QBTMA) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)
       (NO-OP)

;Bind SELF-MAPPING-TABLE to the right mapping table
;for the flavor whose name is stored in the fef in M-A.
;Must not clobber: M-A, M-D, M-J, M-R, M-S.
QLENTR-GET-SELF-MAPPING-TABLE
;Get the FEFHI-MISC word which contains the index of the start of the ADL.
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-MISC)))
	(CHECK-PAGE-READ)
	((A-TEM1) (LISP-BYTE %%FEFHI-MS-ARG-DESC-ORG) MD)
	((A-TEM1) ADD (M-CONSTANT -1) A-TEM1)
;Access the word before the ADL.  It contains the flavor name.
	((VMA-START-READ) ADD M-A A-TEM1)	
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
;Get the mapping table for SELF for that flavor.
	((C-PDL-BUFFER-POINTER-PUSH) M-A)
	(CALL-XCT-NEXT GET-SELF-MAPPING-TABLE)
       ((M-B) Q-TYPED-POINTER MD)	;Method-flavor-name into M-B.
	((M-A) C-PDL-BUFFER-POINTER-POP)
;Bind SELF-MAPPING-TABLE to it.
	(JUMP-XCT-NEXT BIND-SELF-MAP)
       ((M-B) M-T)

;Index wrt mapping table of the array leader slot that holds the name of
;the method-flavor the mapping table is for.
(ASSIGN %MAPPING-TABLE-FLAVOR -3)
XGET-SELF-MAPPING-TABLE
	(MISC-INST-ENTRY %GET-SELF-MAPPING-TABLE)
	((M-B) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)

;Given flavor name in M-B, return mapping table in M-B.
GET-SELF-MAPPING-TABLE
	((M-T) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-SELF-MAPPING-TABLE)
	(JUMP-EQUAL M-T A-V-NIL GET-SELF-MAPPING-TABLE-1)
;If we currently have a non-nil mapping table, is it for this flavor?
;The mapping table can be a flavor name.  If so, it's good iff equals desired flavor.
	(POPJ-EQUAL M-T A-B)
	((M-1) Q-DATA-TYPE M-T)
;Any other non-array means it's the wrong table.
	(JUMP-NOT-EQUAL M-1 (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) GET-SELF-MAPPING-TABLE-1)
;An array: get the leader element that says what it is for.
	((VMA-START-READ) ADD M-T (A-CONSTANT %MAPPING-TABLE-FLAVOR)) ;this is negative
	(CHECK-PAGE-READ)			;Look in leader element 1.
	(DISPATCH TRANSPORT MD)
	((VMA-START-READ) ADD MD (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-TYPENAME)))
	(CHECK-PAGE-READ)			;Access the flavor name in the flavor object
	(DISPATCH TRANSPORT MD)
	(POPJ-EQUAL MD A-B)			;Match => return this array, no need to search
GET-SELF-MAPPING-TABLE-1
	((M-TEM) A-SELF)			;If SELF is not an instance, return NIL.
	((M-TEM) Q-DATA-TYPE M-TEM)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) XFALSE)
	((VMA-START-READ) A-SELF)		;Get the flavor object from SELF.
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	((VMA-START-READ) ADD MD (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-MAPPING-TABLE-ALIST)))
	(CHECK-PAGE-READ)			;Access the word in the flavor object
	(DISPATCH TRANSPORT MD)			;that contains the alist of mapping tables.
	((PDL-PUSH) M-D)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)	;Do (ASSQ method-flavor-name alist)
	((C-PDL-BUFFER-POINTER-PUSH) MD)
	(CALL XASSQ)
	(CALL-EQUAL M-T A-V-NIL TRAP)		;The alist MUST have an entry
    (ERROR-TABLE NO-MAPPING-TABLE)
	((M-D) PDL-POP)
	(JUMP QMDD)				;Return CDDR of ASSQ's value.

;Set SELF-MAPPING-TABLE to our arg,
;and set the bit in the open call block saying we are providing it.
;Destination is either D-IGNORE or D-LAST.
XSET-SELF-MAPPING-TABLE (MISC-INST-ENTRY %SET-SELF-MAPPING-TABLE)
	((M-TEM) M-INST-DEST)
	(JUMP-EQUAL-XCT-NEXT M-TEM A-ZERO XSET-SELF-MAPPING-TABLE-1)
       ((A-SELF-MAPPING-TABLE) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
;	(JUMP-IF-BIT-CLEAR M-INST-DEST-LOW-BIT XSET-SELF-MAPPING-TABLE-1)
;If this is D-LAST, pop the last arg (D-LAST will push it back on).
	((M-T) PDL-POP)
XSET-SELF-MAPPING-TABLE-1
	((PDL-BUFFER-INDEX) A-IPMARK)
;Is the function we will be calling a symbol?
;If so, return, since we can't be sure what mapping table it wants.
	((M-1) Q-DATA-TYPE C-PDL-BUFFER-INDEX)
	(POPJ-EQUAL M-1 (A-CONSTANT (EVAL DTP-SYMBOL)))
;Otherwise, set the bit saying that the function's mapping table is provided.
	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD PDL-BUFFER-INDEX (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((C-PDL-BUFFER-INDEX) IOR C-PDL-BUFFER-INDEX
	 (A-CONSTANT (BYTE-VALUE %%LP-CLS-SELF-MAP-PROVIDED 1)))

;HAVE SET UP ARGS
QFL1	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-MISC)))
	(CHECK-PAGE-READ)
	((M-T) (LISP-BYTE %%FEFHI-MS-LOCAL-BLOCK-LENGTH) READ-MEMORY-DATA)
QFL1C	(JUMP-EQUAL M-T A-ZERO QFL1A)
QFL1B	((C-PDL-BUFFER-POINTER-PUSH) A-V-NIL) 	;INIT LOCAL BLOCK TO NIL
	(JUMP-GREATER-THAN-XCT-NEXT M-T (A-CONSTANT 1) QFL1B)
       ((M-T) SUB M-T (A-CONSTANT 1))
QFL1A	(CALL-IF-BIT-SET (LISP-BYTE %%FEFH-SV-BIND) M-D FRMBN1)  ;MOVE S-V BINDINGS TO
		;S-V-CELLS AND PUSH PREVIOUS BINDINGS ON BINDING PDL (M-D HAS %FEFHI-IPC STILL)
;FINISH LINEARLY ENTERING
QLENX	((M-TEM) DPB M-A (BYTE-FIELD Q-POINTER-WIDTH 1) (A-CONSTANT 0))	;NOW UNRELOCATE PC
	((LOCATION-COUNTER) ADD M-TEM A-J OUTPUT-SELECTOR-LEFTSHIFT-1)
	(CALL-IF-BIT-SET M-TRAP-ON-CALLS QMRCL-TRAP)
	(POPJ-EQUAL-XCT-NEXT M-ERROR-SUBSTATUS A-ZERO)	;RETURN TO MAIN LOOP IF NO ERROR
       ((A-IPMARK) (BYTE-FIELD 10. 0) M-AP)	;NO OPEN CALL BLOCK YET
QLEERR	((C-PDL-BUFFER-POINTER-PUSH) DPB M-ERROR-SUBSTATUS Q-POINTER ;PUSH M-ERROR-SUBSTATUS 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))) ; ONTO STACK SO ERROR HANDLER
	(CALL TRAP)					       ; CAN FIND IT.
   (ERROR-TABLE FUNCTION-ENTRY) ;This table entry is specially known about.

;Here if the function takes a rest arg.  M-E has # reg+opt args.
;ADL not being used, fast-arg option is active.
QLFOA1	(JUMP-NOT-EQUAL A-LCTYP M-ZERO QLFRA1)	;Called with LEXPR/FEXPR call
QLFRA2	(CALL-GREATER-THAN M-C A-R SET-TOO-FEW-ARGS)
	;; Called with just spread arguments.
	;; If the rest arg will be NIL, push NILs for it and any missing optionals.
	(JUMP-LESS-THAN M-E A-R QLFSA2)
	((M-TEM) SUB M-E A-R)			;1- number of NILs to push
QLFSA1	((C-PDL-BUFFER-POINTER-PUSH) A-V-NIL)
	(JUMP-GREATER-THAN-XCT-NEXT M-TEM A-ZERO QLFSA1)
       ((M-TEM) SUB M-TEM (A-CONSTANT 1))
	((Q-R) ADD M-E (A-CONSTANT (EVAL %LP-INITIAL-LOCAL-BLOCK-OFFSET)))
	;; Args set up.  Set up entry-state and local-block (offset is in Q-R)
QLFOA5	((A-TEM1) DPB M-R (LISP-BYTE %%LP-ENS-NUM-ARGS-SUPPLIED)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
QLFOA6	((A-LOCALP) ADD Q-R A-S)
	((PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((C-PDL-BUFFER-INDEX) DPB Q-R (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN)
		A-TEM1)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-MISC)))
	(CHECK-PAGE-READ)
	((M-T) (LISP-BYTE %%FEFHI-MS-LOCAL-BLOCK-LENGTH) READ-MEMORY-DATA)
	(JUMP-XCT-NEXT QFL1C)
       ((M-T) SUB M-T (A-CONSTANT 1))		;First local (rest arg) already pushed

	;; Called with enough spread args to get into the rest arg
QLFSA2	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) M+A+1 M-S A-E)		;First of rest, %LP-INITIAL-LOCAL-BLOCK-OFFSET = 1
	((C-PDL-BUFFER-POINTER-PUSH)		;Push the rest-arg
		Q-POINTER M-K (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	((A-TEM1) DPB M-R (LISP-BYTE %%LP-ENS-NUM-ARGS-SUPPLIED)
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX)
				  (BYTE-VALUE %%LP-ENS-UNSAFE-REST-ARG 1))))
	(JUMP-XCT-NEXT QLFOA6)			;Put the local block after the supplied args
       ((Q-R) ADD M-R (A-CONSTANT (EVAL %LP-INITIAL-LOCAL-BLOCK-OFFSET)))

;Call with rest arg to a function which uses the fast arg option and wants a rest arg.
QLFRA1	((M-TEM) SUB M-R (A-CONSTANT 1))	;Number of spread args passed.
	(JUMP-EQUAL-XCT-NEXT M-E A-TEM QLFOA5)	;Matches number desired, enter.
       ((Q-R) ADD M-TEM (A-CONSTANT (EVAL %LP-INITIAL-LOCAL-BLOCK-OFFSET)))
	(CALL-LESS-THAN M-E A-TEM ILLOP)	;Too many spread args => lose.
;; Too few spread args => spread one off the rest arg.
	((M-T) Q-TYPED-POINTER PDL-TOP)
	(JUMP-EQUAL M-T A-V-NIL QLFRA3)	;But if rest arg is NIL, pretend there was none.
	(CALL SPREAD-REST-ARG-ONCE)
	(JUMP-XCT-NEXT QLFRA1)
       ((M-R) ADD M-R (A-CONSTANT 1))

;Pop stack, decrement M-R and go to QLFRA2 (as if there was no rest arg).
QLFRA3	(JUMP-XCT-NEXT QLFRA2)
       ((M-R) PDL-POP SETA A-TEM)

;Pop a value off the stack, then push its car and its cdr.
;Also leaves the cdr in M-T, sans cdr code.
SPREAD-REST-ARG-ONCE
	(CALL-XCT-NEXT QCAR)
       ((M-T) PDL-TOP)
	((M-TEM) PDL-TOP)
	((PDL-TOP) DPB M-T Q-TYPED-POINTER (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
	((M-T) M-TEM)
	(CALL QCDR)
	(POPJ-AFTER-NEXT
	 (PDL-PUSH) DPB M-T Q-TYPED-POINTER (A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
       (NO-OP)

;Decode the ADI and set A-LCTYP to say whether this call passed a rest-arg.
;Then go back to QLEAI2.
QLEAI1	;; Ignore the ADI call type if this frame was tail-recursively called.
	;; In that case, we already got the LCTYP from the entry state word.
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(JUMP-IF-BIT-SET (LISP-BYTE %%LP-ENS-TAIL-RECURSIVELY-CALLED) C-PDL-BUFFER-INDEX
	     QLEAI2)
	((M-K PDL-BUFFER-INDEX) ADD M-S (A-CONSTANT (EVAL (1- %LP-CALL-STATE))))
QLEAI3	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
			Q-DATA-TYPE C-PDL-BUFFER-INDEX TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE DATA-TYPE-SCREWUP FEF)
	(DISPATCH (LISP-BYTE %%ADI-TYPE) C-PDL-BUFFER-INDEX D-QLEAI3)
		;IF FEXPR OR LEXPR, REMEMBER WIERD CALL TYPE, JUMP TO QLEAI2, ELSE TO QLEAI4
       ((A-LCTYP) (LISP-BYTE %%ADI-TYPE) C-PDL-BUFFER-INDEX)

QLEAI4	(CALL-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX ILLOP)	;IGNORE OTHER ADI
	((M-K PDL-BUFFER-INDEX) SUB M-K (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%ADI-PREVIOUS-ADI-FLAG) C-PDL-BUFFER-INDEX QLEAI2);ALL ADI DONE
	(JUMP-XCT-NEXT QLEAI3)
       ((M-K PDL-BUFFER-INDEX) SUB M-K (A-CONSTANT 1))

;LINEAR ENTER WITHOUT FAST OPTION
; M-A FEF			M-R number of args called with
; M-B flags/temp		M-Q bind desc Q
; M-C flags/temp		M-I address of bind desc
; M-D pdl index of arg		M-J start PC of FEF
; M-E count of bind descs	M-S pdl index of frame
; M-T address of sv slot	M-K temp

QRENT	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-MISC)))
	(CHECK-PAGE-READ)
	((M-D PDL-BUFFER-INDEX) ADD M-S
		(A-CONSTANT (EVAL %LP-INITIAL-LOCAL-BLOCK-OFFSET)))        ;-> FIRST ARG
	((M-T) ADD M-A (A-CONSTANT (EVAL %FEFHI-SPECIAL-VALUE-CELL-PNTRS)));-> S-V SLOTS
	((A-ARGS-LEFT) M-R)					      ;# ARGS YET TO DO
	((A-TEM1) (LISP-BYTE %%FEFHI-MS-ARG-DESC-ORG) READ-MEMORY-DATA)
	((M-I) ADD A-TEM1 M-A)					    ;-> FIRST BIND DESC
	((M-E) (LISP-BYTE %%FEFHI-MS-BIND-DESC-LENGTH) READ-MEMORY-DATA)  ;# BIND DESCS
	((A-LOCALP) SETO)			    ;SIGNAL LOCAL BLOCK NOT YET LOCATED
	(JUMP-EQUAL A-LCTYP M-ZERO QBINDL)
	((A-ARGS-LEFT) ADD (M-CONSTANT -1) A-ARGS-LEFT) ;WAS FEXPR OR LEXPR CALL
			;FLUSH NO-SPREAD-ARG AND PROCESS ANY SPREAD ARGS
;BIND LOOP USED WHILE ARGS REMAIN TO BE PROCESSED
QBINDL	(JUMP-GREATER-OR-EQUAL M-ZERO A-ARGS-LEFT QBD0)	;OUT OF SPREAD ARGS
	(JUMP-LESS-THAN
		M-E (A-CONSTANT 1) QBTMA1) ;OUT OF BIND DESC, TOO MANY ARGS
	((VMA-START-READ) M-I)		;ACCESS WORD OF BINDING OPTIONS
	(CHECK-PAGE-READ)
	((M-E) SUB M-E (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-NAME-PRESENT) READ-MEMORY-DATA QBNDL1)
	((M-I) ADD A-ZERO M-I ALU-CARRY-IN-ONE)	;SKIP NAME Q IF PRESENT
QBNDL1	(DISPATCH-XCT-NEXT (LISP-BYTE %%FEF-ARG-SYNTAX) READ-MEMORY-DATA QREDT1)
       ((M-Q) READ-MEMORY-DATA)		;SAVE BIND DESC IN M-Q

QREW1	(CALL-LESS-THAN M-E (A-CONSTANT 1) ILLOP)
	((VMA-START-READ) M-I)		;ACCESS WORD OF BINDING OPTIONS
	(CHECK-PAGE-READ)
	((M-E) SUB M-E (A-CONSTANT 1))
	((M-Q) READ-MEMORY-DATA)
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-NAME-PRESENT) M-Q QBNDL2)
	((M-I) ADD A-ZERO M-I ALU-CARRY-IN-ONE)	;SKIP NAME Q IF PRESENT
QBNDL2	((M-TEM) (LISP-BYTE %%FEF-ARG-SYNTAX) M-Q)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT 2) QBNDL2-NOT-REST)
	(CALL-GREATER-THAN M-ZERO A-LOCALP QLLOCB)	;SET UP LOCAL BLOCK OVER ARG
	((PDL-BUFFER-POINTER) M-D)		;SO DONT STORE LOCALS OVER ARG
	(CALL-IF-BIT-SET (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBLSPCL)
	(JUMP-XCT-NEXT QBD1)
       ((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)

;Rest arg is supplied, but we want a spread arg.
;Spread the first element of the rest arg, putting the car and cdr back on the stack,
;then go process the car as a spread arg.
QBNDL2-NOT-REST
	((PDL-POINTER) M-D)
	((M-T) Q-TYPED-POINTER PDL-TOP)
	(JUMP-EQUAL M-T A-V-NIL QBNDL2-REST-ARG-NIL)
	(CALL-XCT-NEXT SPREAD-REST-ARG-ONCE)
       ((M-R) ADD M-R (A-CONSTANT 1))
	((MD) M-Q)	;QBNDL1 wants the ADL word in MD.
	(JUMP-XCT-NEXT QBNDL1)
       ((A-ARGS-LEFT) M+A+1 M-ZERO A-ARGS-LEFT)

;We want a spread arg, we have a rest arg, but that rest arg is NIL.
;So decide that we are really out of args and default this one (or get error).
QBNDL2-REST-ARG-NIL
	((MD) M-Q)
	(JUMP-XCT-NEXT QBD2A)
       (PDL-POP)

;OPTIONAL ARG IS PRESENT, SPACE PAST INITIALIZATION INFO IF ANY
QBROP1	(DISPATCH (LISP-BYTE %%FEF-INIT-OPTION) M-Q QBOPNP)

QBOSP	(JUMP-XCT-NEXT QBRQA)
       ((M-I) ADD A-ZERO M-I ALU-CARRY-IN-ONE)

QBOASA	((VMA-START-READ M-I) ADD A-ZERO M-I ALU-CARRY-IN-ONE)
	(CHECK-PAGE-READ)
	((M-J) Q-POINTER READ-MEMORY-DATA)	;START LATER TO AVOID CLOBBERING
;REQUIRED ARGUMENT IS PRESENT
QBRQA	(CALL-IF-BIT-SET (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBSPCL)

;ENTER HERE WHEN ARG HAS BEEN BOUND.  THESE CHECKS ONLY CAUSE EXCEPTIONS
QBDL1	(DISPATCH-XCT-NEXT (LISP-BYTE %%FEF-DES-DT) M-Q QBDDT)
       ((M-C) Q-DATA-TYPE C-PDL-BUFFER-INDEX)
QBDDT1	;(DISPATCH-XCT-NEXT (LISP-BYTE %%FEF-QUOTE-STATUS) M-Q QBEQC)
       ;((M-C) Q-FLAG-BIT C-PDL-BUFFER-INDEX)
QBEQC1	((M-D PDL-BUFFER-INDEX) ADD M-D A-ZERO ALU-CARRY-IN-ONE) ;NEXT ARG SLOT
	((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE) ;NEXT BIND DESC ENTRY
	(JUMP-XCT-NEXT QBINDL)			;PROCEED TO NEXT ARG
       ((A-ARGS-LEFT) ADD (M-CONSTANT -1) A-ARGS-LEFT)

;REST ARG - FOR NOW I ASSUME MICRO-COMPILED FUNCTIONS DO STORE CDR CODES
QBRA	(CALL-NOT-EQUAL A-LCTYP M-ZERO ILLOP)	;IF A NON-SPREAD ARG, SHOULD NOT
						;GET TO REST ARG HERE.
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)	;MAKE PNTR TO LIST OF ARGS
       ((M-K) M-D)
	(CALL-GREATER-THAN-XCT-NEXT M-ZERO A-LOCALP QLLOCB)
       ((M-D) ADD M-D A-ARGS-LEFT)	 	;LOCATE LOCAL BLOCK AFTER LAST ARG
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-K	;STORE REST ARG AS FIRST LOCAL
		Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	((M-R) DPB M-MINUS-ONE (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG-1) A-R)
	(CALL-IF-BIT-SET (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBLSPCL)
	((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)	;ADVANCE TO NEXT BIND DESC

QBD0	(JUMP-NOT-EQUAL A-LCTYP M-ZERO QREW1)	;ALSO IS A NO-SPREAD ARG
;BINDING LOOP FOR WHEN ALL ARGS HAVE BEEN USED UP
QBD1	(JUMP-LESS-THAN
		M-E (A-CONSTANT 1) QBD2)	;JUMP IF FINISHED ALL BINDING
	((VMA-START-READ) M-I)			;GET NEXT BINDING DESC Q
	(CHECK-PAGE-READ)
	((M-E) SUB M-E (A-CONSTANT 1))
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-NAME-PRESENT) READ-MEMORY-DATA QBD2A)
	((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)	;SKIP NAME IF PRESENT
QBD2A	(DISPATCH-XCT-NEXT (LISP-BYTE %%FEF-ARG-SYNTAX) READ-MEMORY-DATA QBDT2)
       ((M-Q) READ-MEMORY-DATA)			;SAVE BINDING DESC IN M-Q

;LOCATE LOCAL BLOCK TO WHERE M-D POINTS
;AFTER THIS HAS BEEN CALLED, USE C-PDL-BUFFER-POINTER-PUSH TO STORE LOCALS
QLLOCB	(POPJ-AFTER-NEXT		;PDL-BUFFER-PTR SHOULD BE SET ALREADY?
					;  --NOT IF TOO FEW ARGS FOR ONE--.
	 (PDL-BUFFER-POINTER) SUB M-D (A-CONSTANT 1))	;FIRST PUSH WILL STORE @ M-D
       ((A-LOCALP) M-D)			;PDL INDEX OF LOCALS

;GOT ARG DESCRIPTOR WHEN OUT OF ARGS
QBTFA1	(JUMP-XCT-NEXT QBOPT2)			;SUPPLY ARG OF NIL
       ((M-QBTFA) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)	;GIVE TOO FEW ARGS ERR LATER

QBRA1	(CALL-GREATER-THAN M-ZERO A-LOCALP QLLOCB)	;REST ARG MISSING, MAKE 1ST LOCAL NIL
QBOPT2	((C-PDL-BUFFER-POINTER-PUSH) A-V-NIL)	;STORE MISSING ARG AS NIL (CDR CODE?)
QBD1A	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBLSPCL)
       ((M-D) ADD M-D A-ZERO ALU-CARRY-IN-ONE)
QBDIN1	(JUMP-XCT-NEXT QBD1)
       ((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)

;INTERNAL
QBDINT	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBDIN2)
	(JUMP-XCT-NEXT QBDIN1)	;IF SPECIAL, NO LOCAL SLOT, TAKES S-V SLOT
       ((M-T) ADD M-T A-ZERO ALU-CARRY-IN-ONE)

QBDIN2	(JUMP-XCT-NEXT QBOPT2)	;IF LOCAL, IGNORE AT BIND TIME BUT RESERVE LOCAL SLOT
       (CALL-GREATER-THAN M-ZERO A-LOCALP QLLOCB)	;ALSO MUST LOCATE LOCAL BLOCK


;FREE
QBDFRE	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBDIN1) ;TAKES NO LCL SLOT
	(JUMP-XCT-NEXT QBDIN1)				    ;IF SPECIAL, TAKES S-V SLOT
       ((M-T) ADD M-T A-ZERO ALU-CARRY-IN-ONE)

;AUX
QBDAUX	(CALL-GREATER-THAN M-ZERO A-LOCALP QLLOCB)	;LOCATE LOCAL BLOCK, 
						; THEN DROP THROUGH TO INITIALIZE
QBOPT4	(DISPATCH (LISP-BYTE %%FEF-INIT-OPTION) M-Q QBOPTT)

;OPTIONAL NOT PRESENT
QBOPT1	(JUMP-GREATER-THAN M-ZERO A-LOCALP QBOPT4)
	(CALL ILLOP)		;SHOULDN'T HAVE ARGS AFTER LOCAL BLOCK IS LOCATED

;OPTIONAL ARGUMENT INIT VIA ALTERNATE STARTING ADDRESS AND NOT PRESENT
;LEAVE STARTING ADDRESS ALONE AND INIT TO SELF, COMPILED CODE WILL
;RE-INIT.  BUT DON'T FORGET TO SKIP OVER THE START ADDRESS.
QBOPT5	((M-I) ADD M-I (A-CONSTANT 1))
;OPTIONAL OR AUX, INIT TO SELF OR NONE, LATER MAY BE REINITED BY COMPILED CODE
QBOPT3	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%FEF-SPECIAL-BIT)
			M-Q QBOPT2)		;LOCAL, INIT TO NIL
	((VMA-START-READ) M-T)			;SPECIAL, GET POINTER TO VALUE CELL
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-NO-TRAP READ-MEMORY-DATA)	;FETCH EXTERNAL VALUE CELL.
							;MUST GET CURRENT VALUE, BUT NOT BARF
							;IF DTP-NULL.  MUST NOT LEAVE AN EVCP
							;SINCE THAT WOULD SCREW PREVIOUS
							;BINDING IF IT WAS SETQ'ED.
	((C-PDL-BUFFER-POINTER-PUSH) READ-MEMORY-DATA)
;THIS IS LIKE QBD1A, EXCEPT THAT THE THING WE ARE BINDING IT TO
;MAY BE DTP-NULL, WHICH IS ILLEGAL TO LEAVE ON THE PDL BUFFER.
;ALSO, THE VARIABLE IS KNOWN NOT TO BE AN ARGUMENT THAT WAS SUPPLIED,
;SO THERE'S NO DANGER OF CLOBBERING USEFUL DEBUGGING INFORMATION
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%FEF-SPECIAL-BIT) M-Q QBLSPCL)
       ((M-D) ADD M-D A-ZERO ALU-CARRY-IN-ONE)
	((C-PDL-BUFFER-POINTER) A-V-NIL)	;STORE NIL OVER POSSIBLE GARBAGE
	(JUMP-XCT-NEXT QBD1)
       ((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)

;INIT TO POINTER
QBOPNR	((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)
	((VMA-START-READ) M-I)			;FETCH THING TO INIT TOO, TRANSPORT IT
QBDR1	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	(JUMP-XCT-NEXT QBD1A)
       ((C-PDL-BUFFER-POINTER-PUSH) READ-MEMORY-DATA)

;INIT TO C(POINTER)
QBOCPT	((M-I) ADD M-I A-ZERO ALU-CARRY-IN-ONE)
	((VMA-START-READ) M-I)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	(JUMP-XCT-NEXT QBDR1)
       ((VMA-START-READ) READ-MEMORY-DATA)

;INIT TO CONTENTS OF "EFFECTIVE ADDRESS"
QBOEFF	((M-I VMA-START-READ) ADD M-I A-ZERO ALU-CARRY-IN-ONE)
	(CHECK-PAGE-READ)
	(DISPATCH-XCT-NEXT (BYTE-FIELD 3 6) READ-MEMORY-DATA QBOFDT) ;DISPATCH ON REG
       ((M-1) (BYTE-FIELD 6 0) READ-MEMORY-DATA)	;PICK UP DELTA FIELD

QBFE	((M-1) (BYTE-FIELD 8 0) READ-MEMORY-DATA)	;FULL DELTA
	(JUMP-XCT-NEXT QBDR1)
       ((VMA-START-READ) ADD M-A A-1)		;FETCH FROM FEF OF FCN ENTERING

QBQT	(JUMP-XCT-NEXT QBDR1)
       ((VMA-START-READ) ADD M-1 A-V-CONSTANTS-AREA)	;FETCH FROM CONSTANTS PAGE

QBDLOC	(CALL-GREATER-THAN M-ZERO A-LOCALP ILLOP) ;TRYING TO ADDRESS LOCALS BEFORE LOCATED
	((PDL-BUFFER-INDEX) ADD M-1 A-LOCALP)	;FETCH LOCAL
	(JUMP-XCT-NEXT QBD1A)
       ((C-PDL-BUFFER-POINTER-PUSH) C-PDL-BUFFER-INDEX)

QBDARG	((PDL-BUFFER-INDEX) ADD M-1 A-S ALU-CARRY-IN-ONE)	;FETCH ARG
	(JUMP-XCT-NEXT QBD1A)		;(%LP-INITIAL-LOCAL-BLOCK-OFFSET = 1)
       ((C-PDL-BUFFER-POINTER-PUSH) C-PDL-BUFFER-INDEX)

;TOO MANY ARGS
QBTMA2	((M-QBTMA) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)
	(DISPATCH-XCT-NEXT  (LISP-BYTE %%FEF-ARG-SYNTAX) M-Q QBDT2) ;FINISH BIND DESCS
       ((M-D) ADD M-D A-ARGS-LEFT)	;ADVANCING LCL PNTR PAST THE EXTRA ARGS

;TOO MANY ARGS AND BIND DESC LIST ALL USED UP
QBTMA1	((M-QBTMA) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)
	((M-D) ADD M-D A-ARGS-LEFT)	;ADVANCE LCL PNTR PAST THE EXTRA ARGS

;HERE WHEN BIND DESC LIST HAS BEEN USED UP
;By now, M-R contains the number of args in its low 6 bits
;and the flag saying there is an unsafe rest arg in bit 7.  (Bit 6 is zero).
QBD2	(CALL-GREATER-THAN M-ZERO A-LOCALP QLLOCB)  ;SET UP LOCAL BLOCK
	((M-TEM) A-LOCALP)
	((M-TEM) SUB M-TEM A-S)
	((A-TEM1) DPB M-TEM (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))	;ASSEMBLE ENTRY STATE Q
	((PDL-BUFFER-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(JUMP-XCT-NEXT QLENX)
       ((C-PDL-BUFFER-INDEX) DPB M-R
		(LISP-BYTE %%LP-ENS-NUM-ARGS-AND-UNSAFE-FLAG) A-TEM1)

;COME HERE WHEN BINDING A SPECIAL TO A LOCAL
QBLSPCL	((PDL-BUFFER-INDEX) PDL-BUFFER-POINTER)

;COME HERE WHEN BINDING A SPECIAL
; NOTE CODE BELOW CLEARS %%FEFHI-SVM-HIGH-BIT IN M-C.  THIS IS FOR THE BENEFIT OF
;FRMBN1.  ITS A CROCK, BUT NON-MODULARITY WAS DEEMED WORTH IT BECAUSE OTHERWISE
;CLEAR WOULD HAVE TO BE DONE IN A LOOP.
;NOTE THAT IF WE CAME HERE FROM QBOPT3 THERE MAY BE ILLEGAL DATA TEMPORARILY ON THE PDL BUFFER!
;LETTERED REGS CLOBBERED: M-B, M-K.  M-T HAS S-V PNTR TABLE ADDR, M-C HAS FLAGS.
;PDL-INDEX points to the slot on the stack containing the new value.
QBSPCL	((M-B) C-PDL-BUFFER-INDEX)		;GET VAL TO BIND TO (ARG OR LOCAL)
				;Note that PDL-BUFFER-INDEX is clobbered by overflow trap.
	((VMA-START-READ) M-T)			;GET SPECIAL VALUE CELL POINTER
	(CHECK-PAGE-READ)
	((M-1) ADD (M-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) A-QLBNDP)	;TEST P.C.E. (THIS M-CONST JUST HAPPENED TO
	((M-1) SUB M-1 A-QLBNDH)		; BE AROUND AT THE WRONG TIME).
	(CALL-IF-BIT-CLEAR BOXED-SIGN-BIT M-1 TRAP)
	    (ERROR-TABLE PDL-OVERFLOW SPECIAL)
	(DISPATCH TRANSPORT-NO-EVCP-READ-WRITE READ-MEMORY-DATA) ;TRANSPORT THE SPECIAL VALUE CELL PTR
	((VMA-START-READ) DPB READ-MEMORY-DATA Q-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	(CHECK-PAGE-READ)			;GET CONTENTS OF INTERNAL VALUE CELL
;CODE BELOW IS LOGICALLY SOMEWHAT SIMILAR TO QBND2.
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)	;CHASE FORWARDING PTR IF ANY
	((M-K) Q-TYPED-POINTER READ-MEMORY-DATA) ;BINDING TO SAVE
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT 
		READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER 
		A-B)		;NEW VALUE CELL CONTENTS
	((M-B) VMA)				;CELL ACTUALLY BOUND
	(CHECK-PAGE-WRITE)
	((M-C) DPB M-ZERO (LISP-BYTE %%FEFHI-SVM-HIGH-BIT) A-C) ;FOR FRMBN1'S BENEFIT
						;IF WE ARE COMING FROM THERE.
	(GC-WRITE-TEST)
	((WRITE-MEMORY-DATA) M-K)
	(JUMP-IF-BIT-SET-XCT-NEXT M-QBBFL QBSPCL1)	;JUMP IF NOT FIRST IN BLOCK
       ((M-T) ADD M-T A-ZERO ALU-CARRY-IN-ONE)	 ;ADVANCE TO NEXT S-V SLOT
	((M-K WRITE-MEMORY-DATA) DPB (M-CONSTANT -1) (LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) A-K)
	((M-QBBFL) DPB (M-CONSTANT -1) A-FLAGS)
QBSPCL1 ((VMA-START-WRITE) M+A+1 M-ZERO A-QLBNDP)
	(CHECK-PAGE-WRITE)
	(GC-WRITE-TEST)
	((WRITE-MEMORY-DATA) M-B)
	((VMA-START-WRITE M-K) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-WRITE)			;Note possible invz pntr cleared from M-K
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((A-QLBNDP) VMA)

;DATA TYPE CHECKS
QDTATM	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-SYMBOL)) QBDDT1)
QDTN	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-FIX)) QBDDT1)
	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-EXTENDED-NUMBER)) QBDDT1)
QBDDT3	(JUMP-XCT-NEXT QBDDT1)		;BAD DATA TYPE
       ((M-QBBDT) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)

QDTFXN	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-FIX)) QBDDT1)
	(JUMP QBDDT3)

QDTSYM	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-SYMBOL)) QBDDT1)
	(JUMP QBDDT3)

QDTLST	((M-C) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
	(JUMP-EQUAL M-C A-V-NIL QBDDT1)
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-INDEX SKIP-IF-LIST)
	 (JUMP QBDDT3)
	(JUMP QBDDT1)

QDTFRM	(JUMP-EQUAL M-C (A-CONSTANT (EVAL DTP-FEF-POINTER)) QBDDT1)
	(JUMP QBDDT3)

;EVAL/QUOTE CHECKS
;QBEQE	(JUMP-EQUAL M-C A-ZERO QBEQC1)
;QBEQQ1	(JUMP-XCT-NEXT QBEQC1)
;      ((M-QBBQTS) DPB (M-CONSTANT -1) A-ERROR-SUBSTATUS)
;
;QBEQQ	(JUMP-NOT-EQUAL M-C A-ZERO QBEQC1)
;	(JUMP QBEQQ1)

;;FRAME BIND. BIND S-V S FROM FRAME FAST ENTERED USING S.V. MAP
FRMBN1	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL %FEFHI-SV-BITMAP)))
	(CHECK-PAGE-READ)
	((M-D PDL-BUFFER-INDEX) M-AP)
	((M-T) ADD M-A (A-CONSTANT (EVAL %FEFHI-SPECIAL-VALUE-CELL-PNTRS)))
	(CALL-IF-BIT-CLEAR (LISP-BYTE %%FEFHI-SVM-ACTIVE) 
		READ-MEMORY-DATA ILLOP)  ;FOO FAST OPT 
			;SHOULD NOT BE ON UNLESS SVM IS. (IT ISNT WORTH IT TO HAVE
			;ALL THE HAIRY MICROCODE TO SPEED THIS CASE UP A TAD.)
	((M-C) (LISP-BYTE %%FEFHI-SVM-BITS) READ-MEMORY-DATA)
FRMBN2	(POPJ-EQUAL M-C A-ZERO)	  ;POPJ IF NO MORE BITS
	(CALL-IF-BIT-SET-XCT-NEXT (LISP-BYTE %%FEFHI-SVM-HIGH-BIT) 
			M-C QBSPCL)	;QBSPCL CLEARS %%FEFHI-SVM-HIGH-BIT IN M-C
       ((M-D PDL-BUFFER-INDEX) ADD M-D A-ZERO ALU-CARRY-IN-ONE)
	(JUMP-XCT-NEXT FRMBN2)
       ((M-C) M+M M-C A-ZERO)

;POP A BLOCK OF BINDINGS
BBLKP	(JUMP-XCT-NEXT BBLKP1)
       ((M-ZR) SETCA A-ZERO)

;POP A BINDING (MUSTN'T BASH M-T, M-J, M-R, M-D, M-C)
QUNBND	((M-ZR) A-ZERO)
BBLKP1	((VMA-START-READ) A-QLBNDP)		;Get pntr to bound cell
	(CHECK-PAGE-READ)
	((A-QLBNDP) ADD A-QLBNDP (M-CONSTANT -1))
	((A-QLBNDP) ADD A-QLBNDP (M-CONSTANT -1))
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)
	((M-Q) READ-MEMORY-DATA)
	((VMA-START-READ) M+A+1 M-ZERO A-QLBNDP)	;Previous contents
	(CHECK-PAGE-READ)
	((M-TEM) Q-DATA-TYPE M-Q)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-LOCATIVE)) ILLOP)
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)
	((M-B) READ-MEMORY-DATA)
	((VMA-START-READ) M-Q)			;Access bound cell
	(CHECK-PAGE-READ)			;This is only to preserve cdr/flag bits
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT
		READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-B)
	(CHECK-PAGE-WRITE-BIND)
BBLKP3	(JUMP-IF-BIT-SET (LISP-BYTE %%SPECPDL-BLOCK-START-FLAG) M-B BBLKP2)	;Jump if last binding in block
	(JUMP-NOT-EQUAL M-ZR A-ZERO BBLKP1)	;Loop if BBLKP
	(POPJ-IF-BIT-CLEAR-XCT-NEXT M-DEFERRED-SEQUENCE-BREAK-FLAG)	;Exit if QUNBND
       ((M-B) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))  ;Dont leave a DTP-E-V-C-P in M-B
	(JUMP SB-REINSTATE)			; (If SB, this might make SG switch bomb).

BBLKP2	((M-B) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))) ;Dont leave a DTP-E-V-P in M-B
	(POPJ-IF-BIT-CLEAR-XCT-NEXT M-DEFERRED-SEQUENCE-BREAK-FLAG)
       ((M-QBBFL) DPB M-ZERO A-FLAGS)		;NO MORE B.B.
SB-REINSTATE		;SB deferred.  Take it now?
	((M-TEM) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-INHIBIT-SCHEDULING-FLAG)
	(POPJ-NOT-EQUAL M-TEM A-V-NIL)
	((LOCATION-COUNTER) LOCATION-COUNTER)   ;write LC (assuring fetch of PC)
	(POPJ-AFTER-NEXT   			; and set SB req.
	  (INTERRUPT-CONTROL) IOR LOCATION-COUNTER (A-CONSTANT 1_26.))
       ((M-DEFERRED-SEQUENCE-BREAK-FLAG) DPB M-ZERO A-FLAGS)

XUB (MISC-INST-ENTRY UNBIND-0)			;UNBIND N BLOCKS
    (MISC-INST-ENTRY UNBIND-1)
    (MISC-INST-ENTRY UNBIND-2)
    (MISC-INST-ENTRY UNBIND-3)
    (MISC-INST-ENTRY UNBIND-4)
    (MISC-INST-ENTRY UNBIND-5)
    (MISC-INST-ENTRY UNBIND-6)
    (MISC-INST-ENTRY UNBIND-7)
    (MISC-INST-ENTRY UNBIND-10)
    (MISC-INST-ENTRY UNBIND-11)
    (MISC-INST-ENTRY UNBIND-12)
    (MISC-INST-ENTRY UNBIND-13)
    (MISC-INST-ENTRY UNBIND-14)
    (MISC-INST-ENTRY UNBIND-15)
    (MISC-INST-ENTRY UNBIND-16)
    (MISC-INST-ENTRY UNBIND-17)
	((M-D) (BYTE-FIELD 4 0) M-B)	;GET # BINDINGS TO POP MINUS ONE
XUB1	(CALL-IF-BIT-CLEAR M-QBBFL ILLOP)	;TRYING TO OVERPOP FRAME
	(CALL QUNBND)	
	(POPJ-EQUAL M-D A-ZERO)
	(JUMP-XCT-NEXT XUB1)
       ((M-D) SUB M-D (A-CONSTANT 1))

XPOPIP (MISC-INST-ENTRY POPPDL-0)
       (MISC-INST-ENTRY POPPDL-1)
       (MISC-INST-ENTRY POPPDL-2)
       (MISC-INST-ENTRY POPPDL-3)
       (MISC-INST-ENTRY POPPDL-4)
       (MISC-INST-ENTRY POPPDL-5)
       (MISC-INST-ENTRY POPPDL-6)
       (MISC-INST-ENTRY POPPDL-7)
       (MISC-INST-ENTRY POPPDL-10)
       (MISC-INST-ENTRY POPPDL-11)
       (MISC-INST-ENTRY POPPDL-12)
       (MISC-INST-ENTRY POPPDL-13)
       (MISC-INST-ENTRY POPPDL-14)
       (MISC-INST-ENTRY POPPDL-15)
       (MISC-INST-ENTRY POPPDL-16)
       (MISC-INST-ENTRY POPPDL-17)
;	(POPJ-AFTER-NEXT
;	 (M-B) (BYTE-FIELD 4 0) M-B)	;POP PDL 1-16.  NOTE THIS CAN NOT BE CALLED BY
;					;COMPILED MICROCODE SINCE B WONT BE SET UP
;      ((PDL-BUFFER-POINTER) SUB PDL-BUFFER-POINTER A-B)
;THE FOLLOWING IS A TEMPORARY KLUDGE UNTIL THE COMPILER BUG IS FIXED. 12/19/78 MOON, PER RMS
	((M-B) (BYTE-FIELD 4 0) M-B)
XPOPIP-2
	((PDL-BUFFER-POINTER M-B) SUB PDL-BUFFER-POINTER A-B)
;Flush all open call blocks above stack level in M-B.
XPOPIP-1
	((M-TEM) SUB M-B A-IPMARK)
	(POPJ-IF-BIT-CLEAR (BYTE-FIELD 1 9) M-TEM) ;PP >= A-IPMARK mod 2000
	(CALL POP-OPEN-CALL)		;Compiler forgot to flush this open call block
	(JUMP XPOPIP-1)	;Try again

XMOVE-PDL-TOP (MISC-INST-ENTRY MOVE-PDL-TOP)
	(POPJ-AFTER-NEXT (M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
       (NO-OP)

XSHRINK-PDL-SAVE-TOP (MISC-INST-ENTRY SHRINK-PDL-SAVE-TOP)
	((M-B) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;AMT TO DECREMENT PP BY
	(JUMP-XCT-NEXT XPOPIP-2)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;THING TO RETURN

;Now actually returns a locative to the last slot bound. 
XSPECIAL-PDL-INDEX (MISC-INST-ENTRY SPECIAL-PDL-INDEX)
	(POPJ-AFTER-NEXT (M-T) A-QLBNDP)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

;Now actually take a locative to the slot to unwind to.
XUNBIND-TO-INDEX-MOVE (MISC-INST-ENTRY UNBIND-TO-INDEX-MOVE)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;VALUE TO RETURN LATER
XUNBIND-TO-INDEX (MISC-INST-ENTRY UNBIND-TO-INDEX)
	((M-D) Q-POINTER C-PDL-BUFFER-POINTER-POP)
XUNBIND-TO-INDEX-0
	(POPJ-GREATER-OR-EQUAL M-D A-QLBNDP)
	(CALL-IF-BIT-CLEAR M-QBBFL ILLOP)
	(JUMP-XCT-NEXT XUNBIND-TO-INDEX-0)
       (CALL QUNBND)

XUNBIND-TO-INDEX-UNDER-N (MISC-INST-ENTRY UNBIND-TO-INDEX-UNDER-N)
	((M-1) Q-POINTER PDL-POP)
	((PDL-INDEX) SUB PDL-POINTER A-1)
;; M-D gets the special pdl index we want to unwind to.
;; It is passed to XUNBIND-TO-INDEX-0.
	((M-D) Q-POINTER C-PDL-BUFFER-INDEX)
;; Now discard that word from the stack by copying down everything above it.
;; Use a loop of pushes.
	((PDL-POINTER) SUB PDL-INDEX (A-CONSTANT 1))
;; PDL-POINTER is the next word to push into, minus 1.
;; PDL-INDEX is the next word to fetch from, minus 1.
;; M-1 is the number of words to be copied.
XUNBIND-TO-INDEX-UNDER-N-1
	((M-1) SUB M-1 (A-CONSTANT 1))
	((PDL-INDEX) ADD PDL-INDEX (A-CONSTANT 1))
	(JUMP-GREATER-XCT-NEXT M-1 A-ZERO XUNBIND-TO-INDEX-UNDER-N-1)
       ((PDL-PUSH) C-PDL-BUFFER-INDEX)
	(JUMP XUNBIND-TO-INDEX-0)

XPOP-M-FROM-UNDER-N (MISC-INST-ENTRY POP-M-FROM-UNDER-N)
	((M-1) Q-POINTER PDL-POP)   ;Number of values to keep.
	((M-2) Q-POINTER PDL-POP)   ;Number of words to pop.
	((PDL-INDEX) SUB PDL-POINTER A-1)
;M-B gets final pdl level below values we are preserving.
	((M-B) SUB PDL-INDEX A-2)
;Flush all open call blocks above there.
	(CALL XPOPIP-1)
	((PDL-INDEX) SUB PDL-POINTER A-1)	;XPOPIP-1 clobbered PDL-INDEX.
	((PDL-POINTER) M-B)
;; PDL-POINTER is the next word to push into, minus 1.
;; PDL-INDEX is the next word to fetch from, minus 1.
;; M-1 is the number of words to be copied.
XPOP-M-FROM-UNDER-N-1
	((M-1) SUB M-1 (A-CONSTANT 1))
	((PDL-INDEX) ADD PDL-INDEX (A-CONSTANT 1))
	(JUMP-GREATER-XCT-NEXT M-1 A-ZERO XPOP-M-FROM-UNDER-N-1)
       ((PDL-PUSH) C-PDL-BUFFER-INDEX)
	(POPJ)

;Get rid of one open call block, but don't change the pdl pointer.
;Does not run the unwind form if the call block is an unwind protect!
;  Note that an open call block never has any
;associated binding-pdl slots, since closures and so forth are processed
;when the call is activated.
POP-OPEN-CALL
	(CALL-EQUAL M-AP A-IPMARK TRAP)	;Trying to pop call block that isn't open
    (ERROR-TABLE ILLEGAL-INSTRUCTION)
	((M-K) A-IPMARK)
	((PDL-BUFFER-INDEX) ADD M-K (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-TEM) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) C-PDL-BUFFER-INDEX)
	(POPJ-AFTER-NEXT
	 (M-TEM) SUB M-K A-TEM)
	((A-IPMARK) (BYTE-FIELD 10. 0) M-TEM)

;Get rid of one open call block, but don't change the pdl pointer.
;Takes one arg, which is 0 if the frame being flushed is not an unwind-protect,
;or else the pc of the restart for the unwind protect.
;  The compiler always generates this to D-IGNORE.
XPOP-OPEN-CALL (MISC-INST-ENTRY POP-OPEN-CALL)
	(CALL-EQUAL M-AP A-IPMARK TRAP)	;Trying to pop call block that isn't open
    (ERROR-TABLE ILLEGAL-INSTRUCTION)
	((M-T) Q-POINTER PDL-POP)
	((M-K) A-IPMARK)
	((PDL-BUFFER-INDEX) ADD M-K (A-CONSTANT (EVAL %LP-CALL-STATE)))
	((M-TEM) (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK) C-PDL-BUFFER-INDEX)
	((M-TEM) SUB M-K A-TEM)
	(POPJ-EQUAL-XCT-NEXT M-T A-ZERO)
       ((A-IPMARK) (BYTE-FIELD 10. 0) M-TEM)
;It is an unwind-protect, so jump to the unwind form (pc is in M-T)
;after pushing four words saying how to come back to this pc
;(see XUWPCON-POP-OPEN-CALL).
	((PDL-BUFFER-INDEX) M-AP)
;Get the fef address, shifted left 2.
	((M-K) DPB C-PDL-BUFFER-INDEX (BYTE-FIELD Q-POINTER-WIDTH 2) A-ZERO)
	((M-TEM) SUB LOCATION-COUNTER A-K)
	((M-T) ADD M-T A-T)
	((LOCATION-COUNTER) ADD M-T A-K)
	((PDL-PUSH) DPB M-TEM Q-POINTER
	 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((PDL-PUSH) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX) 1)))
	((PDL-PUSH) A-V-NIL)
	((PDL-PUSH) A-V-NIL)
	(POPJ)

;;; Some support for instances

XFUNCTION-INSIDE-SELF (MISC-INST-ENTRY %FUNCTION-INSIDE-SELF)
	((M-T) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-SELF)
	((M-TEM) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) XFIS-I)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ENTITY)) XFIS-C)
	(POPJ-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-CLOSURE)))	;Default is to return self
XFIS-C	(JUMP-XCT-NEXT QCAR4)			;Get function of closure
      ;((VMA-START-READ) M-T)
XFIS-I	((VMA-START-READ) M-T)			;Get instance header
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	(JUMP-XCT-NEXT QCAR4)
       ((VMA-START-READ) ADD MD (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-FUNCTION)))

XINSTANCE-REF (MISC-INST-ENTRY %INSTANCE-REF)
	(JUMP-XCT-NEXT QCAR3)
       (CALL XINSTANCE-LOC)

XINSTANCE-SET (MISC-INST-ENTRY %INSTANCE-SET)
	(CALL XINSTANCE-LOC)
		(ERROR-TABLE CALLS-SUB %INSTANCE-SET)
	((M-S) M-T)
	((M-A) PDL-TOP)
	(JUMP-XCT-NEXT QRAR4)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

XINSTANCE-LOC (MISC-INST-ENTRY %INSTANCE-LOC)
	((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;Index
		(ERROR-TABLE RESTART XINSTANCE-LOC)
	((M-TEM) Q-DATA-TYPE C-PDL-BUFFER-POINTER)	;Instance
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) TRAP)
		(ERROR-TABLE ARGTYP INSTANCE PP 0 XINSTANCE-LOC %INSTANCE-LOC)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)	;Get instance header
XINSTANCE-LOC-1
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE-HEADER)) TRAP)
		(ERROR-TABLE DATA-TYPE-SCREWUP DTP-INSTANCE-HEADER)
	((M-T) VMA)					;Possibly-forwarded instance
	((VMA-START-READ) ADD MD (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-SIZE)))
	(CHECK-PAGE-READ)
	(CALL-EQUAL M-1 A-ZERO TRAP)			;Don't access the header!
		(ERROR-TABLE ARGTYP PLUSP M-1 1 NIL %INSTANCE-LOC)
	((M-2) Q-POINTER READ-MEMORY-DATA)		;Size of instance
XINSTANCE-LOC-RESTART
	(CALL-GREATER-OR-EQUAL M-1 A-2 TRAP)
    (ERROR-TABLE SUBSCRIPT-OOB M-1 M-2 XINSTANCE-LOC-RESTART M-T)
	(POPJ-AFTER-NEXT (M-T) ADD M-T A-1)
       ((M-T) Q-POINTER M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	    
;%ARGS-INFO <FUNCTION>   FUNCTION CAN BE ANYTHING MEANINGFUL IN
;FUNCTION CONTEXT. RETURNS FIXNUM.  FIELDS AS IN NUMERIC-ARG-DESC-INFO IN QCOM.

XARGI (MISC-INST-ENTRY %ARGS-INFO)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
;ENTER HERE FROM APPLY, ALSO REENTER TO TRY AGAIN (CLOSURE, ETC).
XARGI0	(DISPATCH-XCT-NEXT Q-DATA-TYPE M-S XARGI-DISPATCH)  ;INHIBIT-XCT-NEXT UNLESS
       ((M-T) (A-CONSTANT (PLUS (PLUS 			    ; INTERPRETER TRAP
 		(BYTE-VALUE Q-DATA-TYPE DTP-FIX) 
		(BYTE-MASK %%ARG-DESC-INTERPRETED))
		(BYTE-MASK %%ARG-DESC-MAX-ARGS))))

XAGISG	(POPJ-AFTER-NEXT				;STACK GROUP ACCEPTS ANY NUMBER
	 (M-T) DPB (M-CONSTANT -1) (LISP-BYTE %%ARG-DESC-MAX-ARGS)	;OF EVALED ARGS
			(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
       (NO-OP)

XAGUE1	((VMA-START-READ) ADD M-S A-V-MICRO-CODE-ENTRY-AREA)
	(CHECK-PAGE-READ)
	((M-TEM) Q-DATA-TYPE READ-MEMORY-DATA)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) XAGUE3)  ;NOT MICROCODED NOW.
	(JUMP-XCT-NEXT XAGUE2)				    ;UCODE-ENTRY
       ((VMA-START-READ) ADD M-S A-V-MICRO-CODE-ENTRY-ARGS-INFO-AREA)

XAGICL	(CALL-XCT-NEXT QCAR)				    ;CLOSURE
       ((M-T) Q-POINTER M-S		 ;REPLACE BY CAR OF IT AND TRY AGAIN.
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	(JUMP-XCT-NEXT XARGI0)
       ((M-S) M-T)

XAGAR1	((VMA-START-READ) M-S)			;ARRAY-POINTER
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	(POPJ-AFTER-NEXT 
	 (M-T)
	  (LISP-BYTE %%ARRAY-NUMBER-DIMENSIONS)
	 	 READ-MEMORY-DATA
		 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
       ((M-T) DPB M-T (LISP-BYTE %%ARG-DESC-MIN-ARGS) A-T)  ;COPY INTO BOTH MAX AND MIN

XAGM1	((VMA-START-READ) ADD
		 M-S (A-CONSTANT (EVAL %FEFHI-FAST-ARG-OPT)));MACRO-COMPILED
XAGUE2	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

XARGI3	((VMA-START-READ) ADD M-S (A-CONSTANT 2))	;SYM, REPLACE W FCTN CELL
	(CHECK-PAGE-READ)
XAGUE3	(DISPATCH TRANSPORT READ-MEMORY-DATA)
	(JUMP-XCT-NEXT XARGI0)
       ((M-S) Q-TYPED-POINTER READ-MEMORY-DATA)

;CONVERT PDL BUFFER ADDRESS IN M-K TO VIRTUAL ADDRESS IN M-K WITH LOCATIVE
; DATA-TYPE.  ANY REFERENCE VIRTUAL ADDRESS WHICH MAY BE IN PDL-BUFFER WILL TRAP,
; AND PAGE FAULT HANDLER WILL FIGURE OUT WHAT TO DO.

CONVERT-PDL-BUFFER-ADDRESS	
	((M-K) SUB M-K A-PDL-BUFFER-HEAD)
	(POPJ-AFTER-NEXT 
	 (M-K) DPB M-K (BYTE-FIELD 10. 0)	;ASSURE POSITIVE OFFSET IN CASE OF WRAPAROUND
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
       ((M-K) ADD M-K A-PDL-BUFFER-VIRTUAL-ADDRESS)

; CONVERT VIRTUAL ADDRESS IN M-K INTO PDL-BUFFER-INDEX (ASSUMING IT REFERENCES THE CURRENT
;STACK GROUP).  NOTE THIS DOES NOT ASSURE THAT SECTION OF PDL SWAPPED IN OR ANYTHING.
;IF AND WHEN IT IS SWAPPED IN, HOWEVER, IT WILL OCUPPY THE INDICATED PDL-BUFFER ADDRESS.

GET-PDL-BUFFER-INDEX
	((M-K) SUB M-K A-PDL-BUFFER-VIRTUAL-ADDRESS)
	(POPJ-AFTER-NEXT 
	 (M-K) ADD M-K A-PDL-BUFFER-HEAD)
       ((M-K) (BYTE-FIELD 10. 0) M-K)
))

