;-*-Mode:Midas-*-

(SETQ UC-FCTNS '(
;;; CAR AND CDR
;   NOTE- ALWAYS RETURNS 0 IN FIELDS OTHER THAN POINTER AND DATA TYPE

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAR M-T)

QTA   (MISC-INST-ENTRY M-CAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
QMA
   (ERROR-TABLE RESTART CAR)
QCAR	(DISPATCH (I-ARG CAR-INVOKE-OP) Q-DATA-TYPE M-T CAR-PRE-DISPATCH)
   (ERROR-TABLE ARGTYP CONS M-T T CAR CAR)
				;DROP THROUGH IF NORMAL CAR
QCAR3	((VMA-START-READ) M-T)
QCAR4	(CHECK-PAGE-READ)  
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)	;CHECK FOR INVZ, GC
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

QCARSY	(DISPATCH-XCT-NEXT M-CAR-SYM-MODE CAR-SYM-DISPATCH)	;CAR OF A SYMBOL
       ((M-T) Q-TYPED-POINTER M-T)
   (ERROR-TABLE ARGTYP CONS M-T T CAR CAR)
	(POPJ-EQUAL M-T A-V-NIL)
	(CALL TRAP)
   (ERROR-TABLE ARGTYP CONS M-T T CAR CAR)

QCARNM	(DISPATCH M-CAR-NUM-MODE CAR-NUM-DISPATCH)	;CAR OF A NUMBER
   (ERROR-TABLE ARGTYP CONS M-T T CAR CAR)



(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDR M-T)

QTD   (MISC-INST-ENTRY M-CDR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
QMD   
   (ERROR-TABLE RESTART CDR)
QCDR	(DISPATCH (I-ARG CDR-INVOKE-OP) Q-DATA-TYPE M-T CDR-PRE-DISPATCH)
   (ERROR-TABLE ARGTYP CONS M-T T CDR CDR)
					;DROP THROUGH IF NORMAL LIST CDR
QCDR3	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)  
	(DISPATCH TRANSPORT-CDR READ-MEMORY-DATA)	;CHECK FOR INVZ, DON'T REALLY TRANSPORT
	(DISPATCH Q-CDR-CODE READ-MEMORY-DATA CDR-CDR-DISPATCH)
   (ERROR-TABLE BAD-CDR-CODE RMD)				;POPJ-XCT-NEXT IF CDR NEXT
       ((M-T) ADD VMA (A-CONSTANT 1))		;SAME DATA TYPE AS ARG

QCDRSY	(DISPATCH-XCT-NEXT M-CDR-SYM-MODE CDR-SYM-DISPATCH)
       ((M-T) Q-TYPED-POINTER M-T)
   (ERROR-TABLE ARGTYP CONS M-T T CDR CDR)
	(POPJ-EQUAL M-T A-V-NIL)
	(CALL TRAP)
   (ERROR-TABLE ARGTYP CONS M-T T CDR CDR)

QCDRNM	(DISPATCH M-CDR-NUM-MODE CDR-NUM-DISPATCH)
   (ERROR-TABLE ARGTYP CONS M-T T CDR CDR)

CDR-FULL-NODE 
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)  
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA) ;CHECK FOR INVISIBLE, GC
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

CDR-IS-NIL 
   (MISC-INST-ENTRY FALSE)
XFALSE 	(POPJ-AFTER-NEXT (M-T) A-V-NIL)
       (NO-OP)

QCDPRP	((M-T) Q-TYPED-POINTER M-T)		;TAKING CDR OF SYMBOL (IN P-LIST MODE)
	(JUMP-EQUAL M-T A-V-NIL XFALSE)		;CDR OF NIL IS NIL,
 	((M-T) ADD (A-CONSTANT 3) M-T)		;OTHERWISE IS THE SYMBOL'S PLIST
	(JUMP-XCT-NEXT QCDR)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))


;;; Take car into M-A and cdr into M-T at same time.
CARCDR	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)
	 (JUMP CARCDR-NOT-LIST)
	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)  
	(DISPATCH TRANSPORT MD)
	(jump-not-equal-xct-next vma a-t qcdr)
       ((M-A) Q-TYPED-POINTER MD)
	(DISPATCH Q-CDR-CODE READ-MEMORY-DATA CDR-CDR-DISPATCH)
   (ERROR-TABLE BAD-CDR-CODE RMD)				;POPJ-XCT-NEXT IF CDR NEXT
       ((M-T) ADD VMA (A-CONSTANT 1))		;SAME DATA TYPE AS ARG

CARCDR-NOT-LIST
	(CALL QCAR)
	(POPJ-XCT-NEXT)
       ((M-A) M-T)

;; Multiple CAR/CDR functions.

;; QMA, QMD, etc. take arg in M-T and return value in M-T.
;; XCAAR, etc. pop arg off stack and return value in M-T.
;; QTAD, etc., exist only for certain functions.
;; They pop arg off stack like XCADR, etc., but do not set M-A.

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADDDR M-A)

XCADDDR (MISC-INST-ENTRY CADDDR)
	((M-A) C-PDL-BUFFER-POINTER)
	((M-T) C-PDL-BUFFER-POINTER-POP)
QMADDD 	(CALL QMD)		;These also MC-LINKAGE entries
QMADD 	(CALL QMD)
QMAD 	(CALL QMD)
	(JUMP QMA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAAAAR M-A)

XCAAAAR	(MISC-INST-ENTRY CAAAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMAAAA 	(CALL QMA)			;These also MC-LINKAGEs
QMAAA  	(CALL QMA)
QMAA   	(CALL QMA)
	(JUMP QMA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDDDR M-A)

XCDDDDR (MISC-INST-ENTRY CDDDDR)
	((M-A) C-PDL-BUFFER-POINTER)
	((M-T) C-PDL-BUFFER-POINTER-POP)
QMDDDD 	(CALL QMD)		;These also MC-LINKAGE entries.
QMDDD 	(CALL QMD)
QMDD 	(CALL QMD)
	(JUMP QMD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAAADR M-A)

XCAAADR (MISC-INST-ENTRY CAAADR)
 	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMAAA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMAAAD 	(CALL QMD)			;MC-LINKAGE
	(JUMP QMAAA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDDAR M-A)

XCDDDAR (MISC-INST-ENTRY CDDDAR)
 	(CALL-XCT-NEXT QMA)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMDDD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMDDDA 	(CALL QMA)			;MC-LINKAGE
	(JUMP QMDDD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAADDR M-A)

XCAADDR (MISC-INST-ENTRY CAADDR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMAADD 	(CALL QMD)			;MC-LINKAGE
QMAAD  	(CALL QMD)
	(JUMP QMAA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAADAR M-A)

XCAADAR (MISC-INST-ENTRY CAADAR)
 	(CALL-XCT-NEXT QMA)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMAAD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMAADA 	(CALL QMA)			;MC-LINKAGE
	(JUMP QMAAD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDAAR M-A)

XCDDAAR (MISC-INST-ENTRY CDDAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMDDAA 	(CALL QMA)			;MC-LINKAGE
QMDDA  	(CALL QMA)
	(JUMP QMDD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDADR M-A)

XCDDADR (MISC-INST-ENTRY CDDADR)	
 	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMDDA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMDDAD 	(CALL QMD)			;MC-LINKAGE
	(JUMP QMDDA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADAAR M-A)

XCADAAR (MISC-INST-ENTRY CADAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMADAA 	(CALL QMA)			;MC-LINKAGE
QMADA  	(CALL QMA)
	(JUMP QMAD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADADR M-A)

XCADADR (MISC-INST-ENTRY CADADR)
 	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMADA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMADAD 	(CALL QMD)			;MC-LINKAGE
	(JUMP QMADA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADDAR M-A)

XCADDAR (MISC-INST-ENTRY CADDAR)
 	(CALL-XCT-NEXT QMA)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMADD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMADDA 	(CALL QMA)			;MC-LINKAGE
	(JUMP QMADD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDADAR M-A)

XCDADAR (MISC-INST-ENTRY CDADAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMDADA 	(CALL QMA)			;MC-LINKAGE
QMDAD  	(CALL QMD)
	(JUMP QMDA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDADDR M-A)

XCDADDR (MISC-INST-ENTRY CDADDR)
 	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(CALL-XCT-NEXT QMD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)
	(JUMP QMDA)

QMDADD 	(CALL QMD)			;MC-LINKAGE
	(JUMP QMDAD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDAAAR M-A)

XCDAAAR (MISC-INST-ENTRY CDAAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
QMDAAA 	(CALL QMA)			;MC-LINKAGE
QMDAA  	(CALL QMA)
QMDA   	(CALL QMA)
	(JUMP QMD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDAADR M-A)

XCDAADR (MISC-INST-ENTRY CDAADR)
 	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMDAA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QMDAAD 	(CALL QMD)			;MC-LINKAGE
	(JUMP QMDAA)


;For CAAAR ... CDDDR, the arg is in M-A whenever an error occurs.

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAAAR M-A)

XCAAAR (MISC-INST-ENTRY CAAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMAAA)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAADR M-A)

XCAADR (MISC-INST-ENTRY CAADR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMAAD)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADAR M-A)

XCADAR (MISC-INST-ENTRY CADAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMADA)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADDR M-A)

XCADDR (MISC-INST-ENTRY CADDR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMADD)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDAAR M-A)

XCDAAR (MISC-INST-ENTRY CDAAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMDAA)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDADR M-A)

XCDADR (MISC-INST-ENTRY CDADR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMDAD)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDAR M-A)

XCDDAR (MISC-INST-ENTRY CDDAR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMDDA)
       ((M-A) M-T)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDDR M-A)

XCDDDR (MISC-INST-ENTRY CDDDR)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT QMDDD)
       ((M-A) M-T)

;For CAAR ... CDDR, the arg is in M-A unless an ARG-POPPED says it is elsewhere.

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CAAR M-A)

XCAAR  (MISC-INST-ENTRY M-CAAR)
	(CALL-XCT-NEXT QMA)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CADR M-A)

XCADR  (MISC-INST-ENTRY M-CADR)
	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMA)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDAR M-A)

XCDAR  (MISC-INST-ENTRY M-CDAR)
	(CALL-XCT-NEXT QMA)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS CDDR M-A)

XCDDR  (MISC-INST-ENTRY M-CDDR)
	(CALL-XCT-NEXT QMD)
       ((M-T) C-PDL-BUFFER-POINTER)
    (ERROR-TABLE ARG-POPPED 0 PP)
	(JUMP-XCT-NEXT QMD)
       ((M-A) C-PDL-BUFFER-POINTER-POP)

QTAD	(CALL QTD)
	(JUMP QMA)

QTDD	(CALL QTD)
	(JUMP QMD)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS NTH PP M-T)
(ERROR-TABLE DEFAULT-ARG-LOCATIONS NTHCDR PP M-T)

XNTH (MISC-INST-ENTRY NTH)
	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCAR)))
	;drops in
XNTHCDR (MISC-INST-ENTRY NTHCDR)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;List
		(ERROR-TABLE RESTART XNTHCDR0)
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
	    (ERROR-TABLE ARGTYP POSITIVE-FIXNUM PP 0 XNTHCDR0)
	(CALL-IF-BIT-SET-XCT-NEXT BOXED-SIGN-BIT C-PDL-BUFFER-POINTER TRAP)
       ((M-B) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
	    (ERROR-TABLE ARGTYP POSITIVE-FIXNUM PP 0 XNTHCDR0)
	((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)		;Count
	(POPJ-EQUAL-XCT-NEXT M-1 A-ZERO)
       ((M-A) M-T)
XNTHCDR-1
	(CALL-NOT-EQUAL M-T A-V-NIL QCDR)
	    (ERROR-TABLE CALLS-SUB NTHCDR)
	    (ERROR-TABLE ARG-POPPED 0 M-B M-A)
	(JUMP-GREATER-THAN-XCT-NEXT M-1 (A-CONSTANT 1) XNTHCDR-1)
       ((M-1) SUB M-1 (A-CONSTANT 1))
	(POPJ)

;;; RPLACA AND RPLACD

  (ERROR-TABLE DEFAULT-ARG-LOCATIONS RPLACA M-S M-T)
  (MISC-INST-ENTRY RPLACA)
XRPLCA	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
QRAR1	((M-A) M-S)
;; M-A has the value we should return; differs for RPLACA vs SETCAR.
   (ERROR-TABLE RESTART RPLACA)
XSETCAR1
	(DISPATCH (I-ARG RPLACA-INVOKE-OP) Q-DATA-TYPE M-S QRACDT)
   (ERROR-TABLE ARGTYP CONS M-S 0 RPLACA)

QRAR4	((VMA-START-READ) M-S)			;FETCH WORD TO BE SMASHED
	(CHECK-PAGE-READ)			;NO INT, CALLED BY MVR
	(DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA)	;CHASE INVISIBLES
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT
		READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)	;STORE M-T INTO Q-TYPED-PNTR
	(CHECK-PAGE-WRITE)			;NO SEQ BRK, CALLED BY MVR (???)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((M-T) M-A)

;No longer used for RPLACA, but some random places still call it.
QRAR3	((VMA-START-READ) M-S)			;FETCH WORD TO BE SMASHED
	(CHECK-PAGE-READ)			;NO INT, CALLED BY MVR
	(DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA)	;CHASE INVISIBLES
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT
		READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)	;STORE M-T INTO Q-TYPED-PNTR
	(CHECK-PAGE-WRITE)			;NO SEQ BRK, CALLED BY MVR (???)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((M-T) M-S)

  (ERROR-TABLE DEFAULT-ARG-LOCATIONS RPLACD M-S M-T)
  (MISC-INST-ENTRY RPLACD)
;MUSTN'T CLOBBER M-C OR M-R BECAUSE CALLED BY MULTIPLE-VALUE-LIST
;NOW CLOBBERS M-S, M-T, M-I, M-A
XRPLCD	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
QRDR1	((M-A) M-S)
;; M-A has the value we should return; differs for RPLACD vs SETCDR.
   (ERROR-TABLE RESTART RPLACD)
XSETCDR1
	(DISPATCH (I-ARG RPLACD-INVOKE-OP) Q-DATA-TYPE M-S QRDCDT)
   (ERROR-TABLE ARGTYP CONS M-S 0 RPLACD)

QRDRSY	(DISPATCH M-CDR-SYM-MODE RPLACD-SYM-DISPATCH)
   (ERROR-TABLE ARGTYP CONS M-S 0 RPLACD)

QRDPRP 	((M-S) ADD (A-CONSTANT 3) M-S)		;RPLACD ING SYMBOL (IN P-LIST MODE)
	(JUMP-XCT-NEXT XSETCDR1)
       ((M-S) DPB M-S Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

QRDR3	((VMA-START-READ) M-S)			;GET CAR OF CONS TO BE SMASHED
	(CHECK-PAGE-READ)			;NO SEQ BRK, CDR CODE IN HAND, ALSO MVR
	(DISPATCH TRANSPORT-CDR READ-MEMORY-DATA) ;CHASE INVISIBLE, NO NEED TO TRANSPORT
	(DISPATCH-XCT-NEXT Q-CDR-CODE READ-MEMORY-DATA RPLACD-CDR-DISPATCH)
   (ERROR-TABLE BAD-CDR-CODE RMD)
       ((M-I) READ-MEMORY-DATA)

RPLACD-FULL-NODE
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))	;GET WORD TO SMASH
	(CHECK-PAGE-READ)			;NO SEQ BRK, WORD IN HAND, ALSO MVR
	(DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA)	;CHASE INVISIBLES
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT	;STORE M-T INTO Q-TYPED-PNTR
		READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)			;NO SEQ BRK, CALLED BY MVR (???)
QRDR2	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((M-T) M-A)

RPLACD-NEXT-NIL 
	(JUMP-EQUAL M-T A-V-NIL QRDR2)		;RPLACD WITH NIL AND CDR ALREADY NIL, NO-OP
RPLACD-CDR-NEXT 
;THIS CODE CAN SEQUENCE BREAK!!! BEWARE!!!
	((C-PDL-BUFFER-POINTER-PUSH) M-A)		;SAVE THIS SO WE CAN RETURN IT
	((C-PDL-BUFFER-POINTER-PUSH) VMA)		;ADDR OF CELL TO BE FORWARDED
	((MD) VMA)					;ADDRESS THE MAP
	(DISPATCH MAP-STATUS-CODE MEMORY-MAP-DATA D-GET-MAP-BITS) ;Ensure validity of meta bits
	((M-TEM) (LISP-BYTE %%REGION-REPRESENTATION-TYPE) MEMORY-MAP-DATA)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL %REGION-REPRESENTATION-TYPE-LIST)) TRAP)
    (ERROR-TABLE RPLACD-WRONG-REPRESENTATION-TYPE M-S)
    (ERROR-TABLE ARG-POPPED 0 (PP 1) M-T)
	((C-PDL-BUFFER-POINTER-PUSH) M-I)		;CAR OF NEW CELL
	((C-PDL-BUFFER-POINTER-PUSH) M-T)		;CDR OF NEW CELL
	(CALL-XCT-NEXT XARN)				;IN WHAT AREA WAS THE CONS?
       ((C-PDL-BUFFER-POINTER-PUSH) Q-POINTER MD)	;MD HAS ORIGINAL VMA
	(CALL-XCT-NEXT QCONS)
       ((M-S) Q-TYPED-POINTER M-T)			;PASS ON THE AREA NUMBER
	((WRITE-MEMORY-DATA) DPB M-T Q-POINTER		;CLOBBER ORIGINAL "CAR"
			(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-HEADER-FORWARD)))
	((VMA-START-WRITE) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;RETURN THE ORIGINAL FIRST ARG

;Same as RPLACD but returns second argument (the value stored).
XSETCDR (MISC-INST-ENTRY SETCDR)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT XSETCDR1)
       ((M-A) M-T)		;Save the arg where QRDR1 will return it.

;Same as RPLACA but returns second argument (the value stored).
XSETCAR (MISC-INST-ENTRY SETCAR)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-XCT-NEXT XSETCAR1)
       ((M-A) M-T)		;Save the arg where QRAR1 will return it.

;;; EQUAL

;; For now, EQUAL and EQUALP do the same thing.
	(MISC-INST-ENTRY EQUALP)
XEQUAL	(MISC-INST-ENTRY EQUAL)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-B) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
XEQUAL-0
	(JUMP-EQUAL M-T A-B XTRUE)
	((M-1) Q-DATA-TYPE M-T)
	((M-2) Q-DATA-TYPE M-B)
	(JUMP-NOT-EQUAL M-1 A-2 XFALSE)
	(CALL XEQUAL-1)
	(JUMP-EQUAL M-1 (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) XEQUAL-ARRAY)
	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-NO-ATOM)
	(JUMP XFALSE)

	;; Now we are a list	
	((C-PDL-BUFFER-POINTER-PUSH) M-T)
	(CALL-XCT-NEXT QCAR3)
       ((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((M-B) M-T)
	(CALL-XCT-NEXT QCAR3)
       ((M-T) C-PDL-BUFFER-POINTER)
	;; If the micro stack is filling up, make new stack frame.
	(JUMP-GREATER-THAN MICRO-STACK-PNTR-AND-DATA (A-CONSTANT 10._24.)
			   XEQUAL-SLOW-RECURSE)
	;; Otherwise, test for EQUALity of the two cars.
	(CALL XEQUAL-0)

XEQUAL-CDR
	(JUMP-EQUAL M-T A-V-NIL XEQUAL-DIFFERENT-CARS)
	;; If the cars match, tail-recursively check the two cdrs.
	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)
	((M-B) M-T)
	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)
	(JUMP XEQUAL-0)

XEQUAL-DIFFERENT-CARS
	(POPJ-AFTER-NEXT (PDL-BUFFER-POINTER) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))
       (NO-OP)

XEQUAL-SLOW-RECURSE
	(CALL P3ZERO)
	((ARG-CALL REF-SUPPORT-VECTOR) (I-ARG SVCEQL))
	((C-PDL-BUFFER-POINTER-PUSH) READ-MEMORY-DATA)
	((C-PDL-BUFFER-POINTER-PUSH) M-T)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	((ARG-CALL MMCALL) (I-ARG 2))
	(JUMP XEQUAL-CDR)

	;;Numbers are EQUAL if =
XEQUAL-1
	(DISPATCH-XCT-NEXT Q-DATA-TYPE M-T POPJ-IF-NOT-NUMBER)
       ((M-A) (A-CONSTANT ARITH-2ARG-EQUAL))
	((M-GARBAGE) MICRO-STACK-DATA-POP)
	((C-PDL-BUFFER-POINTER-PUSH) M-B)
	(DISPATCH-XCT-NEXT Q-DATA-TYPE M-B D-NUMARG1)
       (NO-OP)
	(JUMP XFALSE)				;Non-EQ fixnums

XEQUAL-ARRAY
	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	((M-1) (LISP-BYTE %%ARRAY-TYPE-FIELD) READ-MEMORY-DATA)
	(JUMP-EQUAL M-1 (A-CONSTANT (EVAL (LSH ART-STRING ARRAY-TYPE-SHIFT))) XEQUAL-STRING)
	(JUMP-NOT-EQUAL M-1 (A-CONSTANT (EVAL (LSH ART-FAT-STRING ARRAY-TYPE-SHIFT))) XFALSE)
XEQUAL-STRING
	((VMA-START-READ) M-B)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	((M-2) (LISP-BYTE %%ARRAY-TYPE-FIELD) READ-MEMORY-DATA)
	(JUMP-EQUAL M-2 (A-CONSTANT (EVAL (LSH ART-STRING ARRAY-TYPE-SHIFT))) XEQUAL-STRING-1)
	(JUMP-NOT-EQUAL M-2 (A-CONSTANT (EVAL (LSH ART-FAT-STRING ARRAY-TYPE-SHIFT))) XFALSE)
XEQUAL-STRING-1
	((C-PDL-BUFFER-POINTER-PUSH) A-T)
	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)) )
	((C-PDL-BUFFER-POINTER-PUSH) A-B)
	((C-PDL-BUFFER-POINTER-PUSH) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((C-PDL-BUFFER-POINTER-PUSH) A-V-NIL)
	(JUMP XSTRING-EQUAL)			;No XCT-NEXT here

;(%BLT from-address to-address n-words increment)
;Increment is usually 1, less often -1 for backwards blt.
XBLT (MISC-INST-ENTRY %BLT)
	((M-D) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-C) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-2) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-2) SUB M-2 A-D)
	((M-1) SUB M-1 A-D)
XBLT1	(JUMP-EQUAL M-C (A-CONSTANT 0) XFALSE)
	((VMA-START-READ M-1) ADD M-1 A-D)
	(CHECK-PAGE-READ)
	((VMA-START-WRITE M-2) ADD M-2 A-D)
	(CHECK-PAGE-WRITE)
	(JUMP-XCT-NEXT XBLT1)
       ((M-C) SUB M-C (A-CONSTANT 1))

XNUMBP (MISC-INST-ENTRY NUMBERP)
	((M-T) C-PDL-BUFFER-POINTER-POP)
XTNUMB	(DISPATCH-XCT-NEXT Q-DATA-TYPE M-T POPJ-IF-NOT-NUMBER)	;MC-LINKAGE
       ((M-T) A-V-NIL)
	(JUMP XTRUE)

XFIXP (MISC-INST-ENTRY FIXP)
	((M-T) C-PDL-BUFFER-POINTER-POP)
XTFIXP	((M-TEM) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-FIX)) XTRUE)
	((M-4) (A-CONSTANT (EVAL %HEADER-TYPE-BIGNUM)))
XFXFLP	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-EXTENDED-NUMBER)) XFALSE)
	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)
	((M-T) A-V-TRUE)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	(POPJ-AFTER-NEXT (M-TEM) (LISP-BYTE %%HEADER-TYPE-FIELD) READ-MEMORY-DATA)
       (CALL-NOT-EQUAL M-TEM A-4 XFALSE)

XFLTP (MISC-INST-ENTRY FLOATP)
	((M-T) C-PDL-BUFFER-POINTER-POP)
XTFLTP	((M-TEM) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-SMALL-FLONUM)) XTRUE)
	(JUMP-XCT-NEXT XFXFLP)
       ((M-4) (A-CONSTANT (EVAL %HEADER-TYPE-FLONUM)))

XDATTP (MISC-INST-ENTRY %DATA-TYPE)
	(POPJ-AFTER-NEXT 
	 (M-T)  C-PDL-BUFFER-POINTER-POP 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))
		Q-DATA-TYPE)
       (NO-OP)

XDAT   (MISC-INST-ENTRY %POINTER)
	(POPJ-AFTER-NEXT 
	 (M-T)  C-PDL-BUFFER-POINTER-POP 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))
		Q-POINTER)
       (NO-OP)

XSDATP (MISC-INST-ENTRY %MAKE-POINTER)
	((A-TEM1) C-PDL-BUFFER-POINTER-POP)    ;ARG2, THE POINTER
	(POPJ-AFTER-NEXT 
	 (M-T) C-PDL-BUFFER-POINTER-POP)       ;ARG1, THE DATA TYPE
       ((M-T) DPB M-T Q-DATA-TYPE A-TEM1)
	
XSTND (MISC-INST-ENTRY %P-STORE-CONTENTS)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;NEED IN M-T FOR RETURNED VALUE
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
	((WRITE-MEMORY-DATA-START-WRITE)
	    SELECTIVE-DEPOSIT READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-LDB-OFFSET PP M-C M-B)

XOPLDB(MISC-INST-ENTRY %P-LDB-OFFSET)
	(JUMP-XCT-NEXT XOPLD1)			;JOIN XLDB, BUT FIRST
       (CALL XOMR0)				;REFERENCE THE LOCATION

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %LOGLDB PP M-1)

XLLDB (MISC-INST-ENTRY %LOGLDB)			;LDB FOR FIXNUMS
	(JUMP-XCT-NEXT XLLDB1)
       ((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-LDB PP VMA)

;%P-LDB treats target Q just as 32 bits.  Data type is not interpreted.
XPLDB (MISC-INST-ENTRY %P-LDB)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)			;VMA MAY POINT AT UNBOXED DATA.
XOPLD1  ((M-1) READ-MEMORY-DATA)		;VMA MAY BE LEFT POINTING AT UNBOXED DATA..
XLLDB1	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP) ;ARG1, BYTE POINTER.  MUST BE FIXNUM.
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
  (ERROR-TABLE ARGTYP FIXNUM PP 0)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)    ;GET NUMBER OF BITS
	(JUMP-EQUAL M-K A-ZERO XLDB-ZERO)  ;WANT 0 BITS, RETURN 0
					   ; (THIS IS A FAIRLY RANDOM THING TO CHECK FOR
					   ; BUT IF WE DIDNT, IT WOULD CAUSE LOSSAGE)
	(CALL-GREATER-THAN M-K (A-CONSTANT Q-POINTER-WIDTH) TRAP)
    (ERROR-TABLE ARGTYP FIXNUM-FIELD PP 0)
	((M-J) SUB M-K (A-CONSTANT 1))	   ;BYTE LENGTH MINUS ONE FIELD
	((M-E) (BYTE-FIELD 6 6) C-PDL-BUFFER-POINTER-POP) ;GET NUMBER OF PLACES OVER
	((A-TEM2) SUB (M-CONSTANT 40) A-E)	  ;COMPENSATE FOR SHIFTER LOSSAGE
	(POPJ-AFTER-NEXT 
	 (OA-REG-LOW) DPB M-J A-TEM2 OAL-BYTL-1)
       ((M-T) BYTE-INST 
		M-1 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

;LDB can only extract from fixnums and bignums.  The target is considered to
; have infinite sign extension.  LDB "should" always return a positive number.
; This issue currently doesn't arise, since LDB is implemented only for
; positive-fixnum-sized bytes, i.e. a maximum of 23. bits wide.  Note the
; presence of %LOGLDB, which will load a 24-bit byte of a fixnum and return
; it as a possibly-negative fixnum.
XLDB  (MISC-INST-ENTRY LDB) (ERROR-TABLE RESTART XLDB)
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER D-NUMARG)  ;Only the second operand is
	    (ERROR-TABLE ARGTYP NUMBER PP 1 XLDB)   ;processed via NUMARG.  Thus LDB is
	    (ERROR-TABLE ARG-POPPED 0 PP PP)
       ((M-A) (A-CONSTANT ARITH-1ARG-LDB))	    ;considered to be a one operand op.
		(ERROR-TABLE RESTART XLDB0)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)	;Arg1, byte pointer.  Must be fixnum.
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
            (ERROR-TABLE ARGTYP FIXNUM PP 0 XLDB0)
	    (ERROR-TABLE ARG-POPPED 0 PP (FIXPACK M-1))
;Fixnum case.  Data to LDB out of (arg2) sign extended in M-1.
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)    ;Get number of bits
	(JUMP-EQUAL M-K A-ZERO XLDB-ZERO)  ;Want 0 bits, return 0
					   ; (This is a fairly random thing to check for
					   ; but if we didnt, it would cause lossage)
	(CALL-GREATER-THAN M-K (A-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) TRAP)
    (ERROR-TABLE ARGTYP FIXNUM-FIELD PP 0 XLDB0)
    (ERROR-TABLE ARG-POPPED 0 PP (FIXPACK M-1))
	((M-J) SUB M-K (A-CONSTANT 1))	   ;Byte length minus one field
	((M-E) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6)
		 C-PDL-BUFFER-POINTER-POP) ;Get number of places over
	((M-2) SUB (M-CONSTANT 40) A-K)	   ;Maximum M-rotate to keep byte within a word
XLDB3	(JUMP-GREATER-THAN M-E A-2 XLDB2)  ;Jump if left edge of byte off end of word
	((A-TEM2) SUB (M-CONSTANT 40) A-E) ;Compensate for shifter lossage
	(POPJ-AFTER-NEXT 
	 (OA-REG-LOW) DPB M-J OAL-BYTL-1 A-TEM2)
       ((M-T) BYTE-INST M-1
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))  

;Get here if left edge of byte is off 32. bit word.  Arithmetic shift right until it fits.
XLDB2	((M-1) LDB (BYTE-FIELD 31. 1) M-1 A-1)
	(JUMP-XCT-NEXT XLDB3)
       ((M-E) SUB M-E (A-CONSTANT 1))

BIGNUM-LDB	;M-Q has bignum, M-C has bignum header, M-I has length of bignum.
		(ERROR-TABLE RESTART BIGNUM-LDB)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)	;Arg1, byte pointer.  Must be fixnum.
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
            (ERROR-TABLE ARGTYP FIXNUM PP 0 BIGNUM-LDB)
	    (ERROR-TABLE ARG-POPPED 0 PP M-Q)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)    ;Get number of bits
	(CALL-GREATER-THAN M-K (A-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) TRAP)
	    (ERROR-TABLE ARGTYP FIXNUM-FIELD PP 0 BIGNUM-LDB)
	    (ERROR-TABLE ARG-POPPED 0 PP M-Q)
	((M-E) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6)
			 C-PDL-BUFFER-POINTER)  ;Number of places over
	((M-D) (A-CONSTANT 1))			;Offset within bignum
BIGLDB2	(JUMP-LESS-THAN M-E (A-CONSTANT 31.) BIGLDB1)  ;Found word desired byte starts in
	((M-D) ADD M-D (A-CONSTANT 1))
	(JUMP-LESS-OR-EQUAL-XCT-NEXT M-D A-I BIGLDB2)
       ((M-E) SUB M-E (A-CONSTANT 31.))
	((OA-REG-HIGH) BIGNUM-HEADER-SIGN M-C)	;Byte off top of bignum, return sign bits
	((M-T) M-ZERO)
	(JUMP C-PDL-BUFFER-POINTER-POP BIGLDB6)	;Truncate byte and return (also flush arg)

BIGLDB1	((VMA-START-READ) ADD M-Q A-D)	;Fetch word of bignum
	(CHECK-PAGE-READ)
	((M-ZR) (A-CONSTANT 31.))	;31. useful bits in bignum word.
	(CALL-XCT-NEXT I-LDB)		;Get at least some of the right stuff into M-2
       ((M-1) READ-MEMORY-DATA)
	((M-T) Q-POINTER M-2 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))) ;Force result into fixnum
	(JUMP-EQUAL M-4 A-K BIGLDB3)   ;and return it if that is entire byte
	(JUMP-EQUAL M-D A-I BIGLDB3)   ;Also return if that was last word of bignum
	((VMA-START-READ) M+A+1 M-Q A-D)	;Get next word of bignum
	(CHECK-PAGE-READ)
	((M-J) M-A-1 M-K A-4)		;Number of bits left to go minus one
	((OA-REG-LOW) DPB M-J OAL-BYTL-1 A-ZERO)
	((M-1) BYTE-INST READ-MEMORY-DATA A-ZERO)  ;Get bits from second word
	((OA-REG-LOW) DPB M-J OAL-BYTL-1 A-4)   ;Put those bits above the previous bits.
	((M-T) DPB M-1 A-T)
BIGLDB3	(POPJ-IF-BIT-CLEAR-XCT-NEXT BIGNUM-HEADER-SIGN M-C)	;Done if bignum was positive
       ((M-E) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6)	;Retrieve byte pos, flush arg from pdl
			 C-PDL-BUFFER-POINTER-POP)
	;; Bignum was negative.  Take complement of the byte value retrieved.
	;; This is a 1's or 2's complement depending on whether all bits to the
	;; right are zero.  M-K still has the byte size.
	((M-T) XOR M-T (A-CONSTANT -1))	;1's complement the byte and some extra bits to left
	((VMA) M-Q)			;Scan the bignum for zeros, until start of the byte
BIGLDB4	(JUMP-LESS-OR-EQUAL M-E A-ZERO BIGLDB7)
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ)
	(JUMP-LESS-THAN M-E (A-CONSTANT 31.) BIGLDB5)
	(JUMP-EQUAL-XCT-NEXT READ-MEMORY-DATA A-ZERO BIGLDB4)
       ((M-E) SUB M-E (A-CONSTANT 31.))
BIGLDB6	((M-K) SUB M-K (A-CONSTANT 1))	;OK, truncate the byte value and return it
	(POPJ-AFTER-NEXT (OA-REG-LOW) DPB M-K OAL-BYTL-1 A-ZERO)
       ((M-T) (BYTE-FIELD 0 0) M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

BIGLDB5	((M-E) SUB M-E (A-CONSTANT 1))	;Check bits in last word
	((OA-REG-LOW) DPB M-E OAL-BYTL-1 A-ZERO)
	((M-TEM) (BYTE-FIELD 0 0) READ-MEMORY-DATA)
	(JUMP-NOT-EQUAL M-TEM A-ZERO BIGLDB6)
BIGLDB7	(JUMP-XCT-NEXT BIGLDB6)		;2's complement
       ((M-T) ADD M-T (A-CONSTANT 1))

XLSH-ZERO 
XLDB-ZERO 
	(POPJ-AFTER-NEXT 
	 (M-T) SETA (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)) ;RESULT = 0
		    C-PDL-BUFFER-POINTER-POP)	;DON'T FORGET TO POP ARG1
       (NO-OP)

;INTERNAL LDB.  TAKES DATA IN M-1, BITS IN M-K, PLACES OVER IN M-E.
; SIZE OF DATA IN M-1 IN M-ZR (MAX 32.).
; RETURNS BYTE IN M-2.  M-4 GETS NUMBER OF BITS OF M-2 THAT ACTUALLY 
; CONTAIN DESIRED BYTE, IE, SAME AS M-K IF ENTIRE BYTE WAS WITHIN M-ZR BITS,
; OTHERWISE ONE LESS FOR EACH BIT BYTE EXTENDED BEYOND M-ZR BITS, OR ZERO IF
; BYTE WAS ENTIRELY TO THE LEFT OF M-ZR BITS.  REST OF M-2 IS ZERO.
I-LDB	((M-2) ADD M-K A-E)
	(JUMP-GREATER-THAN M-2 A-ZR I-LDB0)	;LEFT EDGE OF BYTE OFF TOP
	((M-4) M-K)				;ENTIRE BYTE WILL FIT.
I-LDB2	(POPJ-EQUAL-XCT-NEXT M-4 A-ZERO)
       ((M-2) A-ZERO)				;RETURN 0 FOR 0 LENGTH BYTE.
	((A-TEM2) SUB (M-CONSTANT 40) A-E)
	((M-TEM) SUB M-4 (A-CONSTANT 1))	;HARDWARE BYTE LENGTH IS REAL VALUE -1.
	(POPJ-AFTER-NEXT
	 (OA-REG-LOW) DPB M-TEM OAL-BYTL-1 A-TEM2)
       ((M-2) BYTE-INST M-1 A-ZERO)

I-LDB0	((M-2) SUB M-2 A-ZR)			;NUMBER OF BITS OFF TOP
	(JUMP-LESS-THAN-XCT-NEXT M-E A-ZR I-LDB2) ;JUMP IF ANY BITS OF BYTE IN THIS WORD
       ((M-4) SUB M-K A-2)			;REDUCE SIZE OF BYTE TO AS MUCH AS WILL FIT
	(POPJ-AFTER-NEXT (M-4) A-ZERO)		;BYTE NOT IN THIS WORD, RETURN 0 BITS
       ((M-2) A-ZERO)

;INTERNAL DPB. TAKES DATA TO DEPOSIT IN M-1, DATA TO DEPOSIT INTO IN M-2,
; SIZE OF M-2 (MAX 32.) IN M-ZR.  BITS IN M-K, PLACES OVER IN M-E.
; RESULT IN M-2.  M-K REDUCED BY BITS THAT WERE DEPOSITED (IE WILL BE ZERO IF
; ENTIRE BYTE FIT).  IF BYTE DID NOT COMPLETELY FIT, M-1 IS SHIFTED RIGHT BY
; AMOUNT THAT DID FIT.  SMASHES M-4, TEMPS
I-DPB	(POPJ-EQUAL M-K A-ZERO)
	((M-4) ADD M-K A-E)
	(JUMP-GREATER-THAN-XCT-NEXT M-4 A-ZR I-DPB0)	;JUMP IF LEFT EDGE OF BYTE OFF TOP
       ((M-TEM) SUB M-K (A-CONSTANT 1))
	((M-K) A-ZERO)				;NONE LEFT TO DO, WHOLE BYTE IN THIS WORD
	(POPJ-AFTER-NEXT 
	 (OA-REG-LOW) DPB M-TEM OAL-BYTL-1 A-E)
       ((M-2) DPB M-1 A-2)

I-DPB0	(POPJ-GREATER-OR-EQUAL M-E A-ZR)	;RETURN IF ENTIRE BYTE OFF TO LEFT
	((M-K) SUB M-4 A-ZR)			;M-K GETS NUMBER OF BITS LEFT OVER
	((M-TEM) SUB M-TEM A-K)			;REDUCE SIZE OF BYTE
	((OA-REG-LOW) DPB M-TEM OAL-BYTL-1 A-E)
	((M-2) DPB M-1 A-2)			;DO THE DPB
	((A-TEM2) M-A-1 (M-CONSTANT 40) A-TEM)	;SHIFT OVER TO USE UP WHATS BEEN DPB'ED
	(POPJ-AFTER-NEXT 			;FACT BYTE SIZE IS +1 DOESNT HURT,
	 (OA-REG-LOW) DPB M-K OAL-BYTL-1 A-TEM2)	; SINCE M-1 WASN'T 32 BITS
       ((M-1) BYTE-INST M-1 A-ZERO)		;RIGHT ADJUST BITS IN M-1 FOR NEXT TIME.

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-DPB-OFFSET PP PP M-C M-B)

XOPDPB(MISC-INST-ENTRY %P-DPB-OFFSET)
	(JUMP-XCT-NEXT XOPDP1)			;JOIN XDPB, BUT FIRST
       (CALL XOMR0)				;REFERENCE THE DATA AND SET VMA

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %LOGDPB M-1 (+ (LSH M-E 6) M-K) M-2)

XLDPB (MISC-INST-ENTRY %LOGDPB)    ;DPB FOR FIXNUMS ONLY, CAN STORE INTO SIGN BIT
	((M-2) C-PDL-BUFFER-POINTER-POP)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)
	((M-E) (BYTE-FIELD 6 6) C-PDL-BUFFER-POINTER-POP)
	((M-1) C-PDL-BUFFER-POINTER-POP)
	(CALL-XCT-NEXT I-DPB)	  ;SEMI-RANDOM TO USE THIS ROUTINE, BUT SPEED DOESNT
       ((M-ZR) (A-CONSTANT Q-POINTER-WIDTH))  ; MATTER AND IT SAVES A UINST OR TWO.
	(POPJ-AFTER-NEXT 
	  (M-T) DPB M-2 Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
       (NO-OP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-DPB PP PP VMA)

XPDPB (MISC-INST-ENTRY %P-DPB)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)	;VMA MAY POINT TO UNBOXED DATA
XOPDP1  ((M-1) READ-MEMORY-DATA)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)		 ;ARG2, BYTE POINTER
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
   (ERROR-TABLE ARGTYP FIXNUM PP 1)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER) ;GET NUMBER OF BITS
	(JUMP-EQUAL M-K A-ZERO XDPB-ZERO)
	((M-K) SUB M-K (A-CONSTANT 1))
	((A-TEM1) (BYTE-FIELD 6 6) C-PDL-BUFFER-POINTER-POP) ;GET NUMBER OF PLACES OVER
	((OA-REG-LOW) DPB M-K A-TEM1 OAL-BYTL-1)
	((WRITE-MEMORY-DATA-START-WRITE)	;VMA CAN BE LEFT POINTING AT UNBOXED DATA
		DPB C-PDL-BUFFER-POINTER-POP A-1)
	(CHECK-PAGE-WRITE)
	(JUMP XFALSE)
       
; DPB never changes the sign of quantity DPB'ed into, it extends
; the sign arbitrarily far to the left past the byte.
XDPB (MISC-INST-ENTRY DPB) (ERROR-TABLE RESTART XDPB)
	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))	;ADDRESS ARG1
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-INDEX TRAP-UNLESS-FIXNUM)	;MAKE SURE NOT BIGNUM
    (ERROR-TABLE ARGTYP FIXNUM (PP -2) 0 XDPB)
    (ERROR-TABLE ARG-POPPED 0 PP PP PP)
	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER D-NUMARG) ;ONLY THE THIRD OPERAND IS 
	    (ERROR-TABLE ARGTYP NUMBER PP T XDPB)  ;PROCESSED VIA NUMARG. THUS DPB IS A
	    (ERROR-TABLE ARG-POPPED 0 PP PP PP)
       ((M-A) (A-CONSTANT ARITH-1ARG-DPB))	   ;ONE OPERAND OP.
;FIXNUM CASE.  DATA TO DPB INTO (ARG3) SIGN EXTENDED IN M-1.
		(ERROR-TABLE RESTART XDPB0)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)		 ;ARG2, BYTE POINTER
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 1 XDPB0)
    (ERROR-TABLE ARG-POPPED 0 PP PP M-1)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER) ;GET NUMBER OF BITS
	(JUMP-EQUAL M-K A-ZERO XDPB-ZERO)
	(CALL-GREATER-THAN M-K (A-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) TRAP)
    (ERROR-TABLE ARGTYP FIXNUM-FIELD PP 0 XDPB0)
    (ERROR-TABLE ARG-POPPED 0 PP PP M-1)
	((M-E) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6)
			C-PDL-BUFFER-POINTER-POP) ;GET NUMBER OF PLACES OVER
ASHDPB	((M-2) ADD M-K A-E)			;M-2 maximum number of bits in result
	(JUMP-GREATER-THAN M-2 (A-CONSTANT 32.) XDPB2A)	;Multi-word => use bignum code 
	(JUMP-LESS-THAN-XCT-NEXT M-1 A-ZERO ASHDPB-NEG)
       ((M-J) SUB M-K (A-CONSTANT 1))		;Single-word => use hardware DPB
	((OA-REG-LOW) DPB M-J OAL-BYTL-1 A-E)
	((M-1) DPB C-PDL-BUFFER-POINTER-POP A-1)
	(JUMP-GREATER-OR-EQUAL M-1 A-ZERO RETURN-M-1)	;Result in M-1 if sign didn't change
	((M-C) A-ZERO)				;Else it's a 2-word bignum
	(JUMP-XCT-NEXT OVERFLOW-BIGNUM-CREATE)
       ((M-2) A-ZERO)

ASHDPB-NEG					;Single-word DPB into negative number
	((OA-REG-LOW) DPB M-J OAL-BYTL-1 A-E)
	((M-1) DPB C-PDL-BUFFER-POINTER-POP A-1)
	(JUMP-LESS-THAN M-1 A-ZERO RETURN-M-1)	;Result in M-1 if sign didn't change
	((M-1) SUB M-ZERO A-1)			;Else it's a 2-word bignum
	(JUMP-NOT-EQUAL-XCT-NEXT M-1 A-ZERO OVERFLOW-BIGNUM-CREATE-NEGATIVE)
       ((M-2) A-ZERO)
	(JUMP-XCT-NEXT OVERFLOW-BIGNUM-CREATE-NEGATIVE)
       ((M-2) (A-CONSTANT 1))

;Get here on DPB ing into fixnum at position beyond 31. bits.  Fake up bignum
; and fall into bignum case.  Hair is that it avoids creating a
; garbage bignum just to copy out of.
XDPB2A	(CALL-LESS-THAN-XCT-NEXT M-1 A-ZERO XDPB-BM)   ;MAGNITUDIFY M-1 AND SAVE SIGN
       ((M-C) A-ZERO)		    ;IN BIGNUM-HEADER-SIGN POSITION.
ASHDPB1	((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC BIGDPB3)))
ASHDPB2	((M-J) DPB M-E (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6) A-K)
	((C-PDL-BUFFER-POINTER-PUSH) DPB M-J Q-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))  ;PUSH ARG2 BACK
	((M-D) DPB M-1 Q-POINTER    ;SUBROUTINE SMASHES M-1
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))  ;THIS IS NOW ALWAYS A POSITIVE
	(CALL-XCT-NEXT DPB-BIGNUM-SETUP)			; NUMBER EVEN IF IT IS SETZ
       ((M-I) A-ZERO)	;INDICATE SPECIAL CASE TO BIGNUM-COPY-EXPAND. HEADER SIGN IN M-C.
	((MD) Q-POINTER M-D)
	((VMA-START-WRITE) ADD M-T (A-CONSTANT 1))  ;STORE AWAY SAVED PIECE, CREATING
	(CHECK-PAGE-WRITE)			    ;BIGNUM TO SMASH
;Smashable bignum in M-T, header in M-C.  Length in M-I has been smashed.
BIGDPB0	((M-I) BIGNUM-HEADER-LENGTH M-C)	;NEW LENGTH
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)  ;NUMBER-OF-BITS
	(CALL-GREATER-THAN M-K (A-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) TRAP)
	    (ERROR-TABLE ARGTYP FIXNUM-FIELD PP 0)
	    (ERROR-TABLE ARG-POPPED PP PP M-T)
	(CALL-IF-BIT-SET BIGNUM-HEADER-SIGN M-C BIGNEG)	;GET 2'S COMPLEMENT REPRESENTATION
	((M-E) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH (PLUS 1 6)) 6)
		C-PDL-BUFFER-POINTER-POP)  ;NUMBER OF PLACES OVER
	((M-1) Q-POINTER C-PDL-BUFFER-POINTER-POP)	;DATA TO DEPOSIT.
	((M-D) (A-CONSTANT 1))		;OFFSET WITHIN BIGNUM
BIGDPB2	(JUMP-LESS-THAN M-E (A-CONSTANT 31.) BIGDPB1)
	((M-D) ADD M-D (A-CONSTANT 1))		;BYTE DOES NOT START IN THIS WORD
	(JUMP-LESS-OR-EQUAL-XCT-NEXT M-D A-I BIGDPB2)
       ((M-E) SUB M-E (A-CONSTANT 31.))
	(CALL TRAP)
	   (ERROR-TABLE BIGNUM-NOT-BIG-ENOUGH-DPB)	;SHOULDN'T HAPPEN

BIGDPB1	((VMA-START-READ) ADD M-T A-D)	  ;FETCH WORD OF BIGNUM
	(CHECK-PAGE-READ)
	((M-ZR) (A-CONSTANT 31.))
	(CALL-XCT-NEXT I-DPB)		;DEPOSIT IN SOME
       ((M-2) READ-MEMORY-DATA)
	((MD-START-WRITE) M-2)		;WRITE THAT WORD BACK.
	(CHECK-PAGE-WRITE)
	(POPJ-EQUAL M-K A-ZERO)			;NO BITS LEFT TO DEPOSIT
	((VMA-START-READ) ADD M-T A-D ALU-CARRY-IN-ONE)
	(CHECK-PAGE-READ)
	((M-E) A-ZERO)
	(CALL-XCT-NEXT I-DPB)		;DEPOSIT THE REST OF THE BITS.
       ((M-2) READ-MEMORY-DATA)
	(POPJ-AFTER-NEXT (MD-START-WRITE) M-2)
       (CHECK-PAGE-WRITE)

XDPB-BM	(POPJ-AFTER-NEXT   ;MAKING NEGATIVE NUMBER.  MAGNITUDIFY AND SET BIGNUM SIGN BIT.
	 (M-1) SUB M-ZERO A-1)
       ((M-C) DPB M-MINUS-ONE BIGNUM-HEADER-SIGN A-ZERO)

;Bignum in M-T, length in M-I.  Take 2's complement of it.  Bashes M-3, M-4
BIGNEG	((M-3) (A-CONSTANT 1))		;Offset into bignum
	((M-4) (A-CONSTANT 0))		;0 if borrow, -1 if no borrow
BIGNEG1	((VMA-START-READ) ADD M-T A-3)
	(CHECK-PAGE-READ)
	((M-3) ADD M-3 (A-CONSTANT 1))
	((M-TEM) READ-MEMORY-DATA)
	(JUMP-EQUAL-XCT-NEXT READ-MEMORY-DATA A-ZERO BIGNEG2)
       ((M-TEM) SUB M-4 A-TEM)
	((M-4) (A-CONSTANT -1))		;No more borrow
BIGNEG2	((MD-START-WRITE) (BYTE-FIELD 31. 0) M-TEM)	;Make sure high bit stays clear
	(CHECK-PAGE-WRITE)
	(JUMP-LESS-OR-EQUAL M-3 A-I BIGNEG1)
	(POPJ)

BIGNUM-DPB  ;bignum in M-Q, header in M-C, length in M-I.
	(CALL DPB-BIGNUM-SETUP)
	(CALL BIGDPB0)
BIGDPB3	(CALL-IF-BIT-SET BIGNUM-HEADER-SIGN M-C BIGNEG)	;If was negated, put in sign-magn form
	(JUMP BIGNUM-DPB-CLEANUP)	;bignum in M-T, header in M-C, length in M-I.

XDPB-ZERO
	((M-T) DPB M-1 Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX))) 
	(POPJ-AFTER-NEXT 			;RESULT IS ARG3
	    (M-GARBAGE) C-PDL-BUFFER-POINTER-POP)
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)	;AND POP OTHER TWO ARGS

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-MASK-FIELD-OFFSET PP M-C M-B)

XOPMF (MISC-INST-ENTRY %P-MASK-FIELD-OFFSET)
	(JUMP-XCT-NEXT XOPMF1)			;JOIN XMF, BUT FIRST
       (CALL XOMR0)				;REFERENCE THE LOCATION

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-MASK-FIELD PP VMA)

XPMF  (MISC-INST-ENTRY %P-MASK-FIELD)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
XOPMF1	(JUMP-XCT-NEXT XPFM1)
       ((M-1) READ-MEMORY-DATA)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS MASK-FIELD PP M-1)

XMF   (MISC-INST-ENTRY MASK-FIELD)	;LIKE LDB BUT DATA IN ORIGINAL POSITION IN Q
	((M-1) C-PDL-BUFFER-POINTER-POP)	;DATA TO EXTRACT
XPFM1	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP) ;ARG1, BYTE POINTER.  MUST BE FIXNUM.
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
  (ERROR-TABLE ARGTYP FIXNUM PP 0)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER)    ;GET NUMBER OF BITS
	(JUMP-EQUAL M-K A-ZERO XLDB-ZERO)  ;WANT 0 BITS, RETURN 0
					   ; (THIS IS A FAIRLY RANDOM THING TO CHECK FOR
					   ; BUT IF WE DIDNT, IT WOULD CAUSE LOSSAGE)
	((M-J) SUB M-K (A-CONSTANT 1))	   ;BECAUSE BITS IN LDB IS +1
	((A-TEM2) (BYTE-FIELD 6 6) C-PDL-BUFFER-POINTER-POP) ;GET NUMBER OF PLACES OVER
	(POPJ-AFTER-NEXT 		   ;NO "SHIFTER LOSSAGE" ON SELECTIVE-DEPOSIT
	 (OA-REG-LOW) DPB M-J A-TEM2 OAL-BYTL-1)
       ((M-T) SELECTIVE-DEPOSIT 
		M-1 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-DEPOSIT-FIELD-OFFSET PP PP M-C M-B)

XOPDF(MISC-INST-ENTRY %P-DEPOSIT-FIELD-OFFSET)
	(JUMP-XCT-NEXT XOPDF1)			;JOIN XDF, BUT FIRST
       (CALL XOMR0)				;REFERENCE THE LOCATION AND SET VMA

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-DEPOSIT-FIELD PP PP VMA)

XPDF (MISC-INST-ENTRY %P-DEPOSIT-FIELD)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
XOPDF1	(CALL-XCT-NEXT XPDF1)
       ((A-TEM3) READ-MEMORY-DATA)
	((WRITE-MEMORY-DATA-START-WRITE) M-T)
	(CHECK-PAGE-WRITE)
	(JUMP XFALSE)

;This can return untyped data.  It also doesn't work on bignums.
;Fortunately no one has ever called it.
XDF  (MISC-INST-ENTRY DEPOSIT-FIELD)
	((A-TEM3) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;ARG3, DATA TO STORE IN
XPDF1	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)		 ;ARG2, BYTE POINTER
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
  (ERROR-TABLE ARGTYP FIXNUM PP 1)
	((M-K) (BYTE-FIELD 6 0) C-PDL-BUFFER-POINTER) ;GET NUMBER OF BITS
	(JUMP-EQUAL M-K A-ZERO XDPB-ZERO)
	((M-K) SUB M-K (A-CONSTANT 1))
	((A-TEM1) (BYTE-FIELD 6 6) C-PDL-BUFFER-POINTER-POP) ;GET NUMBER OF PLACES OVER
	(POPJ-AFTER-NEXT 
	 (OA-REG-LOW) DPB M-K A-TEM1 OAL-BYTL-1)
       ((M-T) SELECTIVE-DEPOSIT C-PDL-BUFFER-POINTER-POP A-TEM3)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS %P-STORE-TAG-AND-POINTER PP M-A)

XCMBS (MISC-INST-ENTRY %P-STORE-TAG-AND-POINTER)
	((M-A) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;ARG3, VALUE FOR POINTER FIELD
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)	      ;ARG3 ANY TYPE, MISCBITS MUST BE FIXNUM
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-FIXNUM)
    (ERROR-TABLE ARGTYP FIXNUM PP 2)
	((WRITE-MEMORY-DATA) DPB C-PDL-BUFFER-POINTER-POP ;ARG2, VALUE FOR TYPE, ETC.
		Q-ALL-BUT-POINTER A-A)
	((VMA-START-WRITE) C-PDL-BUFFER-POINTER-POP) ;ARG1, WHERE TO STORE
	(CHECK-PAGE-WRITE)
	(JUMP XFALSE)

XPDAT (MISC-INST-ENTRY %P-POINTER)
	((M-K) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST Q-POINTER))))
XPDAT1  ((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT
	 (OA-REG-LOW) M-K)
       ((M-T) BYTE-INST READ-MEMORY-DATA (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

XPDATP (MISC-INST-ENTRY %P-DATA-TYPE)
	(JUMP-XCT-NEXT XPDAT1)
       ((M-K) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST Q-DATA-TYPE))))

XPCDRC (MISC-INST-ENTRY %P-CDR-CODE)
	(JUMP-XCT-NEXT XPDAT1)
       ((M-K) (A-CONSTANT (OA-LOW-CONTEXT (BYTE-INST Q-CDR-CODE))))

XSPDTP (MISC-INST-ENTRY %P-STORE-DATA-TYPE)
	((M-K) (A-CONSTANT (OA-LOW-CONTEXT (DPB Q-DATA-TYPE))))
XSPDTP1 ((M-T) C-PDL-BUFFER-POINTER-POP)	;DATA TO DPB IN (ALSO RETURN AS VALUE)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
	((A-TEM2) READ-MEMORY-DATA)
	((OA-REG-LOW) M-K)
	((WRITE-MEMORY-DATA-START-WRITE) DPB M-T A-TEM2)
	(CHECK-PAGE-WRITE)
	(POPJ)

XSPDAT (MISC-INST-ENTRY %P-STORE-POINTER)
	(JUMP-XCT-NEXT XSPDTP1)
       ((M-K) (A-CONSTANT (OA-LOW-CONTEXT (DPB Q-POINTER))))

XSPCDR (MISC-INST-ENTRY %P-STORE-CDR-CODE)
	(JUMP-XCT-NEXT XSPDTP1)
       ((M-K) (A-CONSTANT (OA-LOW-CONTEXT (DPB Q-CDR-CODE))))

;Provides a way to pick up the pointer-field of an external-value-cell
;pointer or a dtp-null pointer, or any invisible pointer,
;converting it into a locative and transporting it if it points to old-space.
XPCAL (MISC-INST-ENTRY %P-CONTENTS-AS-LOCATIVE)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)	;GET SPECD LOCATION
	(CHECK-PAGE-READ)
XPCAL1	(CALL-XCT-NEXT TRANS-OLD0)			;TRANSPORT OLDSPACE POINTER, BUT
       ((M-1) MD)					; DON'T CHASE INVISIBLE POINTERS
	(POPJ-AFTER-NEXT (M-T) Q-POINTER MD 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
       (CALL-NOT-EQUAL MD A-1 XPCAL1)			;REPEAT IF E.G. SNAPPED OUT HDR-FWD

XPCALO (MISC-INST-ENTRY %P-CONTENTS-AS-LOCATIVE-OFFSET)
	(JUMP-XCT-NEXT XPCAL1)
       (CALL XOMR0)					;GET SPECD LOCATION
	
XPDIF (MISC-INST-ENTRY %POINTER-DIFFERENCE)
	((M-T) Q-POINTER C-PDL-BUFFER-POINTER-POP)
	(POPJ-AFTER-NEXT
	  (M-T) SUB C-PDL-BUFFER-POINTER-POP A-T)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))


XOMR (MISC-INST-ENTRY %P-CONTENTS-OFFSET)
	(CALL XOMR0)				;READ THE SPECIFIED LOCATION
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)	;RETURN ITS CONTENTS

XOMR0	((M-B) C-PDL-BUFFER-POINTER-POP)	;GET THE OFFSET
	((VMA-START-READ M-C) C-PDL-BUFFER-POINTER-POP)	;READ THE HEADER WORD
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)	;FOLLOW FORWARDING PTR
	(POPJ-AFTER-NEXT
	 (VMA-START-READ) ADD VMA A-B)		;NOW REFERENCE THE SPECIFIED LOCATION
       (CHECK-PAGE-READ)			;VMA COULD BE POINTING INTO UNFORWARDED DATA

XOMS  (MISC-INST-ENTRY %P-STORE-CONTENTS-OFFSET)
	(CALL XOMR0)				;READ THE SPECIFIED LOCATION, SET VMA
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT READ-MEMORY-DATA 
		Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

;%MAKE-POINTER-OFFSET <new data type> <pointer> <offset> returns a pointer whose pointer
;   is (+ (%POINTER <pointer>) <offset>) and whose data type is <new data type>.  No data
;   type checks.
XMOP (MISC-INST-ENTRY %MAKE-POINTER-OFFSET)
	((M-T) C-PDL-BUFFER-POINTER-POP)
	(POPJ-AFTER-NEXT
		(M-T) ADD C-PDL-BUFFER-POINTER-POP A-T)
       ((M-T) DPB Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP A-T)


XSFP (MISC-INST-ENTRY %STACK-FRAME-POINTER)
	(CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) M-AP)
	(POPJ-AFTER-NEXT (M-T) M-K)
       (NO-OP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS GET M-B M-D)

XGET (MISC-INST-ENTRY GET)
	((M-D) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;Arg2, property name.
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;Arg1, symbol or plist.
	((M-A) M-D)		;Arg must go here as well, for INSTANCE-INVOKE.
	;; The following instruction can popj out of XGET.
	((ARG-CALL-XCT-NEXT PLGET) (I-ARG INSTANCE-INVOKE-GET))
       ((M-B) M-T)		;Save copy of arg in M-B.
XGET1	(POPJ-EQUAL M-T A-V-NIL)		;END OF PLIST REACHED
	(CALL CARCDR)
;; If the car matches desired property,
;; return the car of the following link (now in M-T).
	(JUMP-EQUAL M-A A-D QCAR)
	(JUMP-XCT-NEXT XGET1)
       (CALL QCDR)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS GET-LOCATION-OR-NIL M-B M-D)

XGETI (MISC-INST-ENTRY GET-LOCATION-OR-NIL)
	((M-D) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;Arg2, property name.
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP) ;Arg1, symbol or plist.
	((M-A) M-D)		;Arg must go here as well, for INSTANCE-INVOKE.
	;; The following instruction can popj out of XGETI.
	((ARG-CALL-XCT-NEXT PLGET) (I-ARG INSTANCE-INVOKE-GET-LOCATION-OR-NIL))
       ((M-B) M-T)		;Save copy of arg in M-B.
XGETI1	(POPJ-EQUAL M-T A-V-NIL)		;END OF PLIST REACHED
	(CALL CARCDR)
	(JUMP-EQUAL M-A A-D XGETI2)
	(JUMP-XCT-NEXT XGETI1)
       (CALL QCDR)

;Convert address of next link (whose car is the property value) into a locative.
XGETI2	(POPJ-AFTER-NEXT (M-T) DPB M-T Q-POINTER
	    (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
       (NO-OP)

;SUBROUTINE TO PICK UP THE PLIST OF THE OBJECT IN M-T, RETURNING IT IN M-T.
;RETURNS NIL IF A RANDOM TYPE, FOR MACLISP COMPATIBILITY.  UNFORTUNATELY
;NOT USEFUL FOR PLIST-CHANGING THINGS, BUT THOSE AREN'T CURRENTLY IN MICROCODE ANYWAY.
PLGET	((M-ZR) Q-DATA-TYPE M-T)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SYMBOL)) PLGET2)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LIST)) QCDR) ;"DISEMBODIED" PROPERTY LIST
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LOCATIVE)) QCDR) ;"DISEMBODIED" PROPERTY LIST
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-INSTANCE)) INSTANCE-INVOKE)
	(JUMP XFALSE)				;GET OF RANDOM THINGS NIL IN MACLISP, SO ...

PLGET2	((VMA-START-READ) ADD M-T		;ARG1, SYMBOL TO GET FROM
		      (A-CONSTANT 3))		;GET PLIST CELL OF ARG1
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

;; Send a message to the instance in M-T, with argument in M-A.
;; The I-ARG controls what message we send; it is an INSTANCE-INVOKE code.
;; POPJ's twice, so exits the calling function.
INSTANCE-INVOKE
	((M-B) DPB READ-I-ARG Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(CALL P3ZERO)
	((PDL-PUSH) M-T)	;First push the instance -- that's what we call.
	((ARG-CALL REF-SUPPORT-VECTOR) (I-ARG SVC-INSTANCE-INVOKE-VECTOR))
	((VMA-START-READ) ADD MD (A-CONSTANT 1))
	(CHECK-PAGE-READ)	;Get the value of INSTANCE-INVOKE-VECTOR.
	(DISPATCH TRANSPORT MD)
	((VMA-START-READ) M+A+1 MD A-B)
	(CHECK-PAGE-READ)	;Get the operation keyword out of the vector.
	(DISPATCH TRANSPORT MD)
	((PDL-PUSH) MD)
	((PDL-PUSH) M-A)	;Push the arg.
	((ARG-CALL MMCALL) (I-ARG 2))	;Call, 2 args.  Value comes back in M-T.
	(MICRO-STACK-DATA-POP)	;Flush return address in GET or GETL.
	(POPJ)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS GETL M-B M-S)

XGETL (MISC-INST-ENTRY GETL)
	((M-A) C-PDL-BUFFER-POINTER-POP)	;ARG2, LIST OF PROPERTIES
	((M-B) C-PDL-BUFFER-POINTER-POP)	;ARG1, THING TO GET FROM
	;; The following instruction can popj out of XGETL.
	((ARG-CALL-XCT-NEXT PLGET) (I-ARG INSTANCE-INVOKE-GETL))
       ((M-T) M-B)
	((M-S) M-A)
XGETL1	(POPJ-EQUAL M-T A-V-NIL)		;EXHAUSTED THE PLIST
	(CALL-XCT-NEXT QCAR)			;GET NEXT INDICATOR
       ((C-PDL-BUFFER-POINTER-PUSH) M-T)	;SAVE CURRENT PLIST NODE
	((M-A) Q-TYPED-POINTER M-T)		;SAVE INDICATOR.
	((M-T) Q-TYPED-POINTER M-S)		;GET LIST OF PROPERTY NAMES
XGETL2	(JUMP-EQUAL M-T A-V-NIL XGETL3)		;NO MATCH THIS ONE
	(CALL-XCT-NEXT QCAR)			;GET NEXT PROP NAME TO TRY
       ((C-PDL-BUFFER-POINTER-PUSH) M-T)
	(JUMP-EQUAL M-T A-A POP1TJ)		;GOT IT
	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;TRY NEXT PROP NAME
	(JUMP XGETL2)

XGETL3	(JUMP-XCT-NEXT XGETL1)       
       (CALL QTDD)				;TRY NEXT PROPERTY

POP1TJ	(POPJ-AFTER-NEXT
	  (M-GARBAGE) C-PDL-BUFFER-POINTER-POP)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS ASSQ M-D M-B)

;; Called indirectly from QLENTR -- watch out.
XASSQ (MISC-INST-ENTRY ASSQ)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;ARG2
	((M-D) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)	;ARG1
	((M-B) M-T)
XASSQ1	(POPJ-EQUAL M-T A-V-NIL)
	(CALL CARCDR)
	((PDL-PUSH) M-T)
;; Next link in alist is on pdl, this alist element in M-A.  Take its car.
	(CALL-XCT-NEXT QCAR)
       ((M-T) M-A)
;; Next link still on pdl, this alist element in M-A,
;; this element's key in M-T.
	(JUMP-NOT-EQUAL-XCT-NEXT M-T A-D XASSQ1)
       ((M-T) PDL-POP)
	(POPJ-XCT-NEXT)
       ((M-T) M-A)

POPTJ	(POPJ-AFTER-NEXT
	  (M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
       (NO-OP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS LAST (PP -1))

XLAST (MISC-INST-ENTRY LAST)
	((M-T C-PDL-BUFFER-POINTER-PUSH) C-PDL-BUFFER-POINTER)
XLAST1	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)
	 (JUMP POPT1J)
	(CALL-XCT-NEXT QCDR)
       ((C-PDL-BUFFER-POINTER) M-T)
	(JUMP XLAST1)

POPT1J	(POPJ-AFTER-NEXT
	  (M-T) C-PDL-BUFFER-POINTER-POP)
	(C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS LENGTH M-A)

XLENGT (MISC-INST-ENTRY LENGTH)
   (ERROR-TABLE RESTART LENGTH)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-A) M-T)
XTLENG	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)		;MC-LINKAGE
	 (JUMP-NOT-EQUAL M-T A-V-NIL XLEN2)
	((C-PDL-BUFFER-POINTER-PUSH) 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
XLEN1	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-LIST)
	 (JUMP POPTJ)
	(CALL QCDR)
	(JUMP-XCT-NEXT XLEN1)
       ((C-PDL-BUFFER-POINTER) ADD C-PDL-BUFFER-POINTER (A-CONSTANT 1))

;Arg is not a list of any sort.  If it's an array, return the active length.
XLEN2	((M-1) Q-DATA-TYPE M-T)
	(JUMP-EQUAL-XCT-NEXT M-1 (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) XAAIXL)
       ((PDL-PUSH) M-T)
	(CALL TRAP)
   (ERROR-TABLE ARGTYP LIST PP T LENGTH)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS SET M-S M-T)

XSET (MISC-INST-ENTRY SET)
	((M-T) C-PDL-BUFFER-POINTER-POP) 		;ARG2, NEW VALUE & RESULT
		(ERROR-TABLE RESTART XSET)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)		;ARG1, THE SYMBOL TO SET
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL PP 0 XSET)
   (ERROR-TABLE ARG-POPPED 0 PP M-T)
	((M-S) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((VMA-START-READ) ADD M-S (A-CONSTANT 1))	;ACCESS V.C.
	(CHECK-PAGE-READ)				;READ VALUE CELL FIRST
	(JUMP-NOT-EQUAL M-S A-V-NIL XSET2)		;Merge with STOCYC.
	(CALL TRAP)					;Don't clobber NIL!
   (ERROR-TABLE ARGTYP NON-NIL M-S 0)

XNOT (MISC-INST-ENTRY NOT)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-EQUAL M-T A-V-NIL XTRUE)
	(JUMP XFALSE)

XATOM (MISC-INST-ENTRY ATOM)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
			Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP SKIP-IF-ATOM)
	(JUMP XFALSE)
	(JUMP XTRUE)

XGPN  (MISC-INST-ENTRY GET-PNAME)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
		  Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL PP T)
   (ERROR-TABLE ARG-POPPED 0 PP)
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA)
       ((M-T) DPB READ-MEMORY-DATA Q-POINTER
		 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-ARRAY-POINTER)))

   (MISC-INST-ENTRY %BINDING-INSTANCES)    ;(%BINDING-INSTANCES <LIST-OF-SYMBOLS>)
  ;SIMILAR TO CLOSURE, BUT TAKES NO FUNCTION.  VALUE RETURNNED IS LIST OF
  ;LOCATIVES WHICH ARE ALTERNATELY INTERNAL AND EXTERNAL VALUE CELL POINTERS.
XBINS   ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
	(JUMP-EQUAL M-T A-V-NIL POPTJ)
	(CALL XTLENG)
	((M-B) ADD M-T A-T)			;TWO CELLS FOR EACH VAR
	((M-B) Q-POINTER M-B)
	(CALL-XCT-NEXT LIST-OF-NILS)		;ALLOCATE CLOSURE OUT OF LIST SPACE
       ((M-S) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-CNSADF)  ;LIST OF NILS SETS UP CDR CODES
	((M-T C-PDL-BUFFER-POINTER-PUSH) Q-POINTER M-T 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))  ;VALUE TO RETURN, EVENTUALLY
	(JUMP-XCT-NEXT XBINS1)
       ((C-PDL-BUFFER-POINTER-PUSH) M-T)	;FILLING POINTER.

   (MISC-INST-ENTRY CLOSURE)	;(CLOSURE <CLOSURE-LIST> <FCTN>)
XCLOS	((M-J) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)   ;FCTN
	(CALL-XCT-NEXT XTLENG)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER)
	((M-B) ADD M-T A-T ALU-CARRY-IN-ONE)	;TWO CELLS FOR EACH VAR PLUS ONE FOR FCTN
	((M-B) Q-POINTER M-B)
	(CALL-XCT-NEXT LIST-OF-NILS)		;ALLOCATE CLOSURE OUT OF LIST SPACE
       ((M-S) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-CNSADF)  ;LIST OF NILS SETS UP CDR CODES
	((C-PDL-BUFFER-POINTER-PUSH)	;EVENTUAL VALUE
		Q-POINTER M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-CLOSURE)))
	((M-S) Q-POINTER M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LIST)))
	(CALL-XCT-NEXT QRAR1)			;(RPLACA <CLOSURE-BLOCK> <FCTN>)
       ((M-T) M-J)				;FCTN
	((C-PDL-BUFFER-POINTER-PUSH) ADD M-T A-ZERO ALU-CARRY-IN-ONE)	;STEP FILLING POINTER
XBINS1	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
;0(IP) - POINTER TO BINDING INSTANCE BLOCK BEING FILLED IN
;-1(IP)- VALUE TO RETURN EVENTUALLY.
;-2(IP)- LIST OF VARS TO CLOSE OVER.
XCLOS4	(JUMP-EQUAL M-T A-V-NIL XCLOSX)		;LIST OF SYMS TO CLOSE IN M-T
	(CALL QCAR)
	(DISPATCH Q-DATA-TYPE M-T TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL M-T NIL)
	((M-S) C-PDL-BUFFER-POINTER-POP)	;FILLING POINTER  (IN POSITION FOR RPLACA)
	((M-T) DPB M-T Q-POINTER 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	(CALL-XCT-NEXT QRAR1)
       ((M-T C-PDL-BUFFER-POINTER-PUSH) ADD M-T A-ZERO ALU-CARRY-IN-ONE)
					;POINTER TO INTERNAL VALUE CELL
					;M-T GETS LOCATION FILLED.
	((VMA-START-READ) C-PDL-BUFFER-POINTER-POP)	;READ INTERNAL VALUE CELL
	(CHECK-PAGE-READ)
	((C-PDL-BUFFER-POINTER-PUSH) ADD M-T A-ZERO ALU-CARRY-IN-ONE) ;BUMP FILLING POINTER
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)
	((M-1) Q-DATA-TYPE READ-MEMORY-DATA)
	(JUMP-EQUAL M-1 (A-CONSTANT (EVAL DTP-EXTERNAL-VALUE-CELL-POINTER)) 
			XCLOS3A)	;XFER ON EXTERNAL VALUE CELL ALREADY EXISTS
	((C-PDL-BUFFER-POINTER-PUSH) VMA)	;SAVE POINTER TO INTERNAL VALUE CELL
	((C-PDL-BUFFER-POINTER-PUSH) READ-MEMORY-DATA)	;SAVE INTERNAL VALUE CELL CONTENTS
	(CALL-XCT-NEXT LCONS-D)			;ALLOCATE EXT VAL CELL IN LIST SPACE
       ((M-B) (A-CONSTANT 1))
	((VMA M-T) Q-POINTER M-T		;ADDRESS OF NEW EXTERNAL V-C
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-EXTERNAL-VALUE-CELL-POINTER)))
	((WRITE-MEMORY-DATA-START-WRITE)
		DPB C-PDL-BUFFER-POINTER Q-TYPED-POINTER  ;V-C CONTENTS
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))
	(CHECK-PAGE-WRITE)
	((WRITE-MEMORY-DATA) SELECTIVE-DEPOSIT C-PDL-BUFFER-POINTER-POP 
		Q-ALL-BUT-TYPED-POINTER A-T)
	((VMA-START-WRITE) C-PDL-BUFFER-POINTER-POP)	;WRITE INTO INTERNAL V-C
	(CHECK-PAGE-WRITE)
XCLOS3	((M-T) DPB M-T Q-POINTER       ;TO AVOID PROFUSION OF RANDOM D.T.S.  AVOIDS LOSSAGE
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE))) ;WITH CAR IN QCLS1
					;QCLS1 CHANGES BACK TO DTP-EXT-V-C EVENTUALLY
	(CALL-XCT-NEXT QRAR1)				;FORWARDING PNTR IN M-T
       ((M-S) C-PDL-BUFFER-POINTER-POP)			;GET BACK FILL POINTER
	((C-PDL-BUFFER-POINTER-PUSH) ADD M-T A-ZERO ALU-CARRY-IN-ONE)   ;BUMP FILL POINTER
	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))	;BUMP VARS POINTER
	(CALL-XCT-NEXT QCDR)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)
		;PDL-BUFFER-INDEX NOT SAVED ACROSS SEQUENCE BREAKS
	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER (A-CONSTANT 2))
	(JUMP-XCT-NEXT XCLOS4)
       ((C-PDL-BUFFER-INDEX) M-T)

XCLOS3A	(JUMP-XCT-NEXT XCLOS3)
       ((M-T) READ-MEMORY-DATA)		;POINTER TO EXTERNAL V-C

XCLOSX	((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)	;FLUSH FILLING POINTER
	(POPJ-AFTER-NEXT 
	 (M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)	;FLUSH CLOSURE-LIST


      (MISC-INST-ENTRY %EXTERNAL-VALUE-CELL)
XEVC	(CALL XVCL)		;Returns address of IVC.  Does not follow EVCPs.
	((VMA-START-READ) M-T)
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT-IVC READ-MEMORY-DATA) ;GC
       ((M-T) DPB VMA Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

XVCL  (MISC-INST-ENTRY VALUE-CELL-LOCATION)
	((A-TEM1) (A-CONSTANT 1))
XCL1	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL PP T)
   (ERROR-TABLE ARG-POPPED 0 PP)
	(POPJ-AFTER-NEXT 
	 (M-T) DPB Q-POINTER C-PDL-BUFFER-POINTER-POP 
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
       ((M-T) ADD M-T A-TEM1)

XFCL  (MISC-INST-ENTRY FUNCTION-CELL-LOCATION)
	(JUMP-XCT-NEXT XCL1)
       ((A-TEM1) (A-CONSTANT 2))

XPRPCL (MISC-INST-ENTRY PROPERTY-CELL-LOCATION)
	(JUMP-XCT-NEXT XCL1)
       ((A-TEM1) (A-CONSTANT 3))

XPACKCL (MISC-INST-ENTRY PACKAGE-CELL-LOCATION)
	(JUMP-XCT-NEXT XCL1)
       ((A-TEM1) (A-CONSTANT 4))


XFCTEV (MISC-INST-ENTRY FSYMEVAL)
	(JUMP-XCT-NEXT XSYME2)
       ((M-1) (A-CONSTANT 2))

XSYMEV (MISC-INST-ENTRY SYMEVAL)
	((M-1) (A-CONSTANT 1))
XSYME2		(ERROR-TABLE RESTART XSYME2)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
	 	  Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL PP T XSYME2)
   (ERROR-TABLE ARG-POPPED 0 PP)
	((VMA-START-READ) ADD C-PDL-BUFFER-POINTER-POP A-1)
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA) ;GC, FOLLOW INVZ
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)

POP-THEN-XFALSE
	(JUMP-XCT-NEXT XFALSE)
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS MEMQ M-C M-B)

XMEMQ (MISC-INST-ENTRY MEMQ)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-C) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-B) M-T)
;; Enters here from CSM-7.
XMEMQ1	(POPJ-EQUAL M-T A-V-NIL)
	(CALL-XCT-NEXT CARCDR)	;Get car in M-A, cdr in M-T.
       ((M-D) M-T)		;Save this link, as value if this elt matches.
	(JUMP-NOT-EQUAL M-A A-C XMEMQ1)
	(POPJ-XCT-NEXT)
       ((M-T) M-D)

(ERROR-TABLE DEFAULT-ARG-LOCATIONS FIND-POSITION-IN-LIST M-D M-C)

XFPIL (MISC-INST-ENTRY FIND-POSITION-IN-LIST)
	((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-C) M-T)
	((M-D) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-B) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
XFPIL1	(POPJ-EQUAL M-T A-V-NIL)
	(CALL-XCT-NEXT CARCDR)
       ((M-B) ADD M-B (A-CONSTANT 1))
	(JUMP-NOT-EQUAL M-A A-D XFPIL1)
	(POPJ-XCT-NEXT)
       ((M-T) SUB M-B (A-CONSTANT 1))

XLOCATE-IN-INSTANCE (MISC-INST-ENTRY LOCATE-IN-INSTANCE)
    (ERROR-TABLE RESTART XLOCATE-IN-INSTANCE)
	((M-TEM) Q-DATA-TYPE PDL-TOP)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL DTP-SYMBOL)) XLOCATE-IN-INSTANCE-1)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-LOCATIVE)) TRAP)
    (ERROR-TABLE ARGTYP SYMBOL-OR-LOCATIVE PP 1 XLOCATE-IN-INSTANCE)
	(CALL XFSH)
	(JUMP-XCT-NEXT XLOCATE-IN-INSTANCE-2)
       ((M-C) M-T)

XLOCATE-IN-INSTANCE-1
	((M-C) LDB Q-TYPED-POINTER PDL-POP)
;Decode the first arg.
XLOCATE-IN-INSTANCE-2
    (ERROR-TABLE RESTART XLOCATE-IN-INSTANCE-2)
	((M-TEM) Q-DATA-TYPE PDL-TOP)
	(CALL-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) TRAP)
    (ERROR-TABLE ARGTYP INSTANCE PP 1 XLOCATE-IN-INSTANCE-2)
    (ERROR-TABLE ARG-POPPED M-C)
	((M-A VMA-START-READ) Q-TYPED-POINTER PDL-POP)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER MD)
	((VMA-START-READ) ADD MD (A-CONSTANT (EVAL %INSTANCE-DESCRIPTOR-ALL-INSTANCE-VARIABLES)))
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	((VMA M-D) MD)
;; M-A holds the instance.
;; M-D holds the list of all instance variables.
;; VMA is a tail of that list.
;; M-C is the symbol we want.
XLOCATE-IN-INSTANCE-LOOP
	((VMA-START-READ) VMA)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT MD)
	((M-TEM) Q-TYPED-POINTER MD)
	(JUMP-EQUAL M-TEM A-C XLOCATE-IN-INSTANCE-FOUND)
	((M-TEM) Q-CDR-CODE MD)
	(JUMP-EQUAL-XCT-NEXT M-TEM (A-CONSTANT (EVAL CDR-NEXT)) XLOCATE-IN-INSTANCE-LOOP)
       ((VMA) ADD VMA (A-CONSTANT 1))
;; Variable is not found.
	(CALL TRAP)
    (ERROR-TABLE INSTANCE-LACKS-INSTANCE-VARIABLE M-C M-A)

XLOCATE-IN-INSTANCE-FOUND
	((M-1) SUB VMA A-D)
	((M-T) M+A+1 M-A A-1)
	(POPJ-XCT-NEXT)
       ((M-T) DPB M-T Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

   (MISC-INST-ENTRY LISTP)
XLISTP	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP SKIP-IF-LIST)
	(JUMP XFALSE)
	(JUMP XTRUE)

   (MISC-INST-ENTRY NLISTP)
XNLSTP	(DISPATCH Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP SKIP-IF-ATOM)
	(JUMP XFALSE)
	(JUMP XTRUE)

   (MISC-INST-ENTRY SYMBOLP)
XSYMP	((M-ZR) Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SYMBOL)) XTRUE)
	(JUMP XFALSE)

   (MISC-INST-ENTRY NSYMBOLP)
XNSYMP	((M-ZR) Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP)
	(JUMP-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-SYMBOL)) XTRUE)
	(JUMP XFALSE)

   (MISC-INST-ENTRY ARRAYP)
XARRYP	((M-ZR) Q-DATA-TYPE C-PDL-BUFFER-POINTER-POP)
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) XTRUE)
	(JUMP XFALSE)

   (MISC-INST-ENTRY STRINGP)
	;; A STRING IS DEFINED TO BE A ONE-D ARRAY OF TYPE ART-STRING OR ART-FAT-STRING.
XSTRNP	((M-A) C-PDL-BUFFER-POINTER-POP)
	((M-TEM) Q-DATA-TYPE M-A)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-ARRAY-POINTER)) XFALSE)
	((VMA-START-READ) M-A)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-HEADER READ-MEMORY-DATA)
	((M-TEM) (LISP-BYTE %%ARRAY-NUMBER-DIMENSIONS) READ-MEMORY-DATA)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT 1) XFALSE)
	((M-TEM) (LISP-BYTE %%ARRAY-TYPE-FIELD) READ-MEMORY-DATA)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL (LSH ART-STRING ARRAY-TYPE-SHIFT))) XTRUE)
	(JUMP-EQUAL M-TEM (A-CONSTANT (EVAL (LSH ART-FAT-STRING ARRAY-TYPE-SHIFT))) XTRUE)
	(JUMP XFALSE)

   (MISC-INST-ENTRY FBOUNDP)
XFCTNP	(JUMP-XCT-NEXT XBOUNP1)
       ((M-1) (A-CONSTANT 2))

   (MISC-INST-ENTRY BOUNDP)
XBOUNP	((M-1) (A-CONSTANT 1))
XBOUNP1	(ERROR-TABLE RESTART XBOUNP1)
	(DISPATCH (I-ARG DATA-TYPE-INVOKE-OP)
			Q-DATA-TYPE C-PDL-BUFFER-POINTER TRAP-UNLESS-SYM)
   (ERROR-TABLE ARGTYP SYMBOL PP 0 XBOUNP1)
   (ERROR-TABLE ARG-POPPED 0 PP)
	((VMA-START-READ) ADD C-PDL-BUFFER-POINTER-POP A-1)
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-IVC READ-MEMORY-DATA)	;NOT USING CONTENTS, DON'T BARF IF NULL
	((M-ZR) Q-DATA-TYPE READ-MEMORY-DATA)		;AND DON'T TRANSPORT
	(JUMP-EQUAL M-ZR (A-CONSTANT (EVAL DTP-NULL)) XFALSE)
	(JUMP XTRUE)
))

