;-*-Mode:MIDAS-*-

(SETQ UC-INTERRUPT '(
;PUSHJ HERE FOR ERRORS WHICH CAN TRAP TO MACROCODE.
;ON THE CONS MACHINE THIS USED THE OPCS, BUT WE HAVE REPUDIATED THAT PRACTICE.
;THEREFORE THIS CAN'T BE CALLED FROM THE INSTRUCTION AFTER A POPJ-AFTER-NEXT,
;AND SHOULDN'T BE CALLED FROM A CALL-XCT-NEXT UNLESS YOU MOVE THE ERROR-TABLE
;ENTRY DOWN.
TRAP	(JUMP-IF-BIT-CLEAR M-TRAP-ENABLE ILLOP)	;TURN INTO ILLOP UNLESS TRAPS ENABLED
	((M-TEM) M-FLAGS-NO-SEQUENCE-BREAK)	;TURN INTO ILLOP IF TRAP AT BAD TIME
	(JUMP-NOT-EQUAL M-TEM A-ZERO ILLOP)	;NOTE WOULD PROBABLY DIE LATER ANYWAY
	((M-TEM) A-SG-STATE)			;RECURSIVE TRAP?
	(CALL-IF-BIT-SET (LISP-BYTE %%SG-ST-PROCESSING-ERROR) M-TEM ILLOP)	;IF SO, HALT
	((A-SG-STATE) DPB (M-CONSTANT -1) (LISP-BYTE %%SG-ST-PROCESSING-ERROR) A-TEM)
	((M-TEM) MICRO-STACK-DATA-POP		;INVOLVES A LDB
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((A-TRAP-MICRO-PC) SUB M-TEM (A-CONSTANT 1))	;PRESUMED ADDRESS OF CALL
	((A-TEM3) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-QTRSTKG)
	((M-TEM) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-QCSTKG)
	(CALL-EQUAL M-TEM A-TEM3 ILLOP)		;RECURSIVE ERRORS
	((A-QLBNDH) A-QLBNDRH)			;ENSURE NO SPECIAL PDL OVERFLOW STORING STATUS
						;REGULAR PDL IS PREWITHDRAWN, CAN'T OVERFLOW
	(CALL-XCT-NEXT SGLV)			;STORE CURRENT STATUS
       ((M-TEM) (A-CONSTANT (EVAL SG-STATE-AWAITING-ERROR-RECOVERY))) ;AND SWAP SPECIAL-PDL
	((A-SG-TEM) A-V-NIL)	;Transmit NIL (do not change, EH knows about this.)
	(JUMP-XCT-NEXT SG-ENTER)			;"CALL" TRAP HANDLER STACK GROUP
       ((M-A) A-QTRSTKG)

;PUSHJ HERE ON ACTIVATE INVOKE.  OPERATION TYPE FROM I-ARG.
;INVOKE-ACTIVATE
;	(CALL-XCT-NEXT TRAP)	;NO HANDLER YET
;      ((C-PDL-BUFFER-POINTER-PUSH) DPB READ-I-ARG Q-POINTER	;SAVE OP-CODE
;		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
;      (ERROR-TABLE INVOKE)

;;; INTERRUPTS

;;; This code looks for a Unibus interrupt.  If it finds one it checks whether
;;; it was a keyboard interrupt; if so the character is read out and stored
;;; into the keyboard buffer.  Then the bus interface is readied to take another
;;; interrupt.

;;; Interrupts may clobber only what page faults clobber, plus the A-INTR-TEM
;;; registers.  Interrupts may take page faults to set up the map, but may
;;; not swap in pages.  Interrupts save and restore VMA and MD, but may
;;; possibly invalidate MAP[VMA] and MAP[MD].  Note that if you use
;;; (CHECK-PAGE-READ), an interrupt may occur after the read, and if you
;;; use (CHECK-PAGE-WRITE), an interrupt may occur after the write,
;;; or before it if the page is not swapped in.
;;; It is best if interrupts don't touch the pdl buffer.

(ASSIGN INTERVAL-TIMER-VECTOR 274)
(ASSIGN INTERVAL-TIMER-UNIBUS-ADDRESS 764124)
(ASSIGN MICROSECOND-CLOCK-UNIBUS-ADDRESS 764120)

INTR	(CALL-IF-BIT-SET M-INTERRUPT-FLAG ILLOP);Recursive interrupt!
	((A-INTR-VMA) VMA)			;Mustn't bash the VMA
	((A-INTR-MD) MD)			; nor the MD
	((M-INTERRUPT-FLAG) DPB (M-CONSTANT -1) A-FLAGS) ;No page faults allowed here
	((VMA-START-READ) (A-CONSTANT 77773020)) ;Unibus address 766040 (interrupt status)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-INTR-A) M-A)			;I need a couple M registers
	((A-INTR-B) M-B)
	((A-INTR-T) M-T)			;Convenient to be able to clobber this
	((A-INTR-LOCAL-UNIBUS-MODE) (BYTE-FIELD 1 1) MD)
	(JUMP-EQUAL A-INTR-LOCAL-UNIBUS-MODE M-ZERO INNL0)  ;jump on no local-enable, ie,
						; PDP11 arbritrating UNIBUS. 
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 15.) MD INTRX0) ;If not Unibus, go check for XBUS
	((M-B) SELECTIVE-DEPOSIT MD (BYTE-FIELD 8 2) A-ZERO)	;Interrupt vector address
	(JUMP-EQUAL M-B (A-CONSTANT 270) CHAOS-INTR)	;Chaos net has special handler
;	(JUMP-EQUAL M-B (A-CONSTANT 400) ETHER-XMIT-DONE)	;Ether Xmit completed
;	(JUMP-EQUAL M-B (A-CONSTANT 404) ETHER-RCV-DONE)	;Ether Receive done
;	(JUMP-EQUAL M-B (A-CONSTANT 410) ETHER-COLLISION)	;Collision.
	(JUMP-EQUAL M-B (A-CONSTANT INTERVAL-TIMER-VECTOR) INTR-INTERVAL-TIMER)
	;No specially provided device handler, maybe this is a general buffered device
	;E.g. the keyboard is one.
	((M-A) (A-CONSTANT (EVAL (+ 400 %SYS-COM-UNIBUS-INTERRUPT-LIST
				    %UNIBUS-CHANNEL-VECTOR-ADDRESS
				    (- %UNIBUS-CHANNEL-LINK)))))
INTR-0	((VMA-START-READ) ADD M-A
		(A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-LINK %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((MD) Q-POINTER MD)
	(CALL-EQUAL MD A-ZERO ILLOP)	;Reached end of list, lossage occurring
	((VMA-START-READ M-A) ADD MD (A-CONSTANT (EVAL %UNIBUS-CHANNEL-VECTOR-ADDRESS)))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-NOT-EQUAL MD A-B INTR-0)		;Loop until find device with this vector
	((VMA-START-READ) ADD M-A
	    (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-CSR-BITS %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-INTR-TEM1) READ-MEMORY-DATA)
	((VMA-START-READ) ADD M-A
	    (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-CSR-ADDRESS %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((VMA-START-READ) READ-MEMORY-DATA)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-TEM) AND READ-MEMORY-DATA A-INTR-TEM1)
	(JUMP-EQUAL M-TEM A-ZERO INTR-0)	;Device's ready bit not on, try for other
						;devices on the same vector
INNUBI		;Merge here in pdp11 arbitrating unibus case.
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-IN-PTR
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-B) READ-MEMORY-DATA)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-DATA-ADDRESS
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-TEM) A-INTR-TEM1)			;Output device?
	(JUMP-IF-BIT-SET (LISP-BYTE %%UNIBUS-CSR-OUTPUT) M-TEM INTR-OUTDEV)
	(JUMP-IF-BIT-SET (LISP-BYTE %%UNIBUS-CSR-TWO-DATA-REGISTERS) M-TEM INTR-2-A)
	(JUMP-IF-BIT-CLEAR Q-FLAG-BIT READ-MEMORY-DATA INTR-1)	;Jump if one-word device
INTR-2-A
	((VMA-START-READ) ADD MD (A-CONSTANT 1))	;Two-word device (kbd) needs to
	(CHECK-PAGE-READ-NO-INTERRUPT)			; read the high-order word first.
	((A-INTR-TEM1) DPB READ-MEMORY-DATA (BYTE-FIELD 20 20) A-ZERO)
	((VMA-START-READ) SUB VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-XCT-NEXT INTR-2)
       ((MD) (BYTE-FIELD 20 0) READ-MEMORY-DATA A-INTR-TEM1)

INTR-1	((VMA-START-READ) READ-MEMORY-DATA)	;Get device data
	(CHECK-PAGE-READ-NO-INTERRUPT) 
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%UNIBUS-CSR-TIMESTAMPED) M-TEM INTR-2)
	;If timestamped device, put data byte in top 8 bits, current timestamp in low 24.
	(CALL READ-USEC-TIME)
	((MD) DPB MD (BYTE-FIELD 8 24.) A-LAST-USEC-TIME)
INTR-2	((VMA-START-WRITE) M-B)			;Write into buffer
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-END
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-B) ADD M-B (A-CONSTANT 1))		;Advance storing pointer
	(JUMP-IF-BIT-SET (LISP-BYTE %%UNIBUS-CSR-SB-ENABLE) M-TEM INTR-SB-1)
	(JUMP-IF-BIT-CLEAR Q-FLAG-BIT READ-MEMORY-DATA INTR-NO-SB);This bit enables seq breaks.
INTR-SB-1
	(JUMP-IF-BIT-CLEAR-XCT-NEXT M-SBS-UNIBUS INTR-NO-SB)     ;This bit is also required.
       ((MD) Q-POINTER READ-MEMORY-DATA)	;Flush the flag bit.
	((INTERRUPT-CONTROL) IOR LOCATION-COUNTER (A-CONSTANT 1_26.))
INTR-NO-SB
	(JUMP-GREATER-THAN READ-MEMORY-DATA A-B INTR-3)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-START
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-B) READ-MEMORY-DATA)
INTR-3	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-OUT-PTR
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-EQUAL READ-MEMORY-DATA A-B UB-INTR-RET)	;Don't advance IN ptr if buffer full
	((WRITE-MEMORY-DATA) M-B)
	((VMA-START-WRITE) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-IN-PTR
						        %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
UB-INTR-RET
	((MD) A-ZERO)				;Clear Unibus interrupt flag
	((VMA-START-WRITE) (A-CONSTANT 77773021)) ;Unibus address 766042
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	((MD) (A-CONSTANT 6000))		;Enable one more Unibus interrupt
	((VMA-START-WRITE) (A-CONSTANT 77773020)) ;Unibus address 766040
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
XB-INTR-RET
	((M-INTERRUPT-FLAG) DPB (M-CONSTANT 0) A-FLAGS)	;Allow page faults again
	((MD) A-INTR-MD)
	((VMA) A-INTR-VMA)
	((M-T) A-INTR-T)
	(POPJ-AFTER-NEXT (M-B) A-INTR-B)	;Dismiss
       ((M-A) A-INTR-A)

INTR-OUTDEV
	((A-INTR-TEM1) READ-MEMORY-DATA)	;Address of device data register
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-OUT-PTR
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((VMA-START-READ) READ-MEMORY-DATA)	;Get next word to go out
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-EQUAL VMA A-B INTR-OUTSTOP)	;Buffer empty, stop device
	((M-B) VMA)				;Save out pointer
	(JUMP-IF-BIT-CLEAR-XCT-NEXT (LISP-BYTE %%UNIBUS-CSR-TIMESTAMPED) M-TEM INTR-OUTDEV1)
       ((WRITE-MEMORY-DATA) READ-MEMORY-DATA)	;Parity check
	((A-TIMESTAMPED-OUTPUT-COUNT-1) M+A+1 M-ZERO A-TIMESTAMPED-OUTPUT-COUNT-1)
INTR-OUTDEV-BUSY-WAIT
	((A-TIMESTAMPED-OUTPUT-COUNT-2) M+A+1 M-ZERO A-TIMESTAMPED-OUTPUT-COUNT-2)
	;Timestamped device: MD top 8 bits have char, low 23 have time for it to be output.
	;Subtract the current time from the desired time; see how long to wait.
	(CALL READ-USEC-TIME)
	((M-T) SUB MD A-LAST-USEC-TIME)
	((M-T) (BYTE-FIELD 23. 0) M-T)
	;; Past time => output now.
	(JUMP-GREATER-THAN M-T (A-CONSTANT 37700000) INTR-OUTDEV-NOW)
	;; Very short time => output now.
	(JUMP-LESS-THAN M-T (A-CONSTANT 8) INTR-OUTDEV-NOW)
	;; less than 128 usec => busy wait until that time.
	(JUMP-LESS-THAN M-T (A-CONSTANT 200) INTR-OUTDEV-BUSY-WAIT)
	;; Longer time => use interval timer to wait until a time shortly before then.
	((M-T) SUB M-T (A-CONSTANT 200))
	((M-T) (BYTE-FIELD 16. 4) M-T)
	((MD) (A-CONSTANT 1_20))   ;Timer counts up, not down.
	((MD) SUB MD A-T)
	((VMA-START-WRITE) (A-CONSTANT (PLUS INTERVAL-TIMER-UNIBUS-ADDRESS
					     LOWEST-UNIBUS-VIRTUAL-ADDRESS)))
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	;; Stop output on this device until the timer interrupts us.
	(JUMP INTR-OUTSTOP)

INTR-OUTDEV-NOW
	((MD) (BYTE-FIELD 8 24.) MD)
INTR-OUTDEV1
	((VMA-START-WRITE) A-INTR-TEM1)		;Store into device
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-END
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-B) ADD M-B (A-CONSTANT 1))		;Advance reading pointer
	(JUMP-GREATER-THAN READ-MEMORY-DATA A-B INTR-OUTDEV3)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-START
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-B) READ-MEMORY-DATA)
INTR-OUTDEV3
	((WRITE-MEMORY-DATA) M-B)
	((VMA-START-WRITE) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-BUFFER-OUT-PTR
						        %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	(JUMP UB-INTR-RET)

INTR-OUTSTOP
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-OUTPUT-TURNOFF-BITS
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-INTR-TEM1) READ-MEMORY-DATA)
	((VMA-START-READ) ADD M-A (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-OUTPUT-TURNOFF-ADDRESS
						       %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((VMA) READ-MEMORY-DATA)
	((WRITE-MEMORY-DATA-START-WRITE) A-INTR-TEM1)
	(CHECK-PAGE-WRITE-NO-INTERRUPT)		;Clear interrupt-enable bit
	(JUMP UB-INTR-RET)

;Come here for an interrupt on the interval timer.
;Perhaps turn on interrupts from a timed output device
;(which will immediately interrupt and be fed its next piece of output).
INTR-INTERVAL-TIMER
	((VMA) A-UNIBUS-TIMED-OUTPUT-CSR-ADDRESS)
	(JUMP-NOT-EQUAL VMA A-ZERO UB-INTR-RET)
	((MD-START-WRITE) A-UNIBUS-TIMED-OUTPUT-CSR-BITS)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP UB-INTR-RET)

;Read the time in microseconds, and put it in A-LAST-USEC-TIME.
READ-USEC-TIME
	((A-TEM2) MD)
	((VMA-START-READ) (A-CONSTANT (PLUS LOWEST-UNIBUS-VIRTUAL-ADDRESS
					    MICROSECOND-CLOCK-UNIBUS-ADDRESS)))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-LAST-USEC-TIME) MD)
	((VMA-START-READ) M+1 VMA)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(POPJ-AFTER-NEXT
	 (A-LAST-USEC-TIME) DPB MD (BYTE-FIELD 20 20) A-LAST-USEC-TIME)
       ((MD) A-TEM2)

;get here if PDP11 arbitrating UNIBUS.  This means we cannot depend on any UNIBUS
;interrupts so we poll all UNIBUS devices every XBUS interrupt.
INNL0	((VMA-START-READ M-B) A-CHAOS-CSR-ADDRESS)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%CHAOS-CSR-RECEIVE-ENABLE) MD INNL1)
	(JUMP-IF-BIT-SET (LISP-BYTE %%CHAOS-CSR-RECEIVE-DONE) MD CHAOS-INTR)
INNL1	(JUMP-IF-BIT-CLEAR (LISP-BYTE %%CHAOS-CSR-TRANSMIT-ENABLE) MD INNL2)
	(JUMP-IF-BIT-SET (LISP-BYTE %%CHAOS-CSR-TRANSMIT-DONE) MD CHAOS-INTR)
INNL2
  ;Now check all devices in the unibus vector tables.
	((M-A) (A-CONSTANT (EVAL (+ 400 %SYS-COM-UNIBUS-INTERRUPT-LIST
				    %UNIBUS-CHANNEL-VECTOR-ADDRESS
				    (- %UNIBUS-CHANNEL-LINK)))))
INND0	((VMA-START-READ) ADD M-A
		(A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-LINK %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((MD) Q-POINTER MD)
	(JUMP-EQUAL MD A-ZERO INTRX0)	;Reached end of list, maybe it really is the XBUS.
	((M-A) ADD MD (A-CONSTANT (EVAL %UNIBUS-CHANNEL-VECTOR-ADDRESS)))
	((VMA-START-READ) ADD M-A
	    (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-CSR-BITS %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-INTR-TEM1) READ-MEMORY-DATA)
	((VMA-START-READ) ADD M-A
	    (A-CONSTANT (EVAL (- %UNIBUS-CHANNEL-CSR-ADDRESS %UNIBUS-CHANNEL-VECTOR-ADDRESS))))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((VMA-START-READ) READ-MEMORY-DATA)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-TEM) AND READ-MEMORY-DATA A-INTR-TEM1)
  ;***Should make sure interrupt enable on.  It will be for kbd tho.***
	(JUMP-NOT-EQUAL M-TEM A-ZERO INNUBI)	;Device's ready bit on, handle.
	(JUMP INND0)

;;; XBUS interrupts

INTRX0	((VMA-START-READ) A-TV-REGS-BASE)	;Look for TV interrupt
	(CHECK-PAGE-READ-NO-INTERRUPT)
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 4) READ-MEMORY-DATA INTRX1)
	((WRITE-MEMORY-DATA-START-WRITE)	;Yes, clear flag
		ANDCA READ-MEMORY-DATA (A-CONSTANT 1_4))
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
	;; Here is the roughly-60-cycle clock interrupt handler
	(JUMP-LESS-OR-EQUAL M-ZERO A-CHAOS-TRANSMIT-ABORTED 60CYC-0)
	;; Wake up Chaosnet after transmit abort
	(CALL-XCT-NEXT CHAOS-WAKEUP)
       ((A-CHAOS-TRANSMIT-ABORTED) (A-CONSTANT 1))
60CYC-0	(JUMP-NOT-EQUAL A-DISK-BUSY M-ZERO 60CYC-1)
	((A-DISK-IDLE-TIME) M+A+1 M-ZERO A-DISK-IDLE-TIME)
60CYC-1	(CALL TRACK-MOUSE)			;See if the mouse has moved
	;; End of the 60-cycle clock interrupt handler
	(JUMP-LESS-THAN-XCT-NEXT M-ZERO A-TV-CLOCK-COUNTER INTRX1)
       ((A-TV-CLOCK-COUNTER) ADD (M-CONSTANT -1) A-TV-CLOCK-COUNTER)
	(JUMP-IF-BIT-CLEAR-XCT-NEXT M-SBS-CLOCK INTRX1)
       ((A-TV-CLOCK-COUNTER) ADD (M-CONSTANT -1) A-TV-CLOCK-RATE) ;Counted down, recycle
	((INTERRUPT-CONTROL)			; and give sequence break if needed
		IOR LOCATION-COUNTER (A-CONSTANT 1_26.))
INTRX1	(JUMP-EQUAL A-DISK-BUSY M-ZERO INTRX2)	;Look for disk interrupt
	((VMA-START-READ) A-DISK-REGS-BASE)
	(CHECK-PAGE-READ-NO-INTERRUPT)		;Bit 3 is interrupt-request
	(CALL-IF-BIT-SET (BYTE-FIELD 1 3) READ-MEMORY-DATA DISK-COMPLETION)
INTRX2	(JUMP XB-INTR-RET)			;End of interrupt chain
))