;-*-Mode:Midas-*-

(SETQ UC-MACROCODE '(
;;; MAIN INSTRUCTION EXECUTING LOOP

;NOTE: QMLP MUST BE AT LOC WITH BIT 1=0.  QMLP AND QMLP+1 ARE SKIPPED BY STREAM HARDWARE
; AUTOMATICALLY IF NO FETCH REQUIRED.
(MODULO 4) ;THIS CONSTRAINT IS A LITTLE MORE SEVERE THAN REALLY NECESSARY
QMLP	(CALL-CONDITIONAL PG-FAULT-INTERRUPT-OR-SEQUENCE-BREAK QMLP-P-OR-I-OR-SB)
	((M-INST-BUFFER) READ-MEMORY-DATA)
	(DISPATCH-XCT-NEXT M-INST-OP OPDTB)
   (ERROR-TABLE ILLEGAL-INSTRUCTION)
      ((MICRO-STACK-DATA-PUSH) A-MAIN-DISPATCH)	;PUT BACK RETURN FOR NEXT TIME

QMLP-P-OR-I-OR-SB
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 26.) LOCATION-COUNTER PGF-R-I)    ;Jump on no SB
;Prepare to take SB, make sure VMA doesnt point to untyped storage.
	((VMA) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
;Funnyness with 0@U.  0@U is not saved as part of the SG.  Instead, it is physically
;replaced with the appropriate main loop return when the SG is resumed.
;Our return is currently in 0@U, so would go away if this happened.  So we
;bugger things so the standard thing is in 0@U, which requires decrementing the PC.
	((M-GARBAGE) MICRO-STACK-DATA-POP)
	((LOCATION-COUNTER) SUB LOCATION-COUNTER (A-CONSTANT 2))
	(JUMP-XCT-NEXT SBSER)
       ((MICRO-STACK-DATA-PUSH) A-MAIN-DISPATCH)

(MODULO 4)
DMLP	(CALL-CONDITIONAL PG-FAULT-INTERRUPT-OR-SEQUENCE-BREAK DMLP-P-OR-I-OR-SB)
        ((M-INST-BUFFER) READ-MEMORY-DATA)
        ((M-1) DPB M-ZERO Q-ALL-BUT-POINTER A-TRAP-AP-LEVEL)
        (JUMP-EQUAL M-1 A-ZERO DMLP-1)	;DONT CHACK M-AP LEVEL
        (CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) PDL-BUFFER-POINTER)
        (JUMP-LESS-OR-EQUAL M-K A-TRAP-AP-LEVEL STEP-BREAK-1)
DMLP-1	(DISPATCH-XCT-NEXT M-INST-OP OPDTB)
       ((MICRO-STACK-DATA-PUSH) A-DEBUG-DISPATCH)

DMLP-P-OR-I-OR-SB
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 26.) LOCATION-COUNTER PGF-R-I)    ;Jump on no SB
;Prepare to take SB, make sure VMA doesnt point to untyped storage.
	((VMA) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
;Funnyness with 0@U.  0@U is not saved as part of the SG.  Instead, it is physically
;replaced with the appropriate main loop return when the SG is resumed.
;Our return is currently in 0@U, so would go away if this happened.  So we
;bugger things so the standard thing is in 0@U, which requires decrementing the PC.
	((M-GARBAGE) MICRO-STACK-DATA-POP)
	((LOCATION-COUNTER) SUB LOCATION-COUNTER (A-CONSTANT 2))
	(JUMP-XCT-NEXT SBSER)
       ((MICRO-STACK-DATA-PUSH) A-DEBUG-DISPATCH)

(MODULO 4)
SINGLE-STEP
	(CHECK-PAGE-READ)
        ((M-INST-BUFFER) READ-MEMORY-DATA)
	((M-1) (A-CONSTANT (EVAL SG-SINGLE-STEP-TRAP)))	;CHANGE STACK-GROUP-STATE
	((A-SG-STATE) DPB M-1 (LISP-BYTE %%SG-ST-INST-DISP) A-SG-STATE) ;TO SINGLE-STEP TRAP
        (DISPATCH-XCT-NEXT M-INST-OP OPDTB)
       ((MICRO-STACK-DATA-PUSH) A-SINGLE-STEP-TRAP)	;RETURN TO STEP-BREAK

;;; WE HAVE TO WASTE THESE INSTRUCTIONS, BECAUSE WE WANT THE MACRO PC TO BE
;;; INCREMENTED, AND IT MIGHT SKIP THE FIRST 2 INSTRUCTIONS IF IT DOESN'T DO
;;; A MEMORY CYCLE (WHICH WE DONT ACTUALLY CARE ABOUT)
(MODULO 4)
STEP-BREAK
	(CHECK-PAGE-READ)
        ((M-INST-BUFFER) READ-MEMORY-DATA)
STEP-BREAK-1
	((LOCATION-COUNTER) SUB LOCATION-COUNTER (A-CONSTANT 2)) ;instr not done yet
	((MICRO-STACK-DATA-PUSH) A-SINGLE-STEP-TRAP)        ;Mustn't have empty pdl!
	(CALL TRAP)
     (ERROR-TABLE STEP-BREAK)


INSTRUCTION-STREAM-FETCHER   ;DO FETCHES ASSOCIATED WITH MULTI-UNIT INSTUCTIONS.
	(CHECK-PAGE-READ)
	(POPJ-AFTER-NEXT NO-OP)
       ((M-INST-BUFFER) READ-MEMORY-DATA)

;;; THIS IS THE MISC ENTRY SMASHED IN FOR BREAKPOINTS IN FEF'S
BREAKPOINT (MISC-INST-ENTRY BPT)
	(CALL TRAP)
     (ERROR-TABLE BREAKPOINT)


;;; EFFECTIVE ADDRESS COMPUTATION ROUTINES.
;   THESE ARE ENTERED FROM QADCM1, THEY PUT THE OPERAND INTO M-T AND POPJ.
; Q-ALL-BUT-TYPED-POINTER bits should be zero.

QAFE	((M-1) M-INST-ADR)			;FULL DELTA
QAFE1	((PDL-BUFFER-INDEX) M-AP)		;0(AP) -> FEF
	((VMA-START-READ) ADD C-PDL-BUFFER-INDEX A-1)
QADR4	(CHECK-PAGE-READ)			;NOTE THAT DATA-TYPE OF VMA DOESN'T MATTER
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT READ-MEMORY-DATA) ;FOLLOW ALL INVZ
       ((M-T) Q-TYPED-POINTER READ-MEMORY-DATA)	;RETURN C(E) IN M-T

;GET EFFECTIVE ADDRESS, NOT PLANNING TO READ CONTENTS.  POPJ WITH EFF ADR ON PDL
;MUSTN'T TRANSPORT, NOR BARF AT TRAP, BUT MUST FOLLOW EXTERNAL VALUE CELL POINTER
QEAFE	((M-1) M-INST-ADR)			;FULL DELTA
	((PDL-BUFFER-INDEX) M-AP)		;0(AP) -> FEF
	((VMA-START-READ) ADD C-PDL-BUFFER-INDEX A-1)
	(CHECK-PAGE-READ)  
	(POPJ-AFTER-NEXT DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA) ;FOLLOW ALL INVZ
       ((C-PDL-BUFFER-POINTER-PUSH) DPB VMA	;PUSH VMA AS A LOCATIVE
		Q-POINTER (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
					    (BYTE-VALUE Q-CDR-CODE CDR-NEXT))))

;REF LOCAL BLOCK.  CANNOT BE INVISIBLE POINTER.
;IF THIS IS EVER CHANGED TO ALLOW INVISIBLE POINTERS, GOT TO FOOL AROUND
;WITH THE QADCM3 DISPATCH AND THE THINGS THAT USE IT, AND DECIDE WHICH
;FLAVORS OF INVISIBILITY DO WHAT WITH RESPECT TO VALUE-CELL-LOCATION.
QADLOC	((M-1) M-INST-DELTA)
QADLOC1	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-1 A-LOCALP)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)

;REF ARGUMENT BLOCK.  CANNOT BE INVISIBLE POINTER.
QADARG	((M-1) M-INST-DELTA)
QADARG1	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-AP A-1 ALU-CARRY-IN-ONE) ;%LP-INITIAL-LOCAL-BLOCK-OFFSET=1
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-INDEX)

;REF CONSTANTS PAGE.
QAQT	((M-1) M-INST-DELTA)
QAQT1	(JUMP-XCT-NEXT QADR4)
       ((VMA-START-READ) ADD M-1 A-V-CONSTANTS-AREA)

;Ref pdl or ref instance var.
;Most common is pdl (delta is 77), so arrange not to slow that case down
;with the check for the other case.
QADPDL	((M-1) M-INST-DELTA)
QADPDL1	(POPJ-AFTER-NEXT
	 (M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
       (CALL-NOT-EQUAL M-1 (A-CONSTANT 77) QADPDLT)	;Really instance var ref.

;Delta 0 thru 37 is index of unmapped ivar.
;40 thru 67 is index of mapped ivar.  70 thru 76 are reserved.
QADPDLT
	((PDL-POINTER) ADD PDL-POINTER (A-CONSTANT 1))	;Undo the mistaken pop.
;; Error if SELF is not an instance.
	((M-T) DPB M-ZERO Q-POINTER A-SELF)
	(CALL-NOT-EQUAL M-T
	 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-INSTANCE))
	 TRAP)
;; Is it unmapped (less than 40)?
    (ERROR-TABLE SELF-NOT-INSTANCE)
	(JUMP-IF-BIT-SET (BYTE-FIELD 1 5) M-1 QADPDLT-MAPPED)
;; Ref to unmapped instance variable.
	(JUMP-XCT-NEXT QADR4)
       ((VMA-START-READ) M+A+1 M-1 A-SELF)

QADPDLT-MAPPED
	(CALL-GREATER-OR-EQUAL M-1 (A-CONSTANT 70) TRAP)	;Reserved for future use.
   (ERROR-TABLE ILLEGAL-INSTRUCTION)
;Map the SELF-REF-INDEX thru the mapping table, an ART-16B array.
	((M-T) (BYTE-FIELD 20 1) M-1)
	((VMA-START-READ) M+A+1 A-SELF-MAPPING-TABLE M-T)
	(CHECK-PAGE-READ)
	(JUMP-IF-BIT-CLEAR (BYTE-FIELD 1 0) M-1 QADPDLT-MAPPED-EVEN)
	((MD) (BYTE-FIELD 20 20) MD)
QADPDLT-MAPPED-EVEN
	((M-1) (BYTE-FIELD 20 0) MD)
;; Now we have the actual index; ref that slot.
	(JUMP-XCT-NEXT QADR4)
       ((VMA-START-READ) M+A+1 M-1 A-SELF)
	
;Make a pointer to the desired slot in SELF and then INVZ to there.
;MD contains the slot number.
;Note: no need to check for oldspace since A-SELF can't point to oldspace.


;;; STORE CYCLE
;   VALUE IN M-T.  A READ-TYPE EFF ADDR COMPUTATION MAY OR MAY NOT
;   HAVE TAKEN PLACE ALREADY.
;   EXITS VIA POPJ BACK TO MAIN LOOP.

QIPOP	((M-T) C-PDL-BUFFER-POINTER-POP)	;POP INST, CODE BELOW DUPLICATES STOCYC
	(DISPATCH-XCT-NEXT M-INST-REGISTER QADCM2)	;DISPATCH ON ADDRESS TYPE
       ((M-1) M-INST-DELTA)				;WITH DELTA IN M-1

QIMVM	((M-T) C-PDL-BUFFER-POINTER)			;MOVEM INSTRUCTION
STOCYC	(DISPATCH-XCT-NEXT M-INST-REGISTER QADCM2)	;DISPATCH ON ADDRESS TYPE
       ((M-1) M-INST-DELTA)				;WITH DELTA IN M-1

;STOCYC ENDS UP HERE IF USING FEF ADDRESSING.
;STORE IN FEF, NO READ CYCLE TOOK PLACE, SO MUST COMPUTE VMA AND CHECK FOR INVZ
QSTFE	((M-1) M-INST-ADR)				;FULL DELTA
QSTFE1	((PDL-BUFFER-INDEX) M-AP)			;0(AP) -> FEF
	((VMA-START-READ) ADD C-PDL-BUFFER-INDEX A-1)
	(CHECK-PAGE-READ)  
XSET2							;Entry from SET
	(DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA)	;FOLLOW ALL INVZ
		;FOLLOWING INSTRUCTION MUSTN'T POPJ-AFTER-NEXT BECAUSE
		;CANNOT START WRITE AND INSTRUCTION FETCH SIMULTANEOUSLY
	(JUMP-IF-BIT-SET Q-FLAG-BIT MD QSTFE-MONITOR)
QSTFE-M	((MD-START-WRITE) SELECTIVE-DEPOSIT
		MD Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       ((M-T) Q-TYPED-POINTER M-T)

;Get here if FLAG-BIT set in a cell about to be written.  Find monitor function
; following the cell, and call it with args  <old-value>, <new-value>.
; If old value is DTP-NULL, don't crash the machine; pass unbound marker instead
QSTFE-MONITOR
	(CALL-XCT-NEXT QSTFE-M)		;Complete store
       ((M-A) Q-TYPED-POINTER MD)	;Save copy of old value
	(POPJ-EQUAL M-A A-T)		;Same thing, thats all.
	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;Save copy of new to return
	(CALL P3ZERO)
	((VMA-START-READ) M+1 VMA)
	(CHECK-PAGE-READ)
	((C-PDL-BUFFER-POINTER-PUSH) MD)	;Monitoring function
	((C-PDL-BUFFER-POINTER-PUSH) M-A)	;Old value
	((M-TEM) Q-DATA-TYPE M-A)		;Substitute Unbound marker?
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-NULL)) QSTFE-MONITOR-1)
	((ARG-CALL REF-SUPPORT-VECTOR) (I-ARG SVCUNB))
	((C-PDL-BUFFER-POINTER) READ-MEMORY-DATA)	
QSTFE-MONITOR-1
	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;New value
	((ARG-JUMP MMCALL) (I-ARG 2))
	(POPJ-AFTER-NEXT
	  (M-T) C-PDL-BUFFER-POINTER-POP)
       (NO-OP)

;STORE IN LOCAL BLOCK
QSTLOC	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-1 A-LOCALP)
       ((C-PDL-BUFFER-INDEX) M-T)

;STORE IN ARGUMENT BLOCK
QSTARG	(POPJ-AFTER-NEXT
	 (PDL-BUFFER-INDEX) ADD M-AP A-1 ALU-CARRY-IN-ONE)
       ((C-PDL-BUFFER-INDEX) M-T)

;PUSH LOCATIVE POINTER TO ADDRESS OF LOCAL VARIABLE ONTO THE PDL
QVMALCL (CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) ADD M-1 A-LOCALP)
	;; Set the flag saying that we have pointers to our stack frame
	;; so we should not flush it.
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((M-2) C-PDL-BUFFER-INDEX)
	(POPJ-AFTER-NEXT
	 (C-PDL-BUFFER-POINTER-PUSH) DPB M-K Q-POINTER
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  (BYTE-VALUE Q-CDR-CODE CDR-NEXT))))
	;; Note: the previous insn must not be the last one
	;; because the pdl buffer has no pass around path.
       ((C-PDL-BUFFER-INDEX) DPB M-MINUS-ONE (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG) A-2)

;PUSH LOCATIVE POINTER TO ADDRESS OF ARGUMENT VARIABLE ONTO THE PDL
QVMAARG (CALL-XCT-NEXT CONVERT-PDL-BUFFER-ADDRESS)
       ((M-K) ADD M-AP A-1 ALU-CARRY-IN-ONE)
	;; Set the flag saying that we have pointers to our stack frame
	;; so we should not flush it.
	((PDL-INDEX) ADD M-AP (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	((M-2) C-PDL-BUFFER-INDEX)
	(POPJ-AFTER-NEXT
	 (C-PDL-BUFFER-POINTER-PUSH) DPB M-K Q-POINTER
		(A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)
				  (BYTE-VALUE Q-CDR-CODE CDR-NEXT))))
	;; Note: the previous insn must not be the last one
	;; because the pdl buffer has no pass around path.
       ((C-PDL-BUFFER-INDEX) DPB M-MINUS-ONE (LISP-BYTE %%LP-ENS-UNSAFE-REST-ARG) A-2)

;Get and set lexical variables inherited from outer contexts.
XLOAD-FROM-HIGHER-CONTEXT
	(MISC-INST-ENTRY %LOAD-FROM-HIGHER-CONTEXT)
	(CALL XLOCATE-IN-HIGHER-CONTEXT)
	(JUMP QCAR)

XSTORE-IN-HIGHER-CONTEXT
	(MISC-INST-ENTRY %STORE-IN-HIGHER-CONTEXT)
	(CALL XLOCATE-IN-HIGHER-CONTEXT)
	((M-S) M-T)
	(JUMP-XCT-NEXT QRAR1)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

XLOCATE-IN-HIGHER-CONTEXT
	(MISC-INST-ENTRY %LOCATE-IN-HIGHER-CONTEXT)
;Compute in M-T the address of a local or arg in a higher lexical context.
;Pops a word off the stack to specify where to find the local:
;  Sign bit	  0 => arg, 1 => local.
;  Next 11. bits  Number of contexts to go up (0 => immediate higher context)
;  Low 12. bits	  Number of arg or local in that context.
	((M-A) C-PDL-BUFFER-POINTER-POP)
	((M-B) (BYTE-FIELD 11. 12.) M-A)
	((M-T) A-LEXICAL-ENVIRONMENT)
XLOCATE-IN-HIGHER-CONTEXT-1
	(JUMP-EQUAL M-B A-ZERO XLOCATE-IN-HIGHER-CONTEXT-3)
	(CALL QCDR)
	(JUMP-XCT-NEXT XLOCATE-IN-HIGHER-CONTEXT-1)
       ((M-B) SUB M-B (A-CONSTANT 1))

XLOCATE-IN-HIGHER-CONTEXT-3
	(CALL QCAR)
	(CALL-EQUAL M-T A-V-NIL TRAP)
    (ERROR-TABLE ILLEGAL-INSTRUCTION)
	(JUMP-IF-BIT-CLEAR BOXED-SIGN-BIT M-A XLOCATE-IN-HIGHER-CONTEXT-2)
	((VMA-START-READ) ADD M-T (A-CONSTANT (EVAL %LP-ENTRY-STATE)))
	(CHECK-PAGE-READ)
	((M-B) (LISP-BYTE %%LP-ENS-MACRO-LOCAL-BLOCK-ORIGIN) MD)
	((M-T) ADD M-B A-T)
	((M-T) SUB M-T (A-CONSTANT 1))
XLOCATE-IN-HIGHER-CONTEXT-2
	((M-B) (BYTE-FIELD 12. 0) M-A)
	(POPJ-AFTER-NEXT
	 (M-T) M+A+1 M-B A-T)
	((M-T) DPB M-T Q-POINTER
	       (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))


;;; BASIC INSTRUCTIONS
;   OPERAND IS NOT FETCHED YET, SO FETCH IT INTO M-T, THEN
;   PRODUCE RESULT IN M-T, AND DISPATCH ON DESTINATION FIELD

QICDDR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCDR)))	;CALL QCDR BEFORE RETURNING
	(JUMP-XCT-NEXT QIMOVE1)
       (CALL QCDR)

QICDR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCDR)))	;CALL QCDR BEFORE RETURNING
	(DISPATCH M-INST-DEST QMDTBD)		;MAY EXECUTE NEXT INSTUCTION
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))

QICADR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCDR)))	;CALL QCDR BEFORE RETURNING
	(JUMP-XCT-NEXT QIMOVE1)
       (CALL QCAR)

QICAR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCAR)))	;CALL QCAR BEFORE RETURNING
	(DISPATCH M-INST-DEST QMDTBD)		;MAY EXECUTE NEXT INSTUCTION
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))

QICAAR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCAR)))	;CALL QCAR BEFORE RETURNING
	(JUMP-XCT-NEXT QIMOVE1)
       (CALL QCAR)

QICDAR	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)		;FETCH C(E)
       ((MICRO-STACK-DATA-PUSH) (A-CONSTANT (I-MEM-LOC QCAR)))	;CALL QCAR BEFORE RETURNING
	(JUMP-XCT-NEXT QIMOVE1)
       (CALL QCDR)

QIMOVE	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM4)
       ((M-1) M-INST-DELTA)
QIMOVE1	(DISPATCH M-INST-DEST QMDTBD)		;MAY EXECUTE NEXT INSTUCTION
       ((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))

;ALL OF THESE WANT OPERAND FETCHED.
QIND1	(DISPATCH-XCT-NEXT M-INST-DEST D-ND1)
       (DISPATCH-CALL M-INST-REGISTER QADCM5)

;ALL OF THESE WANT OPERAND FETCHED.
QIND2	(DISPATCH-XCT-NEXT M-INST-DEST D-ND2)
       (DISPATCH-CALL M-INST-REGISTER QADCM5)

;THESE DON'T WANT THEIR OPERAND FETCHED.
QIND3	(DISPATCH M-INST-DEST D-ND3)

;CALL WITH NO ARGS
QICAL0	(DISPATCH-CALL M-INST-REGISTER QADCM5)		;FETCH C(E)
	(JUMP-XCT-NEXT QMRCL)				;ACTIVATE, BUT FIRST
       (CALL CBM)					;OPEN CALL BLOCK

;CALL WITH ARGS.  JUST OPEN A CALL BLOCK.
QICALL	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM1)	;FETCH C(E)
CBM    ((M-C) M-INST-DEST)		;EVENTUAL DESTINATION
CBM0					;%OPEN-CALL-BLOCK etc. call in here
	((M-ZR) ADD PDL-BUFFER-POINTER	;Open macro-to-macro call block
		 (A-CONSTANT (EVAL %LP-CALL-BLOCK-LENGTH)))
	((M-TEM) SUB M-ZR A-IPMARK)	;Compute delta to prev open block
	((A-TEM1) DPB M-TEM (LISP-BYTE %%LP-CLS-DELTA-TO-OPEN-BLOCK)
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-TEM) SUB M-ZR A-AP)		;Compute delta to prev active block
	((A-TEM1) DPB M-TEM (LISP-BYTE %%LP-CLS-DELTA-TO-ACTIVE-BLOCK) A-TEM1)
	((C-PDL-BUFFER-POINTER-PUSH)	;Push LPCLS Q
	    DPB M-C (LISP-BYTE %%LP-CLS-DESTINATION) A-TEM1)
;QBNEAF QBALM WOULD GO HERE IF EVER REVIVED
	((C-PDL-BUFFER-POINTER-PUSH)	;Push LPEXS Q
	    (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((C-PDL-BUFFER-POINTER-PUSH)	;Push LPENS Q
	    (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(POPJ-AFTER-NEXT		;Push LPFEF Q
	  (C-PDL-BUFFER-POINTER-PUSH) M-T)
       ((A-IPMARK) (BYTE-FIELD 10. 0) M-ZR)	;A-IPMARK -> new open block


;;; MISC INSTRUCTION
;;; Note that the misc function invoked might do a micro-to-macro call,
;;; upon return M-INST-BUFFER would not be set up.  Therefore we must not
;;; depend on it.  The MISC instruction works by doing something similar
;;; to a micro-to-micro call to the misc function, with a return address
;;; dependent on the destination; in the case of D-IGNORE there is no
;;; return address, it returns directly to the main instruction loop.
;;; This means that any misc instruction which can be called to D-IGNORE
;;; must not start a memory cycle in the same instruction that popjs.
;;; MISC insts must return their value in M-T, with 0 in Q-ALL-BUT-TYPED-POINTER.
MISC	((M-B) M-INST-ADR)	;GET LOW 9 BITS OF INST
	(JUMP-LESS-THAN	M-B (A-CONSTANT 200) AREFI)	;ARRAY REFERENCES
	((VMA-START-READ) ADD A-V-MISC-BASE M-B)
	(CHECK-PAGE-READ)
	(DISPATCH-XCT-NEXT M-INST-DEST D-MISC-DEST)
       ((OA-REG-LOW M-LAST-MICRO-ENTRY) DPB READ-MEMORY-DATA OAL-JUMP A-ZERO)
	(JUMP 0)		;CALL EXECUTION ROUTINE

MISC-TO-STACK
	(CALL 0)		;CALL EXECUTION ROUTINE
M-T-TO-STACK
	(POPJ-AFTER-NEXT (C-PDL-BUFFER-POINTER-PUSH) Q-TYPED-POINTER M-T
			(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NEXT)))
       (NO-OP)


;;; BRANCH INSTRUCTION

QIBRN	(DISPATCH-XCT-NEXT M-INST-DEST BRDTAB)	;DISP ON BRANCH TYPE
       ((M-B) M-INST-ADR-*2+X)			;M-B = OFFSET IN BYTES, LOW BIT INDETERMINATE
						;NOTE THAT THE LC HARDWARE IGNORES THE LOW BIT
						;AND READS IT BACK AS ZERO IN HALFWORD MODE

;HERE WHEN YOU'VE DECIDED TO BRANCH
QBRALW	(CALL-IF-BIT-SET (BYTE-FIELD 1 9) M-B QBRLZ1)  ;EXTEND SIGN IF NECESSARY
QBRLZ2	(POPJ-AFTER-NEXT			;NOTE, MUST CHANGE LC IN SAME CYCLE AS POPJ
	  (LOCATION-COUNTER) ADD LOCATION-COUNTER A-B)
       (NO-OP)					;THIS CYCLE DOES VMA<-LC, START-READ

;BRANCH DELTA NEGATIVE
QBRLZ1	(POPJ-LESS-THAN-XCT-NEXT M-B (A-CONSTANT 1776))	;RETURN TO QBRLZ2 UNLESS LONG BRANCH
       ((M-B) SELECTIVE-DEPOSIT (M-CONSTANT -1)
		(BYTE-FIELD 22. 10.) A-B)	;EXTEND SIGN
;DOUBLE-LENGTH BRANCH, LONG OFFSET IS IN SECOND HALFWORD
	(DISPATCH ADVANCE-INSTRUCTION-STREAM)
	((M-B) (BYTE-FIELD 17. 37) ;SAME TRICK AS WITH M-INST-ADR-*2+X. 
			M-INST-BUFFER INSTRUCTION-STREAM)
	(POPJ-AFTER-NEXT			;RETURN TO QBRLZ2, XCT NEXT IF EXTEND SIGN
	  POPJ-IF-BIT-CLEAR (BYTE-FIELD 1 16.) M-B)
       ((M-B) SELECTIVE-DEPOSIT (M-CONSTANT -1)
		(BYTE-FIELD 15. 17.) A-B)

QBRNL	((M-K) Q-TYPED-POINTER M-T)		;BRANCH ON NIL
	(JUMP-EQUAL M-K A-V-NIL QBRALW)

;HERE WHEN YOU'VE DECIDED NOT TO BRANCH
QBRNOT	(POPJ-LESS-THAN M-B (A-CONSTANT 1776))	;CHECK FOR DOUBLE LENGTH INSTRUCTION
	(DISPATCH ADVANCE-INSTRUCTION-STREAM)
	(POPJ)

QBRNNL	((M-K) Q-TYPED-POINTER M-T)		;BRANCH ON NOT NIL
	(JUMP-NOT-EQUAL M-K A-V-NIL QBRALW)
	(POPJ-LESS-THAN M-B (A-CONSTANT 1776))	;CHECK FOR DOUBLE LENGTH INSTRUCTION
	(DISPATCH ADVANCE-INSTRUCTION-STREAM)   ;DUPLICATED AS MINOR SPEED BUM.
	(POPJ)

QBRAT	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-ATOM)	;BRANCH ON ATOM
	 (JUMP QBRNOT)
	(JUMP QBRALW)

QBRNAT	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-ATOM)	;BRANCH ON NOT-ATOM
	 (JUMP QBRALW)
	(JUMP QBRNOT)

QBRNLP	((M-K) Q-TYPED-POINTER M-T)		;BR NIL, POP IF NOT
	(JUMP-EQUAL M-K A-V-NIL QBRALW)
	(JUMP-XCT-NEXT QBRNOT)
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)

QBRNNP	((M-K) Q-TYPED-POINTER M-T)		;BR NOT NIL, POP IF
	(JUMP-NOT-EQUAL M-K A-V-NIL QBRALW)
	(JUMP-XCT-NEXT QBRNOT)
       ((M-GARBAGE) C-PDL-BUFFER-POINTER-POP)

;;; NON-DESTINATION-GROUP-2
;   E IN VMA, C(E) IN M-T

;THESE COMPARE C(E) TO TOP OF STACK, POP,
; AND LEAVE T OR NIL IN M-T IN LIEUE OF SETTING INDICATORS

XMEQ (MISC-INST-ENTRY M-EQ)
	((M-T) C-PDL-BUFFER-POINTER-POP)
QMEQ					;MC-LINKAGE
QIEQ	((M-2) Q-TYPED-POINTER M-T)
	((M-1) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	(JUMP-NOT-EQUAL M-1 A-2 XFALSE)
  (MISC-INST-ENTRY TRUE)
XTRUE	(POPJ-AFTER-NEXT (M-T) A-V-TRUE)
       (NO-OP)

;Numeric comparisons are off with the rest of the numeric stuff.
;THESE MODIFY THE CONTENTS OF THEIR EFFECTIVE ADDRESS

QISCDDR	(JUMP-XCT-NEXT STOCYC)
       (CALL QMDD)		;CDDR THE ARGUMENT

QISCDR	(JUMP-XCT-NEXT STOCYC)
       (CALL QMD)		;CDR THE ARGUMENT

QISM1	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;NO PASS-AROUND PATH ON PDL BUFFER
	(JUMP-XCT-NEXT STOCYC)			;STORES BACK WITH NO ASSUMPTIONS ABOUT VMA
       (CALL X1MNS)				;M-T GETS (1- PDL)
	
QISP1	((C-PDL-BUFFER-POINTER-PUSH) M-T)	;NO PASS-AROUND PATH ON PDL BUFFER
	(JUMP-XCT-NEXT STOCYC)			;STORES BACK WITH NO ASSUMPTIONS ABOUT VMA
       (CALL X1PLS)				;M-T GETS (1+ PDL)

;;; NON-DESTINATION-GROUP-3
;   EFFECTIVE ADDRESS NOT YET COMPUTED, M-T NOT VALID.

QIPSHE	(DISPATCH-XCT-NEXT M-INST-REGISTER QADCM3)	;EFF ADR TO PDL AND POPJ
       ((M-1) M-INST-DELTA)
    (ERROR-TABLE ILLEGAL-INSTRUCTION)

QISETN	(JUMP-XCT-NEXT STOCYC)
       ((M-T) A-V-NIL)

QISETZ	(JUMP-XCT-NEXT STOCYC)
       ((M-T) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))

QIBNDN	(CALL QBND1)		;SAVE PRESENT BINDING
	((M-T) A-V-NIL)		;AND RE-BIND TO NIL
QIBDN1	((M-T WRITE-MEMORY-DATA-START-WRITE) SELECTIVE-DEPOSIT M-E
		Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(POPJ-AFTER-NEXT GC-WRITE-TEST)
       (NO-OP)

QIBNDP	(CALL QBND1)		;SAVE PRESENT BINDING
	(JUMP-XCT-NEXT QIBDN1)	;AND REBIND TO POP(PDL)
       ((M-T) C-PDL-BUFFER-POINTER-POP)

XUBI  (MISC-INST-ENTRY %USING-BINDING-INSTANCES)  ;One arg, a list of binding instances.
	(JUMP-XCT-NEXT QCLS1)
       ((M-T) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)

XBIND (MISC-INST-ENTRY BIND)
	((M-T) C-PDL-BUFFER-POINTER-POP)		;ARG 2, NEW VALUE TO GIVE
   (ERROR-TABLE RESTART XBIND)
	((M-ZR) Q-DATA-TYPE C-PDL-BUFFER-POINTER)	;ARG 1, POINTER TO CELL TO BIND
	(CALL-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-LOCATIVE)) TRAP)
   (ERROR-TABLE ARGTYP LOCATIVE PP 0 XBIND)
   (ERROR-TABLE ARG-POPPED 0 PP M-T)
XBIND1	(JUMP-XCT-NEXT QIBDN1)
       (CALL QBND2)

;Come here to make a binding "for a closure"; that is, a binding
;whose %%SPECPDL-CLOSURE-BINDING flag is set, saying that the binding
;was done "outside" of the actual function in the stack frame.
QBND4-CLOSURE
	(DISPATCH TRANSPORT-NO-EVCP-READ-WRITE READ-MEMORY-DATA)	;DON'T FOLLOW EXTERNAL-VALUE-CELL-PTR
;LOGICALLY SIMILAR CODE TO BELOW EXISTS AT QBSPCL
	;M-E can be an invisible pointer, so don't save typed pointer part.
	((M-E) SELECTIVE-DEPOSIT READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER
		 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))

	((MD) ANDCA MD (A-CONSTANT (BYTE-VALUE %%SPECPDL-BLOCK-START-FLAG 1)))
	(JUMP-XCT-NEXT QBND4-CLOSURE-1)
       ((MD) IOR MD (A-CONSTANT (BYTE-VALUE %%SPECPDL-CLOSURE-BINDING 1)))

QIBND 				;SAVE CURRENT CONTENTS, DON'T CHANGE
				;LEAVE M-E SET TO OLD CONTENTS (MAINLY FOR CDR CODE)
QBND1	(DISPATCH-CALL-XCT-NEXT M-INST-REGISTER QADCM6)	;EFF ADR TO PDL
       ((M-1) M-INST-DELTA)
    (ERROR-TABLE ILLEGAL-INSTRUCTION)
QBND2	((VMA-START-READ M-B) C-PDL-BUFFER-POINTER-POP)	;FETCH CURRENT CONTENTS
	(CHECK-PAGE-READ)				;INT OK, HAVEN'T HACKED YET
;VMA and M-B have location being bound.  MD has current contents.
;Will return with old-value saved and Q-ALL-BUT-TYPED-POINTER in M-E,
;VMA and M-B updated to actual location bound (different if there is a ONE-Q-FORWARD).
QBND4	(DISPATCH TRANSPORT-NO-EVCP-READ-WRITE READ-MEMORY-DATA)	;DON'T FOLLOW EXTERNAL-VALUE-CELL-PTR
;LOGICALLY SIMILAR CODE TO BELOW EXISTS AT QBSPCL
	;M-E can be an invisible pointer, so don't save typed pointer part.
	((M-E) SELECTIVE-DEPOSIT READ-MEMORY-DATA Q-ALL-BUT-TYPED-POINTER
		 (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	((MD) DPB MD Q-TYPED-POINTER A-ZERO)
QBND4-CLOSURE-1
	((M-1) ADD (M-CONSTANT (DIFFERENCE Q-POINTER-WIDTH 1)) A-QLBNDP)	;TEST P.C.E. (THIS M-CONST JUST HAPPENED TO
	((M-1) SUB M-1 A-QLBNDH)		; BE AROUND AT THE WRONG TIME).
	(CALL-IF-BIT-CLEAR BOXED-SIGN-BIT M-1 TRAP)
   (ERROR-TABLE PDL-OVERFLOW SPECIAL)		;M-1 SHOULD BE NEGATIVE AS 24-BIT QUANTITY
	(JUMP-IF-BIT-SET-XCT-NEXT M-QBBFL QBND3)	 ;JUMP IF NOT FIRST IN BLOCK
       ((M-B) VMA)	;THIS INSTRUCTION MAKES IT FOLLOW FORWARDING POINTERS
			;AND BIND THAT FINALLY POINTED-TO CELL RATHER THAN THE
			;INTERNAL VALUE CELL.  THIS ONLY APPLIES WHEN IT IS
			;FORWARDED WITH DTP-ONE-Q-FORWARD RATHER THAN
			;DTP-EXTERNAL-VALUE-CELL-POINTER
	((MD) IOR MD (A-CONSTANT (BYTE-VALUE %%SPECPDL-BLOCK-START-FLAG 1)))
	((M-QBBFL) DPB (M-CONSTANT -1) A-FLAGS)
QBND3	((VMA-START-WRITE) ADD A-QLBNDP M-ZERO ALU-CARRY-IN-ONE)	;STORE PREV CONTENTS
	(CHECK-PAGE-WRITE)			;HAVE INCRD A-QLBNDP, NO SEQ BRK
	((A-QLBNDP) ADD VMA (A-CONSTANT 1))
	(GC-WRITE-TEST)
	((WRITE-MEMORY-DATA) Q-POINTER M-B	;LOCATIVE PNTR TO BOUND LOCN
		(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
	((VMA-START-WRITE) A-QLBNDP)		;STORE POINTER TO BOUND CELL
	(CHECK-PAGE-WRITE)			;NO SEQ BRK, BIND NOT REALLY FINISHED
	(POPJ-AFTER-NEXT GC-WRITE-TEST)	;NOTE, POPJ MUST BE DELAYED BECAUSE CANNOT START WRITE
       ((VMA) M-B)		;AND INSTRUCTION FETCH SIMULTANEOUSLY.

;SPECIAL KLUDGEY ADDRESS ROUTINE FOR BIND.  ALWAYS INDIRECTS ONE LEVEL.
;RETURNS WITH ADDRESS ON PDL.
QBAFE	((M-1) M-INST-ADR)			;FULL DELTA
	((PDL-BUFFER-INDEX) M-AP)		;0(AP) -> FEF
	((VMA-START-READ) ADD C-PDL-BUFFER-INDEX A-1)
	(CHECK-PAGE-READ)  
	(DISPATCH TRANSPORT-NO-EVCP READ-MEMORY-DATA)	;ONLY TRANSPORT, DON'T DO INVZ
	((M-ZR) Q-DATA-TYPE READ-MEMORY-DATA)	;MAKE SURE IT WAS AN EVCP
	(POPJ-AFTER-NEXT			;AND RETURN LOCATIVE ON PDL
	 (C-PDL-BUFFER-POINTER-PUSH) DPB READ-MEMORY-DATA
		Q-POINTER (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-LOCATIVE)))
			;NO PASS-AROUND PATH ON PDL-BUFFER
       (CALL-NOT-EQUAL M-ZR (A-CONSTANT (EVAL DTP-EXTERNAL-VALUE-CELL-POINTER)) ILLOP)

;;; DESTINATION HANDLERS
;   DATA TO STORE IN M-T

;THESE DESTINATIONS ARE NOW HANDLED BY THE INSTRUCTION FOLLOWING THE DESTINATION DISPATCH
;QMDDN		;NEXT (ARG)
;QMDDS		;STACK

;;; DESTINATION NEXT-LIST

MISC-TO-LIST
	(CALL 0)				;CALL MISC FUNCTION, DROP INTO QMDDNL
QMDDNL	((VMA-START-READ) C-PDL-BUFFER-POINTER)	;PTR TO NEXT PLACE IN LIST
	(CHECK-PAGE-READ)
	(DISPATCH TRANSPORT-WRITE READ-MEMORY-DATA)
	((WRITE-MEMORY-DATA-START-WRITE)	;GET RANDOM BITS FROM PLACE STORING TO
	    SELECTIVE-DEPOSIT READ-MEMORY-DATA
		Q-ALL-BUT-TYPED-POINTER A-T)
	(CHECK-PAGE-WRITE)
	(GC-WRITE-TEST)
	(CALL-XCT-NEXT QCDR)
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;CDR TO NEXT PLACE IN LIST
	(DISPATCH Q-DATA-TYPE M-T SKIP-IF-ATOM)
	(POPJ-AFTER-NEXT			;NOT THROUGH WITH LIST
	 (C-PDL-BUFFER-POINTER-PUSH) M-T)
	(NO-OP)
	((M-C) DPB C-PDL-BUFFER-POINTER-POP	;THROUGH, GET ORIGINAL DESTINATION
		(LISP-BYTE %%LP-CLS-DESTINATION) A-ZERO)
	(JUMP-XCT-NEXT QIMOVE-EXIT)
       ((M-T) C-PDL-BUFFER-POINTER-POP)		;POINTER TO HEAD OF LIST

;;; DESTINATION LAST

MISC-TO-LAST
	(CALL 0)				;CALL MISC FUNCTION, DROP INTO QMDDL
QMDDL	((C-PDL-BUFFER-POINTER-PUSH) DPB M-T Q-ALL-BUT-CDR-CODE
		(A-CONSTANT (BYTE-VALUE Q-CDR-CODE CDR-NIL)))

;;;ACTIVATE PENDING CALL
QMRCL	((PDL-BUFFER-INDEX) SUB PDL-BUFFER-POINTER A-IPMARK)	;M-R PASSES ARG COUNT TO CALLED FCTN
	((M-R) PDL-BUFFER-INDEX)		;TRUNCATE RESULT TO BE POSITIVE
						;IN CASE FRAME WRAPPED AROUND PDL BUFFER.
	((PDL-BUFFER-INDEX M-S) A-IPMARK)	;GET FEF POINTER POINTER
	((M-A) C-PDL-BUFFER-INDEX)		;M-A := FUNCTION TO CALL
	(DISPATCH Q-DATA-TYPE M-A D-QMRCL)	;DISPATCH ON DATA TYPE
       (CALL QLLV)				;DOES LINEAR LEAVE IF NECC.

QMRCL-TRAP
	((VMA) A-V-NIL)
QMRCL-TRAP-1
;Many things that call this do so just before checking M-ERROR-SUBSTATUS, so save it.
	((M-A) M-ERROR-SUBSTATUS)
	(CALL TRAP)
    (ERROR-TABLE CALL-TRAP)
	((M-ERROR-SUBSTATUS) M-A)
	(POPJ)

))
