(SETQ UC-TRACK-MOUSE '(
;;; "Build a better mousetrap and the world will beat a path to your door"
;;;					-- Samuel F. B. Morse

XSET-MOUSE-SCREEN (MISC-INST-ENTRY %SET-MOUSE-SCREEN)
	(CALL SWAP-TV-AND-MOUSE-SCREENS)
	(CALL SELECT-SHEET-0)
		;drops through
SWAP-TV-AND-MOUSE-SCREENS
	((M-TEM) A-MOUSE-SCREEN-BUFFER-ADDRESS)
	((A-MOUSE-SCREEN-BUFFER-ADDRESS) A-TV-SCREEN-BUFFER-ADDRESS)
	((A-TV-SCREEN-BUFFER-ADDRESS) M-TEM)
	((M-TEM) A-MOUSE-SCREEN-BUFFER-END-ADDRESS)
	((A-MOUSE-SCREEN-BUFFER-END-ADDRESS) A-TV-SCREEN-BUFFER-END-ADDRESS)
	((A-TV-SCREEN-BUFFER-END-ADDRESS) M-TEM)
	((M-TEM) A-MOUSE-SCREEN-LOCATIONS-PER-LINE)
	((A-MOUSE-SCREEN-LOCATIONS-PER-LINE) A-TV-SCREEN-LOCATIONS-PER-LINE)
	((A-TV-SCREEN-LOCATIONS-PER-LINE) M-TEM)
	((M-TEM) A-MOUSE-SCREEN-BUFFER-BIT-OFFSET)
	((A-MOUSE-SCREEN-BUFFER-BIT-OFFSET) A-TV-SCREEN-BUFFER-BIT-OFFSET)
	((A-TV-SCREEN-BUFFER-BIT-OFFSET) M-TEM)
	((M-TEM) A-MOUSE-SCREEN-WIDTH)
	((A-MOUSE-SCREEN-WIDTH) A-TV-SCREEN-WIDTH)
	((A-TV-SCREEN-WIDTH) M-TEM)
	((M-TEM) A-MOUSE-SCREEN-BUFFER-PIXEL-SIZE-MROT)
	((A-MOUSE-SCREEN-BUFFER-PIXEL-SIZE-MROT) A-TV-SCREEN-BUFFER-PIXEL-SIZE-MROT)
	((A-TV-SCREEN-BUFFER-PIXEL-SIZE-MROT) M-TEM)
	((M-TEM) A-MOUSE-SCREEN)
	(POPJ-AFTER-NEXT (A-MOUSE-SCREEN) A-TV-CURRENT-SHEET)
       ((A-TV-CURRENT-SHEET) M-TEM)

SELECT-SHEET-0
	((M-C) Q-TYPED-POINTER C-PDL-BUFFER-POINTER-POP)
	((M-TEM) Q-DATA-TYPE M-C)
	(JUMP-NOT-EQUAL M-TEM (A-CONSTANT (EVAL DTP-INSTANCE)) SELECT-SHEET-ARRAY)
	(JUMP SELECT-SHEET-1)

;XOR the mouse cursor into the screen at its current position (except that if
;MOUSE-X, MOUSE-Y lie outside the MOUSE-SHEET, force the cursor to stay inside.)
;Due to the offset, the bits of the cursor can hang out in any direction.  We
;clip at the top and bottom, but let it wrap around at left and right for now.
;Uses M-1, M-2, M-A, M-B, M-E, M-T, Q-R, M-TEM only
XOR-MOUSE-CURSOR
	((M-A) A-MOUSE-CURSOR-X)
	((M-B) A-MOUSE-CURSOR-Y)
XOR-MOUSE-CURSOR-0
	;Confine reference position in M-A, M-B to within the sheet
	(JUMP-IF-BIT-CLEAR BOXED-SIGN-BIT M-A CONFINE-CURSOR-1)
	((M-A) A-ZERO)
CONFINE-CURSOR-1
	(JUMP-LESS-THAN M-A A-MOUSE-SCREEN-WIDTH CONFINE-CURSOR-2)
	((M-A) ADD (M-CONSTANT -1) A-MOUSE-SCREEN-WIDTH)
CONFINE-CURSOR-2
	(JUMP-IF-BIT-CLEAR BOXED-SIGN-BIT M-B CONFINE-CURSOR-3)
	((M-B) A-ZERO)
CONFINE-CURSOR-3
	;Don't bother at the bottom, since SELECT-SHEET didn't save the
	;right value and for most cursors the difference would be indistinguishable.

	;Convert (X,Y) address like TVXYADR
	((M-1) DPB M-B (BYTE-FIELD 20. 12.) A-ZERO)	;Y POSITION (LSH 12)
	(CALL-XCT-NEXT MPY12)
       ((Q-R) A-MOUSE-SCREEN-LOCATIONS-PER-LINE)	;M-2 GETS OFFSET TO START OF LINE
	((OA-REG-LOW) A-MOUSE-SCREEN-BUFFER-PIXEL-SIZE-MROT)
	;; X coordinate gets multiplied by pixel size
	((M-TEM) DPB M-A Q-POINTER A-ZERO)
	((M-TEM) ADD M-TEM A-MOUSE-SCREEN-BUFFER-BIT-OFFSET)
	((M-1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 5) 5) M-TEM)  ;WORD PART OF X POSITION
	((OA-REG-HIGH) (BYTE-FIELD 1 (DIFFERENCE Q-POINTER-WIDTH 5 1)) M-1)
	((M-1) SELECTIVE-DEPOSIT M-ZERO
	 (BYTE-FIELD (DIFFERENCE 32. (DIFFERENCE Q-POINTER-WIDTH 5))
		     (DIFFERENCE Q-POINTER-WIDTH 5))
	 A-1)
	((M-E) ADD M-2 A-1)				;RELATIVE WORD ADDRESS
	((M-E) ADD M-E A-MOUSE-SCREEN-BUFFER-ADDRESS)
	((M-T) (BYTE-FIELD 5 0) M-TEM)			;BIT PART OF X POSITION
	((M-E) Q-POINTER M-E)			;Truncate in case of ridiculous X,Y
	;M-E word address, M-T bit offset in that word
	;Now output one or two columns, depending on whether it crosses word boundary
	((M-B) ADD (M-CONSTANT -1) A-MOUSE-CURSOR-WIDTH)
	((M-B) (BYTE-FIELD 5 0) M-B)
	((M-TEM) M-A-1 (M-CONSTANT 40) A-T)
	(JUMP-LESS-OR-EQUAL M-B A-TEM XOR-MOUSE-CURSOR-3)
	;Do second column first
	((M-2) M-A-1 M-B A-TEM)			;Byte width-1 for second column
	((M-B) M-TEM)				;Byte width-1 for first column
	((M-TEM) M-A-1 (M-CONSTANT 40) A-B)
	((M-2) DPB M-2 OAL-BYTL-1 A-TEM)	;LDB pointer for second column
	((M-A) (A-CONSTANT MOUSE-CURSOR-PATTERN-AMEM-LOC))
	((M-1) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-CURSOR-HEIGHT)
	((VMA) SUB M-E A-MOUSE-SCREEN-LOCATIONS-PER-LINE)
	((VMA) ADD VMA (A-CONSTANT 1))
XOR-MOUSE-CURSOR-1
	((VMA-START-READ) ADD VMA A-MOUSE-SCREEN-LOCATIONS-PER-LINE)
	(JUMP-LESS-THAN VMA A-MOUSE-SCREEN-BUFFER-ADDRESS XOR-MOUSE-CURSOR-2)
	(JUMP-GREATER-OR-EQUAL VMA A-MOUSE-SCREEN-BUFFER-END-ADDRESS XOR-MOUSE-CURSOR-3)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((OA-REG-HIGH) DPB M-A OAH-A-SRC A-ZERO)
	((M-TEM) A-GARBAGE)
	((OA-REG-LOW) M-2)
	((M-TEM) (BYTE-FIELD 0 0) M-TEM)		;Cursor pattern aligned
	((WRITE-MEMORY-DATA-START-WRITE) XOR READ-MEMORY-DATA A-TEM)
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
XOR-MOUSE-CURSOR-2
	((M-A) ADD M-A (A-CONSTANT 1))
	(JUMP-GREATER-THAN-XCT-NEXT M-1 (A-CONSTANT 1) XOR-MOUSE-CURSOR-1)
       ((M-1) SUB M-1 (A-CONSTANT 1))
XOR-MOUSE-CURSOR-3
	;Now do first column
	((M-A) (A-CONSTANT MOUSE-CURSOR-PATTERN-AMEM-LOC))
	((M-1) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-CURSOR-HEIGHT)
	((VMA) SUB M-E A-MOUSE-SCREEN-LOCATIONS-PER-LINE)
XOR-MOUSE-CURSOR-4
	((VMA-START-READ) ADD VMA A-MOUSE-SCREEN-LOCATIONS-PER-LINE)
	(JUMP-LESS-THAN VMA A-MOUSE-SCREEN-BUFFER-ADDRESS XOR-MOUSE-CURSOR-5)
	(POPJ-GREATER-OR-EQUAL VMA A-MOUSE-SCREEN-BUFFER-END-ADDRESS)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((OA-REG-HIGH) DPB M-A OAH-A-SRC A-ZERO)
	((M-TEM) A-GARBAGE)
	((OA-REG-LOW) DPB M-B OAL-BYTL-1 A-T)
	((M-TEM) DPB M-TEM (BYTE-FIELD 0 0) A-ZERO)	;Cursor pattern aligned
	((WRITE-MEMORY-DATA-START-WRITE) XOR READ-MEMORY-DATA A-TEM)
	(CHECK-PAGE-WRITE-NO-INTERRUPT)
XOR-MOUSE-CURSOR-5
	((M-A) ADD M-A (A-CONSTANT 1))
	(JUMP-GREATER-THAN-XCT-NEXT M-1 (A-CONSTANT 1) XOR-MOUSE-CURSOR-4)
       ((M-1) SUB M-1 (A-CONSTANT 1))
	(POPJ)

XOPEN-MOUSE-CURSOR (MISC-INST-ENTRY %OPEN-MOUSE-CURSOR)
	((M-TEM) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-CURSOR-STATE)
	(CALL-EQUAL M-TEM (A-CONSTANT 3) XOR-MOUSE-CURSOR)
	(JUMP-XCT-NEXT XFALSE)
       ((A-MOUSE-CURSOR-STATE) (A-CONSTANT (PLUS (BYTE-VALUE Q-DATA-TYPE DTP-FIX) 1)))

;Here every 60th of a second
TRACK-MOUSE
	((M-TEM) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-CURSOR-STATE)
	(POPJ-EQUAL M-TEM A-ZERO)		;Disabled
	((VMA-START-READ) A-MOUSE-HARDWARE-ADDRESS)
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((A-MOUSE-SAVE-1) M-1)
	((A-MOUSE-SAVE-2) M-2)
	((A-MOUSE-SAVE-E) M-E)
	((M-A) READ-MEMORY-DATA)
	((VMA-START-READ) ADD VMA (A-CONSTANT 1))
	(CHECK-PAGE-READ-NO-INTERRUPT)
	((M-TEM) XOR M-A A-MOUSE-LAST-H1)	;Have buttons changed state?
	((M-TEM) (BYTE-FIELD 3 12.) M-TEM)
	(JUMP-EQUAL-XCT-NEXT M-TEM A-ZERO TRACK-MOUSE-1)
       ((M-B) READ-MEMORY-DATA)
	;Store new state of buttons into buttons buffer
	((A-MOUSE-WAKEUP) A-V-TRUE)
	((M-T) DPB M-ZERO (BYTE-FIELD 27. 5) A-MOUSE-BUTTONS-BUFFER-IN-INDEX)
	((M-T) ADD M-T (A-CONSTANT MOUSE-BUTTONS-BUFFER-AMEM-LOC))
	(CALL READ-MICROSECOND-CLOCK)		;M-2 gets clock
	((OA-REG-LOW M-TEM) DPB M-T OAL-A-DEST A-ZERO)
	((A-GARBAGE) BOXED-NUM-EXCEPT-SIGN-BIT M-2	;FIXNUM-MICROSECOND-TIME
			(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((OA-REG-LOW M-TEM) ADD M-TEM (A-CONSTANT (BYTE-VALUE OAL-A-DEST 1)))
	((A-GARBAGE) A-MOUSE-X)
	((OA-REG-LOW M-TEM) ADD M-TEM (A-CONSTANT (BYTE-VALUE OAL-A-DEST 1)))
	((A-GARBAGE) A-MOUSE-Y)
	((OA-REG-LOW M-TEM) ADD M-TEM (A-CONSTANT (BYTE-VALUE OAL-A-DEST 1)))
	((A-GARBAGE) (BYTE-FIELD 3 12.) M-A (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-T) ADD M-T (A-CONSTANT 4))
	((M-T) (BYTE-FIELD 5 0) M-T (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(JUMP-NOT-EQUAL-XCT-NEXT M-T A-MOUSE-BUTTONS-BUFFER-OUT-INDEX TRACK-MOUSE-1)
       ((A-MOUSE-BUTTONS-BUFFER-IN-INDEX) M-T)
	((M-T) ADD M-T (A-CONSTANT 4))		;Buffer full: discard oldest value
	((A-MOUSE-BUTTONS-BUFFER-OUT-INDEX) (BYTE-FIELD 5 0) M-T
			(A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
TRACK-MOUSE-1
	;Compute physical delta-X (in M-B) and delta-Y (in M-A)
	((M-A) SUB M-A A-MOUSE-LAST-H1)
	((A-MOUSE-LAST-H1) ADD M-A A-MOUSE-LAST-H1)
	((OA-REG-HIGH) (BYTE-FIELD 1 11.) M-A)
	((M-A) DPB M-ZERO (BYTE-FIELD 21. 11.) A-A)
	((M-B) SUB M-B A-MOUSE-LAST-H2)
	((A-MOUSE-LAST-H2) ADD M-B A-MOUSE-LAST-H2)
	((OA-REG-HIGH) (BYTE-FIELD 1 11.) M-B)
	((M-B) DPB M-ZERO (BYTE-FIELD 21. 11.) A-B)
	;Compute physical speed, which involves time averaging
	((M-TEM) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-Y-SPEED)
	(JUMP-EQUAL M-TEM A-ZERO TRACK-MOUSE-1C)
	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 4) 4) M-TEM)
	((M-TEM) M-A-1 M-TEM A-TEM1)		;Speed times 15/16 or less
TRACK-MOUSE-1C
	(JUMP-GREATER-OR-EQUAL-XCT-NEXT M-A A-ZERO TRACK-MOUSE-1A)
       ((A-TEM1) DPB M-A (BYTE-FIELD 30. 2) A-ZERO)	;delta-Y times 4
	((A-TEM1) SUB M-ZERO A-TEM1)		;sum((15/16)^i,i,0,inf)=16
TRACK-MOUSE-1A
	((M-TEM) ADD M-TEM A-TEM1)		;New speed
	((A-MOUSE-Y-SPEED) Q-POINTER M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	((M-TEM) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-X-SPEED)
	(JUMP-EQUAL M-TEM A-ZERO TRACK-MOUSE-1D)
	((A-TEM1) (BYTE-FIELD (DIFFERENCE Q-POINTER-WIDTH 4) 4) M-TEM)
	((M-TEM) M-A-1 M-TEM A-TEM1)		;Speed times 15/16 or less
TRACK-MOUSE-1D
	(JUMP-GREATER-OR-EQUAL-XCT-NEXT M-B A-ZERO TRACK-MOUSE-1B)
       ((A-TEM1) DPB M-B (BYTE-FIELD 30. 2) A-ZERO)	;delta-X times 4
	((A-TEM1) SUB M-ZERO A-TEM1)
TRACK-MOUSE-1B
	((M-TEM) ADD M-TEM A-TEM1)		;New speed
	((A-MOUSE-X-SPEED) Q-POINTER M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	;Speed bum if mouse hasn't moved
	((M-TEM) IOR M-A A-B)
	(JUMP-EQUAL M-TEM A-ZERO TRACK-MOUSE-NO-MOTION)
	;Do speed-dependent scaling into logical delta-X, delta-Y, and update position
	((M-1) (A-CONSTANT MOUSE-Y-SCALE-ARRAY-AMEM-LOC))
	((M-2) ADD M-1 (A-CONSTANT 12.))
TRACK-MOUSE-YSC-LOOP
	((OA-REG-HI) DPB M-1 OAH-A-SRC A-ZERO)
	((M-TEM) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-GARBAGE)
	(JUMP-GREATER-THAN M-TEM A-MOUSE-Y-SPEED TRACK-MOUSE-YSC)
	(JUMP-LESS-THAN-XCT-NEXT M-1 A-2 TRACK-MOUSE-YSC-LOOP)
       ((M-1) ADD M-1 (A-CONSTANT 2))
TRACK-MOUSE-YSC
	((OA-REG-HI) DPB M-1 OAH-A-SRC A-ZERO)
	((M-1) A-PGF-TEM)			;A-PGF-TEM = 1@A
	((OA-REG-HIGH) BOXED-SIGN-BIT M-1)
	((M-1) DPB M-ZERO Q-ALL-BUT-POINTER A-1)
	(CALL-XCT-NEXT MPY)
       ((Q-R) M-A)
	((M-TEM) ADD Q-R A-MOUSE-Y-FRACTION)	;Delta-Y times 1024
	((A-MOUSE-Y-FRACTION) (BYTE-FIELD 10. 0) M-TEM)
	((M-TEM) (BYTE-FIELD 22. 10.) M-TEM A-TEM)
	((A-MOUSE-INTERNAL-Y) ADD M-TEM A-MOUSE-INTERNAL-Y)
	;Note that we do not clip the mouse position at this level; the macrocode
	;will handle that by warping the cursor back into the valid region
	((M-1) (A-CONSTANT MOUSE-X-SCALE-ARRAY-AMEM-LOC))
	((M-2) ADD M-1 (A-CONSTANT 12.))
TRACK-MOUSE-XSC-LOOP
	((OA-REG-HI) DPB M-1 OAH-A-SRC A-ZERO)
	((M-TEM) DPB M-ZERO Q-ALL-BUT-TYPED-POINTER A-GARBAGE)
	(JUMP-GREATER-THAN M-TEM A-MOUSE-X-SPEED TRACK-MOUSE-XSC)
	(JUMP-LESS-THAN-XCT-NEXT M-1 A-2 TRACK-MOUSE-XSC-LOOP)
       ((M-1) ADD M-1 (A-CONSTANT 2))
TRACK-MOUSE-XSC
	((OA-REG-HI) DPB M-1 OAH-A-SRC A-ZERO)
	((M-1) A-PGF-TEM)			;A-PGF-TEM = 1@A
	((OA-REG-HIGH) BOXED-SIGN-BIT M-1)
	((M-1) DPB M-ZERO Q-ALL-BUT-POINTER A-1)
	(CALL-XCT-NEXT MPY)
       ((Q-R) M-B)
	((M-TEM) ADD Q-R A-MOUSE-X-FRACTION)	;Delta-X times 1024
	((A-MOUSE-X-FRACTION) (BYTE-FIELD 10. 0) M-TEM)
	((M-TEM) (BYTE-FIELD 22. 10.) M-TEM A-TEM)
	((A-MOUSE-INTERNAL-X) ADD M-TEM A-MOUSE-INTERNAL-X)
TRACK-MOUSE-NO-MOTION
;Now that we have moved the "internal" mouse location,
;move the external one too, with a pixel of hysteresis.

;Now see if the X position has changed enough to warrant waking up the mouse process
;and redrawing the cursor.  We lag a little so that small changes of position
;of less than a pixel away from the edge of the pixel the mouse is at
;do not get seen at a higher level.  They are not forgotten; motion of the
;internal mouse coordinates accumulates till it gets big enough to report.
	((M-A) A-MOUSE-INTERNAL-X)
	(JUMP-EQUAL M-A A-MOUSE-PREVIOUS-INTERNAL-X TRACK-MOUSE-X-OK)
	((M-1) SUB M-A A-MOUSE-PREVIOUS-INTERNAL-X)
	(JUMP-EQUAL M-1 A-MINUS-ONE TRACK-MOUSE-X-OK)
	(JUMP-EQUAL M-1 (A-CONSTANT 1) TRACK-MOUSE-X-OK)
;When the internal coordinate moves "enough", move the external one and wake up mouse process.
	((A-MOUSE-WAKEUP) A-V-TRUE)
	((A-MOUSE-PREVIOUS-INTERNAL-X) ADD M-1 A-MOUSE-PREVIOUS-INTERNAL-X)
	((M-TEM) ADD M-1 A-MOUSE-X)
	((A-MOUSE-X) Q-POINTER M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
TRACK-MOUSE-X-OK
;Do the same thing for Y.
	((M-A) A-MOUSE-INTERNAL-Y)
	(JUMP-EQUAL M-A A-MOUSE-PREVIOUS-INTERNAL-Y TRACK-MOUSE-Y-OK)
	((M-1) SUB M-A A-MOUSE-PREVIOUS-INTERNAL-Y)
	(JUMP-EQUAL M-1 A-MINUS-ONE TRACK-MOUSE-Y-OK)
	(JUMP-EQUAL M-1 (A-CONSTANT 1) TRACK-MOUSE-Y-OK)
;When the internal coordinate moves "enough", move the external one and wake up mouse process.
	((A-MOUSE-WAKEUP) A-V-TRUE)
	((A-MOUSE-PREVIOUS-INTERNAL-Y) ADD M-1 A-MOUSE-PREVIOUS-INTERNAL-Y)
	((M-TEM) ADD M-1 A-MOUSE-Y)
	((A-MOUSE-Y) Q-POINTER M-TEM (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
TRACK-MOUSE-Y-OK

;Now see if the cursor needs attention.  If it is off, turn it on.  If it
;is on but in the wrong place, turn it off, move it, turn it on.
	((M-T) DPB M-ZERO Q-ALL-BUT-POINTER A-MOUSE-CURSOR-STATE)
	(JUMP-LESS-THAN M-T (A-CONSTANT 2) TRACK-MOUSE-9)	;Cursor is open
	((M-A) A-MOUSE-CURSOR-X)
	((M-1) A-MOUSE-X)			;Compute where cursor should be
	((M-1) SUB M-1 A-MOUSE-CURSOR-X-OFFSET)
	((A-MOUSE-CURSOR-X) Q-POINTER M-1)
	((M-B) A-MOUSE-CURSOR-Y)
	((M-2) A-MOUSE-Y)
	((M-2) SUB M-2 A-MOUSE-CURSOR-Y-OFFSET)
	((A-MOUSE-CURSOR-Y) Q-POINTER M-2)
	((A-MOUSE-CURSOR-STATE) DPB (M-CONSTANT -1)	;Set it to 3 (on)
		(BYTE-FIELD 2 0) (A-CONSTANT (BYTE-VALUE Q-DATA-TYPE DTP-FIX)))
	(JUMP-NOT-EQUAL M-T (A-CONSTANT 3) TRACK-MOUSE-8)
	(JUMP-NOT-EQUAL M-A A-MOUSE-CURSOR-X TRACK-MOUSE-7)
	(JUMP-EQUAL M-B A-MOUSE-CURSOR-Y TRACK-MOUSE-9)
TRACK-MOUSE-7
	(CALL XOR-MOUSE-CURSOR-0)		;Undraw old cursor
TRACK-MOUSE-8
	(CALL XOR-MOUSE-CURSOR)			;Draw new cursor
TRACK-MOUSE-9
	((M-1) A-MOUSE-SAVE-1)
	(POPJ-AFTER-NEXT (M-2) A-MOUSE-SAVE-2)
       ((M-E) A-MOUSE-SAVE-E)
))