;;; (c) Copyright 1985, Lisp Machine Incorporated.

(defconstant uc-scavenger '(

(locality a-mem)
a-scavenge-region (0)
a-scavenge-region-origin (0)
a-scavenge-region-free-pointer (0)
a-scavenge-object (0)
a-scavenge-next-object (0)
a-scavenge-object-bound (0)
a-scavenge-block-bound (0)
a-scavenge-work (0)
a-scavenge-volatility (0)
a-scavenge-state (0)
a-scavenge-block-return-pc (0)
a-scavenger-start-time (0)
a-scavenger-start-disk-time (0)
a-scavenger-transporter-start-time (0)
a-scavenger-transporter-start-disk-time (0)
(locality i-mem)

     (misc-inst-entry %gc-scav-reset)
reset-scavenger
        ((m-k) q-pointer pdl-pop)
        (jump-not-equal m-k a-scavenge-region xfalse)
        (jump-equal m-k a-zero xfalse)
        (call invalidate-cons-caches)
     ;; Set scavenge pointer back to object boundary.
        (call-xct-next store-region-gc-pointer)
       ((m-1) a-scavenge-object)
        ((a-scavenge-state) m-zero)
     ;; Check to see if we're beyond free pointer.
        ((vma-start-read) add m-k a-v-region-free-pointer)
        (check-page-read)
        ((m-1) output-selector-mask-25 add md a-scavenge-region-origin)
     ;; If we're still below the free pointer, don't worry about it.
        (jump-greater-or-equal m-1 a-scavenge-next-object xfalse)
     ;; Past free pointer, set scavenge-pointer = free-pointer and reset scavenger.
        (call-return store-region-gc-pointer xtrue)

     (misc-inst-entry %gc-scavenge)
scavenge
        (call-xct-next scavenge-while-consing)
       ((a-scavenge-work) q-pointer pdl-pop)
        (jump xfalse)

scavenge-while-consing
     ;; Extra-PDL trap depends on this test to inhibit scavenge during cons.
        (popj-if-bit-set m-transport-flag)
        ((m-tem) dpb m-zero q-all-but-typed-pointer a-gc-flip-ready)
        (popj-not-equal m-tem a-v-nil)
        ((m-tem) dpb m-zero q-all-but-typed-pointer a-inhibit-scavenging-flag)
        (popj-not-equal m-tem a-v-nil)
     ;; Many Lisp functions expect WITHOUT-INTERRUPTS to inhibit scavenging, also.
        ((m-tem) dpb m-zero q-all-but-typed-pointer a-inhibit-scheduling-flag)
        (popj-not-equal m-tem a-v-nil)
        (call scavenge-save)
        (jump-equal-xct-next m-zero a-scavenge-state scavenge-regions)
       ((a-scavenge-volatility) dpb m-zero (byte 36 2) a-gc-switches)
resume-scavenge
        (call load-region-scavenge-parameters)
        ((q-r) a-scavenge-state)
        (jump-equal-xct-next q-r (a-constant 2) scavenge-block)
       ((micro-stack-data-push) a-scavenge-block-return-pc)
     ;; Scavenging a PDL (carefully).  Scavenge limit may have changed since last invocation.
        (call-xct-next structure-info)
       ((m-t) a-scavenge-object)
        (jump-xct-next scavenge-block)
       ((a-scavenge-block-bound) add m-3 a-scavenge-object)

(begin-comment) Zwei Lossage (end-comment)

scavenge-next-region
        (call-xct-next store-region-gc-pointer)
       ((m-1) a-scavenge-region-free-pointer)
scavenge-regions
        ((a-scavenge-region) (a-constant 400))
scavenge-regions-loop
        ((a-scavenge-region q-r) add m-minus-one a-scavenge-region)
        (jump-less-or-equal q-r a-zero finish-scavenge)
        ((vma-start-read) add q-r a-v-region-bits)
        (illop-if-page-fault)
        (jump-if-bit-clear (lisp-byte %%region-scavenge-enable) md scavenge-regions-loop)
        (call-xct-next load-region-scavenge-parameters)
       ((pdl-push) md)
        (jump-if-bit-set-xct-next (lisp-byte %%region-scavenge-carefully) pdl-pop scavenge-region-carefully)
       (jump-greater-or-equal m-1 a-scavenge-region-free-pointer scavenge-regions-loop)

scavenge-next-page
     ;; Run scavenge-queue, spending scavenge units.  Doing it this often helps locality.
        (call-not-equal-xct-next m-minus-one a-scavenge-queue-pointer run-scavenge-queue)
       ((a-scavenge-queue-work) a-scavenge-work)
        ((a-scavenge-work) a-scavenge-queue-work)
        (call-greater-or-equal m-1 a-scavenge-region-free-pointer scavenge-check-region-free-pointer)
        (jump-not-equal-xct-next m-zero a-scavenge-volatility scavenge-page-loop)
       ((m-1) dpb m-zero (byte 10 0) a-1)
     ;; Scavenging level 0, don't bother searching for worthwhile pages.  (Code below depends on this.)
        (jump scavenge-page)

scavenge-skip-sector
        ((m-1) add m-1 (a-constant (eval (* 20 400))))
        ((m-1) dpb m-zero (byte 14 0) a-1)
scavenge-page-loop
        (call-greater-or-equal m-1 a-scavenge-region-free-pointer scavenge-check-region-free-pointer)
	((m-tem1) (byte (difference q-pointer-width 14) 14) m-1)
	((vma-start-read) add m-tem1 a-v-virtual-page-volatility)
	(illop-if-page-fault)
        ((m-lam) q-page-number m-1)
	((m-tem3) dpb m-lam (byte 4 1) a-zero)
        (jump-equal md a-zero scavenge-skip-sector)
        ((m-tem3) sub (m-constant 40) a-tem3)
        ((oa-reg-low) oal-mrot m-tem3)
        ((m-tem) (byte 2 0) md)
        (jump-less-than-xct-next m-tem a-scavenge-volatility scavenge-page-loop)
       ((m-1) add m-1 (a-constant 400))
        ((m-1) sub m-1 (a-constant 400))		   ;Undo superfluous add.

scavenge-page
     ;; Make sure we have the latest and greatest free-pointer for comparisons.
        (call-xct-next load-scavenge-region-free-pointer)
       ((m-k) a-scavenge-region)
     ;; Set volatility of this page down to zero.
        (call-xct-next update-page-volatility-for-scavenger)
       ((a-page-volatility) m-zero)
        (call-xct-next read-structure-handle)
       ((m-3) q-page-number m-1)
        ((a-scavenge-object) m-1)			   ;Compatability with careful code.
        ((a-scavenge-object-bound) add m-1 a-6)		   ;Initial-Qs.
        ((a-scavenge-next-object) add m-1 a-5)		   ;First-Object.
        ((a-scavenge-block-bound q-r) add m-1 (a-constant 400))
        ((a-scavenge-state) (a-constant 2))
        (jump-less-or-equal-xct-next q-r a-scavenge-region-free-pointer scavenge-block)
       ((micro-stack-data-push) (a-constant (i-mem-loc scavenge-next-page)))
        (jump-xct-next scavenge-block)
       ((a-scavenge-block-bound) a-scavenge-region-free-pointer)

;;; Careful scavenging.

scavenge-region-carefully
scavenge-carefully-page-loop
        (call-greater-or-equal m-1 a-scavenge-region-free-pointer scavenge-check-region-free-pointer)
        (call-xct-next read-page-volatility)
       ((m-lam) q-page-number m-1)
        (jump-less-than-xct-next m-tem a-scavenge-volatility scavenge-carefully-page-loop)
       ((m-1) add m-1 (a-constant 400))
        ((m-1) sub m-1 (a-constant 400))		   ;Undo superfluous add.

scavenge-carefully-find-header
     ;; M-1 is at the first word of a volatile page.  Go find the first page containing this
     ;; structure, set the volatilities of all the pages in the object to zero, then scavenge it.
        (call-xct-next read-structure-handle)
       ((m-3) q-page-number m-1)
     ;; If <first-header> (M-5) = 0, structure starts on this page.
        (jump-not-equal-xct-next m-5 a-zero scavenge-carefully-find-header)
       ((m-1) sub m-1 (a-constant 400))
        ((m-1) add m-1 (a-constant 400))		   ;Undo superfluous subtract.

     ;; M-1 points to the header of a structure that contains volatile pointers.
        (call-xct-next structure-info)
       ((m-t) q-pointer m-1)
        ((a-scavenge-object) q-pointer m-1)
        ((a-scavenge-block-bound) add m-1 a-3)
        ((a-scavenge-next-object) add a-scavenge-block-bound m-4)

     ;; Set volatility of every page in the object (Note: including unboxed words) to zero.
scavenge-carefully-update-volatilities
        (jump-greater-or-equal m-1 a-scavenge-next-object scavenge-object-carefully)
        (call-xct-next update-page-volatility-for-scavenger)
       ((a-page-volatility) m-zero)
        (jump-xct-next scavenge-carefully-update-volatilities)
       ((m-1) add m-1 (a-constant 400))

scavenge-object-carefully
        ((a-scavenge-state) (a-constant 3))
        ((a-scavenge-object-bound) m-zero)
        (call-xct-next scavenge-block)
       ((m-1) a-scavenge-object)
        (jump-xct-next scavenge-region-carefully)
       ((m-1) a-scavenge-next-object)

;;; Scavenge block.

scavenge-block-next-object
        ((m-1) a-scavenge-next-object)
        ((a-scavenge-object-bound) m-zero)
scavenge-block
scavenge-block-loop
     ;; It's important to test for block boundary before object boundary.  Also, note
     ;; that skipping over unboxed words can take M-1 past block boundary, so test for
     ;; greater-or-equal.
        (popj-greater-or-equal m-1 a-scavenge-block-bound)
        (jump-equal m-1 a-scavenge-object-bound scavenge-block-next-object)
       	((vma-start-read) m-1)
        (check-page-read)
        ((a-scavenge-work) add m-minus-one a-scavenge-work)
        (dispatch q-data-type d-scavenge-word md)
       ((m-1) add m-1 (a-constant 1))
        (dispatch transport-scav md)
        ((vma-start-write) vma)
        (check-page-write-force)
        (jump-less-than-xct-next m-zero a-scavenge-work scavenge-block-loop)
       (gc-write-test-volatility)
     ;; Completed scavenge work quantum -- suspend scavenge-block in a resumable way.
        (jump-xct-next suspend-scavenge)
       ((a-scavenge-block-return-pc) micro-stack-data-pop)

scavenge-block-header
     ;; First check for %header-type-list, which should be skipped quickly.
        ((m-tem) (lisp-byte %%header-type-field) md)
        (popj-equal m-tem (a-constant (eval %header-type-list)))
scavenge-block-array-header
        (call-xct-next structure-info)
       ((m-t) q-pointer m-1)
     ;; Restart reference, since VMA/MD probably lost in STRUCTURE-INFO.
        ((vma-start-read) m-1)
        (check-page-read)
     ;; If there are no unboxed words, can go until block bound or until next header.
        (popj-equal m-4 a-zero)
        (popj-after-next
          (a-scavenge-object-bound q-r) add m-1 a-3)
       ((a-scavenge-next-object) add q-r a-4)
        
(locality d-mem)
(start-dispatch 5 0)
d-scavenge-word
	(scavenge-block-loop)			       ;trap (immediate) (allowed in PDLs and SGs)
	(p-bit r-bit)				       ;null
	(p-bit n-bit illop)			       ;free
	(p-bit r-bit)				       ;symbol
	(p-bit r-bit)				       ;symbol-header (all boxed)
	(scavenge-block-loop)			       ;fix (immediate)
	(p-bit r-bit)				       ;extended-number
	(p-bit n-bit scavenge-block-header)	       ;header
	(p-bit r-bit)				       ;gc-forward
	(p-bit r-bit)				       ;external-value-cell-pointer
	(p-bit r-bit)				       ;one-q-forward
	(p-bit r-bit)				       ;header-forward
	(p-bit r-bit)				       ;body-forward
	(p-bit r-bit)				       ;locative
	(p-bit r-bit)				       ;list
	(scavenge-block-loop)			       ;u code entry (immediate)
	(p-bit r-bit)				       ;fef
	(p-bit r-bit)				       ;array-pointer
	(p-bit n-bit scavenge-block-array-header)      ;array-header
	(p-bit r-bit)				       ;stack-group
	(p-bit r-bit)				       ;closure
	(scavenge-block-loop)			       ;small-flonum (immediate)
	(p-bit r-bit)				       ;select-method
	(p-bit r-bit)				       ;instance
	(p-bit r-bit)				       ;instance-header (all boxed)
	(p-bit r-bit)				       ;entity
	(p-bit r-bit)				       ;stack-closure
	(scavenge-block-loop)			       ;self-ref-pointer (immediate)
	(scavenge-block-loop)			       ;character (immediate)
        (p-bit r-bit)				       ;rplacd-forward
        (p-bit n-bit illop)			       ;36
        (scavenge-block-loop)			       ;trap (immediate) (allowed in PDLs and SGs)
(end-dispatch)
(locality i-mem)

;;;

finish-scavenge
        (jump-not-equal m-minus-one a-scavenge-queue-pointer finish-scavenge-not-quite-done)
        ((a-scavenge-state) m-zero)
        (jump-xct-next scavenge-restore)
       ((a-gc-flip-ready) a-v-true)

finish-scavenge-not-quite-done
     ;; All regions seem scavenged, but there are still objects on the scavenge queue.
     ;; Run the queue to completion (won't take long), then loop through all the regions
     ;; again, just to make sure.
        (call-not-equal-xct-next m-minus-one a-scavenge-queue-pointer run-scavenge-queue)
       ((a-scavenge-queue-work) dpb m-minus-one q-pointer a-zero)
        (jump scavenge-regions)

;;;

(begin-comment) Zwei Lossage (end-comment)

load-region-scavenge-parameters
        ((m-k) a-scavenge-region)
        ((vma-start-read) add m-k a-v-region-origin)
        (illop-if-page-fault)
        ((a-scavenge-region-origin) q-pointer md)
        ((vma-start-read) add m-k a-v-region-gc-pointer)
        (check-page-read)
        ((m-1) output-selector-mask-25 add md a-scavenge-region-origin)
load-scavenge-region-free-pointer
        (popj-equal-xct-next m-k a-copy-cons-cache-region)
       ((a-scavenge-region-free-pointer) dpb m-zero q-all-but-pointer a-copy-cons-cache-free-pointer)
        (popj-equal-xct-next m-k a-active-cons-cache-region)
       ((a-scavenge-region-free-pointer) dpb m-zero q-all-but-pointer a-active-cons-cache-free-pointer)
        ((vma-start-read) add m-k a-v-region-free-pointer)
        (popj-after-next illop-if-page-fault)		   ;Technically cheating, but...
       ((a-scavenge-region-free-pointer) output-selector-mask-25 add md a-scavenge-region-origin)

;;; This is an interesting hack.  During all the various loops in the scavenger, we're continually
;;; checking M-1 (the scavenge pointer) against a-scavenge-region-free-pointer to see if we're done.
;;; Since there is often consing going on in regions (particularly copy regions!) as we scavenge
;;; them, the region-free-pointer is moving, but we don't notice it cause we only set up
;;; a-scavenge-region-free-pointer at the beginning.  This can cause the scavenger to move on to other
;;; regions before truly finishing one, which is OK since we will come back to it, but it is slow.
;;; To remedy this, test for the end of a region with:
;;;    (call-greater-or-equal m-1 a-scavenge-region-free-pointer scavenge-check-region-free-pointer)
;;; which will update a-scavenge-region-free-pointer based on the latest information.  The interesting
;;; part is that it only returns to the caller if there are more words to be scavenged in this region.
;;; Otherwise, it jumps to SCAVENGE-NEXT-REGION, fixing up the microstack appropriately.  Nifty, eh?

scavenge-check-region-free-pointer
        (call-xct-next load-scavenge-region-free-pointer)
       ((m-k) a-scavenge-region)
        (popj-less-than m-1 a-scavenge-region-free-pointer)
        (jump-xct-next scavenge-next-region)
       ((m-garbage) micro-stack-data-pop)

store-region-gc-pointer
        ((vma) a-scavenge-region)
        ((vma) add vma a-v-region-gc-pointer)
        ((md) q-pointer m-1 (a-constant (byte-value q-data-type dtp-fix)))
        (popj-after-next
          (md-start-write) sub md a-scavenge-region-origin)
       (check-page-write-no-interrupt)

;;; Perfunctory measurements indicate that this is a significant loss, probably due to
;;; the inefficiency of SEARCH-PAGE-HASH-TABLE.
;scavenge-flush-page
;     ;; Don't do it if page could be in fixed area.
;        ((m-tem) dpb m-zero q-all-but-pointer a-v-first-unfixed-area)
;        (popj-less-than m-1 a-t)
;        (call search-page-hash-table)
;     ;; Don't do it if page has no valid PHT entry.
;	(popj-if-bit-clear pht1-valid-bit md)
;     ;; Only age normal pages.  In particular, don't age wired or flushed pages.
;        ((m-tem) pht1-swap-status-code md)
;        (popj-not-equal m-tem (a-constant (eval %pht-swap-status-normal)))
;        ((md-start-write) selective-deposit md pht1-all-but-age-and-swap-status-code
;	                  (a-constant (eval %pht-swap-status-age-trap)))
;        (illop-if-page-fault)
;        (popj-after-next)
;	((#+lambda l2-map-control
;	  #+exp vma-write-l2-map-control) (a-constant 0))  ;Flush level-2 map.

(locality a-mem)
a-scavenge-save-a (0)
a-scavenge-save-b (0)
a-scavenge-save-k (0)
a-scavenge-save-t (0)
a-scavenge-save-1 (0)
a-scavenge-save-2 (0)
a-scavenge-save-3 (0)
a-scavenge-save-4 (0)
a-scavenge-save-5 (0)
a-scavenge-save-6 (0)
(locality i-mem)

scavenge-save
#-lambda(begin-comment)
        ((a-scavenger-start-time) stat-counter-aux)
        ((a-scavenger-start-disk-time) a-disk-wait-time)
        ((a-scavenger-transporter-start-time) a-transporter-time)
        ((a-scavenger-transporter-start-disk-time) a-transporter-disk-time)
#-lambda(end-comment)
        (call-xct-next turn-on-scavenger-run-light)
       ((m-scavenge-flag) dpb m-minus-one a-flags)
        ((a-scavenge-save-a) m-a)
        ((a-scavenge-save-b) m-b)
        ((a-scavenge-save-k) m-k)
        ((a-scavenge-save-t) m-t)
        ((a-scavenge-save-1) m-1)
        ((a-scavenge-save-2) m-2)
        ((a-scavenge-save-3) m-3)
        ((a-scavenge-save-4) m-4)
        (popj-after-next
          (a-scavenge-save-5) m-5)
       ((a-scavenge-save-6) m-6)

suspend-scavenge
        (call store-region-gc-pointer)
scavenge-restore
#-lambda(begin-comment)
        ((m-tem) sub stat-counter-aux a-scavenger-start-time)
        ((a-scavenger-time) add m-tem a-scavenger-time)
        ((m-tem) a-disk-wait-time)
        ((m-tem) sub m-tem a-scavenger-start-disk-time)
        ((a-scavenger-disk-time) add m-tem a-scavenger-disk-time)
        ((m-tem) a-transporter-time)
        ((m-tem) sub m-tem a-scavenger-transporter-start-time)
        ((a-scavenger-transporter-time) add m-tem a-scavenger-transporter-time)
        ((m-tem) a-transporter-disk-time)
        ((m-tem) sub m-tem a-scavenger-transporter-start-disk-time)
        ((a-scavenger-transporter-disk-time) add m-tem a-scavenger-transporter-disk-time)
#-lambda(end-comment)
        ((m-scavenge-flag) dpb m-zero a-flags)
        (call turn-off-scavenger-run-light)
        ((m-a) a-scavenge-save-a)
        ((m-b) a-scavenge-save-b)
        ((m-k) a-scavenge-save-k)
        ((m-t) a-scavenge-save-t)
        ((m-1) a-scavenge-save-1)
        ((m-2) a-scavenge-save-2)
        ((m-3) a-scavenge-save-3)
        ((m-4) a-scavenge-save-4)
        (popj-after-next
          (m-5) a-scavenge-save-5)
       ((m-6) a-scavenge-save-6)

turn-on-scavenger-run-light
        ((vma) a-disk-run-light)
        ((vma-start-read) sub vma (a-constant 2))
        (check-page-read-map-reload-only)
        ((m-tem) md)
        (popj-after-next
          (md-start-write) dpb m-minus-one (byte 20 0) a-tem)
       (check-page-write-map-reload-only)

turn-off-scavenger-run-light
        ((vma) a-disk-run-light)
        ((md) m-zero)
        (popj-after-next
          (vma-start-write) sub vma (a-constant 2))
       (check-page-write-map-reload-only)

(begin-comment) Zwei Lossage (end-comment)

;;; Scavenge queue.

;;; The scavenge queue is a small (1024 word) area of memory managed in a stack-like fashion
;;; to do approximately depth-first copying of objects in the transporter (and thus the
;;; scavenger).  Each entry on the queue is one word, consisting of a 25-bit address and a
;;; 7-bit word count.  The address is the address of the next word to be scavenged, the count
;;; is the remaining words in the entry.  When every word is looked at, the entry on the queue
;;; is updated (looking at a word can cause more objects to appear on the queue, so this whole
;;; process must be very reentrant) by incrementing the address and decrementing the word
;;; count.  When the count for an object gets to zero, the object is popped off the queue, and
;;; then that word is looked at (sort of tail-recursively).

;;; Yes, this code is pretty simple.  However, there are some non-trivial interactions with
;;; TRANS-OLD-COPY that you have to be careful about.

(locality a-mem)
a-scavenge-queue-pointer (-1)  ;Points to current entry.  Pushing on the queue pre-increments.
a-scavenge-queue-active (0)    ;Communication with transporter.
a-scavenge-queue-work (0)      ;Number of units remaining in this invocation.
(locality i-mem)

;;; Called at the end of TRANS-OLD-COPY to put the copied object on the scavenge-queue and
;;; to do some scavenge-queue work.  This can use no accumulators.
transport-run-scavenge-queue
        ((m-tem) a-transport-boxed-size)
        ((md) dpb m-tem (byte 6 31) a-transport-new-object-base)       ;Put count into high bits.
        ((m-tem) m+a+1 m-zero a-scavenge-queue-pointer)		       ;Compute new pointer.
        (popj-greater-or-equal m-tem a-scavenge-queue-maximum-depth)   ;Queue full, punt.
        ((a-scavenge-queue-pointer) m-tem)			       ;Save new pointer.
        ((vma-start-write) add m-tem a-v-scavenge-queue)	       ;Save entry.
        (check-page-write)
        (popj-not-equal m-zero a-scavenge-queue-active)		       ;Not reentrant from here on.
        ((pdl-push) a-transport-new-object)			       ;Save these for restarting trap.
        ((pdl-push) a-trans-vma)
        (call-xct-next run-scavenge-queue)
       ((a-scavenge-queue-work) a-transporter-scavenge-queue-work-quantum)
        (popj-after-next
          (a-trans-vma) pdl-pop)
       ((a-transport-new-object) pdl-pop)

;;; Set A-SCAVENGE-COUNT to the maximum number of words to look at before calling this.  When
;;; this returns, it will either be zero (there may still be entries on the queue) or the
;;; initial value minus the number of words scanned (the queue was exhausted).
run-scavenge-queue
        ((a-scavenge-queue-active) (a-constant 1))
scavenge-queue-loop
        ((m-tem) a-scavenge-queue-pointer)
        (jump-less-than m-tem a-zero scavenge-queue-exit)      ;Queue empty, punt.
        ((vma-start-read) add m-tem a-v-scavenge-queue)
        (check-page-read)
        ((m-tem1) q-all-but-pointer md)		               ;Word count for this object.
        (jump-less-or-equal-xct-next m-tem1 (a-constant 1) pop-scavenge-queue)
       ((pdl-push) q-pointer md)		               ;Location to be checked, popped below.
        ((m-tem1) sub m-tem1 (a-constant 1))
        ((m-tem) output-selector-mask-25 add md (a-constant 1))
        ((md-start-write) dpb m-tem1 q-all-but-pointer a-tem)  ;Update queue before transport.
        (check-page-write)
scavenge-queue-transport
       	((vma-start-read) pdl-pop)
        (check-page-read)
        ((a-scavenge-queue-work) add m-minus-one a-scavenge-queue-work)
        (dispatch transport-scav md)		               ;This might push another object.
        ((vma-start-write) vma)
        (check-page-write)
        (jump-less-or-equal-xct-next m-zero a-scavenge-queue-work scavenge-queue-loop)
       (gc-write-test-volatility)

     ;; Fall through when scavenge-queue work gets to zero.
scavenge-queue-exit
        (popj-after-next)
       ((a-scavenge-queue-active) m-zero)

pop-scavenge-queue
        (jump-xct-next scavenge-queue-transport)
       ((a-scavenge-queue-pointer) add m-minus-one a-scavenge-queue-pointer)

))
