/* Meroko - Explorer 1 hardware-level emulator 

 This file is subject to the terms and conditions of the GNU General Public
 License.  See the file COPYING in the main directory of this archive for
 more details.

*/



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <ncurses.h>
#include <signal.h>
#include <string.h>

#include "meroko.h"
/* Expansion cards */
#include "raven_cpu.h"

/* NCurses data */
/* Root window */
WINDOW *msg_w;

#ifdef TRACELOG
FILE *logfile;
#endif

extern void raven_disp_init();
struct itimerval interval;

void logmsg(char *msg);
unsigned int period = 0;

extern void updatetime(int arg);

// Alarm
void alarmhandler(int fnord){
  int key;
  signal(SIGALRM,&alarmhandler);
  setitimer(ITIMER_REAL,&interval,NULL);    
  /*
  updatetime(0);
  */
  key=wgetch(msg_w);
  if(key != ERR){
    // Stuff
    switch(key){
    case 's': // STEP
      raven_step();
      break;
    case 'g': // GO
      raven_cont();
      break;
    case 'h': // HALT
      raven_halt();
      break;
    };
  }
  raven_dispupdate();
  period=0;
};

// To log a message
void logmsg(char *msg){

#ifdef TRACELOG
  // Save debug log
  fprintf(logfile,"%s",msg);
  fflush(logfile);
  // Don't do this for some stuff.
  if(strncmp(msg,"DEBUG:",6)==0){ return; }
#endif

  scroll(msg_w);                      // Drop a line
  mvwprintw(msg_w,(LINES/2)-2,1,msg); // Print text
  box(msg_w,0,0);                     // Redraw box
  wmove(msg_w,0,(COLS/2)-4);          // Move cursor
  wprintw(msg_w,"MESSAGES");          // Write title
  wrefresh(msg_w);                    // Redraw
};

// ENTRY POINT
int main(){

#ifdef TRACELOG
  logfile = fopen("DEBUG.LOG","w+");
#endif

  raven_initialize();

  // Curses init
  printf("[SYS] Initializing curses...\n");
  initscr();
  cbreak();
  noecho();
  keypad(stdscr,TRUE);
  //  printw("Got %dx%d",LINES,COLS);
  msg_w = newwin((LINES/2),COLS,(LINES/2),0);
  scrollok(msg_w,TRUE);
  nodelay(msg_w,TRUE);
  raven_disp_init();
	

  /* Establish monitoring */
  signal(SIGALRM,&alarmhandler);
  interval.it_interval.tv_usec = 0;
  interval.it_interval.tv_sec = 1;
  interval.it_value.tv_usec = 0;
  interval.it_value.tv_sec = 1;
  
  setitimer(ITIMER_REAL,&interval,NULL);    

  logmsg("[SYS] Starting CPU at 0\n");  
  while(1){
    raven_clockpulse();
  }

  // Die
  endwin();

#ifdef TRACELOG
  fclose(logfile);
#endif

  return(0);
}
