;;; -*- Mode: Lisp; Package: FILE-SYSTEM; Base: 8.; Patch-File: T -*-
;;; Written 6/10/84 08:19:03 by LMFile,
;;; Reason: make local-file-mixin operations take error args consistent with pathname system
;;; while running on Lisp Machine Filecomputer from band 1
;;; with System 98.49, CADR 3.6, ZMail 53.17, MIT-Specific 22.1, Experimental Local-File 48.4, Experimental FILE-Server 8.5, Experimental LFS 3.3, Experimental MagTape 22.6, microcode 309, XFS/C.

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :DELETE) (&OPTIONAL (ERROR-P T))
  (IDENTIFY-FILE-OPERATION ':DELETE
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
        (LMFS-DELETE-FILE FILE)))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :UNDELETE) (&OPTIONAL (ERROR-P T))
  (IDENTIFY-FILE-OPERATION ':UNDELETE
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
        (LMFS-UNDELETE-FILE FILE)))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :EXPUNGE) (&KEY (ERROR T))
  (IDENTIFY-FILE-OPERATION ':EXPUNGE
    (HANDLING-ERRORS ERROR
      (LMFS-EXPUNGE-DIRECTORY DIRECTORY NAME TYPE VERSION))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :RENAME) (NEW-NAME &OPTIONAL (ERROR-P T))
  (IDENTIFY-FILE-OPERATION ':RENAME
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
	(LMFS-RENAME-FILE FILE
			  (PATHNAME-DIRECTORY NEW-NAME)
			  (OR (PATHNAME-NAME NEW-NAME) "FOO")
			  (OR (PATHNAME-TYPE NEW-NAME) ':UNSPECIFIC)
			  (PATHNAME-VERSION NEW-NAME))))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :CREATE-LINK) (TARGET &KEY (ERROR T))
  TARGET
  (HANDLING-ERRORS ERROR
    (LM-SIGNAL-ERROR 'LINKS-NOT-SUPPORTED NIL NIL ':CREATE-LINK)))

))
