;;; -*- Mode: Lisp; Package: FILE-SYSTEM; Base: 8.; Patch-File: T -*-
;;; Patch file for LFS version 2.2
;;; Reason: Larger disk labels. - RMS
;;; Written 7/06/83 16:59:08 by LMFile,
;;; while running on Lisp Machine Filecomputer from band 1
;;; with MIT-Specific 19.5, System 94.34, ZMail 50.16, Experimental Local-File 44.2, FILE-Server 6.6, MagTape 14.4, Experimental LFS 2.1, microcode 238, FC.



; From file PACK.LISP SRC:<L.FILE2> OZ:
#8R FILE-SYSTEM:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER:PATCH-SOURCE-FILE "SYS: FILE2; PACK  "

(DEFUN INIT-FILE-PARTITION
       (UNIT PARTITION-NAME &OPTIONAL &KEY
	(VOLUME-NAME "FOO")
	(COMMENT "FOO")
	(PAGES-PER-BLOCK 1)
	(PACK-NUMBER 0)
	(PACKS-IN-VOLUME 1)
	(PARENT-VOLUME-NAME "ROOT")
	(DANGER-AVAILABLE-BLOCKS DEFAULT-DANGER-AVAILABLE-BLOCKS)
	(MINIMUM-AVAILABLE-BLOCKS DEFAULT-MINIMUM-AVAILABLE-BLOCKS)
	(MAXIMUM-AVAILABLE-BLOCKS DEFAULT-MAXIMUM-AVAILABLE-BLOCKS)
	(DESIRABLE-AVAILABLE-BLOCKS DEFAULT-DESIRABLE-AVAILABLE-BLOCKS)
	(AVAILABLE-TABLE-SIZE DEFAULT-AVAILABLE-TABLE-SIZE)
	&AUX RQB PART-BASE PART-SIZE
	(BLOCK-SIZE (* PAGE-SIZE PAGES-PER-BLOCK))
	(FREE-MAP-FIRST-BLOCK 1)
	FREE-MAP-N-BLOCKS)
  (OR (AND (FIXP PACK-NUMBER)
	   (FIXP PACKS-IN-VOLUME)
	   ( PACK-NUMBER 0)
	   (> PACKS-IN-VOLUME PACK-NUMBER))
      (FERROR NIL "Pack number ~S out of ~S packs is meaningless"
	      PACK-NUMBER PACKS-IN-VOLUME))
  (VALIDATE-UNIT-NUMBER UNIT)
  (CHECK-ARG VOLUME-NAME STRINGP "a string")
  (CHECK-ARG PARENT-VOLUME-NAME STRINGP "a string")
  (SETQ VOLUME-NAME (STRING-UPCASE VOLUME-NAME))
  (SETQ PARENT-VOLUME-NAME (STRING-UPCASE PARENT-VOLUME-NAME))
  (DISMOUNT-UNIT UNIT PARTITION-NAME)
  (UNWIND-PROTECT
    (PROG INIT ()
	  (SETQ RQB (GET-DISK-RQB))
	  (MULTIPLE-VALUE (PART-BASE PART-SIZE)
	    (FIND-DISK-PARTITION PARTITION-NAME NIL UNIT))
	  (OR PART-BASE (FERROR NIL "No partition named ~S on unit ~S" PARTITION-NAME UNIT))
	  (DISK-READ RQB UNIT PART-BASE)
	  (OR (YES-OR-NO-P
		(IF (STRING-EQUAL (GET-DISK-STRING RQB HEADER-IDENTIFICATION 4) "FILE")
		    (FORMAT NIL "Reinitialize unit ~S partition ~A, which is volume ~A pack ~S? "
			    UNIT PARTITION-NAME
			    (GET-DISK-STRING RQB HEADER-VOLUME-NAME 32.)
			    (GET-DISK-FIXNUM RQB HEADER-PACK-NUMBER-WITHIN-VOLUME))
		  (FORMAT NIL "Initialize unit ~S partition ~A, not formatted for LMFILE? "
			  UNIT PARTITION-NAME)))
	      (RETURN-FROM INIT NIL))
	  (FILLARRAY (RQB-BUFFER RQB) '(0))
	  (PUT-DISK-STRING RQB "FILE" HEADER-IDENTIFICATION 4)
	  (PUT-DISK-FIXNUM RQB 2 HEADER-VERSION-NUMBER)
	  (PUT-DISK-STRING RQB VOLUME-NAME HEADER-VOLUME-NAME 32.)
	  (PUT-DISK-FIXNUM RQB PACK-NUMBER HEADER-PACK-NUMBER-WITHIN-VOLUME)
	  (PUT-DISK-FIXNUM RQB PACKS-IN-VOLUME HEADER-NUMBER-OF-PACKS-IN-VOLUME)
	  (PUT-DISK-FIXNUM RQB 0 HEADER-SYSTEM-INCARNATION-NUMBER)
	  (PUT-DISK-FIXNUM RQB PAGES-PER-BLOCK HEADER-PAGES-PER-BLOCK)
	  (PUT-DISK-FIXNUM RQB (TRUNCATE PART-SIZE PAGES-PER-BLOCK) HEADER-NUMBER-OF-BLOCKS)
	  (SETQ FREE-MAP-N-BLOCKS
		(QUOTIENT-CEILING (TRUNCATE PART-SIZE PAGES-PER-BLOCK) (* BLOCK-SIZE 40)))
	  (PUT-DISK-FIXNUM RQB FREE-MAP-FIRST-BLOCK HEADER-FREE-MAP-FIRST-BLOCK)
	  (PUT-DISK-FIXNUM RQB FREE-MAP-N-BLOCKS HEADER-FREE-MAP-NUMBER-OF-BLOCKS)
	  (PUT-DISK-FIXNUM RQB (+ FREE-MAP-FIRST-BLOCK FREE-MAP-N-BLOCKS)
			   HEADER-BLOCK-STARTS-FILE-MAP-FIRST-BLOCK)
	  (PUT-DISK-FIXNUM RQB (+ FREE-MAP-FIRST-BLOCK FREE-MAP-N-BLOCKS FREE-MAP-N-BLOCKS)
			   HEADER-LOCKED-BLOCK-MAP-FIRST-BLOCK)
	  (PUT-DISK-FIXNUM RQB 0 HEADER-ROOT-FIRST-BLOCK)
	  (PUT-DISK-STRING RQB COMMENT HEADER-COMMENT 96.)
	  ;; Say we should GC this pack on first use.
	  (PUT-DISK-FIXNUM RQB 0 HEADER-PACK-CLEAN-FLAG)
	  (PUT-DISK-FIXNUM RQB DANGER-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-DANGER)
	  (PUT-DISK-FIXNUM RQB MINIMUM-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-MINIMUM)
	  (PUT-DISK-FIXNUM RQB MAXIMUM-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-MAXIMUM)
	  (PUT-DISK-FIXNUM RQB DESIRABLE-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-DESIRABLE)
	  (PUT-DISK-FIXNUM RQB AVAILABLE-TABLE-SIZE HEADER-AVAILABLE-TABLE-SIZE)
	  (PUT-DISK-STRING RQB PARENT-VOLUME-NAME HEADER-PARENT-VOLUME-NAME 32.)
	  (DISK-WRITE RQB UNIT PART-BASE)
; Clear out the block-starts-file map.
          (CLEAR-BITMAP UNIT (+ FREE-MAP-FIRST-BLOCK FREE-MAP-N-BLOCKS) FREE-MAP-N-BLOCKS
			PART-BASE PAGES-PER-BLOCK)
; Clear out the locked block map.
	  (CLEAR-BITMAP UNIT (+ FREE-MAP-FIRST-BLOCK FREE-MAP-N-BLOCKS FREE-MAP-N-BLOCKS)
			FREE-MAP-N-BLOCKS
			PART-BASE PAGES-PER-BLOCK)
; Clear out the free map.  Yes, say that no blocks are free!
; The first GC will correctly initialize the free map.
	  (CLEAR-BITMAP UNIT FREE-MAP-FIRST-BLOCK
			FREE-MAP-N-BLOCKS
			PART-BASE PAGES-PER-BLOCK))
    (RETURN-DISK-RQB RQB)))

))

; From file PACK.LISP SRC:<L.FILE2> OZ:
#8R FILE-SYSTEM:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER:PATCH-SOURCE-FILE "SYS: FILE2; PACK  "

;Change some of the parameters of a partition, without invalidating its contents.
;You must run this if you make the partition longer.
(DEFUN REINIT-FILE-PARTITION (UNIT PARTITION-NAME &OPTIONAL &KEY
				   VOLUME-NAME COMMENT PACK-NUMBER PACKS-IN-VOLUME
				   PARENT-VOLUME-NAME
				   DANGER-AVAILABLE-BLOCKS
				   MINIMUM-AVAILABLE-BLOCKS
				   MAXIMUM-AVAILABLE-BLOCKS
				   DESIRABLE-AVAILABLE-BLOCKS
				   AVAILABLE-TABLE-SIZE
				   &AUX RQB PART-BASE PART-SIZE PAGES-PER-BLOCK
				   BLOCK-SIZE
				   OLD-TOTAL-N-BLOCKS
				   TOTAL-N-BLOCKS
				   FREE-MAP-OLD-N-BLOCKS
				   FREE-MAP-N-BLOCKS)
  (VALIDATE-UNIT-NUMBER UNIT)
  (AND VOLUME-NAME (CHECK-ARG VOLUME-NAME STRINGP "a string"))
  (AND PARENT-VOLUME-NAME (CHECK-ARG PARENT-VOLUME-NAME STRINGP "a string"))
  (AND VOLUME-NAME (SETQ VOLUME-NAME (STRING-UPCASE VOLUME-NAME)))
  (AND PARENT-VOLUME-NAME (SETQ PARENT-VOLUME-NAME (STRING-UPCASE PARENT-VOLUME-NAME)))
  (DISMOUNT-UNIT UNIT PARTITION-NAME)
  (UNWIND-PROTECT
    (PROG INIT ()
	  (SETQ RQB (GET-DISK-RQB))
	  (MULTIPLE-VALUE (PART-BASE PART-SIZE)
	    (FIND-DISK-PARTITION PARTITION-NAME NIL UNIT))
	  (OR PART-BASE (FERROR NIL "No partition named ~A on unit ~S" PARTITION-NAME UNIT))
	  ;; Start from what's already in that partition's header.
	  (DISK-READ RQB UNIT PART-BASE)
	  (OR (AND (STRING-EQUAL (GET-DISK-STRING RQB HEADER-IDENTIFICATION 4) "FILE")
		   (MEMQ (GET-DISK-FIXNUM RQB HEADER-VERSION-NUMBER) '(1 2)))
	      (FERROR NIL "Unit ~S partition ~A not formatted for LMFILE"
		      UNIT PARTITION-NAME))
	  (OR (YES-OR-NO-P (FORMAT NIL "Reinitialize unit ~S partition ~A, which is volume ~A pack ~S? "
				   UNIT PARTITION-NAME
				   (GET-DISK-STRING RQB HEADER-VOLUME-NAME 32.)
				   (GET-DISK-FIXNUM RQB HEADER-PACK-NUMBER-WITHIN-VOLUME)))
	      (RETURN-FROM INIT NIL))
	  ;; Change pack identification if specified.
	  (AND VOLUME-NAME
	       (PUT-DISK-STRING RQB VOLUME-NAME HEADER-VOLUME-NAME 32.))
	  (AND PACK-NUMBER
	       (PUT-DISK-FIXNUM RQB PACK-NUMBER HEADER-PACK-NUMBER-WITHIN-VOLUME))
	  (AND PACKS-IN-VOLUME
	       (PUT-DISK-FIXNUM RQB PACKS-IN-VOLUME HEADER-NUMBER-OF-PACKS-IN-VOLUME))
	  (AND COMMENT
	       (PUT-DISK-STRING RQB COMMENT HEADER-COMMENT 96.))
	  (AND PARENT-VOLUME-NAME
	       (PUT-DISK-STRING RQB PARENT-VOLUME-NAME HEADER-PARENT-VOLUME-NAME 32.))
	  ;; Change available table parameters if specified.
	  (AND DANGER-AVAILABLE-BLOCKS
	       (PUT-DISK-FIXNUM RQB DANGER-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-DANGER))
	  (AND MINIMUM-AVAILABLE-BLOCKS
	       (PUT-DISK-FIXNUM RQB MINIMUM-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-MINIMUM))
	  (AND MAXIMUM-AVAILABLE-BLOCKS
	       (PUT-DISK-FIXNUM RQB MAXIMUM-AVAILABLE-BLOCKS HEADER-AVAILABLE-TABLE-MAXIMUM))
	  (AND DESIRABLE-AVAILABLE-BLOCKS
	       (PUT-DISK-FIXNUM RQB DESIRABLE-AVAILABLE-BLOCKS
				HEADER-AVAILABLE-TABLE-DESIRABLE))
	  (AND AVAILABLE-TABLE-SIZE
	       (PUT-DISK-FIXNUM RQB AVAILABLE-TABLE-SIZE HEADER-AVAILABLE-TABLE-SIZE))
	  ;; Change size of maps if they aren't big enough.
	  (SETQ PAGES-PER-BLOCK (GET-DISK-FIXNUM RQB HEADER-PAGES-PER-BLOCK))
	  (SETQ BLOCK-SIZE (* PAGE-SIZE PAGES-PER-BLOCK))
	  (SETQ FREE-MAP-N-BLOCKS
		(QUOTIENT-CEILING (TRUNCATE PART-SIZE PAGES-PER-BLOCK) (* BLOCK-SIZE 40)))
	  (SETQ FREE-MAP-OLD-N-BLOCKS (GET-DISK-FIXNUM RQB HEADER-FREE-MAP-NUMBER-OF-BLOCKS))
	  (SETQ OLD-TOTAL-N-BLOCKS
		(IF (= (GET-DISK-FIXNUM RQB HEADER-VERSION-NUMBER) 2)
		    (GET-DISK-FIXNUM RQB HEADER-NUMBER-OF-BLOCKS)
		  (* FREE-MAP-OLD-N-BLOCKS (* BLOCK-SIZE 40))))
	  (SETQ TOTAL-N-BLOCKS (TRUNCATE PART-SIZE PAGES-PER-BLOCK))
	  (PUT-DISK-FIXNUM RQB TOTAL-N-BLOCKS HEADER-NUMBER-OF-BLOCKS)
	  (PUT-DISK-FiXNUM RQB 2 HEADER-VERSION-NUMBER)
	  (COND ((> FREE-MAP-N-BLOCKS FREE-MAP-OLD-N-BLOCKS)
		 (OR (> TOTAL-N-BLOCKS (+ OLD-TOTAL-N-BLOCKS (* 3 FREE-MAP-N-BLOCKS)))
		     (FERROR NIL "Partition size increment is too small"))
		 ;; Size of maps must increase!
		 ;; Note it is ok to extend the free map with 0's,
		 ;; since the newly-created blocks will get freed up
		 ;; by the first GC.  Similarly, we can leave the old
		 ;; map blocks marked in use, and this way there is no
		 ;; need to do anything special about the new ones either.
		 ;; But we must mark the pack as dirty to cause GC!
		 (PUT-DISK-FIXNUM RQB 0 HEADER-PACK-CLEAN-FLAG)
		 (PUT-DISK-FIXNUM RQB FREE-MAP-N-BLOCKS HEADER-FREE-MAP-NUMBER-OF-BLOCKS)
		 (MOVE-AND-EXPAND-MAP UNIT RQB HEADER-FREE-MAP-FIRST-BLOCK
				      FREE-MAP-OLD-N-BLOCKS
				      OLD-TOTAL-N-BLOCKS
				      FREE-MAP-N-BLOCKS
				      PART-BASE PAGES-PER-BLOCK)
		 (MOVE-AND-EXPAND-MAP UNIT RQB HEADER-BLOCK-STARTS-FILE-MAP-FIRST-BLOCK
				      FREE-MAP-OLD-N-BLOCKS
				      (+ OLD-TOTAL-N-BLOCKS FREE-MAP-N-BLOCKS)
				      FREE-MAP-N-BLOCKS
				      PART-BASE PAGES-PER-BLOCK)
		 (MOVE-AND-EXPAND-MAP UNIT RQB HEADER-LOCKED-BLOCK-MAP-FIRST-BLOCK
				      FREE-MAP-OLD-N-BLOCKS
				      (+ OLD-TOTAL-N-BLOCKS
					 FREE-MAP-N-BLOCKS FREE-MAP-N-BLOCKS)
				      FREE-MAP-N-BLOCKS
				      PART-BASE PAGES-PER-BLOCK)))
	  (DISK-WRITE RQB UNIT PART-BASE))
    (RETURN-DISK-RQB RQB)))

))

; From file PACK.LISP SRC:<L.FILE2> OZ:
#8R FILE-SYSTEM:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER:PATCH-SOURCE-FILE "SYS: FILE2; PACK  "

;Look at a unit examine its header.
;We create the PACK-STRUCTURE object and store it in TENTATIVE-PACK-LIST.
;This does not actually make the unit available for use.
;MOUNT-TENTATIVE-UNITS does that, after verifying that all the tentative
;units make a consistent set.
(DEFUN CONSIDER-UNIT (UNIT &OPTIONAL (PARTITION-NAME "FILE")
		    &AUX (RQB NIL)
		         (PACK (MAKE-PACK-STRUCTURE))
			 TB
			 PART-BASE
			 PART-SIZE)
  ;; See if this unit and partition are already on PACK-LIST or TENTATIVE-PACK-LIST.
  (DOLIST (PACK PACK-LIST)
    (AND (= (PACK-UNIT-NUMBER PACK) UNIT)
	 (STRING-EQUAL (PACK-PARTITION-NAME PACK) PARTITION-NAME)
	 (FERROR NIL "Unit ~S partition ~A is already mounted" UNIT PARTITION-NAME)))
  (DOLIST (PACK TENTATIVE-PACK-LIST)
    (AND (= (PACK-UNIT-NUMBER PACK) UNIT)
	 (STRING-EQUAL (PACK-PARTITION-NAME PACK) PARTITION-NAME)
	 (SETQ TENTATIVE-PACK-LIST
	       (DELQ PACK TENTATIVE-PACK-LIST))))
  (OR (SI:POWER-UP-DISK UNIT)
      (FERROR NIL "Unit ~S is not on-line" UNIT))
  (UNWIND-PROTECT
    (PROGN (SETQ RQB (GET-DISK-RQB))
	   (MULTIPLE-VALUE (PART-BASE PART-SIZE)
		    (FIND-DISK-PARTITION PARTITION-NAME NIL UNIT))
	   (AND (NULL PART-BASE)
		(FERROR NIL "No ~A partition on unit ~S" PARTITION-NAME UNIT))
	   (DISK-READ RQB UNIT PART-BASE)  ;Get pack file-system header
	   (OR (AND (STRING-EQUAL (GET-DISK-STRING RQB HEADER-IDENTIFICATION 4) "FILE")
		    (MEMQ (GET-DISK-FIXNUM RQB HEADER-VERSION-NUMBER) '(1 2)))
	       (FERROR NIL "Unit ~S partition ~A not formatted for LMFILE"
		       UNIT PARTITION-NAME))
	   (SETF (PACK-UNIT-NUMBER PACK) UNIT)
	   (SETF (PACK-PARTITION-NAME PACK) PARTITION-NAME)
	   (SETF (PACK-VOLUME-NAME PACK) (GET-DISK-STRING RQB HEADER-VOLUME-NAME 32.))
	   (SETF (PACK-NUMBER-WITHIN-VOLUME PACK)
		 (GET-DISK-FIXNUM RQB HEADER-PACK-NUMBER-WITHIN-VOLUME))
	   (SETF (PACK-NUMBER-OF-PACKS-IN-VOLUME PACK)
		 (GET-DISK-FIXNUM RQB HEADER-NUMBER-OF-PACKS-IN-VOLUME))
	   (OR (AND (>= (PACK-NUMBER-WITHIN-VOLUME PACK) 0)
		    (< (PACK-NUMBER-WITHIN-VOLUME PACK)
		       (PACK-NUMBER-OF-PACKS-IN-VOLUME PACK))
		    (<= (PACK-NUMBER-OF-PACKS-IN-VOLUME PACK) N-UNITS))
	       (FERROR NIL "Unit ~S partition ~A pack number information is inconsistent"
		       UNIT PARTITION-NAME))
	   (SETF (PACK-INCARNATION-NUMBER PACK)
		 (%24-BIT-PLUS (GET-DISK-FIXNUM RQB HEADER-SYSTEM-INCARNATION-NUMBER) 1))
	   (SETF (PACK-COMMENT PACK) (GET-DISK-STRING RQB HEADER-COMMENT 96.))
	   (SETF (PACK-PAGES-PER-BLOCK PACK)
		 (GET-DISK-FIXNUM RQB HEADER-PAGES-PER-BLOCK))
	   (SETF (PACK-FIRST-ABS-PAGE-NUMBER PACK) PART-BASE)
	   (SETF (PACK-NUMBER-OF-BLOCKS PACK)
		 (IF (= (GET-DISK-FIXNUM RQB HEADER-VERSION-NUMBER) 1)
		     (TRUNCATE PART-SIZE (PACK-PAGES-PER-BLOCK PACK))
		   (GET-DISK-FIXNUM RQB HEADER-NUMBER-OF-BLOCKS)))
	   (SETF (PACK-FREE-MAP-FIRST-BLOCK PACK)
		 (GET-DISK-FIXNUM RQB HEADER-FREE-MAP-FIRST-BLOCK))
	   (SETF (PACK-BLOCK-STARTS-FILE-MAP-FIRST-BLOCK PACK)
		 (GET-DISK-FIXNUM RQB HEADER-BLOCK-STARTS-FILE-MAP-FIRST-BLOCK))
	   (SETF (PACK-LOCKED-BLOCK-MAP-FIRST-BLOCK PACK)
		 (GET-DISK-FIXNUM RQB HEADER-LOCKED-BLOCK-MAP-FIRST-BLOCK))
	   (SETF (PACK-FREE-MAP-SCANNING-INDEX PACK) 0)
	   (SETF (PACK-FREE-MAP-NUMBER-OF-BLOCKS PACK)
		 (GET-DISK-FIXNUM RQB HEADER-FREE-MAP-NUMBER-OF-BLOCKS))
	   (OR (= (PACK-FREE-MAP-NUMBER-OF-BLOCKS PACK)
		  (QUOTIENT-CEILING (PACK-NUMBER-OF-BLOCKS PACK)
				    (* 32. (PACK-PAGES-PER-BLOCK PACK) PAGE-SIZE)))
	       (FERROR NIL "Inconsistent free table size on unit ~S partition ~A"
		       UNIT PARTITION-NAME))
	   (SETF (PACK-DANGER-AVAILABLE-BLOCKS PACK)
		 (GET-DISK-FIXNUM RQB HEADER-AVAILABLE-TABLE-DANGER))
	   (SETF (PACK-MINIMUM-AVAILABLE-BLOCKS PACK)
		 (GET-DISK-FIXNUM RQB HEADER-AVAILABLE-TABLE-MINIMUM))
	   (SETF (PACK-MAXIMUM-AVAILABLE-BLOCKS PACK)
		 (GET-DISK-FIXNUM RQB HEADER-AVAILABLE-TABLE-MAXIMUM))
	   (SETF (PACK-DESIRABLE-AVAILABLE-BLOCKS PACK)
		 (GET-DISK-FIXNUM RQB HEADER-AVAILABLE-TABLE-DESIRABLE))
	   ;; Set up available table
	   (LET ((AVAILABLE-TABLE-SIZE (GET-DISK-FIXNUM RQB HEADER-AVAILABLE-TABLE-SIZE)))
	     (OR (AND (PLUSP (PACK-MINIMUM-AVAILABLE-BLOCKS PACK))
		      (< (PACK-MINIMUM-AVAILABLE-BLOCKS PACK)
			 (PACK-DESIRABLE-AVAILABLE-BLOCKS PACK))
		      (< (PACK-DESIRABLE-AVAILABLE-BLOCKS PACK)
			 (PACK-MAXIMUM-AVAILABLE-BLOCKS PACK))
		      (< (PACK-DESIRABLE-AVAILABLE-BLOCKS PACK)
			 AVAILABLE-TABLE-SIZE)
		      (< (PACK-DANGER-AVAILABLE-BLOCKS PACK)
			 (PACK-MINIMUM-AVAILABLE-BLOCKS PACK))
;		      (< (PACK-MAXIMUM-AVAILABLE-BLOCKS PACK)
;			 (PACK-NUMBER-OF-BLOCKS PACK))
		 )
		 (FERROR NIL "Nonsensical available-table parameters on unit ~S partition ~A"
			 UNIT PARTITION-NAME))
	     (SETQ TB (MAKE-ARRAY (LIST AVAILABLE-TABLE-SIZE 2)
				  ':AREA PERMANENT-STORAGE-AREA))
	     (DOTIMES (I AVAILABLE-TABLE-SIZE) (ASET 0 TB I 0) (ASET 0 TB I 1)))
	   (SETF (PACK-AVAILABLE-TABLE PACK) TB)
	   (SETF (PACK-NUMBER-OF-AVAILABLE-BLOCKS PACK) 0)
	   (SETF (PACK-PARENT-VOLUME-NAME PACK)
		 (GET-DISK-STRING RQB HEADER-PARENT-VOLUME-NAME 32.))
	   (AND (STRING-EQUAL (PACK-PARENT-VOLUME-NAME PACK) "")
		(SETF (PACK-PARENT-VOLUME-NAME PACK) NIL))
	   (SETF (PACK-ROOT-FIRST-BLOCK PACK)
		 (GET-DISK-FIXNUM RQB HEADER-ROOT-FIRST-BLOCK))
	   (SELECTQ (GET-DISK-FIXNUM RQB HEADER-PACK-CLEAN-FLAG)
	     (0 (SETF (PACK-GC-BIT-MAP PACK)
		      (MAKE-ARRAY (* 2 PAGE-SIZE (PACK-PAGES-PER-BLOCK PACK)
				     (PACK-FREE-MAP-NUMBER-OF-BLOCKS PACK))
				  ':TYPE 'ART-16B)))
	     (2 (SETF (PACK-LOCKED-BLOCK-FILES PACK) T)))
	   ;; Read in the contents of the bit maps.
	   (SETF (PACK-BLOCK-STARTS-FILE-MAP-ARRAY PACK)
		 (READ-BITMAP-INTO-ARRAY PACK (PACK-BLOCK-STARTS-FILE-MAP-FIRST-BLOCK PACK)))
	   (SETF (PACK-LOCKED-BLOCK-MAP-ARRAY PACK)
		 (READ-BITMAP-INTO-ARRAY PACK (PACK-LOCKED-BLOCK-MAP-FIRST-BLOCK PACK)))
	   (SETF (PACK-FREE-MAP-RQB PACK)
		 (GET-DISK-RQB (* (PACK-FREE-MAP-NUMBER-OF-BLOCKS PACK)
				  (PACK-PAGES-PER-BLOCK PACK))))
	   (READ-BITMAP-INTO-ARRAY PACK (PACK-FREE-MAP-FIRST-BLOCK PACK)
				   (RQB-BUFFER (PACK-FREE-MAP-RQB PACK)))
	   (SETF (PACK-NUMBER-OF-FREE-BLOCKS PACK)
		 (COUNT-FREE-BLOCKS PACK))
	   (PUSH PACK TENTATIVE-PACK-LIST))		;Do this last
    (RETURN-DISK-RQB RQB)))

))
