;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 11/12/84 06:12:00 by Mly,
;;; Reason: Proceeding from file error by supplying new pathname doesn't blow out
;;; while running on Lisp Machine Eight from band 2
;;; with System 98.76, CADR 3.10, ZMail 53.19, MIT-Specific 22.5, microcode 309, ZM MIT.


; From file LMMAC.LISP OZ:<L.SYS2> OZ: (379)
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; LMMAC  "

(DEFUN FILE-RETRY-RESUME-HANDLER (ERROR-OBJECT TAG &OPTIONAL NEW-PATHNAME)
  ERROR-OBJECT
  (*THROW TAG NEW-PATHNAME))

))

; From file CHSAUX.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: IO; CHSAUX  "

(DEFUN GENERATE-HOST-TABLE-1 (INPUT-FILE OUTPUT-FILE)
  (LET ((*PACKAGE* (FIND-PACKAGE "CHAOS"))
	(*READ-BASE* 8) (*PRINT-BASE* 8))
    (WITH-OPEN-FILE (OUTPUT-STREAM OUTPUT-FILE :DIRECTION :OUTPUT :CHARACTERS T)
      (FORMAT OUTPUT-STREAM "~
;;; -*- Mode: LISP;~@[ Package: ~A;~] Base: 8 -*-
;;; *** THIS FILE WAS AUTOMATICALLY GENERATED BY A PROGRAM, DO NOT EDIT IT ***
;;; Host table made from ~A~%"
	      SI:*FORCE-PACKAGE* (SEND (FS:PARSE-PATHNAME INPUT-FILE) :TRUENAME))
      (SI::WRITE-RESPONSIBILITY-COMMENT OUTPUT-STREAM)
      (GENERATE-HOST-TABLE-2 INPUT-FILE OUTPUT-STREAM)
      (WHEN (GET-SITE-OPTION :NON-CHAOS-HOST-TABLE-FILE)
	(GENERATE-HOST-TABLE-2 (GET-SITE-OPTION :NON-CHAOS-HOST-TABLE-FILE)
			       OUTPUT-STREAM)))))

))
