;;; -*- Mode:Lisp; Readtable:T; Package:ZWEI; Base:8.; Patch-File:T -*-
;;; Patch file for ZMail version 54.1
;;; Reason: typo broke buffer select menu
;;; ~X screw in mode line
;;; Written 9/24/84 22:16:48 by Mly,
;;; while running on Lisp Machine Nine from band 3
;;; with Experimental System 99.4, CADR 4.0, Experimental ZMail 54.0, MIT-Specific 23.0, microcode 320, GC@2.



; From file FILTER.LISP OZ:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFUN MENU-GET-ZMAIL-BUFFER-FOR-SELECTION (&AUX ITEM-LIST)
  "Return a ZMAIL-BUFFER chose by the user.  We offer the menu."
  (MULTIPLE-VALUE-BIND (ZMAIL-BUFFER-ALIST TEMP-ZMAIL-BUFFER-ALIST)
      (GET-ZMAIL-BUFFER-ALISTS T)
    (LEXPR-SEND *SELECT-ZMAIL-BUFFER-MENU* :SET-GEOMETRY
		(IF (OR ZMAIL-BUFFER-ALIST TEMP-ZMAIL-BUFFER-ALIST) '(2 NIL) '(NIL 1)))
    (SETQ ITEM-LIST (TV:APPEND-ITEM-LISTS ZMAIL-BUFFER-ALIST TEMP-ZMAIL-BUFFER-ALIST)))
  (SETQ ITEM-LIST (APPEND ITEM-LIST
			  (AND (ODDP (LENGTH ITEM-LIST)) '(("" :NO-SELECT T)))
			  '(("Read or create file" :VALUE :READ-FILE :FONT FONTS:HL12I
			     :DOCUMENTATION
			     "Read in and select a mail file, creating it if necessary.")
			    ("Mark summary" :VALUE :MARKING :FONT FONTS:HL12I
			     :DOCUMENTATION
		       "Select a temporary buffer made by clicking on the summary window.")
			    ("Abort" :VALUE :ABORT :FONT FONTS:HL12I
				     :DOCUMENTATION "Abort this command.")
			    ("Subset" :VALUE :SUBSET :FONT FONTS:HL12I
			     :DOCUMENTATION "Select a subset buffer made by filtering.")
			    )))
  (OR (EQUAL ITEM-LIST (SEND *SELECT-ZMAIL-BUFFER-MENU* :ITEM-LIST))
      (SEND *SELECT-ZMAIL-BUFFER-MENU* :SET-ITEM-LIST ITEM-LIST))
  (UNWIND-PROTECT
    (PROGN
      (TV:EXPOSE-WINDOW-NEAR *SELECT-ZMAIL-BUFFER-MENU* (RECTANGLE-NEAR-COMMAND-MENU))
      (DO ((ZMAIL-BUFFER)) (NIL)
	(SETQ ZMAIL-BUFFER (SEND *SELECT-ZMAIL-BUFFER-MENU* :CHOOSE))
	(SET-COMMAND-BUTTON (SEND *SELECT-ZMAIL-BUFFER-MENU* :LAST-BUTTONS))
	(SELECTQ ZMAIL-BUFFER
	  (:ABORT
	   (ABORT-CURRENT-COMMAND))
	  (:SUBSET
	   (SEND *SELECT-ZMAIL-BUFFER-MENU* :DEACTIVATE)
	   (SETQ ZMAIL-BUFFER (READ-SUBSET-ZMAIL-BUFFER)))
	  (:MARKING
	   (SEND *SELECT-ZMAIL-BUFFER-MENU* :DEACTIVATE)
	   (SETQ ZMAIL-BUFFER (MAKE-ZMAIL-BUFFER-BY-MARKING)))
	  (:READ-FILE
	   (SETQ ZMAIL-BUFFER (READ-ZMAIL-BUFFER-FILENAME *SELECT-ZMAIL-BUFFER-MENU*))))
	(WHEN (OR (STRINGP ZMAIL-BUFFER) (TYPEP ZMAIL-BUFFER 'FS:PATHNAME))
	  (SEND *SELECT-ZMAIL-BUFFER-MENU* :DEACTIVATE)
	  (SETQ ZMAIL-BUFFER (ZMAIL-FIND-FILE-NOSELECT ZMAIL-BUFFER)))
	(AND ZMAIL-BUFFER (RETURN ZMAIL-BUFFER))))
    (SEND *SELECT-ZMAIL-BUFFER-MENU* :DEACTIVATE)))

))

; From file COMNDS.LISP OZ:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((*PACKAGE* (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

(DEFUN COMPUTE-CURRENT-MSG-NAME ()
  (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION 'COM-EDIT-CURRENT-MSG)
  (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION 'COM-ZMAIL-KEYWORDS)
  (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION 'COM-ZMAIL-MOVE)
  (SETQ *CURRENT-MSG-NAME*
	(AND *ZMAIL-BUFFER*
	     (IF *MSG*
		 (LET ((STRING (MAKE-EMPTY-STRING 40))
		       (STATUS (ASSURE-MSG-PARSED *MSG*))
		       (NMSGS (AND (NOT (AND (ZMAIL-BUFFER-DISK-P *ZMAIL-BUFFER*)
					     (MEMQ (ZMAIL-DISK-BUFFER-STATUS *ZMAIL-BUFFER*)
						   '(:NEW-MAIL :LOADING :LOADING-NEW-MAIL))))
				   (ZMAIL-BUFFER-NMSGS *ZMAIL-BUFFER*))))
		   (FORMAT STRING "~4@TMsg #~D//~:[??~*~;~D~]" (1+ *MSG-NO*) NMSGS NMSGS)
		   (DO ((LIST *SAVED-INTERNAL-PROPERTIES-ALIST* (CDR LIST))
			(FLAG NIL)
			(KEY))
		       ((NULL LIST)
			(AND FLAG (VECTOR-PUSH-EXTEND #/) STRING)))
		     (SETQ KEY (CDAR LIST))
		     (COND ((IF (EQ KEY 'LAST)
				(AND NMSGS (= *MSG-NO* (1- NMSGS)))
				(GET STATUS KEY))
			    (APPEND-TO-ARRAY STRING (IF FLAG ", " " ("))
			    (APPEND-TO-ARRAY STRING (CAAR LIST))
			    (SETQ FLAG T))))
		   STRING)
		 "    Empty buffer"))))

))
