;;; -*- Mode: LISP -*-
;;; Memory diagnostic system, includes microcode and debugging function


(SETQ MEMD '(

(DEF-DATA-FIELD OAL-MROT 5 0)				;MROT field of microinstruction

(LOCALITY M-MEM)

M-GARBAGE	(0)
M-HUNOZ		(0)
M-ZERO		(0)
M-MINUS-ONE 
M-ONES		(0)

M-A		(0)
M-B		(0)
M-C		(0)
M-D		(0)
M-S		(0)

M-1	(0)
M-2	(0)

M-LOOP-COUNT	(0)
M-CURRENT-MEMORY-DATA	(0)
M-TEST	                (0)     ;Dispatch offset of current test
M-STARTING-POINT	(0)
M-CURRENT-MEMORY-LOC    (0)	;The memory location being hacked currently


(LOCALITY A-MEM)

A-GARBAGE	(0)
A-HUNOZ		(0)
A-ZERO		(0)
A-ONES		(0)

A-A		(0)
A-B		(0)
A-C		(0)
A-D		(0)
A-S		(0)

A-1	(0)
A-2	(0)

A-LOOP-COUNT	(0)
A-CURRENT-MEMORY-DATA   (0)     ;The data that should be at VMA
A-TEST	                (0)     ;Dispatch offset of current test
A-STARTING-POINT	(0)	;Starting point of next pass over memory for certain tests
A-CURRENT-MEMORY-LOC    (0)	;The memory location being hacked currently

(LOC 40)

A-TEM1			(0)
A-TEM2			(0)
A-TEM3			(0)

A-MAIN-MEMORY-START	(0)     ;First memory loc of interest, mapped to vir adr 0
A-MAIN-MEMORY-SIZE      (0)     ;Size of memory under test
A-REPEAT-COUNT		(0)	;Number of times to do the main data loop (decremented til 0)

;Below registers used by test loop TL
A-WA1 (0)	;address for first cycle (write)
A-RA1 (0)	;address for 2nd cycle (read)
A-WA2 (0)	;  " 3rd cycle (write)
A-RA2 (0)       ;  " 4th cycle (read)
A-WD1 (0)       ;data for first write
A-WD2 (37777777777)  ;data for second write 

(LOCALITY D-MEM)


(START-DISPATCH 3 (PLUS INHIBIT-XCT-NEXT-BIT P-BIT))

MEMORY-DATA-TESTS-INIT-DATA
	(DATA-ZEROES-INIT)                              ;ZEROES
	(DATA-ONES-INIT)                                ;ONES
	(DATA-FLOATING-ZEROES-INIT)                     ;FLOATING ZEROES
	(DATA-FLOATING-ONES-INIT)                       ;FLOATING ONES
	(DATA-OFFSET-FLOATING-ZEROES-INIT)      	;FLOATING ZEROES, OFFSET PER ADR
	(DATA-OFFSET-FLOATING-ONES-INIT)		;FLOATING ONES, OFFSET PER ADR
	(DATA-FLOATING-ADDRESS-INIT)                    ;DATA IS FLOATING ADDRESS
	(DATA-FLOATING-ADDRESS-COM-INIT)		;DATA IS FLOATING COM OF ADDRESS

(END-DISPATCH)


(START-DISPATCH 3 (PLUS INHIBIT-XCT-NEXT-BIT P-BIT))

MEMORY-DATA-TESTS-INIT-ADDRESS
	(R-BIT)                                         ;ZEROES, DROP THROUGH
	(R-BIT)                                         ;ONES
	(R-BIT)                                         ;FLOATING ZEROES
	(R-BIT)                                         ;FLOATING ONES
	(DATA-OFFSET-FLOATING-ZEROES-ADR-INIT)          ;FLOATING ZEROES OFFSET
	(DATA-OFFSET-FLOATING-ONES-ADR-INIT)            ;FLOATING ONES OFFSET
	(R-BIT)                                         ;DATA IS ADDRESS
	(R-BIT)                                         ;DATA IS COMPLEMENT OF ADDRESS


(END-DISPATCH)


(START-DISPATCH 3 (PLUS INHIBIT-XCT-NEXT-BIT P-BIT))

MEMORY-DATA-TESTS-STEP-DATA
	(MEMORY-TEST-OK)                                ;ZEROES
	(MEMORY-TEST-OK)                                ;ONES
	(DATA-FLOATING-ZEROES-STEP)                     ;FLOATING ZEROES
	(DATA-FLOATING-ONES-STEP)                       ;FLOATING ONES
	(DATA-OFFSET-FLOATING-ZEROES-STEP)              ;FLOATING ZEROES OFFSET
	(DATA-OFFSET-FLOATING-ONES-STEP)		;FLOATING ONES OFFSET
	(DATA-FLOATING-ADDRESS-STEP)			;DATA IS ADDRESS
	(DATA-FLOATING-ADDRESS-COM-STEP)		;DATA IS COMPLEMENT OF ADDRESS

(END-DISPATCH)


(START-DISPATCH 3 (PLUS INHIBIT-XCT-NEXT-BIT P-BIT))

MEMORY-DATA-TESTS-STEP-ADDRESS
	(R-BIT)                                         ;ZEROES, DROP THROUGH
	(R-BIT)                                         ;ONES
	(R-BIT)                                         ;FLOATING ZEROES
	(R-BIT)                                         ;FLOATING ONES
	(DATA-OFFSET-FLOATING-ZEROES-ADR-STEP)          ;FLOATING ZEROES OFFSET
	(DATA-OFFSET-FLOATING-ONES-ADR-STEP)            ;FLOATING ONES OFFSET
	(DATA-FLOATING-ADDRESS-ADR-STEP)		;DATA IS ADDRESS
	(DATA-FLOATING-ADDRESS-COM-ADR-STEP)		;DATA IS COMPLEMENT OF ADDRESS

(END-DISPATCH)


(LOCALITY I-MEM)

(LOC 0)

;;; Main diagnostic loop, data tests
MEMORY-DATA-TEST
	((M-ONES) SETO)
	((M-ZERO) SETZ)
	(DISPATCH MEMORY-DATA-TESTS-INIT-DATA (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)

MEMORY-DATA-TEST-1
	((M-CURRENT-MEMORY-LOC) A-MAIN-MEMORY-START)    ;START FROM THE BEGINNING
	(DISPATCH MEMORY-DATA-TESTS-INIT-ADDRESS (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)
	((M-LOOP-COUNT) SETZ)

MEMORY-DATA-LOOP-1
        (DISPATCH MEMORY-DATA-TESTS-STEP-ADDRESS (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)
	((VMA) M-CURRENT-MEMORY-LOC)
	((MD-START-WRITE) M-CURRENT-MEMORY-DATA)        ;WRITE APPROPRIATE DATA
	(JUMP-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
	((VMA-START-READ) M-CURRENT-MEMORY-LOC) 	;NOW READ BACK THE DATA IMMEDIATLY
	(JUMP-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
MEMORY-DATA-IMMEDIATE-READBACK
	(CALL-NOT-EQUAL-XCT-NEXT MD A-CURRENT-MEMORY-DATA ERROR-WRONG-DATA)
       ((M-LOOP-COUNT) M+A+1 M-LOOP-COUNT A-ZERO)
	(JUMP-LESS-THAN-XCT-NEXT M-LOOP-COUNT A-MAIN-MEMORY-SIZE MEMORY-DATA-LOOP-1)
       ((M-CURRENT-MEMORY-LOC) M+A+1 M-CURRENT-MEMORY-LOC A-ZERO)

	;; NOW WE HAVE WRITTEN A DATA PATTERN, READ IT BACK AND INSURE IT IS CORRECT
MEMORY-CHECK-LOOP
	((M-CURRENT-MEMORY-LOC) A-MAIN-MEMORY-START)
	(DISPATCH MEMORY-DATA-TESTS-INIT-ADDRESS (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)
	((M-LOOP-COUNT) SETZ)

MEMORY-CHECK-LOOP-1
	(DISPATCH MEMORY-DATA-TESTS-STEP-ADDRESS (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)
	((VMA-START-READ) M-CURRENT-MEMORY-LOC)
	(JUMP-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
MEMORY-CHECK
	(CALL-NOT-EQUAL-XCT-NEXT MD A-CURRENT-MEMORY-DATA ERROR-WRONG-DATA)
       ((M-LOOP-COUNT) M+A+1 M-LOOP-COUNT A-ZERO)
	(JUMP-LESS-THAN-XCT-NEXT M-LOOP-COUNT A-MAIN-MEMORY-SIZE MEMORY-CHECK-LOOP-1)
       ((M-CURRENT-MEMORY-LOC) M+A+1 M-CURRENT-MEMORY-LOC A-ZERO)
	(DISPATCH MEMORY-DATA-TESTS-STEP-DATA (BYTE-FIELD 3 0) M-TEST)
	(NO-OP)
	(JUMP-LESS-THAN-XCT-NEXT M-ZERO A-REPEAT-COUNT MEMORY-DATA-TEST-1)
       ((A-REPEAT-COUNT) ADD M-MINUS-ONE A-REPEAT-COUNT)

MEMORY-TEST-OK
	(JUMP HALT-CONS MEMORY-TEST-OK)
	(NO-OP)

ERROR-BAD-PAGE-FAULT
	(JUMP HALT-CONS ERROR-BAD-PAGE-FAULT)
	(NO-OP)

ERROR-WRONG-DATA
	(NO-OP HALT-CONS)                               ;DATA ERROR, CONTINUABLE
	(POPJ)
	(NO-OP)		;SO PC SAYS ERROR-WRONG-DATA INSTEAD OF DATA-ZEROS WHEN IT STOPS

;;; Data tests
DATA-ZEROES 

DATA-ZEROES-INIT
	(POPJ-AFTER-NEXT (A-REPEAT-COUNT) M+A+1 M-ZERO A-ZERO)
	((M-CURRENT-MEMORY-DATA) SETZ)

DATA-ONES 

DATA-ONES-INIT
	(POPJ-AFTER-NEXT (A-REPEAT-COUNT) M+A+1 M-ZERO A-ZERO)
	((M-CURRENT-MEMORY-DATA) SETO)


DATA-FLOATING-ZEROES 

DATA-FLOATING-ZEROES-INIT
	(POPJ-AFTER-NEXT (A-REPEAT-COUNT) (A-CONSTANT 32.))
	((M-CURRENT-MEMORY-DATA) (BYTE-FIELD 37 0) M-ONES A-ZERO)

DATA-FLOATING-ZEROES-STEP
	((M-CURRENT-MEMORY-DATA) (BYTE-FIELD 40 1) M-CURRENT-MEMORY-DATA)
	(POPJ)


DATA-FLOATING-ONES 

DATA-FLOATING-ONES-INIT
	(POPJ-AFTER-NEXT (A-REPEAT-COUNT) (A-CONSTANT 32.))
	((M-CURRENT-MEMORY-DATA) DPB (BYTE-FIELD 1 37) M-ONES A-ZERO)

DATA-FLOATING-ONES-STEP
	((M-CURRENT-MEMORY-DATA) (BYTE-FIELD 40 1) M-CURRENT-MEMORY-DATA)
	(POPJ)


DATA-OFFSET-FLOATING-ZEROES 

DATA-OFFSET-FLOATING-ZEROES-INIT
	(POPJ-AFTER-NEXT (M-STARTING-POINT) (BYTE-FIELD 37 0) M-ONES A-ZERO)
	((A-REPEAT-COUNT) (A-CONSTANT 32.))

DATA-OFFSET-FLOATING-ZEROES-ADR-INIT
	((M-CURRENT-MEMORY-DATA) M-STARTING-POINT)
	(POPJ)

DATA-OFFSET-FLOATING-ZEROES-ADR-STEP
	((M-CURRENT-MEMORY-DATA) (BYTE-FIELD 40 1) M-CURRENT-MEMORY-DATA)
	(POPJ)

DATA-OFFSET-FLOATING-ZEROES-STEP
	((M-STARTING-POINT) (BYTE-FIELD 40 1) M-STARTING-POINT)
	(POPJ)


DATA-OFFSET-FLOATING-ONES 

DATA-OFFSET-FLOATING-ONES-INIT
	(POPJ-AFTER-NEXT (M-STARTING-POINT) DPB (BYTE-FIELD 1 37) M-ONES A-ZERO)
	((A-REPEAT-COUNT) (A-CONSTANT 32.))

DATA-OFFSET-FLOATING-ONES-ADR-INIT
	((M-CURRENT-MEMORY-DATA) M-STARTING-POINT)
	(POPJ)

DATA-OFFSET-FLOATING-ONES-ADR-STEP
	((M-CURRENT-MEMORY-DATA) (BYTE-FIELD 40 1) M-CURRENT-MEMORY-DATA)
	(POPJ)

DATA-OFFSET-FLOATING-ONES-STEP
	((M-STARTING-POINT) (BYTE-FIELD 40 1) M-STARTING-POINT)
	(POPJ)


DATA-FLOATING-ADDRESS 

DATA-FLOATING-ADDRESS-INIT
	(POPJ-AFTER-NEXT (M-STARTING-POINT) SETZ)
	((A-REPEAT-COUNT) (A-CONSTANT 32.))

DATA-FLOATING-ADDRESS-ADR-STEP
	(POPJ-AFTER-NEXT (OA-REG-LOW) DPB M-STARTING-POINT OAL-MROT A-ZERO)
	((M-CURRENT-MEMORY-DATA) LDB (BYTE-FIELD 40 0)
				 M-CURRENT-MEMORY-LOC A-ZERO)

DATA-FLOATING-ADDRESS-STEP
	((M-STARTING-POINT) M+A+1 M-STARTING-POINT A-ZERO)
	(POPJ)

DATA-FLOATING-ADDRESS-COM 

DATA-FLOATING-ADDRESS-COM-INIT
	(POPJ-AFTER-NEXT (M-STARTING-POINT) SETZ)
	((A-REPEAT-COUNT) (A-CONSTANT 32.))

DATA-FLOATING-ADDRESS-COM-ADR-STEP
	((OA-REG-LOW) DPB M-STARTING-POINT OAL-MROT A-ZERO)
	(POPJ-AFTER-NEXT (M-CURRENT-MEMORY-DATA) LDB (BYTE-FIELD 40 0)
						 M-CURRENT-MEMORY-LOC A-ZERO)
	((M-CURRENT-MEMORY-DATA) SETCM M-CURRENT-MEMORY-DATA)

DATA-FLOATING-ADDRESS-COM-STEP
	((M-STARTING-POINT) M+A+1 M-STARTING-POINT A-ZERO)
	(POPJ)

;separate little test loop

TL	((MD) A-WD1)
	((VMA-START-WRITE) A-WA1)
        (CALL-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
	((VMA-START-READ) A-RA1)
        (CALL-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
	((MD) A-WD2)
	((VMA-START-WRITE) A-WA2)
        (CALL-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
	((VMA-START-READ) A-RA2)
        (CALL-IF-PAGE-FAULT ERROR-BAD-PAGE-FAULT)
	(JUMP TL)
	(NO-OP)

))	;END OF MICROCODE

