;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 51.9
;;; Reason: Lock bug.  filter definition frame bug.
;;; Written 10/27/83 23:56:34 by RMS,
;;; while running on Lisp Machine One from band 7
;;; with System 97.20, CADR 1.0, ZMail 51.7, MIT-Specific 21.0, microcode 257, ZM MIT.



; From file TOP.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; TOP  "


(DEFUN SET-ZMAIL-USER (&OPTIONAL SILENT &AUX (OLD-FRACT *SUMMARY-WINDOW-FRACTION*))
  (WITH-LOCK (*ZMAIL-PROFILE-LOADING-LOCK-CELL*)
    (UNLESS (EQUAL *ZMAIL-USER* USER-ID)
      (UNLESS *INITIALIZED-FOR-USER*
	(LET ((*INTERVAL*
		(OR *INTERVAL*			;Must not be NIL; would cause errors.
		    (WINDOW-INTERVAL *MSG-WINDOW*))))
	  (TURN-ON-MODE *MAJOR-MODE*))
	(SETQ *INITIALIZED-FOR-USER* T))
      (LOAD-ZMAIL-INIT-FILE SILENT)
      (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
      (SET-MAIN-WINDOW-CONFIGURATION *DEFAULT-INITIAL-WINDOW-CONFIGURATION*
				     ( *SUMMARY-WINDOW-FRACTION* OLD-FRACT))
      (SETQ *ZMAIL-USER* USER-ID))))

(DEFUN LOAD-ZMAIL-INIT-FILE (&OPTIONAL SILENT)
  (UNLESS (EQUAL *ZMAIL-INIT-LOADED* USER-ID)
    (WITH-LOCK (*ZMAIL-PROFILE-LOADING-LOCK-CELL*)
      (WITH-OPEN-FILE (STREAM (ZMAIL-INIT-FILE-PATHNAME)
			      ':ERROR NIL ':CHARACTERS ':DEFAULT)
	(COND ((NOT (ERRORP STREAM))
	       (UNLESS SILENT (FORMAT QUERY-IO "~&Loading Zmail init file ~A"
				      (FUNCALL STREAM ':TRUENAME)))
	       (FUNCALL (IF (FUNCALL STREAM ':CHARACTERS)
			    #'SI:READFILE-INTERNAL #'SI:FASLOAD-INTERNAL)
			STREAM "ZWEI" T))))
      (SETQ *ZMAIL-INIT-LOADED* USER-ID))))

))

; From file FILTER.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

;; This is sent when the window configuration is changed to :FILTER.
(DEFMETHOD (ZMAIL-FILTER-FRAME :INITIALIZE) (&AUX NEW-NAME CHANGED-P)
  (SETQ NEW-NAME (GENERATE-UNIQUE-NAME *USER-FILTER-ALIST*))
  (SETQ CHANGED-P (FUNCALL-SELF ':SET-PANES-ITEM-LIST 'KEYWORD-COMMAND-MENU
				(APPEND '(("Any" :VALUE ANY
					   :FONT FONTS:HL12BI :DOCUMENTATION
					   "Messages with any keyword on them."))
					*KEYWORD-ALIST*
					NIL)))
  (SETQ CHANGED-P (OR (FUNCALL-SELF ':SET-PANES-ITEM-LIST
				    'USER-FILTER-MENU (COPYLIST *USER-FILTER-ALIST*))
		      CHANGED-P))
  (AND CHANGED-P (FUNCALL-SELF ':SET-CONFIGURATION 'ONLY))
  (FUNCALL-SELF ':TURN-OFF-ACCENTS)
  (FUNCALL-SELF ':SET-PANES-NAME 'NAME-BUTTON NEW-NAME)
  (FUNCALL-SELF ':SET-SELECTION-SUBSTITUTE NIL)
  (SYS:%USING-BINDING-INSTANCES (CLOSURE-BINDINGS EDITOR-CLOSURE))
  (LET ((*BATCH-UNDO-SAVE* T))
    (DELETE-INTERVAL *EDITOR-INTERVAL*)
    (INSERT-FORM-INTO-WINDOW
      `(DEFINE-FILTER ,(INTERN (STRING-UPCASE NEW-NAME)) (MSG)) -1))
  (DISCARD-UNDO-INFORMATION *EDITOR-INTERVAL*)
  (MUST-REDISPLAY *EDITOR-WINDOW* DIS-ALL)
  (FORMAT QUERY-IO "~&"))

))

; From file FILTER.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

;; This is sent when the window configuration is changed to :FILTER.
(DEFMETHOD (ZMAIL-FILTER-FRAME :INITIALIZE) (&AUX NEW-NAME CHANGED-P)
  (SETQ NEW-NAME (GENERATE-UNIQUE-NAME *USER-FILTER-ALIST*))
  (SETQ CHANGED-P (FUNCALL-SELF ':SET-PANES-ITEM-LIST 'KEYWORD-COMMAND-MENU
				(APPEND '(("Any" :VALUE ANY
					   :FONT FONTS:HL12BI :DOCUMENTATION
					   "Messages with any keyword on them."))
					*KEYWORD-ALIST*
					NIL)))
  (SETQ CHANGED-P (OR (FUNCALL-SELF ':SET-PANES-ITEM-LIST
				    'USER-FILTER-MENU (COPYLIST *USER-FILTER-ALIST*))
		      CHANGED-P))
  (AND CHANGED-P (FUNCALL-SELF ':SET-CONFIGURATION 'ONLY))
  (FUNCALL-SELF ':TURN-OFF-ACCENTS)
  (FUNCALL-SELF ':SET-PANES-NAME 'NAME-BUTTON NEW-NAME)
  (FUNCALL-SELF ':SET-SELECTION-SUBSTITUTE NIL)
  (SYS:%USING-BINDING-INSTANCES (CLOSURE-BINDINGS EDITOR-CLOSURE))
  (LET ((*BATCH-UNDO-SAVE* T))
    (DELETE-INTERVAL *EDITOR-INTERVAL*)
    (INSERT-FORM-INTO-WINDOW
      `(DEFINE-FILTER ,(INTERN (STRING-UPCASE NEW-NAME)) (MSG)) -1))
  (DISCARD-UNDO-INFORMATION *EDITOR-INTERVAL*)
  (MUST-REDISPLAY *EDITOR-WINDOW* DIS-ALL)
  (FORMAT QUERY-IO "~&"))

))
