;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 53.3
;;; Reason: Logical pathnames for mail files.
;;; Profile mode bug.  Prepare for Y-OR-N-P change.
;;; Written 12/12/83 23:40:12 by RMS,
;;; while running on Lisp Machine Nine from band 3
;;; with Bad Inconsistently updated System 98.6, CADR 3.1, Experimental ZMail 53.0, MIT-Specific 22.0, microcode 305, ZM MIT.



; From file FILTER.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "


(DEFUN FORMAT-DATE-FOR-FILTER (STRING)
  (DECLARE (RETURNS TIME-STRING RELATIVE-P))
  (MULTIPLE-VALUE-BIND (TIME RELATIVE-P)
      (CONDITION-CASE (ERROR)
	  (TIME:PARSE-UNIVERSAL-TIME STRING 0 NIL NIL)	;Parse it, assuming not in future
	(ERROR (BARF ERROR)))
    (IF (AND RELATIVE-P
	     (Y-OR-N-P "Do you want that time relative to when the filter is run?"))
	(VALUES STRING RELATIVE-P)
	(MULTIPLE-VALUE-BIND (SECONDS-OR-ERRMES MINUTES HOURS DAY MONTH YEAR)
	    (TIME:DECODE-UNIVERSAL-TIME TIME)
	  (AND ( YEAR 1900.) (< YEAR 2000.)
	       (SETQ YEAR (- YEAR 1900.)))
	  (FORMAT-DATE-FOR-FILTER-INTERNAL SECONDS-OR-ERRMES MINUTES HOURS DAY MONTH YEAR)))))

))

; From file FILTER.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "


(DEFUN GET-AND-COMPILE-FILTER (&AUX FILTER-PROP FILTER)
  (SETQ *TYPEOUT-WINDOW* (WINDOW-TYPEOUT-WINDOW *WINDOW*)
	TERMINAL-IO *TYPEOUT-WINDOW*)
  (FUNCALL *TYPEOUT-WINDOW* ':MAKE-COMPLETE)
  (SETQ FILTER-PROP (EVAL (READ-FROM-EDITOR-WINDOW)))
  (OR (AND (EQ (CAR FILTER-PROP) ':PROPERTY)
	   (EQ (CADDR FILTER-PROP) 'FILTER-FUNCTION))
      (BARF "Does not look like a filter definition"))
  (SETQ FILTER (CADR FILTER-PROP))
  (PUTPROP FILTER (GET FILTER 'FILTER-FUNCTION) 'EXPR-FILTER-FUNCTION)
  (COMPILE FILTER-PROP)
  (AND (FUNCALL *TYPEOUT-WINDOW* ':INCOMPLETE-P)	;If there are warning messages,
       (NOT (LET ((QUERY-IO *TYPEOUT-WINDOW*))
	      (Y-OR-N-P "Ok? ")))	;user has chance to not exit
       (ABORT-CURRENT-COMMAND))
  FILTER)

))

; From file PROFIL.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; PROFIL  "

(DEFMETHOD (ZMAIL-PROFILE-FRAME :AFTER :INIT) (IGNORE)
  (SYS:%USING-BINDING-INSTANCES (CLOSURE-BINDINGS EDITOR-CLOSURE))
  (INITIALIZE-TOP-LEVEL-EDITOR *PROFILE-EDITOR-WINDOW*)
  (ADD-INITIALIZATION "Reset zmail displayed user options"
		      `(FUNCALL ',(FUNCALL-SELF ':GET-PANE 'CHOOSE-WINDOW) ':SET-VARIABLES
				(TV:PRUNE-USER-OPTION-ALIST *ZMAIL-USER-OPTION-ALIST*))
		      '(SITE-OPTION)))

(DEFMETHOD (ZMAIL-PROFILE-FRAME :INITIALIZE) ()
  (UNLESS (SYMEVAL-IN-CLOSURE EDITOR-CLOSURE '*WINDOW*)
    (SYS:%USING-BINDING-INSTANCES (CLOSURE-BINDINGS EDITOR-CLOSURE))
    (INITIALIZE-TOP-LEVEL-EDITOR *PROFILE-EDITOR-WINDOW* T))
  (FUNCALL-SELF ':SEND-PANE 'CHOOSE-WINDOW ':SET-STACK-GROUP SYS:%CURRENT-STACK-GROUP)
  (FUNCALL-SELF ':TURN-OFF-ACCENTS))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFUN GET-ZMAIL-BUFFER-FROM-PATHNAME (PATHNAME &OPTIONAL CREATE-P)
  "Return the ZMAIL buffer visiting PATHNAME.
CREATE-P non-NIL says visit the file if there is none.
Otherwise return NIL in that case."
  (LET ((FS:*ALWAYS-MERGE-TYPE-AND-VERSION* T))
    (SETQ PATHNAME (FS:MERGE-PATHNAME-DEFAULTS PATHNAME *ZMAIL-PATHNAME-DEFAULTS*)))
  (COND ((DOLIST (ZMAIL-BUFFER *ZMAIL-BUFFER-LIST*)
	   (AND (ZMAIL-BUFFER-DISK-P ZMAIL-BUFFER)
		(EQ (FS:TRANSLATED-PATHNAME PATHNAME) (BUFFER-PATHNAME ZMAIL-BUFFER))
		(RETURN ZMAIL-BUFFER))))
	(CREATE-P
	 (ZMAIL-FIND-FILE-NOSELECT PATHNAME))))

))
