/*
   tapextract.c
   brad@heeltoe.com
  
   Copyright 1999, 2000 Eric Smith

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as published
   by the Free Software Foundation.  Note that permission is not granted
   to redistribute this program under the terms of any other version of the
   General Public License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "tapeio.h"
#include "stdio.h"
#include "stdarg.h"
#include "fcntl.h"

#define MAX_REC_LEN (32768*2)

char *progname;

void print_usage (FILE *f)
{
  fprintf (f, "Usage: %s in\n", progname);
}

void fatal (int retval, char *fmt, ...)
{
  va_list ap;

  if (fmt)
    {
      fprintf (stderr, "%s: ", progname);
      va_start (ap, fmt);
      vfprintf (stderr, fmt, ap);
      va_end (ap);
    }

  if (retval == 1)
    print_usage (stderr);

  exit (retval);
}

int main (int argc, char *argv[])
{
  int file = 0;
  int record = 0;
  unsigned long filebytes = 0;
  unsigned long tapebytes = 0;
  int len;
  char *srcfn = NULL;
  tape_handle src = NULL;
  char *buf;
  int ofd;
  char fn[256];

  progname = argv [0];

  while (++argv, --argc)
    {
      if ((argv [0][0] == '-') && (argv [0][1] != '\0'))
	{
	    fatal (1, "unrecognized option '%s'\n", argv [0]);
	}
      else if (! srcfn)
	srcfn = argv [0];
      else
	fatal (1, NULL);
    }

  if (! srcfn)
    fatal (1, NULL);

  buf = (char *) malloc (MAX_REC_LEN);
  if (! buf)
    fatal (2, "can't allocate buffer\n");

  src = opentape (srcfn, 0, 0);
  if (! src)
    fatal (3, "can't open source tape\n");

  ofd = 0;
  for (;;)
    {
      len = getrec (src, buf, MAX_REC_LEN);
      if (len == 0)
	{
	  printf ("total length of file %d = %d records, %d bytes\n",
		  file, record, filebytes);
	  tapebytes += filebytes;
	  close(ofd);
	  ofd = 0;
	  file++;
	  record = 0;
	  filebytes = 0;
	  printf ("start of file %d\n", file);
	  fflush (stdout);
	}
      else
	{
	  if (ofd == 0) {
		  sprintf(fn, "file%03d", file+1);
		  ofd = open(fn, O_RDWR | O_CREAT, 0666);
		  if (ofd < 0) {
			  perror(fn);
			  exit(1);
		  }
	  }

	  if (0) printf ("file %d record %d: length %d\n", file, record, len);
	  fflush (stdout);
	  write(ofd, buf, len);
	  filebytes += len;
	  record++;
	}
    }

  closetape (src);

  return (0);
}
