#!/bin/sh

cd tmp
rm -f files*

if [ ! -e 606.tap ]; then
    echo "uncompress 606"
    cp ../606.tap.gz .
    gunzip 606.tap.gz
fi

if [ ! -e 671.tap ]; then
    echo "uncompress 671"
    cp ../671.tap.gz .
    gunzip 671.tap.gz
fi

echo 606:
../tapeutils-0.4/tapeextract 606.tap >/dev/null
ls -l file*
mv file002 image-606
../read20/read20 -t -f image-606 >files.606

if [ ! -e extract-606 ]; then
    mkdir extract-606
fi

(cd extract-606; ../../read20/read20 -x -f ../image-606) >output-606

echo 671:
../tapeutils-0.4/tapeextract 671.tap >/dev/null
ls -l file*
mv file002 image-671
../read20/read20 -t -f image-671 >files.671

if [ ! -e extract-671 ]; then
    mkdir extract-671
fi

(cd extract-671; ../../read20/read20 -x -f ../image-671) >output-671

rm -f file0*

exit 0
