;;; -*- Mode:Lisp; Package:CADR; Base:8 -*-
;;; PHONEY LISP MACHINE MICROCODE -- CADR VERSION
;;;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;2/4/79 MODIFIED FOR CHANGES TO MAP-STATUS-CODE IN PAGE MAP 

;LISP MACHINE Q'S ARE REPRESENTED AS MACLISP FIXNUMS, CONTAINING
;THE SAME FIELDS.  EXCEPT, -1 MEANS PAGE INACCESSIBLE, AND AT SOME
;LEVELS -2 MEANS IN PDL BUFFER.

(DEFVAR QF-VIRTUAL-ADDR-KNOWN-ADDR)
(DEFVAR QF-VIRTUAL-ADDR-KNOWN-MAP)
(DEFVAR QF-VIRTUAL-ADDR-KNOWN-PHT1)
(DEFVAR QF-VIRTUAL-ADDR-KNOWN-PHT2)

(DEFVAR QF-AREA-ORIGIN-CACHE NIL
  "Alist of area name vs starting address of that area.  For fixed areas only.")
(DEFVAR QF-PAGE-PARTITION-CACHE NIL
  "Disk address of start of PAGE partition on debugged machine, or NIL.")
(DEFVAR QF-BAND-PARTITION-CACHE NIL
  "Disk address of start of loaded band on debugged machine, or NIL.
This is only relevant to the semi-working code that tries to debug
brand S systems that have been fast-booted.")
(DEFVAR QF-PAGE-BAND-FLAGS-CACHE NIL
  "/"page-band-flags/" from debugged machine, or NIL.
This is only relevant to the semi-working code that tries to debug
brand S systems that have been fast-booted.")
(DEFCONST QF-FINDCORE-TRACE-SWITCH NIL
  "T => trace times we must swap out a page on the debugged machine.")
(DEFVAR QF-PHT-CACHE :UNBOUND
  "List of ucode version, PHT limit, PHT mask; or NIL if not determined yet.")
(DEFCONST QF-PAGE-HASH-TABLE-EXTRA-CHECKING-FLAG NIL
  "T turns on extra error checking for manipulation of debugged machines PHT.")

(DEFVAR QF-CACHE-VERSION 0
  "Cached symbols are recorded with this number.
Incrementing this number therefore invalidates the cached data.")
(DEFVAR PHT-ADDR NIL "Address of page hash table in debugged machine; NIL if not yet known.")
(DEFVAR OLD-AREA-ORDER NIL
  "T if the order of fixed areas in debugged machine is the system-79-and-earlier order.")

(DEFUN QF-CLEAR-CACHE (IGNORE)
  "Called each time debugged machine has been run, to forget all cached data about it."
  (SETQ QF-AREA-ORIGIN-CACHE NIL)
  (INCF QF-CACHE-VERSION)
  (SETQ QF-PHT-CACHE NIL)
  (SETQ QF-PAGE-PARTITION-CACHE NIL)
  (SETQ QF-BAND-PARTITION-CACHE NIL)
  (SETQ QF-PAGE-BAND-FLAGS-CACHE NIL)
  (SETQ PHT-ADDR NIL)
  ;; Take this out after changes are debugged.
  ;; This is to catch failure to reinit these.
  ;; For actual use, it will be better to leave them as their last values
  ;; if the attempt to determine them fails.
  (SETQ %%QF-POINTER NIL
	%QF-POINTER-MASK NIL
	%%QF-BOXED-SIGN-BIT NIL
	%QF-PAGE-NUMBER-MASK NIL
	%%QF-PHT1-VIRTUAL-PAGE-NUMBER NIL
	%QF-POINTER-SANS-BOXED-SIGN-BIT-MASK NIL
	%%QF-DATA-TYPE NIL
	%%QF-CDR-CODE NIL
	%%QF-TYPED-POINTER NIL
	%QF-TYPED-POINTER-MASK NIL)
)

(DEFUN QF-SETUP-Q-FIELDS (&AUX WIDTH)
  (SETQ WIDTH (LDB 0020 (PHYS-MEM-READ (+ 400 %SYS-COM-POINTER-WIDTH))))
  (COND ((= WIDTH 25.)
	 ;; 25-bit pointers.
	 (SETQ %%QF-POINTER 0031
	       %QF-POINTER-MASK 177777777
	       %%QF-BOXED-SIGN-BIT 3001
	       %QF-PAGE-NUMBER-MASK 177777400
	       %%QF-PHT1-VIRTUAL-PAGE-NUMBER 1021
	       %QF-POINTER-SANS-BOXED-SIGN-BIT-MASK 77777777
	       %%QF-DATA-TYPE 3105
	       %%QF-CDR-CODE 3602
	       %%QF-TYPED-POINTER 0036
	       CC-SEXP-DESC CC-SEXP-DESC-25
	       CC-REG-ADDR-DESC CC-REG-ADDR-DESC-25
	       %QF-TYPED-POINTER-MASK 7777777777
	       CC-Q-DESC CC-Q-DESC-25))
	(T
	 ;; 24-bit pointers.
	 (SETQ %%QF-POINTER 0030
	       %QF-POINTER-MASK 77777777
	       %%QF-BOXED-SIGN-BIT 2701
	       %QF-PAGE-NUMBER-MASK 77777400
	       %%QF-PHT1-VIRTUAL-PAGE-NUMBER 1020
	       %QF-POINTER-SANS-BOXED-SIGN-BIT-MASK 37777777
	       %%QF-DATA-TYPE 3005
	       %%QF-CDR-CODE 3602
	       %%QF-TYPED-POINTER 0035
	       %QF-TYPED-POINTER-MASK 3777777777
	       CC-SEXP-DESC CC-SEXP-DESC-24
	       CC-REG-ADDR-DESC CC-REG-ADDR-DESC-24
	       CC-Q-DESC CC-Q-DESC-24)))
  (SETQ QF-NIL (DPB DTP-SYMBOL %%QF-DATA-TYPE 0)))

;(SETQ PHT-ADDR (* 5 400))
(DEFUN QF-SETUP-PHT-ADDR NIL
  (QF-SETUP-Q-FIELDS)
  (SETQ PHT-ADDR (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-PNTR))))
  (COND ((= PHT-ADDR (* 5 400))
	 (SETQ OLD-AREA-ORDER T))   ;pht-addr at 5 in old bands (79 and before)
	((= PHT-ADDR (* 9 400))
	 (SETQ OLD-AREA-ORDER NIL)) ;and 9 in new ones (83 and after)
	((= PHT-ADDR (* 13 400))
	 (SETQ OLD-AREA-ORDER NIL)) ;and 11. in newer ones (97 and after) but same area order.
	(T (SETQ PHT-ADDR NIL)
	   (FERROR NIL "Unable to figure out page table area; virtual memory access will not work."))))

(DEFUN QF-VIRTUAL-MEM-READ (VADR)
  "Returns contents of virtual address VADR of debugged machine, as bignum.
If the address is not in core, returns -1."
  ((LAMBDA (PADR)
	(COND ((= PADR -1) PADR)	;INACCESSIBLE
	      ((= PADR -2)		;IN PDL BUFFER
	       (CC-REGISTER-EXAMINE (QF-VIRTUAL-MEM-PDL-BUF-ADR VADR)))
	      ((PHYS-MEM-READ PADR))))
   (QF-VIRTUAL-MEM-MAP VADR NIL)))

(DEFUN QF-VIRTUAL-MEM-WRITE (VADR DATA)
  "Stores DATA, a bignum, in virtual address VADR of debugged machine.
Does nothing and returns -1 if page is not in core.
Otherwise the value is what was written, which is presumably positive."
  ((LAMBDA (PADR)
	(COND ((= PADR -1) PADR)	;INACCESSIBLE
	      ((= PADR -2)		;IN PDL BUFFER
	       (CC-REGISTER-DEPOSIT (QF-VIRTUAL-MEM-PDL-BUF-ADR VADR) DATA)
	       DATA)
	      (T (PHYS-MEM-WRITE PADR DATA)
		 DATA)))
   (QF-VIRTUAL-MEM-MAP VADR T)))

(DEFUN QF-VIRTUAL-MEM-PDL-BUF-ADR (ADR)
  (+ RAPBO
     (LOGAND 1777
	     (+ (- ADR (CC-SYMBOLIC-EXAMINE-REGISTER 'A-PDL-BUFFER-VIRTUAL-ADDRESS))
	        (CC-SYMBOLIC-EXAMINE-REGISTER 'A-PDL-BUFFER-HEAD)))))

(DEFUN QF-PAGE-HASH-TABLE-LOOKUP (ADR)	;RETURNS -1 OR PHYSICAL MEM ADR OF PHT1 WD
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (SETQ ADR (QF-POINTER ADR))		; OF HASH-TBL ENTRY FOR ADR
  (OR QF-PHT-CACHE (QF-REFILL-PHT-CACHE))
  (LET ((PHT-SIZE (CADR QF-PHT-CACHE)))
    (DECLARE (FIXNUM PHT-SIZE))
    (DO ((HASH (QF-COMPUTE-PAGE-HASH ADR) (+ HASH 2))
	 (PHT1)
	 (COUNT (LSH PHT-SIZE -1) (1- COUNT)))
	((= COUNT 0) -1)     ;INACESSIBLE (SHOULD NEVER HAPPEN, BUT AT LEAST DONT GET
			     ; INTO INFINITE LOOP IF HASH TABLE GETS OVER-FULL)
      (DECLARE (FIXNUM HASH PHT1 PHT2 COUNT))
      (AND (>= HASH PHT-SIZE) (SETQ HASH (- HASH PHT-SIZE)))
      (SETQ PHT1 (PHYS-MEM-READ (+ PHT-ADDR HASH)))
      (COND ((= 0 (LOGAND 100 PHT1))	;NO VALID BIT
	       (RETURN -1))		;NOT FOUND
	    ((= 0 (QF-MASK-PAGE-NUMBER (LOGXOR ADR PHT1)))  ;ADDRESS MATCH
	       (RETURN (+ PHT-ADDR HASH)))))))	;FOUND IT

;Linearly scan page hash table looking for info on given phys-adr.
(DEFUN QF-VIRT-ADR-OF-PHYS-ADR (PHYS-ADR)
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (DO ((PHYS-PAGE (ASH PHYS-ADR -10))
       (HASH-LOCN 0 (+ HASH-LOCN 2))
       (PHT1) (PHT2)
       (COUNT (LSH (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE))) -1)
	      (1- COUNT)))
      ((= COUNT 0) NIL)
    (COND ((AND (BIT-TEST 100 (SETQ PHT1 (PHYS-MEM-READ (+ PHT-ADDR HASH-LOCN))))
		(= PHYS-PAGE (LDB %%PHT2-PHYSICAL-PAGE-NUMBER
				  (SETQ PHT2 (PHYS-MEM-READ
					       (1+ (+ PHT-ADDR HASH-LOCN)))))))
	   (RETURN (+ (ASH (LDB %%QF-PHT1-VIRTUAL-PAGE-NUMBER PHT1) 10)
		      (LOGAND 377 PHYS-ADR)))))))
	   
(DEFUN QF-PAGE-HASH-TABLE-DELETE (ADR HOLE-POINTER)
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (PROG (LEAD-POINTER LEAD-POINTER-HASH-ADR LEAD-POINTER-VIRT-ADR
	 LIM PHT1 PHT2 PPDP MOVED-POINTER)
	(DECLARE (FIXNUM LEAD-POINTER LEAD-POINTER-HASH-ADR LEAD-POINTER-VIRT-ADR 
			 LIM PHT1 PHT2 MOVED-POINTER PPDP))
	(SETQ LIM (+ PHT-ADDR
		     (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE)))
		     -2))		;POINTS TO LAST VALID ENTRY
   L1	(PHYS-MEM-WRITE HOLE-POINTER (QF-MAKE-Q 0 DTP-FIX))	;FLUSH GUY FROM TABLE
	(SETQ LEAD-POINTER HOLE-POINTER)
   L2	(SETQ LEAD-POINTER (COND ((< LEAD-POINTER LIM) (+ LEAD-POINTER 2))
	 			 (T PHT-ADDR)))
	(SETQ PHT1 (PHYS-MEM-READ LEAD-POINTER))
	(COND ((= 0 (LOGAND 100 PHT1))
	       (OR QF-PAGE-HASH-TABLE-EXTRA-CHECKING-FLAG (RETURN T))
	       (AND (= 0 (CC-CHECK-PAGE-HASH-TABLE-ACCESSIBILITY)) (RETURN T))
	       (PRINT (LIST 'QF-PAGE-HASH-TABLE-DELETE-SCREW ADR LEAD-POINTER HOLE-POINTER
			    MOVED-POINTER))
	       (BREAK 'QF-PAGE-HASH-TABLE-DELETE-SCREW T)
	       (RETURN T)))				;BLANK ENTRY, THROUGH
	(SETQ LEAD-POINTER-VIRT-ADR (QF-MASK-PAGE-NUMBER PHT1))
	(SETQ LEAD-POINTER-HASH-ADR
	      (COND ((NOT (= LEAD-POINTER-VIRT-ADR (QF-MASK-PAGE-NUMBER -1)))
		     (+ PHT-ADDR (QF-COMPUTE-PAGE-HASH LEAD-POINTER-VIRT-ADR)))
		    (T HOLE-POINTER)))			;DUMMY ALWAYS HASHES TO HOLE ADDR
	(COND ((< LEAD-POINTER LEAD-POINTER-HASH-ADR) (GO L4))) ;WRAPAROUND CASE
	(COND ((OR (> LEAD-POINTER-HASH-ADR HOLE-POINTER)
		   (< LEAD-POINTER HOLE-POINTER))
	       (GO L2)))				;JUMP IF SHOULDN'T BE WHERE HOLE IS
   L6	(PHYS-MEM-WRITE HOLE-POINTER PHT1)		;SHOULD BE WHERE HOLE IS, MOVE IT 
	(PHYS-MEM-WRITE (1+ HOLE-POINTER) (SETQ PHT2 (PHYS-MEM-READ (1+ LEAD-POINTER))))
	(SETQ PPDP (+ (LOGLDB-FROM-FIXNUM %%PHT2-PHYSICAL-PAGE-NUMBER PHT2)
		      (QF-INITIAL-AREA-ORIGIN 'PHYSICAL-PAGE-DATA)))
	(PHYS-MEM-WRITE PPDP (LOGDPB-INTO-FIXNUM (- HOLE-POINTER PHT-ADDR) 0020
						 (PHYS-MEM-READ PPDP)))
	(SETQ MOVED-POINTER HOLE-POINTER)		;FOR DEBUGGING, WHERE THING MOVED TO
	(SETQ HOLE-POINTER LEAD-POINTER)
	(GO L1)
   L4	(COND ((OR (<= LEAD-POINTER-HASH-ADR HOLE-POINTER)
		   (>= LEAD-POINTER HOLE-POINTER))
	       (GO L6)))				;JUMP IF SHOULD BE WHERE HOLE IS
	(GO L2)
))

(DEFVAR LAST-MAPPED-VIRTUAL-PAGE NIL)
(DEFVAR LAST-MAPPED-PHYSICAL-PAGE NIL)

(DEFUN QF-REFILL-PHT-CACHE ()
 (LET ((PHT-SIZE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE)))))
   (DECLARE (FIXNUM PHT-SIZE))
   (LET ((PHT-MASK (- (LSH 1 (HAULONG PHT-SIZE)) 2)))
     (DECLARE (FIXNUM PHT-MASK))
     (SETQ LAST-MAPPED-VIRTUAL-PAGE NIL
	   LAST-MAPPED-PHYSICAL-PAGE NIL)
     (SETQ QF-PHT-CACHE (LIST (QF-POINTER (CC-SYMBOLIC-EXAMINE-REGISTER 'A-VERSION))
			      PHT-SIZE
			      PHT-MASK)))))

(DEFUN QF-COMPUTE-PAGE-HASH (ADR)
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (OR QF-PHT-CACHE (QF-REFILL-PHT-CACHE))
  (LET ((PHT-SIZE (CADR QF-PHT-CACHE)) (PHT-MASK (CADDR QF-PHT-CACHE)))
   (DECLARE (FIXNUM PHT-SIZE PHT-MASK))
   (LET ((HASH (LOGAND (LOGXOR (ASH (QF-POINTER ADR) -16)
			       (LOGAND 777760 (LOGLDB 0424 ADR)))
		       PHT-MASK)))
     (DECLARE (FIXNUM HASH))
     (AND (>= HASH PHT-SIZE) (SETQ HASH (- HASH PHT-SIZE)))
     HASH)))

(DEFUN QF-VIRTUAL-MEM-MAP (ADR WRITE-CYCLE)
 (SETQ ADR (QF-POINTER ADR))		;FLUSH DATA TYPE ETC.
 (COND ((< ADR (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-WIRED-SIZE))))
	ADR)
       ((EQ (ASH ADR -8) LAST-MAPPED-VIRTUAL-PAGE)
	(+ (LOGAND 377 ADR) (ASH LAST-MAPPED-PHYSICAL-PAGE 8)))
       (T (OR QF-PHT-CACHE (QF-REFILL-PHT-CACHE))
	  (LET ((PHT-SIZE (CADR QF-PHT-CACHE))
		POSSIBLE-PDL-BUFFER-PAGE)
	    (DECLARE (FIXNUM PHT-SIZE))
	    (DO ((HASH (QF-COMPUTE-PAGE-HASH ADR) (+ HASH 2))
		 (PHT1)
		 (PHT2)
		 (TEM)(STS)
		 (COUNT (LSH PHT-SIZE -1) (1- COUNT)))
		((= COUNT 0) -1)			;INACCESSIBLE
	      (DECLARE (FIXNUM HASH PHT1 PHT2 COUNT TEM STS))
	      (AND (>= HASH PHT-SIZE) (SETQ HASH (- HASH PHT-SIZE)))
	      (SETQ PHT1 (PHYS-MEM-READ (+ PHT-ADDR HASH)))
	      (COND ((= 0 (LOGAND 100 PHT1))		;NO VALID BIT
		     (RETURN -1))			;INACCESSIBLE
		    ((= 0 (QF-MASK-PAGE-NUMBER (LOGXOR ADR PHT1)))	;ADDRESS MATCH
		     (SETQ STS (LOGAND 7 PHT1))		;ISOLATE SWAP STATUS CODE
		     (COND ((OR (= STS 0)		;UNUSED ENTRY
				(= STS 6)		;UNUSED CODES
				(= STS 7))
			    (ERROR 'BAD-PAGE-HASH-ENTRY-AT-ADR HASH 'FAIL-ACT)))
		     (SETQ PHT2 (PHYS-MEM-READ (+ PHT-ADDR HASH 1)))	;IN CORE, GET ADDRESS
		     (WHEN (= 5 (LOGLDB-FROM-FIXNUM
				  %%PHT2-MAP-STATUS-CODE PHT2))	;MAY BE IN PDL-BUFFER
		       (SETQ POSSIBLE-PDL-BUFFER-PAGE T)
		       (WHEN (AND (NOT (< ADR (SETQ TEM (QF-POINTER
							  (CC-SYMBOLIC-EXAMINE-REGISTER 
							    'A-PDL-BUFFER-VIRTUAL-ADDRESS)))))
				  (<= ADR (+ TEM
					     (LOGAND 1777 
						     (- (CC-SYMBOLIC-EXAMINE-REGISTER 'PP)
							(CC-SYMBOLIC-EXAMINE-REGISTER 'a-pdl-buffer-head))))))
			 (RETURN -2)))		;IN PDL-BUFFER
				;IF DOING A WRITE-CYCLE INTO A PAGE, SET PHT1-MODIFIED BIT
				;THIS HOPEFULLY ASSURES PAGE WILL GET WRITTEN ON DISK IF IT
				;GETS SWAPPED OUT, EVEN IF THE ACCESS IS NOT READ/WRITE.
		     (COND (WRITE-CYCLE
			    (PHYS-MEM-WRITE (+ PHT-ADDR HASH)
					    (LOGDPB-INTO-FIXNUM 1 %%PHT1-MODIFIED-BIT PHT1))))
		     (UNLESS POSSIBLE-PDL-BUFFER-PAGE
		       (SETQ LAST-MAPPED-PHYSICAL-PAGE
			     (LOGLDB-FROM-FIXNUM %%PHT2-PHYSICAL-PAGE-NUMBER PHT2)
			     LAST-MAPPED-VIRTUAL-PAGE
			     (ASH ADR -8)))
		     (RETURN (+ (ASH (LOGLDB-FROM-FIXNUM %%PHT2-PHYSICAL-PAGE-NUMBER PHT2) 8)
				(LOGAND 377 ADR))))))))))

(DEFUN QF-FINDCORE ()	;CALL TO OBTAIN FREE PAGE OF CONS MEMORY. SWAP ONE OUT IF NECC, ETC.
			;DOESN'T WORK SAME WAY AS MICROCODE ANY MORE
  (DECLARE (FIXNUM PTR LIM PHT1 PHT2 TEM PHTSIZE N))
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (PROG (PTR LIM PHT1 PHT2 TEM PHTSIZE N)
	(SETQ PHTSIZE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE))))
	(SETQ LIM (+ PHT-ADDR PHTSIZE -2))	;POINTS AT HIGHEST ENTRY
	(SETQ N 100.)				;Number of probes before giving up
	;; Poking around at the other machine's page table is very slow, especially
	;; if you do it wrong.  So just pick a random page and swap it out
	;; if it isn't wired.
   PROBE
	(SETQ PTR (+ PHT-ADDR (* (RANDOM (TRUNCATE PHTSIZE 2)) 2)))
	(SETQ PHT1 (PHYS-MEM-READ PTR))
	(SETQ TEM (LOGLDB-FROM-FIXNUM %%PHT1-SWAP-STATUS-CODE PHT1))
	(COND ((OR (= TEM %PHT-SWAP-STATUS-NORMAL)
		   (= TEM %PHT-SWAP-STATUS-FLUSHABLE)
		   (= TEM %PHT-SWAP-STATUS-AGE-TRAP))
	       (GO CF)))
	(OR (ZEROP (SETQ N (1- N))) (GO PROBE))
	(ERROR 'QF-FINDCORE 'NOTHING-TO-SWAP-OUT 'FAIL-ACT)

   CF	(SETQ PHT2 (PHYS-MEM-READ (1+ PTR)))
	(AND QF-FINDCORE-TRACE-SWITCH
	     (PRINT (LIST 'QF-FINDCORE 'PTR PTR 'PHT1 PHT1 'PHT2 PHT2)))
	(SETQ TEM (LOGLDB-FROM-FIXNUM %%PHT2-MAP-STATUS-CODE PHT2))
	(COND ((OR (= TEM %PHT-MAP-STATUS-READ-WRITE)
		   (NOT (ZEROP (LOGLDB %%PHT1-MODIFIED-BIT PHT1))))
	       (CC-DISK-WRITE (QF-GET-DISK-ADR
			       (LOGLDB-FROM-FIXNUM %%QF-PHT1-VIRTUAL-PAGE-NUMBER PHT1))
			      (LOGLDB-FROM-FIXNUM %%PHT2-PHYSICAL-PAGE-NUMBER PHT2)
			      1)))	;NUMBER PAGES
	(COND ((NULL (QF-PAGE-HASH-TABLE-DELETE (QF-MASK-PAGE-NUMBER PHT1) PTR))
	       (ERROR 'QF-FINDCORE 'HASH-SCREWUP 'FAIL-ACT)))	
	;DELETE FROM REAL MACHINE'S MAP
	(COND ((= (SETQ TEM (CC-REGISTER-EXAMINE (+ RAM1O (LOGLDB-FROM-FIXNUM 1513 PHT1))))
		   37)
		(GO X)))	;LVL 1 MAP NOT SET, OK
	(SETQ TEM (+ (ASH TEM 5)
		     (LOGLDB-FROM-FIXNUM 0805 PHT1)
		     RAM2O))
	(CC-REGISTER-DEPOSIT TEM 0)		; CHANGE TO MAP NOT SET UP (ZERO)
    X	(RETURN (LOGLDB-FROM-FIXNUM %%PHT2-PHYSICAL-PAGE-NUMBER PHT2))
))

(DEFVAR QF-SWAP-IN-LOOP-CHECK NIL
  "Detects recursive calls to QF-SWAP-IN, for errors.")

;SWAP IN PAGE AT ADR
(DEFUN QF-SWAP-IN (ADR)
  (SETQ LAST-MAPPED-PHYSICAL-PAGE NIL
	LAST-MAPPED-VIRTUAL-PAGE NIL)
  (SETQ ADR (QF-POINTER ADR))				;FLUSH DATA TYPE ETC.
  (IF (NULL PHT-ADDR) (QF-SETUP-PHT-ADDR))
  (AND QF-SWAP-IN-LOOP-CHECK
       (ERROR ADR '|QF-SWAP-IN INVOKED RECURSIVELY| 'FAIL-ACT))
  (OR (< (QF-PAGE-HASH-TABLE-LOOKUP ADR) 0)
      (ERROR ADR '|ALREADY SWAPPED IN - QF-SWAP-IN| 'FAIL-ACT))
  (PROG (PHYS-PAGE REGION-NUMBER ACCESS-STATUS-AND-META-BITS QF-SWAP-IN-LOOP-CHECK)
    (DECLARE (FIXNUM PHYS-PAGE REGION-NUMBER ACCESS-STATUS-AND-META-BITS))
    (SETQ QF-SWAP-IN-LOOP-CHECK T)
    (SETQ REGION-NUMBER (QF-REGION-NUMBER-OF-POINTER ADR))
    (SETQ ACCESS-STATUS-AND-META-BITS
	  (LOGLDB-FROM-FIXNUM %%REGION-MAP-BITS
			      (PHYS-MEM-READ (+ REGION-NUMBER
						(QF-INITIAL-AREA-ORIGIN 
						 'REGION-BITS)))))
    (SETQ PHYS-PAGE (QF-FINDCORE))
    (CC-DISK-READ (QF-GET-DISK-ADR (LOGLDB-FROM-FIXNUM %%QF-PHT1-VIRTUAL-PAGE-NUMBER ADR))
		  PHYS-PAGE
		  1)
    (OR QF-PHT-CACHE (QF-REFILL-PHT-CACHE))
    (LET ((PHT-SIZE (CADR QF-PHT-CACHE)))
      (DECLARE (FIXNUM PHT-SIZE))
      (DO ((HASH (QF-COMPUTE-PAGE-HASH ADR) (+ HASH 2))
	   (PHT1)
	   (COUNT (LSH PHT-SIZE -1) (1- COUNT)))
	  ((= COUNT 0)  ;UGH FINDCORE SHOULD HAVE DELETED
	   (ERROR 'QF-SWAP-IN 'PAGE-HASH-TABLE-FULL 'FAIL-ACT))
	(DECLARE (FIXNUM HASH PHT1 PHT2 COUNT))
	(AND (>= HASH PHT-SIZE) (SETQ HASH (- HASH PHT-SIZE)))
	(SETQ PHT1 (PHYS-MEM-READ (+ PHT-ADDR HASH)))
	(COND ((= 0 (LOGAND 100 PHT1))			;FOUND HOLE TO PUT NEW PHTE IN
	       (PHYS-MEM-WRITE (+ PHT-ADDR HASH)
			       (QF-MAKE-Q (+ 101 (QF-MASK-PAGE-NUMBER ADR)) DTP-FIX))
	       (PHYS-MEM-WRITE (+ PHT-ADDR HASH 1)
		 (QF-MAKE-Q (LOGDPB-INTO-FIXNUM ACCESS-STATUS-AND-META-BITS 
						%%PHT2-ACCESS-STATUS-AND-META-BITS 
						(LOGDPB-INTO-FIXNUM PHYS-PAGE
						  %%PHT2-PHYSICAL-PAGE-NUMBER
						  0))
			    DTP-FIX))
	       (PHYS-MEM-WRITE (+ PHYS-PAGE (QF-INITIAL-AREA-ORIGIN 'PHYSICAL-PAGE-DATA))
			       HASH)
	       (OR QF-PAGE-HASH-TABLE-EXTRA-CHECKING-FLAG (RETURN T))
	       (AND (= 0 (CC-CHECK-PAGE-HASH-TABLE-ACCESSIBILITY)) (RETURN T))
	       (PRINT (LIST 'QF-SWAP-IN-SCREW ADR HASH COUNT))
	       (BREAK 'QF-SWAP-IN-SCREW T)
	       (RETURN T))))))
;  (SETQ QF-VIRTUAL-ADDR-KNOWN-ADDR -1)			;FORGET OUR COPY OF THE MAP
)

(DEFUN QF-GET-DISK-ADR (VIRTUAL-PAGE-NUMBER)
  (LET ((A-VERSION (QF-POINTER (CC-SYMBOLIC-EXAMINE-REGISTER 'A-VERSION))))
    (OR QF-PAGE-PARTITION-CACHE
      (LET ((SYMBOL-VERSION (CC-LOOKUP-NAME 'VERSION-NUMBER)))
	(WHEN (AND ( A-VERSION SYMBOL-VERSION)
		   (FQUERY NIL "~&Microcode ~D is running but you have the symbols for ~D;
Type Y to load correct symbols, N to proceed anyway. "
			   A-VERSION SYMBOL-VERSION))
	  (CC-LOAD-UCODE-SYMBOLS-FOR-VERSION A-VERSION)
	  (QF-SETUP-Q-FIELDS))
	(IF (< A-VERSION 890.)
	    (SETQ QF-PAGE-PARTITION-CACHE (CC-SYMBOLIC-EXAMINE-REGISTER 'A-DISK-OFFSET))
	  (SETQ QF-PAGE-PARTITION-CACHE (CC-SYMBOLIC-EXAMINE-REGISTER 'A-PAGE-OFFSET))
	  (SETQ QF-BAND-PARTITION-CACHE (CC-SYMBOLIC-EXAMINE-REGISTER 'A-BAND-OFFSET)))))
  (+ VIRTUAL-PAGE-NUMBER
     (IF (AND (>= A-VERSION 890.)   ;patched by RG. 79 loses without this.
	      (QF-PAGE-IN-BAND VIRTUAL-PAGE-NUMBER))
	 QF-BAND-PARTITION-CACHE
	 QF-PAGE-PARTITION-CACHE))))

(DEFUN QF-PAGE-IN-BAND-WORD (PAGE)
  (PROG ()
    (OR QF-PAGE-BAND-FLAGS-CACHE
	(LET ((A-VERSION (QF-POINTER (CC-SYMBOLIC-EXAMINE-REGISTER 'A-VERSION))))
	  (IF (< A-VERSION 890.)
	      (RETURN (VALUES NIL 0)))
	  (SETQ QF-PAGE-BAND-FLAGS-CACHE
		(QF-POINTER (CC-SYMBOLIC-EXAMINE-REGISTER 'A-V-PAGE-BAND-FLAGS)))))
    (LET ((ADR (+ (LSH PAGE -5) QF-PAGE-BAND-FLAGS-CACHE)))
      ;; Wired
      (RETURN (VALUES (QF-VIRTUAL-MEM-READ ADR) ADR)))))

(DEFUN QF-PAGE-IN-BAND (PAGE)
  (LDB-TEST (+ 0001 (LSH (LOGAND PAGE 37) 6)) (QF-PAGE-IN-BAND-WORD PAGE)))

(DEFUN QF-CLEAR-PAGE-IN-BAND (PAGE)
  (MULTIPLE-VALUE-BIND (WORD ADR)
      (QF-PAGE-IN-BAND-WORD PAGE)
    ;; Wired
    (AND ADR (QF-VIRTUAL-MEM-WRITE ADR (DPB 0 (+ 0001 (LSH (LOGAND PAGE 37) 6)) WORD)))))

;THIS READS ANY KIND OF MEMORY WHETHER OR NOT IT IS SWAPPED OUT
(DEFUN QF-MEM-READ (ADR)
  "Return contents of virtual memory address ADR as a bignum, swapping if necessary."
  (PROG (DATA)
    (DECLARE (FIXNUM DATA))
    (SETQ DATA (QF-VIRTUAL-MEM-READ ADR))
    (COND ((< DATA 0)
	   (QF-SWAP-IN ADR)
	   (SETQ DATA (QF-VIRTUAL-MEM-READ ADR))))
    (AND (< DATA 0)
	 (ERROR 'QF-MEM-READ-INACCESSIBLE ADR 'FAIL-ACT))
    (RETURN DATA)))

(DEFUN QF-MEM-READ-TRANSPORT (ADR)
  "Return contents of memory address ADR as a bignum, swapping or forwarding if nec."
  (LET (DATA)
    (DECLARE (FIXNUM DATA))
    (SETQ DATA (QF-VIRTUAL-MEM-READ ADR))
    (COND ((< DATA 0)
	   (QF-SWAP-IN ADR)
	   (SETQ DATA (QF-VIRTUAL-MEM-READ ADR))))
    (AND (< DATA 0)
	 (ERROR 'QF-MEM-READ-INACCESSIBLE ADR 'FAIL-ACT))
    (SELECT (QF-DATA-TYPE DATA)
      ((DTP-GC-FORWARD DTP-ONE-Q-FORWARD DTP-HEADER-FORWARD DTP-EXTERNAL-VALUE-CELL-POINTER)
       (QF-MEM-READ-TRANSPORT DATA))
      (DTP-BODY-FORWARD
       (QF-MEM-READ-TRANSPORT (+ (QF-POINTER (- ADR DATA))
				 (QF-MEM-READ DATA))))
      (T DATA))))

;return disk contents whether swapped in or not.
(DEFUN QF-MEM-READ-DISK-COPY (ADR)
  (PROG (DATA)
	(DECLARE (FIXNUM DATA))
	(CC-DISK-INIT)
	(CC-DISK-WRITE 1 CC-DISK-LOWCORE 1)		;Save on block 1
	(CC-DISK-READ (QF-GET-DISK-ADR (LOGLDB-FROM-FIXNUM %%QF-PHT1-VIRTUAL-PAGE-NUMBER ADR))
		      CC-DISK-LOWCORE
		      1)
	(SETQ DATA (PHYS-MEM-READ (DPB CC-DISK-LOWCORE %%QF-PHT1-VIRTUAL-PAGE-NUMBER ADR)))
	(CC-DISK-READ 1 CC-DISK-LOWCORE 1)		;Restore saved core
	(RETURN DATA)
	))

(DEFUN QF-MEM-WRITE (ADR DATA)
  "Stores DATA, a positive bignum, into virt address ADR of debugged machine.
Swaps in ADR if necessary."
  (COND ((< (QF-VIRTUAL-MEM-WRITE ADR DATA) 0)
	 (QF-SWAP-IN ADR)
	 (AND (< (QF-VIRTUAL-MEM-WRITE ADR DATA) 0)
	      (ERROR 'QF-MEM-WRITE-INACCESSIBLE ADR 'FAIL-ACT)))))

(DEFUN QF-AREA-NUMBER-OF-POINTER (PNTR)
  (DO ((REGION (QF-REGION-NUMBER-OF-POINTER PNTR)
	       (QF-POINTER (QF-MEM-READ (+ REGION-THREAD REGION))))
       (REGION-THREAD (QF-INITIAL-AREA-ORIGIN 'REGION-LIST-THREAD)))
      ((NOT (ZEROP (LOGAND (ASH 1 (1- %%QF-POINTER)) REGION)))
       (LOGAND (1- (ASH 1 (1- %%QF-POINTER))) REGION))))

;GIVEN A POINTER RETURN THE NUMBER OF THE REGION IT IS IN
;LIKE %REGION-NUMBER ON THE REAL MACHINE

(DEFUN QF-REGION-NUMBER-OF-POINTER (PNTR)
  (SETQ PNTR (QF-POINTER PNTR))
  (LET ((QUANTUM (TRUNCATE PNTR %ADDRESS-SPACE-QUANTUM-SIZE))
	(BYTES-PER-WORD (TRUNCATE 32. %ADDRESS-SPACE-MAP-BYTE-SIZE)))
    (DECLARE (FIXNUM QUANTUM BYTES-PER-WORD))
    (LET ((WORD (PHYS-MEM-READ (+ (QF-INITIAL-AREA-ORIGIN 'ADDRESS-SPACE-MAP)
				  (TRUNCATE QUANTUM BYTES-PER-WORD)))))
      (DECLARE (FIXNUM WORD))
      (SETQ WORD (LOGAND (1- (LSH 1 %ADDRESS-SPACE-MAP-BYTE-SIZE))
			 (#M LSH #Q ASH WORD (- (* (\ QUANTUM BYTES-PER-WORD)
						   %ADDRESS-SPACE-MAP-BYTE-SIZE)))))
      (COND ((NOT (ZEROP WORD)) WORD)
	    (T (DO ((L (QF-INITIAL-AREA-LIST) (CDR L))
		    (I 0 (1+ I)))
		   ((OR (NULL L) (EQ (CAR L) 'WORKING-STORAGE-AREA))
		    (ERROR PNTR '|NOT IN ANY REGION - QF-REGION-NUMBER-OF-POINTER| 'FAIL-ACT))
		 (AND (< PNTR (QF-INITIAL-AREA-ORIGIN (CADR L)))
		      (RETURN I))))))))

;;; OBARRAY STUFF

;Symbol in this machine in; returns a symbol in debugged machine, as fixnum,
;or -1 if symbol does not exist.
(DEFUN QF-SYMBOL (THIS-MACHINE-SYMBOL)
  (COND ((AND (EQ (GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-POINTER-VERSION)
		  QF-CACHE-VERSION)
	      (LET ((PACK (PHYS-MEM-READ (+ 400 %SYS-COM-OBARRAY-PNTR))))
		(EQ PACK (GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-PACKAGE)))
	      (GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-POINTER)))
	(T (QF-SYMBOL-INTERNAL THIS-MACHINE-SYMBOL
			       (QF-FIND-PACKAGE
				 (INTERN (PACKAGE-NAME
					   (SYMBOL-PACKAGE THIS-MACHINE-SYMBOL))))
			       THIS-MACHINE-SYMBOL))))

(DEFUN QF-CURRENT-PACKAGE ()
  "Returns the debugged machine's current package (as a number)."
  (LET ((PKG (PHYS-MEM-READ (+ 400 %SYS-COM-OBARRAY-PNTR))))
    (DO () ((OR (NOT (= (QF-DATA-TYPE PKG) DTP-SYMBOL))
		(= PKG QF-NIL)))
      (SETQ PKG (QF-VALUE-CELL-CONTENTS PKG)))
    PKG))

(DEFUN QF-SYMBOL1 (THIS-MACHINE-SYMBOL PACK)
    (COND ((AND (EQ (GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-POINTER-VERSION)
		    QF-CACHE-VERSION)
		(EQ PACK (GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-PACKAGE))
		(GET THIS-MACHINE-SYMBOL 'REAL-MACHINE-ATOM-HEADER-POINTER)))
	  (T (QF-SYMBOL-INTERNAL THIS-MACHINE-SYMBOL PACK THIS-MACHINE-SYMBOL))))

(DEFUN QF-SYMBOL-INTERNAL (PNAME PACK THIS-MACHINE-SYMBOL)
  (DECLARE (FIXNUM PACK))
  (COND ((= (QF-DATA-TYPE PACK) DTP-SYMBOL)
	 (SETQ PACK (QF-VALUE-CELL-CONTENTS PACK))))
  (QF-SYMBOL-SEARCH PNAME PACK THIS-MACHINE-SYMBOL))

;; T if PACK is a package (old-style or new-style), NIL for old-style obarray.
(DEFUN QF-OBARRAY-NEW-P (PACK)
  T)

;; In a new-style package, this is its NAME.
(DEFUN QF-PKG-NAME (PACK)
  (IF (EQ (QF-DATA-TYPE PACK) DTP-SYMBOL)
      (QF-MAKE-Q (QF-MEM-READ-TRANSPORT PACK) DTP-ARRAY-POINTER)
    (QF-ARRAY-LEADER PACK 2)))

;; In a new-style package, this is a list (possibly NIL) of nicknames (strings).
;; In an old-style package, it happens to be a string.
(DEFUN QF-PKG-NICKNAMES (PACK)
  (QF-ARRAY-LEADER PACK 3))

;; In an old style package, this is the superpackage.
;; In a new-style common lisp package, this is a list
;; of packages to inherit from, nonrecursively.
(DEFUN QF-PKG-SUPER-PACKAGE (PACK)
  (IF (= (QF-DATA-TYPE PACK) DTP-ARRAY-POINTER)
      (QF-ARRAY-LEADER PACK 4)
    QF-NIL))					;Can happen if before packages are set up.

;; In a new style package, this slot points to the symbol *ALL-PACKAGES*.
(DEFUN QF-PKG-ALL-PACKAGES-POINTER (PACK)
  (QF-ARRAY-LEADER PACK 5))

;; Used in old-style packages only.
(DEFUN QF-PKG-REFNAME-ALIST (PACK)
  (QF-ARRAY-LEADER PACK 0))

(DEFUN QF-PKG-NUMBER-OF-SLOTS (PACK)
  (ASH (QF-ARRAY-LENGTH PACK) -1))

;SEARCH A SPECIFIED PACKAGE AND ITS SUPERIORS FOR A SYMBOL.
(DEFUN QF-SYMBOL-SEARCH (SYM PACK THIS-MACHINE-SYMBOL)
  (IF (= (QF-DATA-TYPE (QF-PKG-SUPER-PACKAGE PACK))
	 DTP-ARRAY-POINTER)
      (DO ((PKG PACK (QF-PKG-SUPER-PACKAGE PKG))
	   (TEM))
	  ((QF-NULL PKG) -1)
	(SETQ TEM (QF-SYMBOL-PKG SYM PKG THIS-MACHINE-SYMBOL))
	(OR (= TEM -1) (RETURN TEM)))
    ;; New style package with list of other packages to inherit from.
    (LET ((TEM (QF-SYMBOL-PKG SYM PACK THIS-MACHINE-SYMBOL)))
      (IF ( TEM -1) TEM
	(DO ((PKGS (QF-PKG-SUPER-PACKAGE PACK) (QF-CDR PKGS)))
	    ((QF-NULL PKGS) -1)
	  (LET* ((PKG (QF-CAR PKGS))
		 (TEM (QF-SYMBOL-PKG SYM PKG THIS-MACHINE-SYMBOL T)))
	    (OR (= TEM -1) (RETURN TEM))))))))

;LOOK A SYMBOL UP IN A NEW-STYLE OBARRAY.
(DEFUN QF-SYMBOL-PKG (SYM PACK THIS-MACHINE-SYMBOL &OPTIONAL EXTERNAL-ONLY)
    (DECLARE (FIXNUM PACK))
    (DO () ((NOT (= DTP-HEADER-FORWARD (QF-DATA-TYPE (QF-MEM-READ PACK)))))
      (SETQ PACK (QF-MAKE-Q (QF-POINTER (QF-MEM-READ PACK)) DTP-ARRAY-POINTER)))
    (LET ((HASH (QF-PKG-HASH-STRING SYM))
	  (LEN (QF-PKG-NUMBER-OF-SLOTS PACK))
	  (HASH1 0))
	 (DO ((I (\ HASH LEN) (\ (1+ I) LEN)))
	     (NIL)
	   (SETQ HASH1 (QF-PKG-AR-2 PACK 0 I))
	   (AND (QF-NULL HASH1) (RETURN -1))
	   (AND (= HASH (QF-POINTER-SANS-BOXED-SIGN-BIT HASH1))
		(OR (NOT EXTERNAL-ONLY)
		    (NOT (ZEROP (ASH (QF-POINTER HASH1) (- 1 %%QF-POINTER)))))
		(QF-SAMEPNAMEP SYM (QF-PKG-AR-2 PACK 1 I))
		(PROGN
		  (PUTPROP THIS-MACHINE-SYMBOL QF-CACHE-VERSION
			   'REAL-MACHINE-ATOM-HEADER-POINTER-VERSION)
		  (PUTPROP THIS-MACHINE-SYMBOL PACK
			   'REAL-MACHINE-ATOM-HEADER-PACKAGE)
		  (RETURN
		    (PUTPROP
		      THIS-MACHINE-SYMBOL
		      (QF-PKG-AR-2 PACK 1 I)
		      'REAL-MACHINE-ATOM-HEADER-POINTER)))))))

(DEFUN QF-PKG-AR-2 (Q I J)
  (QF-ARRAY-SETUP Q)
  (QF-TYPED-POINTER (QF-ARRAY-READ 
     (QF-ARRAY-DISPLACE
        (+ (* J 2)
	   I)))))

(DEFUN QF-FIND-PACKAGE (MSYMBOL)
    (COND ((AND (EQ (GET MSYMBOL 'REAL-MACHINE-PACKAGE-POINTER-VERSION)
		    QF-CACHE-VERSION)
		(GET MSYMBOL 'REAL-MACHINE-PACKAGE-POINTER)))
	  (T
	   (LET ((PACK (PHYS-MEM-READ (+ 400 %SYS-COM-OBARRAY-PNTR))))
	     (COND ((= (QF-DATA-TYPE PACK) DTP-SYMBOL)
		    (SETQ PACK (QF-VALUE-CELL-CONTENTS PACK))))
	     (IF (= (QF-DATA-TYPE PACK) DTP-NULL) -1
	       (IF (= (QF-DATA-TYPE (QF-PKG-SUPER-PACKAGE PACK)) DTP-ARRAY-POINTER)
		   ;; Old style packages.
		   (PROGN
		     (DO ((P (QF-PKG-SUPER-PACKAGE PACK) (QF-PKG-SUPER-PACKAGE P)))
			 ((NOT (= (QF-DATA-TYPE P) DTP-ARRAY-POINTER)))
		       (SETQ PACK P))
		     (DO ((R-ALIST (QF-PKG-REFNAME-ALIST PACK) (QF-CDR R-ALIST))
			  (THIS-CONS))
			 ((QF-NULL R-ALIST) -1)
		       (SETQ THIS-CONS (QF-CAR R-ALIST))
		       (COND ((QF-LMSTRING-MSYMBOL-EQUAL (QF-CAR THIS-CONS) MSYMBOL)
			      (LET ((ANSWER (QF-CAR (QF-CDR THIS-CONS))))
				(PUTPROP MSYMBOL ANSWER 'REAL-MACHINE-PACKAGE-POINTER)
				(PUTPROP MSYMBOL QF-CACHE-VERSION
					 'REAL-MACHINE-PACKAGE-POINTER-VERSION)
				(RETURN ANSWER))))))
		 ;; New style.  Just look on *ALL-PACKAGES*.
		 ;; We do not allow local nicknames.
		 (LET* ((ALL-PACK-SYM (QF-PKG-ALL-PACKAGES-POINTER PACK))
			(ALL-PACK-LIST (QF-MEM-READ-TRANSPORT (1+ ALL-PACK-SYM))))
		   (DO ((LIST ALL-PACK-LIST (QF-CDR LIST)))
		       ((QF-NULL LIST) -1)
		     (LET ((P (QF-CAR LIST)))
		       (WHEN (OR (QF-LMSTRING-MSYMBOL-EQUAL (QF-PKG-NAME P) MSYMBOL)
				 (DO ((NICKS (QF-PKG-NICKNAMES P) (QF-CDR NICKS)))
				     ((QF-NULL NICKS))
				   (WHEN (QF-LMSTRING-MSYMBOL-EQUAL (QF-CAR NICKS) MSYMBOL)
				     (RETURN T))))
			 (PUTPROP MSYMBOL P 'REAL-MACHINE-PACKAGE-POINTER)
			 (PUTPROP MSYMBOL QF-CACHE-VERSION
				  'REAL-MACHINE-PACKAGE-POINTER-VERSION)
			 (RETURN P)))))))))))

;TAKE A THIS-MACHINE SYMBOL AND FIGURE OUT WHAT PKG-HASH-STRING WOULD DO
;WITH A SYMBOL OF THAT NAME.
;We do not call %SXHASH-STRING so we can win if it is changed!
(DEFUN QF-PKG-HASH-STRING (SYM)
  (DO ((I 0 (1+ I))
       (N (ARRAY-ACTIVE-LENGTH (GET-PNAME SYM)))
       (HASH 0))
      (( I N)
       (IF (BIT-TEST (ASH 1 23.) HASH)
	   (LOGXOR 1 (LDB 23. (QF-POINTER-SANS-BOXED-SIGN-BIT HASH)))	;-37777777 = 40000001
	   HASH))
    (SETQ HASH (ASH (LOGXOR (AREF (GET-PNAME SYM) I) HASH) 7))
    (SETQ HASH (LOGIOR (LOAD-BYTE HASH 24. 7) (LOGAND (1- 1_24.) HASH)))))

;DOESN'T TRY TO WIN FOR HAIRY FONT CHANGES ETC.
(DEFUN QF-LM-STRING-EQUAL (STRING1 STRING2 LEN2)
  (DECLARE (FIXNUM STRING1 LEN1 STRING2 LEN2 WD1 WD2 IDX CHNUM))
  (QF-TRANSPORT-HEADER STRING1)
  (QF-TRANSPORT-HEADER STRING2)
  ((LAMBDA (LEN1)
    (COND ((NOT (= LEN1 LEN2))
	   NIL)
	  ((DO ((IDX 0 (1+ IDX))
		(CHNUM)
		(WD1)
		(WD2))
	       ((NOT (< IDX LEN1))
		T)
	     (COND ((= 0 (SETQ CHNUM (LOGAND 3 IDX)))
		    (SETQ WD1 (QF-MEM-READ (SETQ STRING1 (1+ STRING1))))
		    (SETQ WD2 (QF-MEM-READ (SETQ STRING2 (1+ STRING2))))))
	     (OR (= (LOGAND 377 (LSH WD1 (SETQ CHNUM (* -8 CHNUM))))
		    (LOGAND 377 (LSH WD2 CHNUM)))
		 (RETURN NIL)) ))))
   (QF-ARRAY-ACTIVE-LENGTH STRING1)))

(DEFUN QF-SAMEPNAMEP (LISPSYMB QSYMBPTR)
 (DECLARE (FIXNUM QSYMBPTR))
 (QF-LMSTRING-MSYMBOL-EQUAL (QF-MEM-READ-TRANSPORT QSYMBPTR) LISPSYMB))

(DEFUN QF-LMSTRING-MSYMBOL-EQUAL (CONS-PNAME-PNTR LISPSYMB)
 (DECLARE (FIXNUM CONS-PNAME-PNTR))
 (LET (LEN ARRAY-HEAD)
   (QF-TRANSPORT-HEADER CONS-PNAME-PNTR)
   (SETQ ARRAY-HEAD (QF-MEM-READ CONS-PNAME-PNTR))
   (COND ((NOT (= 0 (LOGLDB-FROM-FIXNUM %%ARRAY-LEADER-BIT ARRAY-HEAD)))
	  (SETQ LEN (QF-POINTER (QF-MEM-READ (- CONS-PNAME-PNTR 2)))))
	 ((= 0 (LOGLDB-FROM-FIXNUM %%ARRAY-LONG-LENGTH-FLAG ARRAY-HEAD))
	  (SETQ LEN (LOGLDB-FROM-FIXNUM %%ARRAY-INDEX-LENGTH-IF-SHORT ARRAY-HEAD)))
	 ((SETQ LEN (QF-POINTER (QF-MEM-READ (SETQ CONS-PNAME-PNTR (1+ CONS-PNAME-PNTR)))))))
   (AND (= (LENGTH (GET-PNAME LISPSYMB)) LEN)
	(DO ((COUNT 0 (1+ COUNT))
	     (WD-NUM 0)
	     (WD)
	     (CH)
	     (LCH)
	     (PORTION 0 (1+ PORTION)))
	    ((>= COUNT LEN) T)
	  (AND (= 0 PORTION)
	       (SETQ WD (QF-MEM-READ (+ (SETQ WD-NUM (1+ WD-NUM))
					CONS-PNAME-PNTR))))
	  (SETQ CH (LOGAND 377 WD))
	  (SETQ WD (ASH WD -8))
	  (AND (= 0 (SETQ LCH (AREF (GET-PNAME LISPSYMB) COUNT)))
	       (RETURN NIL))
	  (COND ((NOT (= LCH CH))
		 (RETURN NIL))
		((= 3 PORTION)
		 (SETQ PORTION -1))) ) )) )

;;;BASIC OPERATIONS
;;; Note that if we have a pointer to old-space, either it has not been copied
;;; out of oldspace yet and that is OK, or there is a GC-forwarding pointer there
;;; which we will end up chasing.  EQ, however, is not well-defined in QF
;;; because of not really grokking old-space.  At least NIL is in a static area.

(DEFUN QF-CAR (LMOB)
    (LET ((TYPE (QF-DATA-TYPE LMOB)))
      (OR (= TYPE DTP-LIST)
	  (= TYPE DTP-LOCATIVE)
	  (= TYPE DTP-CLOSURE)
	  (= TYPE DTP-ENTITY)
	  (ERROR '|Neither a cons nor a locative -- QF-CAR| LMOB)))
    (QF-TYPED-POINTER (QF-MEM-READ-TRANSPORT LMOB)))

(DEFUN QF-CDR (LMOB)
   (LET ((TYPE (QF-DATA-TYPE LMOB))(L LMOB))
     (SELECTN TYPE
	(DTP-LOCATIVE
	 (QF-CAR LMOB))
	((DTP-LIST DTP-CLOSURE DTP-ENTITY)
	 (LET ((CDRC (QF-CDR-CODE
		      (DO ((X (QF-MEM-READ LMOB) (QF-MEM-READ L)))
			  (NIL)
			(SELECTN (QF-DATA-TYPE X)
			   ((DTP-HEADER-FORWARD DTP-GC-FORWARD)
			    (SETQ L X))
			   (OTHERWISE (RETURN X)))))))
	   (LET ((X (SELECTN CDRC
		       (0 (QF-MEM-READ (1+ L)))	;FULL CONS
		       (1 (ERROR '|CDR-ERROR encountered - QF-CDR| LMOB 'FAIL-ACT))
		       (2 QF-NIL)			;CDR NIL
		       (3 (1+ L))
		       (OTHERWISE (ERROR '|Lose big -- QF-CDR|)))))
	     (DO ((X X (QF-MEM-READ X))
		  (ADR L X))
		 (NIL)
	       (SELECTN (QF-DATA-TYPE X)
		  ((DTP-HEADER-FORWARD DTP-GC-FORWARD
		    DTP-ONE-Q-FORWARD DTP-EXTERNAL-VALUE-CELL-POINTER) NIL)
		  (DTP-BODY-FORWARD
		    (LET ((OFFSET (- (QF-POINTER ADR) (QF-POINTER X))))
		      (SETQ X (+ (QF-MEM-READ X) OFFSET))))
		  (OTHERWISE (RETURN (QF-TYPED-POINTER X))))))))
	(OTHERWISE
	 (ERROR '|Neither a cons nor a locative -- QF-CDR| LMOB)))))

(DEFUN QF-MEMQ (ELT LIST)
  (DO ((TAIL LIST (QF-CDR TAIL)))
      ((QF-NULL TAIL) NIL)
    (WHEN (= (QF-CAR TAIL) ELT)
      (RETURN TAIL))))

(DEFUN QF-GET (LIST-OR-SYMBOL ELT)
  (LET ((LIST LIST-OR-SYMBOL))
    (IF (= (QF-DATA-TYPE LIST) DTP-SYMBOL)
	(SETQ LIST (QF-PROPERTY-CELL-LOCATION LIST)))
    (DO ((TAIL (QF-CDR LIST) (QF-CDR (QF-CDR TAIL))))
	((QF-NULL TAIL) NIL)
      (WHEN (= (QF-CAR TAIL) ELT)
	(RETURN (QF-CAR (QF-CDR TAIL)))))))

(DEFUN QF-ASSQ (ELT LIST)
  (DO ((TAIL LIST (QF-CDR TAIL)))
      ((QF-NULL TAIL) NIL)
    (WHEN (= (QF-CAR (QF-CAR TAIL)) ELT)
      (RETURN (QF-CAR TAIL)))))

(DEFUN QF-NTH (N LIST)
  (LET ((TEM LIST))
    (DOTIMES (I N)
      (SETQ TEM (QF-CDR TEM)))
    (QF-CAR TEM)))

(DEFUN QF-LAST (LIST)
  (DO ((TEM LIST (QF-CDR TEM))
       (PREV NIL TEM))
      ((QF-NULL TEM) PREV)))

(DEFUN QF-FEF-INITIAL-PC (FEF)
  (LOGLDB %%FEFH-PC
	  (QF-MEM-READ (+ FEF %FEFHI-IPC))))

(DEFUN QF-FEF-INSTRUCTION (FEF PC)
  "Given a FEF and a PC, returns the corresponding 16-bit macro instruction.
There is no error checking."
  (LOGLDB (COND ((ZEROP (LOGAND 1 PC))
		 %%Q-LOW-HALF)
		(T %%Q-HIGH-HALF))
	  (QF-MEM-READ (+ FEF (TRUNCATE PC 2)))))

(DEFUN QF-FEF-INSTRUCTION-LENGTH (FEF PC &AUX WD OP DISP)
  "Return the length in halfwords of the instruction at PC in FEF."
  (SETQ WD (QF-FEF-INSTRUCTION FEF PC))
  (SETQ OP (LDB 1104 WD)
	DISP (LDB 0011 WD))
  (COND ((AND (= OP 14) (= DISP 777)) 2)
	((AND (< OP 14) (= DISP 776)) 2)
	(T 1)))

(DEFUN QF-FEF-LIMIT-PC (FEF &AUX LIM-PC)
  "Return the pc value of the end of the code of the fef."
  (SETQ LIM-PC (* 2 (QF-POINTER
		      (QF-MEM-READ
			(+ FEF %FEFHI-STORAGE-LENGTH)))))
  (COND ((ZEROP (QF-FEF-INSTRUCTION FEF (1- LIM-PC)))
	 (1- LIM-PC))
	(T LIM-PC)))

(DEFUN QF-FEF-DEBUGGING-INFO (FEF)
  (LOGLDB %%QF-TYPED-POINTER
	  (QF-MEM-READ (+ FEF (1- (LOGLDB %%FEFH-PC-IN-WORDS (QF-MEM-READ FEF)))))))

(DEFUN QF-FEF-FLAVOR-NAME (FEF)
  "Return the flavor which the compiled function FEF assumes SELF is an instance of."
  (AND (NOT (ZEROP (LOGLDB %%FEFH-GET-SELF-MAPPING-TABLE (QF-MEM-READ FEF))))
       (QF-TYPED-POINTER
	 (QF-MEM-READ
	   (+ FEF
	      (1- (LOGLDB %%FEFHI-MS-ARG-DESC-ORG
			  (QF-MEM-READ
			    (+ FEF %FEFHI-MISC)))))))))

(DEFUN QF-FLAVOR-DECODE-SELF-REF-POINTER (FLAVOR-NAME POINTER-NUMBER)
  "Decode the pointer field of a DTP-SELF-REF-POINTER.
Assumes that it is used with flavor FLAVOR-NAME.
Values are an instance variable name and NIL,
or a component flavor name and T."
  (DECLARE (RETURN-LIST INSTANCE-VAR-OR-COMPONENT-FLAVOR T-IF-COMPONENT-FLAVOR))
  (LET ((FLAVOR (QF-GET FLAVOR-NAME (QF-SYMBOL 'SI:FLAVOR))))
    (COND ((NULL FLAVOR) NIL)
	  ((LDB-TEST %%SELF-REF-MAP-LEADER-FLAG POINTER-NUMBER)
	   (VALUES (QF-NTH (- (LDB %%SELF-REF-INDEX POINTER-NUMBER) 3)
			   (QF-FLAVOR-MAPPED-COMPONENT-FLAVORS FLAVOR))
		   T))
	  ((LDB-TEST %%SELF-REF-RELOCATE-FLAG POINTER-NUMBER)
	   (QF-NTH (LDB %%SELF-REF-INDEX POINTER-NUMBER)
		   (QF-FLAVOR-MAPPED-INSTANCE-VARIABLES FLAVOR)))
	  (T 
	   (QF-NTH (LDB %%SELF-REF-INDEX POINTER-NUMBER)
		   (QF-FLAVOR-UNMAPPED-INSTANCE-VARIABLES FLAVOR))))))

(DEFUN QF-FLAVOR-UNMAPPED-INSTANCE-VARIABLES (FLAVOR)
  (QF-GET (QF-MAKE-Q (+ FLAVOR 1 (CC-GET-DEFSTRUCT-INDEX 'SI:FLAVOR-PLIST 'AREF))
		     DTP-LOCATIVE)
	  (QF-SYMBOL 'SI:UNMAPPED-INSTANCE-VARIABLES)))

(DEFUN QF-FLAVOR-MAPPED-COMPONENT-FLAVORS (FLAVOR)
  (QF-GET (QF-MAKE-Q (+ FLAVOR 1 (CC-GET-DEFSTRUCT-INDEX 'SI:FLAVOR-PLIST 'AREF))
		     DTP-LOCATIVE)
	  (QF-SYMBOL 'SI:MAPPED-COMPONENT-FLAVORS)))

(DEFUN QF-FLAVOR-MAPPED-INSTANCE-VARIABLES (FLAVOR)
  (QF-AR-1 FLAVOR (CC-GET-DEFSTRUCT-INDEX 'SI:FLAVOR-MAPPED-INSTANCE-VARIABLES 'AREF)))

(DEFUN QF-FLAVOR-ALL-INSTANCE-VARIABLES (FLAVOR)
  (QF-AR-1 FLAVOR (CC-GET-DEFSTRUCT-INDEX 'SI:FLAVOR-ALL-INSTANCE-VARIABLES 'AREF)))

(DEFUN QF-VALUE-CELL-LOCATION (Q)
  (OR (= (QF-DATA-TYPE Q) DTP-SYMBOL) (ERROR '|NOT SYMBOL - QF-VALUE-CELL-LOCATION| Q 'FAIL-ACT))
  (QF-MAKE-Q (1+ Q) DTP-LOCATIVE))

(DEFUN QF-FUNCTION-CELL-LOCATION (Q)
  (OR (= (QF-DATA-TYPE Q) DTP-SYMBOL) (ERROR '|NOT SYMBOL - QF-FUNCTION-CELL-LOCATION| Q 'FAIL-ACT))
  (QF-MAKE-Q (+ 2 Q) DTP-LOCATIVE))

(DEFUN QF-PROPERTY-CELL-LOCATION (Q)
  (OR (= (QF-DATA-TYPE Q) DTP-SYMBOL) (ERROR '|NOT SYMBOL - QF-PROPERTY-CELL-LOCATION| Q 'FAIL-ACT))
  (QF-MAKE-Q (+ 3 Q) DTP-LOCATIVE))

(DEFUN QF-PACKAGE-CELL-LOCATION (Q)
  (OR (= (QF-DATA-TYPE Q) DTP-SYMBOL) (ERROR '|NOT SYMBOL - QF-PROPERTY-CELL-LOCATION| Q 'FAIL-ACT))
  (QF-MAKE-Q (+ 4 Q) DTP-LOCATIVE))

(DEFUN QF-FUNCTION-CELL-CONTENTS (QQ)
  (AND (EQ (TYPEP QQ) 'SYMBOL) (SETQ QQ (QF-SYMBOL QQ)))
  (OR (= (QF-DATA-TYPE QQ) DTP-SYMBOL) (ERROR 'WTA-QF-FUNCTION-CELL-CONTENTS QQ 'FAIL-ACT))
  (QF-CAR (QF-FUNCTION-CELL-LOCATION QQ)))

(DEFUN QF-VALUE-CELL-CONTENTS (QQ)
  (AND (EQ (TYPEP QQ) 'SYMBOL) (SETQ QQ (QF-SYMBOL QQ)))
  (OR (= (QF-DATA-TYPE QQ) DTP-SYMBOL) (ERROR 'WTA-QF-VALUE-CELL-CONTENTS QQ 'FAIL-ACT))
  (QF-CAR (QF-VALUE-CELL-LOCATION QQ)))

(DEFUN QF-SYMBOL-PACKAGE (QQ)
  (AND (EQ (TYPEP QQ) 'SYMBOL) (SETQ QQ (QF-SYMBOL QQ)))
  (OR (= (QF-DATA-TYPE QQ) DTP-SYMBOL) (ERROR 'WTA-QF-PACKAGE-CELL-CONTENTS QQ 'FAIL-ACT))
  (QF-CAR (QF-PACKAGE-CELL-LOCATION QQ)))

;Kludge to allow incompatible systems to debug each other
;Associate from system major version to initial area list
;The major version is the earliest version with that set of areas
(DEFVAR QF-SYSTEM-AREA-LIST-ALIST
   SYS: '((0. RESIDENT-SYMBOL-AREA SYSTEM-COMMUNICATION-AREA SCRATCH-PAD-INIT-AREA
	      MICRO-CODE-SYMBOL-AREA PAGE-TABLE-AREA PHYSICAL-PAGE-DATA
	      REGION-ORIGIN REGION-LENGTH REGION-BITS ADDRESS-SPACE-MAP REGION-FREE-POINTER
	      REGION-GC-POINTER REGION-LIST-THREAD AREA-NAME AREA-REGION-LIST
	      AREA-REGION-SIZE AREA-MAXIMUM-SIZE SUPPORT-ENTRY-VECTOR
	      CONSTANTS-AREA EXTRA-PDL-AREA MICRO-CODE-ENTRY-AREA
	      MICRO-CODE-ENTRY-NAME-AREA MICRO-CODE-ENTRY-ARGS-INFO-AREA
	      MICRO-CODE-ENTRY-MAX-PDL-USAGE MICRO-CODE-ENTRY-ARGLIST-AREA
	      MICRO-CODE-SYMBOL-NAME-AREA LINEAR-PDL-AREA LINEAR-BIND-PDL-AREA
	      INIT-LIST-AREA WORKING-STORAGE-AREA)
	  (85. RESIDENT-SYMBOL-AREA SYSTEM-COMMUNICATION-AREA SCRATCH-PAD-INIT-AREA
	       MICRO-CODE-SYMBOL-AREA REGION-ORIGIN REGION-LENGTH REGION-BITS
	       REGION-FREE-POINTER PAGE-TABLE-AREA PHYSICAL-PAGE-DATA ADDRESS-SPACE-MAP
	       REGION-GC-POINTER REGION-LIST-THREAD AREA-NAME AREA-REGION-LIST
	       AREA-REGION-BITS AREA-REGION-SIZE AREA-MAXIMUM-SIZE SUPPORT-ENTRY-VECTOR
	       CONSTANTS-AREA EXTRA-PDL-AREA MICRO-CODE-ENTRY-AREA
	       MICRO-CODE-ENTRY-NAME-AREA MICRO-CODE-ENTRY-ARGS-INFO-AREA
	       MICRO-CODE-ENTRY-MAX-PDL-USAGE MICRO-CODE-ENTRY-ARGLIST-AREA
	       MICRO-CODE-SYMBOL-NAME-AREA LINEAR-PDL-AREA LINEAR-BIND-PDL-AREA
	       INIT-LIST-AREA WORKING-STORAGE-AREA)
	  (98. RESIDENT-SYMBOL-AREA SYSTEM-COMMUNICATION-AREA SCRATCH-PAD-INIT-AREA
	       MICRO-CODE-SYMBOL-AREA REGION-ORIGIN REGION-LENGTH REGION-BITS
	       REGION-FREE-POINTER PAGE-TABLE-AREA PHYSICAL-PAGE-DATA ADDRESS-SPACE-MAP
	       REGION-GC-POINTER REGION-LIST-THREAD AREA-NAME AREA-REGION-LIST
	       AREA-REGION-BITS AREA-REGION-SIZE AREA-MAXIMUM-SIZE SUPPORT-ENTRY-VECTOR
	       CONSTANTS-AREA EXTRA-PDL-AREA MICRO-CODE-ENTRY-AREA
	       MICRO-CODE-ENTRY-NAME-AREA MICRO-CODE-ENTRY-ARGS-INFO-AREA
	       MICRO-CODE-ENTRY-MAX-PDL-USAGE
	       MICRO-CODE-PAGING-AREA PAGE-GC-BITS
	       MICRO-CODE-ENTRY-ARGLIST-AREA
	       MICRO-CODE-SYMBOL-NAME-AREA LINEAR-PDL-AREA LINEAR-BIND-PDL-AREA
	       INIT-LIST-AREA WORKING-STORAGE-AREA)
	  (210. RESIDENT-SYMBOL-AREA SYSTEM-COMMUNICATION-AREA SCRATCH-PAD-INIT-AREA
		MICRO-CODE-SYMBOL-AREA PAGE-TABLE-AREA PHYSICAL-PAGE-DATA PAGE-BAND-FLAGS
		REGION-ORIGIN REGION-LENGTH REGION-BITS ADDRESS-SPACE-MAP REGION-FREE-POINTER
		REGION-GC-POINTER REGION-LIST-THREAD AREA-NAME AREA-REGION-LIST
		AREA-REGION-SIZE AREA-MAXIMUM-SIZE AREA-REGION-BITS SUPPORT-ENTRY-VECTOR
		CONSTANTS-AREA EXTRA-PDL-AREA MICRO-CODE-ENTRY-AREA
		MICRO-CODE-ENTRY-NAME-AREA MICRO-CODE-ENTRY-ARGS-INFO-AREA
		MICRO-CODE-ENTRY-MAX-PDL-USAGE MICRO-CODE-ENTRY-ARGLIST-AREA
		MICRO-CODE-SYMBOL-NAME-AREA LINEAR-PDL-AREA LINEAR-BIND-PDL-AREA
		INIT-LIST-AREA WORKING-STORAGE-AREA)
	  ))

;RETURN BASE ADDRSS OF AREA WHICH WAS PRESENT IN COLD-LOAD.  FASTER THAN QF-AREA-ORIGIN,
; AND MORE IMPORTANTLY, GUARANTEED NOT TO CAUSE ANY SWAPPING ACTIVITY.
(DEFUN QF-INITIAL-AREA-ORIGIN (NAME)
  (OR (CDR (ASSQ NAME QF-AREA-ORIGIN-CACHE))
      (LET ((AREA-NUMBER
	      (FIND-POSITION-IN-LIST NAME (QF-INITIAL-AREA-LIST))))
	(IF AREA-NUMBER
	    (LET ((ORIGIN (QF-POINTER
			    (PHYS-MEM-READ (+ AREA-NUMBER
					      (PHYS-MEM-READ
						(+ 400 %SYS-COM-AREA-ORIGIN-PNTR)))))))
	      (PUSH (CONS NAME ORIGIN) QF-AREA-ORIGIN-CACHE)
	      ORIGIN)))
      (FERROR NIL "~S area not found" NAME)))

(DEFUN QF-INITIAL-AREA-LIST ()
  (LET ((MY-VERSION (OR (SYSTEM-COMMUNICATION-AREA %SYS-COM-MAJOR-VERSION)
			(SI:GET-SYSTEM-VERSION)))
	(HIS-VERSION (QF-POINTER (QF-MEM-READ (+ 400 %SYS-COM-MAJOR-VERSION)))))
    (COND ((ZEROP HIS-VERSION)
	   (OR PHT-ADDR (QF-SETUP-PHT-ADDR))
	   (SETQ HIS-VERSION (IF OLD-AREA-ORDER 79.
			       (IF (= %%QF-POINTER 30)
				   97. 98.))
		 MY-VERSION -1)))
    (IF (= MY-VERSION HIS-VERSION) AREA-LIST
      (DO ((L QF-SYSTEM-AREA-LIST-ALIST (CDR L))
	   (RES NIL (IF ( HIS-VERSION (CAAR L)) (CDAR L) RES)))
	  ((NULL L) RES)))))

;RETURN AREA NUMBER OF AREA - BETTER BE AN INITIAL AREA
(DEFUN QF-AREA-NUMBER (NAME)
  (OR (FIND-POSITION-IN-LIST NAME (QF-INITIAL-AREA-LIST))
      (ERROR NAME '|NOT KNOWN - QF-AREA-NUMBER|)))

;;; ARRAYS.  ONLY 1-DIMENSIONAL FOR NOW.

;FUNCTION TO SET UP FOR AN ARRAY REFERENCE
;CORRESPONDS TO GAHDR IN MICRO CODE.
;ARGUMENT IS ARRAY-POINTER-Q
;SETS THE FOLLOWING SPECIAL VARIABLES:
;  QF-ARRAY-HEADER
;  QF-ARRAY-DISPLACED-P
;  QF-ARRAY-HAS-LEADER-P
;  QF-ARRAY-NUMBER-DIMS
;  QF-ARRAY-HEADER-ADDRESS
;  QF-ARRAY-DATA-ORIGIN
;  QF-ARRAY-LENGTH

(DEFUN QF-ARRAY-SETUP (Q)
  (PROG (N)
    (OR (= (QF-DATA-TYPE Q) DTP-ARRAY-POINTER) (ERROR '|NOT AN ARRAY-POINTER - QF-ARRAY-SETUP|
						  Q 'FAIL-ACT))
A   (SETQ QF-ARRAY-HEADER-ADDRESS (QF-POINTER Q))
    (SETQ QF-ARRAY-HEADER (QF-MEM-READ QF-ARRAY-HEADER-ADDRESS))
    (SETQ N (QF-DATA-TYPE QF-ARRAY-HEADER))
    (COND ((= N DTP-ARRAY-HEADER))
	  ((OR (= N DTP-HEADER-FORWARD) (= N DTP-GC-FORWARD))
	   (SETQ Q QF-ARRAY-HEADER)
	   (GO A))
	  ((ERROR '|ARRAY HEADER NOT DTP-ARRAY-HEADER - QF-ARRAY-SETUP| Q 'FAIL-ACT)))
    (SETQ QF-ARRAY-DISPLACED-P (= 1 (LOGLDB-FROM-FIXNUM %%ARRAY-DISPLACED-BIT
							QF-ARRAY-HEADER)))
    (SETQ QF-ARRAY-HAS-LEADER-P (= 1 (LOGLDB-FROM-FIXNUM %%ARRAY-LEADER-BIT QF-ARRAY-HEADER)))
    (SETQ QF-ARRAY-NUMBER-DIMS (LOGLDB-FROM-FIXNUM %%ARRAY-NUMBER-DIMENSIONS QF-ARRAY-HEADER))
    (SETQ QF-ARRAY-DATA-ORIGIN (+ QF-ARRAY-NUMBER-DIMS QF-ARRAY-HEADER-ADDRESS))
    (COND ((= 0 (LOGLDB-FROM-FIXNUM %%ARRAY-LONG-LENGTH-FLAG QF-ARRAY-HEADER))
	   (SETQ QF-ARRAY-LENGTH (LOGLDB-FROM-FIXNUM %%ARRAY-INDEX-LENGTH-IF-SHORT
						     QF-ARRAY-HEADER)))
	  (T
	   (SETQ QF-ARRAY-DATA-ORIGIN (1+ QF-ARRAY-DATA-ORIGIN))
	   (SETQ QF-ARRAY-LENGTH (QF-POINTER (QF-MEM-READ (1+ QF-ARRAY-HEADER-ADDRESS))))))
  ))

;FUNCTION THAT CORRESPONDS TO DSP-ARRAY-SETUP IN MICRO CODE.
;ARGUMENT IS COMPUTED INDEX, RESULT IS NEW, POSSIBLY-OFFSET INDEX.
;HANDLES DISPLACED AND INDIRECT ARRAYS.  BARFS IF INDEX OUT OF BOUNDS.
;MAY MODIFY SPECIAL VARIABLE QF-ARRAY-DATA-ORIGIN.
(DEFUN QF-ARRAY-DISPLACE (I)
 (COND (QF-ARRAY-DISPLACED-P
	(SETQ QF-ARRAY-LENGTH (QF-POINTER (QF-MEM-READ (1+ QF-ARRAY-DATA-ORIGIN))))
	(PROG (K)
	  (SETQ K (QF-MEM-READ QF-ARRAY-DATA-ORIGIN))
	  (OR (= (QF-DATA-TYPE K) DTP-ARRAY-POINTER) (RETURN (SETQ QF-ARRAY-DATA-ORIGIN K)))
	  ;INDIRECT ARRAY
	  (ERROR '|I REALLY DON'T FEEL LIKE HACKING INDIRECT ARRAYS, SORRY - QF-ARRAY-DISPLACE|
		 NIL 'FAIL-ACT))))
 (OR (< I QF-ARRAY-LENGTH)
     (ERROR '|ARRAY INDEX OUT OF BOUNDS - QF-ARRAY-DISPLACE| I 'FAIL-ACT))
 I)

;FUNCTION TO READ OUT CONTENTS OF THE SET UP ARRAY.  ARG IS INDEX.
(DEFUN QF-ARRAY-READ (I)
  (PROG (N TYPE K M Q J)
    (SETQ TYPE (NTH (LOGLDB-FROM-FIXNUM %%ARRAY-TYPE-FIELD QF-ARRAY-HEADER) ARRAY-TYPES))
    (SETQ K (CDR (ASSQ TYPE ARRAY-ELEMENTS-PER-Q)))	;K ELEMENTS PER Q
;**KNOWS ABOUT LENGTH OF POINTER**
    (SETQ N (CDR (OR (ASSQ TYPE '((ART-1B . 1) (ART-2B . 2) (ART-4B . 4) (ART-8B . 8.)
				  (ART-16B . 16.) (ART-32B . 32.) (ART-Q . 32.)
				  (ART-Q-LIST . 29.) (ART-STRING . 8)
				  (ART-STACK-GROUP-HEAD . 32.) (ART-SPECIAL-PDL . 32.)
				  (ART-HALF-FIX . 16.)
				  (ART-REG-PDL . 32.)
				  (ART-FPS-FLOAT . 16.)
				  (ART-FAT-STRING . 16.)
				  ))			;N BITS PER ELEMENT
		     (ERROR '|ARRAY TYPE NOT KNOWN ABOUT - QF-ARRAY-READ| TYPE 'FAIL-ACT))))
    (SETQ M (1- (ASH 1 N)))			;M MASK FOR 1 ELEMENT
    (SETQ Q (TRUNCATE I K) J (* (\ I K) N))			;Q WD INDEX, J BIT INDEX
    (SETQ Q (QF-MEM-READ (+ Q QF-ARRAY-DATA-ORIGIN)))
    (RETURN (LOGAND M (ASH Q (- J))))))

;SIMILAR FUNCTION TO WRITE INTO SET UP ARRAY.
(DEFUN QF-ARRAY-WRITE (I DATA)
  (PROG (N TYPE K M Q J ADR)
    (SETQ TYPE (NTH (LOGLDB-FROM-FIXNUM %%ARRAY-TYPE-FIELD QF-ARRAY-HEADER) ARRAY-TYPES))
    (SETQ K (CDR (ASSQ TYPE ARRAY-ELEMENTS-PER-Q)))
;**KNOWS ABOUT NUMBER OF BITS IN POINTER**
    (SETQ N (CDR (OR (ASSQ TYPE '((ART-1B . 1) (ART-2B . 2) (ART-4B . 4) (ART-8B . 8.)
				  (ART-16B . 16.) (ART-32B . 32.) (ART-Q . 32.)
				  (ART-Q-LIST . 29.) (ART-STRING . 8)
				  (ART-STACK-GROUP-HEAD . 32.) (ART-SPECIAL-PDL . 32.)
				  (ART-HALF-FIX . 16.)
				  (ART-REG-PDL . 32.)
				  (ART-FPS-FLOAT . 16.)
				  (ART-FAT-STRING . 16.)
				  ))			;N BITS PER ELEMENT
		     (ERROR '|ARRAY TYPE NOT KNOWN ABOUT - QF-ARRAY-WRITE| TYPE 'FAIL-ACT))))
    (SETQ M (1- (LSH 1 N)))
    (SETQ Q (TRUNCATE I K) J (* (\ I K) N))
    (SETQ Q (QF-MEM-READ (SETQ ADR (+ Q QF-ARRAY-DATA-ORIGIN))))
    (RETURN (QF-MEM-WRITE ADR
			  (LOGIOR (ASH (LOGAND M DATA) J)
				  (LOGAND (LOGXOR -1 (ASH M J))
					  Q))))))

(DEFUN QF-ARRAY-DIMENSION-N (I Q)
 (QF-ARRAY-SETUP Q)
 (COND ((= I QF-ARRAY-NUMBER-DIMS)
	(ERROR '|QF-ARRAY-DIMENSION-N ON LAST DIMENSION|)))
 (QF-POINTER (QF-MEM-READ (+ I (- QF-ARRAY-DATA-ORIGIN QF-ARRAY-NUMBER-DIMS)))))

(DEFUN QF-AR-1 (Q I)
  (QF-ARRAY-SETUP Q)
  (QF-TYPED-POINTER (QF-ARRAY-READ (QF-ARRAY-DISPLACE I))))

(DEFUN QF-AR-OR-IR-1 (Q I)
  "Do AR-1 if Q is an array, or %INSTANCE-REF if it is an instance.
Note that the first element is index 0 in AR-1, but 1 in %INSTANCE-REF.
We treat I the same as AR-1 or %INSTANCE-REF accordingly."
  (IF (= (QF-DATA-TYPE Q) DTP-INSTANCE)
      (QF-MEM-READ (+ I (QF-POINTER Q)))
    (QF-AR-1 Q I)))

(DEFUN QF-ARRAY-LEADER (Q I)
  (QF-ARRAY-SETUP Q)
  (OR QF-ARRAY-HAS-LEADER-P (ERROR '|NO ARRAY LEADER - QF-ARRAY-LEADER| Q 'FAIL-ACT))
  (OR (< I (QF-POINTER (QF-MEM-READ (- QF-ARRAY-HEADER-ADDRESS 1))))
      (ERROR '|ARRAY LEADER INDEX OUT OF BOUNDS - QF-ARRAY-LEADER| Q 'FAIL-ACT))
  (QF-TYPED-POINTER (QF-MEM-READ (- QF-ARRAY-HEADER-ADDRESS I 2))))

(DEFUN QF-ARRAY-LENGTH (Q)
  (QF-ARRAY-SETUP Q)
  QF-ARRAY-LENGTH)

(DEFUN QF-ARRAY-ACTIVE-LENGTH (Q)
  (QF-ARRAY-SETUP Q)
  (COND ((NOT QF-ARRAY-HAS-LEADER-P)
	 QF-ARRAY-LENGTH)
	((QF-POINTER (QF-MEM-READ (- QF-ARRAY-HEADER-ADDRESS 2))))))

;INITIALIZE ON LOADING
(QF-CLEAR-CACHE T)

