;; -*- Mode: LISP; Package: SYSTEM-INTERNALS; Base: 8 -*-
;CADR VERSION

  (DEFCONSTANT CC-REG-ADR-PHYS-MEM-OFFSET 200000)	;REG ADR IN THIS RANGE REFER TO
						; PHYSICAL MEMORY LOCNS
    (DEFCONSTANT RAXBUS CC-REG-ADR-PHYS-MEM-OFFSET)    ;FOR CONVENIENCE, NOTE THIS IS ONLY 192K
  (DEFCONSTANT CC-REG-ADR-VIRT-MEM-OFFSET 1000000)	;REG ADR ABOVE THIS REFER TO VIRTUAL
						; MAIN MEMORY LOCATIONS

(DEFCONSTANT CFDMD 30)		;FUNCTIONAL DEST FOR MEMORY DATA REGISTER
(DEFCONSTANT CFDVMA 20)	; .. FOR VMA 
(DEFCONSTANT CFDPP 14)		; .. FOR PDL BUFFER POINTER
(DEFCONSTANT CFDPI 13)		; .. FOR PDL BUFFER INDEX

 (DEFCONSTANT RAORG 40000)	; ORIGIN OF REGISTER ADDRESS SPACE
 (DEFCONSTANT RACMO 40000)	;   ORIGIN OF CONTROL MEM 
  (DEFCONSTANT RACME 100000)	;   CONTROL MEMORY (C)  16K
 (DEFCONSTANT RADMO 100000)
  (DEFCONSTANT RADME 104000)	;   DISPATCH MEMORY (D) 2K
 (DEFCONSTANT RAPBO 104000)
  (DEFCONSTANT RAPBE 106000)	;   PDL BUFFER (P)	1024 REG
 (DEFCONSTANT RAM1O 106000)
  (DEFCONSTANT RAM1E 112000)	;   MAP (1ST LEVEL)(M1) 2048 REG (5 BITS EA)
 (DEFCONSTANT RAM2O 112000)
  (DEFCONSTANT RAM2E 114000)	;   MAP (2ND LEVEL)(M2) 1024 REG (24 BITS EA)
 (DEFCONSTANT RAAMO 114000)
  (DEFCONSTANT RAAME 116000)	;   A MEMORY (A)	1K
 (DEFCONSTANT RAUSO 116000)
  (DEFCONSTANT RAUSE 116040)	;   U STACK (U)		32 REG
 (DEFCONSTANT RAMMO 116040)
  (DEFCONSTANT RAMME 116100)	;   M MEMORY (M)	32 REG
 (DEFCONSTANT RAFSO 116100)	;    NOTE: M MEM MUST BE CONTIG WITH FUNCT SRC
  (DEFCONSTANT RAFSE 116140)	;   FUNCTIONAL SOURCES  32 REGS
 (DEFCONSTANT RAFDO 116140)	;   FUNCTIONAL DESTINATIONS 32 REGS
  (DEFCONSTANT RAFDE 116200)
    (DEFCONSTANT RAMD (+ RAFDO CFDMD))		;MAIN MEM DATA REGISTER
    (DEFCONSTANT RAVMA (+ RAFDO CFDVMA))	;VMA (VIRTUAL MEMORY ADDRESS)
    (DEFCONSTANT RAPP  (+ RAFDO CFDPP))	;PDL POINTER (TO PDL BUFFER)
    (DEFCONSTANT RAPI  (+ RAFDO CFDPI))	;PDL INDEX (TO PDL BUFFER)
				;   MICROPROCESSOR REGISTERS  
 (DEFCONSTANT RARGO 116200)	;   INTERNAL (COPY OF) REGISTER SECTION
  (DEFCONSTANT RARGE 116300)	;    (OR IN SOME CASES, THESE REQUIRE SPECIAL ACCESS FOR
		;      "HARWARE" REASONS)
 (DEFCONSTANT RAPC 116200)	;     PC  (PC)
 (DEFCONSTANT RAUSP 116201)	;     U STACK POINTER  (USP)
 (DEFCONSTANT RAIR 116202)	;     .IR (PUT IN DIAG INST REG, THEN LOAD INTO IR,
			;	 THEN UPDATE OBUS DISPLAY.)
 (DEFCONSTANT RASIR 116203)	;     SAVED IR (THE ONE SAVE ON FULL STATE SAVE
			;      AND RESTORED ON FULL RESTORE)
 (DEFCONSTANT RAQ 116204)	;     Q REGISTER  (Q)
 (DEFCONSTANT RADC 116205)	;     DISPATCH CONSTANT REGISTER (DC)
 (DEFCONSTANT RARSET 116206)	;     RESET REGISTER
 (DEFCONSTANT RASTS 116207)	;     STATUS REGISTER (32 BIT, AS READ BY ERERWS)
 (DEFCONSTANT RAOBS 116210)	;     OUTPUT BUS STATUS (32 BITS)
;THE FOLLOWING REGISTERS MAKE VARIOUS FUNCTIONS AVAILABLE TO THE PDP-10
;  WHICH ARE OTHERWISE ACCESSIBLE ONLY BY TYPIN.
;??
 (DEFCONSTANT RARS 116211)	;     RESET (CNTRL-R)
 (DEFCONSTANT RASTEP 116212)	;     STEP  (CNTRL-N)
 (DEFCONSTANT RASTOP 116213)	;     STOP  (CNTRL-S)
 (DEFCONSTANT RASA 116214)	;     SET STARTING ADR (@G)
 (DEFCONSTANT RAGO 116215)	;     GO (CNTRL-P, BUT KEEP LISTENING FOR REGISTER COMMANDS)
 (DEFCONSTANT RAMOD 116216)	;MODE REGISTER, SEE THE OLORD PRINT
 (DEFCONSTANT RARCON 116217)	;REMOTE CONSOLE, ENABLED BY DEPOSIT NON-ZERO IN RAGO
			;EXAMINE GIVES TYO OR 0, DEPOSIT DOES TYI
;
 (DEFCONSTANT RAREALOBUS 116220) ;.OBUS CURRENT OBUS, NOT SAVED ONE
 (DEFCONSTANT RAABUS 116221)	;.A, A-BUS
 (DEFCONSTANT RAMBUS 116222)	;.M, M-BUS
 (DEFCONSTANT RASTAT 116223)	;STATC, STATISTICS COUNTER
 (DEFCONSTANT RALC 116224)     ;LC, MACRO LOCATION COUNTER
   ;
 (DEFCONSTANT RAUBMO 116240)   ;UBM, UNIBUS MAP
  (DEFCONSTANT RAUBME 116260)

		; BUFFERS WITHIN THE CONSOLE COMPUTER
 (DEFCONSTANT RACSWO 116300)	;  MODE SWITCHES (CLLMOD, ETC)
;NO HOPE
;   (SETQ RAPSVAL 62600) ;   PASSIVE STATE VALID
;   (SETQ RAFSVAL 62601) ;   FULL STATE VALID
;   (SETQ RARUN   62602) ;   CONS ACTUALLY RUNNING(?)
;   (SETQ RATRUN  62603) ;   CONS "TRYING" TO RUN
;   (SETQ RALLMOD 62604) ;   LOW LEVEL MODE FLAG
;   (SETQ RANOOPF 62605) ;   NO-OP FLAG
;   (SETQ RAMODREG 62606);   LAST SETTING OF MODE REGISTER (RAMOD)
;   (SETQ RATENMOD 62607);   NON-ZERO -> PDP10 CONSOLE PRGM OPERATIONAL, 11 TO DO NOTHING
			;     EXCEPT CNTRL-META-CALL HACK.
  (DEFCONSTANT RACSWE 116310)
 (DEFCONSTANT RARDRO 116310)	;  "RAID" REGISTERS (RAIDR)
  (DEFCONSTANT RARDRE 116320)
 (DEFCONSTANT RACIBO 116320)
  (DEFCONSTANT RACIBE 116340)	;  CONSOLE INST BUFFER (CI)   8 REG
			;   (EA HOLDS A U INST. CAN BE SENT TO CONS VIA DIB IN A LOOP)

;NO HOPE
 (DEFCONSTANT RACMFO 116340)	;  MAIN MEMORY FUNCTION REGISTERS
;   (SETQ RACVMR 62640)  ;   CONSOLE VMA, INITIATE VIRTUAL READ
;   (SETQ RACRDR 62641)  ;   CONSOLE READ DATA REG
;   (SETQ RACPMR 62642)  ;   CONSOLE VMA, INITIATE PHYSICAL READ
;   (SETQ RACMWD 62644)  ;   CONSOLE VIRTUAL MEM-WRITE-DATA REGISTER
;   (SETQ RACVMW 62645)  ;   CONSOLE VMA, INITIATE VIRTUAL WRITE
;   (SETQ RACPMW 62647)  ;   CONSOLE VMA, INITIATE PHYSICAL WRITE
  (DEFCONSTANT RACMFE 116350)

(DEFCONSTANT RAOPCO 116350)	; OLD PCS
 (DEFCONSTANT RAOPCE 116360)

;"CONSOLE FUNCTION" REGISTERS
 ; CONSOLE STATUS REGISTERS
	;RUN STATUS
	;ERROR STATUS
 ; CONSOLE FUNCTION PSEUDO REGISTERS 
 ;  (MOST OF THESE SIMULATE CONSOLE CTRL CHARS)
	;RESET (CNTRL R)
	;GO (@G)
	;PROCEED (LIKE CNTRL P, BUT STAY IN LISTEN LOOP.
	;STEP (CNTRL N)
