; -*- Mode:Lisp; Package:CADR; Base:8 -*-
;DISK HANDLER FOR CC FOR CADR
;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;******************************
; STILL TO BE DONE
; <HAIRIER> FUNCTION TO VERIFY PAGE HASH TABLE, ALSO MAP?
;******************************

(DECLARE (SPECIAL CC-DISK-ADDRESS CC-DISK-RETRY-COUNT
		  CC-DISK-DA-DESC CC-DISK-STATUS-DESC CC-DISK-CMD-DESC
		  CC-DISK-READ-FCN CC-DISK-WRITE-FCN
		  CC-DISK-TRACE-FLAG CC-DISK-LAST-CMD CC-DISK-LAST-CLP
		  %SYS-COM-PAGE-TABLE-PNTR %SYS-COM-PAGE-TABLE-SIZE
		  %%PHT1-VALID-BIT %%PHT1-VIRTUAL-PAGE-NUMBER
		  %%PHT2-PHYSICAL-PAGE-NUMBER
		  %%PHT1-SWAP-STATUS-CODE %PHT-SWAP-STATUS-PDL-BUFFER 
		  %PHT-SWAP-STATUS-WIRED %PHT-SWAP-STATUS-FLUSHABLE
		  %%PHT2-MAP-STATUS-CODE %%PHT2-ACCESS-STATUS-AND-META-BITS
		  %PHT-MAP-STATUS-READ-WRITE %PHT-MAP-STATUS-PDL-BUFFER
		  %PHT-DUMMY-VIRTUAL-ADDRESS
		  MICRO-CODE-SYMBOL-AREA-START MICRO-CODE-SYMBOL-AREA-END
		  PHT-ADDR
		  CC-DISK-TYPE
		  CTALK-BARF-AT-WRITE-ERRORS))

(SETQ MICRO-CODE-SYMBOL-AREA-START 3  ;MAGIC
      MICRO-CODE-SYMBOL-AREA-END 7)   ;MORE MAGIC

(SETQ CC-DISK-RETRY-COUNT 5)	;TIMES TO RETRY AT CC-DISK-XFER IF GET ERROR
(SETQ CC-DISK-LAST-CMD 0 CC-DISK-LAST-CLP 777) ;AVOID UNBOUND

(SETQ CC-DISK-TRACE-FLAG NIL)

(DEFVAR N-CYLINDERS 1
  "Number of cylinders on disk of debugged machine.
Initial value prevents bomb-out until machine's label can be read.")
(DEFVAR BLOCKS-PER-CYLINDER 2
  "Number of blocks per cylinder (num tracks * blocks per track) on disk of debugged machine.
Initial value prevents bomb-out until machine's label can be read.")
(DEFVAR BLOCKS-PER-TRACK 2
  "Number of blocks per track on disk of debugged machine.
Initial value prevents bomb-out until machine's label can be read.")

(SETQ CC-DISK-ADDRESS 17377774
      CC-DISK-READ-FCN 0
      CC-DISK-WRITE-FCN 11)

(SETQ CC-DISK-DA-DESC '(
	(TYPE-FIELD UNIT 3403 NIL)
	(TYPE-FIELD CYLINDER 2014 NIL)
	(TYPE-FIELD HEAD 0808 NIL)
	(TYPE-FIELD SECTOR 0008 NIL)))

(SETQ CC-DISK-STATUS-DESC '(
	(SELECT-FIELD INTERNAL-PARITY-ERROR 2701 (NIL INTERNAL-PARITY-ERROR))
	(SELECT-FIELD READ-COMPARE-DIFFERENCE 2601 (NIL READ-COMPARE-DIFFERENCE))
	(SELECT-FIELD CCW-CYCLE 2501 (NIL CCW-CYCLE))
	(SELECT-FIELD NXM 2401 (NIL NXM))
	(SELECT-FIELD PAR 2301 (NIL PAR))
	(SELECT-FIELD HEADER-COMPARE-ERR 2201 (NIL HEADER-COMPARE-ERR))
	(SELECT-FIELD HEADER-ECC-ERR 2101 (NIL HEADER-ECC-ERR))
	(SELECT-FIELD ECC-HARD 2001 (NIL ECC-HARD))
	(SELECT-FIELD ECC-SOFT 1701 (NIL ECC-SOFT))
	(SELECT-FIELD OVERRUN 1601 (NIL OVERRUN))
	(SELECT-FIELD TRANSFER-ABORTED 1501 (NIL TRANSFER-ABORTED))
	(SELECT-FIELD START-OF-BLOCK-ERR 1401 (NIL START-OF-BLOCK-ERR))
	(SELECT-FIELD TIMEOUT 1301 (NIL TIMEOUT))
	(SELECT-FIELD SEEK-ERR 1201 (NIL SEEK-ERR))
	(SELECT-FIELD OFF-LINE 1101 (NIL OFF-LINE))
	(SELECT-FIELD OFF-CYL 1001 (NIL OFF-CYL))
	(SELECT-FIELD READ-ONLY 0701 (NIL READ-ONLY))
	(SELECT-FIELD FAULT 0601 (NIL FAULT))
	(SELECT-FIELD NO-SELECT 0501 (NIL NO-SELECT))
	(SELECT-FIELD MULTIPLE-SELECT 0401 (NIL MULTIPLE-SELECT))
	(SELECT-FIELD INTERRUPT 0301 (NIL INTERRUPT))
	(SELECT-FIELD ATTENTION 0201 (NIL ATTENTION))
	(SELECT-FIELD ANY-ATTENTION 0101 (NIL ANY-ATTENTION))
	(SELECT-FIELD IDLE 0001 (BUSY IDLE)) ))

(SETQ CC-DISK-CMD-DESC '(
	(SELECT-FIELD COMMAND 0004 (READ CMD1? READ-ALL CMD3?
				    SEEK AT-EASE-AND-MISC OFFSET-CLEAR CMD7?
				    READ-COMPARE WRITE CMD12? WRITE-ALL
				    CMD14? CMD15? RESET-CONTROLLER CMD17?))
	(SELECT-FIELD SERVO-OFFSET 0402 (NIL BIT4? REVERSE FORWARD))
	(SELECT-FIELD DATA-STROBE 0602 (NIL EARLY LATE EARLY-AND-LATE?))
	(SELECT-FIELD FAULT-CLEAR 1001 (NIL FAULT-CLEAR))
	(SELECT-FIELD RECALIBRATE 1101 (NIL RECALIBRATE))
	(SELECT-FIELD ATTN-INT-ENB 1201 (NIL ATTN-INT-ENB))
	(SELECT-FIELD DONE-INT-ENB 1301 (NIL DONE-INT-ENB)) ))

(DEFUN CC-DISK-ANALYZE ()
    (PRINT 'DISK-CONTROL-STATUS)
    (CC-TYPE-OUT (PHYS-MEM-READ CC-DISK-ADDRESS) CC-DISK-STATUS-DESC T T)
    (TERPRI)
    (PRINC '|ECC ERROR PATTERN BITS |)
    (PRIN1 (LOGLDB 2020 (PHYS-MEM-READ (+ CC-DISK-ADDRESS 3))))
    (TERPRI)
    (PRINC '|ECC ERROR BIT POSITION |)
    (PRIN1 (LOGLDB 0020 (PHYS-MEM-READ (+ CC-DISK-ADDRESS 3))))
    (PRINT 'LAST-CC-COMMAND)
    (CC-TYPE-OUT CC-DISK-LAST-CMD CC-DISK-CMD-DESC T T)
    (PRINT 'DISK-ADDRESS)
    (CC-TYPE-OUT (PHYS-MEM-READ (+ CC-DISK-ADDRESS 2)) CC-DISK-DA-DESC T T)
    (PRINT 'MEMORY-ADDRESS)
    (PRIN1 (LOGLDB 0026 (PHYS-MEM-READ (+ CC-DISK-ADDRESS 1))))
    (PRINT 'LAST-CC-COMMAND-LIST-POINTER)
    (PRIN1 CC-DISK-LAST-CLP)
    (PRINT 'COMMAND-LIST)
    (DO ((I CC-DISK-LAST-CLP (1+ I))
	 (TEM))
	(NIL)
      (DECLARE (FIXNUM I TEM))
      (PRINT I)
      (PRIN1 (SETQ TEM (PHYS-MEM-READ I)))
      (AND (ZEROP (LOGLDB 0001 TEM)) (RETURN NIL)))
    (TERPRI)
)

;Look at the disk error log of the machine on the other end of the debug interface
(DEFUN CC-PRINT-DISK-ERROR-LOG ()
  (DO I 600 (+ I 4) (= I 640)
    (LET ((CLP-CMD (PHYS-MEM-READ I))
	  (DA (PHYS-MEM-READ (1+ I)))
	  (STS (PHYS-MEM-READ (+ I 2)))
	  (MA (PHYS-MEM-READ (+ I 3))))
      (COND ((NOT (ZEROP CLP-CMD))
	     (FORMAT T "~%Command ~O ~@[(~A) ~]"
		       (LOGLDB 0020 CLP-CMD)
		       (CDR (ASSQ (LOGLDB 0004 CLP-CMD) '((0 . "Read")
							  (10 . "Read-Compare")
							  (11 . "Write")))))
	     (AND (BIT-TEST %DISK-COMMAND-DATA-STROBE-EARLY CLP-CMD)
		  (PRINC "Data-Strobe-Early "))
	     (AND (BIT-TEST %DISK-COMMAND-DATA-STROBE-LATE CLP-CMD)
		  (PRINC "Data-Strobe-Late "))
	     (AND (BIT-TEST %DISK-COMMAND-SERVO-OFFSET CLP-CMD)
		  (PRINC "Servo-offset "))
	     (AND (BIT-TEST %DISK-COMMAND-SERVO-OFFSET-FORWARD CLP-CMD)
		  (PRINC "S-O-Forward "))
	     (TERPRI)
	     (FORMAT T "CCW-list pointer ~O (low 16 bits)~%" (LOGLDB 2020 CLP-CMD))
	     (FORMAT T "Disk address: unit ~O, cylinder ~O, head ~O, block ~O (~4:*~D ~D ~D ~D decimal)~%"
		       (LOGLDB 3404 DA) (LOGLDB 2014 DA) (LOGLDB 1010 DA) (LOGLDB 0010 DA))
	     (FORMAT T "Memory address: ~O (type bits ~O)~%"
		       (LOGLDB 0026 MA) (LOGLDB 2602 MA))
	     (FORMAT T "Status: ~O" STS)
	     (DO ((PPSS 2701 (- PPSS 100))
		  (L '("Internal-parity" "Read-compare" "CCW-cycle" "NXM" "Mem-parity"
		       "Header-Compare" "Header-ECC" "ECC-Hard" "ECC-Soft"
		       "Overrun" "Transfer-Aborted (or wr. ovr.)" "Start-Block-Error"
		       "Timeout" "Seek-Error" "Off-Line" "Off-Cylinder"
		       "Read-Only" "Fault" "No-Select" "Multiple-Select"
		       "Interrupt" "Sel-Unit-Attention" "Any-Unit-Attention" "Idle")
		     (CDR L)))
		 ((MINUSP PPSS) (TERPRI))
	       (AND (LDB-TEST PPSS STS) (FORMAT T "~<~%~8X~:;  ~A~>" (CAR L)))))))))


;Try harder routine.
;Get CYL, Head, Sector from disk, or from &OPTIONAL args.
;Try xfer again, with all flavors of offsets, and report.
;Then try recalibrate, all offsets again.

(IF-FOR-LISPM
(defun cc-try-harder (&OPTIONAL CYL head sector
		      &aux (unit 0) disk-adr)
   (cond ((null cyl)					;default from last xfer
	  (setq disk-adr (phys-mem-read (+ cc-disk-address 2)))
	  (setq cyl (ldb 2014 disk-adr)
		head (ldb 0808 disk-adr)
		sector (ldb 0008 disk-adr)
		unit (ldb 3403 disk-adr))))
   (do recal 0 (1+ recal) (= recal 2)
       (do ((fcn-bits '(0 40 60 100 200 140 240 160 260) (cdr fcn-bits))
	    (fcn-name '("Normal" "Servo Reverse" "Servo Forward"
				 "Strobe Early" "Strobe Late"
				 "Servo Reverse -- Strobe Early"  ;NO COMMAS INSIDE STRINGS
				 "Servo Reverse -- Strobe Late"   ; IN MACLISP
				 "Servo Forward -- Strobe Early"
				 "Servo Forward -- Strobe Late")
		      (cdr fcn-name))
            (cc-disk-retry-count 1))              ;for cc-disk-xfer-...
	   ((null fcn-bits))
	   (format t "~%Trying with ~A ---" (car fcn-name))
	   ;; Read that block into core page 3

           (phys-mem-write 1400 525252777)      ;change data
           (cc-disk-seek 0 800. 4 1) ;random seek of cylinder
	   (cc-disk-xfer-track-head-sector (car fcn-bits) cyl head sector 3 1)
           (cc-disk-op 6)           ;Clear servo offset
;           (compare)
       )
       (cond ((= recal 0)
	      (format t "~%[Recalibrating]")
	      (cc-disk-op 1005)     ;Recalibrate
              (cc-disk-wait-idle 4) ;wait Sel Unit Attention - recal done
))))
); If-for-lispm

(if-for-lispm 
(defun cc-disk-clobber (&optional (data 5252525252) cyl head sector
                        &aux disk-adr)
  (cond ((null cyl)					;default from last xfer
         (setq disk-adr (phys-mem-read (+ cc-disk-address 2)))
         (setq cyl (ldb 2014 disk-adr)
               head (ldb 0808 disk-adr)
               sector (ldb 0008 disk-adr))))
  (do ((cc-disk-retry-count 1))
      ((kbd-tyi-no-hang))
      (do i 1400 (1+ i) ( i 2000)
          (phys-mem-write i data))
      ;;Write good data
      (format t "~%Writing ---")	;NO PERIODS IN STRINGS IN MACLISP
      (cc-disk-xfer-track-head-sector 11 cyl head sector 3 1)       ;write it
      (format t "~%Reading ---")
      (cc-disk-xfer-track-head-sector 0 cyl head sector 3 1)        ;read it
      ))
); If-for-lispm

(if-for-lispm
(defun compare (&optional (adr1 1400) ( adr2 2000))
    (do ((adr1 adr1 (1+ adr1))
         (adr2 adr2 (1+ adr2))
         (i 0 (1+ i))
         (dat1)
         (dat2))
        ((= i 400))
        (cond (( (setq dat1 (phys-mem-read adr1)) (setq dat2 (phys-mem-read adr2)))
               (format t "~%~o   ~O--  ~O" adr1 dat1 dat2)))))
); If-for-lispm

(defun cc-disk-seek (fcn-bits cyl head sector)
   (cc-disk-wait-idle 1)
   (phys-mem-write (+ cc-disk-address 2)
                   (+ (lsh head 8)
                      sector
                      (ash cyl 20)))    ;Set seek adr
   (cc-disk-op (+ 4 fcn-bits))      ;Seek op
   (cc-disk-wait-idle 4))           ;wait for selected unit atention

(defun cc-disk-op (fcn)
   (phys-mem-write cc-disk-address fcn)
   (phys-mem-write (+ cc-disk-address 3) 0)		;start operation
   (cc-disk-wait-idle 1))

(defun cc-disk-wait-idle (bit) 		;(&optional (bit 1))
   (do () ((not (zerop (LOGAND bit (phys-mem-read cc-disk-address)))))
       #M (SLEEP-JIFFIES 2)
       #Q (PROCESS-SLEEP 2)
       ))

(defun cc-disk-recalibrate nil 
  (cond 
	(t 
	  (cc-disk-op 1005)     ;Recalibrate
	  (cc-disk-wait-idle 4))) ;wait Sel Unit Attention - recal done
)

;;; INITIALIZES DISK PARAMETERS
(DEFUN CC-DISK-INIT ()
;  (setq marksman-p (= 1 (ldb (bits 2 22.)
;			     (phys-mem-read (+ cc-disk-address 1)))))
  (LET ((CC-DISK-TYPE T))
    (READ-LABEL))
  (SETQ CC-DISK-TYPE T))

;; READ-LABEL is still called from CC-DISK-INIT,
;; READ-LABEL-1 is called from SI:CC-DISK-HANDLER.

(DEFUN READ-LABEL ()
  "Initialize CC parameters giving size of disk tracks, cylinders, etc. from disk label."
  (CC-DISK-WRITE 1 CC-DISK-LOWCORE 1) ;Save on block 1
  (CC-DISK-READ 0 CC-DISK-LOWCORE 1)
  (READ-LABEL-1 CC-DISK-LOWCORE)
  (CC-DISK-READ 1 CC-DISK-LOWCORE 1) ;Restore saved core
  T)

(DEFUN READ-LABEL-1 (LOWCORE)
  "Initialize CC parameters giving size of disk tracks, cylinders, etc. from disk label in page 1.
That is, we assume the debugged machine's disk's label has already been read into core page 1."
  (LET ((B (* LOWCORE 400)))
    (UNLESS (STRING-EQUAL "LABL" (READ-STRING 4 B))
      (FORMAT T "~&Warning: label check word is ~S, not /"LABL/"." (READ-STRING 4 B)))
    (UNLESS (= 1 (PHYS-MEM-READ (1+ B)))
      (FORMAT T "~&Warning: label version is ~D., not 1." (PHYS-MEM-READ (1+ B))))
    (SETQ BLOCKS-PER-TRACK (PHYS-MEM-READ (+ B 4))
	  BLOCKS-PER-CYLINDER (* (PHYS-MEM-READ (+ B 3)) BLOCKS-PER-TRACK)
	  N-CYLINDERS (PHYS-MEM-READ (+ B 2)))))

(DEFUN READ-STRING (NCHARS *ADDR)
   (DO ((WORDS (TRUNCATE (+ NCHARS 3) 4) (1- WORDS))
	(ADDR *ADDR (1+ ADDR))
	(L NIL))
       ((ZEROP WORDS)
	(APPLY 'STRING-APPEND (NREVERSE L)))
     (DO ((WORD (PHYS-MEM-READ ADDR) (#Q ASH #M LSH WORD -10))
	  (CH)
	  (I (COND ((= WORDS 1) (1+ (\ (1- NCHARS) 4))) (T 4)) (1- I)))
	 ((ZEROP I))
       (SETQ CH (LOGAND 377 WORD))
       (OR (= CH 200) (= CH 0)
	   (SETQ L (CONS CH L))))))

;returns t if wins
; if DISK-BLOCK-NUM a list, its (track head sector).
(DEFUN CC-DISK-XFER (FCN DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)
  (PROG (TRACK HEAD SECTOR DUSH ERRCNT STATUS
	 FINAL-DUSH FINAL-ADDRESS FINAL-SECTOR FINAL-HEAD FINAL-TRACK)
     (DECLARE (FIXNUM TRACK HEAD SECTOR DUSH ERRCNT STATUS))
     (COND ((NOT CC-DISK-TYPE)(CC-DISK-INIT)))
     (SETQ ERRCNT CC-DISK-RETRY-COUNT)
     (COND ((NUMBERP DISK-BLOCK-NUM)
	    (SETQ FINAL-ADDRESS (+ DISK-BLOCK-NUM (1- N-BLOCKS)))
	    (IF (ZEROP BLOCKS-PER-CYLINDER)
		(SETQ TRACK 0 HEAD 0 SECTOR DISK-BLOCK-NUM
		      FINAL-TRACK 0 FINAL-HEAD 0 FINAL-SECTOR FINAL-ADDRESS)
	      (SETQ TRACK (TRUNCATE DISK-BLOCK-NUM BLOCKS-PER-CYLINDER))
	      (SETQ SECTOR (\ DISK-BLOCK-NUM BLOCKS-PER-CYLINDER))
	      (SETQ HEAD (TRUNCATE SECTOR BLOCKS-PER-TRACK)
		    SECTOR (\ SECTOR BLOCKS-PER-TRACK))
	      (SETQ FINAL-TRACK (TRUNCATE FINAL-ADDRESS BLOCKS-PER-CYLINDER)
		    FINAL-SECTOR (\ FINAL-ADDRESS BLOCKS-PER-CYLINDER)
		    FINAL-HEAD (TRUNCATE FINAL-SECTOR BLOCKS-PER-TRACK)
		    FINAL-SECTOR (\ FINAL-SECTOR BLOCKS-PER-TRACK))))
	   (T (SETQ TRACK (CAR DISK-BLOCK-NUM)
		    HEAD (CADR DISK-BLOCK-NUM)
		    SECTOR (CADDR DISK-BLOCK-NUM))))		    
     (SETQ DUSH (+ (ASH TRACK 16.) (LSH HEAD 8) SECTOR))
     (AND (> N-BLOCKS 366) ;We only want to use 1 page for the command list
	  (ERROR N-BLOCKS 'TOO-MANY-BLOCKS-FOR-CMD-LIST 'FAIL-ACT))
 LP  ;;Set up the command list, starting at location 12, a bit of a kludge
     (DO ((I 12 (1+ I))
	  (A CORE-PAGE-NUM (1+ A))
	  (N N-BLOCKS (1- N)))
	 ((= N 0))
       (PHYS-MEM-WRITE I (+ (ASH A 8) (COND ((= N 1) 0) (T 1)))))
     (LET ((CTALK-BARF-AT-WRITE-ERRORS NIL))  ;THESE MIGHT NOT READ BACK EXACTLY THE SAME...
      (PROG NIL 
       (PHYS-MEM-WRITE (+ CC-DISK-ADDRESS 0) FCN) ;Store command, does reset
       (PHYS-MEM-WRITE (+ CC-DISK-ADDRESS 1) 12)  ;Store CLP
       (SETQ CC-DISK-LAST-CMD FCN CC-DISK-LAST-CLP 12)
       (PHYS-MEM-WRITE (+ CC-DISK-ADDRESS 2) DUSH)  ;Store disk address
       (PHYS-MEM-WRITE (+ CC-DISK-ADDRESS 0) FCN) ;Store command, does reset
       (PHYS-MEM-WRITE (+ CC-DISK-ADDRESS 3) 0)   ;Start transfer
  WAIT ;;This loop awaits completion
       (AND (ZEROP (LOGAND 1 (SETQ STATUS (PHYS-MEM-READ CC-DISK-ADDRESS))))
	    (GO WAIT))))
     (SETQ FINAL-DUSH (PHYS-MEM-READ (+ CC-DISK-ADDRESS 2)))
     (COND ((NOT (ZEROP (LOGAND STATUS 47777560)))
		; ERROR BITS: INTERNAL PARITY, NXM, MEM PAR, HEADER COMPARE,
		; HEADER ECC, ECC HARD, ECC SOFT, OVERRUN, TRANSFER ABORTED,
		; START-BLOCK ERR, TIMEOUT, SEEK ERR, OFF LINE, OFF CYL, FAULT,
                ;    NO SEL, MUL SEL
	    (CC-DISK-ANALYZE)
	    (AND (ZEROP (SETQ ERRCNT (1- ERRCNT)))
		 (RETURN NIL))	       ;lost
	    (PRINT 'RETRYING)
	    (TERPRI)
	    ;(BREAK CC-DISK-ERROR T)
	    (GO LP))
	   ((AND (NUMBERP FINAL-TRACK)
		 (OR (NOT (= FINAL-TRACK (LDB 2014 FINAL-DUSH)))
		     (NOT (= FINAL-HEAD (LDB 1010 FINAL-DUSH)))
		     (NOT (= FINAL-SECTOR (LDB 0010 FINAL-DUSH)))))
	    (FORMAT T "~%Final disk address incorrect, is ~D,~D,~D; should be ~D,~D,~D"
		    (LDB 2014 FINAL-DUSH) (LDB 1010 FINAL-DUSH) (LDB 0010 FINAL-DUSH)
		    FINAL-TRACK FINAL-HEAD FINAL-SECTOR)
	    (BREAK 'CC-FINAL-DISK-ADDRESS-ERROR T)
	    (GO LP)))
     (RETURN T)		;won
     ))

;SAME AS CC-DISK-XFER, BUT TAKES ARGS IN TRACK, HEAD, SECTOR FORM.
; MAINLY GOOD FOR RETRYING TRANSFERS THAT LOSE, ETC.
(DEFUN CC-DISK-XFER-TRACK-HEAD-SECTOR (FCN TRACK HEAD SECTOR CORE-PAGE-NUM N-BLOCKS)
  (CC-DISK-XFER FCN (LIST TRACK HEAD SECTOR) CORE-PAGE-NUM N-BLOCKS))


;THE QUEUEING/NON-QUEUEING DISTINCTION IS TEMPORARILY NOT PRESENT
(DEFUN CC-DISK-READ (DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)
  (CC-DISK-READ-QUEUEING DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS))

(DEFUN CC-DISK-READ-QUEUEING (DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)
  (AND CC-DISK-TRACE-FLAG (PRINT (LIST 'CC-DISK-READ DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)))
  (CC-DISK-XFER CC-DISK-READ-FCN DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS))

(DEFUN CC-DISK-WRITE (DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)
  (CC-DISK-WRITE-QUEUEING DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS))

(DEFUN CC-DISK-WRITE-QUEUEING (DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)
  (AND CC-DISK-TRACE-FLAG (PRINT (LIST 'CC-DISK-WRITE DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS)))
  (CC-DISK-XFER CC-DISK-WRITE-FCN DISK-BLOCK-NUM CORE-PAGE-NUM N-BLOCKS))

(COMMENT
;;; Old code for doing disk-save and disk-restore with CC.
;;; Commented out because it doesn't know how to work with compressed bands.
;;; Also it uses the old CC disk label mechanism which is being flushed.

;WRITE OUT ALL PAGES WHETHER OR NOT MODIFIED, SINCE WHEN THIS IS
;CALLED THEY OFTEN HAVEN'T GOTTEN TO DISK YET.
(DEFUN CC-DISK-WRITE-OUT-CORE (PARTITION-NAME)
  (LET ((X (GET-PARTITION-START-AND-SIZE PARTITION-NAME)))
    (LET ((PARTITION-START (CAR X)) (PARTITION-SIZE (CDR X)))
      (DO ((PHT-LOC (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-PNTR)))
                    (+ 2 PHT-LOC))
	   (PHT-COUNT (TRUNCATE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE))) 2)
		      (1- PHT-COUNT))
	   (PHT1)
	   (PHT2))
	  ((= 0 PHT-COUNT))
	(DECLARE (FIXNUM PHT-LOC PHT-COUNT PHT1 PHT2))
	(AND (NOT (ZEROP (LOGLDB %%PHT1-VALID-BIT
				  (SETQ PHT1 (PHYS-MEM-READ PHT-LOC)))))	;IF PAGE EXISTS
	     (NOT (= (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1)
		     %PHT-DUMMY-VIRTUAL-ADDRESS))		;AND ISN'T A DUMMY
	     (PROGN					;THEN WRITE IT OUT
	       (SETQ PHT2 (PHYS-MEM-READ (1+ PHT-LOC)))
	       (OR (< (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1) PARTITION-SIZE)
		   (ERROR '|Core doesn't fit in the partition; partition has been clobbered.|
			  (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1) 'FAIL-ACT))
	       (CC-DISK-WRITE-QUEUEING
			      (+ PARTITION-START
				 (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1))
			      (LOGLDB %%PHT2-PHYSICAL-PAGE-NUMBER PHT2)
			      1)
	       (OR (= (LOGLDB %%PHT1-SWAP-STATUS-CODE PHT1) %PHT-SWAP-STATUS-WIRED)
		   (PROGN					;IF NOT WIRED, REMOVE FROM CORE AND
		     (PHYS-MEM-WRITE PHT-LOC
				     (LOGDPB %PHT-DUMMY-VIRTUAL-ADDRESS	;STORE BACK DUMMY ENTRY
					      %%PHT1-VIRTUAL-PAGE-NUMBER
					      (LOGDPB %PHT-SWAP-STATUS-FLUSHABLE
						       %%PHT1-SWAP-STATUS-CODE
						       PHT1)))
		     (PHYS-MEM-WRITE (1+ PHT-LOC)
			     (LOGDPB 200 ;READ-ONLY
				     %%PHT2-ACCESS-STATUS-AND-META-BITS PHT2)))))))
      ;NOW WRITE OUT THE PAGE HASH TABLE AGAIN SINCE IT'S BEEN MODIFIED
      ;1P AT A TIME SINCE MIGHT BE BIGGER THAN THE MAP OR SOMETHING
      ((LAMBDA (PHT-FIRST-PAGE PHT-N-PAGES)
         (DECLARE (FIXNUM PHT-FIRST-PAGE PHT-N-PAGES))
	 (DO ((DA (+ PARTITION-START PHT-FIRST-PAGE) (1+ DA))
	      (PG PHT-FIRST-PAGE (1+ PG))
	      (N PHT-N-PAGES (1- N)))
	     ((= N 0))
	   (DECLARE (FIXNUM DA PG N))
	   (CC-DISK-WRITE-QUEUEING DA PG 1)))
       (TRUNCATE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-PNTR))) 400)
       (TRUNCATE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE))) 400)))
  )) ;DONE, NO NEED TO FLUSH QUEUE SINCE NOT USING QUEUEING NOW

(DEFUN CC-DISK-READ-IN-CORE (PARTITION-NAME)
  (LET ((X (GET-PARTITION-START-AND-SIZE PARTITION-NAME)))
    (LET ((PARTITION-START (CAR X)))
      (QF-CLEAR-CACHE T)			;INVALIDATING CONTENTS OF CORE
      (CC-DISK-READ-QUEUEING (1+ (CAR X)) 1 1)	;GET SYSTEM-COMMUNICATION-AREA
      (DO ((PHT-LOC (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-PNTR))))
	   (PHT-COUNT (CEILING (QF-POINTER
                                  (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE)))
			       400))
	   )
	  NIL
	(DECLARE (FIXNUM PHT-LOC PHT-COUNT))
	(DO J 0 (+ J 1) (NOT (< J PHT-COUNT))		;GET PAGE-TABLE-AREA, 1P AT A TIME
	    (CC-DISK-READ-QUEUEING
			  (+ PARTITION-START (TRUNCATE PHT-LOC 400) J)
			  (+ (TRUNCATE PHT-LOC 400) J)
			  1)))				;NOW READ IN ALL THE PAGES
      (DO ((PHT-LOC (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-PNTR)) (+ 2 PHT-LOC))
	   (PHT-COUNT (TRUNCATE (QF-POINTER (PHYS-MEM-READ (+ 400 %SYS-COM-PAGE-TABLE-SIZE))) 2)
		      (1- PHT-COUNT))
	   (PHT1) 
	   (PG))
	  ((= 0 PHT-COUNT))
	(DECLARE (FIXNUM PHT-LOC PHT-COUNT PHT1 PG))
	(AND (NOT (ZEROP (LOGLDB %%PHT1-VALID-BIT (SETQ PHT1 (PHYS-MEM-READ PHT-LOC)))))
	     (NOT (= (SETQ PG (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1))
		     %PHT-DUMMY-VIRTUAL-ADDRESS))		;NOT DUMMY
	     ;; Don't read in the MICRO-CODE-SYMBOL-AREA, it's part of the ucode logically.
	     (OR (< PG MICRO-CODE-SYMBOL-AREA-START) (NOT (< PG MICRO-CODE-SYMBOL-AREA-END)))
	     (CC-DISK-READ-QUEUEING
			   (+ PARTITION-START PG)
			   (LOGLDB %%PHT2-PHYSICAL-PAGE-NUMBER (PHYS-MEM-READ (1+ PHT-LOC)))
			   1)))
  ))) ;NO NEED TO EMPTY QUEUE SINCE NOT CURRENTLY USING QUEUEING
    
(DEFUN CC-DISK-SAVE (PARTITION)
  (COND	((NUMBERP PARTITION)
	 (SETQ PARTITION (INTERN (STRING-APPEND "LOD" (+ 60 PARTITION))))))
  (GET-PARTITION-START-AND-SIZE PARTITION) ;CAUSE AN ERROR IF NOT A KNOWN PARTITION
  (CC-DISK-WRITE-OUT-CORE 'PAGE)
  (CC-DISK-COPY-PARTITION 'PAGE PARTITION)
  (CC-DISK-READ-IN-CORE 'PAGE))

(DEFUN CC-DISK-RESTORE NARGS
  (LET ((PARTITION (AND (= NARGS 1) (ARG 1))))
    (COND ((NULL PARTITION)
	   (AND (> NARGS 1) (ERROR '|TOO MANY ARGS - CC-DISK-RESTORE| NARGS))
	   (CC-DISK-INIT)  ;Use pack editor to find out what is current default load
	   (SETQ PARTITION INITIAL-LOD-NAME))
	  ((NUMBERP PARTITION)
	   (SETQ PARTITION (INTERN (STRING-APPEND "LOD" (+ 60 PARTITION))))))
    (GET-PARTITION-START-AND-SIZE PARTITION) ;CAUSE AN ERROR IF NOT A KNOWN PARTITION
    (CC-DISK-COPY-PARTITION PARTITION 'PAGE)
    (CC-DISK-READ-IN-CORE 'PAGE)))

(DEFUN GET-PARTITION-START-AND-SIZE (PARTITION-NAME)
  (CC-DISK-INIT)
  (DO ((I 0 (1+ I)))
      ((NOT (< I N-PARTITIONS))
       (ERROR '|No such partition| PARTITION-NAME))
   (COND ((SAMEPNAMEP (ARRAYCALL T PARTITION-NAMES I) PARTITION-NAME)
	  (RETURN (CONS (ARRAYCALL FIXNUM PARTITION-START I)
			(ARRAYCALL FIXNUM PARTITION-SIZE I)))))))

) ;end COMMENT

(DECLARE (SPECIAL CC-DISK-LOWCORE CC-DISK-HIGHCORE))
(SETQ CC-DISK-LOWCORE 10 CC-DISK-HIGHCORE 300)

(DEFUN CC-DISK-COPY-PARTITION (FROM-PARTITION TO-PARTITION)
  (LET (FROM-START FROM-SIZE TO-START TO-SIZE)
    (SETF (VALUES FROM-START FROM-SIZE)
	  (SI:FIND-DISK-PARTITION FROM-PARTITION NIL "cc"))
    (SETF (VALUES TO-START TO-SIZE)
	  (SI:FIND-DISK-PARTITION TO-PARTITION NIL "cc"))
    (COND ((< TO-SIZE FROM-SIZE)
	   (OR (Y-OR-N-P "~A is smaller.  Continue anyway? " TO-PARTITION)
	       (FERROR NIL "~A is smaller than ~A." TO-PARTITION FROM-PARTITION))))
    ;;ALL NUMBERS WITHIN THIS DO ARE IN PAGES, NOT WORDS.
    (DO ((LOWCORE CC-DISK-LOWCORE)	;DON'T SMASH BOTTOM 2K WITH SYSTEM-COMMUNICATION, ETC.
	 (HIGHCORE CC-DISK-HIGHCORE)	;ONLY RELY ON 48K BEING PRESENT 
	 (RELADR 0 (+ RELADR (- HIGHCORE LOWCORE))))	;THIS IS RELATIVE LOC WITHIN PARTITION
	((NOT (< RELADR (MIN FROM-SIZE TO-SIZE))))
      (CC-DISK-READ-QUEUEING
	(+ FROM-START RELADR)
	LOWCORE
	(MIN (- FROM-SIZE RELADR) (- HIGHCORE LOWCORE)))
      (CC-DISK-WRITE-QUEUEING
	(+ TO-START RELADR)
	LOWCORE
	(MIN (- TO-SIZE RELADR) (- HIGHCORE LOWCORE)))
      )))					;DONE, NO NEED TO EMPTY QUEUE IN THIS VERSION

;;; Obsolete user interface functions, now rigged to go through the standard mechanism.

(DEFUN CC-SET-CURRENT-MICROLOAD (PART)
  "Change the current version of microcode on the machine being debugged to be PART."
  (SET-CURRENT-MICROLOAD PART "CC"))

(DEFUN CC-SET-CURRENT-BAND (PART)
  "Change the current LOD partion of the machine being debugged."
  (SET-CURRENT-BAND PART "CC"))

;;; Only works on the real machine.
(DEFUN CC-PRINT-DISK-LABEL ()  ;This is what I always think it is named. -- DLW
  "Show what the disk label is on the machine that is connected via debugging cables."
  (PRINT-DISK-LABEL "CC"))

(DEFUN CC-CHECK-PAGE-HASH-TABLE-ACCESSIBILITY ()
  "Check debugged machine's PHT for inconsistencies.
We report any entry which is positioned wrong
such that a hash lookup would not find it."
  (DO ((TABLE-ADR PHT-ADDR (+ TABLE-ADR 2))
       (HASH-ADR)
       (PHT1)
       (COUNT (LSH (QF-POINTER (PHYS-MEM-READ (+ PAGE-SIZE %SYS-COM-PAGE-TABLE-SIZE))) -1)
	      (1- COUNT))
       (NUMBER-ERRORS 0))
      ((= COUNT 0) NUMBER-ERRORS)
   (DECLARE (FIXNUM TABLE-ADR HASH-ADR COUNT))
   (SETQ PHT1 (PHYS-MEM-READ TABLE-ADR))
   (COND ((= 0 (LOGLDB %%PHT1-VALID-BIT PHT1)))
	 ((= %PHT-DUMMY-VIRTUAL-ADDRESS (LOGLDB %%PHT1-VIRTUAL-PAGE-NUMBER PHT1))) ;DUMMY
         ((NOT (= TABLE-ADR 
		  (SETQ HASH-ADR (QF-PAGE-HASH-TABLE-LOOKUP (LOGAND PHT1 77777400)))))
	   (PRINT (LIST '(HASH TABLE PAIR AT PHYS MEM ADR) TABLE-ADR '(NOT ACCESSIBLE)))
	   (PRINT (LIST '(HASH LOOKUP RETURNS) HASH-ADR))
	   (SETQ NUMBER-ERRORS (1+ NUMBER-ERRORS)) ))))

(DEFUN FORMAT-DISK-PACK (&AUX (NHEADS 5))
  (IF (Y-OR-N-P "Is the drive a T-300? ")
      (SETQ NHEADS 19.))
  (WHEN (Y-OR-N-P "Load the formatting microcode (You won't have much luck without it)? ")
    (CC-LOAD-UCODE "SYS: UBIN; DCFU ULOAD"))
  (CC-SYMBOLIC-DEPOSIT-REGISTER 'M-NHEADS NHEADS)
  (SETQ CC-UPDATE-DISPLAY-FLAG T)
  (CC-REGISTER-DEPOSIT RASA (CC-SYMBOLIC-CMEM-ADR 'START))
  (CC-REGISTER-DEPOSIT RAGO 0)
  (PROCESS-WAIT "Formatting"
		#'(LAMBDA () (ZEROP (CC-REGISTER-EXAMINE RAGO))))
  (CC-REGISTER-DEPOSIT RASTOP 0)
  (COND ((= (CC-REGISTER-EXAMINE RAPC)
	    (CC-SYMBOLIC-CMEM-ADR 'DONE))
	 (FORMAT T "~&Formatting completed sucessfully"))
	(T 
	 (FORMAT T "~&Formatting failed at ~S (~O)~%"
		 (CC-FIND-CLOSEST-SYM (+ RACMO (CC-REGISTER-EXAMINE RAPC)))
		 (CC-REGISTER-EXAMINE RAPC))
	 (FORMAT T "Run CC-DISK-ANALYZE and CC to find out why"))))

;Called on startup (analogous to the PDUMP function on the 10)
(IF-FOR-LISPM
(DEFUN CC-INITIALIZE-ON-STARTUP ()
  (SETQ CC-FULL-SAVE-VALID NIL)
  (SETQ CC-PASSIVE-SAVE-VALID NIL)
  (SETQ CC-DISK-TYPE NIL)))

(IF-FOR-LISPM (ADD-INITIALIZATION "CADR" '(CC-INITIALIZE-ON-STARTUP) '(BEFORE-COLD)))
