;;; -*- Mode: Lisp; Package: FILE-SYSTEM; Base: 8.; Patch-File: T -*-
;;; Patch file for Local-File version 48.4
;;; Reason: :SUPERSEDE bug.  OPENING-INPUT-FILE bug.
;;; Written 8-Feb-84 07:20:46 by Mly,
;;; while running on Lisp Machine Thirty-two from band 7
;;; with Don't-dump-a-band! Inconsistent (unreleased patches loaded) System 98.34, CADR 3.6, ZMail 53.10, MIT-Specific 22.0, Experimental Local-File 48.0, microcode 306.



; From file FSGUTS.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSGUTS  "

(DEFUN LOOKUP-FILE (DIRSPEC NAME TYPE VERSION
		    &OPTIONAL IF-DOES-NOT-EXIST IF-EXISTS (REALLY-OPEN ':DIRECTORY-OK)
		    (DELETED? T))
  "The basic function for finding files.
If REALLY-OPEN is T, we increment the open count of the file,
and get an error if it is a directory.
If REALLY-OPEN is :DIRECTORY-OK (the default), we increment but allow directories.
If REALLY-OPEN is NIL, we do not increment the open count.
DELETED? non-NIL means deleted files can be opened."
  (%STORE-CONDITIONAL (LOCF DIRSPEC) ':WILD "*")
  (%STORE-CONDITIONAL (LOCF NAME) ':WILD "*")
  (%STORE-CONDITIONAL (LOCF TYPE) ':WILD "*")
  (%STORE-CONDITIONAL (LOCF TYPE) ':UNSPECIFIC "")
  (%STORE-CONDITIONAL (LOCF VERSION) ':UNSPECIFIC ':NEWEST)
  (LET ((DIRECTORY (IF (NAMED-STRUCTURE-P DIRSPEC) DIRSPEC
		     (LOOKUP-DIRECTORY DIRSPEC)))
	NO-NEW-VERSION
	USE-EXISTING
	OLD-FILE)
    (BLOCK WIN
      (LM-LOOKUP-ERROR
	;; Must not allow recursive locking -- see LMFS-OPEN-OUTPUT-FILE.
	(LOCKING (DIRECTORY-LOCK DIRECTORY)
	  (*CATCH 'LOOKUP-FILE-ERROR
	    (MULTIPLE-VALUE-BIND (FILE LOC LAST-VERSION-SEEN)
		(COND ((AND (EQ VERSION ':NEWEST) (EQ IF-EXISTS ':NEW-VERSION))
		       (MULTIPLE-VALUE-BIND (FILE LOC LAST-VERSION-SEEN)
			   (LOOKUP-NEWEST-FILE DIRECTORY NAME TYPE)
			 (VALUES FILE
				 (IF FILE (CDR LOC) LOC)
				 LAST-VERSION-SEEN)))
		      ((MEMQ VERSION '(:NEWEST 0))
		       (IF DELETED?
			   (LOOKUP-NEWEST-FILE DIRECTORY NAME TYPE)
			 (LOOKUP-NEWEST-NON-DELETED-FILE DIRECTORY NAME TYPE)))
		      ((EQ VERSION ':OLDEST)
		       (IF (OR DELETED? (EQ IF-EXISTS ':NEW-VERSION))
			   (LOOKUP-OLDEST-FILE DIRECTORY NAME TYPE)
			 (LOOKUP-OLDEST-NON-DELETED-FILE DIRECTORY NAME TYPE)))
		      ;; Depends on extra vars in MULTIPLE-VALUE-BIND
		      ;; becoming bound to NIL.
		      ((MINUSP VERSION)
		       (LET ((NEWEST (LOOKUP-NEWEST-FILE DIRECTORY NAME TYPE)))
			 (IF (NULL NEWEST)
			     (*THROW 'LOOKUP-FILE-ERROR 'FILE-NOT-FOUND))
			 (LOOKUP-NAMED-FILE DIRECTORY NAME TYPE
					    (+ (FILE-VERSION NEWEST) VERSION))))
		      (T
		       (LOOKUP-NAMED-FILE DIRECTORY NAME TYPE VERSION)))
	      (IF (AND FILE (DIRECTORY? FILE) REALLY-OPEN
		       (NEQ REALLY-OPEN ':DIRECTORY-OK))
		  (*THROW 'LOOKUP-FILE-ERROR 'FILE-IS-SUBDIRECTORY))
	      (IF (OR (NULL FILE)
		      (AND (NOT DELETED?)
			   (FILE-DELETED? FILE)))
		  ;; File "does not exist".
		  (ECASE IF-DOES-NOT-EXIST
		    ((NIL) (RETURN-FROM WIN NIL))
		    (:ERROR
		     (*THROW 'LOOKUP-FILE-ERROR
			     (IF FILE 'OPEN-DELETED-FILE 'FILE-NOT-FOUND)))
		    (:CREATE NIL))
		;; File "exists".  Should we use it?
		(ECASE IF-EXISTS
		  ((NIL)
		   (SETQ USE-EXISTING T))
		  (:NEW-VERSION
		   (UNLESS (MEMQ VERSION '(:NEWEST :OLDEST)) (SETQ USE-EXISTING T)))
		  (:SUPERSEDE (SETQ NO-NEW-VERSION T) (SETQ USE-EXISTING T))
		  ((:OVERWRITE :TRUNCATE :APPEND)
		   (UNLESS (ZEROP (FILE-OPEN-COUNT FILE))
		     (*THROW 'LOOKUP-FILE-ERROR 'FILE-LOCKED))
		   (SETQ USE-EXISTING T))
		  (:ERROR
		   (*THROW 'LOOKUP-FILE-ERROR 'FILE-ALREADY-EXISTS))
		  ((:RENAME :RENAME-AND-DELETE)
		   (SETQ OLD-FILE FILE))))
	      (RETURN-FROM WIN
		(IF USE-EXISTING
		    (PROGN
		      (IF REALLY-OPEN
			  (IF (MEMQ IF-EXISTS '(:OVERWRITE :TRUNCATE :APPEND))
			      (LMFS-OPEN-OVERWRITE-FILE FILE)
			    (LMFS-OPEN-INPUT-FILE FILE)))
		      FILE)
		  (VALUES
		    (LMFS-OPEN-OUTPUT-FILE
		      DIRECTORY LOC NAME TYPE
		      (COND ((EQ VERSION ':NEWEST)
			     (IF (NULL LAST-VERSION-SEEN)
				 1
			       (IF NO-NEW-VERSION
				   LAST-VERSION-SEEN
				 (1+ LAST-VERSION-SEEN))))
			    ((EQ VERSION ':OLDEST)
			     (IF (NULL LAST-VERSION-SEEN)
				 1
			       (IF NO-NEW-VERSION
				   LAST-VERSION-SEEN
				 (1- LAST-VERSION-SEEN))))
			    ((NUMBERP VERSION)
			     (COND ((MINUSP VERSION)
				    (*THROW 'LOOKUP-FILE-ERROR 'FILE-NOT-FOUND))
				   ((NOT (< VERSION 1_16.))
				    (*THROW 'LOOKUP-FILE-ERROR 'VERSION-TOO-LARGE))
				   ((ZEROP VERSION)
				    (OR LAST-VERSION-SEEN 1))
				   (T VERSION))))
		      (UNLESS (AND (MEMQ VERSION '(:NEWEST :OLDEST))
				   (NOT NO-NEW-VERSION))
			FILE))
		    OLD-FILE))))))
	DIRECTORY NAME TYPE VERSION))))

))

; From file FSDEFS.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSDEFS  "

(DEFMACRO OPENING-INPUT-FILE ((FILE DIRECTORY NAME TYPE VERSION) &BODY BODY)
  `(LET ((,FILE NIL))
     (UNWIND-PROTECT
       (PROGN
	 (SETQ ,FILE (LOOKUP-FILE ,DIRECTORY ,NAME ,TYPE ,VERSION ':ERROR NIL T))
	 . ,BODY)
       (IF (NOT (NULL ,FILE))
	   (LMFS-CLOSE-FILE ,FILE)))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :DELETE) (ERROR-P)
  (IDENTIFY-FILE-OPERATION ':DELETE
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
        (LMFS-DELETE-FILE FILE)))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :UNDELETE) (ERROR-P)
  (IDENTIFY-FILE-OPERATION ':UNDELETE
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
        (LMFS-UNDELETE-FILE FILE)))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :DELETE-MULTIPLE-FILES) (ERROR-P PATHNAMES)
  (IDENTIFY-FILE-OPERATION ':DELETE
    (HANDLING-ERRORS ERROR-P
       (LOOP FOR PATHNAME IN PATHNAMES
	     WITH FILES-OF-DIRECTORY-TO-WRITE = NIL
	     DO (OPENING-INPUT-FILE (FILE (PATHNAME-DIRECTORY PATHNAME)
					  (PATHNAME-NAME PATHNAME)
					  (PATHNAME-TYPE PATHNAME)
					  (PATHNAME-VERSION PATHNAME))
		   (LMFS-DELETE-FILE FILE NIL)
		   (LOOP FOR ENTRY IN FILES-OF-DIRECTORY-TO-WRITE
			 WHEN (EQUAL (FILE-DIRECTORY FILE) (FILE-DIRECTORY ENTRY))
			 RETURN NIL
			 FINALLY (PUSH FILE FILES-OF-DIRECTORY-TO-WRITE)))
	     FINALLY
	     (DOLIST (FILE FILES-OF-DIRECTORY-TO-WRITE)
	       (WRITE-DIRECTORY-OF-FILE FILE))))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :RENAME) (NEW-NAME ERROR-P)
  (IDENTIFY-FILE-OPERATION ':RENAME
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
	(LMFS-RENAME-FILE FILE
			  (PATHNAME-DIRECTORY NEW-NAME)
			  (OR (PATHNAME-NAME NEW-NAME) "FOO")
			  (OR (PATHNAME-TYPE NEW-NAME) ':UNSPECIFIC)
			  (PATHNAME-VERSION NEW-NAME))))))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :MULTIPLE-FILE-PLISTS) (PATHNAMES OPTIONS)
  "This is a hack to speed up DIRED.
There are no currently meaningful options." OPTIONS
  (IDENTIFY-FILE-OPERATION ':PROPERTIES
    (MAPCAR #'(LAMBDA (PATHNAME)
		(LET ((TPATHNAME (SEND PATHNAME ':TRANSLATED-PATHNAME)))
		  (OPENING-INPUT-FILE (FILE (PATHNAME-DIRECTORY TPATHNAME)
					    (PATHNAME-NAME TPATHNAME)
					    (PATHNAME-TYPE TPATHNAME)
					    (PATHNAME-VERSION TPATHNAME))
		    (IF (NULL FILE)
			(LIST PATHNAME)
		      (LIST* PATHNAME
			     ':TRUENAME (FILE-TRUENAME FILE)
			     (LMFS-FILE-PROPERTIES FILE))))))
	    PATHNAMES)))

))

; From file FSNAME.LISP PS:<L.FILE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; FSNAME  "

(DEFMETHOD (LOCAL-FILE-MIXIN :CHANGE-PROPERTIES) (ERROR-P &REST PLIST)
  (IDENTIFY-FILE-OPERATION ':CHANGE-PROPERTIES
    (HANDLING-ERRORS ERROR-P
      (OPENING-INPUT-FILE (FILE DIRECTORY NAME TYPE VERSION)
	(LMFS-CHANGE-FILE-PROPERTIES FILE PLIST)))))

))
