;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 1-Jan-84 10:14:29 by Mly,
;;; Reason: Bug in Meta-X Copy File.
;;; while running on Lisp Machine Eighteen from band 5
;;; with Experimental System 98.16, CADR 3.4, Experimental ZMail 53.5, MIT-Specific 22.0, microcode 306, ZM MIT.



; From file FILES.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; FILES  "

(DEFUN COPY-FILE-1 (COPY-MODE COPY-CREATION-DATE?)
  (LET* ((FILE-TYPE-STRING
	   (SELECTQ COPY-MODE
	     (:CHARACTERS "Copy text file")
	     (:BINARY "Copy binary file")
	     (OTHERWISE "Copy file")))
	 (PATHNAME
	   (READ-DEFAULTED-PATHNAME (FORMAT NIL "~A:" FILE-TYPE-STRING)
				    (PATHNAME-DEFAULTS)))
	 (TO-SPEC (READ-UNDEFAULTED-PATHNAME-STRING
		    (FORMAT NIL "Copy file ~A to:" PATHNAME)
		    PATHNAME)))
    (OR COPY-MODE (SETQ COPY-MODE ':DEFAULT))
    (IF (SEND PATHNAME ':WILD-P)
	(LET ((DIR (CDR (FS:DIRECTORY-LIST PATHNAME)))
	      (TO-PATHNAME (FS:MERGE-PATHNAMES TO-SPEC PATHNAME)))
	  (FORMAT T "~&Files to be copied:~%")
	  (MAPC *DIRECTORY-SINGLE-FILE-LISTER* DIR)
	  (WHEN (LET ((QUERY-IO STANDARD-OUTPUT))
		  (Y-OR-N-P "Copy them all? "))
	    (DOLIST (ELT DIR)
	      (CONDITION-CASE (ERROR)
		  (COPY-FILE (CAR ELT)
			     (SEND PATHNAME ':TRANSLATE-WILD-PATHNAME TO-PATHNAME (CAR ELT))
			     ':COPY-CREATION-DATE COPY-CREATION-DATE?
			     ':COPY-AUTHOR COPY-CREATION-DATE?
			     ':CHARACTERS COPY-MODE
			     ':REPORT-STREAM STANDARD-OUTPUT)
		((FS:FILE-ERROR SYS:REMOTE-NETWORK-ERROR)
		 (FORMAT T "~&Copy failure: ~A" ERROR))))
	    (FORMAT T "~&Done.~%")))
      (CONDITION-CASE (VALUE)
	  (COPY-FILE PATHNAME TO-SPEC
		     ':COPY-CREATION-DATE COPY-CREATION-DATE?
		     ':COPY-AUTHOR COPY-CREATION-DATE?
		     ':CHARACTERS COPY-MODE
		     ':REPORT-STREAM QUERY-IO)
	((FS:FILE-ERROR SYS:REMOTE-NETWORK-ERROR)
	 (BARF VALUE))))))

))
