;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Patch file for System version 98.23
;;; Reason: Zmacs buffer histories (as used by c-m-l, etc) include all buffers
;;;  c-x c-b lists per-buffer history
;;; tv:update-font-maps -- use this after loading a new copy of an old font
;;; Stuff left out of documenting flavors
;;; Written 3-Jan-84 00:54:11 by Mly,
;;; while running on Lisp Machine Two from band 6
;;; with Don't-dump-a-band! Inconsistent (unreleased patches loaded) System 98.20, CADR 3.4, Inconsistent (unreleased patches loaded) ZMail 53.9, MIT-Specific 22.0, microcode 306, ZM MIT.


; From file ZMACS.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; ZMACS  "

(DEFCOM COM-LIST-BUFFERS "Print a list of the all buffers and their files (or sizes)." ()
  (LET* ((STAR-FLAG NIL) (PLUS-FLAG NIL) (EQV-FLAG NIL) (CIRCLE-PLUS-FLAG NIL)
	 (MAX-SIZE (MIN 40. (- (FUNCALL STANDARD-OUTPUT ':SIZE-IN-CHARACTERS) 40.)))
	 (VERSION-POS (MIN (MAX (+ (FIND-MAXIMUM-BUFFER-NAME-LENGTH MAX-SIZE) 3) 16.)
			   (+ MAX-SIZE 2))))
    (FORMAT T
	    "~&Buffers in ZWEI:~%  Buffer name:~vTFile Version:~vTMajor mode:~2%"
	    VERSION-POS (+ VERSION-POS 15.))
    (DOLIST (BUFFER (HISTORY-LIST (SEND *WINDOW* ':BUFFER-HISTORY)))
                    ;;was *ZMACS-BUFFER-LIST* -- same thing, different ordering
      (LET ((FILE-ID (BUFFER-FILE-ID BUFFER))
	    (NAME) (FLAG))
	(TYO (COND ((EQ FILE-ID T)
		    (SETQ PLUS-FLAG T) #/+)	;+ means new file, never written out
		   ((BUFFER-READ-ONLY-P BUFFER)
		    (SETQ EQV-FLAG T) #/)	; means read-only
		   ((BUFFER-MODIFIED-P BUFFER)
		    (SETQ STAR-FLAG T) #/*)	;* means has unsaved changes.
		   (T #\SP))			;blank if unmodified.
	     STANDARD-OUTPUT)
	(TYO #\SP STANDARD-OUTPUT)
	(MULTIPLE-VALUE (NAME FLAG)
	  (NAME-FOR-DISPLAY BUFFER MAX-SIZE))
	(IF FLAG (SETQ CIRCLE-PLUS-FLAG FLAG))
	(LET ((MAJOR-MODE (BUFFER-MAJOR-MODE BUFFER)))
	  (FUNCALL STANDARD-OUTPUT ':ITEM 'ZMACS-BUFFER BUFFER
		   "~A~vT~:[ [~D Line~:P]~*~;~*~@[~A~]~]~vT(~A)"
		   NAME VERSION-POS
		   FILE-ID
		   (AND (NULL FILE-ID) (COUNT-LINES-BUFFER BUFFER))
		   (IF (MEMQ MAJOR-MODE '(DIRED-MODE BDIRED-MODE))
		       (BUFFER-PATHNAME BUFFER)
		       (BUFFER-VERSION-STRING BUFFER))
		   (+ VERSION-POS 20.)
		   (SYMEVAL MAJOR-MODE)))
	(TERPRI STANDARD-OUTPUT)))
    (TERPRI STANDARD-OUTPUT) ;extra TERPRI to show you that it's finished.
    (AND PLUS-FLAG (PRINC "+ means new file.  " STANDARD-OUTPUT))
    (AND STAR-FLAG (PRINC "* means buffer modified.  " STANDARD-OUTPUT))
    (AND EQV-FLAG (PRINC " means read-only.  " STANDARD-OUTPUT))
    (AND CIRCLE-PLUS-FLAG (PRINC "  means name truncated." STANDARD-OUTPUT))
    (AND (OR PLUS-FLAG STAR-FLAG EQV-FLAG CIRCLE-PLUS-FLAG) (TERPRI STANDARD-OUTPUT))
    DIS-NONE))

))

; From file HISTORY.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; HISTORY  "

(DEFUN APPEND-REMOVE-ON-HISTORY (ELEMENT HISTORY)
  "Append ELEMENT to the end of HISTORY, removing it if it appears earlier.
Does not affect HISTORY's yank-pointer."
  (SETF (HISTORY-LIST HISTORY)
	(APPEND (REMQ ELEMENT (HISTORY-LIST HISTORY)) (LIST ELEMENT)))
  (SETF (HISTORY-LENGTH HISTORY) (LENGTH (HISTORY-LIST HISTORY)))
  ELEMENT)

))

; From file METH.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; METH  "

(DEFMETHOD (ZMACS-BUFFER :ACTIVATE) (&OPTIONAL ASK-FOR-NEW-NAME)
  (WITHOUT-INTERRUPTS
    ;; First, if buffer is not already on name alist, put it on,
    ;; getting a new name if necessary and appropriate.
    (UNLESS (RASSQ SELF *ZMACS-BUFFER-NAME-ALIST*)
      (DO () ((NOT (ASS 'EQUALP NAME *ZMACS-BUFFER-NAME-ALIST*)))
	(IF ASK-FOR-NEW-NAME
	    (LET ((INHIBIT-SCHEDULING-FLAG NIL))
	      (IF (AND PATHNAME
		       (NOT (BUFFER-PATHNAME (CDR (ASS 'EQUALP NAME
						       *ZMACS-BUFFER-NAME-ALIST*)))))
		  ;; This is visiting a file and the other is not.
		  (SEND (CDR (ASS 'EQUALP NAME *ZMACS-BUFFER-NAME-ALIST*))
			':RENAME
			(DO ((NAME1 NAME)
			     (FIRST T NIL))
			    (())
			  (SETQ NAME1
				(TYPEIN-LINE-READLINE
				  (IF FIRST
				      "There is a non-file buffer ~A.  Rename it to: "
				    "~A is in use too.  Try again.")
				  NAME1))
			  (UNLESS (ASS 'EQUALP NAME1 *ZMACS-BUFFER-NAME-ALIST*)
			    (RETURN NAME1))))
		(SETQ NAME 
		      (TYPEIN-LINE-READLINE
			"There is already a buffer named ~A.  Specify another name:"
			NAME))))
	  (BARF "There is already a buffer named ~A." NAME)))
      (PUSH (CONS NAME SELF) *ZMACS-BUFFER-NAME-ALIST*)
      (SETQ *ZMACS-BUFFER-NAME-ALIST*
	    (COPYALIST *ZMACS-BUFFER-NAME-ALIST*))
      (DOLIST (ELT *ZMACS-BUFFER-NAME-ALIST*)
	(SETF (CAR ELT) (SI:COPY-OBJECT (CAR ELT)))))
    ;; Put the buffer on the other lists, if not already there.
    (UNLESS (MEMQ SELF *ZMACS-BUFFER-LIST*)
      (SETQ *ZMACS-BUFFER-LIST* (APPEND *ZMACS-BUFFER-LIST* (LIST SELF)))
      ;;Append to the histories of all the windows
      ;; The histories contain the same elements as *ZMACS-BUFFER-LIST*, though in different
      ;; orders. Thus they are not strictly historical, since they include buffers
      ;; which have never been selected. This is more convenient, though.
      (DOLIST (W *ALL-ZMACS-WINDOWS*)
	(LET ((HISTORY (SEND W ':BUFFER-HISTORY)))
	  (APPEND-REMOVE-ON-HISTORY SELF HISTORY))))))

))

; From file SCREEN.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; SCREEN  "

(DEFMETHOD (ZMACS-WINDOW :AFTER :INIT) (IGNORE)
  (SETF (HISTORY-NAME BUFFER-HISTORY) (STRING-APPEND "buffer selection history for "
						     TV:NAME)
	(HISTORY-LIST BUFFER-HISTORY) (COPYLIST *ZMACS-BUFFER-LIST*)
	(HISTORY-LENGTH BUFFER-HISTORY) (LENGTH *ZMACS-BUFFER-LIST*))
  (PUSH-REMOVE-ON-HISTORY INTERVAL BUFFER-HISTORY))

))

; From file METH.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; METH  "

(DEFMETHOD (ZMACS-WINDOW :EXIT-SPECIAL-BUFFER) (&OPTIONAL MARK-CLEAN BUFFER-BEING-EXITED)
  (LET ((SPECIAL-BUFFER (OR BUFFER-BEING-EXITED *INTERVAL*)))
    (AND MARK-CLEAN (NOT-MODIFIED SPECIAL-BUFFER))
    (IF (EQ SPECIAL-BUFFER *INTERVAL*)
	(MAKE-BUFFER-CURRENT (OR (CAR (MEM 'NEQ SPECIAL-BUFFER (HISTORY-LIST BUFFER-HISTORY)))
				 *INTERVAL*)))
    (WITHOUT-INTERRUPTS
      (DOLIST (W *ALL-ZMACS-WINDOWS*)
	(LET ((HISTORY (SEND W ':BUFFER-HISTORY)))
	  (APPEND-REMOVE-ON-HISTORY SPECIAL-BUFFER HISTORY)))
      (SETQ *ZMACS-BUFFER-LIST* (APPEND (REMQ SPECIAL-BUFFER *ZMACS-BUFFER-LIST*)
					(LIST SPECIAL-BUFFER))))
    (POINT-PDL-PURGE SPECIAL-BUFFER))
  DIS-TEXT)

))

ZWEI:
(DOLIST (W *ALL-ZMACS-WINDOWS*)
  (LET ((HISTORY (SEND W :BUFFER-HISTORY))
	(LENGTH (LENGTH *ZMACS-BUFFER-LIST*)))
    (SETF (HISTORY-LIST HISTORY) (COPYLIST *ZMACS-BUFFER-LIST*)
	  (HISTORY-LENGTH HISTORY) LENGTH)))


; From file SHEET.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; SHEET  "

(DEFUN UFM (WINDOW)
  (LET* ((OLD-FONT-MAP (SEND WINDOW ':FONT-MAP))
	 (FONT-MAP-FONT-LIST (FONT-MAP-FONT-LIST OLD-FONT-MAP))
	 (CURRENT-FONT (FONT-MAP-CURRENT-FONT-NAME OLD-FONT-MAP)))
    (SETQ FONT-MAP-FONT-LIST
	  (MAPCAR 'UPDATE-FONT FONT-MAP-FONT-LIST))
    (OR CURRENT-FONT (SETQ CURRENT-FONT (SEND WINDOW ':CURRENT-FONT)))
    (SETQ CURRENT-FONT (UPDATE-FONT CURRENT-FONT))
    (SEND WINDOW ':SET-FONT-MAP FONT-MAP-FONT-LIST)
    (SEND WINDOW ':SET-CURRENT-FONT CURRENT-FONT))
  (DOLIST (I (SEND WINDOW ':INFERIORS))
    (UFM I)))

))

; From file SHEET.LISP SRC:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; SHEET  "

(DEFUN UPDATE-FONT-MAPS ()
  "Update all the font maps in the window system.
This is a good thing to call after loading a loading a new version of an old font.
IT makes sure that all windows use the new copy."
  (DOLIST (SCREEN ALL-THE-SCREENS)
    (LET ((INFERIORS (SEND SCREEN ':INFERIORS))
	  (FONT-ALIST (SEND SCREEN ':FONT-ALIST))
	  )
      (DOLIST (TEM FONT-ALIST)
	(SET (CDR TEM) (UPDATE-FONT (SYMEVAL (CDR TEM)))))
      (UFM SCREEN)
      (DOLIST (WINDOW INFERIORS)
	(UFM WINDOW)))))

))

; From file ZMACS.LISP SRC:<L.ZWEI> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZWEI; ZMACS  "

(DEFUN SIMILAR-BUFFER-FILES-WARNING (BUFFER &AUX SAME-NAME SAME-TYPE SAME-EVERYTHING)
  "Warn if any buffer other than BUFFER is visiting the same or a similar file."
  (DOLIST (ELT *ZMACS-BUFFER-NAME-ALIST*)
    (AND (NEQ (CDR ELT) BUFFER)
	 (BUFFER-PATHNAME (CDR ELT))
	 (BUFFER-FILE-ID (CDR ELT))
	 (NOT (NODE-SPECIAL-TYPE (CDR ELT)))
	 (IF (EQUALP (FUNCALL (BUFFER-PATHNAME BUFFER) ':STRING-FOR-EDITOR)
		     (FUNCALL (BUFFER-PATHNAME (CDR ELT)) ':STRING-FOR-EDITOR))
	     (RETURN (SETQ SAME-EVERYTHING (CDR ELT)))
	   (IF (EQUALP (FUNCALL (BUFFER-PATHNAME BUFFER) ':NAME)
		       (FUNCALL (BUFFER-PATHNAME (CDR ELT)) ':NAME))
	       (COND ((EQUALP (FUNCALL (BUFFER-PATHNAME BUFFER) ':TYPE)
			      (FUNCALL (BUFFER-PATHNAME (CDR ELT)) ':TYPE))
		      (SETQ SAME-TYPE (CDR ELT)))
		     (T (SETQ SAME-NAME (CDR ELT))))))))
  (IF SAME-EVERYTHING
      (FORMAT QUERY-IO "~&Warning: Buffer ~A~&is also visiting file ~A."
	      (BUFFER-NAME SAME-EVERYTHING) (BUFFER-PATHNAME SAME-EVERYTHING))
    (LET ((LOSER (OR SAME-TYPE SAME-NAME)))
      (IF LOSER
	  (FORMAT QUERY-IO "~&Note: Another buffer ~A~&is visiting file ~A."
		  (BUFFER-NAME LOSER) (BUFFER-PATHNAME LOSER))))))

))

; From file FLAVOR.LISP SRC:<L.SYS2> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; FLAVOR  "

(DEFUN DEFFLAVOR1 (FLAVOR-NAME INSTANCE-VARIABLES COMPONENT-FLAVORS OPTIONS
		   &AUX FFL ALREADY-EXISTS INSTV IDENTICAL-COMPONENTS
			GETTABLE SETTABLE INITTABLE SPECIAL-IVS
			OLD-SPECIAL-IVS OLD-DEFAULT-HANDLER
			OLD-DEFAULT-INIT-PLIST OLD-LOCAL-IVS OLD-INITTABLE-IVS
			OLD-INIT-KWDS OLD-INSTANCE-AREA-FUNCTION
			OLD-REQUIRED-INIT-KEYWORDS
			INIT-KEYWORDS INCLUDES METH-COMB
			NEW-PLIST (PL (LOCF NEW-PLIST))
			(DEFAULT-CONS-AREA
			  (IF *JUST-COMPILING* DEFAULT-CONS-AREA
			    *FLAVOR-AREA*)))
  (OR *JUST-COMPILING* (RECORD-SOURCE-FILE-NAME FLAVOR-NAME 'DEFFLAVOR))
  (WITHOUT-INTERRUPTS
    (COND ((AND (NOT *JUST-COMPILING*)
		(NOT (MEMQ FLAVOR-NAME *ALL-FLAVOR-NAMES*)))
	   (PUSH FLAVOR-NAME *ALL-FLAVOR-NAMES*)
	   ;; Push on the name without the package prefix.
	   (ARRAY-PUSH-EXTEND *ALL-FLAVOR-NAMES-AARRAY*
			      (CONS (GET-PNAME FLAVOR-NAME) FLAVOR-NAME))
	   ;; Push on the name with the package prefix.
	   (ARRAY-PUSH-EXTEND *ALL-FLAVOR-NAMES-AARRAY*
			      (LET ((PACKAGE NIL))
				(CONS (FORMAT NIL "~S" FLAVOR-NAME) FLAVOR-NAME)))
	   ;; Array is no longer sorted.
	   (STORE-ARRAY-LEADER NIL *ALL-FLAVOR-NAMES-AARRAY* 1))))
  ;; Analyze and error check the instance-variable and component-flavor lists
  (SETQ INSTV (MAPCAR #'(LAMBDA (X) (IF (ATOM X) X (CAR X))) INSTANCE-VARIABLES))
  (DOLIST (IV INSTV)
    (IF (OR (NULL IV) (NOT (SYMBOLP IV)))
	(FERROR NIL "~S, which is not a symbol, was specified as an instance variable" IV)))
  (DOLIST (CF COMPONENT-FLAVORS)
    (IF (OR (NULL CF) (NOT (SYMBOLP CF)))
	(FERROR NIL "~S, which is not a symbol, was specified as a component flavor" CF)))
  ;; Certain properties are inherited from the old property list, while
  ;; others are generated afresh each time from the defflavor-options.
  (COND ((AND (SETQ ALREADY-EXISTS (COMPILATION-FLAVOR FLAVOR-NAME))
	      *USE-OLD-FLAVOR-INFO*)
	 (DOLIST (PROP DEFFLAVOR1-PRESERVED-PROPERTIES)
	   (PUTPROP PL (GET (LOCF (FLAVOR-PLIST ALREADY-EXISTS)) PROP)
		    PROP))))
  ;; First, parse all the defflavor options into local variables so we can see
  ;; whether the flavor is being redefined incompatibly.
  (DO ((L OPTIONS (CDR L))
       (OPTION) (ARGS))
      ((NULL L))
    (IF (ATOM (CAR L))
	(SETQ OPTION (CAR L) ARGS NIL)
	(SETQ OPTION (CAAR L) ARGS (CDAR L)))
    (SELECTQ OPTION
	(:GETTABLE-INSTANCE-VARIABLES
	  (VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (SETQ GETTABLE (UNION GETTABLE (OR ARGS INSTV))))
	(:SETTABLE-INSTANCE-VARIABLES
	  (VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (SETQ SETTABLE (UNION SETTABLE (OR ARGS INSTV))))
	((:INITTABLE-INSTANCE-VARIABLES :INITABLE-INSTANCE-VARIABLES)
	  (VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (SETQ INITTABLE (UNION INITTABLE (OR ARGS INSTV))))
	(:SPECIAL-INSTANCE-VARIABLES
	  (VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (SETQ SPECIAL-IVS (UNION SPECIAL-IVS (OR ARGS INSTV))))
	(:INIT-KEYWORDS
	  (SETQ INIT-KEYWORDS (UNION INIT-KEYWORDS ARGS)))
	(:INCLUDED-FLAVORS
	  (SETQ INCLUDES (UNION INCLUDES ARGS)))
	(:NO-VANILLA-FLAVOR
	  (PUTPROP PL T OPTION))
	(:ORDERED-INSTANCE-VARIABLES
	  ;Don't validate.  User may reasonably want to specify non-local instance
	  ;variables, and any bogus names here will get detected by COMPOSE-FLAVOR-COMBINATION
	  ;(VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (PUTPROP PL (OR ARGS INSTV) ':ORDERED-INSTANCE-VARIABLES))
	(:OUTSIDE-ACCESSIBLE-INSTANCE-VARIABLES
	  (VALIDATE-INSTANCE-VARIABLES-SPEC ARGS INSTV FLAVOR-NAME OPTION)
	  (PUTPROP PL (UNION (GET PL ':OUTSIDE-ACCESSIBLE-INSTANCE-VARIABLES)
			     (OR ARGS INSTV))
		   ':OUTSIDE-ACCESSIBLE-INSTANCE-VARIABLES))
	(:METHOD-COMBINATION
	  (SETQ METH-COMB (NUNION-EQUAL METH-COMB ARGS)))
	(:DEFAULT-HANDLER
	  (PUTPROP PL (CAR ARGS) OPTION))
	((:REQUIRED-INSTANCE-VARIABLES :REQUIRED-METHODS
	  :REQUIRED-FLAVORS :REQUIRED-INIT-KEYWORDS)
	  (PUTPROP PL (UNION ARGS (GET PL OPTION)) OPTION))
	((:DOCUMENTATION :DEFAULT-INIT-PLIST :SELECT-METHOD-ORDER :ACCESSOR-PREFIX)
	  (PUTPROP PL ARGS OPTION))
	(:ALIAS-FLAVOR
	 (PUTPROP PL T ':ALIAS-FLAVOR))
	(:ABSTRACT-FLAVOR
	 (PUTPROP PL T ':ABSTRACT-FLAVOR))
	(:INSTANCE-AREA-FUNCTION
	 (PUTPROP PL (CAR ARGS) ':INSTANCE-AREA-FUNCTION))
	(:INSTANTIATION-FLAVOR-FUNCTION
	 (PUTPROP PL (CAR ARGS) ':INSTANTIATION-FLAVOR-FUNCTION))
	((:RUN-TIME-ALTERNATIVES :MIXTURE)
	 (PUTPROP PL ARGS ':RUN-TIME-ALTERNATIVES)
	 (PUTPROP PL 'CHOOSE-RUN-TIME-ALTERNATIVE ':INSTANTIATION-FLAVOR-FUNCTION)
	 (PUTPROP PL (MAKE-RUN-TIME-ALTERNATIVE-ALIST FLAVOR-NAME ARGS)
		  'RUN-TIME-ALTERNATIVE-ALIST))
	(OTHERWISE (FERROR NIL "~S is not a known DEFFLAVOR option." OPTION))))
  ;; All settable instance variables should also be gettable and inittable.
  (DOLIST (V SETTABLE)
    (OR (MEMQ V GETTABLE)
	(PUSH V GETTABLE))
    (OR (MEMQ V INITTABLE)
	(PUSH V INITTABLE)))
  ;; See whether there are any changes in component flavor structure from last time
  (SETQ IDENTICAL-COMPONENTS
	(AND ALREADY-EXISTS
	     *USE-OLD-FLAVOR-INFO*
	     (EQUAL COMPONENT-FLAVORS (FLAVOR-DEPENDS-ON ALREADY-EXISTS))
	     (EQUAL INCLUDES (FLAVOR-INCLUDES ALREADY-EXISTS))
	     (EQUAL (GET PL ':REQUIRED-FLAVORS)
		    (GET (LOCF (FLAVOR-PLIST ALREADY-EXISTS)) ':REQUIRED-FLAVORS))))	
  (AND ALREADY-EXISTS
       (SETQ OLD-SPECIAL-IVS (FLAVOR-SPECIAL-INSTANCE-VARIABLES ALREADY-EXISTS)
	     OLD-DEFAULT-HANDLER (GET (LOCF (FLAVOR-PLIST ALREADY-EXISTS))
				      ':DEFAULT-HANDLER)
	     OLD-DEFAULT-INIT-PLIST (GET (LOCF (FLAVOR-PLIST ALREADY-EXISTS))
					 ':DEFAULT-INIT-PLIST)
	     OLD-LOCAL-IVS (FLAVOR-LOCAL-INSTANCE-VARIABLES ALREADY-EXISTS)
	     OLD-INITTABLE-IVS (FLAVOR-INITTABLE-INSTANCE-VARIABLES ALREADY-EXISTS)
	     OLD-INSTANCE-AREA-FUNCTION (FLAVOR-GET ALREADY-EXISTS ':INSTANCE-AREA-FUNCTION)
	     OLD-REQUIRED-INIT-KEYWORDS (FLAVOR-GET ALREADY-EXISTS ':REQUIRED-INIT-KEYWORDS)
	     OLD-INIT-KWDS (FLAVOR-INIT-KEYWORDS ALREADY-EXISTS)))
  ;; If the flavor is being redefined, and the number or order of instance variables
  ;; is being changed, and this flavor or any that depends on it
  ;; has a select-method table (i.e. has probably been instantiated), give a warning
  ;; and disconnect from the old FLAVOR defstruct so that old instances will
  ;; retain the old information.  The instance variables can get changed either
  ;; locally or by rearrangement of the component flavors.
  (AND ALREADY-EXISTS
       (IF (AND *USE-OLD-FLAVOR-INFO*
		(EQUAL (GET PL ':ORDERED-INSTANCE-VARIABLES)
		       (GET (LOCF (FLAVOR-PLIST ALREADY-EXISTS))
			    ':ORDERED-INSTANCE-VARIABLES))
		(OR (EQUAL (FLAVOR-LOCAL-INSTANCE-VARIABLES ALREADY-EXISTS)
			   INSTANCE-VARIABLES)
		    (EQUAL (MAPCAR #'(LAMBDA (X) (IF (ATOM X) X (CAR X)))
				   (FLAVOR-LOCAL-INSTANCE-VARIABLES ALREADY-EXISTS))
			   INSTV))
		(EQ (GET PL ':ALIAS-FLAVOR)
		    (FLAVOR-GET ALREADY-EXISTS ':ALIAS-FLAVOR))
		(OR IDENTICAL-COMPONENTS
		    (EQUAL (FLAVOR-RELEVANT-COMPONENTS ALREADY-EXISTS
						       COMPONENT-FLAVORS INCLUDES)
			   (FLAVOR-RELEVANT-COMPONENTS ALREADY-EXISTS
						       (FLAVOR-DEPENDS-ON ALREADY-EXISTS)
						       (FLAVOR-INCLUDES ALREADY-EXISTS)))))
	   (IF *JUST-COMPILING*
	       (SETQ ALREADY-EXISTS (FLAVOR-REDEFINITION-FOR-COMPILATION ALREADY-EXISTS NIL)))
	 (IF *JUST-COMPILING*
	     (SETQ ALREADY-EXISTS (FLAVOR-REDEFINITION-FOR-COMPILATION ALREADY-EXISTS T))
	   (SETQ ALREADY-EXISTS (PERFORM-FLAVOR-REDEFINITION FLAVOR-NAME)))))
  (WHEN (GET PL ':ALIAS-FLAVOR)
    (IF (CDR COMPONENT-FLAVORS)
	(FLAVOR-WARN FLAVOR-NAME 'ALIAS-FLAVOR-MULTIPLE-COMPONENTS ':IMPOSSIBLE
		     "This alias flavor has more than one component."))
    (UNLESS COMPONENT-FLAVORS
      (FLAVOR-WARN FLAVOR-NAME 'ALIAS-FLAVOR-MULTIPLE-COMPONENTS ':IMPOSSIBLE
		   "This alias flavor has no component to be the alias of."))
    (IF INSTANCE-VARIABLES
	(FLAVOR-WARN FLAVOR-NAME 'ALIAS-FLAVOR-MULTIPLE-COMPONENTS ':IMPOSSIBLE
		     "This alias flavor has instance variables; they will be ignored.")))
  ;; Make the information structure unless the flavor already exists.
  (LET ((FL (OR ALREADY-EXISTS
		(AND (NOT *JUST-COMPILING*)
		     (GET FLAVOR-NAME 'UNDEFINED-FLAVOR))
		(MAKE-FLAVOR FLAVOR-NAME FLAVOR-NAME))))
    (SETF (FLAVOR-PACKAGE FL) PACKAGE)
    (SETF (FLAVOR-LOCAL-INSTANCE-VARIABLES FL) INSTANCE-VARIABLES)
    (SETF (FLAVOR-DEPENDS-ON FL) COMPONENT-FLAVORS)
    (LET ((OVEC (FLAVOR-COMPONENT-MAPPING-TABLE-VECTOR FL)))
      (SETF (FLAVOR-PLIST FL) NEW-PLIST)
      (IF OVEC (SETF (FLAVOR-COMPONENT-MAPPING-TABLE-VECTOR FL) OVEC)))
    (IF GETTABLE
	(SETF (FLAVOR-GETTABLE-INSTANCE-VARIABLES FL) GETTABLE))
    (IF SETTABLE
	(SETF (FLAVOR-SETTABLE-INSTANCE-VARIABLES FL) SETTABLE))
    (IF SPECIAL-IVS
	(SETF (FLAVOR-SPECIAL-INSTANCE-VARIABLES FL) SPECIAL-IVS))
    (SETF (FLAVOR-INITTABLE-INSTANCE-VARIABLES FL)
	  (LOOP FOR V IN INITTABLE COLLECT (CONS (CORRESPONDING-KEYWORD V) V)))
    (SETF (FLAVOR-INIT-KEYWORDS FL) INIT-KEYWORDS)
    (SETF (FLAVOR-INCLUDES FL) INCLUDES)
    ;; This can't be computed for real until flavor composition,
    ;; but this at least contains some of the right ones.
    (SETF (FLAVOR-UNMAPPED-INSTANCE-VARIABLES FL)
	  (FLAVOR-KNOWN-UNMAPPED-INSTANCE-VARIABLES FL))
    ;; First remove old method-combination declarations, then add new ones
    (DOLIST (MTE (FLAVOR-METHOD-TABLE FL))
      (COND ((LOOP FOR DECL IN METH-COMB NEVER (MEMQ (CAR MTE) (CDDR DECL)))
	     (SETF (SECOND MTE) NIL)
	     (SETF (THIRD MTE) NIL))))
    (DOLIST (DECL METH-COMB)
      (LET ((TYPE (CAR DECL)) (ORDER (CADR DECL)) ELEM)
	;; Don't error-check TYPE now, its definition might not be loaded yet
	(DOLIST (MSG (CDDR DECL))
	  (OR (SETQ ELEM (ASSQ MSG (FLAVOR-METHOD-TABLE FL)))
	      (PUSH (SETQ ELEM (LIST* MSG NIL NIL NIL)) (FLAVOR-METHOD-TABLE FL)))
	  (SETF (SECOND ELEM) TYPE)
	  (SETF (THIRD ELEM) ORDER))))
    (IF *JUST-COMPILING*
	(COMPILATION-DEFINE-FLAVOR FLAVOR-NAME FL)
      ;; Make this a depended-on-by of its depends-on, or remember to do it later in
      ;; the case of depends-on's not yet defined.
      (DOLIST (COMPONENT-FLAVOR COMPONENT-FLAVORS)
	(WITHOUT-INTERRUPTS
	  (COND ((SETQ FFL (GET COMPONENT-FLAVOR 'FLAVOR))
		 (OR (MEMQ FLAVOR-NAME (FLAVOR-DEPENDED-ON-BY FFL))
		     (PUSH FLAVOR-NAME (FLAVOR-DEPENDED-ON-BY FFL))))
		(T (PUSH (CONS COMPONENT-FLAVOR FLAVOR-NAME)
			 *FLAVOR-PENDING-DEPENDS*)))))
      ;; Likewise for its includes
      (DOLIST (INCLUDED-FLAVOR (FLAVOR-INCLUDES FL))
	(WITHOUT-INTERRUPTS
	  (COND ((SETQ FFL (GET INCLUDED-FLAVOR 'FLAVOR))
		 (OR (MEMQ FLAVOR-NAME (FLAVOR-DEPENDED-ON-BY FFL))
		     (PUSH FLAVOR-NAME (FLAVOR-DEPENDED-ON-BY FFL))))
		(T (PUSH (CONS INCLUDED-FLAVOR FLAVOR-NAME)
			 *FLAVOR-PENDING-DEPENDS*)))))
      ;; If someone depends on this flavor, which wasn't defined until now, link them up.
      ;; If that flavor was flavor-composed, recompose it now.
      (WITHOUT-INTERRUPTS
	(DOLIST (X *FLAVOR-PENDING-DEPENDS*)
	  (COND ((EQ (CAR X) FLAVOR-NAME)
		 (OR (MEMQ (CDR X) (FLAVOR-DEPENDED-ON-BY FL))
		     (PUSH (CDR X) (FLAVOR-DEPENDED-ON-BY FL)))
		 (SETQ *FLAVOR-PENDING-DEPENDS*
		       (DELQ X *FLAVOR-PENDING-DEPENDS*))))))
      (PUTPROP FLAVOR-NAME FL 'FLAVOR)
      (REMPROP FLAVOR-NAME 'UNDEFINED-FLAVOR)
      ;; Now, if the flavor was redefined in a way that changes the methods but doesn't
      ;; invalidate old instances, we have to propagate some changes.
      (IF (AND ALREADY-EXISTS
	       (NOT IDENTICAL-COMPONENTS))
	  (PERFORM-FLAVOR-METHOD-ONLY-REDEFINITION FLAVOR-NAME)
	;; If the methods and instances are ok but other things have changed, notice that too.
	(OR (AND (EQUAL OLD-SPECIAL-IVS
			(FLAVOR-SPECIAL-INSTANCE-VARIABLES FL))
		 (EQUAL OLD-DEFAULT-INIT-PLIST
			(GET (LOCF (FLAVOR-PLIST FL))
			     ':DEFAULT-INIT-PLIST))
		 (EQUAL OLD-LOCAL-IVS
			(FLAVOR-LOCAL-INSTANCE-VARIABLES FL))
		 ;; Get a warning every time, if there is a variable
		 ;; that is globally special but not in a :SPECIAL-INSTANCE-VARIABLES
		 (NOT (DOLIST (IV (FLAVOR-LOCAL-INSTANCE-VARIABLES FL))
			;; Elements can be lists (var init)
			(IF (CONSP IV) (SETQ IV (CAR IV)))
			(AND (GET IV 'SPECIAL)
			     (NOT (MEMQ IV (FLAVOR-SPECIAL-INSTANCE-VARIABLES FL)))
			     (RETURN T))))
		 (EQUAL OLD-INITTABLE-IVS
			(FLAVOR-INITTABLE-INSTANCE-VARIABLES FL))
		 (EQUAL OLD-DEFAULT-HANDLER (GET (LOCF (FLAVOR-PLIST FL)) ':DEFAULT-HANDLER))
		 (EQUAL OLD-INSTANCE-AREA-FUNCTION (FLAVOR-GET FL ':INSTANCE-AREA-FUNCTION))
		 (EQUAL OLD-REQUIRED-INIT-KEYWORDS (FLAVOR-GET FL ':REQUIRED-INIT-KEYWORDS))
		 (EQUAL OLD-INIT-KWDS (FLAVOR-INIT-KEYWORDS FL)))
	    (PERFORM-FLAVOR-BINDINGS-REDEFINITION FLAVOR-NAME))))
    (FLAVOR-HACK-DOCUMENTATION FLAVOR-NAME)
    FLAVOR-NAME))

))

; From file FLAVOR.LISP SRC:<L.SYS2> OZ:
#8R SYSTEM-INTERNALS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "SYSTEM-INTERNALS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: SYS2; FLAVOR  "

(DEFUN FLAVOR-HACK-DOCUMENTATION (FLAVOR-NAME)
  (LET* ((DOC (GET (LOCF (FLAVOR-PLIST (GET FLAVOR-NAME 'FLAVOR))) ':DOCUMENTATION))
	 (STRINGS NIL) FOO)
    (IF DOC
	(PROGN
	  (DOLIST (TEM DOC)
	    (AND (STRINGP TEM)
		 (SETQ STRINGS (NCONC STRINGS (NCONS TEM)))))
	  (DOLIST (TEM DOC)
	    (UNLESS (STRINGP TEM)
	      (SETQ STRINGS (NCONC STRINGS (LIST* (IF (AND STRINGS (NOT FOO)) #\RETURN "")
						  (IF FOO "" (SETQ FOO "A "))
						  TEM #\SPACE NIL)))))
	  (IF FOO (NCONC STRINGS (LIST "Flavor.")))
	  (SETF (DOCUMENTATION FLAVOR-NAME 'DEFFLAVOR) (APPLY 'STRING-APPEND STRINGS)))
      (IF (DOCUMENTATION FLAVOR-NAME 'DEFFLAVOR)
	  (SETF (DOCUMENTATION FLAVOR-NAME 'DEFFLAVOR) NIL)))))

))
