;;;-*- Mode:LISP; Package:SYSTEM-INTERNALS; Base:8 -*-
;;; Site declaration for MIT
;;; ** (c) Copyright 1981 Massachusetts Institute of Technology **

(DEFCONST OZ-SYS-PATHNAME-TRANSLATIONS
  ;; this pos not used in 99. (fs:make-logical-pathname-host "SYS")
  '(("CC" "KANSAS:<L.CC>")
    ("CHAOS" "KANSAS:<L.CHAOS>")
    ("COLD" "KANSAS:<L.COLD>")
    ("DEMO" "KANSAS:<L.DEMO>")
    ("DISTRIBUTION" "KANSAS:<L.DISTRIBUTION>")
    ("DOC" "KANSAS:<L.DOC>")
    ("FILE" "KANSAS:<L.FILE>")
    ("FILE2" "KANSAS:<L.FILE2>")
    ("FONTS" "KANSAS:<L.FONTS>")
    ("IO" "KANSAS:<L.IO>")
    ("IO1" "KANSAS:<L.IO1>")
    ("IP" "KANSAS:<L.NETWORK.IP>")
    ("ISPELL" "KANSAS:<L.ISPELL>")
    ("LAMBDA-DIAG" "KANSAS:<L.LAMBDA-DIAG>")
    ("LAMBDA-UCODE" "KANSAS:<L.LAMBDA-UCODE>")
    ("LIB" "KANSAS:<L.LIB>")
    ("MAN" "KANSAS:<L.MAN>")
    ("NETWORK" "KANSAS:<L.NETWORK>")
    ("CHNCP" "KANSAS:<L.NETWORK.CHAOS>")	; Prefer NETWORK;CHAOS; for back-translation
    ("PATCH" "KANSAS:<L.PATCH>")
    ("PRESS-FONTS" "KANSAS:<FONTS>")
    ("SITE" "OZ:<L.SITE>")			; Keep it this way to make caches happy
    ("SYS" "KANSAS:<L.SYS>")
    ("SYS2" "KANSAS:<L.SYS2>")
    ("TAPE" "KANSAS:<L.TAPE>")
    ("UBIN" "KANSAS:<L.UBIN>")
    ("UCADR" "KANSAS:<L.UCADR>")
    ("WINDOW" "KANSAS:<L.WINDOW>")
    ("WIND" "KANSAS:<L.WIND>")
    ("ZMAIL" "KANSAS:<L.ZMAIL>")
    ("ZWEI" "KANSAS:<L.ZWEI>")
    ))

(DEFCONST FC-SYS-PATHNAME-TRANSLATIONS
  '(("CC;" "L\CC;")
    ("CHAOS;" "L\CHAOS;")
    ("DEMO;" "L\DEMO;")
    ("DISTRIBUTION;" "L\DISTRIBUTION;")
    ("DOC;" "L\DOC;")
    ("FILE;" "L\FILE;")
    ("FILE2;" "L\FILE2;")
    ("FONTS;" "L\FONTS;")
    ("IO;" "L\IO;")
    ("IO;FILE;" "L\IO\FILE;")
    ("IO1;" "L\IO1;")
    ("IP;" "L\NETWORK\IP;")
    ("ISPELL;" "L\ISPELL;")
    ("LAMBDA-DIAG;" "L\LAMBDA-DIAG;")
    ("LAMBDA-UCODE;" "L\LAMBDA-UCODE;")
    ("LIB;" "L\LIB;")
    ("MAN;" "L\MAN;")
    ("NETWORK;" "L\NETWORK;")
    ("NETWORK;CHAOS;" "L\NETWORK\CHAOS;")
    ("CHNCP;" "L\NETWORK\CHAOS;")
    ("PATCH;" "L\PATCH;")
    ("PRESS-FONTS;" "L\PRESS-FONTS;")
    ("SITE;" "L\SITE;")
    ("SYS;" "L\SYS;")
    ("SYS2;" "L\SYS2;")
    ("TAPE;" "L\TAPE;")
    ("UBIN;" "L\UBIN;")
    ("UCADR;" "L\UCADR;")
    ("WINDOW;" "L\WINDOW;")
    ("WIND;" "L\WIND;")
    ("ZMAIL;" "L\ZMAIL;")
    ("ZWEI;" "L\ZWEI;")
    ))

(DEFCONST LM-SYS-PATHNAME-TRANSLATIONS
  '(("CC" "CC;")
    ("CHAOS" "CHAOS;")
    ("COMMON-LISP" "COMMON-LISP;")
    ("DEMO" "DEMO;")
    ("ETHER" "ETHER;")
    ("FILE" "FILE;")
    ("FILE2" "FILE2;")
    ("FONTS" "FONTS;")
    ("IO" "IO;")
    ("IO1" "IO1;")
    ("LIB" "LIB;")
    ("NET" "NET;")
    ("PATCH-GED" "PATCH.GED;")
    ("PATCH-FORMATTER" "PATCH.FORMATTER;")
    ("PATCH-GWIN" "PATCH.GWIN;")
    ("PATCH-GLOSSARY" "PATCH.GLOSSARY;")
    ("PATCH-GRASPER" "PATCH.GRASPER;")
    ("PATCH-LOCAL-FILE" "PATCH.LOCAL-FILE;")
    ("PATCH-NLMENU" "PATCH.NLMENU;")
    ("PATCH-NLMENU-INT" "PATCH.NLMENU-INT;")
    ("PATCH-NLMENU-RTMS-INTERFACE" "PATCH.NLMENU-RTMS-INTERFACE;")
    ("PATCH-NU-TAPE" "PATCH.NU-TAPE;")
    ("PATCH-PRINTER" "PATCH.PRINTER;")
    ("PATCH-RTMS" "PATCH.RTMS;")
    ("PATCH-SERVER" "PATCH.SERVER;")
    ("PATCH-SUGGESTIONS" "PATCH.SUGGESTIONS;")
    ("PATCH-TREE-EDITOR" "PATCH.TREE-EDITOR;")
    ("PATCH-UCL" "PATCH.UCL;")
    ("PATCH-UCL-INT" "PATCH.UCL-INT;")
    ("PATCH-UCL-UTILITIES" "PATCH.UCL-UTILITIES;")
    ("PATCH" "PATCH;")
    ("PRINTER" "PRINTER;")
    ("SITE" "SITE;")
    ("SYS" "SYS;")
    ("SYS2" "SYS2;")
    ("TAPE" "TAPE;")
    ("TEST" "TEST;")
    ("TI-CADR" "TI-CADR;")
    ("UBIN" "UBIN;")
    ("UCADR" "UCADR;")
    ("WINDOW" "WINDOW;")
    ("ZMAIL" "ZMAIL;")
    ("ZWEI" "ZWEI;")
;;CM stuff
    ("CM" "CM;")
    ("CM-LOGGING" "CM-LOGGING;")
    ("DRIBBLE" "DRIBBLE;")
    ("AUSTIN" "AUSTIN;")
    ("BUG" "AUSTIN-BUG;")
;;ENTICE Stuff
    ("GED" "GED;")
    ("SUGGESTIONS" "SUGGESTIONS;")
    ("NLMENU" "NLMENU;")
    ("NLMENU-INT" "NLMENU-INT;")
    ("NLMENU-RTMS-INTERFACE" "NLMENU-RTMS-INTERFACE;")
    ("GWIN" "GWIN;")
    ("GLOSSARY" "GLOSSARY;")
    ("GRASPER" "GRASPER;")
    ("SYS-FIX" "SYS-FIX;")
    ("RTMS" "RTMS;")
    ("TREE" "TREE;")
    ("TREE-EDITOR" "TREE-EDITOR;")
    ("UCL" "UCL;")
    ("UCL-INT" "UCL-INT;")
    ("UCL-UTILITIES" "UCL-UTILITIES;")
    ("ZMACS-UCL" "ZMACS-UCL;")
;;Austin products
    ("AFT" "AFT;")
    ("DIAG" "DIAG;")
    ("FORMATTER" "FORMATTER;")
    ("FORMATTER-DB" "FORMATTER-DB;")
    ("MICROCODE" "MICROCODE;")
    ("NU-TAPE" "NU-TAPE;")
    ("SERIAL" "SDU-SERIAL;")
    ("TOOLS" "TOOLS;")
    ("TI-EXAMPLES" "TI-EXAMPLES;")
    ("XNS" "XNS;")
    ))

(DEFSITE :MIT
  ;; OZ is where the sources are
  (:SYS-HOST "OZ")
  ;; SYS: translations to use
  (:SYS-HOST-TRANSLATION-ALIST '(("FC" . FC-SYS-PATHNAME-TRANSLATIONS)
				 ("OZ" . OZ-SYS-PATHNAME-TRANSLATIONS)
				 ("FS" . LM-SYS-PATHNAME-TRANSLATIONS)
				 ("LM" . LM-SYS-PATHNAME-TRANSLATIONS)
				 ("FL" . LM-SYS-PATHNAME-TRANSLATIONS)
				 ("SRC" . LM-SYS-PATHNAME-TRANSLATIONS)
				 (NIL . LM-SYS-PATHNAME-TRANSLATIONS)))
  ;; These two say how to log in to get error tables, etc.
  (:SYS-LOGIN-NAME "LISPM")
  (:SYS-LOGIN-PASSWORD "LISPM")
  ;; Our site-specific system
  (:SITE-SPECIFIC-SYSTEM "MIT-Specific")
  ;; For internet domain addressing, these domains
  ;; are those which the local site belongs to.
  (:LOCAL-INTERNET-DOMAINS '("ARPA"))
; No longer relevant as of system 99.
;  ;; Has a local chaosnet
;  (:CHAOS "MIT")
;  ;; But no (working) ethernet
;  (:ETHER NIL)
  ;; Internet can be reached with Chaos
  (:INTERNET '(("128.31.0.0" :CHAOS "MIT")))
  (:INTERNET-HOST-TABLE "MC: SYSNET; HSTNIC >")
  ;; File computers to go on FS:*PATHNAME-HOST-LIST*.
  ;; The correct name for this site option is :FILE-SERVER-HOSTS as of system 99,
  ;; but the old name is still accepted, and is used here for the sake of earler systems.
  ;; Note that machines not in HSTTBL but known by host table servers
  ;; work EXCEPT when building a new system.
  (:FILE-SERVER-HOSTS '("OZ" "MC"))
  (:CHAOS-FILE-SERVER-HOSTS '("MC" "XX" "OZ" "SPEECH" "EE" "VX" "MATH" "ML"
			      "ALCVAX" "HT" "EDDIE"  "CCC" "CIPG" "DSPG"
			      "VULCAN" "CORWIN" "HTJR" "OBERON" "PFCVAX" "JCF"
			      ;"MIT-MULTICS" Off chaosnet
			      "COGS" "FS" "HOG" "MARIE" "CEZANNE" "DEGAS"
			      "EMS" "HAYDN" "CHARON"
			      "PREP" "PYGMALION" "TALOS" "HEPHAESTUS" "WAIF"
			      ;; What's NU with you ?
			      "NU0" "NU1" "NU2" "NU3" "NU4" "NU5" "NU6" "NU7" "NU8" "NU9"
			      "NU10" "NU11" "NU12" "NU13" "NU14" "NU15" "NU16" "NU17"
			      "SCRC-TENEX" ; not in HSTTBL: "SCRC-COMET" "SCRC-VIXEN"
			      ;; Lisp machines running LMFS -- at MIT
			      ("AP1" :LMFS) ("AP2" :LMFS) ("AP3" :LMFS) ("AP4" :LMFS)
			      ("PI" :LMFS) ("RB2" :LMFS)
			      ("LM15" :LMFS) ("LM18" :LMFS) ("LM23" :LMFS)
			      ("AP5" :LMFS) ("AP6" :LMFS)
			      ("ELVIS" :LMFS) ("JIMI" :LMFS) ("BUDDY" :LMFS) ("JANIS" :LMFS)
			      ("OAK" :LMFS)
			      ;; -- at Symbolics
			      ("POINTER" :LMFS) ; ("NIMBUS" :LMFS) ("HUEY" :LMFS)
			      ("QUABBIN" :LMFS)
			      ;; -- New Exporers
			      "G-COOPER"))
  (:SPECIAL-FILE-HOSTS '((:LMFS ;; Lisp machines running LMFS -- at MIT
			   "AP3" "AP4" "AP5" "AP6" "AP7" "AP8" "RB1" "RB2" "RB3" "RB4" "PI"
			   "LM15" "LM18" "LM23" "ELVIS" "JIMI"
                           "BUDDY" "JANIS" "OAK" "CROSBY"
			   ;; -- at Symbolics
			   "POINTER" "NIMBUS" "HUEY" "QUABBIN" "RIVERSIDE")))
  ;; Machines running LMFILE that remote hosts should be made for.
  ;; The name here is the name the host will get.
  (:LMFILE-SERVER-HOSTS '("FC"))
  ;; Hosts suspected of supporting time servers
  (:CHAOS-TIME-SERVER-HOSTS '("MC" "OZ" "BYPASS" "PLASMA" "PFCV80" "TOTO" "CHATTER"
			      "LM27" "XX" "EE" "VX" "SCRC" "ALCVAX" "HT" "CCC"))
  ;; Hosts that know about hosts off the chaosnet
  (:CHAOS-HOST-TABLE-SERVER-HOSTS '("MC" "OZ" "XX" "EE" "SCRC-TENEX")) ; "ML"
  ;; Hosts that have mail servers capable of forwarding mail anyplace
  (:CHAOS-MAIL-SERVER-HOSTS '("MC" "XX" "OZ" "EE" "VX")) ; "ML"
  ;; Hosts that will receive mail via the SMTP protocol
  (:CHAOS-SMTP-SERVER-HOSTS '("MC"))
  ;; Hosts that accept mail via the :COMSAT method of sending.
  (:FILE-MAIL-SERVER-HOSTS '("MC" "ML"))
  ;; Hosts that have SPELL servers.
  (:SPELL-SERVER-HOSTS '("OZ" "XX"))
  ;; Prepare for DEC's Brave New World -- per-host default devices
  (:HOST-DEFAULT-DEVICE-ALIST '(("OZ" . "OZ")))
  ;; Access another host's tape drive
  (:DEFAULT-REMOTE-TAPE-PROTOCOL :MAGTAPE)
  ;; Our LISPM host names usually start out as CADR-
  (:USUAL-LM-NAME-PREFIX "CADR-")
  ;; EST
  (:TIMEZONE 5)
  ;; Destination for mail to BUG-FOOBAR
  (:HOST-FOR-BUG-REPORTS "MIT-OZ")
  ;; "Local sites", used by ZMail summary display
  (:LOCAL-MAIL-HOSTS '("MC" "OZ" "ML"))
  ;; Mail can be sent by COMSAT
  (:COMSAT T)
  ;; But that is not the default
  (:DEFAULT-MAIL-MODE ':CHAOS)
  ;; There is a GMSGS server for collecting system messages
  (:GMSGS T)
  ;; Actually, goes to the Internet
  (:ARPA-GATEWAYS '("MC" "ML"))
  ;; Has a Dover
  (:DOVER T)
  ;; It is the default printer.
  (:DEFAULT-PRINTER ':DOVER)
  (:DEFAULT-BIT-ARRAY-PRINTER '(:XGP "MC:.GLPR.;TS7SCN"))
  ;; Interpretation of arguments to ESC F
  (:ESC-F-ARG-ALIST '((NIL . :LOGIN) (1 . :LISP-MACHINES)
		      (2 "OZ") (3 "MC") (4 "EE") (5 "VX") (6 "XX") (7 "SCRC-TENEX")
		      (8 . :ALL-LISP-MACHINES) (9 "PIG" "PREP") (10. "CORWIN" "OBERON")
		      (0 . :READ)))

  (:NON-CHAOS-HOST-TABLE-FILE "SYS: SITE; EXTRA HOSTS")

  ;for common lisp compatibility


  ;;We are an MIT Lisp Machine.  This option obsolete as of system 98, though.
  (:DEFAULT-MACHINE-TYPE "MIT-CADR")
  (:LM-SERVER-HOSTS '(("SRC" "BAMBI") ("FL" "BAMBI")))
  ;;This is what Steele says we are
  (:SHORT-SITE-NAME "MIT AI Lab")

  ;;This was as long as I could make it.
  (:LONG-SITE-NAME "Massachusetts Institute of Technology, Artificial Intelligence Laboratory")

  ;; Let's see if we can get the Explorer up!
  (:Ether-Subnet #o32)
  (:serial-subnet 3)
  (:chaos-subnet 1)
  )

