;;; -*- Mode: Lisp; Package: FILE-SYSTEM; Base: 8.; Patch-File: T -*-
;;; Patch file for MagTape version 22.3
;;; Reason: :ONLY-LATEST arg to COPY-DIRECTORY uses :NEWEST :VERSION
;;; Written 1/07/84 18:40:27 by LMFile,
;;; while running on Lisp Machine Filecomputer from band 4
;;; with System 98.26, CADR 3.4, ZMail 53.9, MIT-Specific 22.0, Experimental Local-File 48.1, Experimental FILE-Server 8.2, Experimental LFS 3.1, Experimental MagTape 22.2, microcode 306, Xmntl FS.



; From file COPY.LISP PS:<L.TAPE> OZ:
#8R FILE-SYSTEM#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "FILE-SYSTEM")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: TAPE; COPY  "

(DEFUN COPY-DIRECTORY (DIR TO
		       &OPTIONAL &REST OPTIONS
		       &KEY
		       COPY-ONLY
		       SELECTIVE
		       (RECOPY-FILE-ON-EOT T)
		       (ONLY-LATEST NIL)
		       (SINCE NIL)
		       &ALLOW-OTHER-KEYS
		       &AUX WHOLE-DIR-LIST OUTPUT-DIR-LIST ODIR TAPE-DUMP)
  (SETQ DIR (PARSE-PATHNAME DIR))
  (SETQ DIR (FUNCALL DIR ':NEW-PATHNAME
		     ':NAME (IF (MEMQ (FUNCALL DIR ':NAME) '(NIL :UNSPECIFIC))
				':WILD
				(FUNCALL DIR ':NAME))
		     ':TYPE (IF (MEMQ (FUNCALL DIR ':TYPE) '(NIL :UNSPECIFIC))
				':WILD
				(FUNCALL DIR ':TYPE))
		     ':VERSION (IF ONLY-LATEST ':NEWEST
				 (IF (MEMQ (FUNCALL DIR ':VERSION) '(NIL :UNSPECIFIC))
				     ':WILD
				   (FUNCALL DIR ':VERSION)))))
  (SETQ ODIR (PARSE-PATHNAME TO))
  (COND ((TYPEP ODIR 'PATHNAME)
	 (SETQ ODIR (FUNCALL ODIR ':NEW-PATHNAME
		      ':NAME (IF (MEMQ (FUNCALL ODIR ':NAME) '(NIL :UNSPECIFIC))
				 ':WILD
			       (FUNCALL ODIR ':NAME))
		      ':TYPE (IF (MEMQ (FUNCALL ODIR ':TYPE) '(NIL :UNSPECIFIC))
				 ':WILD
			       (FUNCALL ODIR ':TYPE))
		      ':VERSION (IF (MEMQ (FUNCALL ODIR ':VERSION) '(NIL :UNSPECIFIC :NEWEST))
				    ':WILD
				  (FUNCALL ODIR ':VERSION)))))
	((TYPEP ODIR 'MT-FILEHANDLE)
	 (SETQ TAPE-DUMP T)))
  (SETQ WHOLE-DIR-LIST (DIRECTORY-LIST DIR))
  (COND ((TYPEP ODIR 'PATHNAME)
	 (ERRSET (SETQ OUTPUT-DIR-LIST (DIRECTORY-LIST ODIR))
		 NIL)))
  (DOLIST (F (IF SINCE (ELIMINATE-DATED-FILES (TIME:PARSE-UNIVERSAL-TIME SINCE)
					      WHOLE-DIR-LIST) WHOLE-DIR-LIST))
    (AND (CAR F)
	 (NOT (GET F ':LINK-TO))
	 (OR (NOT SELECTIVE)
	     (PROGN (FORMAT QUERY-IO "Copy ~A ?" (CAR F))
		    (Y-OR-N-P)))
	 (OR (NULL COPY-ONLY)
	     (CHECK-COPY-ONLY (CAR F) COPY-ONLY WHOLE-DIR-LIST))
	 (PROGV (IF RECOPY-FILE-ON-EOT '(*MT-EOT-HANDLER*) NIL)
		'(COPY-EOT-HANDLER)
	   (DO ((V) (EOT))
	       (())
	     (MULTIPLE-VALUE (V EOT)
	       (*CATCH (IF RECOPY-FILE-ON-EOT ':EOT ':NEVER)
		 (LEXPR-FUNCALL #'FS-COPY-FILE (CAR F) TO ':DIRECTORY-LIST (CDR F)
				':OUTPUT-DIRECTORY-LIST OUTPUT-DIR-LIST OPTIONS)))
	     (IF (NULL EOT)
		 (RETURN)
		 (COPY-MOUNT-NEXT-TAPE TAPE-DUMP)))))))

))
